/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import org.freedesktop.DBus;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.CallbackHandler;
import org.freedesktop.dbus.DBusAsyncReply;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusInterfaceName;
import org.freedesktop.dbus.DBusMemberName;
import org.freedesktop.dbus.Error;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.Message;
import org.freedesktop.dbus.MethodCall;
import org.freedesktop.dbus.RemoteObject;
import org.freedesktop.dbus.Tuple;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.exceptions.NotConnected;

class RemoteInvocationHandler
implements InvocationHandler {
    public static final int CALL_TYPE_SYNC = 0;
    public static final int CALL_TYPE_ASYNC = 1;
    public static final int CALL_TYPE_CALLBACK = 2;
    AbstractConnection conn;
    RemoteObject remote;

    public static Object convertRV(String string, Object[] objectArray, Method method, AbstractConnection abstractConnection) throws DBusException {
        Class<?> clazz = method.getReturnType();
        if (null == objectArray) {
            if (null == clazz || Void.TYPE.equals(clazz)) {
                return null;
            }
            throw new DBusExecutionException(Gettext._("Wrong return type (got void, expected a value)"));
        }
        try {
            objectArray = Marshalling.deSerializeParameters(objectArray, new Type[]{method.getGenericReturnType()}, abstractConnection);
        }
        catch (Exception exception) {
            if (AbstractConnection.EXCEPTION_DEBUG) {
                // empty if block
            }
            throw new DBusExecutionException(MessageFormat.format(Gettext._("Wrong return type (failed to de-serialize correct types: {0} )"), exception.getMessage()));
        }
        switch (objectArray.length) {
            case 0: {
                if (null == clazz || Void.TYPE.equals(clazz)) {
                    return null;
                }
                throw new DBusExecutionException(Gettext._("Wrong return type (got void, expected a value)"));
            }
            case 1: {
                return objectArray[0];
            }
        }
        if (!Tuple.class.isAssignableFrom(clazz)) {
            throw new DBusExecutionException(Gettext._("Wrong return type (not expecting Tuple)"));
        }
        Constructor<?> constructor = clazz.getConstructors()[0];
        try {
            return constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            if (AbstractConnection.EXCEPTION_DEBUG) {
                // empty if block
            }
            throw new DBusException(exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object executeRemoteMethod(RemoteObject remoteObject, Method method, AbstractConnection abstractConnection, int n, CallbackHandler callbackHandler, Object ... objectArray) throws DBusExecutionException {
        MethodCall methodCall;
        Object object;
        Type[] typeArray = method.getGenericParameterTypes();
        String string = null;
        if (typeArray.length > 0) {
            try {
                string = Marshalling.getDBusType(typeArray);
                objectArray = Marshalling.convertParameters(objectArray, typeArray, abstractConnection);
            }
            catch (DBusException dBusException) {
                throw new DBusExecutionException(Gettext._("Failed to construct D-Bus type: ") + dBusException.getMessage());
            }
        }
        byte by = 0;
        if (!remoteObject.autostart) {
            by = (byte)(by | 2);
        }
        if (n == 1) {
            by = (byte)(by | 0x40);
        }
        if (method.isAnnotationPresent(DBus.Method.NoReply.class)) {
            by = (byte)(by | 1);
        }
        try {
            object = method.isAnnotationPresent(DBusMemberName.class) ? method.getAnnotation(DBusMemberName.class).value() : method.getName();
            methodCall = null == remoteObject.iface ? new MethodCall(remoteObject.busname, remoteObject.objectpath, null, (String)object, by, string, objectArray) : (null != remoteObject.iface.getAnnotation(DBusInterfaceName.class) ? new MethodCall(remoteObject.busname, remoteObject.objectpath, remoteObject.iface.getAnnotation(DBusInterfaceName.class).value(), (String)object, by, string, objectArray) : new MethodCall(remoteObject.busname, remoteObject.objectpath, AbstractConnection.dollar_pattern.matcher(remoteObject.iface.getName()).replaceAll("."), (String)object, by, string, objectArray));
        }
        catch (DBusException dBusException) {
            if (AbstractConnection.EXCEPTION_DEBUG) {
                // empty if block
            }
            throw new DBusExecutionException(Gettext._("Failed to construct outgoing method call: ") + dBusException.getMessage());
        }
        if (null == abstractConnection.outgoing) {
            throw new NotConnected(Gettext._("Not Connected"));
        }
        switch (n) {
            case 1: {
                abstractConnection.queueOutgoing(methodCall);
                return new DBusAsyncReply(methodCall, method, abstractConnection);
            }
            case 2: {
                object = abstractConnection.pendingCallbacks;
                synchronized (object) {
                    abstractConnection.pendingCallbacks.put(methodCall, callbackHandler);
                    abstractConnection.pendingCallbackReplys.put(methodCall, new DBusAsyncReply(methodCall, method, abstractConnection));
                }
                abstractConnection.queueOutgoing(methodCall);
                return null;
            }
            case 0: {
                abstractConnection.queueOutgoing(methodCall);
            }
        }
        if (method.isAnnotationPresent(DBus.Method.NoReply.class)) {
            return null;
        }
        object = methodCall.getReply();
        if (null == object) {
            throw new DBus.Error.NoReply(Gettext._("No reply within specified time"));
        }
        if (object instanceof Error) {
            ((Error)object).throwException();
        }
        try {
            return RemoteInvocationHandler.convertRV(((Message)object).getSig(), ((Message)object).getParameters(), method, abstractConnection);
        }
        catch (DBusException dBusException) {
            if (AbstractConnection.EXCEPTION_DEBUG) {
                // empty if block
            }
            throw new DBusExecutionException(dBusException.getMessage());
        }
    }

    public RemoteInvocationHandler(AbstractConnection abstractConnection, RemoteObject remoteObject) {
        this.remote = remoteObject;
        this.conn = abstractConnection;
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        block20: {
            if (method.getName().equals("isRemote")) {
                return true;
            }
            if (method.getName().equals("clone")) {
                return null;
            }
            if (method.getName().equals("equals")) {
                try {
                    if (1 == objectArray.length) {
                        return new Boolean(this.remote.equals(((RemoteInvocationHandler)Proxy.getInvocationHandler((Object)objectArray[0])).remote));
                    }
                    break block20;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return Boolean.FALSE;
                }
            }
            if (method.getName().equals("finalize")) {
                return null;
            }
            if (method.getName().equals("getClass")) {
                return DBusInterface.class;
            }
            if (method.getName().equals("hashCode")) {
                return this.remote.hashCode();
            }
            if (method.getName().equals("notify")) {
                this.remote.notify();
                return null;
            }
            if (method.getName().equals("notifyAll")) {
                this.remote.notifyAll();
                return null;
            }
            if (method.getName().equals("wait")) {
                if (0 == objectArray.length) {
                    this.remote.wait();
                } else if (1 == objectArray.length && objectArray[0] instanceof Long) {
                    this.remote.wait((Long)objectArray[0]);
                } else if (2 == objectArray.length && objectArray[0] instanceof Long && objectArray[1] instanceof Integer) {
                    this.remote.wait((Long)objectArray[0], (Integer)objectArray[1]);
                }
                if (objectArray.length <= 2) {
                    return null;
                }
            } else if (method.getName().equals("toString")) {
                return this.remote.toString();
            }
        }
        return RemoteInvocationHandler.executeRemoteMethod(this.remote, method, this.conn, 0, null, objectArray);
    }
}

