/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.octo;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.ice4j.socket.MultiplexingDatagramSocket;
import org.jitsi.utils.logging.Logger;

public class OctoRelay {
    private static final Logger logger = Logger.getLogger(OctoRelay.class);
    private MultiplexingDatagramSocket socket;
    private String relayId;
    private String publicAddress;
    private int port;

    public OctoRelay(String address, int port) throws UnknownHostException, SocketException {
        DatagramSocket s = new DatagramSocket(new InetSocketAddress(InetAddress.getByName(address), port));
        this.socket = new MultiplexingDatagramSocket(s, true);
        this.port = port;
        String id = address + ":" + port;
        this.setRelayId(id);
    }

    void stop() {
        try {
            this.socket.close();
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to stop OctoRelay: ", (Throwable)e);
        }
    }

    public String getId() {
        return this.relayId;
    }

    public void setRelayId(String id) {
        this.relayId = id;
    }

    public void setPublicAddress(String address) {
        this.publicAddress = address;
        String id = this.publicAddress + ":" + this.port;
        this.setRelayId(id);
    }

    public MultiplexingDatagramSocket getSocket() {
        return this.socket;
    }
}

