/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.jitsi.impl.neomedia.RTCPPacketPredicate;
import org.jitsi.impl.neomedia.RTPPacketPredicate;
import org.jitsi.impl.neomedia.VideoMediaStreamImpl;
import org.jitsi.impl.neomedia.rtp.MediaStreamTrackDesc;
import org.jitsi.impl.neomedia.rtp.RTPEncodingDesc;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformerAdapter;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.ByteArrayBuffer;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.service.neomedia.rtp.BandwidthEstimator;
import org.jitsi.utils.ArrayUtils;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.Logger;
import org.jitsi.utils.logging.TimeSeriesLogger;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.VideoChannel;
import org.jitsi.videobridge.cc.AdaptiveTrackProjection;
import org.jitsi.videobridge.cc.RewriteException;

public class BitrateController
implements TransformEngine {
    public static final String BWE_CHANGE_THRESHOLD_PCT_PNAME = "org.jitsi.videobridge.BWE_CHANGE_THRESHOLD_PCT";
    public static final String THUMBNAIL_MAX_HEIGHT_PNAME = "org.jitsi.videobridge.THUMBNAIL_MAX_HEIGHT";
    public static final String ONSTAGE_PREFERRED_HEIGHT_PNAME = "org.jitsi.videobridge.ONSTAGE_PREFERRED_HEIGHT";
    public static final String ONSTAGE_PREFERRED_FRAME_RATE_PNAME = "org.jitsi.videobridge.ONSTAGE_PREFERRED_FRAME_RATE";
    public static final String ENABLE_ONSTAGE_VIDEO_SUSPEND_PNAME = "org.jitsi.videobridge.ENABLE_ONSTAGE_VIDEO_SUSPEND";
    public static final String TRUST_BWE_PNAME = "org.jitsi.videobridge.TRUST_BWE";
    private static final RateSnapshot[] EMPTY_RATE_SNAPSHOT_ARRAY = new RateSnapshot[0];
    private static final int THUMBNAIL_MAX_HEIGHT_DEFAULT = 180;
    private static final int ONSTAGE_PREFERRED_HEIGHT_DEFAULT = 360;
    private static final double ONSTAGE_PREFERRED_FRAME_RATE_DEFAULT = 30.0;
    private static final boolean ENABLE_ONSTAGE_VIDEO_SUSPEND_DEFAULT = false;
    private static int BWE_CHANGE_THRESHOLD_PCT_DEFAULT = 15;
    private static final ConfigurationService cfg = LibJitsi.getConfigurationService();
    private static final int BWE_CHANGE_THRESHOLD_PCT = cfg != null ? cfg.getInt("org.jitsi.videobridge.BWE_CHANGE_THRESHOLD_PCT", BWE_CHANGE_THRESHOLD_PCT_DEFAULT) : BWE_CHANGE_THRESHOLD_PCT_DEFAULT;
    private static final int THUMBNAIL_MAX_HEIGHT = cfg != null ? cfg.getInt("org.jitsi.videobridge.THUMBNAIL_MAX_HEIGHT", 180) : 180;
    private static final int ONSTAGE_PREFERRED_HEIGHT = cfg != null ? cfg.getInt("org.jitsi.videobridge.ONSTAGE_PREFERRED_HEIGHT", 360) : 360;
    private static final double ONSTAGE_PREFERRED_FRAME_RATE = cfg != null ? cfg.getDouble("org.jitsi.videobridge.ONSTAGE_PREFERRED_FRAME_RATE", 30.0) : 30.0;
    private static final boolean ENABLE_ONSTAGE_VIDEO_SUSPEND = cfg != null ? cfg.getBoolean("org.jitsi.videobridge.ENABLE_ONSTAGE_VIDEO_SUSPEND", false) : false;
    private final Logger logger = Logger.getLogger(BitrateController.class);
    private final TimeSeriesLogger timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(BitrateController.class);
    private static final Set<String> INITIAL_EMPTY_SET = Collections.unmodifiableSet(new HashSet(0));
    private final VideoChannel dest;
    private final Map<Long, AdaptiveTrackProjection> adaptiveTrackProjectionMap = new ConcurrentHashMap<Long, AdaptiveTrackProjection>();
    private final PacketTransformer rtpTransformer = new RTPTransformer();
    private final PacketTransformer rtcpTransformer = new RTCPTransformer();
    private Set<String> forwardedEndpointIds = INITIAL_EMPTY_SET;
    private final boolean trustBwe;
    private final boolean enableVideoQualityTracing;
    private long firstMediaMs = -1L;
    private long lastBwe = -1L;
    private List<AdaptiveTrackProjection> adaptiveTrackProjections;

    public BitrateController(VideoChannel dest) {
        this.dest = dest;
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        this.trustBwe = cfg != null && cfg.getBoolean(TRUST_BWE_PNAME, true);
        this.enableVideoQualityTracing = this.timeSeriesLogger.isTraceEnabled();
    }

    private static boolean isLargerThanBweThreshold(long previousBwe, long currentBwe) {
        return Math.abs(previousBwe - currentBwe) >= previousBwe * (long)BWE_CHANGE_THRESHOLD_PCT / 100L;
    }

    public VideoChannel getVideoChannel() {
        return this.dest;
    }

    public PacketTransformer getRTPTransformer() {
        return this.rtpTransformer;
    }

    public PacketTransformer getRTCPTransformer() {
        return this.rtcpTransformer;
    }

    List<AdaptiveTrackProjection> getAdaptiveTrackProjections() {
        return this.adaptiveTrackProjections;
    }

    public boolean accept(RawPacket pkt) {
        long ssrc = pkt.getSSRCAsLong();
        if (ssrc < 0L) {
            return false;
        }
        AdaptiveTrackProjection adaptiveTrackProjection = this.adaptiveTrackProjectionMap.get(ssrc);
        if (adaptiveTrackProjection == null) {
            this.logger.warn((Object)("Dropping an RTP packet, because the SSRC has not been signaled:" + ssrc));
            return false;
        }
        return adaptiveTrackProjection.accept(pkt);
    }

    public void update(long bweBps) {
        this.update(null, bweBps);
    }

    public void update() {
        this.update(null, -1L);
    }

    public void update(List<AbstractEndpoint> conferenceEndpoints, long bweBps) {
        if (bweBps > -1L) {
            if (!BitrateController.isLargerThanBweThreshold(this.lastBwe, bweBps)) {
                return;
            }
            this.lastBwe = bweBps;
        }
        conferenceEndpoints = conferenceEndpoints == null ? this.dest.getConferenceSpeechActivity().getEndpoints() : new ArrayList<AbstractEndpoint>(conferenceEndpoints);
        if (!(this.dest.getStream() instanceof VideoMediaStreamImpl)) {
            return;
        }
        VideoMediaStreamImpl destStream = (VideoMediaStreamImpl)this.dest.getStream();
        BandwidthEstimator bwe = destStream == null ? null : destStream.getOrCreateBandwidthEstimator();
        long nowMs = System.currentTimeMillis();
        boolean trustBwe = this.trustBwe;
        if (trustBwe && (this.firstMediaMs == -1L || nowMs - this.firstMediaMs < 10000L)) {
            trustBwe = false;
        }
        if (bwe != null && bweBps == -1L && trustBwe) {
            bweBps = bwe.getLatestEstimate();
        }
        if (bweBps < 0L || !trustBwe || !destStream.getRtxTransformer().destinationSupportsRtx()) {
            bweBps = Long.MAX_VALUE;
        }
        Object[] trackBitrateAllocations = this.allocate(bweBps, conferenceEndpoints);
        Set<String> oldForwardedEndpointIds = this.forwardedEndpointIds;
        HashSet<String> newForwardedEndpointIds = new HashSet<String>();
        HashSet<String> endpointsEnteringLastNIds = new HashSet<String>();
        HashSet<String> conferenceEndpointIds = new HashSet<String>();
        long totalIdealBps = 0L;
        long totalTargetBps = 0L;
        int totalIdealIdx = 0;
        int totalTargetIdx = 0;
        ArrayList<AdaptiveTrackProjection> adaptiveTrackProjections = new ArrayList<AdaptiveTrackProjection>();
        if (!ArrayUtils.isNullOrEmpty((Object[])trackBitrateAllocations)) {
            for (Object trackBitrateAllocation : trackBitrateAllocations) {
                conferenceEndpointIds.add(((TrackBitrateAllocation)trackBitrateAllocation).endpointID);
                int trackTargetIdx = ((TrackBitrateAllocation)trackBitrateAllocation).getTargetIndex();
                int trackIdealIdx = ((TrackBitrateAllocation)trackBitrateAllocation).getIdealIndex();
                AdaptiveTrackProjection adaptiveTrackProjection = this.lookupOrCreateAdaptiveTrackProjection((TrackBitrateAllocation)trackBitrateAllocation);
                if (adaptiveTrackProjection != null) {
                    adaptiveTrackProjections.add(adaptiveTrackProjection);
                    adaptiveTrackProjection.setTargetIndex(trackTargetIdx);
                    adaptiveTrackProjection.setIdealIndex(trackIdealIdx);
                    if (((TrackBitrateAllocation)trackBitrateAllocation).track != null && this.enableVideoQualityTracing) {
                        DiagnosticContext diagnosticContext = destStream.getDiagnosticContext();
                        long trackTargetBps = ((TrackBitrateAllocation)trackBitrateAllocation).getTargetBitrate();
                        long trackIdealBps = ((TrackBitrateAllocation)trackBitrateAllocation).getIdealBitrate();
                        totalTargetBps += trackTargetBps;
                        totalIdealBps += trackIdealBps;
                        totalTargetIdx += trackTargetIdx;
                        totalIdealIdx += trackIdealIdx;
                        this.timeSeriesLogger.trace((Map)diagnosticContext.makeTimeSeriesPoint("track_quality", nowMs).addField("track_id", (Object)((TrackBitrateAllocation)trackBitrateAllocation).track.hashCode()).addField("target_idx", (Object)trackTargetIdx).addField("ideal_idx", (Object)trackIdealIdx).addField("target_bps", (Object)trackTargetBps).addField("selected", (Object)((TrackBitrateAllocation)trackBitrateAllocation).selected).addField("oversending", (Object)((TrackBitrateAllocation)trackBitrateAllocation).oversending).addField("preferred_idx", (Object)((TrackBitrateAllocation)trackBitrateAllocation).ratedPreferredIdx).addField("endpoint_id", (Object)((TrackBitrateAllocation)trackBitrateAllocation).endpointID).addField("ideal_bps", (Object)trackIdealBps));
                    }
                }
                if (trackTargetIdx <= -1) continue;
                newForwardedEndpointIds.add(((TrackBitrateAllocation)trackBitrateAllocation).endpointID);
                if (oldForwardedEndpointIds.contains(((TrackBitrateAllocation)trackBitrateAllocation).endpointID)) continue;
                endpointsEnteringLastNIds.add(((TrackBitrateAllocation)trackBitrateAllocation).endpointID);
            }
        } else {
            for (AdaptiveTrackProjection adaptiveTrackProjection : this.adaptiveTrackProjectionMap.values()) {
                if (this.enableVideoQualityTracing) {
                    --totalIdealIdx;
                    --totalTargetIdx;
                }
                adaptiveTrackProjection.setTargetIndex(-1);
                adaptiveTrackProjection.setIdealIndex(-1);
            }
        }
        if (this.enableVideoQualityTracing) {
            DiagnosticContext diagnosticContext = destStream.getDiagnosticContext();
            this.timeSeriesLogger.trace((Map)diagnosticContext.makeTimeSeriesPoint("video_quality", nowMs).addField("total_target_idx", (Object)totalTargetIdx).addField("total_ideal_idx", (Object)totalIdealIdx).addField("available_bps", (Object)bweBps).addField("total_target_bps", (Object)totalTargetBps).addField("total_ideal_bps", (Object)totalIdealBps));
        }
        this.adaptiveTrackProjections = Collections.unmodifiableList(adaptiveTrackProjections);
        if (!newForwardedEndpointIds.equals(oldForwardedEndpointIds)) {
            this.dest.sendLastNEndpointsChangeEvent(newForwardedEndpointIds, endpointsEnteringLastNIds, conferenceEndpointIds);
        }
        this.forwardedEndpointIds = newForwardedEndpointIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AdaptiveTrackProjection lookupOrCreateAdaptiveTrackProjection(TrackBitrateAllocation trackBitrateAllocation) {
        Map<Long, AdaptiveTrackProjection> map = this.adaptiveTrackProjectionMap;
        synchronized (map) {
            int ssrc = trackBitrateAllocation.targetSSRC;
            AdaptiveTrackProjection adaptiveTrackProjection = this.adaptiveTrackProjectionMap.get((long)ssrc & 0xFFFFFFFFL);
            if (adaptiveTrackProjection != null || trackBitrateAllocation.track == null) {
                return adaptiveTrackProjection;
            }
            Object[] rtpEncodings = trackBitrateAllocation.track.getRTPEncodings();
            if (ArrayUtils.isNullOrEmpty((Object[])rtpEncodings)) {
                return adaptiveTrackProjection;
            }
            adaptiveTrackProjection = new AdaptiveTrackProjection(trackBitrateAllocation.track);
            for (Object rtpEncoding : rtpEncodings) {
                this.adaptiveTrackProjectionMap.put(rtpEncoding.getPrimarySSRC(), adaptiveTrackProjection);
                long rtxSsrc = rtpEncoding.getSecondarySsrc("rtx");
                if (rtxSsrc == -1L) continue;
                this.adaptiveTrackProjectionMap.put(rtxSsrc, adaptiveTrackProjection);
            }
            return adaptiveTrackProjection;
        }
    }

    private TrackBitrateAllocation[] allocate(long maxBandwidth, List<AbstractEndpoint> conferenceEndpoints) {
        Object[] trackBitrateAllocations = this.prioritize(conferenceEndpoints);
        if (ArrayUtils.isNullOrEmpty((Object[])trackBitrateAllocations)) {
            return trackBitrateAllocations;
        }
        long oldMaxBandwidth = 0L;
        int oldStateLen = 0;
        int[] oldRatedTargetIndices = new int[trackBitrateAllocations.length];
        int[] newRatedTargetIndicies = new int[trackBitrateAllocations.length];
        Arrays.fill(newRatedTargetIndicies, -1);
        while (oldMaxBandwidth != maxBandwidth) {
            Object trackBitrateAllocation;
            int i;
            oldMaxBandwidth = maxBandwidth;
            System.arraycopy(newRatedTargetIndicies, 0, oldRatedTargetIndices, 0, oldRatedTargetIndices.length);
            int newStateLen = 0;
            for (i = 0; i < trackBitrateAllocations.length && ((TrackBitrateAllocation)(trackBitrateAllocation = trackBitrateAllocations[i])).fitsInLastN; ++i) {
                ((TrackBitrateAllocation)trackBitrateAllocation).improve(maxBandwidth += ((TrackBitrateAllocation)trackBitrateAllocation).getTargetBitrate());
                maxBandwidth -= ((TrackBitrateAllocation)trackBitrateAllocation).getTargetBitrate();
                newRatedTargetIndicies[i] = ((TrackBitrateAllocation)trackBitrateAllocation).ratedTargetIdx;
                if (((TrackBitrateAllocation)trackBitrateAllocation).getTargetIndex() > -1) {
                    ++newStateLen;
                }
                if (((TrackBitrateAllocation)trackBitrateAllocation).ratedTargetIdx < ((TrackBitrateAllocation)trackBitrateAllocation).ratedPreferredIdx) break;
            }
            if (oldStateLen > newStateLen) {
                for (i = 0; i < trackBitrateAllocations.length; ++i) {
                    ((TrackBitrateAllocation)trackBitrateAllocations[i]).ratedTargetIdx = oldRatedTargetIndices[i];
                }
                break;
            }
            oldStateLen = newStateLen;
        }
        return trackBitrateAllocations;
    }

    private TrackBitrateAllocation[] prioritize(List<AbstractEndpoint> conferenceEndpoints) {
        if (this.dest.isExpired()) {
            return null;
        }
        AbstractEndpoint destEndpoint = this.dest.getEndpoint();
        if (destEndpoint == null || destEndpoint.isExpired()) {
            return null;
        }
        ArrayList<TrackBitrateAllocation> trackBitrateAllocations = new ArrayList<TrackBitrateAllocation>();
        int lastN = this.dest.getLastN();
        lastN = lastN < 0 ? conferenceEndpoints.size() - 1 : Math.min(lastN, conferenceEndpoints.size() - 1);
        int endpointPriority = 0;
        Set<String> selectedEndpoints = destEndpoint.getSelectedEndpoints();
        Iterator<AbstractEndpoint> it = conferenceEndpoints.iterator();
        while (it.hasNext() && endpointPriority < lastN) {
            AbstractEndpoint sourceEndpoint = it.next();
            if (sourceEndpoint.isExpired() || sourceEndpoint.getID().equals(destEndpoint.getID()) || !selectedEndpoints.contains(sourceEndpoint.getID())) continue;
            Object[] tracks = sourceEndpoint.getMediaStreamTracks(MediaType.VIDEO);
            if (!ArrayUtils.isNullOrEmpty((Object[])tracks)) {
                for (Object track : tracks) {
                    trackBitrateAllocations.add(endpointPriority, new TrackBitrateAllocation(sourceEndpoint, (MediaStreamTrackDesc)track, true, true, this.getVideoChannel().getMaxFrameHeight()));
                }
                ++endpointPriority;
            }
            it.remove();
        }
        Set<String> pinnedEndpoints = destEndpoint.getPinnedEndpoints();
        if (!pinnedEndpoints.isEmpty()) {
            Iterator<AbstractEndpoint> it2 = conferenceEndpoints.iterator();
            while (it2.hasNext() && endpointPriority < lastN) {
                AbstractEndpoint sourceEndpoint = it2.next();
                if (sourceEndpoint.isExpired() || sourceEndpoint.getID().equals(destEndpoint.getID()) || !pinnedEndpoints.contains(sourceEndpoint.getID())) continue;
                Object[] tracks = sourceEndpoint.getMediaStreamTracks(MediaType.VIDEO);
                if (!ArrayUtils.isNullOrEmpty((Object[])tracks)) {
                    for (Object track : tracks) {
                        trackBitrateAllocations.add(endpointPriority, new TrackBitrateAllocation(sourceEndpoint, (MediaStreamTrackDesc)track, true, false, this.getVideoChannel().getMaxFrameHeight()));
                    }
                    ++endpointPriority;
                }
                it2.remove();
            }
        }
        if (!conferenceEndpoints.isEmpty()) {
            for (AbstractEndpoint sourceEndpoint : conferenceEndpoints) {
                boolean forwarded;
                if (sourceEndpoint.isExpired() || sourceEndpoint.getID().equals(destEndpoint.getID())) continue;
                boolean bl = forwarded = endpointPriority < lastN;
                Object[] tracks = sourceEndpoint.getMediaStreamTracks(MediaType.VIDEO);
                if (ArrayUtils.isNullOrEmpty((Object[])tracks)) continue;
                for (Object track : tracks) {
                    trackBitrateAllocations.add(endpointPriority, new TrackBitrateAllocation(sourceEndpoint, (MediaStreamTrackDesc)track, forwarded, false, this.getVideoChannel().getMaxFrameHeight()));
                }
                ++endpointPriority;
            }
        }
        return trackBitrateAllocations.toArray(new TrackBitrateAllocation[trackBitrateAllocations.size()]);
    }

    public Collection<String> getForwardedEndpoints() {
        return this.forwardedEndpointIds;
    }

    private class RTCPTransformer
    extends SinglePacketTransformerAdapter {
        RTCPTransformer() {
            super((Predicate)RTCPPacketPredicate.INSTANCE);
        }

        public RawPacket transform(RawPacket pkt) {
            long ssrc = pkt.getRTCPSSRC();
            if (ssrc < 0L) {
                return pkt;
            }
            AdaptiveTrackProjection adaptiveTrackProjection = (AdaptiveTrackProjection)BitrateController.this.adaptiveTrackProjectionMap.get(ssrc);
            if (adaptiveTrackProjection != null && !adaptiveTrackProjection.rewriteRtcp(pkt)) {
                return null;
            }
            return pkt;
        }
    }

    private class RTPTransformer
    implements PacketTransformer {
        private RTPTransformer() {
        }

        public void close() {
        }

        public RawPacket[] reverseTransform(RawPacket[] pkts) {
            return pkts;
        }

        public RawPacket[] transform(RawPacket[] pkts) {
            if (ArrayUtils.isNullOrEmpty((Object[])pkts)) {
                return pkts;
            }
            if (BitrateController.this.firstMediaMs == -1L) {
                BitrateController.this.firstMediaMs = System.currentTimeMillis();
            }
            RawPacket[] extras = null;
            for (int i = 0; i < pkts.length; ++i) {
                Object[] ret;
                if (!RTPPacketPredicate.INSTANCE.test((ByteArrayBuffer)pkts[i])) continue;
                long ssrc = pkts[i].getSSRCAsLong();
                AdaptiveTrackProjection adaptiveTrackProjection = (AdaptiveTrackProjection)BitrateController.this.adaptiveTrackProjectionMap.get(ssrc);
                if (adaptiveTrackProjection == null) {
                    pkts[i] = null;
                    continue;
                }
                try {
                    ret = adaptiveTrackProjection.rewriteRtp(pkts[i]);
                }
                catch (RewriteException ex) {
                    pkts[i] = null;
                    continue;
                }
                if (ArrayUtils.isNullOrEmpty((Object[])ret)) continue;
                int extrasLen = ArrayUtils.isNullOrEmpty(extras) ? 0 : extras.length;
                RawPacket[] newExtras = new RawPacket[extrasLen + ret.length];
                System.arraycopy(ret, 0, newExtras, extrasLen, ret.length);
                if (extrasLen > 0) {
                    System.arraycopy(extras, 0, newExtras, 0, extrasLen);
                }
                extras = newExtras;
            }
            return (RawPacket[])ArrayUtils.concat((Object[])pkts, extras);
        }
    }

    private class TrackBitrateAllocation {
        private final String endpointID;
        private final boolean fitsInLastN;
        private final boolean selected;
        private final int targetSSRC;
        private final int maxFrameHeight;
        private final MediaStreamTrackDesc track;
        private final RateSnapshot[] ratedIndices;
        private final int ratedPreferredIdx;
        private int ratedTargetIdx = -1;
        private boolean oversending = false;

        private TrackBitrateAllocation(AbstractEndpoint endpoint, MediaStreamTrackDesc track, boolean fitsInLastN, boolean selected, int maxFrameHeight) {
            Object[] encodings;
            this.endpointID = endpoint.getID();
            this.selected = selected;
            this.fitsInLastN = fitsInLastN;
            this.track = track;
            this.maxFrameHeight = maxFrameHeight;
            if (track == null) {
                this.targetSSRC = -1;
                encodings = null;
            } else {
                encodings = track.getRTPEncodings();
                this.targetSSRC = ArrayUtils.isNullOrEmpty((Object[])encodings) ? -1 : (int)encodings[0].getPrimarySSRC();
            }
            if (this.targetSSRC == -1 || !fitsInLastN) {
                this.ratedPreferredIdx = -1;
                this.ratedIndices = EMPTY_RATE_SNAPSHOT_ARRAY;
                return;
            }
            ArrayList<RateSnapshot> ratesList = new ArrayList<RateSnapshot>();
            int ratedPreferredIdx = 0;
            for (Object encoding : encodings) {
                if (encoding.getHeight() > this.maxFrameHeight) continue;
                if (selected) {
                    if (encoding.getHeight() < ONSTAGE_PREFERRED_HEIGHT || encoding.getFrameRate() >= ONSTAGE_PREFERRED_FRAME_RATE) {
                        ratesList.add(new RateSnapshot(encoding.getLastStableBitrateBps(System.currentTimeMillis()), (RTPEncodingDesc)encoding));
                    }
                    if (encoding.getHeight() > ONSTAGE_PREFERRED_HEIGHT) continue;
                    ratedPreferredIdx = ratesList.size() - 1;
                    continue;
                }
                if (encoding.getHeight() > THUMBNAIL_MAX_HEIGHT) continue;
                ratesList.add(new RateSnapshot(encoding.getLastStableBitrateBps(System.currentTimeMillis()), (RTPEncodingDesc)encoding));
            }
            this.ratedPreferredIdx = ratedPreferredIdx;
            this.ratedIndices = ratesList.toArray(new RateSnapshot[ratesList.size()]);
        }

        void improve(long maxBps) {
            if (this.ratedIndices.length == 0) {
                return;
            }
            if (this.ratedTargetIdx == -1 && this.selected) {
                if (!ENABLE_ONSTAGE_VIDEO_SUSPEND) {
                    this.ratedTargetIdx = 0;
                    this.oversending = this.ratedIndices[0].bps > maxBps;
                }
                int i = this.ratedTargetIdx + 1;
                while (i < this.ratedIndices.length && i <= this.ratedPreferredIdx && maxBps >= this.ratedIndices[i].bps) {
                    this.ratedTargetIdx = i++;
                }
            } else if (this.ratedTargetIdx + 1 < this.ratedIndices.length && this.ratedIndices[this.ratedTargetIdx + 1].bps < maxBps) {
                ++this.ratedTargetIdx;
            }
        }

        long getTargetBitrate() {
            return this.ratedTargetIdx != -1 ? this.ratedIndices[this.ratedTargetIdx].bps : 0L;
        }

        long getIdealBitrate() {
            return this.ratedIndices.length != 0 ? this.ratedIndices[this.ratedIndices.length - 1].bps : 0L;
        }

        int getTargetIndex() {
            return this.ratedTargetIdx != -1 ? this.ratedIndices[this.ratedTargetIdx].encoding.getIndex() : -1;
        }

        int getIdealIndex() {
            return this.ratedIndices.length != 0 ? this.ratedIndices[this.ratedIndices.length - 1].encoding.getIndex() : -1;
        }
    }

    static class RateSnapshot {
        final long bps;
        final RTPEncodingDesc encoding;

        private RateSnapshot(long bps, RTPEncodingDesc encoding) {
            this.bps = bps;
            this.encoding = encoding;
        }
    }
}

