/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.net.DatagramPacket;
import org.ice4j.socket.DTLSDatagramFilter;
import org.ice4j.socket.DatagramPacketFilter;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.util.RTCPUtils;
import org.jitsi.util.RTPUtils;
import org.jitsi.utils.logging.Logger;
import org.jitsi.videobridge.RtpChannel;

public class RtpChannelDatagramFilter
implements DatagramPacketFilter {
    private static final Logger logger = Logger.getLogger(RtpChannelDatagramFilter.class);
    private boolean acceptNonRtp = false;
    private final RtpChannel channel;
    private boolean missingPtsWarningLogged = false;
    private final boolean rtcp;

    protected RtpChannelDatagramFilter(RtpChannel channel, boolean rtcp) {
        this(channel, rtcp, false);
    }

    RtpChannelDatagramFilter(RtpChannel channel, boolean rtcp, boolean acceptNonRtp) {
        this.channel = channel;
        this.rtcp = rtcp;
        this.acceptNonRtp = acceptNonRtp;
    }

    public boolean accept(DatagramPacket p) {
        int len;
        int off;
        byte[] buf = p.getData();
        if (!RawPacket.isRtpRtcp((byte[])buf, (int)(off = p.getOffset()), (int)(len = p.getLength()))) {
            return this.acceptNonRtp && DTLSDatagramFilter.isDTLS((DatagramPacket)p);
        }
        if (RTCPUtils.isRtcp((byte[])buf, (int)off, (int)len)) {
            return this.rtcp && this.acceptRTCP(buf, off, len);
        }
        return !this.rtcp && this.acceptRTP(RawPacket.getPayloadType((byte[])buf, (int)off, (int)len));
    }

    private boolean acceptRTCP(byte[] data, int off, int len) {
        if (len >= 8) {
            int[] channelSSRCs;
            int packetSenderSSRC = RTPUtils.readInt((byte[])data, (int)(off + 4));
            for (int channelSSRC : channelSSRCs = this.channel.getDefaultReceiveSSRCs()) {
                if (channelSSRC != packetSenderSSRC) continue;
                return true;
            }
            for (int channelSSRC : channelSSRCs = this.channel.getReceiveSSRCs()) {
                if (channelSSRC != packetSenderSSRC) continue;
                return true;
            }
        }
        return false;
    }

    private boolean acceptRTP(int pt) {
        int[] channelPTs = this.channel.getReceivePTs();
        if (channelPTs == null || channelPTs.length == 0) {
            if (this.channel.getChannelBundleId() == null) {
                return true;
            }
            if (!this.missingPtsWarningLogged) {
                this.missingPtsWarningLogged = true;
                logger.warn((Object)("No payload-types specified for channel " + this.channel.getID() + " while bundle is in use. Packets are dropped."));
            }
            return false;
        }
        for (int channelPT : channelPTs) {
            if (channelPT != pt) continue;
            return true;
        }
        return false;
    }

    public void setAcceptNonRtp(boolean acceptNonRtp) {
        this.acceptNonRtp = acceptNonRtp;
    }
}

