/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.osgi.framework;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jitsi.impl.osgi.framework.BundleContextImpl;
import org.jitsi.impl.osgi.framework.launch.FrameworkImpl;
import org.jitsi.impl.osgi.framework.startlevel.BundleStartLevelImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;

public class BundleImpl
implements Bundle {
    private Logger logger = Logger.getLogger(BundleImpl.class.getName());
    private BundleActivator bundleActivator;
    private BundleContext bundleContext;
    private final long bundleId;
    private BundleStartLevel bundleStartLevel;
    private final FrameworkImpl framework;
    private final String location;
    protected final ClassLoader classLoader;
    private int state = 2;

    public BundleImpl(FrameworkImpl framework, long bundleId, String location, ClassLoader classLoader) {
        this.framework = framework;
        this.bundleId = bundleId;
        this.location = location;
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A> A adapt(Class<A> type) {
        BundleStartLevel adapt;
        if (BundleStartLevel.class.equals(type)) {
            if (this.getBundleId() == 0L) {
                adapt = null;
            } else {
                BundleImpl bundleImpl = this;
                synchronized (bundleImpl) {
                    if (this.bundleStartLevel == null) {
                        this.bundleStartLevel = new BundleStartLevelImpl(this);
                    }
                    adapt = this.bundleStartLevel;
                }
            }
        } else {
            adapt = null;
        }
        BundleStartLevel a = adapt;
        return (A)a;
    }

    public int compareTo(Bundle other) {
        long otherBundleId;
        long thisBundleId = this.getBundleId();
        if (thisBundleId < (otherBundleId = other.getBundleId())) {
            return -1;
        }
        if (thisBundleId == otherBundleId) {
            return 0;
        }
        return 1;
    }

    public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
        return null;
    }

    public BundleContext getBundleContext() {
        switch (this.getState()) {
            case 8: 
            case 16: 
            case 32: {
                return this.bundleContext;
            }
        }
        return null;
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public File getDataFile(String filename) {
        return null;
    }

    public URL getEntry(String path) {
        return null;
    }

    public Enumeration<String> getEntryPaths(String path) {
        return null;
    }

    public FrameworkImpl getFramework() {
        return this.framework;
    }

    public Dictionary<String, String> getHeaders() {
        return this.getHeaders(null);
    }

    public Dictionary<String, String> getHeaders(String locale) {
        return null;
    }

    public long getLastModified() {
        return 0L;
    }

    public String getLocation() {
        return this.getBundleId() == 0L ? "System Bundle" : this.location;
    }

    public ServiceReference<?>[] getRegisteredServices() {
        return this.framework.getRegisteredServices();
    }

    public URL getResource(String name) {
        return null;
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        return null;
    }

    public ServiceReference<?>[] getServicesInUse() {
        return null;
    }

    public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int signersType) {
        return null;
    }

    public int getState() {
        return this.state;
    }

    public String getSymbolicName() {
        return null;
    }

    public Version getVersion() {
        return null;
    }

    public boolean hasPermission(Object permission) {
        return false;
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.classLoader.loadClass(name);
    }

    protected void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    protected void setState(int state) {
        int oldState = this.getState();
        if (oldState != state) {
            this.state = state;
            int newState = this.getState();
            if (oldState != newState) {
                this.stateChanged(oldState, newState);
            }
        }
    }

    public void start() throws BundleException {
        this.start(0);
    }

    public void start(int options) throws BundleException {
        if (this.getState() == 1) {
            throw new IllegalStateException("Bundle.UNINSTALLED");
        }
        BundleStartLevel bundleStartLevel = this.adapt(BundleStartLevel.class);
        FrameworkStartLevel frameworkStartLevel = this.getFramework().adapt(FrameworkStartLevel.class);
        if (bundleStartLevel != null && bundleStartLevel.getStartLevel() > frameworkStartLevel.getStartLevel()) {
            if ((options & 1) == 1) {
                throw new BundleException("startLevel");
            }
            return;
        }
        if (this.getState() == 32) {
            return;
        }
        if (this.getState() == 2) {
            this.setState(4);
        }
        this.setState(8);
        String location = this.getLocation();
        if (location != null) {
            BundleActivator bundleActivator = null;
            Throwable exception = null;
            try {
                bundleActivator = (BundleActivator)this.loadClass(location.replace('/', '.')).newInstance();
                bundleActivator.start(this.getBundleContext());
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "Error starting bundle: " + bundleActivator, t);
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                exception = t;
            }
            if (exception == null) {
                this.bundleActivator = bundleActivator;
            } else {
                this.setState(16);
                this.setState(4);
                this.getFramework().fireBundleEvent(4, this);
                throw new BundleException("BundleActivator.start", exception);
            }
        }
        if (this.getState() == 1) {
            throw new IllegalStateException("Bundle.UNINSTALLED");
        }
        this.setState(32);
    }

    protected void stateChanged(int oldState, int newState) {
        switch (newState) {
            case 32: {
                this.getFramework().fireBundleEvent(2, this);
                break;
            }
            case 4: {
                this.setBundleContext(null);
                break;
            }
            case 8: {
                this.setBundleContext(new BundleContextImpl(this.getFramework(), this));
                break;
            }
        }
    }

    public void stop() throws BundleException {
        this.stop(0);
    }

    public void stop(int options) throws BundleException {
        boolean wasActive = false;
        switch (this.getState()) {
            case 32: {
                wasActive = true;
            }
            case 8: {
                this.setState(16);
                Throwable exception = null;
                if (wasActive && this.bundleActivator != null) {
                    try {
                        this.bundleActivator.stop(this.getBundleContext());
                    }
                    catch (Throwable t) {
                        if (t instanceof ThreadDeath) {
                            throw (ThreadDeath)t;
                        }
                        exception = t;
                    }
                    this.bundleActivator = null;
                }
                if (this.getState() == 1) {
                    throw new BundleException("Bundle.UNINSTALLED");
                }
                this.setState(4);
                this.getFramework().fireBundleEvent(4, this);
                if (exception == null) break;
                throw new BundleException("BundleActivator.stop", exception);
            }
            case 1: {
                throw new IllegalStateException("Bundle.UNINSTALLED");
            }
        }
    }

    public void uninstall() throws BundleException {
    }

    public void update() throws BundleException {
        this.update(null);
    }

    public void update(InputStream input) throws BundleException {
    }
}

