/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.sip.address.Address;
import net.java.sip.communicator.impl.protocol.sip.ContactGroupSipImpl;
import net.java.sip.communicator.impl.protocol.sip.ContactSipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetPresenceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.ServerStoredDetails;
import net.java.sip.communicator.service.protocol.event.ServerStoredGroupEvent;
import net.java.sip.communicator.service.protocol.event.ServerStoredGroupListener;
import net.java.sip.communicator.util.Logger;

public abstract class ServerStoredContactList {
    private static final Logger logger = Logger.getLogger(ServerStoredContactList.class);
    protected static final String ROOT_GROUP_NAME = "RootGroup";
    protected final ProtocolProviderServiceSipImpl sipProvider;
    protected final OperationSetPresenceSipImpl parentOperationSet;
    private final Vector<ServerStoredGroupListener> serverStoredGroupListeners;
    protected final ContactGroupSipImpl rootGroup;

    ServerStoredContactList(ProtocolProviderServiceSipImpl sipProvider, OperationSetPresenceSipImpl parentOperationSet) {
        this.sipProvider = sipProvider;
        this.parentOperationSet = parentOperationSet;
        this.serverStoredGroupListeners = new Vector();
        this.rootGroup = new ContactGroupSipImpl(ROOT_GROUP_NAME, sipProvider);
    }

    public ContactGroupSipImpl getRootGroup() {
        return this.rootGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroupListener(ServerStoredGroupListener listener) {
        Vector<ServerStoredGroupListener> vector = this.serverStoredGroupListeners;
        synchronized (vector) {
            if (!this.serverStoredGroupListeners.contains(listener)) {
                this.serverStoredGroupListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroupListener(ServerStoredGroupListener listener) {
        Vector<ServerStoredGroupListener> vector = this.serverStoredGroupListeners;
        synchronized (vector) {
            this.serverStoredGroupListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireGroupEvent(ContactGroup group, int eventID) {
        ArrayList<ServerStoredGroupListener> listeners;
        ServerStoredGroupEvent event = new ServerStoredGroupEvent(group, eventID, this.parentOperationSet.getServerStoredContactListRoot(), (ProtocolProviderService)this.sipProvider, (OperationSetPersistentPresence)this.parentOperationSet);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Will dispatch the following group event: " + event));
        }
        Vector<ServerStoredGroupListener> vector = this.serverStoredGroupListeners;
        synchronized (vector) {
            listeners = new ArrayList<ServerStoredGroupListener>(this.serverStoredGroupListeners);
        }
        for (ServerStoredGroupListener listener : listeners) {
            if (eventID == 2) {
                listener.groupRemoved(event);
                continue;
            }
            if (eventID == 3) {
                listener.groupNameChanged(event);
                continue;
            }
            if (eventID == 1) {
                listener.groupCreated(event);
                continue;
            }
            if (eventID != 4) continue;
            listener.groupResolved(event);
        }
    }

    public synchronized ContactSipImpl createUnresolvedContact(ContactGroupSipImpl parentGroup, String contactId, String persistentData) {
        Address contactAddress;
        if (parentGroup == null) {
            throw new IllegalArgumentException("Parent group cannot be null");
        }
        if (contactId == null || contactId.length() == 0) {
            throw new IllegalArgumentException("Creating contact id name cannot be null or empty");
        }
        ContactSipImpl existingContact = this.parentOperationSet.resolveContactID(contactId);
        if (existingContact != null) {
            return existingContact;
        }
        try {
            contactAddress = this.sipProvider.parseAddressString(contactId);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(String.format("%1s is no a valid SIP identifier", contactId), ex);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("createUnresolvedContact " + contactId));
        }
        ContactSipImpl newUnresolvedContact = new ContactSipImpl(contactAddress, this.sipProvider);
        newUnresolvedContact.setPersistent(true);
        parentGroup.addContact(newUnresolvedContact);
        newUnresolvedContact.setPersistentData(persistentData);
        this.fireContactAdded(parentGroup, newUnresolvedContact);
        return newUnresolvedContact;
    }

    public synchronized ContactGroupSipImpl createUnresolvedContactGroup(ContactGroupSipImpl parentGroup, String groupName) {
        ContactGroupSipImpl existingGroup;
        if (parentGroup == null) {
            throw new IllegalArgumentException("Parent group cannot be null");
        }
        if (groupName == null || groupName.length() == 0) {
            throw new IllegalArgumentException("Creating group name cannot be null or empry");
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("createUnresolvedContactGroup " + groupName));
        }
        if ((existingGroup = this.findGroupByName(groupName)) != null) {
            return existingGroup;
        }
        ContactGroupSipImpl subGroup = new ContactGroupSipImpl(groupName, this.sipProvider);
        subGroup.setResolved(false);
        parentGroup.addSubgroup(subGroup);
        this.fireGroupEvent(subGroup, 1);
        return subGroup;
    }

    protected ContactGroupSipImpl findGroupByName(String name) {
        for (int i = 0; i < this.getRootGroup().countSubgroups(); ++i) {
            ContactGroupSipImpl gr = (ContactGroupSipImpl)this.getRootGroup().getGroup(i);
            if (!gr.getGroupName().equalsIgnoreCase(name)) continue;
            return gr;
        }
        return null;
    }

    protected void fireContactAdded(ContactGroupSipImpl parentGroup, ContactSipImpl contact) {
        this.parentOperationSet.fireSubscriptionEvent((Contact)contact, parentGroup, 1);
    }

    protected void fireContactMoved(ContactGroupSipImpl oldParentGroup, ContactGroupSipImpl newParentGroup, ContactSipImpl contact) {
        this.parentOperationSet.fireSubscriptionMovedEvent((Contact)contact, oldParentGroup, newParentGroup);
    }

    protected void fireContactRemoved(ContactGroupSipImpl parentGroup, ContactSipImpl contact) {
        this.parentOperationSet.fireSubscriptionEvent((Contact)contact, parentGroup, 2);
    }

    protected void fireContactResolved(ContactGroupSipImpl parentGroup, ContactSipImpl contact) {
        this.parentOperationSet.fireSubscriptionEvent((Contact)contact, parentGroup, 4);
    }

    public synchronized List<ContactSipImpl> getUniqueContacts(ContactGroupSipImpl group) {
        HashMap<String, ContactSipImpl> uniqueContacts = new HashMap<String, ContactSipImpl>();
        List<ContactSipImpl> contacts = this.getAllContacts(group);
        for (ContactSipImpl contact : contacts) {
            uniqueContacts.put(contact.getUri(), contact);
        }
        return new ArrayList<ContactSipImpl>(uniqueContacts.values());
    }

    public synchronized List<ContactSipImpl> getAllContacts(ContactGroupSipImpl group) {
        ArrayList<ContactSipImpl> contacts = new ArrayList<ContactSipImpl>();
        Iterator<ContactGroup> groupIterator = group.subgroups();
        while (groupIterator.hasNext()) {
            contacts.addAll(this.getAllContacts((ContactGroupSipImpl)groupIterator.next()));
        }
        Iterator<Contact> contactIterator = group.contacts();
        while (contactIterator.hasNext()) {
            ContactSipImpl contact = (ContactSipImpl)contactIterator.next();
            contacts.add(contact);
        }
        return contacts;
    }

    public synchronized List<ContactGroupSipImpl> getAllGroups(ContactGroupSipImpl group) {
        ArrayList<ContactGroupSipImpl> groups = new ArrayList<ContactGroupSipImpl>();
        Iterator<ContactGroup> groupIterator = group.subgroups();
        while (groupIterator.hasNext()) {
            groups.addAll(this.getAllGroups((ContactGroupSipImpl)groupIterator.next()));
        }
        return groups;
    }

    private boolean isContactExists(String contactUri) {
        for (ContactSipImpl uniqueContact : this.getUniqueContacts(this.rootGroup)) {
            if (!uniqueContact.getUri().equals(contactUri)) continue;
            return true;
        }
        return false;
    }

    private List<ContactSipImpl> getContacts(String contactUri) {
        ArrayList<ContactSipImpl> result = new ArrayList<ContactSipImpl>();
        for (ContactSipImpl contact : this.getAllContacts(this.rootGroup)) {
            if (!contact.getUri().equals(contactUri)) continue;
            result.add(contact);
        }
        return result;
    }

    private boolean isContactPersistent(String contactUri) {
        for (ContactSipImpl contact : this.getContacts(contactUri)) {
            if (!contact.isPersistent()) continue;
            return true;
        }
        return false;
    }

    public abstract void init();

    public abstract void destroy();

    public abstract URI getImageUri();

    public abstract byte[] getImage(URI var1);

    public abstract ContactGroupSipImpl createGroup(ContactGroupSipImpl var1, String var2, boolean var3) throws OperationFailedException;

    public abstract void renameGroup(ContactGroupSipImpl var1, String var2);

    public abstract void moveContactToGroup(ContactSipImpl var1, ContactGroupSipImpl var2) throws OperationFailedException;

    public abstract void removeGroup(ContactGroupSipImpl var1);

    public synchronized ContactSipImpl createContact(ContactGroupSipImpl parentGroup, String contactId, boolean persistent, String contactType) throws OperationFailedException {
        return this.createContact(parentGroup, contactId, null, persistent, contactType);
    }

    public abstract ContactSipImpl createContact(ContactGroupSipImpl var1, String var2, String var3, boolean var4, String var5) throws OperationFailedException;

    public abstract void removeContact(ContactSipImpl var1) throws OperationFailedException;

    public abstract void renameContact(ContactSipImpl var1, String var2);

    public abstract void authorizationAccepted(ContactSipImpl var1);

    public abstract void authorizationRejected(ContactSipImpl var1);

    public abstract void authorizationIgnored(ContactSipImpl var1);

    public abstract boolean isAccountImageSupported();

    public abstract ServerStoredDetails.ImageDetail getAccountImage() throws OperationFailedException;

    public abstract void deleteAccountImage() throws OperationFailedException;

    public abstract void setAccountImage(byte[] var1) throws OperationFailedException;
}

