/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.SipException;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionUnavailableException;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import net.java.sip.communicator.impl.protocol.sip.ContactSipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetBasicInstantMessagingSipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetPresenceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.SipMessageProcessor;
import net.java.sip.communicator.impl.protocol.sip.SipStackSharing;
import net.java.sip.communicator.service.protocol.AbstractOperationSetTypingNotifications;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.Message;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.MessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.MessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.MessageListener;
import net.java.sip.communicator.service.protocol.event.MessageReceivedEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Logger;
import org.jitsi.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class OperationSetTypingNotificationsSipImpl
extends AbstractOperationSetTypingNotifications<ProtocolProviderServiceSipImpl>
implements SipMessageProcessor,
MessageListener {
    private static final Logger logger = Logger.getLogger(OperationSetTypingNotificationsSipImpl.class);
    private OperationSetPresenceSipImpl opSetPersPresence = null;
    private OperationSetBasicInstantMessagingSipImpl opSetBasicIm = null;
    private final RegistrationStateListener registrationListener;
    private static final String CONTENT_TYPE = "application/im-iscomposing+xml";
    private static final String CONTENT_SUBTYPE = "im-iscomposing+xml";
    private static final String NS_VALUE = "urn:ietf:params:xml:ns:im-iscomposing";
    private static final String STATE_ELEMENT = "state";
    private static final String REFRESH_ELEMENT = "refresh";
    private static final int REFRESH_DEFAULT_TIME = 120;
    private static final int REFRESH_TIME = 60;
    private static final String COMPOSING_STATE_ACTIVE = "active";
    private static final String COMPOSING_STATE_IDLE = "idle";
    private Timer timer = new Timer();
    private final List<TypingTask> typingTasks = new Vector<TypingTask>();

    OperationSetTypingNotificationsSipImpl(ProtocolProviderServiceSipImpl provider, OperationSetBasicInstantMessagingSipImpl opSetBasicIm) {
        super((ProtocolProviderService)provider);
        this.registrationListener = new RegistrationStateListener();
        provider.addRegistrationStateChangeListener(this.registrationListener);
        this.opSetBasicIm = opSetBasicIm;
        opSetBasicIm.addMessageProcessor(this);
    }

    @Override
    public boolean processMessage(RequestEvent requestEvent) {
        Node refreshNode;
        NodeList stateList;
        String content = null;
        Request req = requestEvent.getRequest();
        ContentTypeHeader ctheader = (ContentTypeHeader)req.getHeader("Content-Type");
        if (ctheader == null || !ctheader.getContentSubType().equalsIgnoreCase(CONTENT_SUBTYPE)) {
            return true;
        }
        content = new String(req.getRawContent());
        if (content == null || content.length() == 0) {
            this.sendResponse(requestEvent, 400);
            return false;
        }
        FromHeader fromHeader = (FromHeader)requestEvent.getRequest().getHeader("From");
        if (fromHeader == null) {
            logger.error((Object)"received a request without a from header");
            return true;
        }
        ContactSipImpl from = this.opSetPersPresence.resolveContactID(fromHeader.getAddress().getURI().toString());
        if (from == null) {
            from = fromHeader.getAddress().getDisplayName() != null ? this.opSetPersPresence.createVolatileContact(fromHeader.getAddress().getURI().toString(), fromHeader.getAddress().getDisplayName().toString()) : this.opSetPersPresence.createVolatileContact(fromHeader.getAddress().getURI().toString());
        }
        Document doc = null;
        try {
            doc = this.opSetPersPresence.convertDocument(content);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (doc == null) {
            this.sendResponse(requestEvent, 400);
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("parsing:\n" + content));
        }
        if ((stateList = doc.getElementsByTagNameNS(NS_VALUE, STATE_ELEMENT)).getLength() == 0) {
            logger.error((Object)"no state element in this document");
            this.sendResponse(requestEvent, 400);
            return false;
        }
        Node stateNode = stateList.item(0);
        if (stateNode.getNodeType() != 1) {
            logger.error((Object)"the state node is not an element");
            this.sendResponse(requestEvent, 400);
            return false;
        }
        String state = XMLUtils.getText((Element)((Element)stateNode));
        if (state == null || state.length() == 0) {
            logger.error((Object)"the state element without value");
            this.sendResponse(requestEvent, 400);
            return false;
        }
        NodeList refreshList = doc.getElementsByTagNameNS(NS_VALUE, REFRESH_ELEMENT);
        int refresh = 120;
        if (refreshList.getLength() != 0 && (refreshNode = refreshList.item(0)).getNodeType() == 1) {
            String refreshStr = XMLUtils.getText((Element)((Element)refreshNode));
            try {
                refresh = Integer.parseInt(refreshStr);
            }
            catch (Exception e) {
                logger.error((Object)"Wrong content for refresh", (Throwable)e);
            }
        }
        if (state.equals(COMPOSING_STATE_ACTIVE)) {
            TypingTask task = this.findTypingTask((Contact)from);
            if (task != null) {
                this.typingTasks.remove(task);
                task.cancel();
            }
            task = new TypingTask((Contact)from, true);
            this.typingTasks.add(task);
            this.timer.schedule((TimerTask)task, refresh * 1000);
            this.fireTypingNotificationsEvent((Contact)from, 1);
        } else if (state.equals(COMPOSING_STATE_IDLE)) {
            this.fireTypingNotificationsEvent((Contact)from, 3);
        }
        this.sendResponse(requestEvent, 200);
        return false;
    }

    @Override
    public boolean processResponse(ResponseEvent responseEvent, Map<String, Message> sentMsg) {
        Request req = responseEvent.getClientTransaction().getRequest();
        ContentTypeHeader ctheader = (ContentTypeHeader)req.getHeader("Content-Type");
        if (ctheader == null || !ctheader.getContentSubType().equalsIgnoreCase(CONTENT_SUBTYPE)) {
            return true;
        }
        int status = responseEvent.getResponse().getStatusCode();
        String key = ((CallIdHeader)req.getHeader("Call-ID")).getCallId();
        if (status >= 200 && status < 300) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Ack received from the network : " + responseEvent.getResponse().getReasonPhrase()));
            }
            sentMsg.remove(key);
            return false;
        }
        if (status >= 400 && status != 401 && status != 407) {
            logger.warn((Object)("Error received : " + responseEvent.getResponse().getReasonPhrase()));
            sentMsg.remove(key);
            return false;
        }
        return true;
    }

    @Override
    public boolean processTimeout(TimeoutEvent timeoutEvent, Map<String, Message> sentMessages) {
        Request req = timeoutEvent.getClientTransaction().getRequest();
        ContentTypeHeader ctheader = (ContentTypeHeader)req.getHeader("Content-Type");
        return ctheader == null || !CONTENT_SUBTYPE.equalsIgnoreCase(ctheader.getContentSubType());
    }

    private TypingTask findTypingTask(Contact contact) {
        for (TypingTask typingTask : this.typingTasks) {
            if (!typingTask.getContact().equals(contact)) continue;
            return typingTask;
        }
        return null;
    }

    public void sendTypingNotification(Contact to, int typingState) throws IllegalStateException, IllegalArgumentException {
        Request messageRequest;
        Text stateValue;
        Element state;
        this.assertConnected();
        if (!(to instanceof ContactSipImpl)) {
            throw new IllegalArgumentException("The specified contact is not a Sip contact." + to);
        }
        Document doc = this.opSetPersPresence.createDocument();
        Element rootEl = doc.createElementNS(NS_VALUE, "isComposing");
        rootEl.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        doc.appendChild(rootEl);
        if (typingState == 1) {
            state = doc.createElement(STATE_ELEMENT);
            stateValue = doc.createTextNode(COMPOSING_STATE_ACTIVE);
            state.appendChild(stateValue);
            rootEl.appendChild(state);
            Element refresh = doc.createElement(REFRESH_ELEMENT);
            Text refreshValue = doc.createTextNode(String.valueOf(60));
            refresh.appendChild(refreshValue);
            rootEl.appendChild(refresh);
        } else if (typingState == 4) {
            state = doc.createElement(STATE_ELEMENT);
            stateValue = doc.createTextNode(COMPOSING_STATE_IDLE);
            state.appendChild(stateValue);
            rootEl.appendChild(state);
        } else {
            return;
        }
        Message message = this.opSetBasicIm.createMessage(this.opSetPersPresence.convertDocument(doc), CONTENT_TYPE, "UTF-8", null);
        try {
            messageRequest = this.opSetBasicIm.createMessageRequest(to, message);
        }
        catch (OperationFailedException ex) {
            logger.error((Object)"Failed to create the message.", (Throwable)ex);
            return;
        }
        try {
            this.opSetBasicIm.sendMessageRequest(messageRequest, to, message);
        }
        catch (TransactionUnavailableException ex) {
            logger.error((Object)"Failed to create messageTransaction.\nThis is most probably a network connection error.", (Throwable)ex);
            return;
        }
        catch (SipException ex) {
            logger.error((Object)"Failed to send the message.", (Throwable)ex);
            return;
        }
    }

    private void sendResponse(RequestEvent requestEvent, int response) {
        block4: {
            try {
                Response ok = ((ProtocolProviderServiceSipImpl)this.parentProvider).getMessageFactory().createResponse(response, requestEvent.getRequest());
                SipStackSharing.getOrCreateServerTransaction(requestEvent).sendResponse(ok);
            }
            catch (ParseException exc) {
                logger.error((Object)"failed to build the response", (Throwable)exc);
            }
            catch (SipException exc) {
                logger.error((Object)("failed to send the response : " + exc.getMessage()), (Throwable)exc);
            }
            catch (InvalidArgumentException exc) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug((Object)("Invalid argument for createResponse : " + exc.getMessage()), (Throwable)exc);
            }
        }
    }

    public void messageReceived(MessageReceivedEvent evt) {
        Contact from = evt.getSourceContact();
        TypingTask task = this.findTypingTask(from);
        if (task != null) {
            task.cancel();
            this.fireTypingNotificationsEvent(from, 4);
        }
    }

    public void messageDelivered(MessageDeliveredEvent evt) {
    }

    public void messageDeliveryFailed(MessageDeliveryFailedEvent evt) {
    }

    void shutdown() {
        ((ProtocolProviderServiceSipImpl)this.parentProvider).removeRegistrationStateChangeListener(this.registrationListener);
    }

    private class TypingTask
    extends TimerTask {
        private final Contact contact;

        TypingTask(Contact contact, boolean receiving) {
            this.contact = contact;
        }

        @Override
        public void run() {
            OperationSetTypingNotificationsSipImpl.this.typingTasks.remove(this);
            OperationSetTypingNotificationsSipImpl.this.fireTypingNotificationsEvent(this.contact, 4);
        }

        public Contact getContact() {
            return this.contact;
        }
    }

    private class RegistrationStateListener
    implements RegistrationStateChangeListener {
        private RegistrationStateListener() {
        }

        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The provider changed state from: " + evt.getOldState() + " to: " + evt.getNewState()));
            }
            if (evt.getNewState() == RegistrationState.REGISTERED) {
                OperationSetTypingNotificationsSipImpl.this.opSetPersPresence = (OperationSetPresenceSipImpl)((ProtocolProviderServiceSipImpl)OperationSetTypingNotificationsSipImpl.this.parentProvider).getOperationSet(OperationSetPersistentPresence.class);
            }
        }
    }
}

