/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sm.provider;

import java.io.IOException;
import java.util.ArrayList;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.StanzaErrorTextElement;
import org.jivesoftware.smack.sm.packet.StreamManagement;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class ParseStreamManagement {
    public static StreamManagement.Enabled enabled(XmlPullParser parser) throws XmlPullParserException, IOException {
        ParserUtils.assertAtStartTag((XmlPullParser)parser);
        boolean resume = ParserUtils.getBooleanAttribute((XmlPullParser)parser, (String)"resume", (boolean)false);
        String id = parser.getAttributeValue("", "id");
        String location = parser.getAttributeValue("", "location");
        int max = ParserUtils.getIntegerAttribute((XmlPullParser)parser, (String)"max", (int)-1);
        parser.next();
        ParserUtils.assertAtEndTag((XmlPullParser)parser);
        return new StreamManagement.Enabled(id, resume, location, max);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static StreamManagement.Failed failed(XmlPullParser parser) throws XmlPullParserException, IOException {
        ParserUtils.assertAtStartTag((XmlPullParser)parser);
        StanzaError.Condition condition = null;
        ArrayList<StanzaErrorTextElement> textElements = new ArrayList<StanzaErrorTextElement>(4);
        block4: while (true) {
            XmlPullParser.Event event = parser.next();
            switch (event) {
                case START_ELEMENT: {
                    String name = parser.getName();
                    String namespace = parser.getNamespace();
                    if (!"urn:ietf:params:xml:ns:xmpp-stanzas".equals(namespace)) break;
                    if (name.equals("text")) {
                        String lang = ParserUtils.getXmlLang((XmlPullParser)parser);
                        String text = parser.nextText();
                        StanzaErrorTextElement stanzaErrorTextElement = new StanzaErrorTextElement(text, lang);
                        textElements.add(stanzaErrorTextElement);
                        break;
                    }
                    condition = StanzaError.Condition.fromString((String)name);
                    break;
                }
                case END_ELEMENT: {
                    String name = parser.getName();
                    if ("failed".equals(name)) break block4;
                }
            }
        }
        ParserUtils.assertAtEndTag((XmlPullParser)parser);
        return new StreamManagement.Failed(condition, textElements);
    }

    public static StreamManagement.Resumed resumed(XmlPullParser parser) throws XmlPullParserException, IOException {
        ParserUtils.assertAtStartTag((XmlPullParser)parser);
        long h = ParserUtils.getLongAttribute((XmlPullParser)parser, (String)"h");
        String previd = parser.getAttributeValue("", "previd");
        parser.next();
        ParserUtils.assertAtEndTag((XmlPullParser)parser);
        return new StreamManagement.Resumed(h, previd);
    }

    public static StreamManagement.AckAnswer ackAnswer(XmlPullParser parser) throws XmlPullParserException, IOException {
        ParserUtils.assertAtStartTag((XmlPullParser)parser);
        long h = ParserUtils.getLongAttribute((XmlPullParser)parser, (String)"h");
        parser.next();
        ParserUtils.assertAtEndTag((XmlPullParser)parser);
        return new StreamManagement.AckAnswer(h);
    }

    public static StreamManagement.AckRequest ackRequest(XmlPullParser parser) throws XmlPullParserException, IOException {
        ParserUtils.assertAtStartTag((XmlPullParser)parser);
        parser.next();
        ParserUtils.assertAtEndTag((XmlPullParser)parser);
        return StreamManagement.AckRequest.INSTANCE;
    }
}

