/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.staging.deploy;

import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.sonatype.nexus.maven.staging.AbstractStagingMojo;
import org.sonatype.nexus.maven.staging.deploy.strategy.DeployStrategy;
import org.sonatype.nexus.maven.staging.remote.Parameters;

public abstract class AbstractDeployMojo
extends AbstractStagingMojo {
    @Component(role=DeployStrategy.class)
    private Map<String, DeployStrategy> deployStrategies;
    @Parameter(property="stagingProfileId")
    private String stagingProfileId;
    @Parameter(property="stagingRepositoryId")
    private String stagingRepositoryId;
    @Parameter
    private Map<String, String> tags;
    @Parameter(property="keepStagingRepositoryOnFailure")
    private boolean keepStagingRepositoryOnFailure;
    @Parameter(property="skipStagingRepositoryClose")
    private boolean skipStagingRepositoryClose;
    @Parameter(property="skipStaging")
    private boolean skipStaging;

    protected DeployStrategy getDeployStrategy(String key) throws MojoExecutionException {
        DeployStrategy deployStrategy = this.deployStrategies.get(key);
        if (deployStrategy == null) {
            throw new MojoExecutionException("DeployStrategy " + key + " not found!");
        }
        return deployStrategy;
    }

    @Override
    protected Parameters buildParameters() throws MojoExecutionException {
        try {
            Parameters parameters = super.buildParameters();
            parameters.setKeepStagingRepositoryOnFailure(this.isKeepStagingRepositoryOnFailure());
            parameters.setSkipStagingRepositoryClose(this.isSkipStagingRepositoryClose());
            parameters.setStagingProfileId(this.getStagingProfileId());
            parameters.setStagingRepositoryId(this.getStagingRepositoryId());
            parameters.setTags(this.getTags());
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)parameters.toString());
            }
            return parameters;
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Bad configuration:" + e.getMessage(), e);
        }
    }

    protected String getStagingProfileId() {
        return this.stagingProfileId;
    }

    protected String getStagingRepositoryId() {
        return this.stagingRepositoryId;
    }

    protected Map<String, String> getTags() {
        return this.tags;
    }

    protected boolean isKeepStagingRepositoryOnFailure() {
        return this.keepStagingRepositoryOnFailure;
    }

    protected boolean isSkipStagingRepositoryClose() {
        return this.skipStagingRepositoryClose;
    }

    protected boolean isSkipStaging() {
        return this.skipStaging;
    }
}

