/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Resource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Manifest;
import org.apache.felix.bundleplugin.BundlePlugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class ManifestPlugin
extends BundlePlugin {
    protected boolean rebuildBundle;

    protected void execute(MavenProject project, Map instructions, Properties properties, Jar[] classpath) throws MojoExecutionException {
        Manifest manifest;
        try {
            manifest = this.getManifest(project, instructions, properties, classpath);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Cannot find " + e.getMessage() + " (manifest goal must be run after compile phase)", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error trying to generate Manifest", (Exception)e);
        }
        catch (MojoFailureException e) {
            this.getLog().error((CharSequence)e.getLocalizedMessage());
            throw new MojoExecutionException("Error(s) found in manifest configuration", (Exception)((Object)e));
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"An internal error occurred", (Throwable)e);
            throw new MojoExecutionException("Internal error in maven-bundle-plugin", e);
        }
        File outputFile = new File(this.manifestLocation, "MANIFEST.MF");
        try {
            ManifestPlugin.writeManifest(manifest, outputFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error trying to write Manifest to file " + outputFile, (Exception)e);
        }
    }

    public Manifest getManifest(MavenProject project, Jar[] classpath) throws IOException, MojoFailureException, MojoExecutionException, Exception {
        return this.getManifest(project, new LinkedHashMap(), new Properties(), classpath);
    }

    public Manifest getManifest(MavenProject project, Map instructions, Properties properties, Jar[] classpath) throws IOException, MojoFailureException, MojoExecutionException, Exception {
        String failok;
        Analyzer analyzer = this.getAnalyzer(project, instructions, properties, classpath);
        boolean hasErrors = this.reportErrors("Manifest " + project.getArtifact(), analyzer);
        if (hasErrors && (null == (failok = analyzer.getProperty("-failok")) || "false".equalsIgnoreCase(failok))) {
            throw new MojoFailureException("Error(s) found in manifest configuration");
        }
        Jar jar = analyzer.getJar();
        if (this.unpackBundle) {
            File outputFile = this.getOutputDirectory();
            for (Map.Entry entry : jar.getResources().entrySet()) {
                File entryFile = new File(outputFile, (String)entry.getKey());
                if (entryFile.exists() && ((Resource)entry.getValue()).lastModified() != 0L) continue;
                entryFile.getParentFile().mkdirs();
                FileOutputStream os = new FileOutputStream(entryFile);
                ((Resource)entry.getValue()).write((OutputStream)os);
                ((OutputStream)os).close();
            }
        }
        Manifest manifest = jar.getManifest();
        analyzer.close();
        return manifest;
    }

    protected Analyzer getAnalyzer(MavenProject project, Jar[] classpath) throws IOException, MojoExecutionException, Exception {
        return this.getAnalyzer(project, new LinkedHashMap(), new Properties(), classpath);
    }

    protected Analyzer getAnalyzer(MavenProject project, Map instructions, Properties properties, Jar[] classpath) throws IOException, MojoExecutionException, Exception {
        if (this.rebuildBundle && this.supportedProjectTypes.contains(project.getArtifact().getType())) {
            return this.buildOSGiBundle(project, instructions, properties, classpath);
        }
        File file = project.getArtifact().getFile();
        if (file == null) {
            file = this.getOutputDirectory();
        }
        if (!file.exists()) {
            if (file.equals(this.getOutputDirectory())) {
                file.mkdirs();
            } else {
                throw new FileNotFoundException(file.getPath());
            }
        }
        Builder analyzer = this.getOSGiBuilder(project, instructions, properties, classpath);
        analyzer.setJar(file);
        boolean isOutputDirectory = file.equals(this.getOutputDirectory());
        if (analyzer.getProperty("Export-Package") == null && analyzer.getProperty("-exportcontents") == null && analyzer.getProperty("Private-Package") == null && !isOutputDirectory) {
            String export = ManifestPlugin.calculateExportsFromContents(analyzer.getJar());
            analyzer.setProperty("Export-Package", export);
        }
        this.addMavenInstructions(project, analyzer);
        if (analyzer.getProperty("Embed-Dependency") != null && isOutputDirectory) {
            analyzer.build();
        } else {
            analyzer.mergeManifest(analyzer.getJar().getManifest());
            analyzer.getJar().setManifest(analyzer.calcManifest());
        }
        this.mergeMavenManifest(project, analyzer);
        return analyzer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeManifest(Manifest manifest, File outputFile) throws IOException {
        outputFile.getParentFile().mkdirs();
        FileOutputStream os = new FileOutputStream(outputFile);
        try {
            Jar.writeManifest((Manifest)manifest, (OutputStream)os);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String calculateExportsFromContents(Jar bundle) {
        String ddel = "";
        StringBuffer sb = new StringBuffer();
        Map map = bundle.getDirectories();
        for (Map.Entry entry : map.entrySet()) {
            String directory;
            if (entry.getValue() == null || ((Map)entry.getValue()).isEmpty() || (directory = (String)entry.getKey()).equals("META-INF") || directory.startsWith("META-INF/") || directory.equals("OSGI-OPT") || directory.startsWith("OSGI-OPT/") || directory.equals("/")) continue;
            if (directory.endsWith("/")) {
                directory = directory.substring(0, directory.length() - 1);
            }
            directory = directory.replace('/', '.');
            sb.append(ddel);
            sb.append(directory);
            ddel = ",";
        }
        return sb.toString();
    }
}

