/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.staging.client.internal;

import com.sonatype.nexus.staging.api.dto.StagingRuleFailureDTO;
import com.sonatype.nexus.staging.api.dto.StagingRuleFailuresDTO;
import com.sonatype.nexus.staging.client.StagingRuleFailures;
import com.sonatype.nexus.staging.client.StagingRuleFailuresException;
import com.sonatype.nexus.staging.client.internal.StagingWorkflowV2ServiceImpl;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.util.ArrayList;
import java.util.Arrays;
import org.sonatype.nexus.client.core.exception.NexusClientException;
import org.sonatype.nexus.client.core.exception.NexusClientResponseException;
import org.sonatype.nexus.client.internal.util.Check;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;

public abstract class ExceptionConverter<E> {
    private final StagingWorkflowV2ServiceImpl jerseyStagingWorkflow;

    public ExceptionConverter(StagingWorkflowV2ServiceImpl jerseyStagingWorkflow) {
        this.jerseyStagingWorkflow = (StagingWorkflowV2ServiceImpl)Check.notNull((Object)jerseyStagingWorkflow, StagingWorkflowV2ServiceImpl.class);
    }

    public final E runAndReturn() {
        try {
            return this.perform();
        }
        catch (UniformInterfaceException e) {
            throw this.handleUniformInterfaceException(e);
        }
    }

    protected NexusClientException handleUniformInterfaceException(UniformInterfaceException e) {
        NexusClientException exception = ((JerseyNexusClient)this.jerseyStagingWorkflow.getNexusClient()).convertIfKnown(e);
        if (exception != null) {
            return exception;
        }
        ClientResponse clientResponse = e.getResponse();
        if (!clientResponse.hasEntity()) {
            return ((JerseyNexusClient)this.jerseyStagingWorkflow.getNexusClient()).convert(e);
        }
        String responseBody = ((JerseyNexusClient)this.jerseyStagingWorkflow.getNexusClient()).getResponseBody(clientResponse);
        try {
            StagingRuleFailuresDTO failuresDto = (StagingRuleFailuresDTO)clientResponse.getEntity(StagingRuleFailuresDTO.class);
            ArrayList<StagingRuleFailures.RuleFailure> ruleFailures = new ArrayList<StagingRuleFailures.RuleFailure>();
            for (StagingRuleFailureDTO failureDto : failuresDto.getFailures()) {
                ruleFailures.add(new StagingRuleFailures.RuleFailure(failureDto.getRuleName(), failureDto.getMessages()));
            }
            StagingRuleFailures failure = new StagingRuleFailures("n/a", ruleFailures);
            return new StagingRuleFailuresException(clientResponse.getClientResponseStatus().getStatusCode(), clientResponse.getClientResponseStatus().getReasonPhrase(), Arrays.asList(failure), responseBody);
        }
        catch (Exception ignore) {
            return new NexusClientResponseException(clientResponse.getClientResponseStatus().getReasonPhrase() + " : entity body dump follows: " + responseBody, clientResponse.getClientResponseStatus().getStatusCode(), clientResponse.getClientResponseStatus().getReasonPhrase(), responseBody);
        }
    }

    public abstract E perform();
}

