/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository.maven;

import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.client.core.subsystem.repository.Repository;
import org.sonatype.nexus.client.core.subsystem.repository.maven.MavenGroupRepository;
import org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository.JerseyGroupRepositoryFactory;
import org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository.maven.JerseyMavenGroupRepository;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;
import org.sonatype.nexus.rest.model.RepositoryBaseResource;
import org.sonatype.nexus.rest.model.RepositoryGroupResource;

@Named
@Singleton
public class JerseyMavenGroupRepositoryFactory
extends JerseyGroupRepositoryFactory {
    @Override
    public int canAdapt(RepositoryBaseResource resource) {
        int score = super.canAdapt(resource);
        if (score > 0 && "maven2".equals(resource.getProvider())) {
            ++score;
        }
        return score;
    }

    @Override
    public JerseyMavenGroupRepository adapt(JerseyNexusClient nexusClient, RepositoryBaseResource resource) {
        return new JerseyMavenGroupRepository(nexusClient, (RepositoryGroupResource)resource);
    }

    @Override
    public boolean canCreate(Class<? extends Repository> type) {
        return MavenGroupRepository.class.equals(type);
    }

    @Override
    public JerseyMavenGroupRepository create(JerseyNexusClient nexusClient, String id) {
        return new JerseyMavenGroupRepository(nexusClient, id);
    }
}

