/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.format;

import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.media.Format;
import javax.media.format.VideoFormat;
import org.jitsi.impl.neomedia.format.MediaFormatImpl;
import org.jitsi.impl.neomedia.format.VideoMediaFormatImpl;

public class ParameterizedVideoFormat
extends VideoFormat {
    private static final long serialVersionUID = 0L;
    private Map<String, String> fmtps;

    public ParameterizedVideoFormat(String encoding, Dimension size, int maxDataLength, Class<?> dataType, float frameRate, Map<String, String> fmtps) {
        super(encoding, size, maxDataLength, dataType, frameRate);
        this.fmtps = fmtps == null || fmtps.isEmpty() ? MediaFormatImpl.EMPTY_FORMAT_PARAMETERS : new HashMap<String, String>(fmtps);
    }

    public ParameterizedVideoFormat(String encoding, Map<String, String> fmtps) {
        super(encoding);
        this.fmtps = fmtps == null || fmtps.isEmpty() ? MediaFormatImpl.EMPTY_FORMAT_PARAMETERS : new HashMap<String, String>(fmtps);
    }

    public ParameterizedVideoFormat(String encoding, String ... fmtps) {
        this(encoding, ParameterizedVideoFormat.toMap(fmtps));
    }

    public Object clone() {
        ParameterizedVideoFormat f = new ParameterizedVideoFormat(this.getEncoding(), this.getSize(), this.getMaxDataLength(), this.getDataType(), this.getFrameRate(), null);
        f.copy((Format)this);
        return f;
    }

    protected void copy(Format f) {
        super.copy(f);
        if (f instanceof ParameterizedVideoFormat) {
            ParameterizedVideoFormat pvf = (ParameterizedVideoFormat)f;
            Map<String, String> pvfFmtps = pvf.getFormatParameters();
            this.fmtps = pvfFmtps == null || pvfFmtps.isEmpty() ? MediaFormatImpl.EMPTY_FORMAT_PARAMETERS : new HashMap<String, String>(pvfFmtps);
        }
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        Map<String, String> objFmtps = null;
        if (obj instanceof ParameterizedVideoFormat) {
            objFmtps = ((ParameterizedVideoFormat)((Object)obj)).getFormatParameters();
        }
        return VideoMediaFormatImpl.formatParametersAreEqual(this.getEncoding(), this.getFormatParameters(), objFmtps);
    }

    public boolean formatParametersMatch(Format format) {
        Map<String, String> formatFmtps = null;
        if (format instanceof ParameterizedVideoFormat) {
            formatFmtps = ((ParameterizedVideoFormat)format).getFormatParameters();
        }
        return VideoMediaFormatImpl.formatParametersMatch(this.getEncoding(), this.getFormatParameters(), formatFmtps);
    }

    public String getFormatParameter(String name) {
        return this.fmtps.get(name);
    }

    public Map<String, String> getFormatParameters() {
        return new HashMap<String, String>(this.fmtps);
    }

    public Format intersects(Format format) {
        Format intersection = super.intersects(format);
        if (intersection == null) {
            return null;
        }
        ((ParameterizedVideoFormat)intersection).fmtps = this.fmtps.isEmpty() ? MediaFormatImpl.EMPTY_FORMAT_PARAMETERS : this.getFormatParameters();
        return intersection;
    }

    public boolean matches(Format format) {
        return super.matches(format) && this.formatParametersMatch(format);
    }

    public static <T> Map<T, T> toMap(T ... entries) {
        HashMap<T, T> map;
        if (entries == null || entries.length == 0) {
            map = null;
        } else {
            map = new HashMap<T, T>();
            for (int i = 0; i < entries.length; ++i) {
                map.put(entries[i++], entries[i]);
            }
        }
        return map;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(super.toString());
        s.append(", fmtps={");
        for (Map.Entry<String, String> fmtp : this.fmtps.entrySet()) {
            s.append(fmtp.getKey());
            s.append('=');
            s.append(fmtp.getValue());
            s.append(',');
        }
        int lastIndex = s.length() - 1;
        if (s.charAt(lastIndex) == ',') {
            s.setCharAt(lastIndex, '}');
        } else {
            s.append('}');
        }
        return s.toString();
    }
}

