/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.silk;

import java.util.Arrays;
import org.jitsi.impl.neomedia.codec.audio.silk.Inlines;
import org.jitsi.impl.neomedia.codec.audio.silk.MA;
import org.jitsi.impl.neomedia.codec.audio.silk.Macros;
import org.jitsi.impl.neomedia.codec.audio.silk.SKP_Silk_decoder_control;
import org.jitsi.impl.neomedia.codec.audio.silk.SKP_Silk_decoder_state;
import org.jitsi.impl.neomedia.codec.audio.silk.SigProcFIX;
import org.jitsi.impl.neomedia.codec.audio.silk.TablesOther;
import org.jitsi.impl.neomedia.codec.audio.silk.Typedef;

public class DecodeCore {
    static void SKP_Silk_decode_core(SKP_Silk_decoder_state psDec, SKP_Silk_decoder_control psDecCtrl, short[] xq, int xq_offset, int[] q) {
        int i;
        int lag = 0;
        short[] A_Q12_tmp = new short[16];
        short[] sLTP = new short[480];
        int[] vec_Q10 = new int[120];
        int[] FiltState = new int[16];
        Typedef.SKP_assert(psDec.prev_inv_gain_Q16 != 0);
        short offset_Q10 = TablesOther.SKP_Silk_Quantization_Offsets_Q10[psDecCtrl.sigtype][psDecCtrl.QuantOffsetType];
        int NLSF_interpolation_flag = psDecCtrl.NLSFInterpCoef_Q2 < 4 ? 1 : 0;
        int rand_seed = psDecCtrl.Seed;
        for (i = 0; i < psDec.frame_length; ++i) {
            rand_seed = SigProcFIX.SKP_RAND(rand_seed);
            int dither = rand_seed >> 31;
            psDec.exc_Q10[i] = (q[i] << 10) + offset_Q10;
            psDec.exc_Q10[i] = (psDec.exc_Q10[i] ^ dither) - dither;
            rand_seed += q[i];
        }
        int[] pexc_Q10 = psDec.exc_Q10;
        int pexc_Q10_offset = 0;
        int[] pres_Q10 = psDec.res_Q10;
        int pres_Q10_offset = 0;
        short[] pxq = psDec.outBuf;
        int pxq_offset = psDec.frame_length;
        int sLTP_buf_idx = psDec.frame_length;
        for (int k = 0; k < 4; ++k) {
            short[] A_Q12 = psDecCtrl.PredCoef_Q12[k >> 1];
            System.arraycopy(A_Q12, 0, A_Q12_tmp, 0, psDec.LPC_order);
            short[] B_Q14 = psDecCtrl.LTPCoef_Q14;
            int B_Q14_offset = k * 5;
            int Gain_Q16 = psDecCtrl.Gains_Q16[k];
            int sigtype = psDecCtrl.sigtype;
            int inv_gain_Q16 = Integer.MAX_VALUE / (Gain_Q16 >> 1);
            inv_gain_Q16 = Math.min(inv_gain_Q16, Short.MAX_VALUE);
            int gain_adj_Q16 = 65536;
            if (inv_gain_Q16 != psDec.prev_inv_gain_Q16) {
                gain_adj_Q16 = Inlines.SKP_DIV32_varQ(inv_gain_Q16, psDec.prev_inv_gain_Q16, 16);
            }
            if (psDec.lossCnt != 0 && psDec.prev_sigtype == 0 && psDecCtrl.sigtype == 1 && k < 2) {
                Arrays.fill(B_Q14, B_Q14_offset, B_Q14_offset + 5, (short)0);
                B_Q14[B_Q14_offset + 2] = 4096;
                sigtype = 0;
                psDecCtrl.pitchL[k] = psDec.lagPrev;
            }
            if (sigtype == 0) {
                lag = psDecCtrl.pitchL[k];
                if ((k & 3 - (NLSF_interpolation_flag << 1)) == 0) {
                    int start_idx = psDec.frame_length - lag - psDec.LPC_order - 2;
                    Typedef.SKP_assert(start_idx >= 0);
                    Typedef.SKP_assert(start_idx <= psDec.frame_length - psDec.LPC_order);
                    Arrays.fill(FiltState, 0, psDec.LPC_order, 0);
                    MA.SKP_Silk_MA_Prediction(psDec.outBuf, start_idx + k * (psDec.frame_length >> 2), A_Q12, 0, FiltState, sLTP, start_idx, psDec.frame_length - start_idx, psDec.LPC_order);
                    int inv_gain_Q32 = inv_gain_Q16 << 16;
                    if (k == 0) {
                        inv_gain_Q32 = Macros.SKP_SMULWB(inv_gain_Q32, psDecCtrl.LTP_scale_Q14) << 2;
                    }
                    for (i = 0; i < lag + 2; ++i) {
                        psDec.sLTP_Q16[sLTP_buf_idx - i - 1] = Macros.SKP_SMULWB(inv_gain_Q32, sLTP[psDec.frame_length - i - 1]);
                    }
                } else if (gain_adj_Q16 != 65536) {
                    for (i = 0; i < lag + 2; ++i) {
                        psDec.sLTP_Q16[sLTP_buf_idx - i - 1] = Macros.SKP_SMULWW(gain_adj_Q16, psDec.sLTP_Q16[sLTP_buf_idx - i - 1]);
                    }
                }
            }
            for (i = 0; i < 16; ++i) {
                psDec.sLPC_Q14[i] = Macros.SKP_SMULWW(gain_adj_Q16, psDec.sLPC_Q14[i]);
            }
            Typedef.SKP_assert(inv_gain_Q16 != 0);
            psDec.prev_inv_gain_Q16 = inv_gain_Q16;
            if (sigtype == 0) {
                int[] pred_lag_ptr = psDec.sLTP_Q16;
                int pred_lag_ptr_offset = sLTP_buf_idx - lag + 2;
                for (i = 0; i < psDec.subfr_length; ++i) {
                    int LTP_pred_Q14 = Macros.SKP_SMULWB(pred_lag_ptr[pred_lag_ptr_offset + 0], B_Q14[B_Q14_offset + 0]);
                    LTP_pred_Q14 = Macros.SKP_SMLAWB(LTP_pred_Q14, pred_lag_ptr[pred_lag_ptr_offset - 1], B_Q14[B_Q14_offset + 1]);
                    LTP_pred_Q14 = Macros.SKP_SMLAWB(LTP_pred_Q14, pred_lag_ptr[pred_lag_ptr_offset - 2], B_Q14[B_Q14_offset + 2]);
                    LTP_pred_Q14 = Macros.SKP_SMLAWB(LTP_pred_Q14, pred_lag_ptr[pred_lag_ptr_offset - 3], B_Q14[B_Q14_offset + 3]);
                    LTP_pred_Q14 = Macros.SKP_SMLAWB(LTP_pred_Q14, pred_lag_ptr[pred_lag_ptr_offset - 4], B_Q14[B_Q14_offset + 4]);
                    ++pred_lag_ptr_offset;
                    pres_Q10[pres_Q10_offset + i] = pexc_Q10[pexc_Q10_offset + i] + SigProcFIX.SKP_RSHIFT_ROUND(LTP_pred_Q14, 4);
                    psDec.sLTP_Q16[sLTP_buf_idx] = pres_Q10[pres_Q10_offset + i] << 6;
                    ++sLTP_buf_idx;
                }
            } else {
                System.arraycopy(pexc_Q10, pexc_Q10_offset, pres_Q10, pres_Q10_offset, psDec.subfr_length);
            }
            DecodeCore.SKP_Silk_decode_short_term_prediction(vec_Q10, pres_Q10, pres_Q10_offset, psDec.sLPC_Q14, A_Q12_tmp, psDec.LPC_order, psDec.subfr_length);
            for (i = 0; i < psDec.subfr_length; ++i) {
                pxq[pxq_offset + i] = (short)SigProcFIX.SKP_SAT16(SigProcFIX.SKP_RSHIFT_ROUND(Macros.SKP_SMULWW(vec_Q10[i], Gain_Q16), 10));
            }
            System.arraycopy(psDec.sLPC_Q14, psDec.subfr_length, psDec.sLPC_Q14, 0, 16);
            pexc_Q10_offset += psDec.subfr_length;
            pres_Q10_offset += psDec.subfr_length;
            pxq_offset += psDec.subfr_length;
        }
        System.arraycopy(psDec.outBuf, psDec.frame_length, xq, xq_offset, psDec.frame_length);
    }

    private static void SKP_Silk_decode_short_term_prediction(int[] vec_Q10, int[] pres_Q10, int pres_Q10_offset, int[] sLPC_Q14, short[] A_Q12_tmp, int LPC_order, int subfr_length) {
        for (int i = 0; i < subfr_length; ++i) {
            int LPC_pred_Q10 = Macros.SKP_SMULWB(sLPC_Q14[16 + i - 1], A_Q12_tmp[0]);
            LPC_pred_Q10 = Macros.SKP_SMLAWB(LPC_pred_Q10, sLPC_Q14[16 + i - 2], A_Q12_tmp[1]);
            LPC_pred_Q10 = Macros.SKP_SMLAWB(LPC_pred_Q10, sLPC_Q14[16 + i - 3], A_Q12_tmp[2]);
            LPC_pred_Q10 = Macros.SKP_SMLAWB(LPC_pred_Q10, sLPC_Q14[16 + i - 4], A_Q12_tmp[3]);
            LPC_pred_Q10 = Macros.SKP_SMLAWB(LPC_pred_Q10, sLPC_Q14[16 + i - 5], A_Q12_tmp[4]);
            LPC_pred_Q10 = Macros.SKP_SMLAWB(LPC_pred_Q10, sLPC_Q14[16 + i - 6], A_Q12_tmp[5]);
            LPC_pred_Q10 = Macros.SKP_SMLAWB(LPC_pred_Q10, sLPC_Q14[16 + i - 7], A_Q12_tmp[6]);
            LPC_pred_Q10 = Macros.SKP_SMLAWB(LPC_pred_Q10, sLPC_Q14[16 + i - 8], A_Q12_tmp[7]);
            LPC_pred_Q10 = Macros.SKP_SMLAWB(LPC_pred_Q10, sLPC_Q14[16 + i - 9], A_Q12_tmp[8]);
            LPC_pred_Q10 = Macros.SKP_SMLAWB(LPC_pred_Q10, sLPC_Q14[16 + i - 10], A_Q12_tmp[9]);
            for (int j = 10; j < LPC_order; ++j) {
                LPC_pred_Q10 = Macros.SKP_SMLAWB(LPC_pred_Q10, sLPC_Q14[16 + i - j - 1], A_Q12_tmp[j]);
            }
            vec_Q10[i] = pres_Q10[pres_Q10_offset + i] + LPC_pred_Q10;
            sLPC_Q14[16 + i] = vec_Q10[i] << 4;
        }
    }
}

