/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.g722;

import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.codec.audio.g722.JNIDecoder;

public class JNIDecoderImpl
extends AbstractCodec2 {
    static final Format[] SUPPORTED_INPUT_FORMATS = new Format[]{new AudioFormat("g722/rtp", 8000.0, -1, 1)};
    static final Format[] SUPPORTED_OUTPUT_FORMATS = new Format[]{new AudioFormat("LINEAR", 16000.0, 16, 1, 0, 1, -1, -1.0, Format.byteArray)};
    private long decoder;

    public JNIDecoderImpl() {
        super("G.722 JNI Decoder", AudioFormat.class, SUPPORTED_OUTPUT_FORMATS);
        this.inputFormats = SUPPORTED_INPUT_FORMATS;
    }

    @Override
    protected void doClose() {
        JNIDecoder.g722_decoder_close((long)this.decoder);
    }

    @Override
    protected void doOpen() throws ResourceUnavailableException {
        this.decoder = JNIDecoder.g722_decoder_open();
        if (this.decoder == 0L) {
            throw new ResourceUnavailableException("g722_decoder_open");
        }
    }

    @Override
    protected int doProcess(Buffer inputBuffer, Buffer outputBuffer) {
        byte[] input = (byte[])inputBuffer.getData();
        int outputOffset = outputBuffer.getOffset();
        int outputLength = inputBuffer.getLength() * 4;
        byte[] output = JNIDecoderImpl.validateByteArraySize(outputBuffer, outputOffset + outputLength, true);
        JNIDecoder.g722_decoder_process((long)this.decoder, (byte[])input, (int)inputBuffer.getOffset(), (byte[])output, (int)outputOffset, (int)outputLength);
        outputBuffer.setDuration((long)outputLength * 1000000L / 32L);
        outputBuffer.setFormat(this.getOutputFormat());
        outputBuffer.setLength(outputLength);
        return 0;
    }
}

