/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.version;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.version.Version;
import org.jitsi.service.version.VersionService;
import org.jitsi.version.CurrentVersion;
import org.jitsi.version.VersionImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public abstract class AbstractVersionActivator
implements BundleActivator {
    private final Logger logger = Logger.getLogger(AbstractVersionActivator.class);
    private static final Pattern PARSE_VERSION_STRING_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.([\\d\\.]+)");
    private static BundleContext bundleContext;
    private VersionImpl currentVersion;

    protected abstract CurrentVersion getCurrentVersion();

    public void start(BundleContext context) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Started.");
        }
        bundleContext = context;
        CurrentVersion currentVersion = this.getCurrentVersion();
        this.currentVersion = new VersionImpl(currentVersion.getDefaultAppName(), currentVersion.getMajorVersion(), currentVersion.getMinorVersion(), currentVersion.getNightlyBuildID(), currentVersion.getPreReleaseID());
        VersionServiceImpl versionServiceImpl = new VersionServiceImpl();
        context.registerService(VersionService.class.getName(), (Object)versionServiceImpl, null);
        String applicationName = this.currentVersion.getApplicationName();
        String versionString = this.currentVersion.toString();
        this.logger.debug((Object)(this.currentVersion.getApplicationName() + " Version Service ... [REGISTERED]"));
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)(applicationName + " Version: " + applicationName + " " + versionString));
        }
        ConfigurationService cfg = AbstractVersionActivator.getConfigurationService();
        cfg.setProperty("sip-communicator.application.name", (Object)applicationName, true);
        cfg.setProperty("sip-communicator.version", (Object)versionString, true);
    }

    private static ConfigurationService getConfigurationService() {
        return (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
    }

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    public void stop(BundleContext context) throws Exception {
    }

    class VersionServiceImpl
    implements VersionService {
        VersionServiceImpl() {
        }

        public Version parseVersionString(String version) {
            Matcher matcher = PARSE_VERSION_STRING_PATTERN.matcher(version);
            if (matcher.matches() && matcher.groupCount() == 3) {
                return new VersionImpl(AbstractVersionActivator.this.currentVersion.getApplicationName(), Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), matcher.group(3), AbstractVersionActivator.this.currentVersion.getPreReleaseID());
            }
            return null;
        }

        public Version getCurrentVersion() {
            return AbstractVersionActivator.this.currentVersion;
        }
    }
}

