/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.webdav;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.wagon.InputData;
import org.apache.maven.wagon.OutputData;
import org.apache.maven.wagon.PathUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamWagon;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.providers.webdav.HttpConfiguration;
import org.apache.maven.wagon.providers.webdav.HttpMethodConfiguration;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.resource.Resource;
import org.apache.maven.wagon.shared.http.EncodingUtil;

public abstract class AbstractHttpClientWagon
extends StreamWagon {
    protected static final int SC_NULL = -1;
    protected static final TimeZone GMT_TIME_ZONE = TimeZone.getTimeZone("GMT");
    private HttpClient client;
    protected HttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
    private Properties httpHeaders;
    private HttpConfiguration httpConfiguration;
    private HttpMethod getMethod;

    public void openConnectionInternal() {
        this.repository.setUrl(this.getURL(this.repository));
        this.client = new HttpClient(this.connectionManager);
        this.client.getParams().setCookiePolicy("compatibility");
        String username = null;
        String password = null;
        String domain = null;
        if (this.authenticationInfo != null) {
            username = this.authenticationInfo.getUserName();
            if (StringUtils.contains((String)username, (String)"\\")) {
                String[] domainAndUsername = username.split("\\\\");
                domain = domainAndUsername[0];
                username = domainAndUsername[1];
            }
            password = this.authenticationInfo.getPassword();
        }
        String host = this.getRepository().getHost();
        if (StringUtils.isNotEmpty((String)username) && StringUtils.isNotEmpty(password)) {
            Object creds = domain != null ? new NTCredentials(username, password, host, domain) : new UsernamePasswordCredentials(username, password);
            int port = this.getRepository().getPort() > -1 ? this.getRepository().getPort() : -1;
            AuthScope scope = new AuthScope(host, port);
            this.client.getState().setCredentials(scope, (Credentials)creds);
        }
        HostConfiguration hc = new HostConfiguration();
        ProxyInfo proxyInfo = this.getProxyInfo(this.getRepository().getProtocol(), this.getRepository().getHost());
        if (proxyInfo != null) {
            String proxyUsername = proxyInfo.getUserName();
            String proxyPassword = proxyInfo.getPassword();
            String proxyHost = proxyInfo.getHost();
            int proxyPort = proxyInfo.getPort();
            String proxyNtlmHost = proxyInfo.getNtlmHost();
            String proxyNtlmDomain = proxyInfo.getNtlmDomain();
            if (proxyHost != null) {
                hc.setProxy(proxyHost, proxyPort);
                if (proxyUsername != null && proxyPassword != null) {
                    Object creds = proxyNtlmHost != null || proxyNtlmDomain != null ? new NTCredentials(proxyUsername, proxyPassword, proxyNtlmHost, proxyNtlmDomain) : new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                    int port = proxyInfo.getPort() > -1 ? proxyInfo.getPort() : -1;
                    AuthScope scope = new AuthScope(proxyHost, port);
                    this.client.getState().setProxyCredentials(scope, (Credentials)creds);
                }
            }
        }
        hc.setHost(host);
        this.client.setHostConfiguration(hc);
    }

    public void closeConnection() {
        if (this.connectionManager instanceof MultiThreadedHttpConnectionManager) {
            ((MultiThreadedHttpConnectionManager)this.connectionManager).shutdown();
        }
    }

    public void put(File source, String resourceName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(resourceName);
        this.firePutInitiated(resource, source);
        resource.setContentLength(source.length());
        resource.setLastModified(source.lastModified());
        this.put(null, resource, source);
    }

    public void putFromStream(InputStream stream, String destination, long contentLength, long lastModified) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(destination);
        this.firePutInitiated(resource, null);
        resource.setContentLength(contentLength);
        resource.setLastModified(lastModified);
        this.put(stream, resource, null);
    }

    private void put(InputStream stream, Resource resource, File source) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        RequestEntityImplementation requestEntityImplementation = new RequestEntityImplementation(stream, resource, (Wagon)this, source);
        this.put(resource, source, requestEntityImplementation, this.buildUrl(resource));
    }

    private String buildUrl(Resource resource) {
        return EncodingUtil.encodeURLToString((String)this.getRepository().getUrl(), (String[])new String[]{resource.getName()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(Resource resource, File source, RequestEntityImplementation requestEntityImplementation, String url) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        this.client.getParams().setAuthenticationPreemptive(true);
        try {
            this.mkdirs(PathUtils.dirname((String)resource.getName()));
        }
        catch (IOException e) {
            this.fireTransferError(resource, e, 5);
        }
        PutMethod putMethod = new PutMethod(url);
        this.firePutStarted(resource, source);
        try {
            int statusCode;
            putMethod.setRequestEntity((RequestEntity)requestEntityImplementation);
            try {
                statusCode = this.execute((HttpMethod)putMethod);
            }
            catch (IOException e) {
                this.fireTransferError(resource, e, 6);
                throw new TransferFailedException(e.getMessage(), (Throwable)e);
            }
            this.fireTransferDebug(url + " - Status code: " + statusCode);
            switch (statusCode) {
                case 200: 
                case 201: 
                case 202: 
                case 204: {
                    break;
                }
                case 301: 
                case 302: 
                case 303: {
                    String relocatedUrl = this.calculateRelocatedUrl((EntityEnclosingMethod)putMethod);
                    this.fireTransferDebug("relocate to " + relocatedUrl);
                    this.put(resource, source, requestEntityImplementation, relocatedUrl);
                    return;
                }
                case -1: {
                    TransferFailedException e = new TransferFailedException("Failed to transfer file: " + url);
                    this.fireTransferError(resource, (Exception)e, 6);
                    throw e;
                }
                case 403: {
                    this.fireSessionConnectionRefused();
                    throw new AuthorizationException("Access denied to: " + url);
                }
                case 404: {
                    throw new ResourceDoesNotExistException("File: " + url + " does not exist");
                }
                default: {
                    TransferFailedException e = new TransferFailedException("Failed to transfer file: " + url + ". Return code is: " + statusCode);
                    this.fireTransferError(resource, (Exception)e, 6);
                    throw e;
                }
            }
            this.firePutCompleted(resource, source);
        }
        finally {
            putMethod.releaseConnection();
        }
    }

    protected String calculateRelocatedUrl(EntityEnclosingMethod method) {
        Header locationHeader = method.getResponseHeader("Location");
        String locationField = locationHeader.getValue();
        return locationField.startsWith("http") ? locationField : this.getURL(this.getRepository()) + '/' + locationField;
    }

    protected void mkdirs(String dirname) throws IOException {
    }

    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        int statusCode;
        StringBuilder url = new StringBuilder(this.getRepository().getUrl());
        if (!url.toString().endsWith("/")) {
            url.append('/');
        }
        url.append(resourceName);
        HeadMethod headMethod = new HeadMethod(url.toString());
        try {
            statusCode = this.execute((HttpMethod)headMethod);
        }
        catch (IOException e) {
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
        try {
            switch (statusCode) {
                case 200: {
                    boolean bl = true;
                    return bl;
                }
                case 304: {
                    boolean bl = true;
                    return bl;
                }
                case -1: {
                    throw new TransferFailedException("Failed to transfer file: " + url);
                }
                case 403: {
                    throw new AuthorizationException("Access denied to: " + url);
                }
                case 401: {
                    throw new AuthorizationException("Not authorized.");
                }
                case 407: {
                    throw new AuthorizationException("Not authorized by proxy.");
                }
                case 404: {
                    boolean bl = false;
                    return bl;
                }
            }
            throw new TransferFailedException("Failed to transfer file: " + url + ". Return code is: " + statusCode);
        }
        finally {
            headMethod.releaseConnection();
        }
    }

    protected int execute(HttpMethod httpMethod) throws IOException {
        this.setParameters(httpMethod);
        this.setHeaders(httpMethod);
        int statusCode = this.client.executeMethod(httpMethod);
        return statusCode;
    }

    protected void setParameters(HttpMethod method) {
        HttpMethodParams params;
        HttpMethodConfiguration config;
        HttpMethodConfiguration httpMethodConfiguration = config = this.httpConfiguration == null ? null : this.httpConfiguration.getMethodConfiguration(method);
        if (config != null && (params = config.asMethodParams(method.getParams())) != null) {
            method.setParams(params);
        }
        if (config == null || config.getConnectionTimeout() == 60000) {
            method.getParams().setSoTimeout(this.getTimeout());
        }
    }

    protected void setHeaders(HttpMethod method) {
        Header[] headers;
        HttpMethodConfiguration config;
        HttpMethodConfiguration httpMethodConfiguration = config = this.httpConfiguration == null ? null : this.httpConfiguration.getMethodConfiguration(method);
        if (config == null || config.isUseDefaultHeaders()) {
            method.addRequestHeader("Cache-control", "no-cache");
            method.addRequestHeader("Cache-store", "no-store");
            method.addRequestHeader("Pragma", "no-cache");
            method.addRequestHeader("Expires", "0");
            method.addRequestHeader("Accept-Encoding", "gzip");
        }
        if (this.httpHeaders != null) {
            for (Object header : this.httpHeaders.keySet()) {
                method.addRequestHeader((String)header, this.httpHeaders.getProperty((String)header));
            }
        }
        Header[] headerArray = headers = config == null ? null : config.asRequestHeaders();
        if (headers != null) {
            for (Header header : headers) {
                method.addRequestHeader(header);
            }
        }
    }

    protected String getURL(Repository repository) {
        return repository.getUrl();
    }

    protected HttpClient getClient() {
        return this.client;
    }

    public void setConnectionManager(HttpConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Properties getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setHttpHeaders(Properties httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public HttpConfiguration getHttpConfiguration() {
        return this.httpConfiguration;
    }

    public void setHttpConfiguration(HttpConfiguration httpConfiguration) {
        this.httpConfiguration = httpConfiguration;
    }

    public void fillInputData(InputData inputData) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Header contentEncoding;
        int statusCode;
        Resource resource = inputData.getResource();
        StringBuilder url = new StringBuilder(this.getRepository().getUrl());
        if (!url.toString().endsWith("/")) {
            url.append('/');
        }
        url.append(resource.getName());
        this.getMethod = new GetMethod(url.toString());
        long timestamp = resource.getLastModified();
        if (timestamp > 0L) {
            SimpleDateFormat fmt = new SimpleDateFormat("EEE, dd-MMM-yy HH:mm:ss zzz", Locale.US);
            fmt.setTimeZone(GMT_TIME_ZONE);
            Header hdr = new Header("If-Modified-Since", fmt.format(new Date(timestamp)));
            this.fireTransferDebug("sending ==> " + hdr + "(" + timestamp + ")");
            this.getMethod.addRequestHeader(hdr);
        }
        try {
            statusCode = this.execute(this.getMethod);
        }
        catch (IOException e) {
            this.fireTransferError(resource, e, 5);
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
        this.fireTransferDebug(url + " - Status code: " + statusCode);
        switch (statusCode) {
            case 200: {
                break;
            }
            case 304: {
                return;
            }
            case -1: {
                TransferFailedException e = new TransferFailedException("Failed to transfer file: " + url);
                this.fireTransferError(resource, (Exception)e, 5);
                throw e;
            }
            case 403: {
                this.fireSessionConnectionRefused();
                throw new AuthorizationException("Access denied to: " + url);
            }
            case 401: {
                this.fireSessionConnectionRefused();
                throw new AuthorizationException("Not authorized.");
            }
            case 407: {
                this.fireSessionConnectionRefused();
                throw new AuthorizationException("Not authorized by proxy.");
            }
            case 404: {
                throw new ResourceDoesNotExistException("File: " + url + " does not exist");
            }
            default: {
                this.cleanupGetTransfer(resource);
                TransferFailedException e = new TransferFailedException("Failed to transfer file: " + url + ". Return code is: " + statusCode);
                this.fireTransferError(resource, (Exception)e, 5);
                throw e;
            }
        }
        InputStream is = null;
        Header contentLengthHeader = this.getMethod.getResponseHeader("Content-Length");
        if (contentLengthHeader != null) {
            try {
                long contentLength = Integer.valueOf(contentLengthHeader.getValue()).intValue();
                resource.setContentLength(contentLength);
            }
            catch (NumberFormatException e) {
                this.fireTransferDebug("error parsing content length header '" + contentLengthHeader.getValue() + "' " + e);
            }
        }
        Header lastModifiedHeader = this.getMethod.getResponseHeader("Last-Modified");
        long lastModified = 0L;
        if (lastModifiedHeader != null) {
            try {
                lastModified = DateUtil.parseDate((String)lastModifiedHeader.getValue()).getTime();
                resource.setLastModified(lastModified);
            }
            catch (DateParseException e) {
                this.fireTransferDebug("Unable to parse last modified header");
            }
            this.fireTransferDebug("last-modified = " + lastModifiedHeader.getValue() + " (" + lastModified + ")");
        }
        boolean isGZipped = (contentEncoding = this.getMethod.getResponseHeader("Content-Encoding")) != null && "gzip".equalsIgnoreCase(contentEncoding.getValue());
        try {
            is = this.getMethod.getResponseBodyAsStream();
            if (isGZipped) {
                is = new GZIPInputStream(is);
            }
        }
        catch (IOException e) {
            this.fireTransferError(resource, e, 5);
            String msg = "Error occurred while retrieving from remote repository:" + this.getRepository() + ": " + e.getMessage();
            throw new TransferFailedException(msg, (Throwable)e);
        }
        inputData.setInputStream(is);
    }

    protected void cleanupGetTransfer(Resource resource) {
        if (this.getMethod != null) {
            this.getMethod.releaseConnection();
        }
    }

    public void putFromStream(InputStream stream, String destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.putFromStream(stream, destination, -1L, -1L);
    }

    protected void putFromStream(InputStream stream, Resource resource) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        this.putFromStream(stream, resource.getName(), -1L, -1L);
    }

    public void fillOutputData(OutputData outputData) throws TransferFailedException {
        throw new IllegalStateException("this wagon http client must not use fillOutputData");
    }

    private final class RequestEntityImplementation
    implements RequestEntity {
        private final Resource resource;
        private final Wagon wagon;
        private File source;
        private ByteBuffer byteBuffer;

        private RequestEntityImplementation(InputStream stream, Resource resource, Wagon wagon, File source) throws TransferFailedException {
            if (source != null) {
                this.source = source;
            } else {
                try {
                    byte[] bytes = IOUtils.toByteArray((InputStream)stream);
                    this.byteBuffer = ByteBuffer.allocate(bytes.length);
                    this.byteBuffer.put(bytes);
                }
                catch (IOException e) {
                    throw new TransferFailedException(e.getMessage(), (Throwable)e);
                }
            }
            this.resource = resource;
            this.wagon = wagon;
        }

        public long getContentLength() {
            return this.resource.getContentLength();
        }

        public String getContentType() {
            return null;
        }

        public boolean isRepeatable() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeRequest(OutputStream output) throws IOException {
            byte[] buffer = new byte[4096];
            TransferEvent transferEvent = new TransferEvent(this.wagon, this.resource, 3, 6);
            transferEvent.setTimestamp(System.currentTimeMillis());
            InputStream fin = null;
            try {
                int n;
                fin = this.source != null ? new FileInputStream(this.source) : new ByteArrayInputStream(this.byteBuffer.array());
                for (int remaining = Integer.MAX_VALUE; remaining > 0 && (n = fin.read(buffer, 0, Math.min(buffer.length, remaining))) != -1; remaining -= n) {
                    AbstractHttpClientWagon.this.fireTransferProgress(transferEvent, buffer, n);
                    output.write(buffer, 0, n);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fin);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fin);
            output.flush();
        }
    }
}

