/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.tmatesoft.svn.core.internal.wc.ISVNInputFile;

public class SVNInputFileChannel
implements ISVNInputFile {
    FileChannel myChannel;
    FileInputStream myFileStream;

    public SVNInputFileChannel(File file) throws FileNotFoundException {
        this.myFileStream = new FileInputStream(file);
        this.myChannel = this.myFileStream.getChannel();
    }

    public void seek(long pos) throws IOException {
        this.myChannel.position(pos);
    }

    public long getFilePointer() throws IOException {
        return this.myChannel.position();
    }

    public int read() throws IOException {
        byte[] buf = new byte[1];
        int r = this.myChannel.read(ByteBuffer.wrap(buf));
        return r < 0 ? -1 : buf[0] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.myChannel.read(ByteBuffer.wrap(b));
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.myChannel.read(ByteBuffer.wrap(b, off, len));
    }

    public long length() throws IOException {
        return this.myChannel.size();
    }

    public void close() throws IOException {
        if (this.myChannel != null) {
            this.myChannel.close();
        }
        if (this.myFileStream != null) {
            this.myFileStream.close();
        }
    }
}

