/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.text.ParseException;
import java.util.Collection;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLHandshakeException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNProxyManager;
import org.tmatesoft.svn.core.auth.ISVNSSLManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVErrorHandler;
import org.tmatesoft.svn.core.internal.io.dav.http.ChunkedInputStream;
import org.tmatesoft.svn.core.internal.io.dav.http.FixedSizeInputStream;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPBasicAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPHeader;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPNTLMAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPParser;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPRequest;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPStatus;
import org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnection;
import org.tmatesoft.svn.core.internal.io.dav.http.SpoolFile;
import org.tmatesoft.svn.core.internal.io.dav.http.XMLReader;
import org.tmatesoft.svn.core.internal.util.SVNSocketFactory;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableOutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class HTTPConnection
implements IHTTPConnection {
    private static final DefaultHandler DEFAULT_SAX_HANDLER = new DefaultHandler();
    private static EntityResolver NO_ENTITY_RESOLVER = new EntityResolver(){

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
    };
    private static final int DEFAULT_HTTP_TIMEOUT = 3600000;
    private static SAXParserFactory ourSAXParserFactory;
    private byte[] myBuffer;
    private SAXParser mySAXParser;
    private SVNURL myHost;
    private OutputStream myOutputStream;
    private InputStream myInputStream;
    private Socket mySocket;
    private SVNRepository myRepository;
    private boolean myIsSecured;
    private boolean myIsProxied;
    private SVNAuthentication myLastValidAuth;
    private HTTPAuthentication myChallengeCredentials;
    private HTTPAuthentication myProxyAuthentication;
    private boolean myIsSpoolResponse;
    private ISVNSSLManager mySSLManager;
    private String myCharset;
    private boolean myIsSpoolAll;
    private File mySpoolDirectory;

    public HTTPConnection(SVNRepository repository, String charset, File spoolDirectory, boolean spoolAll) throws SVNException {
        this.myRepository = repository;
        this.myCharset = charset;
        this.myHost = repository.getLocation().setPath("", false);
        this.myIsSecured = "https".equalsIgnoreCase(this.myHost.getProtocol());
        this.myIsSpoolAll = spoolAll;
        this.mySpoolDirectory = spoolDirectory;
    }

    public SVNURL getHost() {
        return this.myHost;
    }

    private void connect(ISVNSSLManager sslManager) throws IOException, SVNException {
        SVNURL location = this.myRepository.getLocation();
        if (this.mySocket == null || SVNSocketFactory.isSocketStale(this.mySocket)) {
            long timeout;
            ISVNProxyManager proxyAuth;
            this.close();
            String host = location.getHost();
            int port = location.getPort();
            ISVNAuthenticationManager authManager = this.myRepository.getAuthenticationManager();
            ISVNProxyManager iSVNProxyManager = proxyAuth = authManager != null ? authManager.getProxyManager(location) : null;
            if (proxyAuth != null && proxyAuth.getProxyHost() != null) {
                this.mySocket = SVNSocketFactory.createPlainSocket(proxyAuth.getProxyHost(), proxyAuth.getProxyPort());
                if (this.myProxyAuthentication == null) {
                    this.myProxyAuthentication = new HTTPBasicAuthentication(proxyAuth.getProxyUserName(), proxyAuth.getProxyPassword(), this.myCharset);
                }
                this.myIsProxied = true;
                if (this.myIsSecured) {
                    HTTPRequest connectRequest = new HTTPRequest(this.myCharset);
                    connectRequest.setConnection(this);
                    connectRequest.setProxyAuthentication(this.myProxyAuthentication.authenticate());
                    connectRequest.setForceProxyAuth(true);
                    connectRequest.dispatch("CONNECT", host + ":" + port, null, 0, 0, null);
                    HTTPStatus status = connectRequest.getStatus();
                    if (status.getCode() == 200) {
                        this.myInputStream = null;
                        this.myOutputStream = null;
                        this.mySocket = SVNSocketFactory.createSSLSocket(sslManager, host, port, this.mySocket);
                        proxyAuth.acknowledgeProxyContext(true, null);
                        return;
                    }
                    SVNURL proxyURL = SVNURL.parseURIEncoded("http://" + proxyAuth.getProxyHost() + ":" + proxyAuth.getProxyPort());
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "{0} request failed on ''{1}''", new Object[]{"CONNECT", proxyURL});
                    proxyAuth.acknowledgeProxyContext(false, err);
                    SVNErrorManager.error(err, connectRequest.getErrorMessage());
                }
            } else {
                this.myIsProxied = false;
                this.myProxyAuthentication = null;
                this.mySocket = this.myIsSecured ? SVNSocketFactory.createSSLSocket(sslManager, host, port) : SVNSocketFactory.createPlainSocket(host, port);
            }
            long l = timeout = this.myRepository.getAuthenticationManager() != null ? this.myRepository.getAuthenticationManager().getHTTPTimeout(this.myRepository) : 3600000L;
            if (timeout < 0L) {
                timeout = 3600000L;
            }
            this.mySocket.setSoTimeout((int)timeout);
        }
    }

    public void readHeader(HTTPRequest request) throws IOException {
        InputStream is = this.myRepository.getDebugLog().createLogStream(this.getInputStream());
        try {
            HTTPStatus status = HTTPParser.parseStatus(is, this.myCharset);
            HTTPHeader header = HTTPHeader.parseHeader(is, this.myCharset);
            request.setStatus(status);
            request.setResponseHeader(header);
        }
        catch (ParseException e) {
            String line = HTTPParser.readLine(is, this.myCharset);
            while (line != null && line.length() > 0) {
                line = HTTPParser.readLine(is, this.myCharset);
            }
            throw new IOException(e.getMessage());
        }
        finally {
            this.myRepository.getDebugLog().flushStream(is);
        }
    }

    public SVNErrorMessage readError(HTTPRequest request, String method, String path) {
        DAVErrorHandler errorHandler = new DAVErrorHandler();
        try {
            this.readData(request, method, path, (DefaultHandler)errorHandler);
        }
        catch (IOException e) {
            return null;
        }
        return errorHandler.getErrorMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendData(byte[] body) throws IOException {
        try {
            this.getOutputStream().write(body, 0, body.length);
            this.getOutputStream().flush();
        }
        finally {
            this.myRepository.getDebugLog().flushStream(this.getOutputStream());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendData(InputStream source, long length) throws IOException {
        try {
            byte[] buffer = this.getBuffer();
            while (length > 0L) {
                int read = source.read(buffer, 0, (int)Math.min((long)buffer.length, length));
                length -= (long)read;
                if (read <= 0) break;
                this.getOutputStream().write(buffer, 0, read);
            }
            this.getOutputStream().flush();
        }
        finally {
            this.myRepository.getDebugLog().flushStream(this.getOutputStream());
        }
    }

    public SVNAuthentication getLastValidCredentials() {
        return this.myLastValidAuth;
    }

    public void clearAuthenticationCache() {
        this.myLastValidAuth = null;
        this.mySSLManager = null;
    }

    public HTTPStatus request(String method, String path, HTTPHeader header, StringBuffer body, int ok1, int ok2, OutputStream dst, DefaultHandler handler) throws SVNException {
        return this.request(method, path, header, body, ok1, ok2, dst, handler, null);
    }

    public HTTPStatus request(String method, String path, HTTPHeader header, StringBuffer body, int ok1, int ok2, OutputStream dst, DefaultHandler handler, SVNErrorMessage context) throws SVNException {
        byte[] buffer = null;
        if (body != null) {
            try {
                buffer = body.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                buffer = body.toString().getBytes();
            }
        }
        return this.request(method, path, header, buffer != null ? new ByteArrayInputStream(buffer) : null, ok1, ok2, dst, handler, context);
    }

    public HTTPStatus request(String method, String path, HTTPHeader header, InputStream body, int ok1, int ok2, OutputStream dst, DefaultHandler handler) throws SVNException {
        return this.request(method, path, header, body, ok1, ok2, dst, handler, null);
    }

    public HTTPStatus request(String method, String path, HTTPHeader header, InputStream body, int ok1, int ok2, OutputStream dst, DefaultHandler handler, SVNErrorMessage context) throws SVNException {
        SVNErrorMessage err;
        block54: {
            HTTPStatus status;
            HTTPRequest request;
            String realm;
            SVNAuthentication httpAuth;
            block55: {
                block56: {
                    boolean isAuthForced;
                    if ("".equals(path) || path == null) {
                        path = "/";
                    }
                    if (this.myChallengeCredentials != null) {
                        this.myChallengeCredentials.setChallengeParameter("methodname", method);
                        this.myChallengeCredentials.setChallengeParameter("uri", path);
                    }
                    ISVNSSLManager sslManager = this.mySSLManager != null ? this.mySSLManager : this.promptSSLClientCertificate(true);
                    String sslRealm = "<" + this.myHost.getProtocol() + "://" + this.myHost.getHost() + ":" + this.myHost.getPort() + ">";
                    httpAuth = this.myLastValidAuth;
                    boolean bl = isAuthForced = this.myRepository.getAuthenticationManager() != null ? this.myRepository.getAuthenticationManager().isAuthenticationForced() : false;
                    if (httpAuth == null && isAuthForced) {
                        httpAuth = this.myRepository.getAuthenticationManager().getFirstAuthentication("svn.simple", sslRealm, null);
                        this.myChallengeCredentials = new HTTPBasicAuthentication((SVNPasswordAuthentication)httpAuth, this.myCharset);
                        this.myChallengeCredentials.setChallengeParameter("methodname", method);
                        this.myChallengeCredentials.setChallengeParameter("uri", path);
                    }
                    realm = null;
                    request = new HTTPRequest(this.myCharset);
                    request.setConnection(this);
                    request.setKeepAlive(true);
                    request.setRequestBody(body);
                    request.setResponseHandler(handler);
                    request.setResponseStream(dst);
                    err = null;
                    while (true) {
                        String newPath;
                        SVNErrorMessage sslErr;
                        status = null;
                        try {
                            err = null;
                            this.connect(sslManager);
                            request.reset();
                            request.setProxied(this.myIsProxied);
                            request.setSecured(this.myIsSecured);
                            if (this.myProxyAuthentication != null) {
                                request.setProxyAuthentication(this.myProxyAuthentication.authenticate());
                            }
                            if (httpAuth != null && this.myChallengeCredentials != null) {
                                String authResponse = this.myChallengeCredentials.authenticate();
                                request.setAuthentication(authResponse);
                            }
                            request.dispatch(method, path, header, ok1, ok2, context);
                            status = request.getStatus();
                        }
                        catch (SSLHandshakeException ssl) {
                            SVNSSLAuthentication sslAuth;
                            this.myRepository.getDebugLog().info(ssl);
                            if (sslManager != null && (sslAuth = sslManager.getClientAuthentication()) != null) {
                                this.close();
                                sslErr = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "SSL handshake failed: ''{0}''", ssl.getMessage());
                                this.myRepository.getAuthenticationManager().acknowledgeAuthentication(false, "svn.ssl", sslRealm, sslErr, sslAuth);
                                sslManager = this.promptSSLClientCertificate(false);
                                continue;
                            }
                            err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, ssl);
                        }
                        catch (IOException e) {
                            this.myRepository.getDebugLog().info(e);
                            if (e instanceof SocketTimeoutException) {
                                err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "timed out waiting for server");
                            } else if (e instanceof SVNCancellableOutputStream.IOCancelException) {
                                SVNErrorManager.cancel(e.getMessage());
                            } else {
                                SVNSSLAuthentication sslAuth;
                                if (sslManager != null && sslManager.isClientCertPromptRequired() && (sslAuth = sslManager.getClientAuthentication()) != null) {
                                    this.close();
                                    sslErr = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "SSL handshake failed: ''{0}''", e.getMessage());
                                    this.myRepository.getAuthenticationManager().acknowledgeAuthentication(false, "svn.ssl", sslRealm, sslErr, sslAuth);
                                    sslManager = this.promptSSLClientCertificate(false);
                                    continue;
                                }
                                err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, e.getMessage());
                            }
                        }
                        catch (SVNException e) {
                            this.myRepository.getDebugLog().info(e);
                            this.close();
                            throw e;
                        }
                        finally {
                            this.finishResponse(request);
                            continue;
                        }
                        if (err != null) {
                            this.close();
                            if (sslManager != null) {
                                sslManager.acknowledgeSSLContext(false, err);
                            }
                            break block54;
                        }
                        if (sslManager != null) {
                            sslManager.acknowledgeSSLContext(true, null);
                            SVNSSLAuthentication sslAuth = sslManager.getClientAuthentication();
                            if (sslAuth != null) {
                                this.mySSLManager = sslManager;
                                this.myRepository.getAuthenticationManager().acknowledgeAuthentication(true, "svn.ssl", sslRealm, null, sslAuth);
                            }
                        }
                        if (status.getCode() == 403) {
                            this.myLastValidAuth = null;
                            this.close();
                            err = request.getErrorMessage();
                            break block55;
                        }
                        if (this.myIsProxied && status.getCode() == 407) {
                            ISVNProxyManager proxyManager;
                            HTTPNTLMAuthentication ntlmProxyAuth;
                            Collection proxyAuthHeaders = request.getResponseHeader().getHeaderValues("Proxy-Authenticate");
                            boolean retry = false;
                            if (!HTTPAuthentication.isSchemeSupportedByServer(this.myProxyAuthentication.getAuthenticationScheme(), proxyAuthHeaders)) {
                                retry = true;
                            }
                            try {
                                this.myProxyAuthentication = HTTPAuthentication.parseAuthParameters(proxyAuthHeaders, this.myProxyAuthentication, this.myCharset);
                            }
                            catch (SVNException svne) {
                                this.myRepository.getDebugLog().info(svne);
                                err = svne.getErrorMessage();
                                break block54;
                            }
                            if (retry) {
                                this.close();
                                continue;
                            }
                            if (this.myProxyAuthentication instanceof HTTPNTLMAuthentication && (ntlmProxyAuth = (HTTPNTLMAuthentication)this.myProxyAuthentication).isInType3State()) continue;
                            err = SVNErrorMessage.create(SVNErrorCode.CANCELLED, "HTTP proxy authorization cancelled");
                            SVNURL location = this.myRepository.getLocation();
                            ISVNAuthenticationManager authManager = this.myRepository.getAuthenticationManager();
                            ISVNProxyManager iSVNProxyManager = proxyManager = authManager != null ? authManager.getProxyManager(location) : null;
                            if (proxyManager != null) {
                                proxyManager.acknowledgeProxyContext(false, err);
                            }
                            this.close();
                            break block54;
                        }
                        if (status.getCode() == 401) {
                            HTTPNTLMAuthentication ntlmAuth;
                            Collection authHeaderValues = request.getResponseHeader().getHeaderValues("WWW-Authenticate");
                            if (authHeaderValues == null || authHeaderValues.size() == 0) {
                                err = request.getErrorMessage();
                                status.setError(SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, err.getMessageTemplate(), err.getRelatedObjects()));
                                if ("LOCK".equalsIgnoreCase(method)) {
                                    status.getError().setChildErrorMessage(SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Probably you are trying to lock file in repository that only allows anonymous access"));
                                }
                                SVNErrorManager.error(status.getError());
                                return status;
                            }
                            boolean skip = false;
                            boolean bl2 = isAuthForced = this.myRepository.getAuthenticationManager() != null ? this.myRepository.getAuthenticationManager().isAuthenticationForced() : false;
                            if (isAuthForced && httpAuth != null && this.myChallengeCredentials != null && !HTTPAuthentication.isSchemeSupportedByServer(this.myChallengeCredentials.getAuthenticationScheme(), authHeaderValues)) {
                                skip = true;
                            }
                            try {
                                this.myChallengeCredentials = HTTPAuthentication.parseAuthParameters(authHeaderValues, this.myChallengeCredentials, this.myCharset);
                            }
                            catch (SVNException svne) {
                                err = svne.getErrorMessage();
                                break block54;
                            }
                            this.myChallengeCredentials.setChallengeParameter("methodname", method);
                            this.myChallengeCredentials.setChallengeParameter("uri", path);
                            if (skip) {
                                this.close();
                                continue;
                            }
                            if (this.myChallengeCredentials instanceof HTTPNTLMAuthentication && (ntlmAuth = (HTTPNTLMAuthentication)this.myChallengeCredentials).isInType3State()) continue;
                            this.myLastValidAuth = null;
                            this.close();
                            ISVNAuthenticationManager authManager = this.myRepository.getAuthenticationManager();
                            if (authManager == null) {
                                err = request.getErrorMessage();
                                break block54;
                            }
                            realm = this.myChallengeCredentials.getChallengeParameter("realm");
                            realm = realm == null ? "" : " " + realm;
                            realm = "<" + this.myHost.getProtocol() + "://" + this.myHost.getHost() + ":" + this.myHost.getPort() + ">" + realm;
                            if (httpAuth == null) {
                                httpAuth = authManager.getFirstAuthentication("svn.simple", realm, this.myRepository.getLocation());
                            } else {
                                authManager.acknowledgeAuthentication(false, "svn.simple", realm, request.getErrorMessage(), httpAuth);
                                httpAuth = authManager.getNextAuthentication("svn.simple", realm, this.myRepository.getLocation());
                            }
                            if (httpAuth == null) {
                                err = SVNErrorMessage.create(SVNErrorCode.CANCELLED, "HTTP authorization cancelled");
                                break block54;
                            }
                            this.myChallengeCredentials.setCredentials((SVNPasswordAuthentication)httpAuth);
                            continue;
                        }
                        if (status.getCode() != 301 && status.getCode() != 302) break block56;
                        this.close();
                        String newLocation = request.getResponseHeader().getFirstHeaderValue("Location");
                        if (newLocation == null) {
                            err = request.getErrorMessage();
                            break block54;
                        }
                        int hostIndex = newLocation.indexOf("://");
                        if (hostIndex > 0) {
                            hostIndex += 3;
                            hostIndex = newLocation.indexOf("/", hostIndex);
                        }
                        if (hostIndex <= 0 || hostIndex >= newLocation.length() || !(newPath = newLocation.substring(hostIndex)).endsWith("/") || newPath.endsWith("//") || path.endsWith("/") || !newPath.substring(0, newPath.length() - 1).equals(path)) break;
                        path = path + "//";
                    }
                    err = request.getErrorMessage();
                    break block55;
                }
                if (request.getErrorMessage() != null) {
                    err = request.getErrorMessage();
                }
            }
            if (err == null) {
                if (this.myIsProxied) {
                    ISVNProxyManager proxyManager;
                    SVNURL location = this.myRepository.getLocation();
                    ISVNAuthenticationManager authManager = this.myRepository.getAuthenticationManager();
                    ISVNProxyManager iSVNProxyManager = proxyManager = authManager != null ? authManager.getProxyManager(location) : null;
                    if (proxyManager != null) {
                        proxyManager.acknowledgeProxyContext(true, null);
                    }
                }
                if (httpAuth != null && realm != null && this.myRepository.getAuthenticationManager() != null) {
                    this.myRepository.getAuthenticationManager().acknowledgeAuthentication(true, "svn.simple", realm, null, httpAuth);
                }
                this.myLastValidAuth = httpAuth;
                status.setHeader(request.getResponseHeader());
                return status;
            }
        }
        this.close();
        if (err != null && err.getErrorCode().getCategory() != 175000 && err.getErrorCode() != SVNErrorCode.UNSUPPORTED_FEATURE) {
            SVNErrorManager.error(err);
        }
        this.myRepository.getDebugLog().info(err.getMessage());
        this.myRepository.getDebugLog().info(new Exception());
        SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "{0} request failed on ''{1}''", new Object[]{method, path});
        SVNErrorManager.error(err2, err);
        return null;
    }

    private ISVNSSLManager promptSSLClientCertificate(boolean firstAuth) throws SVNException {
        SVNURL location = this.myRepository.getLocation();
        ISVNAuthenticationManager authManager = this.myRepository.getAuthenticationManager();
        ISVNSSLManager sslManager = null;
        SVNSSLAuthentication sslAuth = null;
        String sslRealm = "<" + location.getProtocol() + "://" + location.getHost() + ":" + location.getPort() + ">";
        if (this.myIsSecured) {
            ISVNSSLManager iSVNSSLManager = sslManager = authManager != null ? authManager.getSSLManager(location) : null;
        }
        if (authManager != null && sslManager != null && (sslManager.isClientCertPromptRequired() || firstAuth && sslManager.getClientCertLoadingError() != null)) {
            while (true) {
                if ((sslAuth = firstAuth ? (SVNSSLAuthentication)authManager.getFirstAuthentication("svn.ssl", sslRealm, location) : (SVNSSLAuthentication)authManager.getNextAuthentication("svn.ssl", sslRealm, location)) == null) {
                    SVNErrorManager.cancel("SSL authentication with client certificate cancelled");
                }
                sslManager.setClientAuthentication(sslAuth);
                if (sslManager.getClientCertLoadingError() == null) break;
                sslManager.acknowledgeSSLContext(false, SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, sslManager.getClientCertLoadingError().getMessage()));
            }
        }
        return sslManager;
    }

    public SVNErrorMessage readData(HTTPRequest request, OutputStream dst) throws IOException {
        InputStream stream = this.createInputStream(request.getResponseHeader(), this.getInputStream());
        byte[] buffer = this.getBuffer();
        boolean willCloseConnection = false;
        try {
            int count;
            while ((count = stream.read(buffer)) > 0) {
                if (dst == null) continue;
                dst.write(buffer, 0, count);
            }
        }
        catch (IOException e) {
            willCloseConnection = true;
            if (e.getCause() instanceof SVNException) {
                SVNErrorMessage sVNErrorMessage = ((SVNException)e.getCause()).getErrorMessage();
                return sVNErrorMessage;
            }
            throw e;
        }
        finally {
            if (!willCloseConnection) {
                SVNFileUtil.closeFile(stream);
            }
            this.myRepository.getDebugLog().flushStream(stream);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public SVNErrorMessage readData(HTTPRequest request, String method, String path, DefaultHandler handler) throws IOException {
        block27: {
            block24: {
                block22: {
                    block25: {
                        block23: {
                            is = null;
                            tmpFile = null;
                            err = null;
                            if (!this.myIsSpoolResponse && !this.myIsSpoolAll) ** GOTO lbl41
                            dst = null;
                            tmpFile = new SpoolFile(this.mySpoolDirectory);
                            dst = tmpFile.openForWriting();
                            dst = new SVNCancellableOutputStream(dst, this.myRepository.getCanceller());
                            err = this.readData(request, dst);
                            SVNFileUtil.closeFile(dst);
                            dst = null;
                            if (err == null) break block22;
                            var9_11 = err;
                            SVNFileUtil.closeFile(dst);
                            if (!this.myIsSpoolResponse && !this.myIsSpoolAll) break block23;
                            SVNFileUtil.closeFile(is);
                            break block25;
                        }
                        if (err == null && !HTTPConnection.hasToCloseConnection(request.getResponseHeader())) {
                            SVNFileUtil.closeFile(is);
                        }
                    }
                    if (tmpFile != null) {
                        try {
                            tmpFile.delete();
                        }
                        catch (SVNException e) {
                            throw new IOException(e.getMessage());
                        }
                    }
                    this.myIsSpoolResponse = false;
                    return var9_11;
                }
                try {
                    block26: {
                        is = tmpFile.openForReading();
                        {
                            catch (Throwable var11_13) {
                                SVNFileUtil.closeFile(dst);
                                throw var11_13;
                            }
                        }
                        SVNFileUtil.closeFile(dst);
                        break block26;
lbl41:
                        // 1 sources

                        is = this.createInputStream(request.getResponseHeader(), this.getInputStream());
                    }
                    err = this.readData(is, method, path, handler);
                    if (!this.myIsSpoolResponse && !this.myIsSpoolAll) break block24;
                }
                catch (IOException e) {
                    try {
                        throw e;
                    }
                    catch (Throwable var12_14) {
                        if (this.myIsSpoolResponse || this.myIsSpoolAll) {
                            SVNFileUtil.closeFile(is);
                        } else if (err == null && !HTTPConnection.hasToCloseConnection(request.getResponseHeader())) {
                            SVNFileUtil.closeFile(is);
                        }
                        if (tmpFile != null) {
                            try {
                                tmpFile.delete();
                            }
                            catch (SVNException e) {
                                throw new IOException(e.getMessage());
                            }
                        }
                        this.myIsSpoolResponse = false;
                        throw var12_14;
                    }
                }
                SVNFileUtil.closeFile(is);
                break block27;
            }
            if (err == null && !HTTPConnection.hasToCloseConnection(request.getResponseHeader())) {
                SVNFileUtil.closeFile(is);
            }
        }
        if (tmpFile != null) {
            try {
                tmpFile.delete();
            }
            catch (SVNException e) {
                throw new IOException(e.getMessage());
            }
        }
        this.myIsSpoolResponse = false;
        return err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNErrorMessage readData(InputStream is, String method, String path, DefaultHandler handler) throws FactoryConfigurationError, UnsupportedEncodingException, IOException {
        try {
            if (this.mySAXParser == null) {
                this.mySAXParser = HTTPConnection.getSAXParserFactory().newSAXParser();
            }
            XMLReader reader = new XMLReader(is);
            while (!reader.isClosed()) {
                org.xml.sax.XMLReader xmlReader = this.mySAXParser.getXMLReader();
                xmlReader.setContentHandler(handler);
                xmlReader.setDTDHandler(handler);
                xmlReader.setErrorHandler(handler);
                xmlReader.setEntityResolver(NO_ENTITY_RESOLVER);
                xmlReader.parse(new InputSource(reader));
            }
        }
        catch (SAXException e) {
            if (e instanceof SAXParseException) {
                if (handler instanceof DAVErrorHandler) {
                    SVNErrorMessage e2 = null;
                    return e2;
                }
            } else {
                if (e.getException() instanceof SVNException) {
                    SVNErrorMessage e2 = ((SVNException)e.getException()).getErrorMessage();
                    return e2;
                }
                if (e.getCause() instanceof SVNException) {
                    SVNErrorMessage e2 = ((SVNException)e.getCause()).getErrorMessage();
                    return e2;
                }
            }
            SVNErrorMessage e2 = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Processing {0} request response failed: {1} ({2}) ", new Object[]{method, e.getMessage(), path});
            return e2;
        }
        catch (ParserConfigurationException e) {
            SVNErrorMessage e2 = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "XML parser configuration error while processing {0} request response: {1} ({2}) ", new Object[]{method, e.getMessage(), path});
            return e2;
        }
        catch (EOFException e) {
        }
        finally {
            if (this.mySAXParser != null) {
                org.xml.sax.XMLReader xmlReader = null;
                try {
                    xmlReader = this.mySAXParser.getXMLReader();
                }
                catch (SAXException e) {}
                if (xmlReader != null) {
                    xmlReader.setContentHandler(DEFAULT_SAX_HANDLER);
                    xmlReader.setDTDHandler(DEFAULT_SAX_HANDLER);
                    xmlReader.setErrorHandler(DEFAULT_SAX_HANDLER);
                    xmlReader.setEntityResolver(NO_ENTITY_RESOLVER);
                }
            }
            this.myRepository.getDebugLog().flushStream(is);
        }
        return null;
    }

    public void skipData(HTTPRequest request) throws IOException {
        if (HTTPConnection.hasToCloseConnection(request.getResponseHeader())) {
            return;
        }
        InputStream is = this.createInputStream(request.getResponseHeader(), this.getInputStream());
        while (is.skip(2048L) > 0L) {
        }
    }

    public void close() {
        if (this.mySocket != null) {
            if (this.myInputStream != null) {
                try {
                    this.myInputStream.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (this.myOutputStream != null) {
                try {
                    this.myOutputStream.flush();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (this.myOutputStream != null) {
                try {
                    this.myOutputStream.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            try {
                this.mySocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mySocket = null;
            this.myOutputStream = null;
            this.myInputStream = null;
        }
    }

    private byte[] getBuffer() {
        if (this.myBuffer == null) {
            this.myBuffer = new byte[32768];
        }
        return this.myBuffer;
    }

    private InputStream getInputStream() throws IOException {
        if (this.myInputStream == null) {
            if (this.mySocket == null) {
                return null;
            }
            this.myInputStream = new BufferedInputStream(this.mySocket.getInputStream(), 2048);
        }
        return this.myInputStream;
    }

    private OutputStream getOutputStream() throws IOException {
        if (this.myOutputStream == null) {
            if (this.mySocket == null) {
                return null;
            }
            this.myOutputStream = new BufferedOutputStream(this.mySocket.getOutputStream(), 2048);
            this.myOutputStream = this.myRepository.getDebugLog().createLogStream(this.myOutputStream);
        }
        return this.myOutputStream;
    }

    private void finishResponse(HTTPRequest request) {
        HTTPHeader header;
        if (this.myOutputStream != null) {
            try {
                this.myOutputStream.flush();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        HTTPHeader hTTPHeader = header = request != null ? request.getResponseHeader() : null;
        if (HTTPConnection.hasToCloseConnection(header)) {
            this.close();
        }
    }

    private static boolean hasToCloseConnection(HTTPHeader header) {
        return header == null || "close".equalsIgnoreCase(header.getFirstHeaderValue("Connection")) || "close".equalsIgnoreCase(header.getFirstHeaderValue("Proxy-Connection"));
    }

    private InputStream createInputStream(HTTPHeader readHeader, InputStream is) throws IOException {
        if ("chunked".equalsIgnoreCase(readHeader.getFirstHeaderValue("Transfer-Encoding"))) {
            is = new ChunkedInputStream(is, this.myCharset);
        } else if (readHeader.getFirstHeaderValue("Content-Length") != null) {
            is = new FixedSizeInputStream(is, Long.parseLong(readHeader.getFirstHeaderValue("Content-Length").toString()));
        } else if (!HTTPConnection.hasToCloseConnection(readHeader)) {
            is = new FixedSizeInputStream(is, 0L);
            readHeader.setHeaderValue("Connection", "close");
        }
        if ("gzip".equals(readHeader.getFirstHeaderValue("Content-Encoding"))) {
            is = new GZIPInputStream(is);
        }
        return this.myRepository.getDebugLog().createLogStream(is);
    }

    private static synchronized SAXParserFactory getSAXParserFactory() throws FactoryConfigurationError {
        if (ourSAXParserFactory == null) {
            ourSAXParserFactory = SAXParserFactory.newInstance();
            try {
                ourSAXParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
            }
            catch (SAXNotRecognizedException e) {
            }
            catch (SAXNotSupportedException e) {
            }
            catch (ParserConfigurationException e) {
                // empty catch block
            }
            try {
                ourSAXParserFactory.setFeature("http://xml.org/sax/features/validation", false);
            }
            catch (SAXNotRecognizedException e) {
            }
            catch (SAXNotSupportedException e) {
            }
            catch (ParserConfigurationException e) {
                // empty catch block
            }
            try {
                ourSAXParserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (SAXNotRecognizedException e) {
            }
            catch (SAXNotSupportedException e) {
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
            ourSAXParserFactory.setNamespaceAware(true);
            ourSAXParserFactory.setValidating(false);
        }
        return ourSAXParserFactory;
    }

    public void setSpoolResponse(boolean spoolResponse) {
        this.myIsSpoolResponse = spoolResponse;
    }
}

