/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.colibri;

import org.jivesoftware.smack.packet.IQ;

public class ShutdownIQ
extends IQ {
    public static final String NAMESPACE = "http://jitsi.org/protocol/colibri";
    public static final String FORCE_ELEMENT_NAME = "force-shutdown";
    public static final String GRACEFUL_ELEMENT_NAME = "graceful-shutdown";
    private final String elementName;

    public static boolean isValidElementName(String elementName) {
        return GRACEFUL_ELEMENT_NAME.equals(elementName) || FORCE_ELEMENT_NAME.equals(elementName);
    }

    public static ShutdownIQ createShutdownIQ(String elementName) {
        if (!ShutdownIQ.isValidElementName(elementName)) {
            throw new IllegalArgumentException("Invalid element name: " + elementName);
        }
        if (GRACEFUL_ELEMENT_NAME.equals(elementName)) {
            return ShutdownIQ.createGracefulShutdownIQ();
        }
        return ShutdownIQ.createForceShutdownIQ();
    }

    public static ShutdownIQ createGracefulShutdownIQ() {
        return new ShutdownIQ(GRACEFUL_ELEMENT_NAME);
    }

    public static ShutdownIQ createForceShutdownIQ() {
        return new ShutdownIQ(FORCE_ELEMENT_NAME);
    }

    private ShutdownIQ(String elementName) {
        super(elementName, NAMESPACE);
        this.elementName = elementName;
    }

    public boolean isGracefulShutdown() {
        return this.elementName.equals(GRACEFUL_ELEMENT_NAME);
    }

    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder buf) {
        buf.setEmptyElement();
        return buf;
    }
}

