/*
 * Decompiled with CFR 0.152.
 */
package com.github.difflib.patch;

import com.github.difflib.patch.Chunk;
import com.github.difflib.patch.Delta;
import com.github.difflib.patch.DeltaType;
import com.github.difflib.patch.PatchFailedException;
import java.util.List;

public final class InsertDelta<T>
extends Delta<T> {
    public InsertDelta(Chunk<T> original, Chunk<T> revised) {
        super(DeltaType.INSERT, original, revised);
    }

    @Override
    public void applyTo(List<T> target) throws PatchFailedException {
        this.verify(target);
        int position = this.getOriginal().getPosition();
        List lines = this.getRevised().getLines();
        for (int i = 0; i < lines.size(); ++i) {
            target.add(position + i, lines.get(i));
        }
    }

    @Override
    public void restore(List<T> target) {
        int position = this.getRevised().getPosition();
        int size = this.getRevised().size();
        for (int i = 0; i < size; ++i) {
            target.remove(position);
        }
    }

    public String toString() {
        return "[InsertDelta, position: " + this.getOriginal().getPosition() + ", lines: " + this.getRevised().getLines() + "]";
    }
}

