/*
 * Decompiled with CFR 0.152.
 */
package javax.media.protocol;

import java.io.IOException;
import java.io.InputStream;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullSourceStream;

public class InputSourceStream
implements PullSourceStream {
    protected InputStream stream;
    protected boolean eosReached;
    private ContentDescriptor contentDescriptor;

    public InputSourceStream(InputStream s, ContentDescriptor type) {
        this.stream = s;
        this.contentDescriptor = type;
    }

    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public boolean endOfStream() {
        return this.eosReached;
    }

    @Override
    public ContentDescriptor getContentDescriptor() {
        return this.contentDescriptor;
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public Object getControl(String controlName) {
        return null;
    }

    @Override
    public Object[] getControls() {
        return new Object[0];
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int result = this.stream.read(buffer, offset, length);
        if (result == -1) {
            this.eosReached = true;
        }
        return result;
    }

    @Override
    public boolean willReadBlock() {
        try {
            return this.stream.available() <= 0;
        }
        catch (IOException e) {
            return true;
        }
    }
}

