/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp;

import org.jitsi.util.RTPUtils;

public class TimestampUtils {
    public static final long MAX_TIMESTAMP_VALUE = 0xFFFFFFFFL;
    public static final long ROLLOVER_DELTA_VALUE = 0x80000000L;

    public static long subtractAsUnsignedInt32(long t1, long t2) {
        return RTPUtils.as32Bits(t1 - t2);
    }

    public static boolean isNewerTimestamp(long t1, long t2) {
        if (t1 == t2) {
            return false;
        }
        if (TimestampUtils.subtractAsUnsignedInt32(t1, t2) == 0x80000000L) {
            return t1 > t2;
        }
        return TimestampUtils.subtractAsUnsignedInt32(t1, t2) < 0x80000000L;
    }

    public static long latestTimestamp(long timestamp1, long timestamp2) {
        return TimestampUtils.isNewerTimestamp(timestamp1, timestamp2) ? timestamp1 : timestamp2;
    }
}

