/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.plugin.surefire.report.ConsoleReporter;
import org.apache.maven.plugin.surefire.report.FileReporter;
import org.apache.maven.plugin.surefire.report.ReportEntryType;
import org.apache.maven.plugin.surefire.report.StatelessXmlReporter;
import org.apache.maven.plugin.surefire.report.TestMethodStats;
import org.apache.maven.plugin.surefire.report.TestSetStats;
import org.apache.maven.plugin.surefire.report.TestcycleConsoleOutputReceiver;
import org.apache.maven.plugin.surefire.report.Utf8RecodingDeferredFileOutputStream;
import org.apache.maven.plugin.surefire.report.WrappedReportEntry;
import org.apache.maven.plugin.surefire.runorder.StatisticsReporter;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.TestSetReportEntry;

public class TestSetRunListener
implements RunListener,
ConsoleOutputReceiver,
ConsoleLogger {
    private final Queue<TestMethodStats> testMethodStats = new ConcurrentLinkedQueue<TestMethodStats>();
    private final TestSetStats detailsForThis;
    private final TestcycleConsoleOutputReceiver consoleOutputReceiver;
    private final boolean briefOrPlainFormat;
    private final StatelessXmlReporter simpleXMLReporter;
    private final ConsoleReporter consoleReporter;
    private final FileReporter fileReporter;
    private final StatisticsReporter statisticsReporter;
    private Utf8RecodingDeferredFileOutputStream testStdOut = TestSetRunListener.initDeferred("stdout");
    private Utf8RecodingDeferredFileOutputStream testStdErr = TestSetRunListener.initDeferred("stderr");

    public TestSetRunListener(ConsoleReporter consoleReporter, FileReporter fileReporter, StatelessXmlReporter simpleXMLReporter, TestcycleConsoleOutputReceiver consoleOutputReceiver, StatisticsReporter statisticsReporter, boolean trimStackTrace, boolean isPlainFormat, boolean briefOrPlainFormat) {
        this.consoleReporter = consoleReporter;
        this.fileReporter = fileReporter;
        this.statisticsReporter = statisticsReporter;
        this.simpleXMLReporter = simpleXMLReporter;
        this.consoleOutputReceiver = consoleOutputReceiver;
        this.briefOrPlainFormat = briefOrPlainFormat;
        this.detailsForThis = new TestSetStats(trimStackTrace, isPlainFormat);
    }

    public boolean isDebugEnabled() {
        return this.consoleReporter.getConsoleLogger().isDebugEnabled();
    }

    public void debug(String message) {
        this.consoleReporter.getConsoleLogger().debug(TestSetRunListener.trimTrailingNewLine(message));
    }

    public boolean isInfoEnabled() {
        return this.consoleReporter.getConsoleLogger().isInfoEnabled();
    }

    public void info(String message) {
        this.consoleReporter.getConsoleLogger().info(TestSetRunListener.trimTrailingNewLine(message));
    }

    public boolean isWarnEnabled() {
        return this.consoleReporter.getConsoleLogger().isWarnEnabled();
    }

    public void warning(String message) {
        this.consoleReporter.getConsoleLogger().warning(TestSetRunListener.trimTrailingNewLine(message));
    }

    public boolean isErrorEnabled() {
        return this.consoleReporter.getConsoleLogger().isErrorEnabled();
    }

    public void error(String message) {
        this.consoleReporter.getConsoleLogger().error(TestSetRunListener.trimTrailingNewLine(message));
    }

    public void error(String message, Throwable t) {
        this.consoleReporter.getConsoleLogger().error(message, t);
    }

    public void error(Throwable t) {
        this.consoleReporter.getConsoleLogger().error(t);
    }

    public synchronized void writeTestOutput(byte[] buf, int off, int len, boolean stdout) {
        try {
            Utf8RecodingDeferredFileOutputStream os = stdout ? this.testStdOut : this.testStdErr;
            os.write(buf, off, len);
            this.consoleOutputReceiver.writeTestOutput(buf, off, len, stdout);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void testSetStarting(TestSetReportEntry report) {
        this.detailsForThis.testSetStart();
        this.consoleReporter.testSetStarting((ReportEntry)report);
        this.consoleOutputReceiver.testSetStarting((ReportEntry)report);
    }

    private void clearCapture() {
        this.testStdOut = TestSetRunListener.initDeferred("stdout");
        this.testStdErr = TestSetRunListener.initDeferred("stderr");
    }

    public void testSetCompleted(TestSetReportEntry report) {
        WrappedReportEntry wrap = this.wrapTestSet(report);
        List<String> testResults = this.briefOrPlainFormat ? this.detailsForThis.getTestResults() : Collections.emptyList();
        this.fileReporter.testSetCompleted(wrap, this.detailsForThis, testResults);
        this.simpleXMLReporter.testSetCompleted(wrap, this.detailsForThis);
        this.statisticsReporter.testSetCompleted();
        this.consoleReporter.testSetCompleted(wrap, this.detailsForThis, testResults);
        this.consoleOutputReceiver.testSetCompleted((ReportEntry)wrap);
        this.consoleReporter.reset();
        wrap.getStdout().free();
        wrap.getStdErr().free();
        this.addTestMethodStats();
        this.detailsForThis.reset();
        this.clearCapture();
    }

    public void testStarting(ReportEntry report) {
        this.detailsForThis.testStart();
    }

    public void testSucceeded(ReportEntry reportEntry) {
        WrappedReportEntry wrapped = this.wrap(reportEntry, ReportEntryType.SUCCESS);
        this.detailsForThis.testSucceeded(wrapped);
        this.statisticsReporter.testSucceeded(reportEntry);
        this.clearCapture();
    }

    public void testError(ReportEntry reportEntry) {
        WrappedReportEntry wrapped = this.wrap(reportEntry, ReportEntryType.ERROR);
        this.detailsForThis.testError(wrapped);
        this.statisticsReporter.testError(reportEntry);
        this.clearCapture();
    }

    public void testFailed(ReportEntry reportEntry) {
        WrappedReportEntry wrapped = this.wrap(reportEntry, ReportEntryType.FAILURE);
        this.detailsForThis.testFailure(wrapped);
        this.statisticsReporter.testFailed(reportEntry);
        this.clearCapture();
    }

    public void testSkipped(ReportEntry reportEntry) {
        WrappedReportEntry wrapped = this.wrap(reportEntry, ReportEntryType.SKIPPED);
        this.detailsForThis.testSkipped(wrapped);
        this.statisticsReporter.testSkipped(reportEntry);
        this.clearCapture();
    }

    public void testExecutionSkippedByUser() {
    }

    public void testAssumptionFailure(ReportEntry report) {
        this.testSkipped(report);
    }

    private WrappedReportEntry wrap(ReportEntry other, ReportEntryType reportEntryType) {
        int estimatedElapsed = 0;
        if (reportEntryType != ReportEntryType.SKIPPED) {
            Integer etime = other.getElapsed();
            estimatedElapsed = etime == null ? this.detailsForThis.getElapsedSinceLastStart() : etime.intValue();
        }
        return new WrappedReportEntry(other, reportEntryType, estimatedElapsed, this.testStdOut, this.testStdErr);
    }

    private WrappedReportEntry wrapTestSet(TestSetReportEntry other) {
        return new WrappedReportEntry((ReportEntry)other, null, other.getElapsed() != null ? other.getElapsed().intValue() : this.detailsForThis.getElapsedSinceTestSetStart(), this.testStdOut, this.testStdErr, other.getSystemProperties());
    }

    public void close() {
        this.consoleOutputReceiver.close();
    }

    private void addTestMethodStats() {
        for (WrappedReportEntry reportEntry : this.detailsForThis.getReportEntries()) {
            TestMethodStats methodStats = new TestMethodStats(reportEntry.getClassMethodName(), reportEntry.getReportEntryType(), reportEntry.getStackTraceWriter());
            this.testMethodStats.add(methodStats);
        }
    }

    public Queue<TestMethodStats> getTestMethodStats() {
        return this.testMethodStats;
    }

    private static String trimTrailingNewLine(String message) {
        int e = message == null ? 0 : TestSetRunListener.lineBoundSymbolWidth(message);
        return message != null && e != 0 ? message.substring(0, message.length() - e) : message;
    }

    private static int lineBoundSymbolWidth(String message) {
        return message.endsWith("\r\n") ? 2 : (message.endsWith("\n") || message.endsWith("\r") ? 1 : 0);
    }

    private static Utf8RecodingDeferredFileOutputStream initDeferred(String channel) {
        return new Utf8RecodingDeferredFileOutputStream(channel);
    }
}

