/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;

public class KrbDataInputStream
extends BufferedInputStream {
    private boolean bigEndian = true;

    public void setNativeByteOrder() {
        this.bigEndian = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
    }

    public KrbDataInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public final int readLength4() throws IOException {
        int n = this.read(4);
        if (n < 0) {
            throw new IOException("Invalid encoding");
        }
        return n;
    }

    public int read(int n) throws IOException {
        byte[] byArray = new byte[n];
        if (this.read(byArray, 0, n) != n) {
            throw new IOException("Premature end of stream reached");
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (this.bigEndian) {
                n2 |= (byArray[i] & 0xFF) << (n - i - 1) * 8;
                continue;
            }
            n2 |= (byArray[i] & 0xFF) << i * 8;
        }
        return n2;
    }

    public int readVersion() throws IOException {
        int n = (this.read() & 0xFF) << 8;
        return n | this.read() & 0xFF;
    }
}

