/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.IOException;
import java.security.CodeSigner;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.Manifest;
import sun.security.jca.Providers;
import sun.security.util.Debug;
import sun.security.util.DisabledAlgorithmConstraints;
import sun.security.util.JarConstraintsParameters;

public class ManifestEntryVerifier {
    private static final Debug debug = Debug.getInstance("jar");
    HashMap<String, MessageDigest> createdDigests = new HashMap(11);
    ArrayList<MessageDigest> digests = new ArrayList();
    ArrayList<byte[]> manifestHashes = new ArrayList();
    private String name = null;
    private final String manifestFileName;
    private final Manifest man;
    private boolean skip = true;
    private JarEntry entry;
    private CodeSigner[] signers = null;
    private static final char[] hexc = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public ManifestEntryVerifier(Manifest manifest, String string) {
        this.manifestFileName = string;
        this.man = manifest;
    }

    public void setEntry(String string, JarEntry jarEntry) throws IOException {
        this.digests.clear();
        this.manifestHashes.clear();
        this.name = string;
        this.entry = jarEntry;
        this.skip = true;
        this.signers = null;
        if (this.man == null || string == null) {
            return;
        }
        this.skip = false;
        Attributes attributes = this.man.getAttributes(string);
        if (attributes == null && (attributes = this.man.getAttributes("./" + string)) == null && (attributes = this.man.getAttributes("/" + string)) == null) {
            return;
        }
        for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
            String string2 = entry.getKey().toString();
            if (!string2.toUpperCase(Locale.ENGLISH).endsWith("-DIGEST")) continue;
            String string3 = string2.substring(0, string2.length() - 7);
            MessageDigest messageDigest = this.createdDigests.get(string3);
            if (messageDigest == null) {
                try {
                    messageDigest = MessageDigest.getInstance(string3, SunProviderHolder.instance);
                    this.createdDigests.put(string3, messageDigest);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
            if (messageDigest == null) continue;
            messageDigest.reset();
            this.digests.add(messageDigest);
            this.manifestHashes.add(Base64.getMimeDecoder().decode((String)entry.getValue()));
        }
    }

    public void update(byte by) {
        if (this.skip) {
            return;
        }
        for (int i = 0; i < this.digests.size(); ++i) {
            this.digests.get(i).update(by);
        }
    }

    public void update(byte[] byArray, int n, int n2) {
        if (this.skip) {
            return;
        }
        for (int i = 0; i < this.digests.size(); ++i) {
            this.digests.get(i).update(byArray, n, n2);
        }
    }

    public JarEntry getEntry() {
        return this.entry;
    }

    public CodeSigner[] verify(Hashtable<String, CodeSigner[]> hashtable, Hashtable<String, CodeSigner[]> hashtable2, Map<CodeSigner[], Map<String, Boolean>> map) throws JarException {
        if (this.skip) {
            return null;
        }
        if (this.digests.isEmpty()) {
            throw new SecurityException("digest missing for " + this.name);
        }
        if (this.signers != null) {
            return this.signers;
        }
        CodeSigner[] codeSignerArray = hashtable2.get(this.name);
        Map<String, Boolean> map2 = ManifestEntryVerifier.algsPermittedStatusForSigners(map, codeSignerArray);
        boolean bl = true;
        JarConstraintsParameters jarConstraintsParameters = null;
        for (int i = 0; i < this.digests.size(); ++i) {
            Object object;
            MessageDigest messageDigest = this.digests.get(i);
            String string = messageDigest.getAlgorithm();
            if (map2 != null) {
                object = map2.get(string);
                if (object == null) {
                    if (jarConstraintsParameters == null) {
                        jarConstraintsParameters = new JarConstraintsParameters(codeSignerArray);
                    }
                    if (!this.checkConstraints(string, jarConstraintsParameters)) {
                        map2.put(string, Boolean.FALSE);
                        continue;
                    }
                    map2.put(string, Boolean.TRUE);
                } else if (!((Boolean)object).booleanValue()) continue;
            }
            bl = false;
            object = this.manifestHashes.get(i);
            byte[] byArray = messageDigest.digest();
            if (debug != null) {
                debug.println("Manifest Entry: " + this.name + " digest=" + string);
                debug.println("  manifest " + ManifestEntryVerifier.toHex((byte[])object));
                debug.println("  computed " + ManifestEntryVerifier.toHex(byArray));
                debug.println();
            }
            if (MessageDigest.isEqual(byArray, (byte[])object)) continue;
            throw new SecurityException(string + " digest error for " + this.name);
        }
        if (bl) {
            return null;
        }
        this.signers = hashtable2.remove(this.name);
        if (this.signers != null) {
            hashtable.put(this.name, this.signers);
        }
        return this.signers;
    }

    private static Map<String, Boolean> algsPermittedStatusForSigners(Map<CodeSigner[], Map<String, Boolean>> map, CodeSigner[] codeSignerArray) {
        if (codeSignerArray != null) {
            Map<String, Boolean> map2 = map.get(codeSignerArray);
            if (map2 == null) {
                map2 = new HashMap<String, Boolean>();
                map.put(codeSignerArray, map2);
            }
            return map2;
        }
        return null;
    }

    private boolean checkConstraints(String string, JarConstraintsParameters jarConstraintsParameters) {
        try {
            jarConstraintsParameters.setExtendedExceptionMsg("META-INF/MANIFEST.MF", this.name + " entry");
            DisabledAlgorithmConstraints.jarConstraints().permits(string, jarConstraintsParameters, false);
            return true;
        }
        catch (GeneralSecurityException generalSecurityException) {
            if (debug != null) {
                debug.println("Digest algorithm is restricted: " + generalSecurityException);
            }
            return false;
        }
    }

    static String toHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(hexc[byArray[i] >> 4 & 0xF]);
            stringBuffer.append(hexc[byArray[i] & 0xF]);
        }
        return stringBuffer.toString();
    }

    private static class SunProviderHolder {
        private static final Provider instance = Providers.getSunProvider();

        private SunProviderHolder() {
        }
    }
}

