/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ContentProviderClient;
import android.content.Context;
import android.location.Location;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.internal.dm;
import com.google.android.gms.internal.ex;
import com.google.android.gms.internal.fc;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.a;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ey {
    private final fc<ex> oO;
    private final Context mContext;
    private ContentProviderClient oP = null;
    private boolean oQ = false;
    private HashMap<LocationListener, b> oR = new HashMap();

    public ey(Context context, fc<ex> fc2) {
        this.mContext = context;
        this.oO = fc2;
    }

    public Location getLastLocation() {
        this.oO.bc();
        try {
            return this.oO.bd().cl();
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestLocationUpdates(LocationRequest request, LocationListener listener, Looper looper) {
        this.oO.bc();
        if (looper == null) {
            dm.a(Looper.myLooper(), (Object)"Can't create handler inside thread that has not called Looper.prepare()");
        }
        HashMap<LocationListener, b> hashMap = this.oR;
        synchronized (hashMap) {
            b b2 = this.oR.get(listener);
            if (b2 == null) {
                b2 = new b(listener, looper);
            }
            this.oR.put(listener, b2);
            try {
                this.oO.bd().a(request, b2, this.mContext.getPackageName());
            }
            catch (RemoteException remoteException) {
                throw new IllegalStateException(remoteException);
            }
        }
    }

    public void requestLocationUpdates(LocationRequest request, PendingIntent callbackIntent) {
        this.oO.bc();
        try {
            this.oO.bd().a(request, callbackIntent);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocationUpdates(LocationListener listener) {
        this.oO.bc();
        dm.a(listener, (Object)"Invalid null listener");
        HashMap<LocationListener, b> hashMap = this.oR;
        synchronized (hashMap) {
            b b2 = this.oR.remove(listener);
            if (this.oP != null && this.oR.isEmpty()) {
                this.oP.release();
                this.oP = null;
            }
            if (b2 != null) {
                b2.release();
                try {
                    this.oO.bd().a(b2);
                }
                catch (RemoteException remoteException) {
                    throw new IllegalStateException(remoteException);
                }
            }
        }
    }

    public void removeLocationUpdates(PendingIntent callbackIntent) {
        this.oO.bc();
        try {
            this.oO.bd().a(callbackIntent);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void setMockMode(boolean isMockMode) {
        this.oO.bc();
        try {
            this.oO.bd().setMockMode(isMockMode);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
        this.oQ = isMockMode;
    }

    public void setMockLocation(Location mockLocation) {
        this.oO.bc();
        try {
            this.oO.bd().setMockLocation(mockLocation);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners() {
        try {
            HashMap<LocationListener, b> hashMap = this.oR;
            synchronized (hashMap) {
                for (b b2 : this.oR.values()) {
                    if (b2 == null) continue;
                    this.oO.bd().a(b2);
                }
                this.oR.clear();
            }
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void cm() {
        if (this.oQ) {
            this.setMockMode(false);
        }
    }

    private static class a
    extends Handler {
        private final LocationListener oS;

        public a(LocationListener locationListener) {
            this.oS = locationListener;
        }

        public a(LocationListener locationListener, Looper looper) {
            super(looper);
            this.oS = locationListener;
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Location location = new Location((Location)msg.obj);
                    this.oS.onLocationChanged(location);
                    break;
                }
                default: {
                    Log.e((String)"LocationClientHelper", (String)"unknown message in LocationHandler.handleMessage");
                }
            }
        }
    }

    private static class b
    extends a.a {
        private Handler oT;

        b(LocationListener locationListener, Looper looper) {
            this.oT = looper == null ? new a(locationListener) : new a(locationListener, looper);
        }

        public void onLocationChanged(Location location) {
            if (this.oT == null) {
                Log.e((String)"LocationClientHelper", (String)"Received a location in client after calling removeLocationUpdates.");
                return;
            }
            Message message = Message.obtain();
            message.what = 1;
            message.obj = location;
            this.oT.sendMessage(message);
        }

        public void release() {
            this.oT = null;
        }
    }
}

