#include <sys/types.h>

#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>

#include <machine/sysarch.h>
#include <machine/pio.h>

static void
dumpbios(void)
{
	int off;

	for (off = 0x00; off <= 0xff; off++) {
		if ((off % 16) == 0)
			printf("\n%02x:", off);
		outb(0x70, off);
		printf(" %02x", inb(0x71));
	}
	printf("\n");
}

int
main(void)
{
	int error;
	int off;

	error = i386_iopl(0);
	if (error == -1)
		errx(EXIT_FAILURE, "i386_iopl failed");

	dumpbios();

	for (off = 0x38; off <= 0x3f; off++) {
		outb(0x70, off);
		outb(0x71, 0x00);
	}

	dumpbios();

	return EXIT_SUCCESS;
}
