/* $Id: main.c,v 1.7 2008/09/11 20:58:56 agcrooks Exp $ */

/*
 * Copyright (c) 2005 Manuel Freire.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include <sys/cdefs.h>

#ifndef lint
__COPYRIGHT("@(#) Copyright (c) 2005 Manuel Freire");
__RCSID("$Id: main.c,v 1.7 2008/09/11 20:58:56 agcrooks Exp $");
#endif

#include <sys/types.h>
#include <sys/param.h>

#include <err.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "bpg.h"

/* this struct defines a name (first arg), and the function to call */
typedef struct cmd_t {
	const char	*name;
	int		(*func)(bpginfo_t *, int, char **);
} cmd_t;

static cmd_t cmds[] = {
	{	"sign"		,	bpg_sign	},
	{	"verify"	,	bpg_verify	},
	{	"encrypt"	,	bpg_encrypt	},
	{	"symmenc"	,	bpg_symmenc	},
	{	"decrypt"	,	bpg_decrypt	},
	{	"encsig"	,	bpg_encsig	},
	{	NULL		,	0		},
};

static void
usage(void)
{

#if 0
	/* not quite yet */
	(void)fprintf(stderr,
"usage: %s ( sign | verify | encrypt | symmenc | decrypt | encsig ) ...\n",
		      getprogname());
#endif
	(void)fprintf(stderr, "usage: %s ( sign | verify ) ...\n",
		      getprogname()); 

	exit(EXIT_FAILURE);
}

/*
 * The bpg(1) utility is a command line interface for the bpg(3) library. It
 * performs OpenPGP operations, such as sign, verify, encrypt or decrypt data
 * in a public key system.
 */
int
main(int argc, char *argv[])
{
	bpginfo_t	*info;
	cmd_t		*cmd;
	char		 defkey[8 + 1];
	int		 ch;
	int		 i;

	setprogname(argv[0]);

	/* parse command */
	if (argc < 2) {
		usage();
	}
	for (cmd = cmds; cmd->name && strcasecmp(cmd->name, argv[1]) != 0 ; cmd++) {
	}
	if (cmd->name == NULL) {
		usage();
	}

	argc--;
	argv++;

	/* initialise info structure */
	if ((info = malloc(sizeof(*info))) == NULL) {
		err(EXIT_FAILURE, NULL);
	}
	(void) memset(info, 0x0, sizeof(*info));
	info->opt = BPG_CTX_new();

	bpg_get_defaults(info, NULL);

	/* parse options */
	while ((ch = getopt(argc, argv, "abdvc:h:p:o:r:u:z:D:U:R:P:Z:"))
	    != -1) {
		switch (ch) {
		case 'a':
		case 'c':
		case 'h':
		case 'p':
		case 'z':
		case 'Z':
			errx(EXIT_FAILURE, "-%c not yet supported", optopt);
			/* NOTREACHED */
		case 'D':
			info->detached = 1;
			info->det_sig_file = optarg;	/* dangerous */
			break;
		case 'P':
			/*
			 * VERY DANGEROUS OPTION: ps reveals passphrase;
			 * use a file with the password instead.
			 */
			info->opt->pass = optarg;	/* dangerous */
			break;
		case 'R':
			info->pub_file = optarg;	/* dangerous */
			break;
		case 'U':
			info->sec_file = optarg;	/* dangerous */
			break;
		case 'b':
			info->opt->ascii = 0;
			break;
		case 'd':
			info->detached = 1;
			break;
		case 'o':
			info->output_file = optarg;	/* dangerous */
			break;
		case 'r':
			BPG_set_id(info->opt, "public", optarg);
			break;
		case 'u':
			BPG_set_id(info->opt, "secret", optarg);
			break;
		case 'v':
			info->verbose = 1;
			break;
		case '?':
		default:
			usage();
			/* NOTREACHED */
		}
	}

	return (*cmd->func)(info, argc - optind, argv + optind) ? EXIT_SUCCESS : EXIT_FAILURE;
}
