/* $NetBSD: rump_syscalls.c,v 1.164 2024/10/09 16:29:11 christos Exp $ */

/*
 * System call vector and marshalling for rump.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * created from	NetBSD: syscalls.master,v 1.316 2024/10/09 16:27:28 christos Exp
 */

#ifdef RUMP_CLIENT
#include <rump/rumpuser_port.h>
#endif /* RUMP_CLIENT */

#include <sys/param.h>

#ifdef __NetBSD__
#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: rump_syscalls.c,v 1.164 2024/10/09 16:29:11 christos Exp $");

#include <sys/fstypes.h>
#include <sys/proc.h>
#endif /* __NetBSD__ */

#ifdef RUMP_CLIENT
#include <errno.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>

#include <srcsys/syscall.h>
#include <srcsys/syscallargs.h>

#include <rump/rumpclient.h>

#define rsys_syscall(num, data, dlen, retval)	\
    rumpclient_syscall(num, data, dlen, retval)
#define rsys_seterrno(error) errno = error
#else
#include <sys/syscall.h>
#include <sys/syscallargs.h>

#include <sys/syscallvar.h>

#include <rump-sys/kern.h>

#include <rump/rumpuser.h>
#define rsys_syscall(num, data, dlen, retval)	\
    rump_syscall(num, data, dlen, retval)

#define rsys_seterrno(error) rumpuser_seterrno(error)
#endif

#ifndef RUMP_KERNEL_IS_LIBC
#define RUMP_SYS_COMPAT
#endif

#if	BYTE_ORDER == BIG_ENDIAN
#define SPARG(p,k)	((p)->k.be.datum)
#else /* LITTLE_ENDIAN, I hope dearly */
#define SPARG(p,k)	((p)->k.le.datum)
#endif


void rumpns_sys_nomodule(void);

ssize_t rump___sysimpl_read(int, void *, size_t);
ssize_t
rump___sysimpl_read(int fd, void * buf, size_t nbyte)
{
	register_t retval[2];
	int error = 0;
	ssize_t rv = -1;
	struct sys_read_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, nbyte) = nbyte;

	error = rsys_syscall(SYS_read, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(read,rump___sysimpl_read);
__weak_alias(_read,rump___sysimpl_read);
__strong_alias(_sys_read,rump___sysimpl_read);
#endif /* RUMP_KERNEL_IS_LIBC */

ssize_t rump___sysimpl_write(int, const void *, size_t);
ssize_t
rump___sysimpl_write(int fd, const void * buf, size_t nbyte)
{
	register_t retval[2];
	int error = 0;
	ssize_t rv = -1;
	struct sys_write_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, nbyte) = nbyte;

	error = rsys_syscall(SYS_write, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(write,rump___sysimpl_write);
__weak_alias(_write,rump___sysimpl_write);
__strong_alias(_sys_write,rump___sysimpl_write);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_open(const char *, int, mode_t);
int
rump___sysimpl_open(const char * path, int flags, mode_t mode)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_open_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, flags) = flags;
	SPARG(&callarg, mode) = mode;

	error = rsys_syscall(SYS_open, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(open,rump___sysimpl_open);
__weak_alias(_open,rump___sysimpl_open);
__strong_alias(_sys_open,rump___sysimpl_open);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_close(int);
int
rump___sysimpl_close(int fd)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_close_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;

	error = rsys_syscall(SYS_close, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(close,rump___sysimpl_close);
__weak_alias(_close,rump___sysimpl_close);
__strong_alias(_sys_close,rump___sysimpl_close);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_link(const char *, const char *);
int
rump___sysimpl_link(const char * path, const char * link)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_link_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, link) = link;

	error = rsys_syscall(SYS_link, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(link,rump___sysimpl_link);
__weak_alias(_link,rump___sysimpl_link);
__strong_alias(_sys_link,rump___sysimpl_link);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_unlink(const char *);
int
rump___sysimpl_unlink(const char * path)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_unlink_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;

	error = rsys_syscall(SYS_unlink, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(unlink,rump___sysimpl_unlink);
__weak_alias(_unlink,rump___sysimpl_unlink);
__strong_alias(_sys_unlink,rump___sysimpl_unlink);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_chdir(const char *);
int
rump___sysimpl_chdir(const char * path)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_chdir_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;

	error = rsys_syscall(SYS_chdir, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(chdir,rump___sysimpl_chdir);
__weak_alias(_chdir,rump___sysimpl_chdir);
__strong_alias(_sys_chdir,rump___sysimpl_chdir);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_fchdir(int);
int
rump___sysimpl_fchdir(int fd)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_fchdir_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;

	error = rsys_syscall(SYS_fchdir, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(fchdir,rump___sysimpl_fchdir);
__weak_alias(_fchdir,rump___sysimpl_fchdir);
__strong_alias(_sys_fchdir,rump___sysimpl_fchdir);
#endif /* RUMP_KERNEL_IS_LIBC */

#ifdef RUMP_SYS_COMPAT
int rump___sysimpl_mknod(const char *, mode_t, uint32_t);
int
rump___sysimpl_mknod(const char * path, mode_t mode, uint32_t dev)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct compat_50_sys_mknod_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, mode) = mode;
	SPARG(&callarg, dev) = dev;

	error = rsys_syscall(SYS_compat_50_mknod, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(mknod,rump___sysimpl_mknod);
__weak_alias(_mknod,rump___sysimpl_mknod);
__strong_alias(_sys_mknod,rump___sysimpl_mknod);
#endif /* RUMP_KERNEL_IS_LIBC */
#endif /* RUMP_SYS_COMPAT */

int rump___sysimpl_chmod(const char *, mode_t);
int
rump___sysimpl_chmod(const char * path, mode_t mode)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_chmod_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, mode) = mode;

	error = rsys_syscall(SYS_chmod, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(chmod,rump___sysimpl_chmod);
__weak_alias(_chmod,rump___sysimpl_chmod);
__strong_alias(_sys_chmod,rump___sysimpl_chmod);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_chown(const char *, uid_t, gid_t);
int
rump___sysimpl_chown(const char * path, uid_t uid, gid_t gid)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_chown_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, uid) = uid;
	SPARG(&callarg, gid) = gid;

	error = rsys_syscall(SYS_chown, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(chown,rump___sysimpl_chown);
__weak_alias(_chown,rump___sysimpl_chown);
__strong_alias(_sys_chown,rump___sysimpl_chown);
#endif /* RUMP_KERNEL_IS_LIBC */

pid_t rump___sysimpl_getpid(void);
pid_t
rump___sysimpl_getpid(void )
{
	register_t retval[2];
	pid_t rv = -1;

	(void)rsys_syscall(SYS_getpid, NULL, 0, retval);
	if (sizeof(pid_t) > sizeof(register_t))
		rv = *(pid_t *)retval;
	else
		rv = *retval;
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(getpid,rump___sysimpl_getpid);
__weak_alias(_getpid,rump___sysimpl_getpid);
__strong_alias(_sys_getpid,rump___sysimpl_getpid);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_unmount(const char *, int);
int
rump___sysimpl_unmount(const char * path, int flags)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_unmount_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_unmount, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(unmount,rump___sysimpl_unmount);
__weak_alias(_unmount,rump___sysimpl_unmount);
__strong_alias(_sys_unmount,rump___sysimpl_unmount);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_setuid(uid_t);
int
rump___sysimpl_setuid(uid_t uid)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_setuid_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, uid) = uid;

	error = rsys_syscall(SYS_setuid, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(setuid,rump___sysimpl_setuid);
__weak_alias(_setuid,rump___sysimpl_setuid);
__strong_alias(_sys_setuid,rump___sysimpl_setuid);
#endif /* RUMP_KERNEL_IS_LIBC */

uid_t rump___sysimpl_getuid(void);
uid_t
rump___sysimpl_getuid(void )
{
	register_t retval[2];
	uid_t rv = -1;

	(void)rsys_syscall(SYS_getuid, NULL, 0, retval);
	if (sizeof(uid_t) > sizeof(register_t))
		rv = *(uid_t *)retval;
	else
		rv = *retval;
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(getuid,rump___sysimpl_getuid);
__weak_alias(_getuid,rump___sysimpl_getuid);
__strong_alias(_sys_getuid,rump___sysimpl_getuid);
#endif /* RUMP_KERNEL_IS_LIBC */

uid_t rump___sysimpl_geteuid(void);
uid_t
rump___sysimpl_geteuid(void )
{
	register_t retval[2];
	uid_t rv = -1;

	(void)rsys_syscall(SYS_geteuid, NULL, 0, retval);
	if (sizeof(uid_t) > sizeof(register_t))
		rv = *(uid_t *)retval;
	else
		rv = *retval;
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(geteuid,rump___sysimpl_geteuid);
__weak_alias(_geteuid,rump___sysimpl_geteuid);
__strong_alias(_sys_geteuid,rump___sysimpl_geteuid);
#endif /* RUMP_KERNEL_IS_LIBC */

ssize_t rump___sysimpl_recvmsg(int, struct msghdr *, int);
ssize_t
rump___sysimpl_recvmsg(int s, struct msghdr * msg, int flags)
{
	register_t retval[2];
	int error = 0;
	ssize_t rv = -1;
	struct sys_recvmsg_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, s) = s;
	SPARG(&callarg, msg) = msg;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_recvmsg, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(recvmsg,rump___sysimpl_recvmsg);
__weak_alias(_recvmsg,rump___sysimpl_recvmsg);
__strong_alias(_sys_recvmsg,rump___sysimpl_recvmsg);
#endif /* RUMP_KERNEL_IS_LIBC */

ssize_t rump___sysimpl_sendmsg(int, const struct msghdr *, int);
ssize_t
rump___sysimpl_sendmsg(int s, const struct msghdr * msg, int flags)
{
	register_t retval[2];
	int error = 0;
	ssize_t rv = -1;
	struct sys_sendmsg_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, s) = s;
	SPARG(&callarg, msg) = msg;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_sendmsg, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(sendmsg,rump___sysimpl_sendmsg);
__weak_alias(_sendmsg,rump___sysimpl_sendmsg);
__strong_alias(_sys_sendmsg,rump___sysimpl_sendmsg);
#endif /* RUMP_KERNEL_IS_LIBC */

ssize_t rump___sysimpl_recvfrom(int, void *, size_t, int, struct sockaddr *, socklen_t *);
ssize_t
rump___sysimpl_recvfrom(int s, void * buf, size_t len, int flags, struct sockaddr * from, socklen_t * fromlenaddr)
{
	register_t retval[2];
	int error = 0;
	ssize_t rv = -1;
	struct sys_recvfrom_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, s) = s;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, len) = len;
	SPARG(&callarg, flags) = flags;
	SPARG(&callarg, from) = from;
	SPARG(&callarg, fromlenaddr) = fromlenaddr;

	error = rsys_syscall(SYS_recvfrom, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(recvfrom,rump___sysimpl_recvfrom);
__weak_alias(_recvfrom,rump___sysimpl_recvfrom);
__strong_alias(_sys_recvfrom,rump___sysimpl_recvfrom);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_accept(int, struct sockaddr *, socklen_t *);
int
rump___sysimpl_accept(int s, struct sockaddr * name, socklen_t * anamelen)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_accept_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, s) = s;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, anamelen) = anamelen;

	error = rsys_syscall(SYS_accept, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(accept,rump___sysimpl_accept);
__weak_alias(_accept,rump___sysimpl_accept);
__strong_alias(_sys_accept,rump___sysimpl_accept);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_getpeername(int, struct sockaddr *, socklen_t *);
int
rump___sysimpl_getpeername(int fdes, struct sockaddr * asa, socklen_t * alen)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_getpeername_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fdes) = fdes;
	SPARG(&callarg, asa) = asa;
	SPARG(&callarg, alen) = alen;

	error = rsys_syscall(SYS_getpeername, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(getpeername,rump___sysimpl_getpeername);
__weak_alias(_getpeername,rump___sysimpl_getpeername);
__strong_alias(_sys_getpeername,rump___sysimpl_getpeername);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_getsockname(int, struct sockaddr *, socklen_t *);
int
rump___sysimpl_getsockname(int fdes, struct sockaddr * asa, socklen_t * alen)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_getsockname_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fdes) = fdes;
	SPARG(&callarg, asa) = asa;
	SPARG(&callarg, alen) = alen;

	error = rsys_syscall(SYS_getsockname, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(getsockname,rump___sysimpl_getsockname);
__weak_alias(_getsockname,rump___sysimpl_getsockname);
__strong_alias(_sys_getsockname,rump___sysimpl_getsockname);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_access(const char *, int);
int
rump___sysimpl_access(const char * path, int flags)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_access_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_access, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(access,rump___sysimpl_access);
__weak_alias(_access,rump___sysimpl_access);
__strong_alias(_sys_access,rump___sysimpl_access);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_chflags(const char *, u_long);
int
rump___sysimpl_chflags(const char * path, u_long flags)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_chflags_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_chflags, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(chflags,rump___sysimpl_chflags);
__weak_alias(_chflags,rump___sysimpl_chflags);
__strong_alias(_sys_chflags,rump___sysimpl_chflags);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_fchflags(int, u_long);
int
rump___sysimpl_fchflags(int fd, u_long flags)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_fchflags_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_fchflags, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(fchflags,rump___sysimpl_fchflags);
__weak_alias(_fchflags,rump___sysimpl_fchflags);
__strong_alias(_sys_fchflags,rump___sysimpl_fchflags);
#endif /* RUMP_KERNEL_IS_LIBC */

void rump___sysimpl_sync(void);
void
rump___sysimpl_sync(void )
{
	register_t retval[2];

	rsys_syscall(SYS_sync, NULL, 0, retval);
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(sync,rump___sysimpl_sync);
__weak_alias(_sync,rump___sysimpl_sync);
__strong_alias(_sys_sync,rump___sysimpl_sync);
#endif /* RUMP_KERNEL_IS_LIBC */

pid_t rump___sysimpl_getppid(void);
pid_t
rump___sysimpl_getppid(void )
{
	register_t retval[2];
	pid_t rv = -1;

	(void)rsys_syscall(SYS_getppid, NULL, 0, retval);
	if (sizeof(pid_t) > sizeof(register_t))
		rv = *(pid_t *)retval;
	else
		rv = *retval;
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(getppid,rump___sysimpl_getppid);
__weak_alias(_getppid,rump___sysimpl_getppid);
__strong_alias(_sys_getppid,rump___sysimpl_getppid);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_dup(int);
int
rump___sysimpl_dup(int fd)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_dup_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;

	error = rsys_syscall(SYS_dup, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(dup,rump___sysimpl_dup);
__weak_alias(_dup,rump___sysimpl_dup);
__strong_alias(_sys_dup,rump___sysimpl_dup);
#endif /* RUMP_KERNEL_IS_LIBC */

gid_t rump___sysimpl_getegid(void);
gid_t
rump___sysimpl_getegid(void )
{
	register_t retval[2];
	gid_t rv = -1;

	(void)rsys_syscall(SYS_getegid, NULL, 0, retval);
	if (sizeof(gid_t) > sizeof(register_t))
		rv = *(gid_t *)retval;
	else
		rv = *retval;
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(getegid,rump___sysimpl_getegid);
__weak_alias(_getegid,rump___sysimpl_getegid);
__strong_alias(_sys_getegid,rump___sysimpl_getegid);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_ktrace(const char *, int, int, pid_t);
int
rump___sysimpl_ktrace(const char * fname, int ops, int facs, pid_t pid)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_ktrace_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fname) = fname;
	SPARG(&callarg, ops) = ops;
	SPARG(&callarg, facs) = facs;
	SPARG(&callarg, pid) = pid;

	error = rsys_syscall(SYS_ktrace, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(ktrace,rump___sysimpl_ktrace);
__weak_alias(_ktrace,rump___sysimpl_ktrace);
__strong_alias(_sys_ktrace,rump___sysimpl_ktrace);
#endif /* RUMP_KERNEL_IS_LIBC */

gid_t rump___sysimpl_getgid(void);
gid_t
rump___sysimpl_getgid(void )
{
	register_t retval[2];
	gid_t rv = -1;

	(void)rsys_syscall(SYS_getgid, NULL, 0, retval);
	if (sizeof(gid_t) > sizeof(register_t))
		rv = *(gid_t *)retval;
	else
		rv = *retval;
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(getgid,rump___sysimpl_getgid);
__weak_alias(_getgid,rump___sysimpl_getgid);
__strong_alias(_sys_getgid,rump___sysimpl_getgid);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl___getlogin(char *, size_t);
int
rump___sysimpl___getlogin(char * namebuf, size_t namelen)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___getlogin_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, namebuf) = namebuf;
	SPARG(&callarg, namelen) = namelen;

	error = rsys_syscall(SYS___getlogin, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(__getlogin,rump___sysimpl___getlogin);
__weak_alias(___getlogin,rump___sysimpl___getlogin);
__strong_alias(_sys___getlogin,rump___sysimpl___getlogin);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl___setlogin(const char *);
int
rump___sysimpl___setlogin(const char * namebuf)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___setlogin_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, namebuf) = namebuf;

	error = rsys_syscall(SYS___setlogin, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(__setlogin,rump___sysimpl___setlogin);
__weak_alias(___setlogin,rump___sysimpl___setlogin);
__strong_alias(_sys___setlogin,rump___sysimpl___setlogin);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_ioctl(int, u_long, void *);
int
rump___sysimpl_ioctl(int fd, u_long com, void * data)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_ioctl_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, com) = com;
	SPARG(&callarg, data) = data;

	error = rsys_syscall(SYS_ioctl, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(ioctl,rump___sysimpl_ioctl);
__weak_alias(_ioctl,rump___sysimpl_ioctl);
__strong_alias(_sys_ioctl,rump___sysimpl_ioctl);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_revoke(const char *);
int
rump___sysimpl_revoke(const char * path)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_revoke_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;

	error = rsys_syscall(SYS_revoke, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(revoke,rump___sysimpl_revoke);
__weak_alias(_revoke,rump___sysimpl_revoke);
__strong_alias(_sys_revoke,rump___sysimpl_revoke);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_symlink(const char *, const char *);
int
rump___sysimpl_symlink(const char * path, const char * link)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_symlink_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, link) = link;

	error = rsys_syscall(SYS_symlink, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(symlink,rump___sysimpl_symlink);
__weak_alias(_symlink,rump___sysimpl_symlink);
__strong_alias(_sys_symlink,rump___sysimpl_symlink);
#endif /* RUMP_KERNEL_IS_LIBC */

ssize_t rump___sysimpl_readlink(const char *, char *, size_t);
ssize_t
rump___sysimpl_readlink(const char * path, char * buf, size_t count)
{
	register_t retval[2];
	int error = 0;
	ssize_t rv = -1;
	struct sys_readlink_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, count) = count;

	error = rsys_syscall(SYS_readlink, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(readlink,rump___sysimpl_readlink);
__weak_alias(_readlink,rump___sysimpl_readlink);
__strong_alias(_sys_readlink,rump___sysimpl_readlink);
#endif /* RUMP_KERNEL_IS_LIBC */

mode_t rump___sysimpl_umask(mode_t);
mode_t
rump___sysimpl_umask(mode_t newmask)
{
	register_t retval[2];
	int error = 0;
	mode_t rv = -1;
	struct sys_umask_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, newmask) = newmask;

	error = rsys_syscall(SYS_umask, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(mode_t) > sizeof(register_t))
			rv = *(mode_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(umask,rump___sysimpl_umask);
__weak_alias(_umask,rump___sysimpl_umask);
__strong_alias(_sys_umask,rump___sysimpl_umask);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_chroot(const char *);
int
rump___sysimpl_chroot(const char * path)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_chroot_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;

	error = rsys_syscall(SYS_chroot, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(chroot,rump___sysimpl_chroot);
__weak_alias(_chroot,rump___sysimpl_chroot);
__strong_alias(_sys_chroot,rump___sysimpl_chroot);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_getgroups(int, gid_t *);
int
rump___sysimpl_getgroups(int gidsetsize, gid_t * gidset)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_getgroups_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, gidsetsize) = gidsetsize;
	SPARG(&callarg, gidset) = gidset;

	error = rsys_syscall(SYS_getgroups, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(getgroups,rump___sysimpl_getgroups);
__weak_alias(_getgroups,rump___sysimpl_getgroups);
__strong_alias(_sys_getgroups,rump___sysimpl_getgroups);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_setgroups(int, const gid_t *);
int
rump___sysimpl_setgroups(int gidsetsize, const gid_t * gidset)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_setgroups_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, gidsetsize) = gidsetsize;
	SPARG(&callarg, gidset) = gidset;

	error = rsys_syscall(SYS_setgroups, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(setgroups,rump___sysimpl_setgroups);
__weak_alias(_setgroups,rump___sysimpl_setgroups);
__strong_alias(_sys_setgroups,rump___sysimpl_setgroups);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_getpgrp(void);
int
rump___sysimpl_getpgrp(void )
{
	register_t retval[2];
	int error = 0;
	int rv = -1;

	error = rsys_syscall(SYS_getpgrp, NULL, 0, retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(getpgrp,rump___sysimpl_getpgrp);
__weak_alias(_getpgrp,rump___sysimpl_getpgrp);
__strong_alias(_sys_getpgrp,rump___sysimpl_getpgrp);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_setpgid(pid_t, pid_t);
int
rump___sysimpl_setpgid(pid_t pid, pid_t pgid)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_setpgid_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, pid) = pid;
	SPARG(&callarg, pgid) = pgid;

	error = rsys_syscall(SYS_setpgid, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(setpgid,rump___sysimpl_setpgid);
__weak_alias(_setpgid,rump___sysimpl_setpgid);
__strong_alias(_sys_setpgid,rump___sysimpl_setpgid);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_dup2(int, int);
int
rump___sysimpl_dup2(int from, int to)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_dup2_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, from) = from;
	SPARG(&callarg, to) = to;

	error = rsys_syscall(SYS_dup2, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(dup2,rump___sysimpl_dup2);
__weak_alias(_dup2,rump___sysimpl_dup2);
__strong_alias(_sys_dup2,rump___sysimpl_dup2);
#endif /* RUMP_KERNEL_IS_LIBC */

ssize_t rump___sysimpl_getrandom(void *, size_t, unsigned int);
ssize_t
rump___sysimpl_getrandom(void * buf, size_t buflen, unsigned int flags)
{
	register_t retval[2];
	int error = 0;
	ssize_t rv = -1;
	struct sys_getrandom_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, buflen) = buflen;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_getrandom, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(getrandom,rump___sysimpl_getrandom);
__weak_alias(_getrandom,rump___sysimpl_getrandom);
__strong_alias(_sys_getrandom,rump___sysimpl_getrandom);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_fcntl(int, int, void *);
int
rump___sysimpl_fcntl(int fd, int cmd, void * arg)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_fcntl_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, cmd) = cmd;
	SPARG(&callarg, arg) = arg;

	error = rsys_syscall(SYS_fcntl, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(fcntl,rump___sysimpl_fcntl);
__weak_alias(_fcntl,rump___sysimpl_fcntl);
__strong_alias(_sys_fcntl,rump___sysimpl_fcntl);
#endif /* RUMP_KERNEL_IS_LIBC */

#ifdef RUMP_SYS_COMPAT
int rump___sysimpl_select(int, fd_set *, fd_set *, fd_set *, struct timeval *);
int
rump___sysimpl_select(int nd, fd_set * in, fd_set * ou, fd_set * ex, struct timeval * tv)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct compat_50_sys_select_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, nd) = nd;
	SPARG(&callarg, in) = in;
	SPARG(&callarg, ou) = ou;
	SPARG(&callarg, ex) = ex;
	SPARG(&callarg, tv) = (struct timeval50 *)tv;

	error = rsys_syscall(SYS_compat_50_select, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(select,rump___sysimpl_select);
__weak_alias(_select,rump___sysimpl_select);
__strong_alias(_sys_select,rump___sysimpl_select);
#endif /* RUMP_KERNEL_IS_LIBC */
#endif /* RUMP_SYS_COMPAT */

int rump___sysimpl_fsync(int);
int
rump___sysimpl_fsync(int fd)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_fsync_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;

	error = rsys_syscall(SYS_fsync, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(fsync,rump___sysimpl_fsync);
__weak_alias(_fsync,rump___sysimpl_fsync);
__strong_alias(_sys_fsync,rump___sysimpl_fsync);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_connect(int, const struct sockaddr *, socklen_t);
int
rump___sysimpl_connect(int s, const struct sockaddr * name, socklen_t namelen)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_connect_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, s) = s;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, namelen) = namelen;

	error = rsys_syscall(SYS_connect, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(connect,rump___sysimpl_connect);
__weak_alias(_connect,rump___sysimpl_connect);
__strong_alias(_sys_connect,rump___sysimpl_connect);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_bind(int, const struct sockaddr *, socklen_t);
int
rump___sysimpl_bind(int s, const struct sockaddr * name, socklen_t namelen)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_bind_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, s) = s;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, namelen) = namelen;

	error = rsys_syscall(SYS_bind, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(bind,rump___sysimpl_bind);
__weak_alias(_bind,rump___sysimpl_bind);
__strong_alias(_sys_bind,rump___sysimpl_bind);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_setsockopt(int, int, int, const void *, socklen_t);
int
rump___sysimpl_setsockopt(int s, int level, int name, const void * val, socklen_t valsize)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_setsockopt_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, s) = s;
	SPARG(&callarg, level) = level;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, val) = val;
	SPARG(&callarg, valsize) = valsize;

	error = rsys_syscall(SYS_setsockopt, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(setsockopt,rump___sysimpl_setsockopt);
__weak_alias(_setsockopt,rump___sysimpl_setsockopt);
__strong_alias(_sys_setsockopt,rump___sysimpl_setsockopt);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_listen(int, int);
int
rump___sysimpl_listen(int s, int backlog)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_listen_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, s) = s;
	SPARG(&callarg, backlog) = backlog;

	error = rsys_syscall(SYS_listen, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(listen,rump___sysimpl_listen);
__weak_alias(_listen,rump___sysimpl_listen);
__strong_alias(_sys_listen,rump___sysimpl_listen);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_getsockopt(int, int, int, void *, socklen_t *);
int
rump___sysimpl_getsockopt(int s, int level, int name, void * val, socklen_t * avalsize)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_getsockopt_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, s) = s;
	SPARG(&callarg, level) = level;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, val) = val;
	SPARG(&callarg, avalsize) = avalsize;

	error = rsys_syscall(SYS_getsockopt, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(getsockopt,rump___sysimpl_getsockopt);
__weak_alias(_getsockopt,rump___sysimpl_getsockopt);
__strong_alias(_sys_getsockopt,rump___sysimpl_getsockopt);
#endif /* RUMP_KERNEL_IS_LIBC */

ssize_t rump___sysimpl_readv(int, const struct iovec *, int);
ssize_t
rump___sysimpl_readv(int fd, const struct iovec * iovp, int iovcnt)
{
	register_t retval[2];
	int error = 0;
	ssize_t rv = -1;
	struct sys_readv_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, iovp) = iovp;
	SPARG(&callarg, iovcnt) = iovcnt;

	error = rsys_syscall(SYS_readv, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(readv,rump___sysimpl_readv);
__weak_alias(_readv,rump___sysimpl_readv);
__strong_alias(_sys_readv,rump___sysimpl_readv);
#endif /* RUMP_KERNEL_IS_LIBC */

ssize_t rump___sysimpl_writev(int, const struct iovec *, int);
ssize_t
rump___sysimpl_writev(int fd, const struct iovec * iovp, int iovcnt)
{
	register_t retval[2];
	int error = 0;
	ssize_t rv = -1;
	struct sys_writev_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, iovp) = iovp;
	SPARG(&callarg, iovcnt) = iovcnt;

	error = rsys_syscall(SYS_writev, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(writev,rump___sysimpl_writev);
__weak_alias(_writev,rump___sysimpl_writev);
__strong_alias(_sys_writev,rump___sysimpl_writev);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_fchown(int, uid_t, gid_t);
int
rump___sysimpl_fchown(int fd, uid_t uid, gid_t gid)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_fchown_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, uid) = uid;
	SPARG(&callarg, gid) = gid;

	error = rsys_syscall(SYS_fchown, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(fchown,rump___sysimpl_fchown);
__weak_alias(_fchown,rump___sysimpl_fchown);
__strong_alias(_sys_fchown,rump___sysimpl_fchown);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_fchmod(int, mode_t);
int
rump___sysimpl_fchmod(int fd, mode_t mode)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_fchmod_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, mode) = mode;

	error = rsys_syscall(SYS_fchmod, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(fchmod,rump___sysimpl_fchmod);
__weak_alias(_fchmod,rump___sysimpl_fchmod);
__strong_alias(_sys_fchmod,rump___sysimpl_fchmod);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_setreuid(uid_t, uid_t);
int
rump___sysimpl_setreuid(uid_t ruid, uid_t euid)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_setreuid_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, ruid) = ruid;
	SPARG(&callarg, euid) = euid;

	error = rsys_syscall(SYS_setreuid, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(setreuid,rump___sysimpl_setreuid);
__weak_alias(_setreuid,rump___sysimpl_setreuid);
__strong_alias(_sys_setreuid,rump___sysimpl_setreuid);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_setregid(gid_t, gid_t);
int
rump___sysimpl_setregid(gid_t rgid, gid_t egid)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_setregid_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, rgid) = rgid;
	SPARG(&callarg, egid) = egid;

	error = rsys_syscall(SYS_setregid, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(setregid,rump___sysimpl_setregid);
__weak_alias(_setregid,rump___sysimpl_setregid);
__strong_alias(_sys_setregid,rump___sysimpl_setregid);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_rename(const char *, const char *);
int
rump___sysimpl_rename(const char * from, const char * to)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_rename_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, from) = from;
	SPARG(&callarg, to) = to;

	error = rsys_syscall(SYS_rename, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(rename,rump___sysimpl_rename);
__weak_alias(_rename,rump___sysimpl_rename);
__strong_alias(_sys_rename,rump___sysimpl_rename);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_flock(int, int);
int
rump___sysimpl_flock(int fd, int how)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_flock_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, how) = how;

	error = rsys_syscall(SYS_flock, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(flock,rump___sysimpl_flock);
__weak_alias(_flock,rump___sysimpl_flock);
__strong_alias(_sys_flock,rump___sysimpl_flock);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_mkfifo(const char *, mode_t);
int
rump___sysimpl_mkfifo(const char * path, mode_t mode)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_mkfifo_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, mode) = mode;

	error = rsys_syscall(SYS_mkfifo, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(mkfifo,rump___sysimpl_mkfifo);
__weak_alias(_mkfifo,rump___sysimpl_mkfifo);
__strong_alias(_sys_mkfifo,rump___sysimpl_mkfifo);
#endif /* RUMP_KERNEL_IS_LIBC */

ssize_t rump___sysimpl_sendto(int, const void *, size_t, int, const struct sockaddr *, socklen_t);
ssize_t
rump___sysimpl_sendto(int s, const void * buf, size_t len, int flags, const struct sockaddr * to, socklen_t tolen)
{
	register_t retval[2];
	int error = 0;
	ssize_t rv = -1;
	struct sys_sendto_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, s) = s;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, len) = len;
	SPARG(&callarg, flags) = flags;
	SPARG(&callarg, to) = to;
	SPARG(&callarg, tolen) = tolen;

	error = rsys_syscall(SYS_sendto, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(sendto,rump___sysimpl_sendto);
__weak_alias(_sendto,rump___sysimpl_sendto);
__strong_alias(_sys_sendto,rump___sysimpl_sendto);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_shutdown(int, int);
int
rump___sysimpl_shutdown(int s, int how)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_shutdown_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, s) = s;
	SPARG(&callarg, how) = how;

	error = rsys_syscall(SYS_shutdown, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(shutdown,rump___sysimpl_shutdown);
__weak_alias(_shutdown,rump___sysimpl_shutdown);
__strong_alias(_sys_shutdown,rump___sysimpl_shutdown);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_socketpair(int, int, int, int *);
int
rump___sysimpl_socketpair(int domain, int type, int protocol, int * rsv)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_socketpair_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, domain) = domain;
	SPARG(&callarg, type) = type;
	SPARG(&callarg, protocol) = protocol;
	SPARG(&callarg, rsv) = rsv;

	error = rsys_syscall(SYS_socketpair, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(socketpair,rump___sysimpl_socketpair);
__weak_alias(_socketpair,rump___sysimpl_socketpair);
__strong_alias(_sys_socketpair,rump___sysimpl_socketpair);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_mkdir(const char *, mode_t);
int
rump___sysimpl_mkdir(const char * path, mode_t mode)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_mkdir_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, mode) = mode;

	error = rsys_syscall(SYS_mkdir, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(mkdir,rump___sysimpl_mkdir);
__weak_alias(_mkdir,rump___sysimpl_mkdir);
__strong_alias(_sys_mkdir,rump___sysimpl_mkdir);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_rmdir(const char *);
int
rump___sysimpl_rmdir(const char * path)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_rmdir_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;

	error = rsys_syscall(SYS_rmdir, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(rmdir,rump___sysimpl_rmdir);
__weak_alias(_rmdir,rump___sysimpl_rmdir);
__strong_alias(_sys_rmdir,rump___sysimpl_rmdir);
#endif /* RUMP_KERNEL_IS_LIBC */

#ifdef RUMP_SYS_COMPAT
int rump___sysimpl_utimes(const char *, const struct timeval *);
int
rump___sysimpl_utimes(const char * path, const struct timeval * tptr)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct compat_50_sys_utimes_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, tptr) = (const struct timeval50 *)tptr;

	error = rsys_syscall(SYS_compat_50_utimes, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(utimes,rump___sysimpl_utimes);
__weak_alias(_utimes,rump___sysimpl_utimes);
__strong_alias(_sys_utimes,rump___sysimpl_utimes);
#endif /* RUMP_KERNEL_IS_LIBC */
#endif /* RUMP_SYS_COMPAT */

int rump___sysimpl_setsid(void);
int
rump___sysimpl_setsid(void )
{
	register_t retval[2];
	int error = 0;
	int rv = -1;

	error = rsys_syscall(SYS_setsid, NULL, 0, retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(setsid,rump___sysimpl_setsid);
__weak_alias(_setsid,rump___sysimpl_setsid);
__strong_alias(_sys_setsid,rump___sysimpl_setsid);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_nfssvc(int, void *);
int
rump___sysimpl_nfssvc(int flag, void * argp)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_nfssvc_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, flag) = flag;
	SPARG(&callarg, argp) = argp;

	error = rsys_syscall(SYS_nfssvc, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(nfssvc,rump___sysimpl_nfssvc);
__weak_alias(_nfssvc,rump___sysimpl_nfssvc);
__strong_alias(_sys_nfssvc,rump___sysimpl_nfssvc);
#endif /* RUMP_KERNEL_IS_LIBC */

ssize_t rump___sysimpl_pread(int, void *, size_t, off_t);
ssize_t
rump___sysimpl_pread(int fd, void * buf, size_t nbyte, off_t offset)
{
	register_t retval[2];
	int error = 0;
	ssize_t rv = -1;
	struct sys_pread_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, nbyte) = nbyte;
	SPARG(&callarg, PAD) = 0;
	SPARG(&callarg, offset) = offset;

	error = rsys_syscall(SYS_pread, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(pread,rump___sysimpl_pread);
__weak_alias(_pread,rump___sysimpl_pread);
__strong_alias(_sys_pread,rump___sysimpl_pread);
#endif /* RUMP_KERNEL_IS_LIBC */

ssize_t rump___sysimpl_pwrite(int, const void *, size_t, off_t);
ssize_t
rump___sysimpl_pwrite(int fd, const void * buf, size_t nbyte, off_t offset)
{
	register_t retval[2];
	int error = 0;
	ssize_t rv = -1;
	struct sys_pwrite_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, nbyte) = nbyte;
	SPARG(&callarg, PAD) = 0;
	SPARG(&callarg, offset) = offset;

	error = rsys_syscall(SYS_pwrite, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(pwrite,rump___sysimpl_pwrite);
__weak_alias(_pwrite,rump___sysimpl_pwrite);
__strong_alias(_sys_pwrite,rump___sysimpl_pwrite);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_setgid(gid_t);
int
rump___sysimpl_setgid(gid_t gid)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_setgid_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, gid) = gid;

	error = rsys_syscall(SYS_setgid, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(setgid,rump___sysimpl_setgid);
__weak_alias(_setgid,rump___sysimpl_setgid);
__strong_alias(_sys_setgid,rump___sysimpl_setgid);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_setegid(gid_t);
int
rump___sysimpl_setegid(gid_t egid)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_setegid_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, egid) = egid;

	error = rsys_syscall(SYS_setegid, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(setegid,rump___sysimpl_setegid);
__weak_alias(_setegid,rump___sysimpl_setegid);
__strong_alias(_sys_setegid,rump___sysimpl_setegid);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_seteuid(uid_t);
int
rump___sysimpl_seteuid(uid_t euid)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_seteuid_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, euid) = euid;

	error = rsys_syscall(SYS_seteuid, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(seteuid,rump___sysimpl_seteuid);
__weak_alias(_seteuid,rump___sysimpl_seteuid);
__strong_alias(_sys_seteuid,rump___sysimpl_seteuid);
#endif /* RUMP_KERNEL_IS_LIBC */

long rump___sysimpl_pathconf(const char *, int);
long
rump___sysimpl_pathconf(const char * path, int name)
{
	register_t retval[2];
	int error = 0;
	long rv = -1;
	struct sys_pathconf_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, name) = name;

	error = rsys_syscall(SYS_pathconf, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(long) > sizeof(register_t))
			rv = *(long *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(pathconf,rump___sysimpl_pathconf);
__weak_alias(_pathconf,rump___sysimpl_pathconf);
__strong_alias(_sys_pathconf,rump___sysimpl_pathconf);
#endif /* RUMP_KERNEL_IS_LIBC */

long rump___sysimpl_fpathconf(int, int);
long
rump___sysimpl_fpathconf(int fd, int name)
{
	register_t retval[2];
	int error = 0;
	long rv = -1;
	struct sys_fpathconf_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, name) = name;

	error = rsys_syscall(SYS_fpathconf, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(long) > sizeof(register_t))
			rv = *(long *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(fpathconf,rump___sysimpl_fpathconf);
__weak_alias(_fpathconf,rump___sysimpl_fpathconf);
__strong_alias(_sys_fpathconf,rump___sysimpl_fpathconf);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_getsockopt2(int, int, int, void *, socklen_t *);
int
rump___sysimpl_getsockopt2(int s, int level, int name, void * val, socklen_t * avalsize)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_getsockopt2_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, s) = s;
	SPARG(&callarg, level) = level;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, val) = val;
	SPARG(&callarg, avalsize) = avalsize;

	error = rsys_syscall(SYS_getsockopt2, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(getsockopt2,rump___sysimpl_getsockopt2);
__weak_alias(_getsockopt2,rump___sysimpl_getsockopt2);
__strong_alias(_sys_getsockopt2,rump___sysimpl_getsockopt2);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_getrlimit(int, struct rlimit *);
int
rump___sysimpl_getrlimit(int which, struct rlimit * rlp)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_getrlimit_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, which) = which;
	SPARG(&callarg, rlp) = rlp;

	error = rsys_syscall(SYS_getrlimit, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(getrlimit,rump___sysimpl_getrlimit);
__weak_alias(_getrlimit,rump___sysimpl_getrlimit);
__strong_alias(_sys_getrlimit,rump___sysimpl_getrlimit);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_setrlimit(int, const struct rlimit *);
int
rump___sysimpl_setrlimit(int which, const struct rlimit * rlp)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_setrlimit_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, which) = which;
	SPARG(&callarg, rlp) = rlp;

	error = rsys_syscall(SYS_setrlimit, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(setrlimit,rump___sysimpl_setrlimit);
__weak_alias(_setrlimit,rump___sysimpl_setrlimit);
__strong_alias(_sys_setrlimit,rump___sysimpl_setrlimit);
#endif /* RUMP_KERNEL_IS_LIBC */

off_t rump___sysimpl_lseek(int, off_t, int);
off_t
rump___sysimpl_lseek(int fd, off_t offset, int whence)
{
	register_t retval[2];
	int error = 0;
	off_t rv = -1;
	struct sys_lseek_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, PAD) = 0;
	SPARG(&callarg, offset) = offset;
	SPARG(&callarg, whence) = whence;

	error = rsys_syscall(SYS_lseek, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(off_t) > sizeof(register_t))
			rv = *(off_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(lseek,rump___sysimpl_lseek);
__weak_alias(_lseek,rump___sysimpl_lseek);
__strong_alias(_sys_lseek,rump___sysimpl_lseek);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_truncate(const char *, off_t);
int
rump___sysimpl_truncate(const char * path, off_t length)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_truncate_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, PAD) = 0;
	SPARG(&callarg, length) = length;

	error = rsys_syscall(SYS_truncate, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(truncate,rump___sysimpl_truncate);
__weak_alias(_truncate,rump___sysimpl_truncate);
__strong_alias(_sys_truncate,rump___sysimpl_truncate);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_ftruncate(int, off_t);
int
rump___sysimpl_ftruncate(int fd, off_t length)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_ftruncate_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, PAD) = 0;
	SPARG(&callarg, length) = length;

	error = rsys_syscall(SYS_ftruncate, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(ftruncate,rump___sysimpl_ftruncate);
__weak_alias(_ftruncate,rump___sysimpl_ftruncate);
__strong_alias(_sys_ftruncate,rump___sysimpl_ftruncate);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl___sysctl(const int *, u_int, void *, size_t *, const void *, size_t);
int
rump___sysimpl___sysctl(const int * name, u_int namelen, void * oldv, size_t * oldlenp, const void * newv, size_t newlen)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___sysctl_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, name) = name;
	SPARG(&callarg, namelen) = namelen;
	SPARG(&callarg, oldv) = oldv;
	SPARG(&callarg, oldlenp) = oldlenp;
	SPARG(&callarg, newv) = newv;
	SPARG(&callarg, newlen) = newlen;

	error = rsys_syscall(SYS___sysctl, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(__sysctl,rump___sysimpl___sysctl);
__weak_alias(___sysctl,rump___sysimpl___sysctl);
__strong_alias(_sys___sysctl,rump___sysimpl___sysctl);
#endif /* RUMP_KERNEL_IS_LIBC */

#ifdef RUMP_SYS_COMPAT
int rump___sysimpl_futimes(int, const struct timeval *);
int
rump___sysimpl_futimes(int fd, const struct timeval * tptr)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct compat_50_sys_futimes_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, tptr) = (const struct timeval50 *)tptr;

	error = rsys_syscall(SYS_compat_50_futimes, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(futimes,rump___sysimpl_futimes);
__weak_alias(_futimes,rump___sysimpl_futimes);
__strong_alias(_sys_futimes,rump___sysimpl_futimes);
#endif /* RUMP_KERNEL_IS_LIBC */
#endif /* RUMP_SYS_COMPAT */

pid_t rump___sysimpl_getpgid(pid_t);
pid_t
rump___sysimpl_getpgid(pid_t pid)
{
	register_t retval[2];
	int error = 0;
	pid_t rv = -1;
	struct sys_getpgid_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, pid) = pid;

	error = rsys_syscall(SYS_getpgid, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(pid_t) > sizeof(register_t))
			rv = *(pid_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(getpgid,rump___sysimpl_getpgid);
__weak_alias(_getpgid,rump___sysimpl_getpgid);
__strong_alias(_sys_getpgid,rump___sysimpl_getpgid);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_reboot(int, char *);
int
rump___sysimpl_reboot(int opt, char * bootstr)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_reboot_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, opt) = opt;
	SPARG(&callarg, bootstr) = bootstr;

	error = rsys_syscall(SYS_reboot, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(reboot,rump___sysimpl_reboot);
__weak_alias(_reboot,rump___sysimpl_reboot);
__strong_alias(_sys_reboot,rump___sysimpl_reboot);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_poll(struct pollfd *, u_int, int);
int
rump___sysimpl_poll(struct pollfd * fds, u_int nfds, int timeout)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_poll_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fds) = fds;
	SPARG(&callarg, nfds) = nfds;
	SPARG(&callarg, timeout) = timeout;

	error = rsys_syscall(SYS_poll, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(poll,rump___sysimpl_poll);
__weak_alias(_poll,rump___sysimpl_poll);
__strong_alias(_sys_poll,rump___sysimpl_poll);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_timer_create(clockid_t, struct sigevent *, timer_t *);
int
rump___sysimpl_timer_create(clockid_t clock_id, struct sigevent * evp, timer_t * timerid)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_timer_create_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, clock_id) = clock_id;
	SPARG(&callarg, evp) = evp;
	SPARG(&callarg, timerid) = timerid;

	error = rsys_syscall(SYS_timer_create, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(timer_create,rump___sysimpl_timer_create);
__weak_alias(_timer_create,rump___sysimpl_timer_create);
__strong_alias(_sys_timer_create,rump___sysimpl_timer_create);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_timer_delete(timer_t);
int
rump___sysimpl_timer_delete(timer_t timerid)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_timer_delete_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, timerid) = timerid;

	error = rsys_syscall(SYS_timer_delete, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(timer_delete,rump___sysimpl_timer_delete);
__weak_alias(_timer_delete,rump___sysimpl_timer_delete);
__strong_alias(_sys_timer_delete,rump___sysimpl_timer_delete);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_timer_getoverrun(timer_t);
int
rump___sysimpl_timer_getoverrun(timer_t timerid)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_timer_getoverrun_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, timerid) = timerid;

	error = rsys_syscall(SYS_timer_getoverrun, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(timer_getoverrun,rump___sysimpl_timer_getoverrun);
__weak_alias(_timer_getoverrun,rump___sysimpl_timer_getoverrun);
__strong_alias(_sys_timer_getoverrun,rump___sysimpl_timer_getoverrun);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_fdatasync(int);
int
rump___sysimpl_fdatasync(int fd)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_fdatasync_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;

	error = rsys_syscall(SYS_fdatasync, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(fdatasync,rump___sysimpl_fdatasync);
__weak_alias(_fdatasync,rump___sysimpl_fdatasync);
__strong_alias(_sys_fdatasync,rump___sysimpl_fdatasync);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_modctl(int, void *);
int
rump___sysimpl_modctl(int cmd, void * arg)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_modctl_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, cmd) = cmd;
	SPARG(&callarg, arg) = arg;

	error = rsys_syscall(SYS_modctl, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(modctl,rump___sysimpl_modctl);
__weak_alias(_modctl,rump___sysimpl_modctl);
__strong_alias(_sys_modctl,rump___sysimpl_modctl);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl__ksem_init(unsigned int, intptr_t *);
int
rump___sysimpl__ksem_init(unsigned int value, intptr_t * idp)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys__ksem_init_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, value) = value;
	SPARG(&callarg, idp) = idp;

	error = rsys_syscall(SYS__ksem_init, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(_ksem_init,rump___sysimpl__ksem_init);
__weak_alias(__ksem_init,rump___sysimpl__ksem_init);
__strong_alias(_sys__ksem_init,rump___sysimpl__ksem_init);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl__ksem_open(const char *, int, mode_t, unsigned int, intptr_t *);
int
rump___sysimpl__ksem_open(const char * name, int oflag, mode_t mode, unsigned int value, intptr_t * idp)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys__ksem_open_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, name) = name;
	SPARG(&callarg, oflag) = oflag;
	SPARG(&callarg, mode) = mode;
	SPARG(&callarg, value) = value;
	SPARG(&callarg, idp) = idp;

	error = rsys_syscall(SYS__ksem_open, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(_ksem_open,rump___sysimpl__ksem_open);
__weak_alias(__ksem_open,rump___sysimpl__ksem_open);
__strong_alias(_sys__ksem_open,rump___sysimpl__ksem_open);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl__ksem_unlink(const char *);
int
rump___sysimpl__ksem_unlink(const char * name)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys__ksem_unlink_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, name) = name;

	error = rsys_syscall(SYS__ksem_unlink, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(_ksem_unlink,rump___sysimpl__ksem_unlink);
__weak_alias(__ksem_unlink,rump___sysimpl__ksem_unlink);
__strong_alias(_sys__ksem_unlink,rump___sysimpl__ksem_unlink);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl__ksem_close(intptr_t);
int
rump___sysimpl__ksem_close(intptr_t id)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys__ksem_close_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, id) = id;

	error = rsys_syscall(SYS__ksem_close, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(_ksem_close,rump___sysimpl__ksem_close);
__weak_alias(__ksem_close,rump___sysimpl__ksem_close);
__strong_alias(_sys__ksem_close,rump___sysimpl__ksem_close);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl__ksem_post(intptr_t);
int
rump___sysimpl__ksem_post(intptr_t id)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys__ksem_post_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, id) = id;

	error = rsys_syscall(SYS__ksem_post, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(_ksem_post,rump___sysimpl__ksem_post);
__weak_alias(__ksem_post,rump___sysimpl__ksem_post);
__strong_alias(_sys__ksem_post,rump___sysimpl__ksem_post);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl__ksem_wait(intptr_t);
int
rump___sysimpl__ksem_wait(intptr_t id)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys__ksem_wait_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, id) = id;

	error = rsys_syscall(SYS__ksem_wait, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(_ksem_wait,rump___sysimpl__ksem_wait);
__weak_alias(__ksem_wait,rump___sysimpl__ksem_wait);
__strong_alias(_sys__ksem_wait,rump___sysimpl__ksem_wait);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl__ksem_trywait(intptr_t);
int
rump___sysimpl__ksem_trywait(intptr_t id)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys__ksem_trywait_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, id) = id;

	error = rsys_syscall(SYS__ksem_trywait, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(_ksem_trywait,rump___sysimpl__ksem_trywait);
__weak_alias(__ksem_trywait,rump___sysimpl__ksem_trywait);
__strong_alias(_sys__ksem_trywait,rump___sysimpl__ksem_trywait);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl__ksem_getvalue(intptr_t, unsigned int *);
int
rump___sysimpl__ksem_getvalue(intptr_t id, unsigned int * value)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys__ksem_getvalue_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, id) = id;
	SPARG(&callarg, value) = value;

	error = rsys_syscall(SYS__ksem_getvalue, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(_ksem_getvalue,rump___sysimpl__ksem_getvalue);
__weak_alias(__ksem_getvalue,rump___sysimpl__ksem_getvalue);
__strong_alias(_sys__ksem_getvalue,rump___sysimpl__ksem_getvalue);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl__ksem_destroy(intptr_t);
int
rump___sysimpl__ksem_destroy(intptr_t id)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys__ksem_destroy_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, id) = id;

	error = rsys_syscall(SYS__ksem_destroy, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(_ksem_destroy,rump___sysimpl__ksem_destroy);
__weak_alias(__ksem_destroy,rump___sysimpl__ksem_destroy);
__strong_alias(_sys__ksem_destroy,rump___sysimpl__ksem_destroy);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl__ksem_timedwait(intptr_t, const struct timespec *);
int
rump___sysimpl__ksem_timedwait(intptr_t id, const struct timespec * abstime)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys__ksem_timedwait_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, id) = id;
	SPARG(&callarg, abstime) = abstime;

	error = rsys_syscall(SYS__ksem_timedwait, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(_ksem_timedwait,rump___sysimpl__ksem_timedwait);
__weak_alias(__ksem_timedwait,rump___sysimpl__ksem_timedwait);
__strong_alias(_sys__ksem_timedwait,rump___sysimpl__ksem_timedwait);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl___posix_rename(const char *, const char *);
int
rump___sysimpl___posix_rename(const char * from, const char * to)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___posix_rename_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, from) = from;
	SPARG(&callarg, to) = to;

	error = rsys_syscall(SYS___posix_rename, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(__posix_rename,rump___sysimpl___posix_rename);
__weak_alias(___posix_rename,rump___sysimpl___posix_rename);
__strong_alias(_sys___posix_rename,rump___sysimpl___posix_rename);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_lchmod(const char *, mode_t);
int
rump___sysimpl_lchmod(const char * path, mode_t mode)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_lchmod_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, mode) = mode;

	error = rsys_syscall(SYS_lchmod, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(lchmod,rump___sysimpl_lchmod);
__weak_alias(_lchmod,rump___sysimpl_lchmod);
__strong_alias(_sys_lchmod,rump___sysimpl_lchmod);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_lchown(const char *, uid_t, gid_t);
int
rump___sysimpl_lchown(const char * path, uid_t uid, gid_t gid)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_lchown_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, uid) = uid;
	SPARG(&callarg, gid) = gid;

	error = rsys_syscall(SYS_lchown, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(lchown,rump___sysimpl_lchown);
__weak_alias(_lchown,rump___sysimpl_lchown);
__strong_alias(_sys_lchown,rump___sysimpl_lchown);
#endif /* RUMP_KERNEL_IS_LIBC */

#ifdef RUMP_SYS_COMPAT
int rump___sysimpl_lutimes(const char *, const struct timeval *);
int
rump___sysimpl_lutimes(const char * path, const struct timeval * tptr)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct compat_50_sys_lutimes_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, tptr) = (const struct timeval50 *)tptr;

	error = rsys_syscall(SYS_compat_50_lutimes, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(lutimes,rump___sysimpl_lutimes);
__weak_alias(_lutimes,rump___sysimpl_lutimes);
__strong_alias(_sys_lutimes,rump___sysimpl_lutimes);
#endif /* RUMP_KERNEL_IS_LIBC */
#endif /* RUMP_SYS_COMPAT */

int rump___sysimpl___posix_chown(const char *, uid_t, gid_t);
int
rump___sysimpl___posix_chown(const char * path, uid_t uid, gid_t gid)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___posix_chown_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, uid) = uid;
	SPARG(&callarg, gid) = gid;

	error = rsys_syscall(SYS___posix_chown, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(__posix_chown,rump___sysimpl___posix_chown);
__weak_alias(___posix_chown,rump___sysimpl___posix_chown);
__strong_alias(_sys___posix_chown,rump___sysimpl___posix_chown);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl___posix_fchown(int, uid_t, gid_t);
int
rump___sysimpl___posix_fchown(int fd, uid_t uid, gid_t gid)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___posix_fchown_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, uid) = uid;
	SPARG(&callarg, gid) = gid;

	error = rsys_syscall(SYS___posix_fchown, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(__posix_fchown,rump___sysimpl___posix_fchown);
__weak_alias(___posix_fchown,rump___sysimpl___posix_fchown);
__strong_alias(_sys___posix_fchown,rump___sysimpl___posix_fchown);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl___posix_lchown(const char *, uid_t, gid_t);
int
rump___sysimpl___posix_lchown(const char * path, uid_t uid, gid_t gid)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___posix_lchown_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, uid) = uid;
	SPARG(&callarg, gid) = gid;

	error = rsys_syscall(SYS___posix_lchown, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(__posix_lchown,rump___sysimpl___posix_lchown);
__weak_alias(___posix_lchown,rump___sysimpl___posix_lchown);
__strong_alias(_sys___posix_lchown,rump___sysimpl___posix_lchown);
#endif /* RUMP_KERNEL_IS_LIBC */

pid_t rump___sysimpl_getsid(pid_t);
pid_t
rump___sysimpl_getsid(pid_t pid)
{
	register_t retval[2];
	int error = 0;
	pid_t rv = -1;
	struct sys_getsid_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, pid) = pid;

	error = rsys_syscall(SYS_getsid, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(pid_t) > sizeof(register_t))
			rv = *(pid_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(getsid,rump___sysimpl_getsid);
__weak_alias(_getsid,rump___sysimpl_getsid);
__strong_alias(_sys_getsid,rump___sysimpl_getsid);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_fktrace(int, int, int, pid_t);
int
rump___sysimpl_fktrace(int fd, int ops, int facs, pid_t pid)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_fktrace_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, ops) = ops;
	SPARG(&callarg, facs) = facs;
	SPARG(&callarg, pid) = pid;

	error = rsys_syscall(SYS_fktrace, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(fktrace,rump___sysimpl_fktrace);
__weak_alias(_fktrace,rump___sysimpl_fktrace);
__strong_alias(_sys_fktrace,rump___sysimpl_fktrace);
#endif /* RUMP_KERNEL_IS_LIBC */

ssize_t rump___sysimpl_preadv(int, const struct iovec *, int, off_t);
ssize_t
rump___sysimpl_preadv(int fd, const struct iovec * iovp, int iovcnt, off_t offset)
{
	register_t retval[2];
	int error = 0;
	ssize_t rv = -1;
	struct sys_preadv_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, iovp) = iovp;
	SPARG(&callarg, iovcnt) = iovcnt;
	SPARG(&callarg, PAD) = 0;
	SPARG(&callarg, offset) = offset;

	error = rsys_syscall(SYS_preadv, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(preadv,rump___sysimpl_preadv);
__weak_alias(_preadv,rump___sysimpl_preadv);
__strong_alias(_sys_preadv,rump___sysimpl_preadv);
#endif /* RUMP_KERNEL_IS_LIBC */

ssize_t rump___sysimpl_pwritev(int, const struct iovec *, int, off_t);
ssize_t
rump___sysimpl_pwritev(int fd, const struct iovec * iovp, int iovcnt, off_t offset)
{
	register_t retval[2];
	int error = 0;
	ssize_t rv = -1;
	struct sys_pwritev_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, iovp) = iovp;
	SPARG(&callarg, iovcnt) = iovcnt;
	SPARG(&callarg, PAD) = 0;
	SPARG(&callarg, offset) = offset;

	error = rsys_syscall(SYS_pwritev, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(pwritev,rump___sysimpl_pwritev);
__weak_alias(_pwritev,rump___sysimpl_pwritev);
__strong_alias(_sys_pwritev,rump___sysimpl_pwritev);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl___getcwd(char *, size_t);
int
rump___sysimpl___getcwd(char * bufp, size_t length)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___getcwd_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, bufp) = bufp;
	SPARG(&callarg, length) = length;

	error = rsys_syscall(SYS___getcwd, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(__getcwd,rump___sysimpl___getcwd);
__weak_alias(___getcwd,rump___sysimpl___getcwd);
__strong_alias(_sys___getcwd,rump___sysimpl___getcwd);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_fchroot(int);
int
rump___sysimpl_fchroot(int fd)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_fchroot_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;

	error = rsys_syscall(SYS_fchroot, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(fchroot,rump___sysimpl_fchroot);
__weak_alias(_fchroot,rump___sysimpl_fchroot);
__strong_alias(_sys_fchroot,rump___sysimpl_fchroot);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_lchflags(const char *, u_long);
int
rump___sysimpl_lchflags(const char * path, u_long flags)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_lchflags_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_lchflags, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(lchflags,rump___sysimpl_lchflags);
__weak_alias(_lchflags,rump___sysimpl_lchflags);
__strong_alias(_sys_lchflags,rump___sysimpl_lchflags);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_issetugid(void);
int
rump___sysimpl_issetugid(void )
{
	register_t retval[2];
	int rv = -1;

	(void)rsys_syscall(SYS_issetugid, NULL, 0, retval);
	if (sizeof(int) > sizeof(register_t))
		rv = *(int *)retval;
	else
		rv = *retval;
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(issetugid,rump___sysimpl_issetugid);
__weak_alias(_issetugid,rump___sysimpl_issetugid);
__strong_alias(_sys_issetugid,rump___sysimpl_issetugid);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_utrace(const char *, void *, size_t);
int
rump___sysimpl_utrace(const char * label, void * addr, size_t len)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_utrace_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, label) = label;
	SPARG(&callarg, addr) = addr;
	SPARG(&callarg, len) = len;

	error = rsys_syscall(SYS_utrace, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(utrace,rump___sysimpl_utrace);
__weak_alias(_utrace,rump___sysimpl_utrace);
__strong_alias(_sys_utrace,rump___sysimpl_utrace);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_kqueue(void);
int
rump___sysimpl_kqueue(void )
{
	register_t retval[2];
	int error = 0;
	int rv = -1;

	error = rsys_syscall(SYS_kqueue, NULL, 0, retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(kqueue,rump___sysimpl_kqueue);
__weak_alias(_kqueue,rump___sysimpl_kqueue);
__strong_alias(_sys_kqueue,rump___sysimpl_kqueue);
#endif /* RUMP_KERNEL_IS_LIBC */

#ifdef RUMP_SYS_COMPAT
int rump___sysimpl_kevent(int, const struct kevent *, size_t, struct kevent *, size_t, const struct timespec *);
int
rump___sysimpl_kevent(int fd, const struct kevent * changelist, size_t nchanges, struct kevent * eventlist, size_t nevents, const struct timespec * timeout)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct compat_50_sys_kevent_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, changelist) = (const struct kevent100 *)changelist;
	SPARG(&callarg, nchanges) = nchanges;
	SPARG(&callarg, eventlist) = (struct kevent100 *)eventlist;
	SPARG(&callarg, nevents) = nevents;
	SPARG(&callarg, timeout) = (const struct timespec50 *)timeout;

	error = rsys_syscall(SYS_compat_50_kevent, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(kevent,rump___sysimpl_kevent);
__weak_alias(_kevent,rump___sysimpl_kevent);
__strong_alias(_sys_kevent,rump___sysimpl_kevent);
#endif /* RUMP_KERNEL_IS_LIBC */
#endif /* RUMP_SYS_COMPAT */

int rump___sysimpl_fsync_range(int, int, off_t, off_t);
int
rump___sysimpl_fsync_range(int fd, int flags, off_t start, off_t length)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_fsync_range_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, flags) = flags;
	SPARG(&callarg, start) = start;
	SPARG(&callarg, length) = length;

	error = rsys_syscall(SYS_fsync_range, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(fsync_range,rump___sysimpl_fsync_range);
__weak_alias(_fsync_range,rump___sysimpl_fsync_range);
__strong_alias(_sys_fsync_range,rump___sysimpl_fsync_range);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_extattrctl(const char *, int, const char *, int, const char *);
int
rump___sysimpl_extattrctl(const char * path, int cmd, const char * filename, int attrnamespace, const char * attrname)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_extattrctl_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, cmd) = cmd;
	SPARG(&callarg, filename) = filename;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, attrname) = attrname;

	error = rsys_syscall(SYS_extattrctl, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(extattrctl,rump___sysimpl_extattrctl);
__weak_alias(_extattrctl,rump___sysimpl_extattrctl);
__strong_alias(_sys_extattrctl,rump___sysimpl_extattrctl);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_extattr_set_file(const char *, int, const char *, const void *, size_t);
int
rump___sysimpl_extattr_set_file(const char * path, int attrnamespace, const char * attrname, const void * data, size_t nbytes)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_extattr_set_file_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, attrname) = attrname;
	SPARG(&callarg, data) = data;
	SPARG(&callarg, nbytes) = nbytes;

	error = rsys_syscall(SYS_extattr_set_file, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(extattr_set_file,rump___sysimpl_extattr_set_file);
__weak_alias(_extattr_set_file,rump___sysimpl_extattr_set_file);
__strong_alias(_sys_extattr_set_file,rump___sysimpl_extattr_set_file);
#endif /* RUMP_KERNEL_IS_LIBC */

ssize_t rump___sysimpl_extattr_get_file(const char *, int, const char *, void *, size_t);
ssize_t
rump___sysimpl_extattr_get_file(const char * path, int attrnamespace, const char * attrname, void * data, size_t nbytes)
{
	register_t retval[2];
	int error = 0;
	ssize_t rv = -1;
	struct sys_extattr_get_file_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, attrname) = attrname;
	SPARG(&callarg, data) = data;
	SPARG(&callarg, nbytes) = nbytes;

	error = rsys_syscall(SYS_extattr_get_file, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(extattr_get_file,rump___sysimpl_extattr_get_file);
__weak_alias(_extattr_get_file,rump___sysimpl_extattr_get_file);
__strong_alias(_sys_extattr_get_file,rump___sysimpl_extattr_get_file);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_extattr_delete_file(const char *, int, const char *);
int
rump___sysimpl_extattr_delete_file(const char * path, int attrnamespace, const char * attrname)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_extattr_delete_file_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, attrname) = attrname;

	error = rsys_syscall(SYS_extattr_delete_file, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(extattr_delete_file,rump___sysimpl_extattr_delete_file);
__weak_alias(_extattr_delete_file,rump___sysimpl_extattr_delete_file);
__strong_alias(_sys_extattr_delete_file,rump___sysimpl_extattr_delete_file);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_extattr_set_fd(int, int, const char *, const void *, size_t);
int
rump___sysimpl_extattr_set_fd(int fd, int attrnamespace, const char * attrname, const void * data, size_t nbytes)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_extattr_set_fd_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, attrname) = attrname;
	SPARG(&callarg, data) = data;
	SPARG(&callarg, nbytes) = nbytes;

	error = rsys_syscall(SYS_extattr_set_fd, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(extattr_set_fd,rump___sysimpl_extattr_set_fd);
__weak_alias(_extattr_set_fd,rump___sysimpl_extattr_set_fd);
__strong_alias(_sys_extattr_set_fd,rump___sysimpl_extattr_set_fd);
#endif /* RUMP_KERNEL_IS_LIBC */

ssize_t rump___sysimpl_extattr_get_fd(int, int, const char *, void *, size_t);
ssize_t
rump___sysimpl_extattr_get_fd(int fd, int attrnamespace, const char * attrname, void * data, size_t nbytes)
{
	register_t retval[2];
	int error = 0;
	ssize_t rv = -1;
	struct sys_extattr_get_fd_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, attrname) = attrname;
	SPARG(&callarg, data) = data;
	SPARG(&callarg, nbytes) = nbytes;

	error = rsys_syscall(SYS_extattr_get_fd, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(extattr_get_fd,rump___sysimpl_extattr_get_fd);
__weak_alias(_extattr_get_fd,rump___sysimpl_extattr_get_fd);
__strong_alias(_sys_extattr_get_fd,rump___sysimpl_extattr_get_fd);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_extattr_delete_fd(int, int, const char *);
int
rump___sysimpl_extattr_delete_fd(int fd, int attrnamespace, const char * attrname)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_extattr_delete_fd_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, attrname) = attrname;

	error = rsys_syscall(SYS_extattr_delete_fd, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(extattr_delete_fd,rump___sysimpl_extattr_delete_fd);
__weak_alias(_extattr_delete_fd,rump___sysimpl_extattr_delete_fd);
__strong_alias(_sys_extattr_delete_fd,rump___sysimpl_extattr_delete_fd);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_extattr_set_link(const char *, int, const char *, const void *, size_t);
int
rump___sysimpl_extattr_set_link(const char * path, int attrnamespace, const char * attrname, const void * data, size_t nbytes)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_extattr_set_link_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, attrname) = attrname;
	SPARG(&callarg, data) = data;
	SPARG(&callarg, nbytes) = nbytes;

	error = rsys_syscall(SYS_extattr_set_link, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(extattr_set_link,rump___sysimpl_extattr_set_link);
__weak_alias(_extattr_set_link,rump___sysimpl_extattr_set_link);
__strong_alias(_sys_extattr_set_link,rump___sysimpl_extattr_set_link);
#endif /* RUMP_KERNEL_IS_LIBC */

ssize_t rump___sysimpl_extattr_get_link(const char *, int, const char *, void *, size_t);
ssize_t
rump___sysimpl_extattr_get_link(const char * path, int attrnamespace, const char * attrname, void * data, size_t nbytes)
{
	register_t retval[2];
	int error = 0;
	ssize_t rv = -1;
	struct sys_extattr_get_link_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, attrname) = attrname;
	SPARG(&callarg, data) = data;
	SPARG(&callarg, nbytes) = nbytes;

	error = rsys_syscall(SYS_extattr_get_link, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(extattr_get_link,rump___sysimpl_extattr_get_link);
__weak_alias(_extattr_get_link,rump___sysimpl_extattr_get_link);
__strong_alias(_sys_extattr_get_link,rump___sysimpl_extattr_get_link);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_extattr_delete_link(const char *, int, const char *);
int
rump___sysimpl_extattr_delete_link(const char * path, int attrnamespace, const char * attrname)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_extattr_delete_link_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, attrname) = attrname;

	error = rsys_syscall(SYS_extattr_delete_link, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(extattr_delete_link,rump___sysimpl_extattr_delete_link);
__weak_alias(_extattr_delete_link,rump___sysimpl_extattr_delete_link);
__strong_alias(_sys_extattr_delete_link,rump___sysimpl_extattr_delete_link);
#endif /* RUMP_KERNEL_IS_LIBC */

ssize_t rump___sysimpl_extattr_list_fd(int, int, void *, size_t);
ssize_t
rump___sysimpl_extattr_list_fd(int fd, int attrnamespace, void * data, size_t nbytes)
{
	register_t retval[2];
	int error = 0;
	ssize_t rv = -1;
	struct sys_extattr_list_fd_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, data) = data;
	SPARG(&callarg, nbytes) = nbytes;

	error = rsys_syscall(SYS_extattr_list_fd, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(extattr_list_fd,rump___sysimpl_extattr_list_fd);
__weak_alias(_extattr_list_fd,rump___sysimpl_extattr_list_fd);
__strong_alias(_sys_extattr_list_fd,rump___sysimpl_extattr_list_fd);
#endif /* RUMP_KERNEL_IS_LIBC */

ssize_t rump___sysimpl_extattr_list_file(const char *, int, void *, size_t);
ssize_t
rump___sysimpl_extattr_list_file(const char * path, int attrnamespace, void * data, size_t nbytes)
{
	register_t retval[2];
	int error = 0;
	ssize_t rv = -1;
	struct sys_extattr_list_file_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, data) = data;
	SPARG(&callarg, nbytes) = nbytes;

	error = rsys_syscall(SYS_extattr_list_file, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(extattr_list_file,rump___sysimpl_extattr_list_file);
__weak_alias(_extattr_list_file,rump___sysimpl_extattr_list_file);
__strong_alias(_sys_extattr_list_file,rump___sysimpl_extattr_list_file);
#endif /* RUMP_KERNEL_IS_LIBC */

ssize_t rump___sysimpl_extattr_list_link(const char *, int, void *, size_t);
ssize_t
rump___sysimpl_extattr_list_link(const char * path, int attrnamespace, void * data, size_t nbytes)
{
	register_t retval[2];
	int error = 0;
	ssize_t rv = -1;
	struct sys_extattr_list_link_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, data) = data;
	SPARG(&callarg, nbytes) = nbytes;

	error = rsys_syscall(SYS_extattr_list_link, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(extattr_list_link,rump___sysimpl_extattr_list_link);
__weak_alias(_extattr_list_link,rump___sysimpl_extattr_list_link);
__strong_alias(_sys_extattr_list_link,rump___sysimpl_extattr_list_link);
#endif /* RUMP_KERNEL_IS_LIBC */

#ifdef RUMP_SYS_COMPAT
int rump___sysimpl_pselect(int, fd_set *, fd_set *, fd_set *, const struct timespec *, const sigset_t *);
int
rump___sysimpl_pselect(int nd, fd_set * in, fd_set * ou, fd_set * ex, const struct timespec * ts, const sigset_t * mask)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct compat_50_sys_pselect_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, nd) = nd;
	SPARG(&callarg, in) = in;
	SPARG(&callarg, ou) = ou;
	SPARG(&callarg, ex) = ex;
	SPARG(&callarg, ts) = (const struct timespec50 *)ts;
	SPARG(&callarg, mask) = mask;

	error = rsys_syscall(SYS_compat_50_pselect, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(pselect,rump___sysimpl_pselect);
__weak_alias(_pselect,rump___sysimpl_pselect);
__strong_alias(_sys_pselect,rump___sysimpl_pselect);
#endif /* RUMP_KERNEL_IS_LIBC */
#endif /* RUMP_SYS_COMPAT */

#ifdef RUMP_SYS_COMPAT
int rump___sysimpl_pollts(struct pollfd *, u_int, const struct timespec *, const sigset_t *);
int
rump___sysimpl_pollts(struct pollfd * fds, u_int nfds, const struct timespec * ts, const sigset_t * mask)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct compat_50_sys_pollts_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fds) = fds;
	SPARG(&callarg, nfds) = nfds;
	SPARG(&callarg, ts) = (const struct timespec50 *)ts;
	SPARG(&callarg, mask) = mask;

	error = rsys_syscall(SYS_compat_50_pollts, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(pollts,rump___sysimpl_pollts);
__weak_alias(_pollts,rump___sysimpl_pollts);
__strong_alias(_sys_pollts,rump___sysimpl_pollts);
#endif /* RUMP_KERNEL_IS_LIBC */
#endif /* RUMP_SYS_COMPAT */

int rump___sysimpl_setxattr(const char *, const char *, const void *, size_t, int);
int
rump___sysimpl_setxattr(const char * path, const char * name, const void * value, size_t size, int flags)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_setxattr_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, value) = value;
	SPARG(&callarg, size) = size;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_setxattr, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(setxattr,rump___sysimpl_setxattr);
__weak_alias(_setxattr,rump___sysimpl_setxattr);
__strong_alias(_sys_setxattr,rump___sysimpl_setxattr);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_lsetxattr(const char *, const char *, const void *, size_t, int);
int
rump___sysimpl_lsetxattr(const char * path, const char * name, const void * value, size_t size, int flags)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_lsetxattr_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, value) = value;
	SPARG(&callarg, size) = size;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_lsetxattr, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(lsetxattr,rump___sysimpl_lsetxattr);
__weak_alias(_lsetxattr,rump___sysimpl_lsetxattr);
__strong_alias(_sys_lsetxattr,rump___sysimpl_lsetxattr);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_fsetxattr(int, const char *, const void *, size_t, int);
int
rump___sysimpl_fsetxattr(int fd, const char * name, const void * value, size_t size, int flags)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_fsetxattr_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, value) = value;
	SPARG(&callarg, size) = size;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_fsetxattr, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(fsetxattr,rump___sysimpl_fsetxattr);
__weak_alias(_fsetxattr,rump___sysimpl_fsetxattr);
__strong_alias(_sys_fsetxattr,rump___sysimpl_fsetxattr);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_getxattr(const char *, const char *, void *, size_t);
int
rump___sysimpl_getxattr(const char * path, const char * name, void * value, size_t size)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_getxattr_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, value) = value;
	SPARG(&callarg, size) = size;

	error = rsys_syscall(SYS_getxattr, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(getxattr,rump___sysimpl_getxattr);
__weak_alias(_getxattr,rump___sysimpl_getxattr);
__strong_alias(_sys_getxattr,rump___sysimpl_getxattr);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_lgetxattr(const char *, const char *, void *, size_t);
int
rump___sysimpl_lgetxattr(const char * path, const char * name, void * value, size_t size)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_lgetxattr_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, value) = value;
	SPARG(&callarg, size) = size;

	error = rsys_syscall(SYS_lgetxattr, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(lgetxattr,rump___sysimpl_lgetxattr);
__weak_alias(_lgetxattr,rump___sysimpl_lgetxattr);
__strong_alias(_sys_lgetxattr,rump___sysimpl_lgetxattr);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_fgetxattr(int, const char *, void *, size_t);
int
rump___sysimpl_fgetxattr(int fd, const char * name, void * value, size_t size)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_fgetxattr_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, value) = value;
	SPARG(&callarg, size) = size;

	error = rsys_syscall(SYS_fgetxattr, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(fgetxattr,rump___sysimpl_fgetxattr);
__weak_alias(_fgetxattr,rump___sysimpl_fgetxattr);
__strong_alias(_sys_fgetxattr,rump___sysimpl_fgetxattr);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_listxattr(const char *, char *, size_t);
int
rump___sysimpl_listxattr(const char * path, char * list, size_t size)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_listxattr_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, list) = list;
	SPARG(&callarg, size) = size;

	error = rsys_syscall(SYS_listxattr, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(listxattr,rump___sysimpl_listxattr);
__weak_alias(_listxattr,rump___sysimpl_listxattr);
__strong_alias(_sys_listxattr,rump___sysimpl_listxattr);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_llistxattr(const char *, char *, size_t);
int
rump___sysimpl_llistxattr(const char * path, char * list, size_t size)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_llistxattr_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, list) = list;
	SPARG(&callarg, size) = size;

	error = rsys_syscall(SYS_llistxattr, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(llistxattr,rump___sysimpl_llistxattr);
__weak_alias(_llistxattr,rump___sysimpl_llistxattr);
__strong_alias(_sys_llistxattr,rump___sysimpl_llistxattr);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_flistxattr(int, char *, size_t);
int
rump___sysimpl_flistxattr(int fd, char * list, size_t size)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_flistxattr_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, list) = list;
	SPARG(&callarg, size) = size;

	error = rsys_syscall(SYS_flistxattr, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(flistxattr,rump___sysimpl_flistxattr);
__weak_alias(_flistxattr,rump___sysimpl_flistxattr);
__strong_alias(_sys_flistxattr,rump___sysimpl_flistxattr);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_removexattr(const char *, const char *);
int
rump___sysimpl_removexattr(const char * path, const char * name)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_removexattr_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, name) = name;

	error = rsys_syscall(SYS_removexattr, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(removexattr,rump___sysimpl_removexattr);
__weak_alias(_removexattr,rump___sysimpl_removexattr);
__strong_alias(_sys_removexattr,rump___sysimpl_removexattr);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_lremovexattr(const char *, const char *);
int
rump___sysimpl_lremovexattr(const char * path, const char * name)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_lremovexattr_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, name) = name;

	error = rsys_syscall(SYS_lremovexattr, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(lremovexattr,rump___sysimpl_lremovexattr);
__weak_alias(_lremovexattr,rump___sysimpl_lremovexattr);
__strong_alias(_sys_lremovexattr,rump___sysimpl_lremovexattr);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_fremovexattr(int, const char *);
int
rump___sysimpl_fremovexattr(int fd, const char * name)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_fremovexattr_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, name) = name;

	error = rsys_syscall(SYS_fremovexattr, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(fremovexattr,rump___sysimpl_fremovexattr);
__weak_alias(_fremovexattr,rump___sysimpl_fremovexattr);
__strong_alias(_sys_fremovexattr,rump___sysimpl_fremovexattr);
#endif /* RUMP_KERNEL_IS_LIBC */

#ifdef RUMP_SYS_COMPAT
int rump___sysimpl_stat30(const char *, struct stat *);
int
rump___sysimpl_stat30(const char * path, struct stat * ub)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct compat_50_sys___stat30_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, ub) = (struct stat30 *)ub;

	error = rsys_syscall(SYS_compat_50___stat30, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(stat,rump___sysimpl_stat30);
__weak_alias(__stat30,rump___sysimpl_stat30);
__weak_alias(___stat30,rump___sysimpl_stat30);
__strong_alias(_sys___stat30,rump___sysimpl_stat30);
#endif /* RUMP_KERNEL_IS_LIBC */
#endif /* RUMP_SYS_COMPAT */

#ifdef RUMP_SYS_COMPAT
int rump___sysimpl_fstat30(int, struct stat *);
int
rump___sysimpl_fstat30(int fd, struct stat * sb)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct compat_50_sys___fstat30_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, sb) = (struct stat30 *)sb;

	error = rsys_syscall(SYS_compat_50___fstat30, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(fstat,rump___sysimpl_fstat30);
__weak_alias(__fstat30,rump___sysimpl_fstat30);
__weak_alias(___fstat30,rump___sysimpl_fstat30);
__strong_alias(_sys___fstat30,rump___sysimpl_fstat30);
#endif /* RUMP_KERNEL_IS_LIBC */
#endif /* RUMP_SYS_COMPAT */

#ifdef RUMP_SYS_COMPAT
int rump___sysimpl_lstat30(const char *, struct stat *);
int
rump___sysimpl_lstat30(const char * path, struct stat * ub)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct compat_50_sys___lstat30_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, ub) = (struct stat30 *)ub;

	error = rsys_syscall(SYS_compat_50___lstat30, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(lstat,rump___sysimpl_lstat30);
__weak_alias(__lstat30,rump___sysimpl_lstat30);
__weak_alias(___lstat30,rump___sysimpl_lstat30);
__strong_alias(_sys___lstat30,rump___sysimpl_lstat30);
#endif /* RUMP_KERNEL_IS_LIBC */
#endif /* RUMP_SYS_COMPAT */

int rump___sysimpl_getdents30(int, char *, size_t);
int
rump___sysimpl_getdents30(int fd, char * buf, size_t count)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___getdents30_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, count) = count;

	error = rsys_syscall(SYS___getdents30, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(getdents,rump___sysimpl_getdents30);
__weak_alias(__getdents30,rump___sysimpl_getdents30);
__weak_alias(___getdents30,rump___sysimpl_getdents30);
__strong_alias(_sys___getdents30,rump___sysimpl_getdents30);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_socket30(int, int, int);
int
rump___sysimpl_socket30(int domain, int type, int protocol)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___socket30_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, domain) = domain;
	SPARG(&callarg, type) = type;
	SPARG(&callarg, protocol) = protocol;

	error = rsys_syscall(SYS___socket30, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(socket,rump___sysimpl_socket30);
__weak_alias(__socket30,rump___sysimpl_socket30);
__weak_alias(___socket30,rump___sysimpl_socket30);
__strong_alias(_sys___socket30,rump___sysimpl_socket30);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_getfh30(const char *, void *, size_t *);
int
rump___sysimpl_getfh30(const char * fname, void * fhp, size_t * fh_size)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___getfh30_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fname) = fname;
	SPARG(&callarg, fhp) = fhp;
	SPARG(&callarg, fh_size) = fh_size;

	error = rsys_syscall(SYS___getfh30, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(getfh,rump___sysimpl_getfh30);
__weak_alias(__getfh30,rump___sysimpl_getfh30);
__weak_alias(___getfh30,rump___sysimpl_getfh30);
__strong_alias(_sys___getfh30,rump___sysimpl_getfh30);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_fhopen40(const void *, size_t, int);
int
rump___sysimpl_fhopen40(const void * fhp, size_t fh_size, int flags)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___fhopen40_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fhp) = fhp;
	SPARG(&callarg, fh_size) = fh_size;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS___fhopen40, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(fhopen,rump___sysimpl_fhopen40);
__weak_alias(__fhopen40,rump___sysimpl_fhopen40);
__weak_alias(___fhopen40,rump___sysimpl_fhopen40);
__strong_alias(_sys___fhopen40,rump___sysimpl_fhopen40);
#endif /* RUMP_KERNEL_IS_LIBC */

#ifdef RUMP_SYS_COMPAT
int rump___sysimpl_fhstat40(const void *, size_t, struct stat *);
int
rump___sysimpl_fhstat40(const void * fhp, size_t fh_size, struct stat * sb)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct compat_50_sys___fhstat40_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fhp) = fhp;
	SPARG(&callarg, fh_size) = fh_size;
	SPARG(&callarg, sb) = (struct stat30 *)sb;

	error = rsys_syscall(SYS_compat_50___fhstat40, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(fhstat,rump___sysimpl_fhstat40);
__weak_alias(__fhstat40,rump___sysimpl_fhstat40);
__weak_alias(___fhstat40,rump___sysimpl_fhstat40);
__strong_alias(_sys___fhstat40,rump___sysimpl_fhstat40);
#endif /* RUMP_KERNEL_IS_LIBC */
#endif /* RUMP_SYS_COMPAT */

int rump___sysimpl_aio_cancel(int, struct aiocb *);
int
rump___sysimpl_aio_cancel(int fildes, struct aiocb * aiocbp)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_aio_cancel_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fildes) = fildes;
	SPARG(&callarg, aiocbp) = aiocbp;

	error = rsys_syscall(SYS_aio_cancel, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(aio_cancel,rump___sysimpl_aio_cancel);
__weak_alias(_aio_cancel,rump___sysimpl_aio_cancel);
__strong_alias(_sys_aio_cancel,rump___sysimpl_aio_cancel);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_aio_error(const struct aiocb *);
int
rump___sysimpl_aio_error(const struct aiocb * aiocbp)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_aio_error_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, aiocbp) = aiocbp;

	error = rsys_syscall(SYS_aio_error, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(aio_error,rump___sysimpl_aio_error);
__weak_alias(_aio_error,rump___sysimpl_aio_error);
__strong_alias(_sys_aio_error,rump___sysimpl_aio_error);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_aio_fsync(int, struct aiocb *);
int
rump___sysimpl_aio_fsync(int op, struct aiocb * aiocbp)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_aio_fsync_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, op) = op;
	SPARG(&callarg, aiocbp) = aiocbp;

	error = rsys_syscall(SYS_aio_fsync, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(aio_fsync,rump___sysimpl_aio_fsync);
__weak_alias(_aio_fsync,rump___sysimpl_aio_fsync);
__strong_alias(_sys_aio_fsync,rump___sysimpl_aio_fsync);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_aio_read(struct aiocb *);
int
rump___sysimpl_aio_read(struct aiocb * aiocbp)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_aio_read_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, aiocbp) = aiocbp;

	error = rsys_syscall(SYS_aio_read, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(aio_read,rump___sysimpl_aio_read);
__weak_alias(_aio_read,rump___sysimpl_aio_read);
__strong_alias(_sys_aio_read,rump___sysimpl_aio_read);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_aio_return(struct aiocb *);
int
rump___sysimpl_aio_return(struct aiocb * aiocbp)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_aio_return_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, aiocbp) = aiocbp;

	error = rsys_syscall(SYS_aio_return, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(aio_return,rump___sysimpl_aio_return);
__weak_alias(_aio_return,rump___sysimpl_aio_return);
__strong_alias(_sys_aio_return,rump___sysimpl_aio_return);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_aio_write(struct aiocb *);
int
rump___sysimpl_aio_write(struct aiocb * aiocbp)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_aio_write_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, aiocbp) = aiocbp;

	error = rsys_syscall(SYS_aio_write, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(aio_write,rump___sysimpl_aio_write);
__weak_alias(_aio_write,rump___sysimpl_aio_write);
__strong_alias(_sys_aio_write,rump___sysimpl_aio_write);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_lio_listio(int, struct aiocb *const *, int, struct sigevent *);
int
rump___sysimpl_lio_listio(int mode, struct aiocb *const * list, int nent, struct sigevent * sig)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_lio_listio_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, mode) = mode;
	SPARG(&callarg, list) = list;
	SPARG(&callarg, nent) = nent;
	SPARG(&callarg, sig) = sig;

	error = rsys_syscall(SYS_lio_listio, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(lio_listio,rump___sysimpl_lio_listio);
__weak_alias(_lio_listio,rump___sysimpl_lio_listio);
__strong_alias(_sys_lio_listio,rump___sysimpl_lio_listio);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_mount50(const char *, const char *, int, void *, size_t);
int
rump___sysimpl_mount50(const char * type, const char * path, int flags, void * data, size_t data_len)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___mount50_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, type) = type;
	SPARG(&callarg, path) = path;
	SPARG(&callarg, flags) = flags;
	SPARG(&callarg, data) = data;
	SPARG(&callarg, data_len) = data_len;

	error = rsys_syscall(SYS___mount50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(mount,rump___sysimpl_mount50);
__weak_alias(__mount50,rump___sysimpl_mount50);
__weak_alias(___mount50,rump___sysimpl_mount50);
__strong_alias(_sys___mount50,rump___sysimpl_mount50);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_posix_fadvise50(int, off_t, off_t, int);
int
rump___sysimpl_posix_fadvise50(int fd, off_t offset, off_t len, int advice)
{
	register_t retval[2];
	int rv = -1;
	struct sys___posix_fadvise50_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, PAD) = 0;
	SPARG(&callarg, offset) = offset;
	SPARG(&callarg, len) = len;
	SPARG(&callarg, advice) = advice;

	(void)rsys_syscall(SYS___posix_fadvise50, &callarg, sizeof(callarg), retval);
	if (sizeof(int) > sizeof(register_t))
		rv = *(int *)retval;
	else
		rv = *retval;
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(posix_fadvise,rump___sysimpl_posix_fadvise50);
__weak_alias(__posix_fadvise50,rump___sysimpl_posix_fadvise50);
__weak_alias(___posix_fadvise50,rump___sysimpl_posix_fadvise50);
__strong_alias(_sys___posix_fadvise50,rump___sysimpl_posix_fadvise50);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_select50(int, fd_set *, fd_set *, fd_set *, struct timeval *);
int
rump___sysimpl_select50(int nd, fd_set * in, fd_set * ou, fd_set * ex, struct timeval * tv)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___select50_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, nd) = nd;
	SPARG(&callarg, in) = in;
	SPARG(&callarg, ou) = ou;
	SPARG(&callarg, ex) = ex;
	SPARG(&callarg, tv) = tv;

	error = rsys_syscall(SYS___select50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(select,rump___sysimpl_select50);
__weak_alias(__select50,rump___sysimpl_select50);
__weak_alias(___select50,rump___sysimpl_select50);
__strong_alias(_sys___select50,rump___sysimpl_select50);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_gettimeofday50(struct timeval *, void *);
int
rump___sysimpl_gettimeofday50(struct timeval * tp, void * tzp)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___gettimeofday50_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, tp) = tp;
	SPARG(&callarg, tzp) = tzp;

	error = rsys_syscall(SYS___gettimeofday50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(gettimeofday,rump___sysimpl_gettimeofday50);
__weak_alias(__gettimeofday50,rump___sysimpl_gettimeofday50);
__weak_alias(___gettimeofday50,rump___sysimpl_gettimeofday50);
__strong_alias(_sys___gettimeofday50,rump___sysimpl_gettimeofday50);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_settimeofday50(const struct timeval *, const void *);
int
rump___sysimpl_settimeofday50(const struct timeval * tv, const void * tzp)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___settimeofday50_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, tv) = tv;
	SPARG(&callarg, tzp) = tzp;

	error = rsys_syscall(SYS___settimeofday50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(settimeofday,rump___sysimpl_settimeofday50);
__weak_alias(__settimeofday50,rump___sysimpl_settimeofday50);
__weak_alias(___settimeofday50,rump___sysimpl_settimeofday50);
__strong_alias(_sys___settimeofday50,rump___sysimpl_settimeofday50);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_utimes50(const char *, const struct timeval *);
int
rump___sysimpl_utimes50(const char * path, const struct timeval * tptr)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___utimes50_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, tptr) = tptr;

	error = rsys_syscall(SYS___utimes50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(utimes,rump___sysimpl_utimes50);
__weak_alias(__utimes50,rump___sysimpl_utimes50);
__weak_alias(___utimes50,rump___sysimpl_utimes50);
__strong_alias(_sys___utimes50,rump___sysimpl_utimes50);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_adjtime50(const struct timeval *, struct timeval *);
int
rump___sysimpl_adjtime50(const struct timeval * delta, struct timeval * olddelta)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___adjtime50_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, delta) = delta;
	SPARG(&callarg, olddelta) = olddelta;

	error = rsys_syscall(SYS___adjtime50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(adjtime,rump___sysimpl_adjtime50);
__weak_alias(__adjtime50,rump___sysimpl_adjtime50);
__weak_alias(___adjtime50,rump___sysimpl_adjtime50);
__strong_alias(_sys___adjtime50,rump___sysimpl_adjtime50);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_futimes50(int, const struct timeval *);
int
rump___sysimpl_futimes50(int fd, const struct timeval * tptr)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___futimes50_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, tptr) = tptr;

	error = rsys_syscall(SYS___futimes50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(futimes,rump___sysimpl_futimes50);
__weak_alias(__futimes50,rump___sysimpl_futimes50);
__weak_alias(___futimes50,rump___sysimpl_futimes50);
__strong_alias(_sys___futimes50,rump___sysimpl_futimes50);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_lutimes50(const char *, const struct timeval *);
int
rump___sysimpl_lutimes50(const char * path, const struct timeval * tptr)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___lutimes50_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, tptr) = tptr;

	error = rsys_syscall(SYS___lutimes50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(lutimes,rump___sysimpl_lutimes50);
__weak_alias(__lutimes50,rump___sysimpl_lutimes50);
__weak_alias(___lutimes50,rump___sysimpl_lutimes50);
__strong_alias(_sys___lutimes50,rump___sysimpl_lutimes50);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_setitimer50(int, const struct itimerval *, struct itimerval *);
int
rump___sysimpl_setitimer50(int which, const struct itimerval * itv, struct itimerval * oitv)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___setitimer50_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, which) = which;
	SPARG(&callarg, itv) = itv;
	SPARG(&callarg, oitv) = oitv;

	error = rsys_syscall(SYS___setitimer50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(setitimer,rump___sysimpl_setitimer50);
__weak_alias(__setitimer50,rump___sysimpl_setitimer50);
__weak_alias(___setitimer50,rump___sysimpl_setitimer50);
__strong_alias(_sys___setitimer50,rump___sysimpl_setitimer50);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_getitimer50(int, struct itimerval *);
int
rump___sysimpl_getitimer50(int which, struct itimerval * itv)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___getitimer50_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, which) = which;
	SPARG(&callarg, itv) = itv;

	error = rsys_syscall(SYS___getitimer50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(getitimer,rump___sysimpl_getitimer50);
__weak_alias(__getitimer50,rump___sysimpl_getitimer50);
__weak_alias(___getitimer50,rump___sysimpl_getitimer50);
__strong_alias(_sys___getitimer50,rump___sysimpl_getitimer50);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_clock_gettime50(clockid_t, struct timespec *);
int
rump___sysimpl_clock_gettime50(clockid_t clock_id, struct timespec * tp)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___clock_gettime50_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, clock_id) = clock_id;
	SPARG(&callarg, tp) = tp;

	error = rsys_syscall(SYS___clock_gettime50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(clock_gettime,rump___sysimpl_clock_gettime50);
__weak_alias(__clock_gettime50,rump___sysimpl_clock_gettime50);
__weak_alias(___clock_gettime50,rump___sysimpl_clock_gettime50);
__strong_alias(_sys___clock_gettime50,rump___sysimpl_clock_gettime50);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_clock_settime50(clockid_t, const struct timespec *);
int
rump___sysimpl_clock_settime50(clockid_t clock_id, const struct timespec * tp)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___clock_settime50_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, clock_id) = clock_id;
	SPARG(&callarg, tp) = tp;

	error = rsys_syscall(SYS___clock_settime50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(clock_settime,rump___sysimpl_clock_settime50);
__weak_alias(__clock_settime50,rump___sysimpl_clock_settime50);
__weak_alias(___clock_settime50,rump___sysimpl_clock_settime50);
__strong_alias(_sys___clock_settime50,rump___sysimpl_clock_settime50);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_clock_getres50(clockid_t, struct timespec *);
int
rump___sysimpl_clock_getres50(clockid_t clock_id, struct timespec * tp)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___clock_getres50_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, clock_id) = clock_id;
	SPARG(&callarg, tp) = tp;

	error = rsys_syscall(SYS___clock_getres50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(clock_getres,rump___sysimpl_clock_getres50);
__weak_alias(__clock_getres50,rump___sysimpl_clock_getres50);
__weak_alias(___clock_getres50,rump___sysimpl_clock_getres50);
__strong_alias(_sys___clock_getres50,rump___sysimpl_clock_getres50);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_nanosleep50(const struct timespec *, struct timespec *);
int
rump___sysimpl_nanosleep50(const struct timespec * rqtp, struct timespec * rmtp)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___nanosleep50_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, rqtp) = rqtp;
	SPARG(&callarg, rmtp) = rmtp;

	error = rsys_syscall(SYS___nanosleep50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(nanosleep,rump___sysimpl_nanosleep50);
__weak_alias(__nanosleep50,rump___sysimpl_nanosleep50);
__weak_alias(___nanosleep50,rump___sysimpl_nanosleep50);
__strong_alias(_sys___nanosleep50,rump___sysimpl_nanosleep50);
#endif /* RUMP_KERNEL_IS_LIBC */

#ifdef RUMP_SYS_COMPAT
int rump___sysimpl_kevent50(int, const struct kevent *, size_t, struct kevent *, size_t, const struct timespec *);
int
rump___sysimpl_kevent50(int fd, const struct kevent * changelist, size_t nchanges, struct kevent * eventlist, size_t nevents, const struct timespec * timeout)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct compat_100_sys___kevent50_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, changelist) = (const struct kevent100 *)changelist;
	SPARG(&callarg, nchanges) = nchanges;
	SPARG(&callarg, eventlist) = (struct kevent100 *)eventlist;
	SPARG(&callarg, nevents) = nevents;
	SPARG(&callarg, timeout) = timeout;

	error = rsys_syscall(SYS_compat_100___kevent50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(kevent,rump___sysimpl_kevent50);
__weak_alias(__kevent50,rump___sysimpl_kevent50);
__weak_alias(___kevent50,rump___sysimpl_kevent50);
__strong_alias(_sys___kevent50,rump___sysimpl_kevent50);
#endif /* RUMP_KERNEL_IS_LIBC */
#endif /* RUMP_SYS_COMPAT */

int rump___sysimpl_pselect50(int, fd_set *, fd_set *, fd_set *, const struct timespec *, const sigset_t *);
int
rump___sysimpl_pselect50(int nd, fd_set * in, fd_set * ou, fd_set * ex, const struct timespec * ts, const sigset_t * mask)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___pselect50_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, nd) = nd;
	SPARG(&callarg, in) = in;
	SPARG(&callarg, ou) = ou;
	SPARG(&callarg, ex) = ex;
	SPARG(&callarg, ts) = ts;
	SPARG(&callarg, mask) = mask;

	error = rsys_syscall(SYS___pselect50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(pselect,rump___sysimpl_pselect50);
__weak_alias(__pselect50,rump___sysimpl_pselect50);
__weak_alias(___pselect50,rump___sysimpl_pselect50);
__strong_alias(_sys___pselect50,rump___sysimpl_pselect50);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_pollts50(struct pollfd *, u_int, const struct timespec *, const sigset_t *);
int
rump___sysimpl_pollts50(struct pollfd * fds, u_int nfds, const struct timespec * ts, const sigset_t * mask)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___pollts50_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fds) = fds;
	SPARG(&callarg, nfds) = nfds;
	SPARG(&callarg, ts) = ts;
	SPARG(&callarg, mask) = mask;

	error = rsys_syscall(SYS___pollts50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(pollts,rump___sysimpl_pollts50);
__weak_alias(__pollts50,rump___sysimpl_pollts50);
__weak_alias(___pollts50,rump___sysimpl_pollts50);
__strong_alias(_sys___pollts50,rump___sysimpl_pollts50);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_aio_suspend50(const struct aiocb *const *, int, const struct timespec *);
int
rump___sysimpl_aio_suspend50(const struct aiocb *const * list, int nent, const struct timespec * timeout)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___aio_suspend50_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, list) = list;
	SPARG(&callarg, nent) = nent;
	SPARG(&callarg, timeout) = timeout;

	error = rsys_syscall(SYS___aio_suspend50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(aio_suspend,rump___sysimpl_aio_suspend50);
__weak_alias(__aio_suspend50,rump___sysimpl_aio_suspend50);
__weak_alias(___aio_suspend50,rump___sysimpl_aio_suspend50);
__strong_alias(_sys___aio_suspend50,rump___sysimpl_aio_suspend50);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_stat50(const char *, struct stat *);
int
rump___sysimpl_stat50(const char * path, struct stat * ub)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___stat50_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, ub) = ub;

	error = rsys_syscall(SYS___stat50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(stat,rump___sysimpl_stat50);
__weak_alias(__stat50,rump___sysimpl_stat50);
__weak_alias(___stat50,rump___sysimpl_stat50);
__strong_alias(_sys___stat50,rump___sysimpl_stat50);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_fstat50(int, struct stat *);
int
rump___sysimpl_fstat50(int fd, struct stat * sb)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___fstat50_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, sb) = sb;

	error = rsys_syscall(SYS___fstat50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(fstat,rump___sysimpl_fstat50);
__weak_alias(__fstat50,rump___sysimpl_fstat50);
__weak_alias(___fstat50,rump___sysimpl_fstat50);
__strong_alias(_sys___fstat50,rump___sysimpl_fstat50);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_lstat50(const char *, struct stat *);
int
rump___sysimpl_lstat50(const char * path, struct stat * ub)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___lstat50_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, ub) = ub;

	error = rsys_syscall(SYS___lstat50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(lstat,rump___sysimpl_lstat50);
__weak_alias(__lstat50,rump___sysimpl_lstat50);
__weak_alias(___lstat50,rump___sysimpl_lstat50);
__strong_alias(_sys___lstat50,rump___sysimpl_lstat50);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_timer_settime50(timer_t, int, const struct itimerspec *, struct itimerspec *);
int
rump___sysimpl_timer_settime50(timer_t timerid, int flags, const struct itimerspec * value, struct itimerspec * ovalue)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___timer_settime50_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, timerid) = timerid;
	SPARG(&callarg, flags) = flags;
	SPARG(&callarg, value) = value;
	SPARG(&callarg, ovalue) = ovalue;

	error = rsys_syscall(SYS___timer_settime50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(timer_settime,rump___sysimpl_timer_settime50);
__weak_alias(__timer_settime50,rump___sysimpl_timer_settime50);
__weak_alias(___timer_settime50,rump___sysimpl_timer_settime50);
__strong_alias(_sys___timer_settime50,rump___sysimpl_timer_settime50);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_timer_gettime50(timer_t, struct itimerspec *);
int
rump___sysimpl_timer_gettime50(timer_t timerid, struct itimerspec * value)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___timer_gettime50_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, timerid) = timerid;
	SPARG(&callarg, value) = value;

	error = rsys_syscall(SYS___timer_gettime50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(timer_gettime,rump___sysimpl_timer_gettime50);
__weak_alias(__timer_gettime50,rump___sysimpl_timer_gettime50);
__weak_alias(___timer_gettime50,rump___sysimpl_timer_gettime50);
__strong_alias(_sys___timer_gettime50,rump___sysimpl_timer_gettime50);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_mknod50(const char *, mode_t, dev_t);
int
rump___sysimpl_mknod50(const char * path, mode_t mode, dev_t dev)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___mknod50_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, mode) = mode;
	SPARG(&callarg, dev) = dev;

	error = rsys_syscall(SYS___mknod50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(mknod,rump___sysimpl_mknod50);
__weak_alias(__mknod50,rump___sysimpl_mknod50);
__weak_alias(___mknod50,rump___sysimpl_mknod50);
__strong_alias(_sys___mknod50,rump___sysimpl_mknod50);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_fhstat50(const void *, size_t, struct stat *);
int
rump___sysimpl_fhstat50(const void * fhp, size_t fh_size, struct stat * sb)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___fhstat50_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fhp) = fhp;
	SPARG(&callarg, fh_size) = fh_size;
	SPARG(&callarg, sb) = sb;

	error = rsys_syscall(SYS___fhstat50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(fhstat,rump___sysimpl_fhstat50);
__weak_alias(__fhstat50,rump___sysimpl_fhstat50);
__weak_alias(___fhstat50,rump___sysimpl_fhstat50);
__strong_alias(_sys___fhstat50,rump___sysimpl_fhstat50);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_pipe2(int *, int);
int
rump___sysimpl_pipe2(int * fildes, int flags)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_pipe2_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fildes) = fildes;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_pipe2, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(pipe2,rump___sysimpl_pipe2);
__weak_alias(_pipe2,rump___sysimpl_pipe2);
__strong_alias(_sys_pipe2,rump___sysimpl_pipe2);
#endif /* RUMP_KERNEL_IS_LIBC */

#ifdef RUMP_SYS_COMPAT
int rump___sysimpl_dup3(int, int, int);
int
rump___sysimpl_dup3(int from, int to, int flags)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct compat_100_sys_dup3_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, from) = from;
	SPARG(&callarg, to) = to;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_compat_100_dup3, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(dup3,rump___sysimpl_dup3);
__weak_alias(_dup3,rump___sysimpl_dup3);
__strong_alias(_sys_dup3,rump___sysimpl_dup3);
#endif /* RUMP_KERNEL_IS_LIBC */
#endif /* RUMP_SYS_COMPAT */

int rump___sysimpl_kqueue1(int);
int
rump___sysimpl_kqueue1(int flags)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_kqueue1_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_kqueue1, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(kqueue1,rump___sysimpl_kqueue1);
__weak_alias(_kqueue1,rump___sysimpl_kqueue1);
__strong_alias(_sys_kqueue1,rump___sysimpl_kqueue1);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_paccept(int, struct sockaddr *, socklen_t *, const sigset_t *, int);
int
rump___sysimpl_paccept(int s, struct sockaddr * name, socklen_t * anamelen, const sigset_t * mask, int flags)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_paccept_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, s) = s;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, anamelen) = anamelen;
	SPARG(&callarg, mask) = mask;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_paccept, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(paccept,rump___sysimpl_paccept);
__weak_alias(_paccept,rump___sysimpl_paccept);
__strong_alias(_sys_paccept,rump___sysimpl_paccept);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_linkat(int, const char *, int, const char *, int);
int
rump___sysimpl_linkat(int fd1, const char * name1, int fd2, const char * name2, int flags)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_linkat_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd1) = fd1;
	SPARG(&callarg, name1) = name1;
	SPARG(&callarg, fd2) = fd2;
	SPARG(&callarg, name2) = name2;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_linkat, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(linkat,rump___sysimpl_linkat);
__weak_alias(_linkat,rump___sysimpl_linkat);
__strong_alias(_sys_linkat,rump___sysimpl_linkat);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_renameat(int, const char *, int, const char *);
int
rump___sysimpl_renameat(int fromfd, const char * from, int tofd, const char * to)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_renameat_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fromfd) = fromfd;
	SPARG(&callarg, from) = from;
	SPARG(&callarg, tofd) = tofd;
	SPARG(&callarg, to) = to;

	error = rsys_syscall(SYS_renameat, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(renameat,rump___sysimpl_renameat);
__weak_alias(_renameat,rump___sysimpl_renameat);
__strong_alias(_sys_renameat,rump___sysimpl_renameat);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_mkfifoat(int, const char *, mode_t);
int
rump___sysimpl_mkfifoat(int fd, const char * path, mode_t mode)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_mkfifoat_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, path) = path;
	SPARG(&callarg, mode) = mode;

	error = rsys_syscall(SYS_mkfifoat, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(mkfifoat,rump___sysimpl_mkfifoat);
__weak_alias(_mkfifoat,rump___sysimpl_mkfifoat);
__strong_alias(_sys_mkfifoat,rump___sysimpl_mkfifoat);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_mknodat(int, const char *, mode_t, dev_t);
int
rump___sysimpl_mknodat(int fd, const char * path, mode_t mode, dev_t dev)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_mknodat_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, path) = path;
	SPARG(&callarg, mode) = mode;
	SPARG(&callarg, PAD) = 0;
	SPARG(&callarg, dev) = dev;

	error = rsys_syscall(SYS_mknodat, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(mknodat,rump___sysimpl_mknodat);
__weak_alias(_mknodat,rump___sysimpl_mknodat);
__strong_alias(_sys_mknodat,rump___sysimpl_mknodat);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_mkdirat(int, const char *, mode_t);
int
rump___sysimpl_mkdirat(int fd, const char * path, mode_t mode)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_mkdirat_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, path) = path;
	SPARG(&callarg, mode) = mode;

	error = rsys_syscall(SYS_mkdirat, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(mkdirat,rump___sysimpl_mkdirat);
__weak_alias(_mkdirat,rump___sysimpl_mkdirat);
__strong_alias(_sys_mkdirat,rump___sysimpl_mkdirat);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_faccessat(int, const char *, int, int);
int
rump___sysimpl_faccessat(int fd, const char * path, int amode, int flag)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_faccessat_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, path) = path;
	SPARG(&callarg, amode) = amode;
	SPARG(&callarg, flag) = flag;

	error = rsys_syscall(SYS_faccessat, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(faccessat,rump___sysimpl_faccessat);
__weak_alias(_faccessat,rump___sysimpl_faccessat);
__strong_alias(_sys_faccessat,rump___sysimpl_faccessat);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_fchmodat(int, const char *, mode_t, int);
int
rump___sysimpl_fchmodat(int fd, const char * path, mode_t mode, int flag)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_fchmodat_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, path) = path;
	SPARG(&callarg, mode) = mode;
	SPARG(&callarg, flag) = flag;

	error = rsys_syscall(SYS_fchmodat, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(fchmodat,rump___sysimpl_fchmodat);
__weak_alias(_fchmodat,rump___sysimpl_fchmodat);
__strong_alias(_sys_fchmodat,rump___sysimpl_fchmodat);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_fchownat(int, const char *, uid_t, gid_t, int);
int
rump___sysimpl_fchownat(int fd, const char * path, uid_t owner, gid_t group, int flag)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_fchownat_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, path) = path;
	SPARG(&callarg, owner) = owner;
	SPARG(&callarg, group) = group;
	SPARG(&callarg, flag) = flag;

	error = rsys_syscall(SYS_fchownat, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(fchownat,rump___sysimpl_fchownat);
__weak_alias(_fchownat,rump___sysimpl_fchownat);
__strong_alias(_sys_fchownat,rump___sysimpl_fchownat);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_fstatat(int, const char *, struct stat *, int);
int
rump___sysimpl_fstatat(int fd, const char * path, struct stat * buf, int flag)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_fstatat_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, path) = path;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, flag) = flag;

	error = rsys_syscall(SYS_fstatat, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(fstatat,rump___sysimpl_fstatat);
__weak_alias(_fstatat,rump___sysimpl_fstatat);
__strong_alias(_sys_fstatat,rump___sysimpl_fstatat);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_utimensat(int, const char *, const struct timespec *, int);
int
rump___sysimpl_utimensat(int fd, const char * path, const struct timespec * tptr, int flag)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_utimensat_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, path) = path;
	SPARG(&callarg, tptr) = tptr;
	SPARG(&callarg, flag) = flag;

	error = rsys_syscall(SYS_utimensat, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(utimensat,rump___sysimpl_utimensat);
__weak_alias(_utimensat,rump___sysimpl_utimensat);
__strong_alias(_sys_utimensat,rump___sysimpl_utimensat);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_openat(int, const char *, int, mode_t);
int
rump___sysimpl_openat(int fd, const char * path, int oflags, mode_t mode)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_openat_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, path) = path;
	SPARG(&callarg, oflags) = oflags;
	SPARG(&callarg, mode) = mode;

	error = rsys_syscall(SYS_openat, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(openat,rump___sysimpl_openat);
__weak_alias(_openat,rump___sysimpl_openat);
__strong_alias(_sys_openat,rump___sysimpl_openat);
#endif /* RUMP_KERNEL_IS_LIBC */

ssize_t rump___sysimpl_readlinkat(int, const char *, char *, size_t);
ssize_t
rump___sysimpl_readlinkat(int fd, const char * path, char * buf, size_t bufsize)
{
	register_t retval[2];
	int error = 0;
	ssize_t rv = -1;
	struct sys_readlinkat_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, path) = path;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, bufsize) = bufsize;

	error = rsys_syscall(SYS_readlinkat, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(readlinkat,rump___sysimpl_readlinkat);
__weak_alias(_readlinkat,rump___sysimpl_readlinkat);
__strong_alias(_sys_readlinkat,rump___sysimpl_readlinkat);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_symlinkat(const char *, int, const char *);
int
rump___sysimpl_symlinkat(const char * path1, int fd, const char * path2)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_symlinkat_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path1) = path1;
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, path2) = path2;

	error = rsys_syscall(SYS_symlinkat, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(symlinkat,rump___sysimpl_symlinkat);
__weak_alias(_symlinkat,rump___sysimpl_symlinkat);
__strong_alias(_sys_symlinkat,rump___sysimpl_symlinkat);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_unlinkat(int, const char *, int);
int
rump___sysimpl_unlinkat(int fd, const char * path, int flag)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_unlinkat_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, path) = path;
	SPARG(&callarg, flag) = flag;

	error = rsys_syscall(SYS_unlinkat, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(unlinkat,rump___sysimpl_unlinkat);
__weak_alias(_unlinkat,rump___sysimpl_unlinkat);
__strong_alias(_sys_unlinkat,rump___sysimpl_unlinkat);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_futimens(int, const struct timespec *);
int
rump___sysimpl_futimens(int fd, const struct timespec * tptr)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_futimens_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, tptr) = tptr;

	error = rsys_syscall(SYS_futimens, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(futimens,rump___sysimpl_futimens);
__weak_alias(_futimens,rump___sysimpl_futimens);
__strong_alias(_sys_futimens,rump___sysimpl_futimens);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl___quotactl(const char *, struct quotactl_args *);
int
rump___sysimpl___quotactl(const char * path, struct quotactl_args * args)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___quotactl_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, args) = args;

	error = rsys_syscall(SYS___quotactl, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(__quotactl,rump___sysimpl___quotactl);
__weak_alias(___quotactl,rump___sysimpl___quotactl);
__strong_alias(_sys___quotactl,rump___sysimpl___quotactl);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_recvmmsg(int, struct mmsghdr *, unsigned int, unsigned int, struct timespec *);
int
rump___sysimpl_recvmmsg(int s, struct mmsghdr * mmsg, unsigned int vlen, unsigned int flags, struct timespec * timeout)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_recvmmsg_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, s) = s;
	SPARG(&callarg, mmsg) = mmsg;
	SPARG(&callarg, vlen) = vlen;
	SPARG(&callarg, flags) = flags;
	SPARG(&callarg, timeout) = timeout;

	error = rsys_syscall(SYS_recvmmsg, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(recvmmsg,rump___sysimpl_recvmmsg);
__weak_alias(_recvmmsg,rump___sysimpl_recvmmsg);
__strong_alias(_sys_recvmmsg,rump___sysimpl_recvmmsg);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_sendmmsg(int, struct mmsghdr *, unsigned int, unsigned int);
int
rump___sysimpl_sendmmsg(int s, struct mmsghdr * mmsg, unsigned int vlen, unsigned int flags)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_sendmmsg_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, s) = s;
	SPARG(&callarg, mmsg) = mmsg;
	SPARG(&callarg, vlen) = vlen;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_sendmmsg, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(sendmmsg,rump___sysimpl_sendmmsg);
__weak_alias(_sendmmsg,rump___sysimpl_sendmmsg);
__strong_alias(_sys_sendmmsg,rump___sysimpl_sendmmsg);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_clock_nanosleep(clockid_t, int, const struct timespec *, struct timespec *);
int
rump___sysimpl_clock_nanosleep(clockid_t clock_id, int flags, const struct timespec * rqtp, struct timespec * rmtp)
{
	register_t retval[2];
	int rv = -1;
	struct sys_clock_nanosleep_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, clock_id) = clock_id;
	SPARG(&callarg, flags) = flags;
	SPARG(&callarg, rqtp) = rqtp;
	SPARG(&callarg, rmtp) = rmtp;

	(void)rsys_syscall(SYS_clock_nanosleep, &callarg, sizeof(callarg), retval);
	if (sizeof(int) > sizeof(register_t))
		rv = *(int *)retval;
	else
		rv = *retval;
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(clock_nanosleep,rump___sysimpl_clock_nanosleep);
__weak_alias(_clock_nanosleep,rump___sysimpl_clock_nanosleep);
__strong_alias(_sys_clock_nanosleep,rump___sysimpl_clock_nanosleep);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_posix_fallocate(int, off_t, off_t);
int
rump___sysimpl_posix_fallocate(int fd, off_t pos, off_t len)
{
	register_t retval[2];
	int rv = -1;
	struct sys_posix_fallocate_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, PAD) = 0;
	SPARG(&callarg, pos) = pos;
	SPARG(&callarg, len) = len;

	(void)rsys_syscall(SYS_posix_fallocate, &callarg, sizeof(callarg), retval);
	if (sizeof(int) > sizeof(register_t))
		rv = *(int *)retval;
	else
		rv = *retval;
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(posix_fallocate,rump___sysimpl_posix_fallocate);
__weak_alias(_posix_fallocate,rump___sysimpl_posix_fallocate);
__strong_alias(_sys_posix_fallocate,rump___sysimpl_posix_fallocate);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_fdiscard(int, off_t, off_t);
int
rump___sysimpl_fdiscard(int fd, off_t pos, off_t len)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_fdiscard_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, PAD) = 0;
	SPARG(&callarg, pos) = pos;
	SPARG(&callarg, len) = len;

	error = rsys_syscall(SYS_fdiscard, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(fdiscard,rump___sysimpl_fdiscard);
__weak_alias(_fdiscard,rump___sysimpl_fdiscard);
__strong_alias(_sys_fdiscard,rump___sysimpl_fdiscard);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_clock_getcpuclockid2(idtype_t, id_t, clockid_t *);
int
rump___sysimpl_clock_getcpuclockid2(idtype_t idtype, id_t id, clockid_t * clock_id)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys_clock_getcpuclockid2_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, idtype) = idtype;
	SPARG(&callarg, id) = id;
	SPARG(&callarg, clock_id) = clock_id;

	error = rsys_syscall(SYS_clock_getcpuclockid2, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(clock_getcpuclockid2,rump___sysimpl_clock_getcpuclockid2);
__weak_alias(_clock_getcpuclockid2,rump___sysimpl_clock_getcpuclockid2);
__strong_alias(_sys_clock_getcpuclockid2,rump___sysimpl_clock_getcpuclockid2);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_getvfsstat90(struct statvfs *, size_t, int);
int
rump___sysimpl_getvfsstat90(struct statvfs * buf, size_t bufsize, int flags)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___getvfsstat90_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, bufsize) = bufsize;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS___getvfsstat90, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(getvfsstat,rump___sysimpl_getvfsstat90);
__weak_alias(__getvfsstat90,rump___sysimpl_getvfsstat90);
__weak_alias(___getvfsstat90,rump___sysimpl_getvfsstat90);
__strong_alias(_sys___getvfsstat90,rump___sysimpl_getvfsstat90);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_statvfs190(const char *, struct statvfs *, int);
int
rump___sysimpl_statvfs190(const char * path, struct statvfs * buf, int flags)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___statvfs190_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS___statvfs190, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(statvfs1,rump___sysimpl_statvfs190);
__weak_alias(__statvfs190,rump___sysimpl_statvfs190);
__weak_alias(___statvfs190,rump___sysimpl_statvfs190);
__strong_alias(_sys___statvfs190,rump___sysimpl_statvfs190);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_fstatvfs190(int, struct statvfs *, int);
int
rump___sysimpl_fstatvfs190(int fd, struct statvfs * buf, int flags)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___fstatvfs190_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS___fstatvfs190, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(fstatvfs1,rump___sysimpl_fstatvfs190);
__weak_alias(__fstatvfs190,rump___sysimpl_fstatvfs190);
__weak_alias(___fstatvfs190,rump___sysimpl_fstatvfs190);
__strong_alias(_sys___fstatvfs190,rump___sysimpl_fstatvfs190);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_fhstatvfs190(const void *, size_t, struct statvfs *, int);
int
rump___sysimpl_fhstatvfs190(const void * fhp, size_t fh_size, struct statvfs * buf, int flags)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___fhstatvfs190_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fhp) = fhp;
	SPARG(&callarg, fh_size) = fh_size;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS___fhstatvfs190, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(fhstatvfs1,rump___sysimpl_fhstatvfs190);
__weak_alias(__fhstatvfs190,rump___sysimpl_fhstatvfs190);
__weak_alias(___fhstatvfs190,rump___sysimpl_fhstatvfs190);
__strong_alias(_sys___fhstatvfs190,rump___sysimpl_fhstatvfs190);
#endif /* RUMP_KERNEL_IS_LIBC */

long rump___sysimpl_lpathconf(const char *, int);
long
rump___sysimpl_lpathconf(const char * path, int name)
{
	register_t retval[2];
	int error = 0;
	long rv = -1;
	struct sys_lpathconf_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, path) = path;
	SPARG(&callarg, name) = name;

	error = rsys_syscall(SYS_lpathconf, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(long) > sizeof(register_t))
			rv = *(long *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(lpathconf,rump___sysimpl_lpathconf);
__weak_alias(_lpathconf,rump___sysimpl_lpathconf);
__strong_alias(_sys_lpathconf,rump___sysimpl_lpathconf);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_kevent100(int, const struct kevent *, size_t, struct kevent *, size_t, const struct timespec *);
int
rump___sysimpl_kevent100(int fd, const struct kevent * changelist, size_t nchanges, struct kevent * eventlist, size_t nevents, const struct timespec * timeout)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___kevent100_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, changelist) = changelist;
	SPARG(&callarg, nchanges) = nchanges;
	SPARG(&callarg, eventlist) = eventlist;
	SPARG(&callarg, nevents) = nevents;
	SPARG(&callarg, timeout) = timeout;

	error = rsys_syscall(SYS___kevent100, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(kevent,rump___sysimpl_kevent100);
__weak_alias(__kevent100,rump___sysimpl_kevent100);
__weak_alias(___kevent100,rump___sysimpl_kevent100);
__strong_alias(_sys___kevent100,rump___sysimpl_kevent100);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump___sysimpl_dup3100(int, int, int);
int
rump___sysimpl_dup3100(int from, int to, int flags)
{
	register_t retval[2];
	int error = 0;
	int rv = -1;
	struct sys___dup3100_args callarg;

	memset(&callarg, 0, sizeof(callarg));
	SPARG(&callarg, from) = from;
	SPARG(&callarg, to) = to;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS___dup3100, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(dup3,rump___sysimpl_dup3100);
__weak_alias(__dup3100,rump___sysimpl_dup3100);
__weak_alias(___dup3100,rump___sysimpl_dup3100);
__strong_alias(_sys___dup3100,rump___sysimpl_dup3100);
#endif /* RUMP_KERNEL_IS_LIBC */

int rump_sys_pipe(int *);
int
rump_sys_pipe(int *fd)
{
	register_t retval[2];
	int error = 0;

	error = rsys_syscall(SYS_pipe, NULL, 0, retval);
	if (error) {
		rsys_seterrno(error);
	} else {
		fd[0] = retval[0];
		fd[1] = retval[1];
	}
	return error ? -1 : 0;
}
#ifdef RUMP_KERNEL_IS_LIBC
__weak_alias(pipe,rump_sys_pipe);
__weak_alias(_pipe,rump_sys_pipe);
__strong_alias(_sys_pipe,rump_sys_pipe);
#endif

#ifndef RUMP_CLIENT
int rumpns_enosys(void);
#define	s(type)	sizeof(type)
#define	n(type)	(sizeof(type)/sizeof (register_t))
#define	ns(type)	n(type), s(type)

struct sysent rump_sysent[] = {
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 0 = syscall */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 1 = exit */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 2 = fork */
	{
		ns(struct sys_read_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 3 = read */
	{
		ns(struct sys_write_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 4 = write */
	{
		ns(struct sys_open_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 5 = open */
	{
		ns(struct sys_close_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 6 = close */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 7 = wait4 */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 8 = ocreat */
	{
		ns(struct sys_link_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 9 = link */
	{
		ns(struct sys_unlink_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 10 = unlink */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 11 = filler */
	{
		ns(struct sys_chdir_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 12 = chdir */
	{
		ns(struct sys_fchdir_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 13 = fchdir */
	{
		ns(struct compat_50_sys_mknod_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 14 = compat_50_mknod */
	{
		ns(struct sys_chmod_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 15 = chmod */
	{
		ns(struct sys_chown_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 16 = chown */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 17 = break */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 18 = getfsstat */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 19 = olseek */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 20 = getpid */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 21 = mount */
	{
		ns(struct sys_unmount_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 22 = unmount */
	{
		ns(struct sys_setuid_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 23 = setuid */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 24 = getuid */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 25 = geteuid */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 26 = ptrace */
	{
		ns(struct sys_recvmsg_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 27 = recvmsg */
	{
		ns(struct sys_sendmsg_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 28 = sendmsg */
	{
		ns(struct sys_recvfrom_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 29 = recvfrom */
	{
		ns(struct sys_accept_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 30 = accept */
	{
		ns(struct sys_getpeername_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 31 = getpeername */
	{
		ns(struct sys_getsockname_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 32 = getsockname */
	{
		ns(struct sys_access_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 33 = access */
	{
		ns(struct sys_chflags_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 34 = chflags */
	{
		ns(struct sys_fchflags_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 35 = fchflags */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 36 = sync */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 37 = kill */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 38 = stat43 */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 39 = getppid */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 40 = lstat43 */
	{
		ns(struct sys_dup_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 41 = dup */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 42 = pipe */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 43 = getegid */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 44 = profil */
	{
		ns(struct sys_ktrace_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 45 = ktrace */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 46 = sigaction13 */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 47 = getgid */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 48 = sigprocmask13 */
	{
		ns(struct sys___getlogin_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 49 = __getlogin */
	{
		ns(struct sys___setlogin_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 50 = __setlogin */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 51 = acct */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 52 = sigpending13 */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 53 = sigaltstack13 */
	{
		ns(struct sys_ioctl_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 54 = ioctl */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 55 = oreboot */
	{
		ns(struct sys_revoke_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 56 = revoke */
	{
		ns(struct sys_symlink_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 57 = symlink */
	{
		ns(struct sys_readlink_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 58 = readlink */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 59 = execve */
	{
		ns(struct sys_umask_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 60 = umask */
	{
		ns(struct sys_chroot_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 61 = chroot */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 62 = fstat43 */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 63 = ogetkerninfo */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 64 = ogetpagesize */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 65 = msync */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 66 = vfork */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 67 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 68 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 69 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 70 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 71 = ommap */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 72 = vadvise */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 73 = munmap */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 74 = mprotect */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 75 = madvise */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 76 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 77 = filler */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 78 = mincore */
	{
		ns(struct sys_getgroups_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 79 = getgroups */
	{
		ns(struct sys_setgroups_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 80 = setgroups */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 81 = getpgrp */
	{
		ns(struct sys_setpgid_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 82 = setpgid */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 83 = setitimer */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 84 = owait */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 85 = oswapon */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 86 = getitimer */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 87 = ogethostname */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 88 = osethostname */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 89 = ogetdtablesize */
	{
		ns(struct sys_dup2_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 90 = dup2 */
	{
		ns(struct sys_getrandom_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 91 = getrandom */
	{
		ns(struct sys_fcntl_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 92 = fcntl */
	{
		ns(struct compat_50_sys_select_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 93 = compat_50_select */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 94 = filler */
	{
		ns(struct sys_fsync_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 95 = fsync */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 96 = setpriority */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 97 = socket */
	{
		ns(struct sys_connect_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 98 = connect */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 99 = oaccept */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 100 = getpriority */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 101 = osend */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 102 = orecv */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 103 = sigreturn13 */
	{
		ns(struct sys_bind_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 104 = bind */
	{
		ns(struct sys_setsockopt_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 105 = setsockopt */
	{
		ns(struct sys_listen_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 106 = listen */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 107 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 108 = osigvec */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 109 = osigblock */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 110 = osigsetmask */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 111 = sigsuspend13 */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 112 = osigstack */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 113 = orecvmsg */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 114 = osendmsg */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 115 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 116 = gettimeofday */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 117 = getrusage */
	{
		ns(struct sys_getsockopt_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 118 = getsockopt */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 119 = filler */
	{
		ns(struct sys_readv_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 120 = readv */
	{
		ns(struct sys_writev_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 121 = writev */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 122 = settimeofday */
	{
		ns(struct sys_fchown_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 123 = fchown */
	{
		ns(struct sys_fchmod_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 124 = fchmod */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 125 = orecvfrom */
	{
		ns(struct sys_setreuid_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 126 = setreuid */
	{
		ns(struct sys_setregid_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 127 = setregid */
	{
		ns(struct sys_rename_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 128 = rename */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 129 = otruncate */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 130 = oftruncate */
	{
		ns(struct sys_flock_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 131 = flock */
	{
		ns(struct sys_mkfifo_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 132 = mkfifo */
	{
		ns(struct sys_sendto_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 133 = sendto */
	{
		ns(struct sys_shutdown_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 134 = shutdown */
	{
		ns(struct sys_socketpair_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 135 = socketpair */
	{
		ns(struct sys_mkdir_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 136 = mkdir */
	{
		ns(struct sys_rmdir_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 137 = rmdir */
	{
		ns(struct compat_50_sys_utimes_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 138 = compat_50_utimes */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 139 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 140 = adjtime */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 141 = ogetpeername */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 142 = ogethostid */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 143 = osethostid */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 144 = ogetrlimit */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 145 = osetrlimit */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 146 = okillpg */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 147 = setsid */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 148 = quotactl */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 149 = oquota */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 150 = ogetsockname */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 151 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 152 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 153 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 154 = filler */
	{
		ns(struct sys_nfssvc_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 155 = nfssvc */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 156 = ogetdirentries */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 157 = statfs */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 158 = fstatfs */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 159 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 160 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 161 = getfh */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 162 = ogetdomainname */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 163 = osetdomainname */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 164 = ouname */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 165 = sysarch */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 166 = __futex */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 167 = __futex_set_robust_list */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 168 = __futex_get_robust_list */
#if !defined(_LP64)
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 169 = osemsys */
#else
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 169 = filler */
#endif
#if !defined(_LP64)
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 170 = omsgsys */
#else
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 170 = filler */
#endif
#if !defined(_LP64)
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 171 = oshmsys */
#else
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 171 = filler */
#endif
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 172 = filler */
	{
		ns(struct sys_pread_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 173 = pread */
	{
		ns(struct sys_pwrite_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 174 = pwrite */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 175 = ntp_gettime */
#if defined(NTP) || !defined(_KERNEL_OPT)
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 176 = ntp_adjtime */
#else
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 176 = filler */
#endif
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 177 = timerfd_create */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 178 = timerfd_settime */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 179 = timerfd_gettime */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 180 = filler */
	{
		ns(struct sys_setgid_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 181 = setgid */
	{
		ns(struct sys_setegid_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 182 = setegid */
	{
		ns(struct sys_seteuid_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 183 = seteuid */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 184 = lfs_bmapv */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 185 = lfs_markv */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 186 = lfs_segclean */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 187 = lfs_segwait */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 188 = stat12 */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 189 = fstat12 */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 190 = lstat12 */
	{
		ns(struct sys_pathconf_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 191 = pathconf */
	{
		ns(struct sys_fpathconf_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 192 = fpathconf */
	{
		ns(struct sys_getsockopt2_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 193 = getsockopt2 */
	{
		ns(struct sys_getrlimit_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 194 = getrlimit */
	{
		ns(struct sys_setrlimit_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 195 = setrlimit */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 196 = getdirentries */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 197 = mmap */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 198 = __syscall */
	{
		ns(struct sys_lseek_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 199 = lseek */
	{
		ns(struct sys_truncate_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 200 = truncate */
	{
		ns(struct sys_ftruncate_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 201 = ftruncate */
	{
		ns(struct sys___sysctl_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 202 = __sysctl */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 203 = mlock */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 204 = munlock */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 205 = undelete */
	{
		ns(struct compat_50_sys_futimes_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 206 = compat_50_futimes */
	{
		ns(struct sys_getpgid_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 207 = getpgid */
	{
		ns(struct sys_reboot_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 208 = reboot */
	{
		ns(struct sys_poll_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 209 = poll */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 210 = afssys */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 211 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 212 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 213 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 214 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 215 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 216 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 217 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 218 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 219 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 220 = __semctl */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 221 = semget */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 222 = semop */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 223 = semconfig */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 224 = msgctl */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 225 = msgget */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 226 = msgsnd */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 227 = msgrcv */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 228 = shmat */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 229 = shmctl */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 230 = shmdt */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 231 = shmget */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 232 = clock_gettime */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 233 = clock_settime */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 234 = clock_getres */
	{
		ns(struct sys_timer_create_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 235 = timer_create */
	{
		ns(struct sys_timer_delete_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 236 = timer_delete */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 237 = timer_settime */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 238 = timer_gettime */
	{
		ns(struct sys_timer_getoverrun_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 239 = timer_getoverrun */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 240 = nanosleep */
	{
		ns(struct sys_fdatasync_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 241 = fdatasync */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 242 = mlockall */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 243 = munlockall */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 244 = __sigtimedwait */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 245 = sigqueueinfo */
	{
		ns(struct sys_modctl_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 246 = modctl */
	{
		ns(struct sys__ksem_init_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 247 = _ksem_init */
	{
		ns(struct sys__ksem_open_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 248 = _ksem_open */
	{
		ns(struct sys__ksem_unlink_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 249 = _ksem_unlink */
	{
		ns(struct sys__ksem_close_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 250 = _ksem_close */
	{
		ns(struct sys__ksem_post_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 251 = _ksem_post */
	{
		ns(struct sys__ksem_wait_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 252 = _ksem_wait */
	{
		ns(struct sys__ksem_trywait_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 253 = _ksem_trywait */
	{
		ns(struct sys__ksem_getvalue_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 254 = _ksem_getvalue */
	{
		ns(struct sys__ksem_destroy_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 255 = _ksem_destroy */
	{
		ns(struct sys__ksem_timedwait_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 256 = _ksem_timedwait */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 257 = mq_open */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 258 = mq_close */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 259 = mq_unlink */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 260 = mq_getattr */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 261 = mq_setattr */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 262 = mq_notify */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 263 = mq_send */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 264 = mq_receive */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 265 = mq_timedsend */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 266 = mq_timedreceive */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 267 = eventfd */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 268 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 269 = filler */
	{
		ns(struct sys___posix_rename_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 270 = __posix_rename */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 271 = swapctl */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 272 = getdents */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 273 = minherit */
	{
		ns(struct sys_lchmod_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 274 = lchmod */
	{
		ns(struct sys_lchown_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 275 = lchown */
	{
		ns(struct compat_50_sys_lutimes_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 276 = compat_50_lutimes */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 277 = __msync13 */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 278 = __stat13 */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 279 = __fstat13 */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 280 = __lstat13 */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 281 = __sigaltstack14 */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 282 = __vfork14 */
	{
		ns(struct sys___posix_chown_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 283 = __posix_chown */
	{
		ns(struct sys___posix_fchown_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 284 = __posix_fchown */
	{
		ns(struct sys___posix_lchown_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 285 = __posix_lchown */
	{
		ns(struct sys_getsid_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 286 = getsid */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 287 = __clone */
	{
		ns(struct sys_fktrace_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 288 = fktrace */
	{
		ns(struct sys_preadv_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 289 = preadv */
	{
		ns(struct sys_pwritev_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 290 = pwritev */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 291 = __sigaction14 */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 292 = __sigpending14 */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 293 = __sigprocmask14 */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 294 = __sigsuspend14 */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 295 = __sigreturn14 */
	{
		ns(struct sys___getcwd_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 296 = __getcwd */
	{
		ns(struct sys_fchroot_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 297 = fchroot */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 298 = fhopen */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 299 = fhstat */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 300 = fhstatfs */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 301 = ____semctl13 */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 302 = __msgctl13 */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 303 = __shmctl13 */
	{
		ns(struct sys_lchflags_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 304 = lchflags */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 305 = issetugid */
	{
		ns(struct sys_utrace_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 306 = utrace */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 307 = getcontext */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 308 = setcontext */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 309 = _lwp_create */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 310 = _lwp_exit */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 311 = _lwp_self */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 312 = _lwp_wait */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 313 = _lwp_suspend */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 314 = _lwp_continue */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 315 = _lwp_wakeup */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 316 = _lwp_getprivate */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 317 = _lwp_setprivate */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 318 = _lwp_kill */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 319 = _lwp_detach */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 320 = _lwp_park */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 321 = _lwp_unpark */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 322 = _lwp_unpark_all */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 323 = _lwp_setname */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 324 = _lwp_getname */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 325 = _lwp_ctl */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 326 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 327 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 328 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 329 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 330 = sa_register */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 331 = sa_stacks */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 332 = sa_enable */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 333 = sa_setconcurrency */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 334 = sa_yield */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 335 = sa_preempt */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 336 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 337 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 338 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 339 = filler */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 340 = __sigaction_sigtramp */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 341 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 342 = filler */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 343 = rasctl */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 344 = kqueue */
	{
		ns(struct compat_50_sys_kevent_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 345 = compat_50_kevent */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 346 = _sched_setparam */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 347 = _sched_getparam */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 348 = _sched_setaffinity */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 349 = _sched_getaffinity */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 350 = sched_yield */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 351 = _sched_protect */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 352 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 353 = filler */
	{
		ns(struct sys_fsync_range_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 354 = fsync_range */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 355 = uuidgen */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 356 = getvfsstat */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 357 = statvfs1 */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 358 = fstatvfs1 */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 359 = fhstatvfs1 */
	{
		ns(struct sys_extattrctl_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 360 = extattrctl */
	{
		ns(struct sys_extattr_set_file_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 361 = extattr_set_file */
	{
		ns(struct sys_extattr_get_file_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 362 = extattr_get_file */
	{
		ns(struct sys_extattr_delete_file_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 363 = extattr_delete_file */
	{
		ns(struct sys_extattr_set_fd_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 364 = extattr_set_fd */
	{
		ns(struct sys_extattr_get_fd_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 365 = extattr_get_fd */
	{
		ns(struct sys_extattr_delete_fd_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 366 = extattr_delete_fd */
	{
		ns(struct sys_extattr_set_link_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 367 = extattr_set_link */
	{
		ns(struct sys_extattr_get_link_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 368 = extattr_get_link */
	{
		ns(struct sys_extattr_delete_link_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 369 = extattr_delete_link */
	{
		ns(struct sys_extattr_list_fd_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 370 = extattr_list_fd */
	{
		ns(struct sys_extattr_list_file_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 371 = extattr_list_file */
	{
		ns(struct sys_extattr_list_link_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 372 = extattr_list_link */
	{
		ns(struct compat_50_sys_pselect_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 373 = compat_50_pselect */
	{
		ns(struct compat_50_sys_pollts_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 374 = compat_50_pollts */
	{
		ns(struct sys_setxattr_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 375 = setxattr */
	{
		ns(struct sys_lsetxattr_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 376 = lsetxattr */
	{
		ns(struct sys_fsetxattr_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 377 = fsetxattr */
	{
		ns(struct sys_getxattr_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 378 = getxattr */
	{
		ns(struct sys_lgetxattr_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 379 = lgetxattr */
	{
		ns(struct sys_fgetxattr_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 380 = fgetxattr */
	{
		ns(struct sys_listxattr_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 381 = listxattr */
	{
		ns(struct sys_llistxattr_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 382 = llistxattr */
	{
		ns(struct sys_flistxattr_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 383 = flistxattr */
	{
		ns(struct sys_removexattr_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 384 = removexattr */
	{
		ns(struct sys_lremovexattr_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 385 = lremovexattr */
	{
		ns(struct sys_fremovexattr_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 386 = fremovexattr */
	{
		ns(struct compat_50_sys___stat30_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 387 = compat_50___stat30 */
	{
		ns(struct compat_50_sys___fstat30_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 388 = compat_50___fstat30 */
	{
		ns(struct compat_50_sys___lstat30_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 389 = compat_50___lstat30 */
	{
		ns(struct sys___getdents30_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 390 = __getdents30 */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 391 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 392 = __fhstat30 */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 393 = __ntp_gettime30 */
	{
		ns(struct sys___socket30_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 394 = __socket30 */
	{
		ns(struct sys___getfh30_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 395 = __getfh30 */
	{
		ns(struct sys___fhopen40_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 396 = __fhopen40 */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 397 = fhstatvfs1 */
	{
		ns(struct compat_50_sys___fhstat40_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 398 = compat_50___fhstat40 */
	{
		ns(struct sys_aio_cancel_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 399 = aio_cancel */
	{
		ns(struct sys_aio_error_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 400 = aio_error */
	{
		ns(struct sys_aio_fsync_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 401 = aio_fsync */
	{
		ns(struct sys_aio_read_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 402 = aio_read */
	{
		ns(struct sys_aio_return_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 403 = aio_return */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 404 = aio_suspend */
	{
		ns(struct sys_aio_write_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 405 = aio_write */
	{
		ns(struct sys_lio_listio_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 406 = lio_listio */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 407 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 408 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 409 = filler */
	{
		ns(struct sys___mount50_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 410 = __mount50 */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 411 = mremap */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 412 = pset_create */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 413 = pset_destroy */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 414 = pset_assign */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 415 = _pset_bind */
	{
		ns(struct sys___posix_fadvise50_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 416 = __posix_fadvise50 */
	{
		ns(struct sys___select50_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 417 = __select50 */
	{
		ns(struct sys___gettimeofday50_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 418 = __gettimeofday50 */
	{
		ns(struct sys___settimeofday50_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 419 = __settimeofday50 */
	{
		ns(struct sys___utimes50_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 420 = __utimes50 */
	{
		ns(struct sys___adjtime50_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 421 = __adjtime50 */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 422 = __lfs_segwait50 */
	{
		ns(struct sys___futimes50_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 423 = __futimes50 */
	{
		ns(struct sys___lutimes50_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 424 = __lutimes50 */
	{
		ns(struct sys___setitimer50_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 425 = __setitimer50 */
	{
		ns(struct sys___getitimer50_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 426 = __getitimer50 */
	{
		ns(struct sys___clock_gettime50_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 427 = __clock_gettime50 */
	{
		ns(struct sys___clock_settime50_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 428 = __clock_settime50 */
	{
		ns(struct sys___clock_getres50_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 429 = __clock_getres50 */
	{
		ns(struct sys___nanosleep50_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 430 = __nanosleep50 */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 431 = ____sigtimedwait50 */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 432 = __mq_timedsend50 */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 433 = __mq_timedreceive50 */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 434 = _lwp_park */
	{
		ns(struct compat_100_sys___kevent50_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 435 = compat_100___kevent50 */
	{
		ns(struct sys___pselect50_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 436 = __pselect50 */
	{
		ns(struct sys___pollts50_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 437 = __pollts50 */
	{
		ns(struct sys___aio_suspend50_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 438 = __aio_suspend50 */
	{
		ns(struct sys___stat50_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 439 = __stat50 */
	{
		ns(struct sys___fstat50_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 440 = __fstat50 */
	{
		ns(struct sys___lstat50_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 441 = __lstat50 */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 442 = ____semctl50 */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 443 = __shmctl50 */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 444 = __msgctl50 */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 445 = __getrusage50 */
	{
		ns(struct sys___timer_settime50_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 446 = __timer_settime50 */
	{
		ns(struct sys___timer_gettime50_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 447 = __timer_gettime50 */
#if defined(NTP) || !defined(_KERNEL_OPT)
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 448 = __ntp_gettime50 */
#else
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 448 = filler */
#endif
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 449 = __wait450 */
	{
		ns(struct sys___mknod50_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 450 = __mknod50 */
	{
		ns(struct sys___fhstat50_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 451 = __fhstat50 */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 452 = filler */
	{
		ns(struct sys_pipe2_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 453 = pipe2 */
	{
		ns(struct compat_100_sys_dup3_args),
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
	},		/* 454 = compat_100_dup3 */
	{
		ns(struct sys_kqueue1_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 455 = kqueue1 */
	{
		ns(struct sys_paccept_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 456 = paccept */
	{
		ns(struct sys_linkat_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 457 = linkat */
	{
		ns(struct sys_renameat_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 458 = renameat */
	{
		ns(struct sys_mkfifoat_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 459 = mkfifoat */
	{
		ns(struct sys_mknodat_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 460 = mknodat */
	{
		ns(struct sys_mkdirat_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 461 = mkdirat */
	{
		ns(struct sys_faccessat_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 462 = faccessat */
	{
		ns(struct sys_fchmodat_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 463 = fchmodat */
	{
		ns(struct sys_fchownat_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 464 = fchownat */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 465 = fexecve */
	{
		ns(struct sys_fstatat_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 466 = fstatat */
	{
		ns(struct sys_utimensat_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 467 = utimensat */
	{
		ns(struct sys_openat_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 468 = openat */
	{
		ns(struct sys_readlinkat_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 469 = readlinkat */
	{
		ns(struct sys_symlinkat_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 470 = symlinkat */
	{
		ns(struct sys_unlinkat_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 471 = unlinkat */
	{
		ns(struct sys_futimens_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 472 = futimens */
	{
		ns(struct sys___quotactl_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 473 = __quotactl */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 474 = posix_spawn */
	{
		ns(struct sys_recvmmsg_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 475 = recvmmsg */
	{
		ns(struct sys_sendmmsg_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 476 = sendmmsg */
	{
		ns(struct sys_clock_nanosleep_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 477 = clock_nanosleep */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 478 = ___lwp_park60 */
	{
		ns(struct sys_posix_fallocate_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 479 = posix_fallocate */
	{
		ns(struct sys_fdiscard_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 480 = fdiscard */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 481 = wait6 */
	{
		ns(struct sys_clock_getcpuclockid2_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 482 = clock_getcpuclockid2 */
	{
		ns(struct sys___getvfsstat90_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 483 = __getvfsstat90 */
	{
		ns(struct sys___statvfs190_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 484 = __statvfs190 */
	{
		ns(struct sys___fstatvfs190_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 485 = __fstatvfs190 */
	{
		ns(struct sys___fhstatvfs190_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 486 = __fhstatvfs190 */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 487 = __acl_get_link */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 488 = __acl_set_link */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 489 = __acl_delete_link */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 490 = __acl_aclcheck_link */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 491 = __acl_get_file */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 492 = __acl_set_file */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 493 = __acl_get_fd */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 494 = __acl_set_fd */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 495 = __acl_delete_file */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 496 = __acl_delete_fd */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 497 = __acl_aclcheck_file */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 498 = __acl_aclcheck_fd */
	{
		ns(struct sys_lpathconf_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 499 = lpathconf */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 500 = memfd_create */
	{
		ns(struct sys___kevent100_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 501 = __kevent100 */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 502 = epoll_create1 */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 503 = epoll_ctl */
	{
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
},		/* 504 = epoll_pwait2 */
	{
		ns(struct sys___dup3100_args),
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 505 = __dup3100 */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_sys_nomodule,
},		/* 506 = semtimedop */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 507 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 508 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 509 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 510 = filler */
	{
		.sy_flags = SYCALL_NOSYS,
		.sy_call = (sy_call_t *)(void *)rumpns_enosys,
	},		/* 511 = filler */
};

const uint32_t rump_sysent_nomodbits[] = {
	0x042c4180,	/* syscalls   0- 31 */
	0xc0b14140,	/* syscalls  32- 63 */
	0x23f80083,	/* syscalls  64- 95 */
	0x2437f0ea,	/* syscalls  96-127 */
	0x7877f406,	/* syscalls 128-159 */
	0x7f008e1e,	/* syscalls 160-191 */
	0xf0044010,	/* syscalls 192-223 */
	0xff9167ff,	/* syscalls 224-255 */
	0x01d107ff,	/* syscalls 256-287 */
	0x0000fc88,	/* syscalls 288-319 */
	0x0200fc01,	/* syscalls 320-351 */
	0x006000f0,	/* syscalls 352-383 */
	0x007fe338,	/* syscalls 384-415 */
	0x1c4f0040,	/* syscalls 416-447 */
	0x00000040,	/* syscalls 448-479 */
	0x04000000,	/* syscalls 480-511 */
};
CTASSERT(__arraycount(rump_sysent) == SYS_NSYSENT);
__strong_alias(rumpns_sysent,rump_sysent);
#endif /* RUMP_CLIENT */
