/*	$NetBSD: smu_8_0_d.h,v 1.3 2021/12/18 23:45:23 riastradh Exp $	*/

/*
 * SMU_8_0 Register documentation
 *
 * Copyright (C) 2014  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef SMU_8_0_D_H
#define SMU_8_0_D_H

#define ixTHM_TCON_CSR_CONFIG                                                   0xd82014a4
#define ixTHM_TCON_CSR_DATA                                                     0xd82014a8
#define ixTHM_TCON_HTC                                                          0xd8200c64
#define ixTHM_TCON_CUR_TMP                                                      0xd8200ca4
#define ixTHM_TCON_THERM_TRIP                                                   0xd8200ce4
#define ixTHM_GPIO_PROCHOT_CTRL                                                 0xd8200d00
#define ixTHM_GPIO_THERMTRIP_CTRL                                               0xd8200d04
#define ixTHM_THERMAL_INT_ENA                                                   0xd8200d10
#define ixTHM_THERMAL_INT_CTRL                                                  0xd8200d14
#define ixTHM_THERMAL_INT_STATUS                                                0xd8200d18
#define ixTMON0_RDIL0_DATA                                                      0xd8202000
#define ixTMON0_RDIL1_DATA                                                      0xd8202004
#define ixTMON0_RDIL2_DATA                                                      0xd8202008
#define ixTMON0_RDIL3_DATA                                                      0xd820200c
#define ixTMON0_RDIL4_DATA                                                      0xd8202010
#define ixTMON0_RDIL5_DATA                                                      0xd8202014
#define ixTMON0_RDIL6_DATA                                                      0xd8202018
#define ixTMON0_RDIL7_DATA                                                      0xd820201c
#define ixTMON0_RDIL8_DATA                                                      0xd8202020
#define ixTMON0_RDIL9_DATA                                                      0xd8202024
#define ixTMON0_RDIL10_DATA                                                     0xd8202028
#define ixTMON0_RDIL11_DATA                                                     0xd820202c
#define ixTMON0_RDIL12_DATA                                                     0xd8202030
#define ixTMON0_RDIL13_DATA                                                     0xd8202034
#define ixTMON0_RDIL14_DATA                                                     0xd8202038
#define ixTMON0_RDIL15_DATA                                                     0xd820203c
#define ixTMON0_RDIR0_DATA                                                      0xd8202040
#define ixTMON0_RDIR1_DATA                                                      0xd8202044
#define ixTMON0_RDIR2_DATA                                                      0xd8202048
#define ixTMON0_RDIR3_DATA                                                      0xd820204c
#define ixTMON0_RDIR4_DATA                                                      0xd8202050
#define ixTMON0_RDIR5_DATA                                                      0xd8202054
#define ixTMON0_RDIR6_DATA                                                      0xd8202058
#define ixTMON0_RDIR7_DATA                                                      0xd820205c
#define ixTMON0_RDIR8_DATA                                                      0xd8202060
#define ixTMON0_RDIR9_DATA                                                      0xd8202064
#define ixTMON0_RDIR10_DATA                                                     0xd8202068
#define ixTMON0_RDIR11_DATA                                                     0xd820206c
#define ixTMON0_RDIR12_DATA                                                     0xd8202070
#define ixTMON0_RDIR13_DATA                                                     0xd8202074
#define ixTMON0_RDIR14_DATA                                                     0xd8202078
#define ixTMON0_RDIR15_DATA                                                     0xd820207c
#define ixTMON0_INT_DATA                                                        0xd8202080
#define ixTMON0_RDIL_PRESENT0                                                   0xd8202084
#define ixTMON0_RDIL_PRESENT1                                                   0xd8202088
#define ixTMON0_RDIR_PRESENT0                                                   0xd820208c
#define ixTMON0_RDIR_PRESENT1                                                   0xd8202090
#define ixTMON0_CONFIG                                                          0xd8202098
#define ixTMON0_TEMP_CALC_COEFF0                                                0xd82020a0
#define ixTMON0_TEMP_CALC_COEFF1                                                0xd82020a4
#define ixTMON0_TEMP_CALC_COEFF2                                                0xd82020a8
#define ixTMON0_TEMP_CALC_COEFF3                                                0xd82020ac
#define ixTMON0_TEMP_CALC_COEFF4                                                0xd82020b0
#define ixTMON0_DEBUG0                                                          0xd82020b4
#define ixTMON0_DEBUG1                                                          0xd82020b8
#define ixTMON1_RDIL0_DATA                                                      0xd8202100
#define ixTMON1_RDIL1_DATA                                                      0xd8202104
#define ixTMON1_RDIL2_DATA                                                      0xd8202108
#define ixTMON1_RDIL3_DATA                                                      0xd820210c
#define ixTMON1_RDIL4_DATA                                                      0xd8202110
#define ixTMON1_RDIL5_DATA                                                      0xd8202114
#define ixTMON1_RDIL6_DATA                                                      0xd8202118
#define ixTMON1_RDIL7_DATA                                                      0xd820211c
#define ixTMON1_RDIL8_DATA                                                      0xd8202120
#define ixTMON1_RDIL9_DATA                                                      0xd8202124
#define ixTMON1_RDIL10_DATA                                                     0xd8202128
#define ixTMON1_RDIL11_DATA                                                     0xd820212c
#define ixTMON1_RDIL12_DATA                                                     0xd8202130
#define ixTMON1_RDIL13_DATA                                                     0xd8202134
#define ixTMON1_RDIL14_DATA                                                     0xd8202138
#define ixTMON1_RDIL15_DATA                                                     0xd820213c
#define ixTMON1_RDIR0_DATA                                                      0xd8202140
#define ixTMON1_RDIR1_DATA                                                      0xd8202144
#define ixTMON1_RDIR2_DATA                                                      0xd8202148
#define ixTMON1_RDIR3_DATA                                                      0xd820214c
#define ixTMON1_RDIR4_DATA                                                      0xd8202150
#define ixTMON1_RDIR5_DATA                                                      0xd8202154
#define ixTMON1_RDIR6_DATA                                                      0xd8202158
#define ixTMON1_RDIR7_DATA                                                      0xd820215c
#define ixTMON1_RDIR8_DATA                                                      0xd8202160
#define ixTMON1_RDIR9_DATA                                                      0xd8202164
#define ixTMON1_RDIR10_DATA                                                     0xd8202168
#define ixTMON1_RDIR11_DATA                                                     0xd820216c
#define ixTMON1_RDIR12_DATA                                                     0xd8202170
#define ixTMON1_RDIR13_DATA                                                     0xd8202174
#define ixTMON1_RDIR14_DATA                                                     0xd8202178
#define ixTMON1_RDIR15_DATA                                                     0xd820217c
#define ixTMON1_INT_DATA                                                        0xd8202180
#define ixTMON1_RDIL_PRESENT0                                                   0xd8202184
#define ixTMON1_RDIL_PRESENT1                                                   0xd8202188
#define ixTMON1_RDIR_PRESENT0                                                   0xd820218c
#define ixTMON1_RDIR_PRESENT1                                                   0xd8202190
#define ixTMON1_CONFIG                                                          0xd8202198
#define ixTMON1_TEMP_CALC_COEFF0                                                0xd82021a0
#define ixTMON1_TEMP_CALC_COEFF1                                                0xd82021a4
#define ixTMON1_TEMP_CALC_COEFF2                                                0xd82021a8
#define ixTMON1_TEMP_CALC_COEFF3                                                0xd82021ac
#define ixTMON1_TEMP_CALC_COEFF4                                                0xd82021b0
#define ixTMON1_DEBUG0                                                          0xd82021b4
#define ixTMON1_DEBUG1                                                          0xd82021b8
#define ixTHM_TMON0_REMOTE_START                                                0xd8202800
#define ixTHM_TMON0_REMOTE_END                                                  0xd82028fc
#define ixTHM_TMON1_REMOTE_START                                                0xd8202900
#define ixTHM_TMON1_REMOTE_END                                                  0xd82029fc
#define ixTHM_TCON_LOCAL0                                                       0xd8202e00
#define ixTHM_TCON_LOCAL1                                                       0xd8202e04
#define ixTHM_TCON_LOCAL2                                                       0xd8202e08
#define ixTHM_TCON_LOCAL3                                                       0xd8202e0c
#define ixTHM_TCON_LOCAL4                                                       0xd8202e10
#define ixTHM_TCON_LOCAL5                                                       0xd8202e14
#define ixTHM_TCON_LOCAL6                                                       0xd8202e18
#define ixTHM_TCON_LOCAL7                                                       0xd8202e1c
#define ixTHM_TCON_LOCAL8                                                       0xd8202e20
#define ixTHM_TCON_LOCAL9                                                       0xd8202e24
#define ixTHM_TCON_LOCAL10                                                      0xd8202e28
#define ixTHM_TCON_LOCAL11                                                      0xd8202e2c
#define ixTHM_TCON_LOCAL12                                                      0xd8202e30
#define ixTHM_TCON_LOCAL13                                                      0xd8202ef8
#define ixTHM_TCON_LOCAL14                                                      0xd8202efc
#define ixTHM_FUSE0                                                             0xd8210000
#define ixTHM_FUSE1                                                             0xd8210004
#define ixTHM_FUSE2                                                             0xd8210008
#define ixTHM_FUSE3                                                             0xd821000c
#define ixTHM_FUSE4                                                             0xd8210010
#define ixTHM_FUSE5                                                             0xd8210014
#define ixTHM_FUSE6                                                             0xd8210018
#define ixTHM_FUSE7                                                             0xd821001c
#define ixTHM_FUSE8                                                             0xd8210020
#define ixTHM_FUSE9                                                             0xd8210024
#define ixTHM_FUSE10                                                            0xd8210028
#define ixTHM_FUSE11                                                            0xd821002c
#define ixTHM_FUSE12                                                            0xd8210030
#define mmMP0PUB_IND_INDEX                                                      0x180
#define mmMP_SMUIF0_MP0PUB_IND_INDEX                                            0x180
#define mmMP_SMUIF1_MP0PUB_IND_INDEX                                            0x182
#define mmMP_SMUIF2_MP0PUB_IND_INDEX                                            0x184
#define mmMP_SMUIF3_MP0PUB_IND_INDEX                                            0x186
#define mmMP_SMUIF4_MP0PUB_IND_INDEX                                            0x188
#define mmMP_SMUIF5_MP0PUB_IND_INDEX                                            0x18a
#define mmMP_SMUIF6_MP0PUB_IND_INDEX                                            0x18c
#define mmMP_SMUIF7_MP0PUB_IND_INDEX                                            0x18e
#define mmMP_SMUIF8_MP0PUB_IND_INDEX                                            0x190
#define mmMP_SMUIF9_MP0PUB_IND_INDEX                                            0x192
#define mmMP_SMUIF10_MP0PUB_IND_INDEX                                           0x194
#define mmMP_SMUIF11_MP0PUB_IND_INDEX                                           0x196
#define mmMP_SMUIF12_MP0PUB_IND_INDEX                                           0x198
#define mmMP_SMUIF13_MP0PUB_IND_INDEX                                           0x19a
#define mmMP_SMUIF14_MP0PUB_IND_INDEX                                           0x19c
#define mmMP_SMUIF15_MP0PUB_IND_INDEX                                           0x19e
#define mmMP0PUB_IND_DATA                                                       0x181
#define mmMP_SMUIF0_MP0PUB_IND_DATA                                             0x181
#define mmMP_SMUIF1_MP0PUB_IND_DATA                                             0x183
#define mmMP_SMUIF2_MP0PUB_IND_DATA                                             0x185
#define mmMP_SMUIF3_MP0PUB_IND_DATA                                             0x187
#define mmMP_SMUIF4_MP0PUB_IND_DATA                                             0x189
#define mmMP_SMUIF5_MP0PUB_IND_DATA                                             0x18b
#define mmMP_SMUIF6_MP0PUB_IND_DATA                                             0x18d
#define mmMP_SMUIF7_MP0PUB_IND_DATA                                             0x18f
#define mmMP_SMUIF8_MP0PUB_IND_DATA                                             0x191
#define mmMP_SMUIF9_MP0PUB_IND_DATA                                             0x193
#define mmMP_SMUIF10_MP0PUB_IND_DATA                                            0x195
#define mmMP_SMUIF11_MP0PUB_IND_DATA                                            0x197
#define mmMP_SMUIF12_MP0PUB_IND_DATA                                            0x199
#define mmMP_SMUIF13_MP0PUB_IND_DATA                                            0x19b
#define mmMP_SMUIF14_MP0PUB_IND_DATA                                            0x19d
#define mmMP_SMUIF15_MP0PUB_IND_DATA                                            0x19f
#define mmMP0PUB_IND_INDEX_0                                                    0x180
#define mmMP0PUB_IND_DATA_0                                                     0x181
#define mmMP0PUB_IND_INDEX_1                                                    0x182
#define mmMP0PUB_IND_DATA_1                                                     0x183
#define mmMP0PUB_IND_INDEX_2                                                    0x184
#define mmMP0PUB_IND_DATA_2                                                     0x185
#define mmMP0PUB_IND_INDEX_3                                                    0x186
#define mmMP0PUB_IND_DATA_3                                                     0x187
#define mmMP0PUB_IND_INDEX_4                                                    0x188
#define mmMP0PUB_IND_DATA_4                                                     0x189
#define mmMP0PUB_IND_INDEX_5                                                    0x18a
#define mmMP0PUB_IND_DATA_5                                                     0x18b
#define mmMP0PUB_IND_INDEX_6                                                    0x18c
#define mmMP0PUB_IND_DATA_6                                                     0x18d
#define mmMP0PUB_IND_INDEX_7                                                    0x18e
#define mmMP0PUB_IND_DATA_7                                                     0x18f
#define mmMP0PUB_IND_INDEX_8                                                    0x190
#define mmMP0PUB_IND_DATA_8                                                     0x191
#define mmMP0PUB_IND_INDEX_9                                                    0x192
#define mmMP0PUB_IND_DATA_9                                                     0x193
#define mmMP0PUB_IND_INDEX_10                                                   0x194
#define mmMP0PUB_IND_DATA_10                                                    0x195
#define mmMP0PUB_IND_INDEX_11                                                   0x196
#define mmMP0PUB_IND_DATA_11                                                    0x197
#define mmMP0PUB_IND_INDEX_12                                                   0x198
#define mmMP0PUB_IND_DATA_12                                                    0x199
#define mmMP0PUB_IND_INDEX_13                                                   0x19a
#define mmMP0PUB_IND_DATA_13                                                    0x19b
#define mmMP0PUB_IND_INDEX_14                                                   0x19c
#define mmMP0PUB_IND_DATA_14                                                    0x19d
#define mmMP0PUB_IND_INDEX_15                                                   0x19e
#define mmMP0PUB_IND_DATA_15                                                    0x19f
#define mmMP0_IND_ACCESS_CNTL                                                   0x1a0
#define mmMP0_MSP_MESSAGE_0                                                     0x1a1
#define mmMP0_MSP_MESSAGE_1                                                     0x1a2
#define mmMP0_MSP_MESSAGE_2                                                     0x1a3
#define mmMP0_MSP_MESSAGE_3                                                     0x1a4
#define mmMP0_MSP_MESSAGE_4                                                     0x1a5
#define mmMP0_MSP_MESSAGE_5                                                     0x1a6
#define mmMP0_MSP_MESSAGE_6                                                     0x1a7
#define mmMP0_MSP_MESSAGE_7                                                     0x1a8
#define mmSAM_IH_EXT_ERR_INTR                                                   0x1a9
#define mmSAM_IH_EXT_ERR_INTR_STATUS                                            0x1aa
#define mmMP0_DISP_TIMER0_CTRL0                                                 0x1ab
#define mmMP0_DISP_TIMER0_CTRL1                                                 0x1ac
#define mmMP0_DISP_TIMER0_CMP_AUTOINC                                           0x1ad
#define mmMP0_DISP_TIMER0_INTEN                                                 0x1ae
#define mmMP0_DISP_TIMER0_OCMP_0_0                                              0x1af
#define mmMP0_DISP_TIMER0_OCMP_0_1                                              0x1b0
#define mmMP0_DISP_TIMER0_CNT                                                   0x1b1
#define mmMP0_DISP_TIMER1_CTRL0                                                 0x1b2
#define mmMP0_DISP_TIMER1_CTRL1                                                 0x1b3
#define mmMP0_DISP_TIMER1_CMP_AUTOINC                                           0x1b4
#define mmMP0_DISP_TIMER1_INTEN                                                 0x1b5
#define mmMP0_DISP_TIMER1_OCMP_0_0                                              0x1b6
#define mmMP0_DISP_TIMER1_OCMP_0_1                                              0x1b7
#define mmMP0_DISP_TIMER1_CNT                                                   0x1b8
#define mmSMU_MP1_SRBM2P_MSG_0                                                  0x1c0
#define mmSMU_MP1_SRBM2P_MSG_1                                                  0x1c1
#define mmSMU_MP1_SRBM2P_MSG_2                                                  0x1c2
#define mmSMU_MP1_SRBM2P_MSG_3                                                  0x1c3
#define mmSMU_MP1_SRBM2P_MSG_4                                                  0x1c4
#define mmSMU_MP1_SRBM2P_MSG_5                                                  0x1c5
#define mmSMU_MP1_SRBM2P_MSG_6                                                  0x1c6
#define mmSMU_MP1_SRBM2P_MSG_7                                                  0x1c7
#define mmSMU_MP1_SRBM2P_MSG_8                                                  0x1c8
#define mmSMU_MP1_SRBM2P_MSG_9                                                  0x1c9
#define mmSMU_MP1_SRBM2P_MSG_10                                                 0x1ca
#define mmSMU_MP1_SRBM2P_MSG_11                                                 0x1cb
#define mmSMU_MP1_SRBM2P_MSG_12                                                 0x1cc
#define mmSMU_MP1_SRBM2P_MSG_13                                                 0x1cd
#define mmSMU_MP1_SRBM2P_MSG_14                                                 0x1ce
#define mmSMU_MP1_SRBM2P_MSG_15                                                 0x1cf
#define mmSMU_MP1_SRBM2P_RESP_0                                                 0x1d0
#define mmSMU_MP1_SRBM2P_RESP_1                                                 0x1d1
#define mmSMU_MP1_SRBM2P_RESP_2                                                 0x1d2
#define mmSMU_MP1_SRBM2P_RESP_3                                                 0x1d3
#define mmSMU_MP1_SRBM2P_RESP_4                                                 0x1d4
#define mmSMU_MP1_SRBM2P_RESP_5                                                 0x1d5
#define mmSMU_MP1_SRBM2P_RESP_6                                                 0x1d6
#define mmSMU_MP1_SRBM2P_RESP_7                                                 0x1d7
#define mmSMU_MP1_SRBM2P_RESP_8                                                 0x1d8
#define mmSMU_MP1_SRBM2P_RESP_9                                                 0x1d9
#define mmSMU_MP1_SRBM2P_RESP_10                                                0x1da
#define mmSMU_MP1_SRBM2P_RESP_11                                                0x1db
#define mmSMU_MP1_SRBM2P_RESP_12                                                0x1dc
#define mmSMU_MP1_SRBM2P_RESP_13                                                0x1dd
#define mmSMU_MP1_SRBM2P_RESP_14                                                0x1de
#define mmSMU_MP1_SRBM2P_RESP_15                                                0x1df
#define mmSMU_MP1_SRBM2P_ARG_0                                                  0x1e0
#define mmSMU_MP1_SRBM2P_ARG_1                                                  0x1e1
#define mmSMU_MP1_SRBM2P_ARG_2                                                  0x1e2
#define mmSMU_MP1_SRBM2P_ARG_3                                                  0x1e3
#define mmSMU_MP1_SRBM2P_ARG_4                                                  0x1e4
#define mmSMU_MP1_SRBM2P_ARG_5                                                  0x1e5
#define mmSMU_MP1_SRBM2P_ARG_6                                                  0x1e6
#define mmSMU_MP1_SRBM2P_ARG_7                                                  0x1e7
#define mmSMU_MP1_SRBM2P_ARG_8                                                  0x1e8
#define mmSMU_MP1_SRBM2P_ARG_9                                                  0x1e9
#define mmSMU_MP1_SRBM2P_ARG_10                                                 0x1ea
#define mmSMU_MP1_SRBM2P_ARG_11                                                 0x1eb
#define mmSMU_MP1_SRBM2P_ARG_12                                                 0x1ec
#define mmSMU_MP1_SRBM2P_ARG_13                                                 0x1ed
#define mmSMU_MP1_SRBM2P_ARG_14                                                 0x1ee
#define mmSMU_MP1_SRBM2P_ARG_15                                                 0x1ef
#define mmSMU_MP1_ACP2MP_RESP                                                   0x1f0
#define mmSMU_MP1_DC2MP_RESP                                                    0x1f1
#define mmSMU_MP1_UVD2MP_RESP                                                   0x1f2
#define mmSMU_MP1_VCE2MP_RESP                                                   0x1f3
#define mmSMU_MP1_RLC2MP_RESP                                                   0x1f4
#define mmMP_FPS_CNT                                                            0x1f5
#define mmSMU_DISP0_TIMER_INT_CONTROL                                           0x1f6
#define mmSMU_DISP1_TIMER_INT_CONTROL                                           0x1f7
#define mmSMU_SRBM_CONFIG                                                       0x1f8
#define ixMP_FPS_CNT_XBAR                                                       0xcf200800
#define ixMP_SRBM_CONFIG_XBAR                                                   0xcf200804
#define ixMP_SRBM_CONTROL                                                       0xcf200c00
#define ixMP_SRBM_ACCVIO_LOG                                                    0xcf200c04
#define ixMP_SRBM_ACCVIO_ADDR                                                   0xcf200c08
#define ixMP_CRBBM_CONTROL                                                      0xcf200c0c
#define ixMP_CRBBM_ACCVIO_LOG                                                   0xcf200c10
#define ixMP_CRBBM_ACCVIO_ADDR                                                  0xcf200c14
#define ixMP_DRAM_CNTL_WRREQ_CNTL                                               0xcf200000
#define ixMP_DRAM_CNTL_WRREQ_CNTL_1                                             0xcf200004
#define ixMP_DRAM_CNTL_WRREQ_LOW_ADDR                                           0xcf200008
#define ixMP_DRAM_CNTL_WRREQ_HIGH_ADDR                                          0xcf20000c
#define ixMP_DRAM_CNTL_WRREQ_MASK                                               0xcf200010
#define ixMP_DRAM_CNTL_WRREQ_DATA_0                                             0xcf200014
#define ixMP_DRAM_CNTL_WRREQ_DATA_1                                             0xcf200018
#define ixMP_DRAM_CNTL_WRREQ_DATA_2                                             0xcf20001c
#define ixMP_DRAM_CNTL_WRREQ_DATA_3                                             0xcf200020
#define ixMP_DRAM_CNTL_WRREQ_DATA_4                                             0xcf200024
#define ixMP_DRAM_CNTL_WRREQ_DATA_5                                             0xcf200028
#define ixMP_DRAM_CNTL_WRREQ_DATA_6                                             0xcf20002c
#define ixMP_DRAM_CNTL_WRREQ_DATA_7                                             0xcf200030
#define ixMP_DRAM_CNTL_WRREQ_STATUS                                             0xcf200038
#define ixMP_DRAM_CNTL_WRRET_STATUS_0                                           0xcf20003c
#define ixMP_DRAM_CNTL_RDREQ_ADDR                                               0xcf200040
#define ixMP_DRAM_CNTL_RDREQ_CNTL                                               0xcf200044
#define ixMP_DRAM_CNTL_RDREQ_CNTL_1                                             0xcf200048
#define ixMP_DRAM_CNTL_RDRET_VALID                                              0xcf20004c
#define ixMP_DRAM_CNTL_RDRET_NACK                                               0xcf200050
#define ixMP_DRAM_CNTL_RDRET_DATA_0                                             0xcf200054
#define ixMP_DRAM_CNTL_RDRET_DATA_1                                             0xcf200058
#define ixMP_DRAM_CNTL_RDRET_DATA_2                                             0xcf20005c
#define ixMP_DRAM_CNTL_RDRET_DATA_3                                             0xcf200060
#define ixMP_DRAM_CNTL_RDRET_DATA_4                                             0xcf200064
#define ixMP_DRAM_CNTL_RDRET_DATA_5                                             0xcf200068
#define ixMP_DRAM_CNTL_RDRET_DATA_6                                             0xcf20006c
#define ixMP_DRAM_CNTL_RDRET_DATA_7                                             0xcf200070
#define ixMP_DRAM_CNTL_RDRET_DATA_8                                             0xcf200074
#define ixMP_DRAM_CNTL_RDRET_DATA_9                                             0xcf200078
#define ixMP_DRAM_CNTL_RDRET_DATA_10                                            0xcf20007c
#define ixMP_DRAM_CNTL_RDRET_DATA_11                                            0xcf200080
#define ixMP_DRAM_CNTL_RDRET_DATA_12                                            0xcf200084
#define ixMP_DRAM_CNTL_RDRET_DATA_13                                            0xcf200088
#define ixMP_DRAM_CNTL_RDRET_DATA_14                                            0xcf20008c
#define ixMP_DRAM_CNTL_RDRET_DATA_15                                            0xcf200090
#define ixMP_DRAM_CNTL_RDRET_DATA_16                                            0xcf200094
#define ixMP_DRAM_CNTL_RDRET_DATA_17                                            0xcf200098
#define ixMP_DRAM_CNTL_RDRET_DATA_18                                            0xcf20009c
#define ixMP_DRAM_CNTL_RDRET_DATA_19                                            0xcf2000a0
#define ixMP_DRAM_CNTL_RDRET_DATA_20                                            0xcf2000a4
#define ixMP_DRAM_CNTL_RDRET_DATA_21                                            0xcf2000a8
#define ixMP_DRAM_CNTL_RDRET_DATA_22                                            0xcf2000ac
#define ixMP_DRAM_CNTL_RDRET_DATA_23                                            0xcf2000b0
#define ixMP_DRAM_CNTL_RDRET_DATA_24                                            0xcf2000b4
#define ixMP_DRAM_CNTL_RDRET_DATA_25                                            0xcf2000b8
#define ixMP_DRAM_CNTL_RDRET_DATA_26                                            0xcf2000bc
#define ixMP_DRAM_CNTL_RDRET_DATA_27                                            0xcf2000c0
#define ixMP_DRAM_CNTL_RDRET_DATA_28                                            0xcf2000c4
#define ixMP_DRAM_CNTL_RDRET_DATA_29                                            0xcf2000c8
#define ixMP_DRAM_CNTL_RDRET_DATA_30                                            0xcf2000cc
#define ixMP_DRAM_CNTL_RDRET_DATA_31                                            0xcf2000d0
#define ixMP_DRAM_CNTL_RDRET_DATA_32                                            0xcf2000d4
#define ixMP_DRAM_CNTL_RDRET_DATA_33                                            0xcf2000d8
#define ixMP_DRAM_CNTL_RDRET_DATA_34                                            0xcf2000dc
#define ixMP_DRAM_CNTL_RDRET_DATA_35                                            0xcf2000e0
#define ixMP_DRAM_CNTL_RDRET_DATA_36                                            0xcf2000e4
#define ixMP_DRAM_CNTL_RDRET_DATA_37                                            0xcf2000e8
#define ixMP_DRAM_CNTL_RDRET_DATA_38                                            0xcf2000ec
#define ixMP_DRAM_CNTL_RDRET_DATA_39                                            0xcf2000f0
#define ixMP_DRAM_CNTL_RDRET_DATA_40                                            0xcf2000f4
#define ixMP_DRAM_CNTL_RDRET_DATA_41                                            0xcf2000f8
#define ixMP_DRAM_CNTL_RDRET_DATA_42                                            0xcf2000fc
#define ixMP_DRAM_CNTL_RDRET_DATA_43                                            0xcf200100
#define ixMP_DRAM_CNTL_RDRET_DATA_44                                            0xcf200104
#define ixMP_DRAM_CNTL_RDRET_DATA_45                                            0xcf200108
#define ixMP_DRAM_CNTL_RDRET_DATA_46                                            0xcf20010c
#define ixMP_DRAM_CNTL_RDRET_DATA_47                                            0xcf200110
#define ixMP_DRAM_CNTL_RDRET_DATA_48                                            0xcf200114
#define ixMP_DRAM_CNTL_RDRET_DATA_49                                            0xcf200118
#define ixMP_DRAM_CNTL_RDRET_DATA_50                                            0xcf20011c
#define ixMP_DRAM_CNTL_RDRET_DATA_51                                            0xcf200120
#define ixMP_DRAM_CNTL_RDRET_DATA_52                                            0xcf200124
#define ixMP_DRAM_CNTL_RDRET_DATA_53                                            0xcf200128
#define ixMP_DRAM_CNTL_RDRET_DATA_54                                            0xcf20012c
#define ixMP_DRAM_CNTL_RDRET_DATA_55                                            0xcf200130
#define ixMP_DRAM_CNTL_RDRET_DATA_56                                            0xcf200134
#define ixMP_DRAM_CNTL_RDRET_DATA_57                                            0xcf200138
#define ixMP_DRAM_CNTL_RDRET_DATA_58                                            0xcf20013c
#define ixMP_DRAM_CNTL_RDRET_DATA_59                                            0xcf200140
#define ixMP_DRAM_CNTL_RDRET_DATA_60                                            0xcf200144
#define ixMP_DRAM_CNTL_RDRET_DATA_61                                            0xcf200148
#define ixMP_DRAM_CNTL_RDRET_DATA_62                                            0xcf20014c
#define ixMP_DRAM_CNTL_RDRET_DATA_63                                            0xcf200150
#define ixMP_IOC_CTRL                                                           0xcf100000
#define ixMP_IOC_RDDATA                                                         0xcf100004
#define ixMP_IOC_PHASE1                                                         0xcf100008
#define ixMP_IOC_PHASE2                                                         0xcf10000c
#define ixMP_IOC_PHASE3                                                         0xcf100010
#define ixMP_IOC_READ_0                                                         0xcf100024
#define ixMP_IOC_READ_1                                                         0xcf100028
#define ixMP_IOC_READ_2                                                         0xcf10002c
#define ixMP_IOC_READ_3                                                         0xcf100030
#define ixMP_IOC_READ_4                                                         0xcf100034
#define ixMP_IOC_READ_5                                                         0xcf100038
#define ixMP_IOC_READ_6                                                         0xcf10003c
#define ixMP_IOC_READ_7                                                         0xcf100040
#define ixMP_IOC_READ_8                                                         0xcf100044
#define ixMP_IOC_READ_9                                                         0xcf100048
#define ixMP_IOC_READ_10                                                        0xcf10004c
#define ixMP_IOC_READ_11                                                        0xcf100050
#define ixMP_IOC_READ_12                                                        0xcf100054
#define ixMP_IOC_READ_13                                                        0xcf100058
#define ixMP_IOC_READ_14                                                        0xcf10005c
#define ixMP_IOC_READ_15                                                        0xcf100060
#define ixMP_IOC_WRITE_0                                                        0xcf100064
#define ixMP_IOC_WRITE_1                                                        0xcf100068
#define ixMP_IOC_WRITE_2                                                        0xcf10006c
#define ixMP_IOC_WRITE_3                                                        0xcf100070
#define ixMP_IOC_WRITE_4                                                        0xcf100074
#define ixMP_IOC_WRITE_5                                                        0xcf100078
#define ixMP_IOC_WRITE_6                                                        0xcf10007c
#define ixMP_IOC_WRITE_7                                                        0xcf100080
#define ixMP_IOC_WRITE_8                                                        0xcf100084
#define ixMP_IOC_WRITE_9                                                        0xcf100088
#define ixMP_IOC_WRITE_10                                                       0xcf10008c
#define ixMP_IOC_WRITE_11                                                       0xcf100090
#define ixMP_IOC_WRITE_12                                                       0xcf100094
#define ixMP_IOC_WRITE_13                                                       0xcf100098
#define ixMP_IOC_WRITE_14                                                       0xcf10009c
#define ixMP_IOC_WRITE_15                                                       0xcf1000a0
#define ixMP_INTERRUPT_CONTROL                                                  0xcf200400
#define ixMP0_SW_INT                                                            0xcf200404
#define ixMP0_SW_INT_CTXID                                                      0xcf200408
#define ixMP1_SW_INT                                                            0xcf20040c
#define ixMP1_SW_INT_CTXID                                                      0xcf200410
#define ixDISP_TIMER_ID                                                         0xcf200414
#define mmPWRHW_SMC_IND_INDEX                                                   0x180
#define mmPWRHW0_PWRHW_SMC_IND_INDEX                                            0x180
#define mmPWRHW1_PWRHW_SMC_IND_INDEX                                            0x182
#define mmPWRHW2_PWRHW_SMC_IND_INDEX                                            0x184
#define mmPWRHW3_PWRHW_SMC_IND_INDEX                                            0x186
#define mmPWRHW_SMC_IND_DATA                                                    0x181
#define mmPWRHW0_PWRHW_SMC_IND_DATA                                             0x181
#define mmPWRHW1_PWRHW_SMC_IND_DATA                                             0x183
#define mmPWRHW2_PWRHW_SMC_IND_DATA                                             0x185
#define mmPWRHW3_PWRHW_SMC_IND_DATA                                             0x187
#define ixCURRENT_STATE_CPU0                                                    0xd0210000
#define ixCURRENT_STATE_CPU1                                                    0xd0210010
#define ixCPU_REDUN_DONE0                                                       0xd0210004
#define ixCPU_REDUN_DONE1                                                       0xd0210014
#define ixCURRENT_VID_CPU0                                                      0xd0210008
#define ixCURRENT_VID_CPU1                                                      0xd0210018
#define ixUNBPM_PWRMGT_ACK                                                      0xd0211000
#define ixCURRENT_FREQ_STATE_NB                                                 0xd0211004
#define ixCURRENT_PSTATE_NB                                                     0xd0211008
#define ixUNBPM_MSG_INT_CONFIG                                                  0xd021100c
#define ixUNBPM_NBPWRMGT_CMD                                                    0xd0211010
#define ixUNBPM_NBPWRMGT_FSM_CFG                                                0xd0211014
#define ixDDR0_FUSE_SSB_XFER                                                    0xd0211018
#define ixDDR0_FUSE_SSB_XFER_CFG                                                0xd021101c
#define ixDDR1_FUSE_SSB_XFER                                                    0xd0211020
#define ixDDR1_FUSE_SSB_XFER_CFG                                                0xd0211024
#define ixUNBPM_FUSES_VAL_PWROK                                                 0xd0211028
#define ixSYNFIFO_CLK_RATIO                                                     0xd021102c
#define ixMISC_SMU_PWRMGT_CFG0                                                  0xd0211030
#define ixMISC_GNB_PWRMGT_CFG1                                                  0xd0211034
#define ixMISC_SMU_PWRMGT_CFG1                                                  0xd0211038
#define ixMISC_GNB_PWRMGT_DATA                                                  0xd021103c
#define ixGN_GNB_SLOW                                                           0xd0211040
#define ixGN_FORCE_NBPS1                                                        0xd0211044
#define ixMISC_SMU_PWRMGT_DATA                                                  0xd0211048
#define ixNB_COF                                                                0xd021104c
#define ixUNBPM_CK_IRESET                                                       0xd0211050
#define ixCURRENT_VID_NB                                                        0xd0211054
#define ixSPR_FUSE_PSTATEPWR1                                                   0xd0211058
#define ixSPR_FUSE_PSTATEPWR2                                                   0xd021105c
#define ixSPR_FUSE_PSTATEPWR3                                                   0xd0211060
#define ixSPR_FUSE_THERMAL_SCRATCH                                              0xd0211064
#define ixSPR_PRODUCT_INFO0                                                     0xd0211068
#define ixSPR_SERIALNUM_REG1                                                    0xd021106c
#define ixSPR_SERIALNUM_REG2                                                    0xd0211070
#define ixSPR_PRODUCT_INFO1                                                     0xd0211074
#define ixSPR_EXT_PRODUCT_INFO                                                  0xd021107c
#define ixSPR_MSIDFUSE                                                          0xd0211080
#define ixSPR_LINK_PRODUCT_INFO                                                 0xd0211084
#define ixSPR_BRAND_NAME_ADDR                                                   0xd0211088
#define ixSPR_BRAND_NAME_DATA                                                   0xd021108c
#define ixSPR_COMBO_PHY_PRODUCT_INFO                                            0xd0211090
#define ixMISC_GNB_PWRMGT_CFG0                                                  0xd0211094
#define ixUNBPM_EXIT_TO_PSTATE                                                  0xd0211098
#define ixUNBPM_WARM_RESET_HS_STATUS                                            0xd021109c
#define ixUNBPM_VOLTAGE_CNTL                                                    0xd02110a0
#define ixUNBPM_VOLTAGE_STATUS                                                  0xd02110a4
#define ixNUM_BOOST_STATES                                                      0xd02110a8
#define ixWARM_RESET_NB_CONTROL                                                 0xd02110ac
#define ixONION_NO_STREAMS_PEND                                                 0xd02110b0
#define ixSPR_PROGRAMMABLE_CTRL                                                 0xd02110b4
#define ixPHN_FUSERX_MISC_FUSES                                                 0xd02110b8
#define ixUNBPM_PWRCTRL_MISC                                                    0xd02110bc
#define ixCSTATE_ACTIVE_SAMPLER                                                 0xd02110c0
#define ixUNBPM_DEBUG_CONFIG_STATUS                                             0xd02110c4
#define ixUNBPM_AXIMST_LAST_CMD                                                 0xd02110c8
#define ixUNB_IF_INTRGEN_LAST_SENT                                              0xd02110cc
#define ixUNBPM_DEBUG_BUS_CNTL                                                  0xd02110d0
#define ixUNBPM_PWRMGT_REQ_DBG_STATUS                                           0xd02110d4
#define ixUNBPM_VIDCHG_REQ_DBG_STATUS                                           0xd02110d8
#define ixUNBPM_SCRATCH_0                                                       0xd021e000
#define ixUNBPM_SCRATCH_1                                                       0xd021e004
#define ixPOWERON_CPU_0                                                         0xd0220000
#define ixPOWERREADY_CPU_0                                                      0xd0220004
#define ixPGRUNFEEDBACK_CPU_0                                                   0xd0220008
#define ixRCC3ON_CPU_0                                                          0xd022000c
#define ixRCC3EXITDONE_CPU_0                                                    0xd0220010
#define ixCORE_FUNC_LATE_SSB_XFER_0                                             0xd0220014
#define ixCORE_FUNC_LATE_SSB_XFER_CFG_0                                         0xd0220018
#define ixCORE_REDUN_SSB_XFER_0                                                 0xd022001c
#define ixCORE_REDUN_SSB_XFER_CFG_0                                             0xd0220020
#define ixCORE_APM_SSB_XFER_0                                                   0xd0220024
#define ixCORE_APM_SSB_XFER_CFG_0                                               0xd0220028
#define ixCOREPM_PWRCTRL_MISC_0                                                 0xd022002c
#define ixLDOIVRON_CPU_0                                                        0xd0220030
#define ixLDOIVREXITDONE_CPU_0                                                  0xd0220034
#define ixRCC3_TARGETPSMREF_CPU_0                                               0xd0220038
#define ixIVR_TARGETPSMREF_CPU_0                                                0xd022003c
#define ixCK_JTCOOLRESET_LATCHED_CPU_0                                          0xd0220044
#define ixCK_DISABLECORE_CPU_0                                                  0xd0220048
#define ixCOREPM_ID_0                                                           0xd022004c
#define ixCOREPM_SCRATCH_0                                                      0xd0220050
#define ixRCC3_WAKEMIN_CPU_0                                                    0xd0220054
#define ixSPMI_CONFIG0_0                                                        0xd0221000
#define ixSPMI_CONFIG1_0                                                        0xd0221004
#define ixSPMI_FSM_READ_TRIGGER_0                                               0xd0221008
#define ixSPMI_FSM_WRITE_TRIGGER_0                                              0xd022100c
#define ixSPMI_FSM_RESET_TRIGGER_0                                              0xd0221010
#define ixSPMI_FSM_BUSY_0                                                       0xd0221014
#define ixSPMI_PATH_0                                                           0xd0221018
#define ixSPMI_C6_STATE_0                                                       0xd022101c
#define ixSPMI_JTAG_OVER_0                                                      0xd0221020
#define ixSPMI_SRAM_ADDRESS_0                                                   0xd0221024
#define ixSPMI_SRAM_DATA_0                                                      0xd0221028
#define ixSPMI_RESET_0                                                          0xd022102c
#define ixSPMI_FORCE_CLOCK_GATERS_0                                             0xd0221030
#define ixSPMI_SPARE_0                                                          0xd0221034
#define ixSPMI_SPARE_EX_0                                                       0xd0221038
#define ixSPMI_SRAM_CLK_GATER_0                                                 0xd022103c
#define ixPOWERON_CPU_1                                                         0xd0230000
#define ixPOWERREADY_CPU_1                                                      0xd0230004
#define ixPGRUNFEEDBACK_CPU_1                                                   0xd0230008
#define ixRCC3ON_CPU_1                                                          0xd023000c
#define ixRCC3EXITDONE_CPU_1                                                    0xd0230010
#define ixCORE_FUNC_LATE_SSB_XFER_1                                             0xd0230014
#define ixCORE_FUNC_LATE_SSB_XFER_CFG_1                                         0xd0230018
#define ixCORE_REDUN_SSB_XFER_1                                                 0xd023001c
#define ixCORE_REDUN_SSB_XFER_CFG_1                                             0xd0230020
#define ixCORE_APM_SSB_XFER_1                                                   0xd0230024
#define ixCORE_APM_SSB_XFER_CFG_1                                               0xd0230028
#define ixCOREPM_PWRCTRL_MISC_1                                                 0xd023002c
#define ixLDOIVRON_CPU_1                                                        0xd0230030
#define ixLDOIVREXITDONE_CPU_1                                                  0xd0230034
#define ixRCC3_TARGETPSMREF_CPU_1                                               0xd0230038
#define ixIVR_TARGETPSMREF_CPU_1                                                0xd023003c
#define ixCK_JTCOOLRESET_LATCHED_CPU_1                                          0xd0230044
#define ixCK_DISABLECORE_CPU_1                                                  0xd0230048
#define ixCOREPM_ID_1                                                           0xd023004c
#define ixCOREPM_SCRATCH_1                                                      0xd0230050
#define ixRCC3_WAKEMIN_CPU_1                                                    0xd0230054
#define ixSPMI_CONFIG0_1                                                        0xd0231000
#define ixSPMI_CONFIG1_1                                                        0xd0231004
#define ixSPMI_FSM_READ_TRIGGER_1                                               0xd0231008
#define ixSPMI_FSM_WRITE_TRIGGER_1                                              0xd023100c
#define ixSPMI_FSM_RESET_TRIGGER_1                                              0xd0231010
#define ixSPMI_FSM_BUSY_1                                                       0xd0231014
#define ixSPMI_PATH_1                                                           0xd0231018
#define ixSPMI_C6_STATE_1                                                       0xd023101c
#define ixSPMI_JTAG_OVER_1                                                      0xd0231020
#define ixSPMI_SRAM_ADDRESS_1                                                   0xd0231024
#define ixSPMI_SRAM_DATA_1                                                      0xd0231028
#define ixSPMI_RESET_1                                                          0xd023102c
#define ixSPMI_FORCE_CLOCK_GATERS_1                                             0xd0231030
#define ixSPMI_SPARE_1                                                          0xd0231034
#define ixSPMI_SPARE_EX_1                                                       0xd0231038
#define ixSPMI_SRAM_CLK_GATER_1                                                 0xd023103c
#define ixGENERAL_PWRMGT                                                        0xd0200000
#define ixCNB_PWRMGT_CNTL                                                       0xd0200004
#define ixSCLK_PWRMGT_CNTL                                                      0xd0200008
#define ixTARGET_AND_CURRENT_PROFILE_INDEX                                      0xd0200014
#define ixTARGET_AND_CURRENT_PROFILE_INDEX_1                                    0xd02000f0
#define ixTARGET_AND_CURRENT_PROFILE_INDEX_2                                    0xd02000f4
#define ixCG_FREQ_TRAN_VOTING_0                                                 0xd02001a8
#define ixCG_FREQ_TRAN_VOTING_1                                                 0xd02001ac
#define ixCG_FREQ_TRAN_VOTING_2                                                 0xd02001b0
#define ixCG_FREQ_TRAN_VOTING_3                                                 0xd02001b4
#define ixCG_FREQ_TRAN_VOTING_4                                                 0xd02001b8
#define ixCG_FREQ_TRAN_VOTING_5                                                 0xd02001bc
#define ixCG_FREQ_TRAN_VOTING_6                                                 0xd02001c0
#define ixCG_FREQ_TRAN_VOTING_7                                                 0xd02001c4
#define ixCG_STATIC_SCREEN_PARAMETER                                            0xd0200044
#define ixCG_ACPI_CNTL                                                          0xd0200064
#define ixSCLK_DEEP_SLEEP_CNTL                                                  0xd0200080
#define ixSCLK_DEEP_SLEEP_CNTL2                                                 0xd0200084
#define ixSCLK_DEEP_SLEEP_CNTL3                                                 0xd020009c
#define ixSCLK_DEEP_SLEEP_MISC_CNTL                                             0xd0200088
#define ixLCLK_DEEP_SLEEP_CNTL                                                  0xd020008c
#define ixLCLK_DEEP_SLEEP_CNTL2                                                 0xd0200310
#define ixSMU_VOLTAGE_STATUS                                                    0xd0200094
#define ixCG_ULV_PARAMETER                                                      0xd020015c
#define ixPWR_DC_RESP                                                           0xd0200300
#define ixPWR_VCE_RESP                                                          0xd0200304
#define ixPWR_UVD_RESP                                                          0xd0200308
#define ixPWR_ACP_RESP                                                          0xd020030c
#define ixPWR_DC_REQ                                                            0xd020031c
#define ixSCLK_MIN_DIV                                                          0xd02003ac
#define ixPCIE_PGFSM_CONFIG                                                     0xd02002d0
#define ixPCIE_PGFSM_WRITE                                                      0xd02002d4
#define ixSERDES_BUSY                                                           0xd02002d8
#define ixPCIE_PGFSM2_CONFIG                                                    0xd02002dc
#define ixPCIE_PGFSM2_WRITE                                                     0xd02002e0
#define ixSERDES2_BUSY                                                          0xd02002e4
#define ixPCIE_PGFSM_0_READ                                                     0xd02002e8
#define ixPCIE_PGFSM_1_READ                                                     0xd02002ec
#define ixPWR_ACPI_INTERRUPT                                                    0xd0200318
#define ixVDDGFX_IDLE_PARAMETER                                                 0xd020036c
#define ixVDDGFX_IDLE_CONTROL                                                   0xd0200370
#define ixVDDGFX_IDLE_EXIT                                                      0xd0200374
#define ixREG_SCLK_DEEP_SLEEP_EXIT                                              0xd0200378
#define ixCAC_WEIGHT_LKG_DC_3                                                   0xd020803c
#define ixLCAC_MC0_CNTL                                                         0xd0208130
#define ixLCAC_MC0_OVR_SEL                                                      0xd0208134
#define ixLCAC_MC0_OVR_VAL                                                      0xd0208138
#define ixLCAC_MC1_CNTL                                                         0xd020813c
#define ixLCAC_MC1_OVR_SEL                                                      0xd0208140
#define ixLCAC_MC1_OVR_VAL                                                      0xd0208144
#define ixLCAC_MC2_CNTL                                                         0xd0208148
#define ixLCAC_MC2_OVR_SEL                                                      0xd020814c
#define ixLCAC_MC2_OVR_VAL                                                      0xd0208150
#define ixLCAC_MC3_CNTL                                                         0xd0208154
#define ixLCAC_MC3_OVR_SEL                                                      0xd0208158
#define ixLCAC_MC3_OVR_VAL                                                      0xd020815c
#define ixLCAC_CPL_CNTL                                                         0xd0208160
#define ixLCAC_CPL_OVR_SEL                                                      0xd0208164
#define ixLCAC_CPL_OVR_VAL                                                      0xd0208168
#define ixMISC_UNB_PWRMGT_CFG0                                                  0xd020c000
#define ixMISC_UNB_PWRMGT_CFG1                                                  0xd020c004
#define ixMISC_UNB_PWRMGT_DATA                                                  0xd020c00c
#define ixGNBPM_SMU_PWRMGT_DATA                                                 0xd020c010
#define ixDMA_ACTIVE_SAMPLER_CFG                                                0xd020c014
#define ixSOUTHBRIDGE_TYPE                                                      0xd020c01c
#define ixGNBPM_SMU_PWRMGT_STATUS                                               0xd020c020
#define ixALLOW_SR_INTR_CTRL                                                    0xd020c024
#define mmGC_CAC_LKG_AGGR_LOWER                                                 0x3294
#define mmGC_CAC_LKG_AGGR_UPPER                                                 0x3295
#define ixGC_CAC_WEIGHT_CU_0                                                    0x32
#define ixGC_CAC_WEIGHT_CU_1                                                    0x33
#define ixGC_CAC_WEIGHT_CU_2                                                    0x34
#define ixGC_CAC_WEIGHT_CU_3                                                    0x35
#define ixGC_CAC_ACC_CU0                                                        0xba
#define ixGC_CAC_ACC_CU1                                                        0xbb
#define ixGC_CAC_ACC_CU2                                                        0xbc
#define ixGC_CAC_ACC_CU3                                                        0xbd
#define ixGC_CAC_ACC_CU4                                                        0xbe
#define ixGC_CAC_ACC_CU5                                                        0xbf
#define ixGC_CAC_ACC_CU6                                                        0xc0
#define ixGC_CAC_ACC_CU7                                                        0xc1
#define ixGC_CAC_OVRD_CU                                                        0xe7

#endif /* SMU_8_0_D_H */
