/*	$NetBSD: i2c_calls.h,v 1.2 2025/09/21 17:54:51 thorpej Exp $	*/

/*
 * THIS FILE IS AUTOMATICALLY GENERATED.  DO NOT EDIT.
 *
 * generated from:
 *	NetBSD: i2c_calls,v 1.1 2025/09/21 17:54:16 thorpej Exp
 */

/*-
 * Copyright (c) 2021 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Jason R. Thorpe.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Device calls used by the I2C subsystem.
 */

#ifndef _I2C_CALLS_H_
#define _I2C_CALLS_H_

#include <sys/device.h>

#include <dev/i2c/i2cvar.h>

/*
 * i2c-enumerate-devices
 *
 * Enumerates the devices connected to the I2C bus, filling out
 * the i2c_attach_args and invoking the callback for each one.
 * The caller provides the storage for the i2c_attach_args.
 *
 * If the callback returns true, then enumeration continues.  If
 * the callback returns false, enumeration is stopped.
 *
 * Call returns 0 if successful, or an error code upon failure:
 *
 * ENOTSUP	The device handle implementation for the
 *		I2C bus does not support this device call.
 */
struct i2c_enumerate_devices_args {
	struct i2c_attach_args *ia;	/* IN */
	bool (*callback)(device_t, struct i2c_enumerate_devices_args *);
};

union i2c_enumerate_devices_binding {
	struct device_call_generic generic;
	struct {
		const char *name;
		struct i2c_enumerate_devices_args *args;
	} binding;
};

#define I2C_ENUMERATE_DEVICES_STR "i2c-enumerate-devices"

#define I2C_ENUMERATE_DEVICES(_args_) \
	&((const union i2c_enumerate_devices_binding){ \
		.binding.name = "i2c-enumerate-devices", \
		.binding.args = (_args_), \
	})

#endif /* _I2C_CALLS_H_ */
