/*	$NetBSD: dcn_1_0_sh_mask.h,v 1.2 2021/12/18 23:45:11 riastradh Exp $	*/

/*
 * Copyright (C) 2017  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef _dcn_1_0_SH_MASK_HEADER
#define _dcn_1_0_SH_MASK_HEADER


// addressBlock: dce_dc_hda_azcontroller_azdec
//AZCONTROLLER0_GLOBAL_CAPABILITIES
#define AZCONTROLLER0_GLOBAL_CAPABILITIES__SIXTY_FOUR_BIT_ADDRESS_SUPPORTED__SHIFT                            0x0
#define AZCONTROLLER0_GLOBAL_CAPABILITIES__NUMBER_OF_SERIAL_DATA_OUTPUT_SIGNALS__SHIFT                        0x1
#define AZCONTROLLER0_GLOBAL_CAPABILITIES__NUMBER_OF_BIDIRECTIONAL_STREAMS_SUPPORTED__SHIFT                   0x3
#define AZCONTROLLER0_GLOBAL_CAPABILITIES__NUMBER_OF_INPUT_STREAMS_SUPPORTED__SHIFT                           0x8
#define AZCONTROLLER0_GLOBAL_CAPABILITIES__NUMBER_OF_OUTPUT_STREAMS_SUPPORTED__SHIFT                          0xc
#define AZCONTROLLER0_GLOBAL_CAPABILITIES__SIXTY_FOUR_BIT_ADDRESS_SUPPORTED_MASK                              0x0001L
#define AZCONTROLLER0_GLOBAL_CAPABILITIES__NUMBER_OF_SERIAL_DATA_OUTPUT_SIGNALS_MASK                          0x0006L
#define AZCONTROLLER0_GLOBAL_CAPABILITIES__NUMBER_OF_BIDIRECTIONAL_STREAMS_SUPPORTED_MASK                     0x00F8L
#define AZCONTROLLER0_GLOBAL_CAPABILITIES__NUMBER_OF_INPUT_STREAMS_SUPPORTED_MASK                             0x0F00L
#define AZCONTROLLER0_GLOBAL_CAPABILITIES__NUMBER_OF_OUTPUT_STREAMS_SUPPORTED_MASK                            0xF000L
//AZCONTROLLER0_MINOR_VERSION
#define AZCONTROLLER0_MINOR_VERSION__MINOR_VERSION__SHIFT                                                     0x0
#define AZCONTROLLER0_MINOR_VERSION__MINOR_VERSION_MASK                                                       0xFFL
//AZCONTROLLER0_MAJOR_VERSION
#define AZCONTROLLER0_MAJOR_VERSION__MAJOR_VERSION__SHIFT                                                     0x0
#define AZCONTROLLER0_MAJOR_VERSION__MAJOR_VERSION_MASK                                                       0xFFL
//AZCONTROLLER0_OUTPUT_PAYLOAD_CAPABILITY
#define AZCONTROLLER0_OUTPUT_PAYLOAD_CAPABILITY__OUTPUT_PAYLOAD_CAPABILITY__SHIFT                             0x0
#define AZCONTROLLER0_OUTPUT_PAYLOAD_CAPABILITY__OUTPUT_PAYLOAD_CAPABILITY_MASK                               0xFFFFL
//AZCONTROLLER0_INPUT_PAYLOAD_CAPABILITY
#define AZCONTROLLER0_INPUT_PAYLOAD_CAPABILITY__INPUT_PAYLOAD_CAPABILITY__SHIFT                               0x0
#define AZCONTROLLER0_INPUT_PAYLOAD_CAPABILITY__INPUT_PAYLOAD_CAPABILITY_MASK                                 0xFFFFL
//AZCONTROLLER0_GLOBAL_CONTROL
#define AZCONTROLLER0_GLOBAL_CONTROL__CONTROLLER_RESET__SHIFT                                                 0x0
#define AZCONTROLLER0_GLOBAL_CONTROL__FLUSH_CONTROL__SHIFT                                                    0x1
#define AZCONTROLLER0_GLOBAL_CONTROL__ACCEPT_UNSOLICITED_RESPONSE_ENABLE__SHIFT                               0x8
#define AZCONTROLLER0_GLOBAL_CONTROL__CONTROLLER_RESET_MASK                                                   0x00000001L
#define AZCONTROLLER0_GLOBAL_CONTROL__FLUSH_CONTROL_MASK                                                      0x00000002L
#define AZCONTROLLER0_GLOBAL_CONTROL__ACCEPT_UNSOLICITED_RESPONSE_ENABLE_MASK                                 0x00000100L
//AZCONTROLLER0_WAKE_ENABLE
#define AZCONTROLLER0_WAKE_ENABLE__SDIN_WAKE_ENABLE_FLAG__SHIFT                                               0x0
#define AZCONTROLLER0_WAKE_ENABLE__SDIN_WAKE_ENABLE_FLAG_MASK                                                 0x0001L
//AZCONTROLLER0_STATE_CHANGE_STATUS
#define AZCONTROLLER0_STATE_CHANGE_STATUS__STATE_CHANGE_STATUS__SHIFT                                         0x0
#define AZCONTROLLER0_STATE_CHANGE_STATUS__STATE_CHANGE_STATUS_MASK                                           0x0001L
//AZCONTROLLER0_GLOBAL_STATUS
#define AZCONTROLLER0_GLOBAL_STATUS__FLUSH_STATUS__SHIFT                                                      0x1
#define AZCONTROLLER0_GLOBAL_STATUS__FLUSH_STATUS_MASK                                                        0x00000002L
//AZCONTROLLER0_OUTPUT_STREAM_PAYLOAD_CAPABILITY
#define AZCONTROLLER0_OUTPUT_STREAM_PAYLOAD_CAPABILITY__OUTSTRMPAY__SHIFT                                     0x0
#define AZCONTROLLER0_OUTPUT_STREAM_PAYLOAD_CAPABILITY__OUTSTRMPAY_MASK                                       0xFFFFL
//AZCONTROLLER0_INPUT_STREAM_PAYLOAD_CAPABILITY
#define AZCONTROLLER0_INPUT_STREAM_PAYLOAD_CAPABILITY__INSTRMPAY__SHIFT                                       0x0
#define AZCONTROLLER0_INPUT_STREAM_PAYLOAD_CAPABILITY__INSTRMPAY_MASK                                         0xFFFFL
//AZCONTROLLER0_INTERRUPT_CONTROL
#define AZCONTROLLER0_INTERRUPT_CONTROL__STREAM_0_INTERRUPT_ENABLE__SHIFT                                     0x0
#define AZCONTROLLER0_INTERRUPT_CONTROL__STREAM_1_INTERRUPT_ENABLE__SHIFT                                     0x1
#define AZCONTROLLER0_INTERRUPT_CONTROL__STREAM_2_INTERRUPT_ENABLE__SHIFT                                     0x2
#define AZCONTROLLER0_INTERRUPT_CONTROL__STREAM_3_INTERRUPT_ENABLE__SHIFT                                     0x3
#define AZCONTROLLER0_INTERRUPT_CONTROL__STREAM_4_INTERRUPT_ENABLE__SHIFT                                     0x4
#define AZCONTROLLER0_INTERRUPT_CONTROL__STREAM_5_INTERRUPT_ENABLE__SHIFT                                     0x5
#define AZCONTROLLER0_INTERRUPT_CONTROL__STREAM_6_INTERRUPT_ENABLE__SHIFT                                     0x6
#define AZCONTROLLER0_INTERRUPT_CONTROL__STREAM_7_INTERRUPT_ENABLE__SHIFT                                     0x7
#define AZCONTROLLER0_INTERRUPT_CONTROL__STREAM_8_INTERRUPT_ENABLE__SHIFT                                     0x8
#define AZCONTROLLER0_INTERRUPT_CONTROL__STREAM_9_INTERRUPT_ENABLE__SHIFT                                     0x9
#define AZCONTROLLER0_INTERRUPT_CONTROL__STREAM_10_INTERRUPT_ENABLE__SHIFT                                    0xa
#define AZCONTROLLER0_INTERRUPT_CONTROL__STREAM_11_INTERRUPT_ENABLE__SHIFT                                    0xb
#define AZCONTROLLER0_INTERRUPT_CONTROL__STREAM_12_INTERRUPT_ENABLE__SHIFT                                    0xc
#define AZCONTROLLER0_INTERRUPT_CONTROL__STREAM_13_INTERRUPT_ENABLE__SHIFT                                    0xd
#define AZCONTROLLER0_INTERRUPT_CONTROL__STREAM_14_INTERRUPT_ENABLE__SHIFT                                    0xe
#define AZCONTROLLER0_INTERRUPT_CONTROL__STREAM_15_INTERRUPT_ENABLE__SHIFT                                    0xf
#define AZCONTROLLER0_INTERRUPT_CONTROL__CONTROLLER_INTERRUPT_ENABLE__SHIFT                                   0x1e
#define AZCONTROLLER0_INTERRUPT_CONTROL__GLOBAL_INTERRUPT_ENABLE__SHIFT                                       0x1f
#define AZCONTROLLER0_INTERRUPT_CONTROL__STREAM_0_INTERRUPT_ENABLE_MASK                                       0x00000001L
#define AZCONTROLLER0_INTERRUPT_CONTROL__STREAM_1_INTERRUPT_ENABLE_MASK                                       0x00000002L
#define AZCONTROLLER0_INTERRUPT_CONTROL__STREAM_2_INTERRUPT_ENABLE_MASK                                       0x00000004L
#define AZCONTROLLER0_INTERRUPT_CONTROL__STREAM_3_INTERRUPT_ENABLE_MASK                                       0x00000008L
#define AZCONTROLLER0_INTERRUPT_CONTROL__STREAM_4_INTERRUPT_ENABLE_MASK                                       0x00000010L
#define AZCONTROLLER0_INTERRUPT_CONTROL__STREAM_5_INTERRUPT_ENABLE_MASK                                       0x00000020L
#define AZCONTROLLER0_INTERRUPT_CONTROL__STREAM_6_INTERRUPT_ENABLE_MASK                                       0x00000040L
#define AZCONTROLLER0_INTERRUPT_CONTROL__STREAM_7_INTERRUPT_ENABLE_MASK                                       0x00000080L
#define AZCONTROLLER0_INTERRUPT_CONTROL__STREAM_8_INTERRUPT_ENABLE_MASK                                       0x00000100L
#define AZCONTROLLER0_INTERRUPT_CONTROL__STREAM_9_INTERRUPT_ENABLE_MASK                                       0x00000200L
#define AZCONTROLLER0_INTERRUPT_CONTROL__STREAM_10_INTERRUPT_ENABLE_MASK                                      0x00000400L
#define AZCONTROLLER0_INTERRUPT_CONTROL__STREAM_11_INTERRUPT_ENABLE_MASK                                      0x00000800L
#define AZCONTROLLER0_INTERRUPT_CONTROL__STREAM_12_INTERRUPT_ENABLE_MASK                                      0x00001000L
#define AZCONTROLLER0_INTERRUPT_CONTROL__STREAM_13_INTERRUPT_ENABLE_MASK                                      0x00002000L
#define AZCONTROLLER0_INTERRUPT_CONTROL__STREAM_14_INTERRUPT_ENABLE_MASK                                      0x00004000L
#define AZCONTROLLER0_INTERRUPT_CONTROL__STREAM_15_INTERRUPT_ENABLE_MASK                                      0x00008000L
#define AZCONTROLLER0_INTERRUPT_CONTROL__CONTROLLER_INTERRUPT_ENABLE_MASK                                     0x40000000L
#define AZCONTROLLER0_INTERRUPT_CONTROL__GLOBAL_INTERRUPT_ENABLE_MASK                                         0x80000000L
//AZCONTROLLER0_INTERRUPT_STATUS
#define AZCONTROLLER0_INTERRUPT_STATUS__STREAM_0_INTERRUPT_STATUS__SHIFT                                      0x0
#define AZCONTROLLER0_INTERRUPT_STATUS__STREAM_1_INTERRUPT_STATUS__SHIFT                                      0x1
#define AZCONTROLLER0_INTERRUPT_STATUS__STREAM_2_INTERRUPT_STATUS__SHIFT                                      0x2
#define AZCONTROLLER0_INTERRUPT_STATUS__STREAM_3_INTERRUPT_STATUS__SHIFT                                      0x3
#define AZCONTROLLER0_INTERRUPT_STATUS__STREAM_4_INTERRUPT_STATUS__SHIFT                                      0x4
#define AZCONTROLLER0_INTERRUPT_STATUS__STREAM_5_INTERRUPT_STATUS__SHIFT                                      0x5
#define AZCONTROLLER0_INTERRUPT_STATUS__STREAM_6_INTERRUPT_STATUS__SHIFT                                      0x6
#define AZCONTROLLER0_INTERRUPT_STATUS__STREAM_7_INTERRUPT_STATUS__SHIFT                                      0x7
#define AZCONTROLLER0_INTERRUPT_STATUS__STREAM_8_INTERRUPT_STATUS__SHIFT                                      0x8
#define AZCONTROLLER0_INTERRUPT_STATUS__STREAM_9_INTERRUPT_STATUS__SHIFT                                      0x9
#define AZCONTROLLER0_INTERRUPT_STATUS__STREAM_10_INTERRUPT_STATUS__SHIFT                                     0xa
#define AZCONTROLLER0_INTERRUPT_STATUS__STREAM_11_INTERRUPT_STATUS__SHIFT                                     0xb
#define AZCONTROLLER0_INTERRUPT_STATUS__STREAM_12_INTERRUPT_STATUS__SHIFT                                     0xc
#define AZCONTROLLER0_INTERRUPT_STATUS__STREAM_13_INTERRUPT_STATUS__SHIFT                                     0xd
#define AZCONTROLLER0_INTERRUPT_STATUS__STREAM_14_INTERRUPT_STATUS__SHIFT                                     0xe
#define AZCONTROLLER0_INTERRUPT_STATUS__STREAM_15_INTERRUPT_STATUS__SHIFT                                     0xf
#define AZCONTROLLER0_INTERRUPT_STATUS__CONTROLLER_INTERRUPT_STATUS__SHIFT                                    0x1e
#define AZCONTROLLER0_INTERRUPT_STATUS__GLOBAL_INTERRUPT_STATUS__SHIFT                                        0x1f
#define AZCONTROLLER0_INTERRUPT_STATUS__STREAM_0_INTERRUPT_STATUS_MASK                                        0x00000001L
#define AZCONTROLLER0_INTERRUPT_STATUS__STREAM_1_INTERRUPT_STATUS_MASK                                        0x00000002L
#define AZCONTROLLER0_INTERRUPT_STATUS__STREAM_2_INTERRUPT_STATUS_MASK                                        0x00000004L
#define AZCONTROLLER0_INTERRUPT_STATUS__STREAM_3_INTERRUPT_STATUS_MASK                                        0x00000008L
#define AZCONTROLLER0_INTERRUPT_STATUS__STREAM_4_INTERRUPT_STATUS_MASK                                        0x00000010L
#define AZCONTROLLER0_INTERRUPT_STATUS__STREAM_5_INTERRUPT_STATUS_MASK                                        0x00000020L
#define AZCONTROLLER0_INTERRUPT_STATUS__STREAM_6_INTERRUPT_STATUS_MASK                                        0x00000040L
#define AZCONTROLLER0_INTERRUPT_STATUS__STREAM_7_INTERRUPT_STATUS_MASK                                        0x00000080L
#define AZCONTROLLER0_INTERRUPT_STATUS__STREAM_8_INTERRUPT_STATUS_MASK                                        0x00000100L
#define AZCONTROLLER0_INTERRUPT_STATUS__STREAM_9_INTERRUPT_STATUS_MASK                                        0x00000200L
#define AZCONTROLLER0_INTERRUPT_STATUS__STREAM_10_INTERRUPT_STATUS_MASK                                       0x00000400L
#define AZCONTROLLER0_INTERRUPT_STATUS__STREAM_11_INTERRUPT_STATUS_MASK                                       0x00000800L
#define AZCONTROLLER0_INTERRUPT_STATUS__STREAM_12_INTERRUPT_STATUS_MASK                                       0x00001000L
#define AZCONTROLLER0_INTERRUPT_STATUS__STREAM_13_INTERRUPT_STATUS_MASK                                       0x00002000L
#define AZCONTROLLER0_INTERRUPT_STATUS__STREAM_14_INTERRUPT_STATUS_MASK                                       0x00004000L
#define AZCONTROLLER0_INTERRUPT_STATUS__STREAM_15_INTERRUPT_STATUS_MASK                                       0x00008000L
#define AZCONTROLLER0_INTERRUPT_STATUS__CONTROLLER_INTERRUPT_STATUS_MASK                                      0x40000000L
#define AZCONTROLLER0_INTERRUPT_STATUS__GLOBAL_INTERRUPT_STATUS_MASK                                          0x80000000L
//AZCONTROLLER0_WALL_CLOCK_COUNTER
#define AZCONTROLLER0_WALL_CLOCK_COUNTER__WALL_CLOCK_COUNTER__SHIFT                                           0x0
#define AZCONTROLLER0_WALL_CLOCK_COUNTER__WALL_CLOCK_COUNTER_MASK                                             0xFFFFFFFFL
//AZCONTROLLER0_STREAM_SYNCHRONIZATION
#define AZCONTROLLER0_STREAM_SYNCHRONIZATION__STREAM_0_SYNCHRONIZATION__SHIFT                                 0x0
#define AZCONTROLLER0_STREAM_SYNCHRONIZATION__STREAM_1_SYNCHRONIZATION__SHIFT                                 0x1
#define AZCONTROLLER0_STREAM_SYNCHRONIZATION__STREAM_2_SYNCHRONIZATION__SHIFT                                 0x2
#define AZCONTROLLER0_STREAM_SYNCHRONIZATION__STREAM_3_SYNCHRONIZATION__SHIFT                                 0x3
#define AZCONTROLLER0_STREAM_SYNCHRONIZATION__STREAM_4_SYNCHRONIZATION__SHIFT                                 0x4
#define AZCONTROLLER0_STREAM_SYNCHRONIZATION__STREAM_5_SYNCHRONIZATION__SHIFT                                 0x5
#define AZCONTROLLER0_STREAM_SYNCHRONIZATION__STREAM_6_SYNCHRONIZATION__SHIFT                                 0x6
#define AZCONTROLLER0_STREAM_SYNCHRONIZATION__STREAM_7_SYNCHRONIZATION__SHIFT                                 0x7
#define AZCONTROLLER0_STREAM_SYNCHRONIZATION__STREAM_8_SYNCHRONIZATION__SHIFT                                 0x8
#define AZCONTROLLER0_STREAM_SYNCHRONIZATION__STREAM_9_SYNCHRONIZATION__SHIFT                                 0x9
#define AZCONTROLLER0_STREAM_SYNCHRONIZATION__STREAM_10_SYNCHRONIZATION__SHIFT                                0xa
#define AZCONTROLLER0_STREAM_SYNCHRONIZATION__STREAM_11_SYNCHRONIZATION__SHIFT                                0xb
#define AZCONTROLLER0_STREAM_SYNCHRONIZATION__STREAM_12_SYNCHRONIZATION__SHIFT                                0xc
#define AZCONTROLLER0_STREAM_SYNCHRONIZATION__STREAM_13_SYNCHRONIZATION__SHIFT                                0xd
#define AZCONTROLLER0_STREAM_SYNCHRONIZATION__STREAM_14_SYNCHRONIZATION__SHIFT                                0xe
#define AZCONTROLLER0_STREAM_SYNCHRONIZATION__STREAM_15_SYNCHRONIZATION__SHIFT                                0xf
#define AZCONTROLLER0_STREAM_SYNCHRONIZATION__STREAM_0_SYNCHRONIZATION_MASK                                   0x00000001L
#define AZCONTROLLER0_STREAM_SYNCHRONIZATION__STREAM_1_SYNCHRONIZATION_MASK                                   0x00000002L
#define AZCONTROLLER0_STREAM_SYNCHRONIZATION__STREAM_2_SYNCHRONIZATION_MASK                                   0x00000004L
#define AZCONTROLLER0_STREAM_SYNCHRONIZATION__STREAM_3_SYNCHRONIZATION_MASK                                   0x00000008L
#define AZCONTROLLER0_STREAM_SYNCHRONIZATION__STREAM_4_SYNCHRONIZATION_MASK                                   0x00000010L
#define AZCONTROLLER0_STREAM_SYNCHRONIZATION__STREAM_5_SYNCHRONIZATION_MASK                                   0x00000020L
#define AZCONTROLLER0_STREAM_SYNCHRONIZATION__STREAM_6_SYNCHRONIZATION_MASK                                   0x00000040L
#define AZCONTROLLER0_STREAM_SYNCHRONIZATION__STREAM_7_SYNCHRONIZATION_MASK                                   0x00000080L
#define AZCONTROLLER0_STREAM_SYNCHRONIZATION__STREAM_8_SYNCHRONIZATION_MASK                                   0x00000100L
#define AZCONTROLLER0_STREAM_SYNCHRONIZATION__STREAM_9_SYNCHRONIZATION_MASK                                   0x00000200L
#define AZCONTROLLER0_STREAM_SYNCHRONIZATION__STREAM_10_SYNCHRONIZATION_MASK                                  0x00000400L
#define AZCONTROLLER0_STREAM_SYNCHRONIZATION__STREAM_11_SYNCHRONIZATION_MASK                                  0x00000800L
#define AZCONTROLLER0_STREAM_SYNCHRONIZATION__STREAM_12_SYNCHRONIZATION_MASK                                  0x00001000L
#define AZCONTROLLER0_STREAM_SYNCHRONIZATION__STREAM_13_SYNCHRONIZATION_MASK                                  0x00002000L
#define AZCONTROLLER0_STREAM_SYNCHRONIZATION__STREAM_14_SYNCHRONIZATION_MASK                                  0x00004000L
#define AZCONTROLLER0_STREAM_SYNCHRONIZATION__STREAM_15_SYNCHRONIZATION_MASK                                  0x00008000L
//AZCONTROLLER0_CORB_LOWER_BASE_ADDRESS
#define AZCONTROLLER0_CORB_LOWER_BASE_ADDRESS__CORB_LOWER_BASE_UNIMPLEMENTED_BITS__SHIFT                      0x0
#define AZCONTROLLER0_CORB_LOWER_BASE_ADDRESS__CORB_LOWER_BASE_ADDRESS__SHIFT                                 0x7
#define AZCONTROLLER0_CORB_LOWER_BASE_ADDRESS__CORB_LOWER_BASE_UNIMPLEMENTED_BITS_MASK                        0x0000007FL
#define AZCONTROLLER0_CORB_LOWER_BASE_ADDRESS__CORB_LOWER_BASE_ADDRESS_MASK                                   0xFFFFFF80L
//AZCONTROLLER0_CORB_UPPER_BASE_ADDRESS
#define AZCONTROLLER0_CORB_UPPER_BASE_ADDRESS__CORB_UPPER_BASE_ADDRESS__SHIFT                                 0x0
#define AZCONTROLLER0_CORB_UPPER_BASE_ADDRESS__CORB_UPPER_BASE_ADDRESS_MASK                                   0xFFFFFFFFL
//AZCONTROLLER0_CORB_WRITE_POINTER
#define AZCONTROLLER0_CORB_WRITE_POINTER__CORB_WRITE_POINTER__SHIFT                                           0x0
#define AZCONTROLLER0_CORB_WRITE_POINTER__CORB_WRITE_POINTER_MASK                                             0x00FFL
//AZCONTROLLER0_CORB_READ_POINTER
#define AZCONTROLLER0_CORB_READ_POINTER__CORB_READ_POINTER__SHIFT                                             0x0
#define AZCONTROLLER0_CORB_READ_POINTER__CORB_READ_POINTER_RESET__SHIFT                                       0xf
#define AZCONTROLLER0_CORB_READ_POINTER__CORB_READ_POINTER_MASK                                               0x00FFL
#define AZCONTROLLER0_CORB_READ_POINTER__CORB_READ_POINTER_RESET_MASK                                         0x8000L
//AZCONTROLLER0_CORB_CONTROL
#define AZCONTROLLER0_CORB_CONTROL__CORB_MEMORY_ERROR_INTERRUPT_ENABLE__SHIFT                                 0x0
#define AZCONTROLLER0_CORB_CONTROL__ENABLE_CORB_DMA_ENGINE__SHIFT                                             0x1
#define AZCONTROLLER0_CORB_CONTROL__CORB_MEMORY_ERROR_INTERRUPT_ENABLE_MASK                                   0x01L
#define AZCONTROLLER0_CORB_CONTROL__ENABLE_CORB_DMA_ENGINE_MASK                                               0x02L
//AZCONTROLLER0_CORB_STATUS
#define AZCONTROLLER0_CORB_STATUS__CORB_MEMORY_ERROR_INDICATION__SHIFT                                        0x0
#define AZCONTROLLER0_CORB_STATUS__CORB_MEMORY_ERROR_INDICATION_MASK                                          0x01L
//AZCONTROLLER0_CORB_SIZE
#define AZCONTROLLER0_CORB_SIZE__CORB_SIZE__SHIFT                                                             0x0
#define AZCONTROLLER0_CORB_SIZE__CORB_SIZE_CAPABILITY__SHIFT                                                  0x4
#define AZCONTROLLER0_CORB_SIZE__CORB_SIZE_MASK                                                               0x0003L
#define AZCONTROLLER0_CORB_SIZE__CORB_SIZE_CAPABILITY_MASK                                                    0x00F0L
//AZCONTROLLER0_RIRB_LOWER_BASE_ADDRESS
#define AZCONTROLLER0_RIRB_LOWER_BASE_ADDRESS__RIRB_LOWER_BASE_UNIMPLEMENTED_BITS__SHIFT                      0x0
#define AZCONTROLLER0_RIRB_LOWER_BASE_ADDRESS__RIRB_LOWER_BASE_ADDRESS__SHIFT                                 0x7
#define AZCONTROLLER0_RIRB_LOWER_BASE_ADDRESS__RIRB_LOWER_BASE_UNIMPLEMENTED_BITS_MASK                        0x0000007FL
#define AZCONTROLLER0_RIRB_LOWER_BASE_ADDRESS__RIRB_LOWER_BASE_ADDRESS_MASK                                   0xFFFFFF80L
//AZCONTROLLER0_RIRB_UPPER_BASE_ADDRESS
#define AZCONTROLLER0_RIRB_UPPER_BASE_ADDRESS__RIRB_UPPER_BASE_ADDRESS__SHIFT                                 0x0
#define AZCONTROLLER0_RIRB_UPPER_BASE_ADDRESS__RIRB_UPPER_BASE_ADDRESS_MASK                                   0xFFFFFFFFL
//AZCONTROLLER0_RIRB_WRITE_POINTER
#define AZCONTROLLER0_RIRB_WRITE_POINTER__RIRB_WRITE_POINTER__SHIFT                                           0x0
#define AZCONTROLLER0_RIRB_WRITE_POINTER__RIRB_WRITE_POINTER_RESET__SHIFT                                     0xf
#define AZCONTROLLER0_RIRB_WRITE_POINTER__RIRB_WRITE_POINTER_MASK                                             0x00FFL
#define AZCONTROLLER0_RIRB_WRITE_POINTER__RIRB_WRITE_POINTER_RESET_MASK                                       0x8000L
//AZCONTROLLER0_RESPONSE_INTERRUPT_COUNT
#define AZCONTROLLER0_RESPONSE_INTERRUPT_COUNT__N_RESPONSE_INTERRUPT_COUNT__SHIFT                             0x0
#define AZCONTROLLER0_RESPONSE_INTERRUPT_COUNT__N_RESPONSE_INTERRUPT_COUNT_MASK                               0x00FFL
//AZCONTROLLER0_RIRB_CONTROL
#define AZCONTROLLER0_RIRB_CONTROL__RESPONSE_INTERRUPT_CONTROL__SHIFT                                         0x0
#define AZCONTROLLER0_RIRB_CONTROL__RIRB_DMA_ENABLE__SHIFT                                                    0x1
#define AZCONTROLLER0_RIRB_CONTROL__RESPONSE_OVERRUN_INTERRUPT_CONTROL__SHIFT                                 0x2
#define AZCONTROLLER0_RIRB_CONTROL__RESPONSE_INTERRUPT_CONTROL_MASK                                           0x01L
#define AZCONTROLLER0_RIRB_CONTROL__RIRB_DMA_ENABLE_MASK                                                      0x02L
#define AZCONTROLLER0_RIRB_CONTROL__RESPONSE_OVERRUN_INTERRUPT_CONTROL_MASK                                   0x04L
//AZCONTROLLER0_RIRB_STATUS
#define AZCONTROLLER0_RIRB_STATUS__RESPONSE_INTERRUPT__SHIFT                                                  0x0
#define AZCONTROLLER0_RIRB_STATUS__RESPONSE_OVERRUN_INTERRUPT_STATUS__SHIFT                                   0x2
#define AZCONTROLLER0_RIRB_STATUS__RESPONSE_INTERRUPT_MASK                                                    0x01L
#define AZCONTROLLER0_RIRB_STATUS__RESPONSE_OVERRUN_INTERRUPT_STATUS_MASK                                     0x04L
//AZCONTROLLER0_RIRB_SIZE
#define AZCONTROLLER0_RIRB_SIZE__RIRB_SIZE__SHIFT                                                             0x0
#define AZCONTROLLER0_RIRB_SIZE__RIRB_SIZE_CAPABILITY__SHIFT                                                  0x4
#define AZCONTROLLER0_RIRB_SIZE__RIRB_SIZE_MASK                                                               0x0003L
#define AZCONTROLLER0_RIRB_SIZE__RIRB_SIZE_CAPABILITY_MASK                                                    0x00F0L
//AZCONTROLLER0_IMMEDIATE_COMMAND_OUTPUT_INTERFACE
#define AZCONTROLLER0_IMMEDIATE_COMMAND_OUTPUT_INTERFACE__IMMEDIATE_COMMAND_WRITE_VERB_AND_PAYLOAD__SHIFT     0x0
#define AZCONTROLLER0_IMMEDIATE_COMMAND_OUTPUT_INTERFACE__IMMEDIATE_COMMAND_WRITE_CODEC_ADDRESS__SHIFT        0x1c
#define AZCONTROLLER0_IMMEDIATE_COMMAND_OUTPUT_INTERFACE__IMMEDIATE_COMMAND_WRITE_VERB_AND_PAYLOAD_MASK       0x0FFFFFFFL
#define AZCONTROLLER0_IMMEDIATE_COMMAND_OUTPUT_INTERFACE__IMMEDIATE_COMMAND_WRITE_CODEC_ADDRESS_MASK          0xF0000000L
//AZCONTROLLER0_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_DATA
#define AZCONTROLLER0_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_DATA__IMMEDIATE_COMMAND_WRITE__SHIFT                 0x0
#define AZCONTROLLER0_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_DATA__IMMEDIATE_COMMAND_WRITE_MASK                   0xFFFFFFFFL
//AZCONTROLLER0_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_INDEX
#define AZCONTROLLER0_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_INDEX__IMMEDIATE_COMMAND_WRITE__SHIFT                0x0
#define AZCONTROLLER0_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_INDEX__IMMEDIATE_COMMAND_WRITE_MASK                  0x0000FFFFL
//AZCONTROLLER0_IMMEDIATE_RESPONSE_INPUT_INTERFACE
#define AZCONTROLLER0_IMMEDIATE_RESPONSE_INPUT_INTERFACE__IMMEDIATE_RESPONSE_READ__SHIFT                      0x0
#define AZCONTROLLER0_IMMEDIATE_RESPONSE_INPUT_INTERFACE__IMMEDIATE_RESPONSE_READ_MASK                        0xFFFFFFFFL
//AZCONTROLLER0_IMMEDIATE_COMMAND_STATUS
#define AZCONTROLLER0_IMMEDIATE_COMMAND_STATUS__IMMEDIATE_COMMAND_BUSY__SHIFT                                 0x0
#define AZCONTROLLER0_IMMEDIATE_COMMAND_STATUS__IMMEDIATE_RESULT_VALID__SHIFT                                 0x1
#define AZCONTROLLER0_IMMEDIATE_COMMAND_STATUS__IMMEDIATE_COMMAND_BUSY_MASK                                   0x00000001L
#define AZCONTROLLER0_IMMEDIATE_COMMAND_STATUS__IMMEDIATE_RESULT_VALID_MASK                                   0x00000002L
//AZCONTROLLER0_DMA_POSITION_LOWER_BASE_ADDRESS
#define AZCONTROLLER0_DMA_POSITION_LOWER_BASE_ADDRESS__DMA_POSITION_BUFFER_ENABLE__SHIFT                      0x0
#define AZCONTROLLER0_DMA_POSITION_LOWER_BASE_ADDRESS__DMA_POSITION_LOWER_BASE_UNIMPLEMENTED_BITS__SHIFT      0x1
#define AZCONTROLLER0_DMA_POSITION_LOWER_BASE_ADDRESS__DMA_POSITION_LOWER_BASE_ADDRESS__SHIFT                 0x7
#define AZCONTROLLER0_DMA_POSITION_LOWER_BASE_ADDRESS__DMA_POSITION_BUFFER_ENABLE_MASK                        0x00000001L
#define AZCONTROLLER0_DMA_POSITION_LOWER_BASE_ADDRESS__DMA_POSITION_LOWER_BASE_UNIMPLEMENTED_BITS_MASK        0x0000007EL
#define AZCONTROLLER0_DMA_POSITION_LOWER_BASE_ADDRESS__DMA_POSITION_LOWER_BASE_ADDRESS_MASK                   0xFFFFFF80L
//AZCONTROLLER0_DMA_POSITION_UPPER_BASE_ADDRESS
#define AZCONTROLLER0_DMA_POSITION_UPPER_BASE_ADDRESS__DMA_POSITION_UPPER_BASE_ADDRESS__SHIFT                 0x0
#define AZCONTROLLER0_DMA_POSITION_UPPER_BASE_ADDRESS__DMA_POSITION_UPPER_BASE_ADDRESS_MASK                   0xFFFFFFFFL
//AZCONTROLLER0_WALL_CLOCK_COUNTER_ALIAS
#define AZCONTROLLER0_WALL_CLOCK_COUNTER_ALIAS__WALL_CLOCK_COUNTER_ALIAS__SHIFT                               0x0
#define AZCONTROLLER0_WALL_CLOCK_COUNTER_ALIAS__WALL_CLOCK_COUNTER_ALIAS_MASK                                 0xFFFFFFFFL


// addressBlock: dce_dc_hda_azendpoint_azdec
//AZENDPOINT0_AZENDPOINT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_DATA
#define AZENDPOINT0_AZENDPOINT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_DATA__IMMEDIATE_COMMAND_WRITE__SHIFT        0x0
#define AZENDPOINT0_AZENDPOINT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_DATA__IMMEDIATE_COMMAND_WRITE_MASK          0xFFFFFFFFL
//AZENDPOINT0_AZENDPOINT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_INDEX
#define AZENDPOINT0_AZENDPOINT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_INDEX__IMMEDIATE_COMMAND_WRITE__SHIFT       0x0
#define AZENDPOINT0_AZENDPOINT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_INDEX__IMMEDIATE_COMMAND_WRITE_MASK         0x0001FFFFL


// addressBlock: dce_dc_hda_azinputendpoint_azdec
//AZINPUTENDPOINT0_AZENDPOINT_IMMEDIATE_COMMAND_INPUT_INTERFACE_DATA
#define AZINPUTENDPOINT0_AZENDPOINT_IMMEDIATE_COMMAND_INPUT_INTERFACE_DATA__IMMEDIATE_COMMAND_WRITE__SHIFT    0x0
#define AZINPUTENDPOINT0_AZENDPOINT_IMMEDIATE_COMMAND_INPUT_INTERFACE_DATA__IMMEDIATE_COMMAND_WRITE_MASK      0xFFFFFFFFL
//AZINPUTENDPOINT0_AZENDPOINT_IMMEDIATE_COMMAND_INPUT_INTERFACE_INDEX
#define AZINPUTENDPOINT0_AZENDPOINT_IMMEDIATE_COMMAND_INPUT_INTERFACE_INDEX__IMMEDIATE_COMMAND_WRITE__SHIFT   0x0
#define AZINPUTENDPOINT0_AZENDPOINT_IMMEDIATE_COMMAND_INPUT_INTERFACE_INDEX__IMMEDIATE_COMMAND_WRITE_MASK     0x0001FFFFL


// addressBlock: dce_dc_hda_azroot_azdec
//AZROOT0_AZROOT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_DATA
#define AZROOT0_AZROOT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_DATA__IMMEDIATE_COMMAND_WRITE__SHIFT                0x0
#define AZROOT0_AZROOT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_DATA__IMMEDIATE_COMMAND_WRITE_MASK                  0xFFFFFFFFL
//AZROOT0_AZROOT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_INDEX
#define AZROOT0_AZROOT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_INDEX__IMMEDIATE_COMMAND_WRITE__SHIFT               0x0
#define AZROOT0_AZROOT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_INDEX__IMMEDIATE_COMMAND_WRITE_MASK                 0x0001FFFFL


// addressBlock: dce_dc_hda_azstream0_azdec
//AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RESET__SHIFT                          0x0
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RUN__SHIFT                            0x1
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__INTERRUPT_ON_COMPLETION_ENABLE__SHIFT        0x2
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_INTERRUPT_ENABLE__SHIFT           0x3
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_INTERRUPT_ENABLE__SHIFT     0x4
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STRIPE_CONTROL__SHIFT                        0x10
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__TRAFFIC_PRIORITY__SHIFT                      0x12
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_NUMBER__SHIFT                         0x14
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__BUFFER_COMPLETION_INTERRUPT_STATUS__SHIFT    0x1a
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR__SHIFT                            0x1b
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR__SHIFT                      0x1c
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_READY__SHIFT                            0x1d
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RESET_MASK                            0x00000001L
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RUN_MASK                              0x00000002L
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__INTERRUPT_ON_COMPLETION_ENABLE_MASK          0x00000004L
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_INTERRUPT_ENABLE_MASK             0x00000008L
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_INTERRUPT_ENABLE_MASK       0x00000010L
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STRIPE_CONTROL_MASK                          0x00030000L
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__TRAFFIC_PRIORITY_MASK                        0x00040000L
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_NUMBER_MASK                           0x00F00000L
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__BUFFER_COMPLETION_INTERRUPT_STATUS_MASK      0x04000000L
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_MASK                              0x08000000L
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_MASK                        0x10000000L
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_READY_MASK                              0x20000000L
//AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER__LINK_POSITION_IN_BUFFER__SHIFT  0x0
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER__LINK_POSITION_IN_BUFFER_MASK    0xFFFFFFFFL
//AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH__CYCLIC_BUFFER_LENGTH__SHIFT                0x0
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH__CYCLIC_BUFFER_LENGTH_MASK                  0xFFFFFFFFL
//AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX__LAST_VALID_INDEX__SHIFT                        0x0
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX__LAST_VALID_INDEX_MASK                          0x000000FFL
//AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE__FIFO_SIZE__SHIFT                                      0x0
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE__FIFO_SIZE_MASK                                        0xFFFFL
//AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__NUMBER_OF_CHANNELS__SHIFT                                0x0
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__BITS_PER_SAMPLE__SHIFT                                   0x4
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_DIVISOR__SHIFT                               0x8
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_MULTIPLE__SHIFT                              0xb
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_RATE__SHIFT                                  0xe
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__NUMBER_OF_CHANNELS_MASK                                  0x000FL
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__BITS_PER_SAMPLE_MASK                                     0x0070L
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_DIVISOR_MASK                                 0x0700L
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_MULTIPLE_MASK                                0x3800L
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_RATE_MASK                                    0x4000L
//AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_UNIMPLEMENTED_BITS__SHIFT  0x0
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS__SHIFT  0x7
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_UNIMPLEMENTED_BITS_MASK  0x0000007FL
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_MASK  0xFFFFFF80L
//AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_UPPER_BASE_ADDRESS__SHIFT  0x0
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_UPPER_BASE_ADDRESS_MASK  0xFFFFFFFFL
//AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS__LINK_POSITION_IN_BUFFER_ALIAS__SHIFT  0x0
#define AZSTREAM0_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS__LINK_POSITION_IN_BUFFER_ALIAS_MASK  0xFFFFFFFFL


// addressBlock: dce_dc_hda_azstream1_azdec
//AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RESET__SHIFT                          0x0
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RUN__SHIFT                            0x1
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__INTERRUPT_ON_COMPLETION_ENABLE__SHIFT        0x2
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_INTERRUPT_ENABLE__SHIFT           0x3
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_INTERRUPT_ENABLE__SHIFT     0x4
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STRIPE_CONTROL__SHIFT                        0x10
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__TRAFFIC_PRIORITY__SHIFT                      0x12
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_NUMBER__SHIFT                         0x14
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__BUFFER_COMPLETION_INTERRUPT_STATUS__SHIFT    0x1a
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR__SHIFT                            0x1b
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR__SHIFT                      0x1c
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_READY__SHIFT                            0x1d
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RESET_MASK                            0x00000001L
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RUN_MASK                              0x00000002L
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__INTERRUPT_ON_COMPLETION_ENABLE_MASK          0x00000004L
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_INTERRUPT_ENABLE_MASK             0x00000008L
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_INTERRUPT_ENABLE_MASK       0x00000010L
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STRIPE_CONTROL_MASK                          0x00030000L
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__TRAFFIC_PRIORITY_MASK                        0x00040000L
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_NUMBER_MASK                           0x00F00000L
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__BUFFER_COMPLETION_INTERRUPT_STATUS_MASK      0x04000000L
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_MASK                              0x08000000L
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_MASK                        0x10000000L
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_READY_MASK                              0x20000000L
//AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER__LINK_POSITION_IN_BUFFER__SHIFT  0x0
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER__LINK_POSITION_IN_BUFFER_MASK    0xFFFFFFFFL
//AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH__CYCLIC_BUFFER_LENGTH__SHIFT                0x0
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH__CYCLIC_BUFFER_LENGTH_MASK                  0xFFFFFFFFL
//AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX__LAST_VALID_INDEX__SHIFT                        0x0
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX__LAST_VALID_INDEX_MASK                          0x000000FFL
//AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE__FIFO_SIZE__SHIFT                                      0x0
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE__FIFO_SIZE_MASK                                        0xFFFFL
//AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__NUMBER_OF_CHANNELS__SHIFT                                0x0
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__BITS_PER_SAMPLE__SHIFT                                   0x4
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_DIVISOR__SHIFT                               0x8
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_MULTIPLE__SHIFT                              0xb
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_RATE__SHIFT                                  0xe
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__NUMBER_OF_CHANNELS_MASK                                  0x000FL
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__BITS_PER_SAMPLE_MASK                                     0x0070L
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_DIVISOR_MASK                                 0x0700L
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_MULTIPLE_MASK                                0x3800L
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_RATE_MASK                                    0x4000L
//AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_UNIMPLEMENTED_BITS__SHIFT  0x0
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS__SHIFT  0x7
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_UNIMPLEMENTED_BITS_MASK  0x0000007FL
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_MASK  0xFFFFFF80L
//AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_UPPER_BASE_ADDRESS__SHIFT  0x0
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_UPPER_BASE_ADDRESS_MASK  0xFFFFFFFFL
//AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS__LINK_POSITION_IN_BUFFER_ALIAS__SHIFT  0x0
#define AZSTREAM1_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS__LINK_POSITION_IN_BUFFER_ALIAS_MASK  0xFFFFFFFFL


// addressBlock: dce_dc_hda_azstream2_azdec
//AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RESET__SHIFT                          0x0
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RUN__SHIFT                            0x1
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__INTERRUPT_ON_COMPLETION_ENABLE__SHIFT        0x2
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_INTERRUPT_ENABLE__SHIFT           0x3
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_INTERRUPT_ENABLE__SHIFT     0x4
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STRIPE_CONTROL__SHIFT                        0x10
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__TRAFFIC_PRIORITY__SHIFT                      0x12
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_NUMBER__SHIFT                         0x14
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__BUFFER_COMPLETION_INTERRUPT_STATUS__SHIFT    0x1a
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR__SHIFT                            0x1b
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR__SHIFT                      0x1c
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_READY__SHIFT                            0x1d
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RESET_MASK                            0x00000001L
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RUN_MASK                              0x00000002L
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__INTERRUPT_ON_COMPLETION_ENABLE_MASK          0x00000004L
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_INTERRUPT_ENABLE_MASK             0x00000008L
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_INTERRUPT_ENABLE_MASK       0x00000010L
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STRIPE_CONTROL_MASK                          0x00030000L
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__TRAFFIC_PRIORITY_MASK                        0x00040000L
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_NUMBER_MASK                           0x00F00000L
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__BUFFER_COMPLETION_INTERRUPT_STATUS_MASK      0x04000000L
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_MASK                              0x08000000L
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_MASK                        0x10000000L
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_READY_MASK                              0x20000000L
//AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER__LINK_POSITION_IN_BUFFER__SHIFT  0x0
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER__LINK_POSITION_IN_BUFFER_MASK    0xFFFFFFFFL
//AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH__CYCLIC_BUFFER_LENGTH__SHIFT                0x0
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH__CYCLIC_BUFFER_LENGTH_MASK                  0xFFFFFFFFL
//AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX__LAST_VALID_INDEX__SHIFT                        0x0
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX__LAST_VALID_INDEX_MASK                          0x000000FFL
//AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE__FIFO_SIZE__SHIFT                                      0x0
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE__FIFO_SIZE_MASK                                        0xFFFFL
//AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__NUMBER_OF_CHANNELS__SHIFT                                0x0
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__BITS_PER_SAMPLE__SHIFT                                   0x4
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_DIVISOR__SHIFT                               0x8
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_MULTIPLE__SHIFT                              0xb
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_RATE__SHIFT                                  0xe
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__NUMBER_OF_CHANNELS_MASK                                  0x000FL
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__BITS_PER_SAMPLE_MASK                                     0x0070L
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_DIVISOR_MASK                                 0x0700L
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_MULTIPLE_MASK                                0x3800L
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_RATE_MASK                                    0x4000L
//AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_UNIMPLEMENTED_BITS__SHIFT  0x0
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS__SHIFT  0x7
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_UNIMPLEMENTED_BITS_MASK  0x0000007FL
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_MASK  0xFFFFFF80L
//AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_UPPER_BASE_ADDRESS__SHIFT  0x0
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_UPPER_BASE_ADDRESS_MASK  0xFFFFFFFFL
//AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS__LINK_POSITION_IN_BUFFER_ALIAS__SHIFT  0x0
#define AZSTREAM2_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS__LINK_POSITION_IN_BUFFER_ALIAS_MASK  0xFFFFFFFFL


// addressBlock: dce_dc_hda_azstream3_azdec
//AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RESET__SHIFT                          0x0
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RUN__SHIFT                            0x1
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__INTERRUPT_ON_COMPLETION_ENABLE__SHIFT        0x2
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_INTERRUPT_ENABLE__SHIFT           0x3
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_INTERRUPT_ENABLE__SHIFT     0x4
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STRIPE_CONTROL__SHIFT                        0x10
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__TRAFFIC_PRIORITY__SHIFT                      0x12
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_NUMBER__SHIFT                         0x14
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__BUFFER_COMPLETION_INTERRUPT_STATUS__SHIFT    0x1a
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR__SHIFT                            0x1b
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR__SHIFT                      0x1c
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_READY__SHIFT                            0x1d
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RESET_MASK                            0x00000001L
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RUN_MASK                              0x00000002L
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__INTERRUPT_ON_COMPLETION_ENABLE_MASK          0x00000004L
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_INTERRUPT_ENABLE_MASK             0x00000008L
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_INTERRUPT_ENABLE_MASK       0x00000010L
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STRIPE_CONTROL_MASK                          0x00030000L
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__TRAFFIC_PRIORITY_MASK                        0x00040000L
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_NUMBER_MASK                           0x00F00000L
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__BUFFER_COMPLETION_INTERRUPT_STATUS_MASK      0x04000000L
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_MASK                              0x08000000L
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_MASK                        0x10000000L
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_READY_MASK                              0x20000000L
//AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER__LINK_POSITION_IN_BUFFER__SHIFT  0x0
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER__LINK_POSITION_IN_BUFFER_MASK    0xFFFFFFFFL
//AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH__CYCLIC_BUFFER_LENGTH__SHIFT                0x0
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH__CYCLIC_BUFFER_LENGTH_MASK                  0xFFFFFFFFL
//AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX__LAST_VALID_INDEX__SHIFT                        0x0
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX__LAST_VALID_INDEX_MASK                          0x000000FFL
//AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE__FIFO_SIZE__SHIFT                                      0x0
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE__FIFO_SIZE_MASK                                        0xFFFFL
//AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__NUMBER_OF_CHANNELS__SHIFT                                0x0
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__BITS_PER_SAMPLE__SHIFT                                   0x4
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_DIVISOR__SHIFT                               0x8
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_MULTIPLE__SHIFT                              0xb
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_RATE__SHIFT                                  0xe
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__NUMBER_OF_CHANNELS_MASK                                  0x000FL
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__BITS_PER_SAMPLE_MASK                                     0x0070L
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_DIVISOR_MASK                                 0x0700L
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_MULTIPLE_MASK                                0x3800L
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_RATE_MASK                                    0x4000L
//AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_UNIMPLEMENTED_BITS__SHIFT  0x0
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS__SHIFT  0x7
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_UNIMPLEMENTED_BITS_MASK  0x0000007FL
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_MASK  0xFFFFFF80L
//AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_UPPER_BASE_ADDRESS__SHIFT  0x0
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_UPPER_BASE_ADDRESS_MASK  0xFFFFFFFFL
//AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS__LINK_POSITION_IN_BUFFER_ALIAS__SHIFT  0x0
#define AZSTREAM3_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS__LINK_POSITION_IN_BUFFER_ALIAS_MASK  0xFFFFFFFFL


// addressBlock: dce_dc_hda_azstream4_azdec
//AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RESET__SHIFT                          0x0
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RUN__SHIFT                            0x1
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__INTERRUPT_ON_COMPLETION_ENABLE__SHIFT        0x2
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_INTERRUPT_ENABLE__SHIFT           0x3
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_INTERRUPT_ENABLE__SHIFT     0x4
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STRIPE_CONTROL__SHIFT                        0x10
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__TRAFFIC_PRIORITY__SHIFT                      0x12
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_NUMBER__SHIFT                         0x14
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__BUFFER_COMPLETION_INTERRUPT_STATUS__SHIFT    0x1a
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR__SHIFT                            0x1b
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR__SHIFT                      0x1c
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_READY__SHIFT                            0x1d
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RESET_MASK                            0x00000001L
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RUN_MASK                              0x00000002L
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__INTERRUPT_ON_COMPLETION_ENABLE_MASK          0x00000004L
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_INTERRUPT_ENABLE_MASK             0x00000008L
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_INTERRUPT_ENABLE_MASK       0x00000010L
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STRIPE_CONTROL_MASK                          0x00030000L
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__TRAFFIC_PRIORITY_MASK                        0x00040000L
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_NUMBER_MASK                           0x00F00000L
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__BUFFER_COMPLETION_INTERRUPT_STATUS_MASK      0x04000000L
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_MASK                              0x08000000L
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_MASK                        0x10000000L
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_READY_MASK                              0x20000000L
//AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER__LINK_POSITION_IN_BUFFER__SHIFT  0x0
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER__LINK_POSITION_IN_BUFFER_MASK    0xFFFFFFFFL
//AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH__CYCLIC_BUFFER_LENGTH__SHIFT                0x0
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH__CYCLIC_BUFFER_LENGTH_MASK                  0xFFFFFFFFL
//AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX__LAST_VALID_INDEX__SHIFT                        0x0
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX__LAST_VALID_INDEX_MASK                          0x000000FFL
//AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE__FIFO_SIZE__SHIFT                                      0x0
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE__FIFO_SIZE_MASK                                        0xFFFFL
//AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__NUMBER_OF_CHANNELS__SHIFT                                0x0
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__BITS_PER_SAMPLE__SHIFT                                   0x4
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_DIVISOR__SHIFT                               0x8
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_MULTIPLE__SHIFT                              0xb
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_RATE__SHIFT                                  0xe
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__NUMBER_OF_CHANNELS_MASK                                  0x000FL
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__BITS_PER_SAMPLE_MASK                                     0x0070L
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_DIVISOR_MASK                                 0x0700L
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_MULTIPLE_MASK                                0x3800L
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_RATE_MASK                                    0x4000L
//AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_UNIMPLEMENTED_BITS__SHIFT  0x0
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS__SHIFT  0x7
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_UNIMPLEMENTED_BITS_MASK  0x0000007FL
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_MASK  0xFFFFFF80L
//AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_UPPER_BASE_ADDRESS__SHIFT  0x0
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_UPPER_BASE_ADDRESS_MASK  0xFFFFFFFFL
//AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS__LINK_POSITION_IN_BUFFER_ALIAS__SHIFT  0x0
#define AZSTREAM4_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS__LINK_POSITION_IN_BUFFER_ALIAS_MASK  0xFFFFFFFFL


// addressBlock: dce_dc_hda_azstream5_azdec
//AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RESET__SHIFT                          0x0
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RUN__SHIFT                            0x1
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__INTERRUPT_ON_COMPLETION_ENABLE__SHIFT        0x2
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_INTERRUPT_ENABLE__SHIFT           0x3
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_INTERRUPT_ENABLE__SHIFT     0x4
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STRIPE_CONTROL__SHIFT                        0x10
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__TRAFFIC_PRIORITY__SHIFT                      0x12
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_NUMBER__SHIFT                         0x14
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__BUFFER_COMPLETION_INTERRUPT_STATUS__SHIFT    0x1a
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR__SHIFT                            0x1b
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR__SHIFT                      0x1c
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_READY__SHIFT                            0x1d
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RESET_MASK                            0x00000001L
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RUN_MASK                              0x00000002L
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__INTERRUPT_ON_COMPLETION_ENABLE_MASK          0x00000004L
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_INTERRUPT_ENABLE_MASK             0x00000008L
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_INTERRUPT_ENABLE_MASK       0x00000010L
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STRIPE_CONTROL_MASK                          0x00030000L
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__TRAFFIC_PRIORITY_MASK                        0x00040000L
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_NUMBER_MASK                           0x00F00000L
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__BUFFER_COMPLETION_INTERRUPT_STATUS_MASK      0x04000000L
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_MASK                              0x08000000L
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_MASK                        0x10000000L
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_READY_MASK                              0x20000000L
//AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER__LINK_POSITION_IN_BUFFER__SHIFT  0x0
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER__LINK_POSITION_IN_BUFFER_MASK    0xFFFFFFFFL
//AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH__CYCLIC_BUFFER_LENGTH__SHIFT                0x0
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH__CYCLIC_BUFFER_LENGTH_MASK                  0xFFFFFFFFL
//AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX__LAST_VALID_INDEX__SHIFT                        0x0
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX__LAST_VALID_INDEX_MASK                          0x000000FFL
//AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE__FIFO_SIZE__SHIFT                                      0x0
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE__FIFO_SIZE_MASK                                        0xFFFFL
//AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__NUMBER_OF_CHANNELS__SHIFT                                0x0
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__BITS_PER_SAMPLE__SHIFT                                   0x4
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_DIVISOR__SHIFT                               0x8
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_MULTIPLE__SHIFT                              0xb
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_RATE__SHIFT                                  0xe
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__NUMBER_OF_CHANNELS_MASK                                  0x000FL
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__BITS_PER_SAMPLE_MASK                                     0x0070L
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_DIVISOR_MASK                                 0x0700L
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_MULTIPLE_MASK                                0x3800L
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_RATE_MASK                                    0x4000L
//AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_UNIMPLEMENTED_BITS__SHIFT  0x0
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS__SHIFT  0x7
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_UNIMPLEMENTED_BITS_MASK  0x0000007FL
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_MASK  0xFFFFFF80L
//AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_UPPER_BASE_ADDRESS__SHIFT  0x0
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_UPPER_BASE_ADDRESS_MASK  0xFFFFFFFFL
//AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS__LINK_POSITION_IN_BUFFER_ALIAS__SHIFT  0x0
#define AZSTREAM5_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS__LINK_POSITION_IN_BUFFER_ALIAS_MASK  0xFFFFFFFFL


// addressBlock: dce_dc_hda_azstream6_azdec
//AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RESET__SHIFT                          0x0
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RUN__SHIFT                            0x1
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__INTERRUPT_ON_COMPLETION_ENABLE__SHIFT        0x2
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_INTERRUPT_ENABLE__SHIFT           0x3
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_INTERRUPT_ENABLE__SHIFT     0x4
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STRIPE_CONTROL__SHIFT                        0x10
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__TRAFFIC_PRIORITY__SHIFT                      0x12
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_NUMBER__SHIFT                         0x14
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__BUFFER_COMPLETION_INTERRUPT_STATUS__SHIFT    0x1a
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR__SHIFT                            0x1b
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR__SHIFT                      0x1c
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_READY__SHIFT                            0x1d
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RESET_MASK                            0x00000001L
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RUN_MASK                              0x00000002L
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__INTERRUPT_ON_COMPLETION_ENABLE_MASK          0x00000004L
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_INTERRUPT_ENABLE_MASK             0x00000008L
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_INTERRUPT_ENABLE_MASK       0x00000010L
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STRIPE_CONTROL_MASK                          0x00030000L
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__TRAFFIC_PRIORITY_MASK                        0x00040000L
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_NUMBER_MASK                           0x00F00000L
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__BUFFER_COMPLETION_INTERRUPT_STATUS_MASK      0x04000000L
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_MASK                              0x08000000L
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_MASK                        0x10000000L
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_READY_MASK                              0x20000000L
//AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER__LINK_POSITION_IN_BUFFER__SHIFT  0x0
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER__LINK_POSITION_IN_BUFFER_MASK    0xFFFFFFFFL
//AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH__CYCLIC_BUFFER_LENGTH__SHIFT                0x0
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH__CYCLIC_BUFFER_LENGTH_MASK                  0xFFFFFFFFL
//AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX__LAST_VALID_INDEX__SHIFT                        0x0
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX__LAST_VALID_INDEX_MASK                          0x000000FFL
//AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE__FIFO_SIZE__SHIFT                                      0x0
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE__FIFO_SIZE_MASK                                        0xFFFFL
//AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__NUMBER_OF_CHANNELS__SHIFT                                0x0
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__BITS_PER_SAMPLE__SHIFT                                   0x4
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_DIVISOR__SHIFT                               0x8
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_MULTIPLE__SHIFT                              0xb
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_RATE__SHIFT                                  0xe
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__NUMBER_OF_CHANNELS_MASK                                  0x000FL
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__BITS_PER_SAMPLE_MASK                                     0x0070L
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_DIVISOR_MASK                                 0x0700L
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_MULTIPLE_MASK                                0x3800L
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_RATE_MASK                                    0x4000L
//AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_UNIMPLEMENTED_BITS__SHIFT  0x0
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS__SHIFT  0x7
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_UNIMPLEMENTED_BITS_MASK  0x0000007FL
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_MASK  0xFFFFFF80L
//AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_UPPER_BASE_ADDRESS__SHIFT  0x0
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_UPPER_BASE_ADDRESS_MASK  0xFFFFFFFFL
//AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS__LINK_POSITION_IN_BUFFER_ALIAS__SHIFT  0x0
#define AZSTREAM6_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS__LINK_POSITION_IN_BUFFER_ALIAS_MASK  0xFFFFFFFFL


// addressBlock: dce_dc_hda_azstream7_azdec
//AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RESET__SHIFT                          0x0
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RUN__SHIFT                            0x1
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__INTERRUPT_ON_COMPLETION_ENABLE__SHIFT        0x2
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_INTERRUPT_ENABLE__SHIFT           0x3
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_INTERRUPT_ENABLE__SHIFT     0x4
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STRIPE_CONTROL__SHIFT                        0x10
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__TRAFFIC_PRIORITY__SHIFT                      0x12
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_NUMBER__SHIFT                         0x14
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__BUFFER_COMPLETION_INTERRUPT_STATUS__SHIFT    0x1a
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR__SHIFT                            0x1b
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR__SHIFT                      0x1c
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_READY__SHIFT                            0x1d
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RESET_MASK                            0x00000001L
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RUN_MASK                              0x00000002L
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__INTERRUPT_ON_COMPLETION_ENABLE_MASK          0x00000004L
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_INTERRUPT_ENABLE_MASK             0x00000008L
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_INTERRUPT_ENABLE_MASK       0x00000010L
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STRIPE_CONTROL_MASK                          0x00030000L
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__TRAFFIC_PRIORITY_MASK                        0x00040000L
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_NUMBER_MASK                           0x00F00000L
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__BUFFER_COMPLETION_INTERRUPT_STATUS_MASK      0x04000000L
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_MASK                              0x08000000L
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_MASK                        0x10000000L
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_READY_MASK                              0x20000000L
//AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER__LINK_POSITION_IN_BUFFER__SHIFT  0x0
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER__LINK_POSITION_IN_BUFFER_MASK    0xFFFFFFFFL
//AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH__CYCLIC_BUFFER_LENGTH__SHIFT                0x0
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH__CYCLIC_BUFFER_LENGTH_MASK                  0xFFFFFFFFL
//AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX__LAST_VALID_INDEX__SHIFT                        0x0
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX__LAST_VALID_INDEX_MASK                          0x000000FFL
//AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE__FIFO_SIZE__SHIFT                                      0x0
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE__FIFO_SIZE_MASK                                        0xFFFFL
//AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__NUMBER_OF_CHANNELS__SHIFT                                0x0
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__BITS_PER_SAMPLE__SHIFT                                   0x4
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_DIVISOR__SHIFT                               0x8
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_MULTIPLE__SHIFT                              0xb
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_RATE__SHIFT                                  0xe
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__NUMBER_OF_CHANNELS_MASK                                  0x000FL
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__BITS_PER_SAMPLE_MASK                                     0x0070L
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_DIVISOR_MASK                                 0x0700L
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_MULTIPLE_MASK                                0x3800L
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_RATE_MASK                                    0x4000L
//AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_UNIMPLEMENTED_BITS__SHIFT  0x0
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS__SHIFT  0x7
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_UNIMPLEMENTED_BITS_MASK  0x0000007FL
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_MASK  0xFFFFFF80L
//AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_UPPER_BASE_ADDRESS__SHIFT  0x0
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_UPPER_BASE_ADDRESS_MASK  0xFFFFFFFFL
//AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS__LINK_POSITION_IN_BUFFER_ALIAS__SHIFT  0x0
#define AZSTREAM7_0_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS__LINK_POSITION_IN_BUFFER_ALIAS_MASK  0xFFFFFFFFL


// addressBlock: dce_dc_mmhubbub_vga_dispdec[72..76]
//VGA_MEM_WRITE_PAGE_ADDR
#define VGA_MEM_WRITE_PAGE_ADDR__VGA_MEM_WRITE_PAGE0_ADDR__SHIFT                                              0x0
#define VGA_MEM_WRITE_PAGE_ADDR__VGA_MEM_WRITE_PAGE1_ADDR__SHIFT                                              0x10
#define VGA_MEM_WRITE_PAGE_ADDR__VGA_MEM_WRITE_PAGE0_ADDR_MASK                                                0x000003FFL
#define VGA_MEM_WRITE_PAGE_ADDR__VGA_MEM_WRITE_PAGE1_ADDR_MASK                                                0x03FF0000L
//VGA_MEM_READ_PAGE_ADDR
#define VGA_MEM_READ_PAGE_ADDR__VGA_MEM_READ_PAGE0_ADDR__SHIFT                                                0x0
#define VGA_MEM_READ_PAGE_ADDR__VGA_MEM_READ_PAGE1_ADDR__SHIFT                                                0x10
#define VGA_MEM_READ_PAGE_ADDR__VGA_MEM_READ_PAGE0_ADDR_MASK                                                  0x000003FFL
#define VGA_MEM_READ_PAGE_ADDR__VGA_MEM_READ_PAGE1_ADDR_MASK                                                  0x03FF0000L


// addressBlock: dce_dc_mmhubbub_vga_dispdec[948..986]
//CRTC8_IDX
#define CRTC8_IDX__VCRTC_IDX__SHIFT                                                                           0x0
#define CRTC8_IDX__VCRTC_IDX_MASK                                                                             0x3FL
//CRTC8_DATA
#define CRTC8_DATA__VCRTC_DATA__SHIFT                                                                         0x0
#define CRTC8_DATA__VCRTC_DATA_MASK                                                                           0xFFL
//GENFC_WT
#define GENFC_WT__VSYNC_SEL_W__SHIFT                                                                          0x3
#define GENFC_WT__VSYNC_SEL_W_MASK                                                                            0x08L
//GENS1
#define GENS1__NO_DISPLAY__SHIFT                                                                              0x0
#define GENS1__VGA_VSTATUS__SHIFT                                                                             0x3
#define GENS1__PIXEL_READ_BACK__SHIFT                                                                         0x4
#define GENS1__NO_DISPLAY_MASK                                                                                0x01L
#define GENS1__VGA_VSTATUS_MASK                                                                               0x08L
#define GENS1__PIXEL_READ_BACK_MASK                                                                           0x30L
//ATTRDW
#define ATTRDW__ATTR_DATA__SHIFT                                                                              0x0
#define ATTRDW__ATTR_DATA_MASK                                                                                0xFFL
//ATTRX
#define ATTRX__ATTR_IDX__SHIFT                                                                                0x0
#define ATTRX__ATTR_PAL_RW_ENB__SHIFT                                                                         0x5
#define ATTRX__ATTR_IDX_MASK                                                                                  0x1FL
#define ATTRX__ATTR_PAL_RW_ENB_MASK                                                                           0x20L
//ATTRDR
#define ATTRDR__ATTR_DATA__SHIFT                                                                              0x0
#define ATTRDR__ATTR_DATA_MASK                                                                                0xFFL
//GENMO_WT
#define GENMO_WT__GENMO_MONO_ADDRESS_B__SHIFT                                                                 0x0
#define GENMO_WT__VGA_RAM_EN__SHIFT                                                                           0x1
#define GENMO_WT__VGA_CKSEL__SHIFT                                                                            0x2
#define GENMO_WT__ODD_EVEN_MD_PGSEL__SHIFT                                                                    0x5
#define GENMO_WT__VGA_HSYNC_POL__SHIFT                                                                        0x6
#define GENMO_WT__VGA_VSYNC_POL__SHIFT                                                                        0x7
#define GENMO_WT__GENMO_MONO_ADDRESS_B_MASK                                                                   0x01L
#define GENMO_WT__VGA_RAM_EN_MASK                                                                             0x02L
#define GENMO_WT__VGA_CKSEL_MASK                                                                              0x0CL
#define GENMO_WT__ODD_EVEN_MD_PGSEL_MASK                                                                      0x20L
#define GENMO_WT__VGA_HSYNC_POL_MASK                                                                          0x40L
#define GENMO_WT__VGA_VSYNC_POL_MASK                                                                          0x80L
//GENS0
#define GENS0__SENSE_SWITCH__SHIFT                                                                            0x4
#define GENS0__CRT_INTR__SHIFT                                                                                0x7
#define GENS0__SENSE_SWITCH_MASK                                                                              0x10L
#define GENS0__CRT_INTR_MASK                                                                                  0x80L
//GENENB
#define GENENB__BLK_IO_BASE__SHIFT                                                                            0x0
#define GENENB__BLK_IO_BASE_MASK                                                                              0xFFL
//SEQ8_IDX
#define SEQ8_IDX__SEQ_IDX__SHIFT                                                                              0x0
#define SEQ8_IDX__SEQ_IDX_MASK                                                                                0x07L
//SEQ8_DATA
#define SEQ8_DATA__SEQ_DATA__SHIFT                                                                            0x0
#define SEQ8_DATA__SEQ_DATA_MASK                                                                              0xFFL
//DAC_MASK
#define DAC_MASK__DAC_MASK__SHIFT                                                                             0x0
#define DAC_MASK__DAC_MASK_MASK                                                                               0xFFL
//DAC_R_INDEX
#define DAC_R_INDEX__DAC_R_INDEX__SHIFT                                                                       0x0
#define DAC_R_INDEX__DAC_R_INDEX_MASK                                                                         0xFFL
//DAC_W_INDEX
#define DAC_W_INDEX__DAC_W_INDEX__SHIFT                                                                       0x0
#define DAC_W_INDEX__DAC_W_INDEX_MASK                                                                         0xFFL
//DAC_DATA
#define DAC_DATA__DAC_DATA__SHIFT                                                                             0x0
#define DAC_DATA__DAC_DATA_MASK                                                                               0x3FL
//GENFC_RD
#define GENFC_RD__VSYNC_SEL_R__SHIFT                                                                          0x3
#define GENFC_RD__VSYNC_SEL_R_MASK                                                                            0x08L
//GENMO_RD
#define GENMO_RD__GENMO_MONO_ADDRESS_B__SHIFT                                                                 0x0
#define GENMO_RD__VGA_RAM_EN__SHIFT                                                                           0x1
#define GENMO_RD__VGA_CKSEL__SHIFT                                                                            0x2
#define GENMO_RD__ODD_EVEN_MD_PGSEL__SHIFT                                                                    0x5
#define GENMO_RD__VGA_HSYNC_POL__SHIFT                                                                        0x6
#define GENMO_RD__VGA_VSYNC_POL__SHIFT                                                                        0x7
#define GENMO_RD__GENMO_MONO_ADDRESS_B_MASK                                                                   0x01L
#define GENMO_RD__VGA_RAM_EN_MASK                                                                             0x02L
#define GENMO_RD__VGA_CKSEL_MASK                                                                              0x0CL
#define GENMO_RD__ODD_EVEN_MD_PGSEL_MASK                                                                      0x20L
#define GENMO_RD__VGA_HSYNC_POL_MASK                                                                          0x40L
#define GENMO_RD__VGA_VSYNC_POL_MASK                                                                          0x80L
//GRPH8_IDX
#define GRPH8_IDX__GRPH_IDX__SHIFT                                                                            0x0
#define GRPH8_IDX__GRPH_IDX_MASK                                                                              0x0FL
//GRPH8_DATA
#define GRPH8_DATA__GRPH_DATA__SHIFT                                                                          0x0
#define GRPH8_DATA__GRPH_DATA_MASK                                                                            0xFFL
//CRTC8_IDX_1
#define CRTC8_IDX_1__VCRTC_IDX__SHIFT                                                                         0x0
#define CRTC8_IDX_1__VCRTC_IDX_MASK                                                                           0x3FL
//CRTC8_DATA_1
#define CRTC8_DATA_1__VCRTC_DATA__SHIFT                                                                       0x0
#define CRTC8_DATA_1__VCRTC_DATA_MASK                                                                         0xFFL
//GENFC_WT_1
#define GENFC_WT_1__VSYNC_SEL_W__SHIFT                                                                        0x3
#define GENFC_WT_1__VSYNC_SEL_W_MASK                                                                          0x08L
//GENS1_1
#define GENS1_1__NO_DISPLAY__SHIFT                                                                            0x0
#define GENS1_1__VGA_VSTATUS__SHIFT                                                                           0x3
#define GENS1_1__PIXEL_READ_BACK__SHIFT                                                                       0x4
#define GENS1_1__NO_DISPLAY_MASK                                                                              0x01L
#define GENS1_1__VGA_VSTATUS_MASK                                                                             0x08L
#define GENS1_1__PIXEL_READ_BACK_MASK                                                                         0x30L


// addressBlock: dce_dc_hda_azcontroller_azdec
//CORB_WRITE_POINTER
#define CORB_WRITE_POINTER__CORB_WRITE_POINTER__SHIFT                                                         0x0
#define CORB_WRITE_POINTER__CORB_WRITE_POINTER_MASK                                                           0x00FFL
//CORB_READ_POINTER
#define CORB_READ_POINTER__CORB_READ_POINTER__SHIFT                                                           0x0
#define CORB_READ_POINTER__CORB_READ_POINTER_RESET__SHIFT                                                     0xf
#define CORB_READ_POINTER__CORB_READ_POINTER_MASK                                                             0x00FFL
#define CORB_READ_POINTER__CORB_READ_POINTER_RESET_MASK                                                       0x8000L
//CORB_CONTROL
#define CORB_CONTROL__CORB_MEMORY_ERROR_INTERRUPT_ENABLE__SHIFT                                               0x0
#define CORB_CONTROL__ENABLE_CORB_DMA_ENGINE__SHIFT                                                           0x1
#define CORB_CONTROL__CORB_MEMORY_ERROR_INTERRUPT_ENABLE_MASK                                                 0x01L
#define CORB_CONTROL__ENABLE_CORB_DMA_ENGINE_MASK                                                             0x02L
//CORB_STATUS
#define CORB_STATUS__CORB_MEMORY_ERROR_INDICATION__SHIFT                                                      0x0
#define CORB_STATUS__CORB_MEMORY_ERROR_INDICATION_MASK                                                        0x01L
//CORB_SIZE
#define CORB_SIZE__CORB_SIZE__SHIFT                                                                           0x0
#define CORB_SIZE__CORB_SIZE_CAPABILITY__SHIFT                                                                0x4
#define CORB_SIZE__CORB_SIZE_MASK                                                                             0x0003L
#define CORB_SIZE__CORB_SIZE_CAPABILITY_MASK                                                                  0x00F0L
//RIRB_LOWER_BASE_ADDRESS
#define RIRB_LOWER_BASE_ADDRESS__RIRB_LOWER_BASE_UNIMPLEMENTED_BITS__SHIFT                                    0x0
#define RIRB_LOWER_BASE_ADDRESS__RIRB_LOWER_BASE_ADDRESS__SHIFT                                               0x7
#define RIRB_LOWER_BASE_ADDRESS__RIRB_LOWER_BASE_UNIMPLEMENTED_BITS_MASK                                      0x0000007FL
#define RIRB_LOWER_BASE_ADDRESS__RIRB_LOWER_BASE_ADDRESS_MASK                                                 0xFFFFFF80L
//RIRB_UPPER_BASE_ADDRESS
#define RIRB_UPPER_BASE_ADDRESS__RIRB_UPPER_BASE_ADDRESS__SHIFT                                               0x0
#define RIRB_UPPER_BASE_ADDRESS__RIRB_UPPER_BASE_ADDRESS_MASK                                                 0xFFFFFFFFL
//RIRB_WRITE_POINTER
#define RIRB_WRITE_POINTER__RIRB_WRITE_POINTER__SHIFT                                                         0x0
#define RIRB_WRITE_POINTER__RIRB_WRITE_POINTER_RESET__SHIFT                                                   0xf
#define RIRB_WRITE_POINTER__RIRB_WRITE_POINTER_MASK                                                           0x00FFL
#define RIRB_WRITE_POINTER__RIRB_WRITE_POINTER_RESET_MASK                                                     0x8000L
//RESPONSE_INTERRUPT_COUNT
#define RESPONSE_INTERRUPT_COUNT__N_RESPONSE_INTERRUPT_COUNT__SHIFT                                           0x0
#define RESPONSE_INTERRUPT_COUNT__N_RESPONSE_INTERRUPT_COUNT_MASK                                             0x00FFL
//RIRB_CONTROL
#define RIRB_CONTROL__RESPONSE_INTERRUPT_CONTROL__SHIFT                                                       0x0
#define RIRB_CONTROL__RIRB_DMA_ENABLE__SHIFT                                                                  0x1
#define RIRB_CONTROL__RESPONSE_OVERRUN_INTERRUPT_CONTROL__SHIFT                                               0x2
#define RIRB_CONTROL__RESPONSE_INTERRUPT_CONTROL_MASK                                                         0x01L
#define RIRB_CONTROL__RIRB_DMA_ENABLE_MASK                                                                    0x02L
#define RIRB_CONTROL__RESPONSE_OVERRUN_INTERRUPT_CONTROL_MASK                                                 0x04L
//RIRB_STATUS
#define RIRB_STATUS__RESPONSE_INTERRUPT__SHIFT                                                                0x0
#define RIRB_STATUS__RESPONSE_OVERRUN_INTERRUPT_STATUS__SHIFT                                                 0x2
#define RIRB_STATUS__RESPONSE_INTERRUPT_MASK                                                                  0x01L
#define RIRB_STATUS__RESPONSE_OVERRUN_INTERRUPT_STATUS_MASK                                                   0x04L
//RIRB_SIZE
#define RIRB_SIZE__RIRB_SIZE__SHIFT                                                                           0x0
#define RIRB_SIZE__RIRB_SIZE_CAPABILITY__SHIFT                                                                0x4
#define RIRB_SIZE__RIRB_SIZE_MASK                                                                             0x0003L
#define RIRB_SIZE__RIRB_SIZE_CAPABILITY_MASK                                                                  0x00F0L
//IMMEDIATE_COMMAND_OUTPUT_INTERFACE
#define IMMEDIATE_COMMAND_OUTPUT_INTERFACE__IMMEDIATE_COMMAND_WRITE_VERB_AND_PAYLOAD__SHIFT                   0x0
#define IMMEDIATE_COMMAND_OUTPUT_INTERFACE__IMMEDIATE_COMMAND_WRITE_CODEC_ADDRESS__SHIFT                      0x1c
#define IMMEDIATE_COMMAND_OUTPUT_INTERFACE__IMMEDIATE_COMMAND_WRITE_VERB_AND_PAYLOAD_MASK                     0x0FFFFFFFL
#define IMMEDIATE_COMMAND_OUTPUT_INTERFACE__IMMEDIATE_COMMAND_WRITE_CODEC_ADDRESS_MASK                        0xF0000000L
//IMMEDIATE_COMMAND_OUTPUT_INTERFACE_DATA
#define IMMEDIATE_COMMAND_OUTPUT_INTERFACE_DATA__IMMEDIATE_COMMAND_WRITE__SHIFT                               0x0
#define IMMEDIATE_COMMAND_OUTPUT_INTERFACE_DATA__IMMEDIATE_COMMAND_WRITE_MASK                                 0xFFFFFFFFL
//IMMEDIATE_COMMAND_OUTPUT_INTERFACE_INDEX
#define IMMEDIATE_COMMAND_OUTPUT_INTERFACE_INDEX__IMMEDIATE_COMMAND_WRITE__SHIFT                              0x0
#define IMMEDIATE_COMMAND_OUTPUT_INTERFACE_INDEX__IMMEDIATE_COMMAND_WRITE_MASK                                0x0000FFFFL
//IMMEDIATE_RESPONSE_INPUT_INTERFACE
#define IMMEDIATE_RESPONSE_INPUT_INTERFACE__IMMEDIATE_RESPONSE_READ__SHIFT                                    0x0
#define IMMEDIATE_RESPONSE_INPUT_INTERFACE__IMMEDIATE_RESPONSE_READ_MASK                                      0xFFFFFFFFL
//IMMEDIATE_COMMAND_STATUS
#define IMMEDIATE_COMMAND_STATUS__IMMEDIATE_COMMAND_BUSY__SHIFT                                               0x0
#define IMMEDIATE_COMMAND_STATUS__IMMEDIATE_RESULT_VALID__SHIFT                                               0x1
#define IMMEDIATE_COMMAND_STATUS__IMMEDIATE_COMMAND_BUSY_MASK                                                 0x00000001L
#define IMMEDIATE_COMMAND_STATUS__IMMEDIATE_RESULT_VALID_MASK                                                 0x00000002L
//DMA_POSITION_LOWER_BASE_ADDRESS
#define DMA_POSITION_LOWER_BASE_ADDRESS__DMA_POSITION_BUFFER_ENABLE__SHIFT                                    0x0
#define DMA_POSITION_LOWER_BASE_ADDRESS__DMA_POSITION_LOWER_BASE_UNIMPLEMENTED_BITS__SHIFT                    0x1
#define DMA_POSITION_LOWER_BASE_ADDRESS__DMA_POSITION_LOWER_BASE_ADDRESS__SHIFT                               0x7
#define DMA_POSITION_LOWER_BASE_ADDRESS__DMA_POSITION_BUFFER_ENABLE_MASK                                      0x00000001L
#define DMA_POSITION_LOWER_BASE_ADDRESS__DMA_POSITION_LOWER_BASE_UNIMPLEMENTED_BITS_MASK                      0x0000007EL
#define DMA_POSITION_LOWER_BASE_ADDRESS__DMA_POSITION_LOWER_BASE_ADDRESS_MASK                                 0xFFFFFF80L
//DMA_POSITION_UPPER_BASE_ADDRESS
#define DMA_POSITION_UPPER_BASE_ADDRESS__DMA_POSITION_UPPER_BASE_ADDRESS__SHIFT                               0x0
#define DMA_POSITION_UPPER_BASE_ADDRESS__DMA_POSITION_UPPER_BASE_ADDRESS_MASK                                 0xFFFFFFFFL
//WALL_CLOCK_COUNTER_ALIAS
#define WALL_CLOCK_COUNTER_ALIAS__WALL_CLOCK_COUNTER_ALIAS__SHIFT                                             0x0
#define WALL_CLOCK_COUNTER_ALIAS__WALL_CLOCK_COUNTER_ALIAS_MASK                                               0xFFFFFFFFL


// addressBlock: dce_dc_hda_azendpoint_azdec
//AZENDPOINT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_DATA
#define AZENDPOINT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_DATA__IMMEDIATE_COMMAND_WRITE__SHIFT                    0x0
#define AZENDPOINT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_DATA__IMMEDIATE_COMMAND_WRITE_MASK                      0xFFFFFFFFL
//AZENDPOINT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_INDEX
#define AZENDPOINT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_INDEX__IMMEDIATE_COMMAND_WRITE__SHIFT                   0x0
#define AZENDPOINT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_INDEX__IMMEDIATE_COMMAND_WRITE_MASK                     0x0001FFFFL


// addressBlock: dce_dc_hda_azinputendpoint_azdec
//AZENDPOINT_IMMEDIATE_COMMAND_INPUT_INTERFACE_DATA
#define AZENDPOINT_IMMEDIATE_COMMAND_INPUT_INTERFACE_DATA__IMMEDIATE_COMMAND_WRITE__SHIFT                     0x0
#define AZENDPOINT_IMMEDIATE_COMMAND_INPUT_INTERFACE_DATA__IMMEDIATE_COMMAND_WRITE_MASK                       0xFFFFFFFFL
//AZENDPOINT_IMMEDIATE_COMMAND_INPUT_INTERFACE_INDEX
#define AZENDPOINT_IMMEDIATE_COMMAND_INPUT_INTERFACE_INDEX__IMMEDIATE_COMMAND_WRITE__SHIFT                    0x0
#define AZENDPOINT_IMMEDIATE_COMMAND_INPUT_INTERFACE_INDEX__IMMEDIATE_COMMAND_WRITE_MASK                      0x0001FFFFL


// addressBlock: dce_dc_hda_azroot_azdec
//AZROOT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_DATA
#define AZROOT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_DATA__IMMEDIATE_COMMAND_WRITE__SHIFT                        0x0
#define AZROOT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_DATA__IMMEDIATE_COMMAND_WRITE_MASK                          0xFFFFFFFFL
//AZROOT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_INDEX
#define AZROOT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_INDEX__IMMEDIATE_COMMAND_WRITE__SHIFT                       0x0
#define AZROOT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_INDEX__IMMEDIATE_COMMAND_WRITE_MASK                         0x0001FFFFL


// addressBlock: dce_dc_hda_azstream0_azdec
//AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RESET__SHIFT                          0x0
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RUN__SHIFT                            0x1
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__INTERRUPT_ON_COMPLETION_ENABLE__SHIFT        0x2
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_INTERRUPT_ENABLE__SHIFT           0x3
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_INTERRUPT_ENABLE__SHIFT     0x4
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STRIPE_CONTROL__SHIFT                        0x10
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__TRAFFIC_PRIORITY__SHIFT                      0x12
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_NUMBER__SHIFT                         0x14
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__BUFFER_COMPLETION_INTERRUPT_STATUS__SHIFT    0x1a
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR__SHIFT                            0x1b
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR__SHIFT                      0x1c
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_READY__SHIFT                            0x1d
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RESET_MASK                            0x00000001L
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RUN_MASK                              0x00000002L
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__INTERRUPT_ON_COMPLETION_ENABLE_MASK          0x00000004L
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_INTERRUPT_ENABLE_MASK             0x00000008L
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_INTERRUPT_ENABLE_MASK       0x00000010L
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STRIPE_CONTROL_MASK                          0x00030000L
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__TRAFFIC_PRIORITY_MASK                        0x00040000L
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_NUMBER_MASK                           0x00F00000L
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__BUFFER_COMPLETION_INTERRUPT_STATUS_MASK      0x04000000L
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_MASK                              0x08000000L
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_MASK                        0x10000000L
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_READY_MASK                              0x20000000L
//AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER__LINK_POSITION_IN_BUFFER__SHIFT  0x0
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER__LINK_POSITION_IN_BUFFER_MASK    0xFFFFFFFFL
//AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH__CYCLIC_BUFFER_LENGTH__SHIFT                0x0
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH__CYCLIC_BUFFER_LENGTH_MASK                  0xFFFFFFFFL
//AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX__LAST_VALID_INDEX__SHIFT                        0x0
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX__LAST_VALID_INDEX_MASK                          0x000000FFL
//AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE__FIFO_SIZE__SHIFT                                      0x0
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE__FIFO_SIZE_MASK                                        0xFFFFL
//AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__NUMBER_OF_CHANNELS__SHIFT                                0x0
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__BITS_PER_SAMPLE__SHIFT                                   0x4
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_DIVISOR__SHIFT                               0x8
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_MULTIPLE__SHIFT                              0xb
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_RATE__SHIFT                                  0xe
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__NUMBER_OF_CHANNELS_MASK                                  0x000FL
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__BITS_PER_SAMPLE_MASK                                     0x0070L
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_DIVISOR_MASK                                 0x0700L
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_MULTIPLE_MASK                                0x3800L
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_RATE_MASK                                    0x4000L
//AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_UNIMPLEMENTED_BITS__SHIFT  0x0
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS__SHIFT  0x7
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_UNIMPLEMENTED_BITS_MASK  0x0000007FL
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_MASK  0xFFFFFF80L
//AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_UPPER_BASE_ADDRESS__SHIFT  0x0
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_UPPER_BASE_ADDRESS_MASK  0xFFFFFFFFL
//AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS__LINK_POSITION_IN_BUFFER_ALIAS__SHIFT  0x0
#define AZSTREAM0_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS__LINK_POSITION_IN_BUFFER_ALIAS_MASK  0xFFFFFFFFL


// addressBlock: dce_dc_hda_azstream1_azdec
//AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RESET__SHIFT                          0x0
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RUN__SHIFT                            0x1
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__INTERRUPT_ON_COMPLETION_ENABLE__SHIFT        0x2
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_INTERRUPT_ENABLE__SHIFT           0x3
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_INTERRUPT_ENABLE__SHIFT     0x4
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STRIPE_CONTROL__SHIFT                        0x10
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__TRAFFIC_PRIORITY__SHIFT                      0x12
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_NUMBER__SHIFT                         0x14
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__BUFFER_COMPLETION_INTERRUPT_STATUS__SHIFT    0x1a
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR__SHIFT                            0x1b
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR__SHIFT                      0x1c
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_READY__SHIFT                            0x1d
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RESET_MASK                            0x00000001L
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RUN_MASK                              0x00000002L
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__INTERRUPT_ON_COMPLETION_ENABLE_MASK          0x00000004L
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_INTERRUPT_ENABLE_MASK             0x00000008L
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_INTERRUPT_ENABLE_MASK       0x00000010L
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STRIPE_CONTROL_MASK                          0x00030000L
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__TRAFFIC_PRIORITY_MASK                        0x00040000L
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_NUMBER_MASK                           0x00F00000L
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__BUFFER_COMPLETION_INTERRUPT_STATUS_MASK      0x04000000L
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_MASK                              0x08000000L
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_MASK                        0x10000000L
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_READY_MASK                              0x20000000L
//AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER__LINK_POSITION_IN_BUFFER__SHIFT  0x0
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER__LINK_POSITION_IN_BUFFER_MASK    0xFFFFFFFFL
//AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH__CYCLIC_BUFFER_LENGTH__SHIFT                0x0
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH__CYCLIC_BUFFER_LENGTH_MASK                  0xFFFFFFFFL
//AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX__LAST_VALID_INDEX__SHIFT                        0x0
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX__LAST_VALID_INDEX_MASK                          0x000000FFL
//AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE__FIFO_SIZE__SHIFT                                      0x0
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE__FIFO_SIZE_MASK                                        0xFFFFL
//AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__NUMBER_OF_CHANNELS__SHIFT                                0x0
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__BITS_PER_SAMPLE__SHIFT                                   0x4
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_DIVISOR__SHIFT                               0x8
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_MULTIPLE__SHIFT                              0xb
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_RATE__SHIFT                                  0xe
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__NUMBER_OF_CHANNELS_MASK                                  0x000FL
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__BITS_PER_SAMPLE_MASK                                     0x0070L
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_DIVISOR_MASK                                 0x0700L
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_MULTIPLE_MASK                                0x3800L
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_RATE_MASK                                    0x4000L
//AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_UNIMPLEMENTED_BITS__SHIFT  0x0
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS__SHIFT  0x7
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_UNIMPLEMENTED_BITS_MASK  0x0000007FL
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_MASK  0xFFFFFF80L
//AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_UPPER_BASE_ADDRESS__SHIFT  0x0
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_UPPER_BASE_ADDRESS_MASK  0xFFFFFFFFL
//AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS__LINK_POSITION_IN_BUFFER_ALIAS__SHIFT  0x0
#define AZSTREAM1_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS__LINK_POSITION_IN_BUFFER_ALIAS_MASK  0xFFFFFFFFL


// addressBlock: dce_dc_hda_azstream2_azdec
//AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RESET__SHIFT                          0x0
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RUN__SHIFT                            0x1
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__INTERRUPT_ON_COMPLETION_ENABLE__SHIFT        0x2
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_INTERRUPT_ENABLE__SHIFT           0x3
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_INTERRUPT_ENABLE__SHIFT     0x4
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STRIPE_CONTROL__SHIFT                        0x10
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__TRAFFIC_PRIORITY__SHIFT                      0x12
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_NUMBER__SHIFT                         0x14
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__BUFFER_COMPLETION_INTERRUPT_STATUS__SHIFT    0x1a
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR__SHIFT                            0x1b
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR__SHIFT                      0x1c
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_READY__SHIFT                            0x1d
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RESET_MASK                            0x00000001L
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RUN_MASK                              0x00000002L
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__INTERRUPT_ON_COMPLETION_ENABLE_MASK          0x00000004L
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_INTERRUPT_ENABLE_MASK             0x00000008L
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_INTERRUPT_ENABLE_MASK       0x00000010L
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STRIPE_CONTROL_MASK                          0x00030000L
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__TRAFFIC_PRIORITY_MASK                        0x00040000L
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_NUMBER_MASK                           0x00F00000L
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__BUFFER_COMPLETION_INTERRUPT_STATUS_MASK      0x04000000L
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_MASK                              0x08000000L
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_MASK                        0x10000000L
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_READY_MASK                              0x20000000L
//AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER__LINK_POSITION_IN_BUFFER__SHIFT  0x0
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER__LINK_POSITION_IN_BUFFER_MASK    0xFFFFFFFFL
//AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH__CYCLIC_BUFFER_LENGTH__SHIFT                0x0
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH__CYCLIC_BUFFER_LENGTH_MASK                  0xFFFFFFFFL
//AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX__LAST_VALID_INDEX__SHIFT                        0x0
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX__LAST_VALID_INDEX_MASK                          0x000000FFL
//AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE__FIFO_SIZE__SHIFT                                      0x0
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE__FIFO_SIZE_MASK                                        0xFFFFL
//AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__NUMBER_OF_CHANNELS__SHIFT                                0x0
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__BITS_PER_SAMPLE__SHIFT                                   0x4
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_DIVISOR__SHIFT                               0x8
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_MULTIPLE__SHIFT                              0xb
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_RATE__SHIFT                                  0xe
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__NUMBER_OF_CHANNELS_MASK                                  0x000FL
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__BITS_PER_SAMPLE_MASK                                     0x0070L
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_DIVISOR_MASK                                 0x0700L
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_MULTIPLE_MASK                                0x3800L
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_RATE_MASK                                    0x4000L
//AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_UNIMPLEMENTED_BITS__SHIFT  0x0
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS__SHIFT  0x7
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_UNIMPLEMENTED_BITS_MASK  0x0000007FL
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_MASK  0xFFFFFF80L
//AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_UPPER_BASE_ADDRESS__SHIFT  0x0
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_UPPER_BASE_ADDRESS_MASK  0xFFFFFFFFL
//AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS__LINK_POSITION_IN_BUFFER_ALIAS__SHIFT  0x0
#define AZSTREAM2_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS__LINK_POSITION_IN_BUFFER_ALIAS_MASK  0xFFFFFFFFL


// addressBlock: dce_dc_hda_azstream3_azdec
//AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RESET__SHIFT                          0x0
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RUN__SHIFT                            0x1
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__INTERRUPT_ON_COMPLETION_ENABLE__SHIFT        0x2
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_INTERRUPT_ENABLE__SHIFT           0x3
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_INTERRUPT_ENABLE__SHIFT     0x4
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STRIPE_CONTROL__SHIFT                        0x10
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__TRAFFIC_PRIORITY__SHIFT                      0x12
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_NUMBER__SHIFT                         0x14
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__BUFFER_COMPLETION_INTERRUPT_STATUS__SHIFT    0x1a
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR__SHIFT                            0x1b
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR__SHIFT                      0x1c
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_READY__SHIFT                            0x1d
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RESET_MASK                            0x00000001L
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RUN_MASK                              0x00000002L
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__INTERRUPT_ON_COMPLETION_ENABLE_MASK          0x00000004L
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_INTERRUPT_ENABLE_MASK             0x00000008L
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_INTERRUPT_ENABLE_MASK       0x00000010L
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STRIPE_CONTROL_MASK                          0x00030000L
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__TRAFFIC_PRIORITY_MASK                        0x00040000L
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_NUMBER_MASK                           0x00F00000L
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__BUFFER_COMPLETION_INTERRUPT_STATUS_MASK      0x04000000L
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_MASK                              0x08000000L
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_MASK                        0x10000000L
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_READY_MASK                              0x20000000L
//AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER__LINK_POSITION_IN_BUFFER__SHIFT  0x0
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER__LINK_POSITION_IN_BUFFER_MASK    0xFFFFFFFFL
//AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH__CYCLIC_BUFFER_LENGTH__SHIFT                0x0
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH__CYCLIC_BUFFER_LENGTH_MASK                  0xFFFFFFFFL
//AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX__LAST_VALID_INDEX__SHIFT                        0x0
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX__LAST_VALID_INDEX_MASK                          0x000000FFL
//AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE__FIFO_SIZE__SHIFT                                      0x0
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE__FIFO_SIZE_MASK                                        0xFFFFL
//AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__NUMBER_OF_CHANNELS__SHIFT                                0x0
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__BITS_PER_SAMPLE__SHIFT                                   0x4
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_DIVISOR__SHIFT                               0x8
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_MULTIPLE__SHIFT                              0xb
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_RATE__SHIFT                                  0xe
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__NUMBER_OF_CHANNELS_MASK                                  0x000FL
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__BITS_PER_SAMPLE_MASK                                     0x0070L
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_DIVISOR_MASK                                 0x0700L
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_MULTIPLE_MASK                                0x3800L
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_RATE_MASK                                    0x4000L
//AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_UNIMPLEMENTED_BITS__SHIFT  0x0
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS__SHIFT  0x7
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_UNIMPLEMENTED_BITS_MASK  0x0000007FL
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_MASK  0xFFFFFF80L
//AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_UPPER_BASE_ADDRESS__SHIFT  0x0
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_UPPER_BASE_ADDRESS_MASK  0xFFFFFFFFL
//AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS__LINK_POSITION_IN_BUFFER_ALIAS__SHIFT  0x0
#define AZSTREAM3_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS__LINK_POSITION_IN_BUFFER_ALIAS_MASK  0xFFFFFFFFL


// addressBlock: dce_dc_hda_azstream4_azdec
//AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RESET__SHIFT                          0x0
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RUN__SHIFT                            0x1
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__INTERRUPT_ON_COMPLETION_ENABLE__SHIFT        0x2
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_INTERRUPT_ENABLE__SHIFT           0x3
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_INTERRUPT_ENABLE__SHIFT     0x4
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STRIPE_CONTROL__SHIFT                        0x10
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__TRAFFIC_PRIORITY__SHIFT                      0x12
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_NUMBER__SHIFT                         0x14
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__BUFFER_COMPLETION_INTERRUPT_STATUS__SHIFT    0x1a
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR__SHIFT                            0x1b
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR__SHIFT                      0x1c
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_READY__SHIFT                            0x1d
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RESET_MASK                            0x00000001L
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RUN_MASK                              0x00000002L
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__INTERRUPT_ON_COMPLETION_ENABLE_MASK          0x00000004L
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_INTERRUPT_ENABLE_MASK             0x00000008L
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_INTERRUPT_ENABLE_MASK       0x00000010L
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STRIPE_CONTROL_MASK                          0x00030000L
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__TRAFFIC_PRIORITY_MASK                        0x00040000L
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_NUMBER_MASK                           0x00F00000L
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__BUFFER_COMPLETION_INTERRUPT_STATUS_MASK      0x04000000L
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_MASK                              0x08000000L
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_MASK                        0x10000000L
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_READY_MASK                              0x20000000L
//AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER__LINK_POSITION_IN_BUFFER__SHIFT  0x0
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER__LINK_POSITION_IN_BUFFER_MASK    0xFFFFFFFFL
//AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH__CYCLIC_BUFFER_LENGTH__SHIFT                0x0
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH__CYCLIC_BUFFER_LENGTH_MASK                  0xFFFFFFFFL
//AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX__LAST_VALID_INDEX__SHIFT                        0x0
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX__LAST_VALID_INDEX_MASK                          0x000000FFL
//AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE__FIFO_SIZE__SHIFT                                      0x0
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE__FIFO_SIZE_MASK                                        0xFFFFL
//AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__NUMBER_OF_CHANNELS__SHIFT                                0x0
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__BITS_PER_SAMPLE__SHIFT                                   0x4
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_DIVISOR__SHIFT                               0x8
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_MULTIPLE__SHIFT                              0xb
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_RATE__SHIFT                                  0xe
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__NUMBER_OF_CHANNELS_MASK                                  0x000FL
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__BITS_PER_SAMPLE_MASK                                     0x0070L
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_DIVISOR_MASK                                 0x0700L
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_MULTIPLE_MASK                                0x3800L
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_RATE_MASK                                    0x4000L
//AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_UNIMPLEMENTED_BITS__SHIFT  0x0
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS__SHIFT  0x7
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_UNIMPLEMENTED_BITS_MASK  0x0000007FL
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_MASK  0xFFFFFF80L
//AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_UPPER_BASE_ADDRESS__SHIFT  0x0
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_UPPER_BASE_ADDRESS_MASK  0xFFFFFFFFL
//AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS__LINK_POSITION_IN_BUFFER_ALIAS__SHIFT  0x0
#define AZSTREAM4_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS__LINK_POSITION_IN_BUFFER_ALIAS_MASK  0xFFFFFFFFL


// addressBlock: dce_dc_hda_azstream5_azdec
//AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RESET__SHIFT                          0x0
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RUN__SHIFT                            0x1
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__INTERRUPT_ON_COMPLETION_ENABLE__SHIFT        0x2
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_INTERRUPT_ENABLE__SHIFT           0x3
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_INTERRUPT_ENABLE__SHIFT     0x4
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STRIPE_CONTROL__SHIFT                        0x10
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__TRAFFIC_PRIORITY__SHIFT                      0x12
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_NUMBER__SHIFT                         0x14
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__BUFFER_COMPLETION_INTERRUPT_STATUS__SHIFT    0x1a
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR__SHIFT                            0x1b
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR__SHIFT                      0x1c
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_READY__SHIFT                            0x1d
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RESET_MASK                            0x00000001L
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RUN_MASK                              0x00000002L
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__INTERRUPT_ON_COMPLETION_ENABLE_MASK          0x00000004L
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_INTERRUPT_ENABLE_MASK             0x00000008L
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_INTERRUPT_ENABLE_MASK       0x00000010L
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STRIPE_CONTROL_MASK                          0x00030000L
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__TRAFFIC_PRIORITY_MASK                        0x00040000L
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_NUMBER_MASK                           0x00F00000L
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__BUFFER_COMPLETION_INTERRUPT_STATUS_MASK      0x04000000L
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_MASK                              0x08000000L
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_MASK                        0x10000000L
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_READY_MASK                              0x20000000L
//AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER__LINK_POSITION_IN_BUFFER__SHIFT  0x0
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER__LINK_POSITION_IN_BUFFER_MASK    0xFFFFFFFFL
//AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH__CYCLIC_BUFFER_LENGTH__SHIFT                0x0
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH__CYCLIC_BUFFER_LENGTH_MASK                  0xFFFFFFFFL
//AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX__LAST_VALID_INDEX__SHIFT                        0x0
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX__LAST_VALID_INDEX_MASK                          0x000000FFL
//AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE__FIFO_SIZE__SHIFT                                      0x0
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE__FIFO_SIZE_MASK                                        0xFFFFL
//AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__NUMBER_OF_CHANNELS__SHIFT                                0x0
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__BITS_PER_SAMPLE__SHIFT                                   0x4
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_DIVISOR__SHIFT                               0x8
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_MULTIPLE__SHIFT                              0xb
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_RATE__SHIFT                                  0xe
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__NUMBER_OF_CHANNELS_MASK                                  0x000FL
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__BITS_PER_SAMPLE_MASK                                     0x0070L
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_DIVISOR_MASK                                 0x0700L
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_MULTIPLE_MASK                                0x3800L
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_RATE_MASK                                    0x4000L
//AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_UNIMPLEMENTED_BITS__SHIFT  0x0
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS__SHIFT  0x7
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_UNIMPLEMENTED_BITS_MASK  0x0000007FL
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_MASK  0xFFFFFF80L
//AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_UPPER_BASE_ADDRESS__SHIFT  0x0
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_UPPER_BASE_ADDRESS_MASK  0xFFFFFFFFL
//AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS__LINK_POSITION_IN_BUFFER_ALIAS__SHIFT  0x0
#define AZSTREAM5_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS__LINK_POSITION_IN_BUFFER_ALIAS_MASK  0xFFFFFFFFL


// addressBlock: dce_dc_hda_azstream6_azdec
//AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RESET__SHIFT                          0x0
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RUN__SHIFT                            0x1
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__INTERRUPT_ON_COMPLETION_ENABLE__SHIFT        0x2
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_INTERRUPT_ENABLE__SHIFT           0x3
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_INTERRUPT_ENABLE__SHIFT     0x4
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STRIPE_CONTROL__SHIFT                        0x10
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__TRAFFIC_PRIORITY__SHIFT                      0x12
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_NUMBER__SHIFT                         0x14
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__BUFFER_COMPLETION_INTERRUPT_STATUS__SHIFT    0x1a
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR__SHIFT                            0x1b
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR__SHIFT                      0x1c
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_READY__SHIFT                            0x1d
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RESET_MASK                            0x00000001L
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RUN_MASK                              0x00000002L
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__INTERRUPT_ON_COMPLETION_ENABLE_MASK          0x00000004L
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_INTERRUPT_ENABLE_MASK             0x00000008L
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_INTERRUPT_ENABLE_MASK       0x00000010L
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STRIPE_CONTROL_MASK                          0x00030000L
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__TRAFFIC_PRIORITY_MASK                        0x00040000L
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_NUMBER_MASK                           0x00F00000L
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__BUFFER_COMPLETION_INTERRUPT_STATUS_MASK      0x04000000L
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_MASK                              0x08000000L
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_MASK                        0x10000000L
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_READY_MASK                              0x20000000L
//AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER__LINK_POSITION_IN_BUFFER__SHIFT  0x0
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER__LINK_POSITION_IN_BUFFER_MASK    0xFFFFFFFFL
//AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH__CYCLIC_BUFFER_LENGTH__SHIFT                0x0
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH__CYCLIC_BUFFER_LENGTH_MASK                  0xFFFFFFFFL
//AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX__LAST_VALID_INDEX__SHIFT                        0x0
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX__LAST_VALID_INDEX_MASK                          0x000000FFL
//AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE__FIFO_SIZE__SHIFT                                      0x0
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE__FIFO_SIZE_MASK                                        0xFFFFL
//AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__NUMBER_OF_CHANNELS__SHIFT                                0x0
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__BITS_PER_SAMPLE__SHIFT                                   0x4
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_DIVISOR__SHIFT                               0x8
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_MULTIPLE__SHIFT                              0xb
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_RATE__SHIFT                                  0xe
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__NUMBER_OF_CHANNELS_MASK                                  0x000FL
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__BITS_PER_SAMPLE_MASK                                     0x0070L
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_DIVISOR_MASK                                 0x0700L
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_MULTIPLE_MASK                                0x3800L
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_RATE_MASK                                    0x4000L
//AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_UNIMPLEMENTED_BITS__SHIFT  0x0
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS__SHIFT  0x7
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_UNIMPLEMENTED_BITS_MASK  0x0000007FL
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_MASK  0xFFFFFF80L
//AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_UPPER_BASE_ADDRESS__SHIFT  0x0
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_UPPER_BASE_ADDRESS_MASK  0xFFFFFFFFL
//AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS__LINK_POSITION_IN_BUFFER_ALIAS__SHIFT  0x0
#define AZSTREAM6_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS__LINK_POSITION_IN_BUFFER_ALIAS_MASK  0xFFFFFFFFL


// addressBlock: dce_dc_hda_azstream7_azdec
//AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RESET__SHIFT                          0x0
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RUN__SHIFT                            0x1
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__INTERRUPT_ON_COMPLETION_ENABLE__SHIFT        0x2
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_INTERRUPT_ENABLE__SHIFT           0x3
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_INTERRUPT_ENABLE__SHIFT     0x4
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STRIPE_CONTROL__SHIFT                        0x10
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__TRAFFIC_PRIORITY__SHIFT                      0x12
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_NUMBER__SHIFT                         0x14
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__BUFFER_COMPLETION_INTERRUPT_STATUS__SHIFT    0x1a
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR__SHIFT                            0x1b
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR__SHIFT                      0x1c
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_READY__SHIFT                            0x1d
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RESET_MASK                            0x00000001L
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_RUN_MASK                              0x00000002L
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__INTERRUPT_ON_COMPLETION_ENABLE_MASK          0x00000004L
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_INTERRUPT_ENABLE_MASK             0x00000008L
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_INTERRUPT_ENABLE_MASK       0x00000010L
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STRIPE_CONTROL_MASK                          0x00030000L
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__TRAFFIC_PRIORITY_MASK                        0x00040000L
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__STREAM_NUMBER_MASK                           0x00F00000L
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__BUFFER_COMPLETION_INTERRUPT_STATUS_MASK      0x04000000L
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_ERROR_MASK                              0x08000000L
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__DESCRIPTOR_ERROR_MASK                        0x10000000L
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_CONTROL_AND_STATUS__FIFO_READY_MASK                              0x20000000L
//AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER__LINK_POSITION_IN_BUFFER__SHIFT  0x0
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER__LINK_POSITION_IN_BUFFER_MASK    0xFFFFFFFFL
//AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH__CYCLIC_BUFFER_LENGTH__SHIFT                0x0
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_CYCLIC_BUFFER_LENGTH__CYCLIC_BUFFER_LENGTH_MASK                  0xFFFFFFFFL
//AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX__LAST_VALID_INDEX__SHIFT                        0x0
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_LAST_VALID_INDEX__LAST_VALID_INDEX_MASK                          0x000000FFL
//AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE__FIFO_SIZE__SHIFT                                      0x0
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_FIFO_SIZE__FIFO_SIZE_MASK                                        0xFFFFL
//AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__NUMBER_OF_CHANNELS__SHIFT                                0x0
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__BITS_PER_SAMPLE__SHIFT                                   0x4
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_DIVISOR__SHIFT                               0x8
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_MULTIPLE__SHIFT                              0xb
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_RATE__SHIFT                                  0xe
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__NUMBER_OF_CHANNELS_MASK                                  0x000FL
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__BITS_PER_SAMPLE_MASK                                     0x0070L
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_DIVISOR_MASK                                 0x0700L
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_MULTIPLE_MASK                                0x3800L
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_FORMAT__SAMPLE_BASE_RATE_MASK                                    0x4000L
//AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_UNIMPLEMENTED_BITS__SHIFT  0x0
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS__SHIFT  0x7
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_UNIMPLEMENTED_BITS_MASK  0x0000007FL
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_LOWER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_LOWER_BASE_ADDRESS_MASK  0xFFFFFF80L
//AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_UPPER_BASE_ADDRESS__SHIFT  0x0
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_BDL_POINTER_UPPER_BASE_ADDRESS__BUFFER_DESCRIPTOR_LIST_UPPER_BASE_ADDRESS_MASK  0xFFFFFFFFL
//AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS__LINK_POSITION_IN_BUFFER_ALIAS__SHIFT  0x0
#define AZSTREAM7_1_OUTPUT_STREAM_DESCRIPTOR_LINK_POSITION_IN_CURRENT_BUFFER_ALIAS__LINK_POSITION_IN_BUFFER_ALIAS_MASK  0xFFFFFFFFL


// addressBlock: dce_dc_mmhubbub_vga_dispdec[72..76]


// addressBlock: dce_dc_mmhubbub_vga_dispdec
//VGA_RENDER_CONTROL
#define VGA_RENDER_CONTROL__VGA_BLINK_RATE__SHIFT                                                             0x0
#define VGA_RENDER_CONTROL__VGA_BLINK_MODE__SHIFT                                                             0x5
#define VGA_RENDER_CONTROL__VGA_CURSOR_BLINK_INVERT__SHIFT                                                    0x7
#define VGA_RENDER_CONTROL__VGA_EXTD_ADDR_COUNT_ENABLE__SHIFT                                                 0x8
#define VGA_RENDER_CONTROL__VGA_VSTATUS_CNTL__SHIFT                                                           0x10
#define VGA_RENDER_CONTROL__VGA_LOCK_8DOT__SHIFT                                                              0x18
#define VGA_RENDER_CONTROL__VGAREG_LINECMP_COMPATIBILITY_SEL__SHIFT                                           0x19
#define VGA_RENDER_CONTROL__VGA_BLINK_RATE_MASK                                                               0x0000001FL
#define VGA_RENDER_CONTROL__VGA_BLINK_MODE_MASK                                                               0x00000060L
#define VGA_RENDER_CONTROL__VGA_CURSOR_BLINK_INVERT_MASK                                                      0x00000080L
#define VGA_RENDER_CONTROL__VGA_EXTD_ADDR_COUNT_ENABLE_MASK                                                   0x00000100L
#define VGA_RENDER_CONTROL__VGA_VSTATUS_CNTL_MASK                                                             0x00030000L
#define VGA_RENDER_CONTROL__VGA_LOCK_8DOT_MASK                                                                0x01000000L
#define VGA_RENDER_CONTROL__VGAREG_LINECMP_COMPATIBILITY_SEL_MASK                                             0x02000000L
//VGA_SEQUENCER_RESET_CONTROL
#define VGA_SEQUENCER_RESET_CONTROL__D1_BLANK_DISPLAY_WHEN_SEQUENCER_RESET__SHIFT                             0x0
#define VGA_SEQUENCER_RESET_CONTROL__D2_BLANK_DISPLAY_WHEN_SEQUENCER_RESET__SHIFT                             0x1
#define VGA_SEQUENCER_RESET_CONTROL__D3_BLANK_DISPLAY_WHEN_SEQUENCER_RESET__SHIFT                             0x2
#define VGA_SEQUENCER_RESET_CONTROL__D4_BLANK_DISPLAY_WHEN_SEQUENCER_RESET__SHIFT                             0x3
#define VGA_SEQUENCER_RESET_CONTROL__D5_BLANK_DISPLAY_WHEN_SEQUENCER_RESET__SHIFT                             0x4
#define VGA_SEQUENCER_RESET_CONTROL__D6_BLANK_DISPLAY_WHEN_SEQUENCER_RESET__SHIFT                             0x5
#define VGA_SEQUENCER_RESET_CONTROL__D1_DISABLE_SYNCS_AND_DE_WHEN_SEQUENCER_RESET__SHIFT                      0x8
#define VGA_SEQUENCER_RESET_CONTROL__D2_DISABLE_SYNCS_AND_DE_WHEN_SEQUENCER_RESET__SHIFT                      0x9
#define VGA_SEQUENCER_RESET_CONTROL__D3_DISABLE_SYNCS_AND_DE_WHEN_SEQUENCER_RESET__SHIFT                      0xa
#define VGA_SEQUENCER_RESET_CONTROL__D4_DISABLE_SYNCS_AND_DE_WHEN_SEQUENCER_RESET__SHIFT                      0xb
#define VGA_SEQUENCER_RESET_CONTROL__D5_DISABLE_SYNCS_AND_DE_WHEN_SEQUENCER_RESET__SHIFT                      0xc
#define VGA_SEQUENCER_RESET_CONTROL__D6_DISABLE_SYNCS_AND_DE_WHEN_SEQUENCER_RESET__SHIFT                      0xd
#define VGA_SEQUENCER_RESET_CONTROL__VGA_MODE_AUTO_TRIGGER_ENABLE__SHIFT                                      0x10
#define VGA_SEQUENCER_RESET_CONTROL__VGA_MODE_AUTO_TRIGGER_REGISTER_SELECT__SHIFT                             0x11
#define VGA_SEQUENCER_RESET_CONTROL__VGA_MODE_AUTO_TRIGGER_INDEX_SELECT__SHIFT                                0x12
#define VGA_SEQUENCER_RESET_CONTROL__D1_BLANK_DISPLAY_WHEN_SEQUENCER_RESET_MASK                               0x00000001L
#define VGA_SEQUENCER_RESET_CONTROL__D2_BLANK_DISPLAY_WHEN_SEQUENCER_RESET_MASK                               0x00000002L
#define VGA_SEQUENCER_RESET_CONTROL__D3_BLANK_DISPLAY_WHEN_SEQUENCER_RESET_MASK                               0x00000004L
#define VGA_SEQUENCER_RESET_CONTROL__D4_BLANK_DISPLAY_WHEN_SEQUENCER_RESET_MASK                               0x00000008L
#define VGA_SEQUENCER_RESET_CONTROL__D5_BLANK_DISPLAY_WHEN_SEQUENCER_RESET_MASK                               0x00000010L
#define VGA_SEQUENCER_RESET_CONTROL__D6_BLANK_DISPLAY_WHEN_SEQUENCER_RESET_MASK                               0x00000020L
#define VGA_SEQUENCER_RESET_CONTROL__D1_DISABLE_SYNCS_AND_DE_WHEN_SEQUENCER_RESET_MASK                        0x00000100L
#define VGA_SEQUENCER_RESET_CONTROL__D2_DISABLE_SYNCS_AND_DE_WHEN_SEQUENCER_RESET_MASK                        0x00000200L
#define VGA_SEQUENCER_RESET_CONTROL__D3_DISABLE_SYNCS_AND_DE_WHEN_SEQUENCER_RESET_MASK                        0x00000400L
#define VGA_SEQUENCER_RESET_CONTROL__D4_DISABLE_SYNCS_AND_DE_WHEN_SEQUENCER_RESET_MASK                        0x00000800L
#define VGA_SEQUENCER_RESET_CONTROL__D5_DISABLE_SYNCS_AND_DE_WHEN_SEQUENCER_RESET_MASK                        0x00001000L
#define VGA_SEQUENCER_RESET_CONTROL__D6_DISABLE_SYNCS_AND_DE_WHEN_SEQUENCER_RESET_MASK                        0x00002000L
#define VGA_SEQUENCER_RESET_CONTROL__VGA_MODE_AUTO_TRIGGER_ENABLE_MASK                                        0x00010000L
#define VGA_SEQUENCER_RESET_CONTROL__VGA_MODE_AUTO_TRIGGER_REGISTER_SELECT_MASK                               0x00020000L
#define VGA_SEQUENCER_RESET_CONTROL__VGA_MODE_AUTO_TRIGGER_INDEX_SELECT_MASK                                  0x00FC0000L
//VGA_MODE_CONTROL
#define VGA_MODE_CONTROL__VGA_ATI_LINEAR__SHIFT                                                               0x0
#define VGA_MODE_CONTROL__VGA_LUT_PALETTE_UPDATE_MODE__SHIFT                                                  0x4
#define VGA_MODE_CONTROL__VGA_128K_APERTURE_PAGING__SHIFT                                                     0x8
#define VGA_MODE_CONTROL__VGA_TEXT_132_COLUMNS_EN__SHIFT                                                      0x10
#define VGA_MODE_CONTROL__VGA_DEEP_SLEEP_FORCE_EXIT__SHIFT                                                    0x18
#define VGA_MODE_CONTROL__VGA_ATI_LINEAR_MASK                                                                 0x00000001L
#define VGA_MODE_CONTROL__VGA_LUT_PALETTE_UPDATE_MODE_MASK                                                    0x00000030L
#define VGA_MODE_CONTROL__VGA_128K_APERTURE_PAGING_MASK                                                       0x00000100L
#define VGA_MODE_CONTROL__VGA_TEXT_132_COLUMNS_EN_MASK                                                        0x00010000L
#define VGA_MODE_CONTROL__VGA_DEEP_SLEEP_FORCE_EXIT_MASK                                                      0x01000000L
//VGA_SURFACE_PITCH_SELECT
#define VGA_SURFACE_PITCH_SELECT__VGA_SURFACE_PITCH_SELECT__SHIFT                                             0x0
#define VGA_SURFACE_PITCH_SELECT__VGA_SURFACE_HEIGHT_SELECT__SHIFT                                            0x8
#define VGA_SURFACE_PITCH_SELECT__VGA_SURFACE_PITCH_SELECT_MASK                                               0x00000003L
#define VGA_SURFACE_PITCH_SELECT__VGA_SURFACE_HEIGHT_SELECT_MASK                                              0x00000300L
//VGA_MEMORY_BASE_ADDRESS
#define VGA_MEMORY_BASE_ADDRESS__VGA_MEMORY_BASE_ADDRESS__SHIFT                                               0x0
#define VGA_MEMORY_BASE_ADDRESS__VGA_MEMORY_BASE_ADDRESS_MASK                                                 0xFFFFFFFFL
//VGA_DISPBUF1_SURFACE_ADDR
#define VGA_DISPBUF1_SURFACE_ADDR__VGA_DISPBUF1_SURFACE_ADDR__SHIFT                                           0x0
#define VGA_DISPBUF1_SURFACE_ADDR__VGA_DISPBUF1_SURFACE_ADDR_MASK                                             0x01FFFFFFL
//VGA_DISPBUF2_SURFACE_ADDR
#define VGA_DISPBUF2_SURFACE_ADDR__VGA_DISPBUF2_SURFACE_ADDR__SHIFT                                           0x0
#define VGA_DISPBUF2_SURFACE_ADDR__VGA_DISPBUF2_SURFACE_ADDR_MASK                                             0x01FFFFFFL
//VGA_MEMORY_BASE_ADDRESS_HIGH
#define VGA_MEMORY_BASE_ADDRESS_HIGH__VGA_MEMORY_BASE_ADDRESS_HIGH__SHIFT                                     0x0
#define VGA_MEMORY_BASE_ADDRESS_HIGH__VGA_MEMORY_BASE_ADDRESS_HIGH_MASK                                       0x000000FFL
//VGA_HDP_CONTROL
#define VGA_HDP_CONTROL__VGA_MEM_PAGE_SELECT_EN__SHIFT                                                        0x0
#define VGA_HDP_CONTROL__VGA_MEMORY_DISABLE__SHIFT                                                            0x4
#define VGA_HDP_CONTROL__VGA_RBBM_LOCK_DISABLE__SHIFT                                                         0x8
#define VGA_HDP_CONTROL__VGA_SOFT_RESET__SHIFT                                                                0x10
#define VGA_HDP_CONTROL__VGA_TEST_RESET_CONTROL__SHIFT                                                        0x18
#define VGA_HDP_CONTROL__VGA_MEM_PAGE_SELECT_EN_MASK                                                          0x00000001L
#define VGA_HDP_CONTROL__VGA_MEMORY_DISABLE_MASK                                                              0x00000010L
#define VGA_HDP_CONTROL__VGA_RBBM_LOCK_DISABLE_MASK                                                           0x00000100L
#define VGA_HDP_CONTROL__VGA_SOFT_RESET_MASK                                                                  0x00010000L
#define VGA_HDP_CONTROL__VGA_TEST_RESET_CONTROL_MASK                                                          0x01000000L
//VGA_CACHE_CONTROL
#define VGA_CACHE_CONTROL__VGA_WRITE_THROUGH_CACHE_DIS__SHIFT                                                 0x0
#define VGA_CACHE_CONTROL__VGA_READ_CACHE_DISABLE__SHIFT                                                      0x8
#define VGA_CACHE_CONTROL__VGA_READ_BUFFER_INVALIDATE__SHIFT                                                  0x10
#define VGA_CACHE_CONTROL__VGA_DCCIF_W256ONLY__SHIFT                                                          0x14
#define VGA_CACHE_CONTROL__VGA_DCCIF_WC_TIMEOUT__SHIFT                                                        0x18
#define VGA_CACHE_CONTROL__VGA_WRITE_THROUGH_CACHE_DIS_MASK                                                   0x00000001L
#define VGA_CACHE_CONTROL__VGA_READ_CACHE_DISABLE_MASK                                                        0x00000100L
#define VGA_CACHE_CONTROL__VGA_READ_BUFFER_INVALIDATE_MASK                                                    0x00010000L
#define VGA_CACHE_CONTROL__VGA_DCCIF_W256ONLY_MASK                                                            0x00100000L
#define VGA_CACHE_CONTROL__VGA_DCCIF_WC_TIMEOUT_MASK                                                          0x3F000000L
//D1VGA_CONTROL
#define D1VGA_CONTROL__D1VGA_MODE_ENABLE__SHIFT                                                               0x0
#define D1VGA_CONTROL__D1VGA_TIMING_SELECT__SHIFT                                                             0x8
#define D1VGA_CONTROL__D1VGA_SYNC_POLARITY_SELECT__SHIFT                                                      0x9
#define D1VGA_CONTROL__D1VGA_OVERSCAN_COLOR_EN__SHIFT                                                         0x10
#define D1VGA_CONTROL__D1VGA_ROTATE__SHIFT                                                                    0x18
#define D1VGA_CONTROL__D1VGA_MODE_ENABLE_MASK                                                                 0x00000001L
#define D1VGA_CONTROL__D1VGA_TIMING_SELECT_MASK                                                               0x00000100L
#define D1VGA_CONTROL__D1VGA_SYNC_POLARITY_SELECT_MASK                                                        0x00000200L
#define D1VGA_CONTROL__D1VGA_OVERSCAN_COLOR_EN_MASK                                                           0x00010000L
#define D1VGA_CONTROL__D1VGA_ROTATE_MASK                                                                      0x03000000L
//D2VGA_CONTROL
#define D2VGA_CONTROL__D2VGA_MODE_ENABLE__SHIFT                                                               0x0
#define D2VGA_CONTROL__D2VGA_TIMING_SELECT__SHIFT                                                             0x8
#define D2VGA_CONTROL__D2VGA_SYNC_POLARITY_SELECT__SHIFT                                                      0x9
#define D2VGA_CONTROL__D2VGA_OVERSCAN_COLOR_EN__SHIFT                                                         0x10
#define D2VGA_CONTROL__D2VGA_ROTATE__SHIFT                                                                    0x18
#define D2VGA_CONTROL__D2VGA_MODE_ENABLE_MASK                                                                 0x00000001L
#define D2VGA_CONTROL__D2VGA_TIMING_SELECT_MASK                                                               0x00000100L
#define D2VGA_CONTROL__D2VGA_SYNC_POLARITY_SELECT_MASK                                                        0x00000200L
#define D2VGA_CONTROL__D2VGA_OVERSCAN_COLOR_EN_MASK                                                           0x00010000L
#define D2VGA_CONTROL__D2VGA_ROTATE_MASK                                                                      0x03000000L
//VGA_STATUS
#define VGA_STATUS__VGA_MEM_ACCESS_STATUS__SHIFT                                                              0x0
#define VGA_STATUS__VGA_REG_ACCESS_STATUS__SHIFT                                                              0x1
#define VGA_STATUS__VGA_DISPLAY_SWITCH_STATUS__SHIFT                                                          0x2
#define VGA_STATUS__VGA_MODE_AUTO_TRIGGER_STATUS__SHIFT                                                       0x3
#define VGA_STATUS__VGA_MEM_ACCESS_STATUS_MASK                                                                0x00000001L
#define VGA_STATUS__VGA_REG_ACCESS_STATUS_MASK                                                                0x00000002L
#define VGA_STATUS__VGA_DISPLAY_SWITCH_STATUS_MASK                                                            0x00000004L
#define VGA_STATUS__VGA_MODE_AUTO_TRIGGER_STATUS_MASK                                                         0x00000008L
//VGA_INTERRUPT_CONTROL
#define VGA_INTERRUPT_CONTROL__VGA_MEM_ACCESS_INT_MASK__SHIFT                                                 0x0
#define VGA_INTERRUPT_CONTROL__VGA_REG_ACCESS_INT_MASK__SHIFT                                                 0x8
#define VGA_INTERRUPT_CONTROL__VGA_DISPLAY_SWITCH_INT_MASK__SHIFT                                             0x10
#define VGA_INTERRUPT_CONTROL__VGA_MODE_AUTO_TRIGGER_INT_MASK__SHIFT                                          0x18
#define VGA_INTERRUPT_CONTROL__VGA_MEM_ACCESS_INT_MASK_MASK                                                   0x00000001L
#define VGA_INTERRUPT_CONTROL__VGA_REG_ACCESS_INT_MASK_MASK                                                   0x00000100L
#define VGA_INTERRUPT_CONTROL__VGA_DISPLAY_SWITCH_INT_MASK_MASK                                               0x00010000L
#define VGA_INTERRUPT_CONTROL__VGA_MODE_AUTO_TRIGGER_INT_MASK_MASK                                            0x01000000L
//VGA_STATUS_CLEAR
#define VGA_STATUS_CLEAR__VGA_MEM_ACCESS_INT_CLEAR__SHIFT                                                     0x0
#define VGA_STATUS_CLEAR__VGA_REG_ACCESS_INT_CLEAR__SHIFT                                                     0x8
#define VGA_STATUS_CLEAR__VGA_DISPLAY_SWITCH_INT_CLEAR__SHIFT                                                 0x10
#define VGA_STATUS_CLEAR__VGA_MODE_AUTO_TRIGGER_INT_CLEAR__SHIFT                                              0x18
#define VGA_STATUS_CLEAR__VGA_MEM_ACCESS_INT_CLEAR_MASK                                                       0x00000001L
#define VGA_STATUS_CLEAR__VGA_REG_ACCESS_INT_CLEAR_MASK                                                       0x00000100L
#define VGA_STATUS_CLEAR__VGA_DISPLAY_SWITCH_INT_CLEAR_MASK                                                   0x00010000L
#define VGA_STATUS_CLEAR__VGA_MODE_AUTO_TRIGGER_INT_CLEAR_MASK                                                0x01000000L
//VGA_INTERRUPT_STATUS
#define VGA_INTERRUPT_STATUS__VGA_MEM_ACCESS_INT_STATUS__SHIFT                                                0x0
#define VGA_INTERRUPT_STATUS__VGA_REG_ACCESS_INT_STATUS__SHIFT                                                0x1
#define VGA_INTERRUPT_STATUS__VGA_DISPLAY_SWITCH_INT_STATUS__SHIFT                                            0x2
#define VGA_INTERRUPT_STATUS__VGA_MODE_AUTO_TRIGGER_INT_STATUS__SHIFT                                         0x3
#define VGA_INTERRUPT_STATUS__VGA_MEM_ACCESS_INT_STATUS_MASK                                                  0x00000001L
#define VGA_INTERRUPT_STATUS__VGA_REG_ACCESS_INT_STATUS_MASK                                                  0x00000002L
#define VGA_INTERRUPT_STATUS__VGA_DISPLAY_SWITCH_INT_STATUS_MASK                                              0x00000004L
#define VGA_INTERRUPT_STATUS__VGA_MODE_AUTO_TRIGGER_INT_STATUS_MASK                                           0x00000008L
//VGA_MAIN_CONTROL
#define VGA_MAIN_CONTROL__VGA_CRTC_TIMEOUT__SHIFT                                                             0x0
#define VGA_MAIN_CONTROL__VGA_RENDER_TIMEOUT_COUNT__SHIFT                                                     0x3
#define VGA_MAIN_CONTROL__VGA_VIRTUAL_VERTICAL_RETRACE_DURATION__SHIFT                                        0x5
#define VGA_MAIN_CONTROL__VGA_READBACK_VGA_VSTATUS_SOURCE_SELECT__SHIFT                                       0x8
#define VGA_MAIN_CONTROL__VGA_MC_WRITE_CLEAN_WAIT_DELAY__SHIFT                                                0xc
#define VGA_MAIN_CONTROL__VGA_READBACK_NO_DISPLAY_SOURCE_SELECT__SHIFT                                        0x10
#define VGA_MAIN_CONTROL__VGA_READBACK_CRT_INTR_SOURCE_SELECT__SHIFT                                          0x18
#define VGA_MAIN_CONTROL__VGA_READBACK_SENSE_SWITCH_SELECT__SHIFT                                             0x1a
#define VGA_MAIN_CONTROL__VGA_EXTERNAL_DAC_SENSE__SHIFT                                                       0x1d
#define VGA_MAIN_CONTROL__VGA_MAIN_TEST_VSTATUS_NO_DISPLAY_CRTC_TIMEOUT__SHIFT                                0x1f
#define VGA_MAIN_CONTROL__VGA_CRTC_TIMEOUT_MASK                                                               0x00000003L
#define VGA_MAIN_CONTROL__VGA_RENDER_TIMEOUT_COUNT_MASK                                                       0x00000018L
#define VGA_MAIN_CONTROL__VGA_VIRTUAL_VERTICAL_RETRACE_DURATION_MASK                                          0x000000E0L
#define VGA_MAIN_CONTROL__VGA_READBACK_VGA_VSTATUS_SOURCE_SELECT_MASK                                         0x00000300L
#define VGA_MAIN_CONTROL__VGA_MC_WRITE_CLEAN_WAIT_DELAY_MASK                                                  0x0000F000L
#define VGA_MAIN_CONTROL__VGA_READBACK_NO_DISPLAY_SOURCE_SELECT_MASK                                          0x00030000L
#define VGA_MAIN_CONTROL__VGA_READBACK_CRT_INTR_SOURCE_SELECT_MASK                                            0x03000000L
#define VGA_MAIN_CONTROL__VGA_READBACK_SENSE_SWITCH_SELECT_MASK                                               0x04000000L
#define VGA_MAIN_CONTROL__VGA_EXTERNAL_DAC_SENSE_MASK                                                         0x20000000L
#define VGA_MAIN_CONTROL__VGA_MAIN_TEST_VSTATUS_NO_DISPLAY_CRTC_TIMEOUT_MASK                                  0x80000000L
//VGA_TEST_CONTROL
#define VGA_TEST_CONTROL__VGA_TEST_ENABLE__SHIFT                                                              0x0
#define VGA_TEST_CONTROL__VGA_TEST_RENDER_START__SHIFT                                                        0x8
#define VGA_TEST_CONTROL__VGA_TEST_RENDER_DONE__SHIFT                                                         0x10
#define VGA_TEST_CONTROL__VGA_TEST_RENDER_DISPBUF_SELECT__SHIFT                                               0x18
#define VGA_TEST_CONTROL__VGA_TEST_ENABLE_MASK                                                                0x00000001L
#define VGA_TEST_CONTROL__VGA_TEST_RENDER_START_MASK                                                          0x00000100L
#define VGA_TEST_CONTROL__VGA_TEST_RENDER_DONE_MASK                                                           0x00010000L
#define VGA_TEST_CONTROL__VGA_TEST_RENDER_DISPBUF_SELECT_MASK                                                 0x01000000L
//VGA_QOS_CTRL
#define VGA_QOS_CTRL__VGA_READ_QOS__SHIFT                                                                     0x0
#define VGA_QOS_CTRL__VGA_WRITE_QOS__SHIFT                                                                    0x4
#define VGA_QOS_CTRL__VGA_READ_QOS_MASK                                                                       0x0000000FL
#define VGA_QOS_CTRL__VGA_WRITE_QOS_MASK                                                                      0x000000F0L
//D3VGA_CONTROL
#define D3VGA_CONTROL__D3VGA_MODE_ENABLE__SHIFT                                                               0x0
#define D3VGA_CONTROL__D3VGA_TIMING_SELECT__SHIFT                                                             0x8
#define D3VGA_CONTROL__D3VGA_SYNC_POLARITY_SELECT__SHIFT                                                      0x9
#define D3VGA_CONTROL__D3VGA_OVERSCAN_COLOR_EN__SHIFT                                                         0x10
#define D3VGA_CONTROL__D3VGA_ROTATE__SHIFT                                                                    0x18
#define D3VGA_CONTROL__D3VGA_MODE_ENABLE_MASK                                                                 0x00000001L
#define D3VGA_CONTROL__D3VGA_TIMING_SELECT_MASK                                                               0x00000100L
#define D3VGA_CONTROL__D3VGA_SYNC_POLARITY_SELECT_MASK                                                        0x00000200L
#define D3VGA_CONTROL__D3VGA_OVERSCAN_COLOR_EN_MASK                                                           0x00010000L
#define D3VGA_CONTROL__D3VGA_ROTATE_MASK                                                                      0x03000000L
//D4VGA_CONTROL
#define D4VGA_CONTROL__D4VGA_MODE_ENABLE__SHIFT                                                               0x0
#define D4VGA_CONTROL__D4VGA_TIMING_SELECT__SHIFT                                                             0x8
#define D4VGA_CONTROL__D4VGA_SYNC_POLARITY_SELECT__SHIFT                                                      0x9
#define D4VGA_CONTROL__D4VGA_OVERSCAN_COLOR_EN__SHIFT                                                         0x10
#define D4VGA_CONTROL__D4VGA_ROTATE__SHIFT                                                                    0x18
#define D4VGA_CONTROL__D4VGA_MODE_ENABLE_MASK                                                                 0x00000001L
#define D4VGA_CONTROL__D4VGA_TIMING_SELECT_MASK                                                               0x00000100L
#define D4VGA_CONTROL__D4VGA_SYNC_POLARITY_SELECT_MASK                                                        0x00000200L
#define D4VGA_CONTROL__D4VGA_OVERSCAN_COLOR_EN_MASK                                                           0x00010000L
#define D4VGA_CONTROL__D4VGA_ROTATE_MASK                                                                      0x03000000L
//D5VGA_CONTROL
#define D5VGA_CONTROL__D5VGA_MODE_ENABLE__SHIFT                                                               0x0
#define D5VGA_CONTROL__D5VGA_TIMING_SELECT__SHIFT                                                             0x8
#define D5VGA_CONTROL__D5VGA_SYNC_POLARITY_SELECT__SHIFT                                                      0x9
#define D5VGA_CONTROL__D5VGA_OVERSCAN_COLOR_EN__SHIFT                                                         0x10
#define D5VGA_CONTROL__D5VGA_ROTATE__SHIFT                                                                    0x18
#define D5VGA_CONTROL__D5VGA_MODE_ENABLE_MASK                                                                 0x00000001L
#define D5VGA_CONTROL__D5VGA_TIMING_SELECT_MASK                                                               0x00000100L
#define D5VGA_CONTROL__D5VGA_SYNC_POLARITY_SELECT_MASK                                                        0x00000200L
#define D5VGA_CONTROL__D5VGA_OVERSCAN_COLOR_EN_MASK                                                           0x00010000L
#define D5VGA_CONTROL__D5VGA_ROTATE_MASK                                                                      0x03000000L
//D6VGA_CONTROL
#define D6VGA_CONTROL__D6VGA_MODE_ENABLE__SHIFT                                                               0x0
#define D6VGA_CONTROL__D6VGA_TIMING_SELECT__SHIFT                                                             0x8
#define D6VGA_CONTROL__D6VGA_SYNC_POLARITY_SELECT__SHIFT                                                      0x9
#define D6VGA_CONTROL__D6VGA_OVERSCAN_COLOR_EN__SHIFT                                                         0x10
#define D6VGA_CONTROL__D6VGA_ROTATE__SHIFT                                                                    0x18
#define D6VGA_CONTROL__D6VGA_MODE_ENABLE_MASK                                                                 0x00000001L
#define D6VGA_CONTROL__D6VGA_TIMING_SELECT_MASK                                                               0x00000100L
#define D6VGA_CONTROL__D6VGA_SYNC_POLARITY_SELECT_MASK                                                        0x00000200L
#define D6VGA_CONTROL__D6VGA_OVERSCAN_COLOR_EN_MASK                                                           0x00010000L
#define D6VGA_CONTROL__D6VGA_ROTATE_MASK                                                                      0x03000000L
//VGA_SOURCE_SELECT
#define VGA_SOURCE_SELECT__VGA_SOURCE_SEL_A__SHIFT                                                            0x0
#define VGA_SOURCE_SELECT__VGA_SOURCE_SEL_B__SHIFT                                                            0x8
#define VGA_SOURCE_SELECT__VGA_SOURCE_SEL_A_MASK                                                              0x00000007L
#define VGA_SOURCE_SELECT__VGA_SOURCE_SEL_B_MASK                                                              0x00000700L


// addressBlock: dce_dc_dccg_dccg_dispdec
//PHYPLLA_PIXCLK_RESYNC_CNTL
#define PHYPLLA_PIXCLK_RESYNC_CNTL__PHYPLLA_PIXCLK_RESYNC_ENABLE__SHIFT                                       0x0
#define PHYPLLA_PIXCLK_RESYNC_CNTL__PHYPLLA_DCCG_DEEP_COLOR_CNTL__SHIFT                                       0x4
#define PHYPLLA_PIXCLK_RESYNC_CNTL__PHYPLLA_PIXCLK_ENABLE__SHIFT                                              0x8
#define PHYPLLA_PIXCLK_RESYNC_CNTL__PHYPLLA_PIXCLK_RESYNC_ENABLE_MASK                                         0x00000001L
#define PHYPLLA_PIXCLK_RESYNC_CNTL__PHYPLLA_DCCG_DEEP_COLOR_CNTL_MASK                                         0x00000030L
#define PHYPLLA_PIXCLK_RESYNC_CNTL__PHYPLLA_PIXCLK_ENABLE_MASK                                                0x00000100L
//PHYPLLB_PIXCLK_RESYNC_CNTL
#define PHYPLLB_PIXCLK_RESYNC_CNTL__PHYPLLB_PIXCLK_RESYNC_ENABLE__SHIFT                                       0x0
#define PHYPLLB_PIXCLK_RESYNC_CNTL__PHYPLLB_DCCG_DEEP_COLOR_CNTL__SHIFT                                       0x4
#define PHYPLLB_PIXCLK_RESYNC_CNTL__PHYPLLB_PIXCLK_ENABLE__SHIFT                                              0x8
#define PHYPLLB_PIXCLK_RESYNC_CNTL__PHYPLLB_PIXCLK_RESYNC_ENABLE_MASK                                         0x00000001L
#define PHYPLLB_PIXCLK_RESYNC_CNTL__PHYPLLB_DCCG_DEEP_COLOR_CNTL_MASK                                         0x00000030L
#define PHYPLLB_PIXCLK_RESYNC_CNTL__PHYPLLB_PIXCLK_ENABLE_MASK                                                0x00000100L
//PHYPLLC_PIXCLK_RESYNC_CNTL
#define PHYPLLC_PIXCLK_RESYNC_CNTL__PHYPLLC_PIXCLK_RESYNC_ENABLE__SHIFT                                       0x0
#define PHYPLLC_PIXCLK_RESYNC_CNTL__PHYPLLC_DCCG_DEEP_COLOR_CNTL__SHIFT                                       0x4
#define PHYPLLC_PIXCLK_RESYNC_CNTL__PHYPLLC_PIXCLK_ENABLE__SHIFT                                              0x8
#define PHYPLLC_PIXCLK_RESYNC_CNTL__PHYPLLC_PIXCLK_RESYNC_ENABLE_MASK                                         0x00000001L
#define PHYPLLC_PIXCLK_RESYNC_CNTL__PHYPLLC_DCCG_DEEP_COLOR_CNTL_MASK                                         0x00000030L
#define PHYPLLC_PIXCLK_RESYNC_CNTL__PHYPLLC_PIXCLK_ENABLE_MASK                                                0x00000100L
//PHYPLLD_PIXCLK_RESYNC_CNTL
#define PHYPLLD_PIXCLK_RESYNC_CNTL__PHYPLLD_PIXCLK_RESYNC_ENABLE__SHIFT                                       0x0
#define PHYPLLD_PIXCLK_RESYNC_CNTL__PHYPLLD_DCCG_DEEP_COLOR_CNTL__SHIFT                                       0x4
#define PHYPLLD_PIXCLK_RESYNC_CNTL__PHYPLLD_PIXCLK_ENABLE__SHIFT                                              0x8
#define PHYPLLD_PIXCLK_RESYNC_CNTL__PHYPLLD_PIXCLK_RESYNC_ENABLE_MASK                                         0x00000001L
#define PHYPLLD_PIXCLK_RESYNC_CNTL__PHYPLLD_DCCG_DEEP_COLOR_CNTL_MASK                                         0x00000030L
#define PHYPLLD_PIXCLK_RESYNC_CNTL__PHYPLLD_PIXCLK_ENABLE_MASK                                                0x00000100L
//DP_DTO_DBUF_EN
#define DP_DTO_DBUF_EN__DP_DTO0_DBUF_EN__SHIFT                                                                0x0
#define DP_DTO_DBUF_EN__DP_DTO1_DBUF_EN__SHIFT                                                                0x1
#define DP_DTO_DBUF_EN__DP_DTO2_DBUF_EN__SHIFT                                                                0x2
#define DP_DTO_DBUF_EN__DP_DTO3_DBUF_EN__SHIFT                                                                0x3
#define DP_DTO_DBUF_EN__DP_DTO4_DBUF_EN__SHIFT                                                                0x4
#define DP_DTO_DBUF_EN__DP_DTO5_DBUF_EN__SHIFT                                                                0x5
#define DP_DTO_DBUF_EN__DP_DTO6_DBUF_EN__SHIFT                                                                0x6
#define DP_DTO_DBUF_EN__DP_DTO7_DBUF_EN__SHIFT                                                                0x7
#define DP_DTO_DBUF_EN__DP_DTO0_DBUF_EN_MASK                                                                  0x00000001L
#define DP_DTO_DBUF_EN__DP_DTO1_DBUF_EN_MASK                                                                  0x00000002L
#define DP_DTO_DBUF_EN__DP_DTO2_DBUF_EN_MASK                                                                  0x00000004L
#define DP_DTO_DBUF_EN__DP_DTO3_DBUF_EN_MASK                                                                  0x00000008L
#define DP_DTO_DBUF_EN__DP_DTO4_DBUF_EN_MASK                                                                  0x00000010L
#define DP_DTO_DBUF_EN__DP_DTO5_DBUF_EN_MASK                                                                  0x00000020L
#define DP_DTO_DBUF_EN__DP_DTO6_DBUF_EN_MASK                                                                  0x00000040L
#define DP_DTO_DBUF_EN__DP_DTO7_DBUF_EN_MASK                                                                  0x00000080L
//DPREFCLK_CGTT_BLK_CTRL_REG
#define DPREFCLK_CGTT_BLK_CTRL_REG__DPREFCLK_TURN_ON_DELAY__SHIFT                                             0x0
#define DPREFCLK_CGTT_BLK_CTRL_REG__DPREFCLK_TURN_OFF_DELAY__SHIFT                                            0x4
#define DPREFCLK_CGTT_BLK_CTRL_REG__DPREFCLK_TURN_ON_DELAY_MASK                                               0x0000000FL
#define DPREFCLK_CGTT_BLK_CTRL_REG__DPREFCLK_TURN_OFF_DELAY_MASK                                              0x00000FF0L
//REFCLK_CNTL
#define REFCLK_CNTL__REFCLK_CLOCK_EN__SHIFT                                                                   0x0
#define REFCLK_CNTL__REFCLK_SRC_SEL__SHIFT                                                                    0x1
#define REFCLK_CNTL__REFCLK_CLOCK_EN_MASK                                                                     0x00000001L
#define REFCLK_CNTL__REFCLK_SRC_SEL_MASK                                                                      0x00000002L
//MIPI_CLK_CNTL
#define MIPI_CLK_CNTL__DSICLK_CLOCK_ENABLE__SHIFT                                                             0x0
#define MIPI_CLK_CNTL__BYTECLK_CLOCK_ENABLE__SHIFT                                                            0x1
#define MIPI_CLK_CNTL__ESCCLK_CLOCK_ENABLE__SHIFT                                                             0x2
#define MIPI_CLK_CNTL__DSICLK_CLOCK_ENABLE_MASK                                                               0x00000001L
#define MIPI_CLK_CNTL__BYTECLK_CLOCK_ENABLE_MASK                                                              0x00000002L
#define MIPI_CLK_CNTL__ESCCLK_CLOCK_ENABLE_MASK                                                               0x00000004L
//REFCLK_CGTT_BLK_CTRL_REG
#define REFCLK_CGTT_BLK_CTRL_REG__REFCLK_TURN_ON_DELAY__SHIFT                                                 0x0
#define REFCLK_CGTT_BLK_CTRL_REG__REFCLK_TURN_OFF_DELAY__SHIFT                                                0x4
#define REFCLK_CGTT_BLK_CTRL_REG__REFCLK_TURN_ON_DELAY_MASK                                                   0x0000000FL
#define REFCLK_CGTT_BLK_CTRL_REG__REFCLK_TURN_OFF_DELAY_MASK                                                  0x00000FF0L
//PHYPLLE_PIXCLK_RESYNC_CNTL
#define PHYPLLE_PIXCLK_RESYNC_CNTL__PHYPLLE_PIXCLK_RESYNC_ENABLE__SHIFT                                       0x0
#define PHYPLLE_PIXCLK_RESYNC_CNTL__PHYPLLE_DCCG_DEEP_COLOR_CNTL__SHIFT                                       0x4
#define PHYPLLE_PIXCLK_RESYNC_CNTL__PHYPLLE_PIXCLK_ENABLE__SHIFT                                              0x8
#define PHYPLLE_PIXCLK_RESYNC_CNTL__PHYPLLE_PIXCLK_RESYNC_ENABLE_MASK                                         0x00000001L
#define PHYPLLE_PIXCLK_RESYNC_CNTL__PHYPLLE_DCCG_DEEP_COLOR_CNTL_MASK                                         0x00000030L
#define PHYPLLE_PIXCLK_RESYNC_CNTL__PHYPLLE_PIXCLK_ENABLE_MASK                                                0x00000100L
//DCCG_PERFMON_CNTL2
#define DCCG_PERFMON_CNTL2__DCCG_PERF_DSICLK_ENABLE__SHIFT                                                    0x0
#define DCCG_PERFMON_CNTL2__DCCG_PERF_REFCLK_ENABLE__SHIFT                                                    0x1
#define DCCG_PERFMON_CNTL2__DCCG_PERF_PIXCLK1_ENABLE__SHIFT                                                   0x2
#define DCCG_PERFMON_CNTL2__DCCG_PERF_PIXCLK2_ENABLE__SHIFT                                                   0x3
#define DCCG_PERFMON_CNTL2__DCCG_PERF_UNIPHYC_PIXCLK_ENABLE__SHIFT                                            0x4
#define DCCG_PERFMON_CNTL2__DCCG_PERF_UNIPHYD_PIXCLK_ENABLE__SHIFT                                            0x5
#define DCCG_PERFMON_CNTL2__DCCG_PERF_UNIPHYE_PIXCLK_ENABLE__SHIFT                                            0x6
#define DCCG_PERFMON_CNTL2__DCCG_PERF_UNIPHYF_PIXCLK_ENABLE__SHIFT                                            0x7
#define DCCG_PERFMON_CNTL2__DCCG_PERF_UNIPHYG_PIXCLK_ENABLE__SHIFT                                            0x8
#define DCCG_PERFMON_CNTL2__DCCG_PERF_DSICLK_ENABLE_MASK                                                      0x00000001L
#define DCCG_PERFMON_CNTL2__DCCG_PERF_REFCLK_ENABLE_MASK                                                      0x00000002L
#define DCCG_PERFMON_CNTL2__DCCG_PERF_PIXCLK1_ENABLE_MASK                                                     0x00000004L
#define DCCG_PERFMON_CNTL2__DCCG_PERF_PIXCLK2_ENABLE_MASK                                                     0x00000008L
#define DCCG_PERFMON_CNTL2__DCCG_PERF_UNIPHYC_PIXCLK_ENABLE_MASK                                              0x00000010L
#define DCCG_PERFMON_CNTL2__DCCG_PERF_UNIPHYD_PIXCLK_ENABLE_MASK                                              0x00000020L
#define DCCG_PERFMON_CNTL2__DCCG_PERF_UNIPHYE_PIXCLK_ENABLE_MASK                                              0x00000040L
#define DCCG_PERFMON_CNTL2__DCCG_PERF_UNIPHYF_PIXCLK_ENABLE_MASK                                              0x00000080L
#define DCCG_PERFMON_CNTL2__DCCG_PERF_UNIPHYG_PIXCLK_ENABLE_MASK                                              0x00000100L
//DSICLK_CGTT_BLK_CTRL_REG
#define DSICLK_CGTT_BLK_CTRL_REG__DSICLK_TURN_ON_DELAY__SHIFT                                                 0x0
#define DSICLK_CGTT_BLK_CTRL_REG__DSICLK_TURN_OFF_DELAY__SHIFT                                                0x4
#define DSICLK_CGTT_BLK_CTRL_REG__DSICLK_TURN_ON_DELAY_MASK                                                   0x0000000FL
#define DSICLK_CGTT_BLK_CTRL_REG__DSICLK_TURN_OFF_DELAY_MASK                                                  0x00000FF0L
//DCCG_CBUS_WRCMD_DELAY
#define DCCG_CBUS_WRCMD_DELAY__CBUS_PLL_WRCMD_DELAY__SHIFT                                                    0x0
#define DCCG_CBUS_WRCMD_DELAY__CBUS_PLL_WRCMD_DELAY_MASK                                                      0x0000000FL
//DCCG_DS_DTO_INCR
#define DCCG_DS_DTO_INCR__DCCG_DS_DTO_INCR__SHIFT                                                             0x0
#define DCCG_DS_DTO_INCR__DCCG_DS_DTO_INCR_MASK                                                               0xFFFFFFFFL
//DCCG_DS_DTO_MODULO
#define DCCG_DS_DTO_MODULO__DCCG_DS_DTO_MODULO__SHIFT                                                         0x0
#define DCCG_DS_DTO_MODULO__DCCG_DS_DTO_MODULO_MASK                                                           0xFFFFFFFFL
//DCCG_DS_CNTL
#define DCCG_DS_CNTL__DCCG_DS_ENABLE__SHIFT                                                                   0x0
#define DCCG_DS_CNTL__DCCG_DS_REF_SRC__SHIFT                                                                  0x4
#define DCCG_DS_CNTL__DCCG_DS_HW_CAL_ENABLE__SHIFT                                                            0x8
#define DCCG_DS_CNTL__DCCG_DS_ENABLED_STATUS__SHIFT                                                           0x9
#define DCCG_DS_CNTL__DCCG_DS_XTALIN_RATE_DIV__SHIFT                                                          0x10
#define DCCG_DS_CNTL__DCCG_DS_JITTER_REMOVE_DIS__SHIFT                                                        0x18
#define DCCG_DS_CNTL__DCCG_DS_DELAY_XTAL_SEL__SHIFT                                                           0x19
#define DCCG_DS_CNTL__DCCG_DS_ENABLE_MASK                                                                     0x00000001L
#define DCCG_DS_CNTL__DCCG_DS_REF_SRC_MASK                                                                    0x00000030L
#define DCCG_DS_CNTL__DCCG_DS_HW_CAL_ENABLE_MASK                                                              0x00000100L
#define DCCG_DS_CNTL__DCCG_DS_ENABLED_STATUS_MASK                                                             0x00000200L
#define DCCG_DS_CNTL__DCCG_DS_XTALIN_RATE_DIV_MASK                                                            0x00030000L
#define DCCG_DS_CNTL__DCCG_DS_JITTER_REMOVE_DIS_MASK                                                          0x01000000L
#define DCCG_DS_CNTL__DCCG_DS_DELAY_XTAL_SEL_MASK                                                             0x02000000L
//DCCG_DS_HW_CAL_INTERVAL
#define DCCG_DS_HW_CAL_INTERVAL__DCCG_DS_HW_CAL_INTERVAL__SHIFT                                               0x0
#define DCCG_DS_HW_CAL_INTERVAL__DCCG_DS_HW_CAL_INTERVAL_MASK                                                 0xFFFFFFFFL
//SYMCLKG_CLOCK_ENABLE
#define SYMCLKG_CLOCK_ENABLE__SYMCLKG_CLOCK_ENABLE__SHIFT                                                     0x0
#define SYMCLKG_CLOCK_ENABLE__SYMCLKG_FE_FORCE_EN__SHIFT                                                      0x4
#define SYMCLKG_CLOCK_ENABLE__SYMCLKG_FE_FORCE_SRC__SHIFT                                                     0x8
#define SYMCLKG_CLOCK_ENABLE__SYMCLKG_CLOCK_ENABLE_MASK                                                       0x00000001L
#define SYMCLKG_CLOCK_ENABLE__SYMCLKG_FE_FORCE_EN_MASK                                                        0x00000010L
#define SYMCLKG_CLOCK_ENABLE__SYMCLKG_FE_FORCE_SRC_MASK                                                       0x00000700L
//DPREFCLK_CNTL
#define DPREFCLK_CNTL__DPREFCLK_SRC_SEL__SHIFT                                                                0x0
#define DPREFCLK_CNTL__UNB_DB_CLK_ENABLE__SHIFT                                                               0x8
#define DPREFCLK_CNTL__DPREFCLK_SRC_SEL_MASK                                                                  0x00000007L
#define DPREFCLK_CNTL__UNB_DB_CLK_ENABLE_MASK                                                                 0x00000100L
//AOMCLK0_CNTL
#define AOMCLK0_CNTL__AOMCLK0_CLOCK_EN__SHIFT                                                                 0x0
#define AOMCLK0_CNTL__AOMCLK0_CLOCK_EN_MASK                                                                   0x00000001L
//AOMCLK1_CNTL
#define AOMCLK1_CNTL__AOMCLK1_CLOCK_EN__SHIFT                                                                 0x0
#define AOMCLK1_CNTL__AOMCLK1_CLOCK_EN_MASK                                                                   0x00000001L
//AOMCLK2_CNTL
#define AOMCLK2_CNTL__AOMCLK2_CLOCK_EN__SHIFT                                                                 0x0
#define AOMCLK2_CNTL__AOMCLK2_CLOCK_EN_MASK                                                                   0x00000001L
//DCCG_AUDIO_DTO2_PHASE
#define DCCG_AUDIO_DTO2_PHASE__DCCG_AUDIO_DTO2_PHASE__SHIFT                                                   0x0
#define DCCG_AUDIO_DTO2_PHASE__DCCG_AUDIO_DTO2_PHASE_MASK                                                     0xFFFFFFFFL
//DCCG_AUDIO_DTO2_MODULO
#define DCCG_AUDIO_DTO2_MODULO__DCCG_AUDIO_DTO2_MODULO__SHIFT                                                 0x0
#define DCCG_AUDIO_DTO2_MODULO__DCCG_AUDIO_DTO2_MODULO_MASK                                                   0xFFFFFFFFL
//DCE_VERSION
#define DCE_VERSION__MAJOR_VERSION__SHIFT                                                                     0x0
#define DCE_VERSION__MINOR_VERSION__SHIFT                                                                     0x8
#define DCE_VERSION__MAJOR_VERSION_MASK                                                                       0x000000FFL
#define DCE_VERSION__MINOR_VERSION_MASK                                                                       0x0000FF00L
//PHYPLLG_PIXCLK_RESYNC_CNTL
#define PHYPLLG_PIXCLK_RESYNC_CNTL__PHYPLLG_PIXCLK_RESYNC_ENABLE__SHIFT                                       0x0
#define PHYPLLG_PIXCLK_RESYNC_CNTL__PHYPLLG_DCCG_DEEP_COLOR_CNTL__SHIFT                                       0x4
#define PHYPLLG_PIXCLK_RESYNC_CNTL__PHYPLLG_PIXCLK_ENABLE__SHIFT                                              0x8
#define PHYPLLG_PIXCLK_RESYNC_CNTL__PHYPLLG_PIXCLK_RESYNC_ENABLE_MASK                                         0x00000001L
#define PHYPLLG_PIXCLK_RESYNC_CNTL__PHYPLLG_DCCG_DEEP_COLOR_CNTL_MASK                                         0x00000030L
#define PHYPLLG_PIXCLK_RESYNC_CNTL__PHYPLLG_PIXCLK_ENABLE_MASK                                                0x00000100L
//DCCG_GTC_CNTL
#define DCCG_GTC_CNTL__DCCG_GTC_ENABLE__SHIFT                                                                 0x0
#define DCCG_GTC_CNTL__DCCG_GTC_ENABLE_MASK                                                                   0x00000001L
//DCCG_GTC_DTO_INCR
#define DCCG_GTC_DTO_INCR__DCCG_GTC_DTO_INCR__SHIFT                                                           0x0
#define DCCG_GTC_DTO_INCR__DCCG_GTC_DTO_INCR_MASK                                                             0xFFFFFFFFL
//DCCG_GTC_DTO_MODULO
#define DCCG_GTC_DTO_MODULO__DCCG_GTC_DTO_MODULO__SHIFT                                                       0x0
#define DCCG_GTC_DTO_MODULO__DCCG_GTC_DTO_MODULO_MASK                                                         0xFFFFFFFFL
//DCCG_GTC_CURRENT
#define DCCG_GTC_CURRENT__DCCG_GTC_CURRENT__SHIFT                                                             0x0
#define DCCG_GTC_CURRENT__DCCG_GTC_CURRENT_MASK                                                               0xFFFFFFFFL
//MIPI_DTO_CNTL
#define MIPI_DTO_CNTL__MIPI_DTO_ENABLE__SHIFT                                                                 0x0
#define MIPI_DTO_CNTL__MIPI_DTO_ENABLE_MASK                                                                   0x00000001L
//MIPI_DTO_PHASE
#define MIPI_DTO_PHASE__MIPI_DTO_PHASE__SHIFT                                                                 0x0
#define MIPI_DTO_PHASE__MIPI_DTO_PHASE_MASK                                                                   0xFFFFFFFFL
//MIPI_DTO_MODULO
#define MIPI_DTO_MODULO__MIPI_DTO_MODULO__SHIFT                                                               0x0
#define MIPI_DTO_MODULO__MIPI_DTO_MODULO_MASK                                                                 0xFFFFFFFFL
//DAC_CLK_ENABLE
#define DAC_CLK_ENABLE__DACA_CLK_ENABLE__SHIFT                                                                0x0
#define DAC_CLK_ENABLE__DACA_CLK_ENABLE_MASK                                                                  0x00000001L
//DVO_CLK_ENABLE
#define DVO_CLK_ENABLE__DVO_CLK_ENABLE__SHIFT                                                                 0x0
#define DVO_CLK_ENABLE__DVO_CLK_ENABLE_MASK                                                                   0x00000001L
//AVSYNC_COUNTER_WRITE
#define AVSYNC_COUNTER_WRITE__AVSYNC_COUNTER_WRVALUE__SHIFT                                                   0x0
#define AVSYNC_COUNTER_WRITE__AVSYNC_COUNTER_WRVALUE_MASK                                                     0xFFFFFFFFL
//AVSYNC_COUNTER_CONTROL
#define AVSYNC_COUNTER_CONTROL__AVSYNC_COUNTER_ENABLE__SHIFT                                                  0x0
#define AVSYNC_COUNTER_CONTROL__AVSYNC_COUNTER_ENABLE_MASK                                                    0x00000001L
//AVSYNC_COUNTER_READ
#define AVSYNC_COUNTER_READ__AVSYNC_COUNTER_RDVALUE__SHIFT                                                    0x0
#define AVSYNC_COUNTER_READ__AVSYNC_COUNTER_RDVALUE_MASK                                                      0xFFFFFFFFL
//MILLISECOND_TIME_BASE_DIV
#define MILLISECOND_TIME_BASE_DIV__MILLISECOND_TIME_BASE_DIV__SHIFT                                           0x0
#define MILLISECOND_TIME_BASE_DIV__MILLISECOND_TIME_BASE_CLOCK_SOURCE_SEL__SHIFT                              0x14
#define MILLISECOND_TIME_BASE_DIV__MILLISECOND_TIME_BASE_DIV_MASK                                             0x0001FFFFL
#define MILLISECOND_TIME_BASE_DIV__MILLISECOND_TIME_BASE_CLOCK_SOURCE_SEL_MASK                                0x00100000L
//DISPCLK_FREQ_CHANGE_CNTL
#define DISPCLK_FREQ_CHANGE_CNTL__DISPCLK_STEP_DELAY__SHIFT                                                   0x0
#define DISPCLK_FREQ_CHANGE_CNTL__DISPCLK_STEP_SIZE__SHIFT                                                    0x10
#define DISPCLK_FREQ_CHANGE_CNTL__DISPCLK_FREQ_RAMP_DONE__SHIFT                                               0x14
#define DISPCLK_FREQ_CHANGE_CNTL__DISPCLK_MAX_ERRDET_CYCLES__SHIFT                                            0x19
#define DISPCLK_FREQ_CHANGE_CNTL__DCCG_FIFO_ERRDET_RESET__SHIFT                                               0x1c
#define DISPCLK_FREQ_CHANGE_CNTL__DCCG_FIFO_ERRDET_STATE__SHIFT                                               0x1d
#define DISPCLK_FREQ_CHANGE_CNTL__DCCG_FIFO_ERRDET_OVR_EN__SHIFT                                              0x1e
#define DISPCLK_FREQ_CHANGE_CNTL__DISPCLK_CHG_FWD_CORR_DISABLE__SHIFT                                         0x1f
#define DISPCLK_FREQ_CHANGE_CNTL__DISPCLK_STEP_DELAY_MASK                                                     0x00003FFFL
#define DISPCLK_FREQ_CHANGE_CNTL__DISPCLK_STEP_SIZE_MASK                                                      0x000F0000L
#define DISPCLK_FREQ_CHANGE_CNTL__DISPCLK_FREQ_RAMP_DONE_MASK                                                 0x00100000L
#define DISPCLK_FREQ_CHANGE_CNTL__DISPCLK_MAX_ERRDET_CYCLES_MASK                                              0x0E000000L
#define DISPCLK_FREQ_CHANGE_CNTL__DCCG_FIFO_ERRDET_RESET_MASK                                                 0x10000000L
#define DISPCLK_FREQ_CHANGE_CNTL__DCCG_FIFO_ERRDET_STATE_MASK                                                 0x20000000L
#define DISPCLK_FREQ_CHANGE_CNTL__DCCG_FIFO_ERRDET_OVR_EN_MASK                                                0x40000000L
#define DISPCLK_FREQ_CHANGE_CNTL__DISPCLK_CHG_FWD_CORR_DISABLE_MASK                                           0x80000000L
//DC_MEM_GLOBAL_PWR_REQ_CNTL
#define DC_MEM_GLOBAL_PWR_REQ_CNTL__DC_MEM_GLOBAL_PWR_REQ_DIS__SHIFT                                          0x0
#define DC_MEM_GLOBAL_PWR_REQ_CNTL__DC_MEM_GLOBAL_PWR_REQ_DIS_MASK                                            0x00000001L
//DCCG_PERFMON_CNTL
#define DCCG_PERFMON_CNTL__DCCG_PERF_DISPCLK_ENABLE__SHIFT                                                    0x0
#define DCCG_PERFMON_CNTL__DCCG_PERF_DPREFCLK_ENABLE__SHIFT                                                   0x1
#define DCCG_PERFMON_CNTL__DCCG_PERF_UNIPHYA_PIXCLK_ENABLE__SHIFT                                             0x2
#define DCCG_PERFMON_CNTL__DCCG_PERF_UNIPHYB_PIXCLK_ENABLE__SHIFT                                             0x3
#define DCCG_PERFMON_CNTL__DCCG_PERF_PIXCLK0_ENABLE__SHIFT                                                    0x4
#define DCCG_PERFMON_CNTL__DCCG_PERF_RUN__SHIFT                                                               0x5
#define DCCG_PERFMON_CNTL__DCCG_PERF_MODE_VSYNC__SHIFT                                                        0x6
#define DCCG_PERFMON_CNTL__DCCG_PERF_MODE_HSYNC__SHIFT                                                        0x7
#define DCCG_PERFMON_CNTL__DCCG_PERF_OTG_SEL__SHIFT                                                           0x8
#define DCCG_PERFMON_CNTL__DCCG_PERF_XTALIN_PULSE_DIV__SHIFT                                                  0xb
#define DCCG_PERFMON_CNTL__DCCG_PERF_DISPCLK_ENABLE_MASK                                                      0x00000001L
#define DCCG_PERFMON_CNTL__DCCG_PERF_DPREFCLK_ENABLE_MASK                                                     0x00000002L
#define DCCG_PERFMON_CNTL__DCCG_PERF_UNIPHYA_PIXCLK_ENABLE_MASK                                               0x00000004L
#define DCCG_PERFMON_CNTL__DCCG_PERF_UNIPHYB_PIXCLK_ENABLE_MASK                                               0x00000008L
#define DCCG_PERFMON_CNTL__DCCG_PERF_PIXCLK0_ENABLE_MASK                                                      0x00000010L
#define DCCG_PERFMON_CNTL__DCCG_PERF_RUN_MASK                                                                 0x00000020L
#define DCCG_PERFMON_CNTL__DCCG_PERF_MODE_VSYNC_MASK                                                          0x00000040L
#define DCCG_PERFMON_CNTL__DCCG_PERF_MODE_HSYNC_MASK                                                          0x00000080L
#define DCCG_PERFMON_CNTL__DCCG_PERF_OTG_SEL_MASK                                                             0x00000700L
#define DCCG_PERFMON_CNTL__DCCG_PERF_XTALIN_PULSE_DIV_MASK                                                    0xFFFFF800L
//DCCG_GATE_DISABLE_CNTL
#define DCCG_GATE_DISABLE_CNTL__DISPCLK_DCCG_GATE_DISABLE__SHIFT                                              0x0
#define DCCG_GATE_DISABLE_CNTL__DISPCLK_R_DCCG_GATE_DISABLE__SHIFT                                            0x1
#define DCCG_GATE_DISABLE_CNTL__SOCCLK_GATE_DISABLE__SHIFT                                                    0x2
#define DCCG_GATE_DISABLE_CNTL__DPREFCLK_GATE_DISABLE__SHIFT                                                  0x3
#define DCCG_GATE_DISABLE_CNTL__DACACLK_GATE_DISABLE__SHIFT                                                   0x4
#define DCCG_GATE_DISABLE_CNTL__DVOACLK_GATE_DISABLE__SHIFT                                                   0x6
#define DCCG_GATE_DISABLE_CNTL__DPREFCLK_R_DCCG_GATE_DISABLE__SHIFT                                           0x8
#define DCCG_GATE_DISABLE_CNTL__DPPCLK_GATE_DISABLE__SHIFT                                                    0x9
#define DCCG_GATE_DISABLE_CNTL__AOMCLK0_GATE_DISABLE__SHIFT                                                   0x11
#define DCCG_GATE_DISABLE_CNTL__AOMCLK1_GATE_DISABLE__SHIFT                                                   0x12
#define DCCG_GATE_DISABLE_CNTL__AOMCLK2_GATE_DISABLE__SHIFT                                                   0x13
#define DCCG_GATE_DISABLE_CNTL__AUDIO_DTO2_CLK_GATE_DISABLE__SHIFT                                            0x15
#define DCCG_GATE_DISABLE_CNTL__DPREFCLK_GTC_GATE_DISABLE__SHIFT                                              0x16
#define DCCG_GATE_DISABLE_CNTL__UNB_DB_CLK_GATE_DISABLE__SHIFT                                                0x17
#define DCCG_GATE_DISABLE_CNTL__REFCLK_GATE_DISABLE__SHIFT                                                    0x1a
#define DCCG_GATE_DISABLE_CNTL__REFCLK_R_DIG_GATE_DISABLE__SHIFT                                              0x1b
#define DCCG_GATE_DISABLE_CNTL__DSICLK_GATE_DISABLE__SHIFT                                                    0x1c
#define DCCG_GATE_DISABLE_CNTL__BYTECLK_GATE_DISABLE__SHIFT                                                   0x1d
#define DCCG_GATE_DISABLE_CNTL__ESCCLK_GATE_DISABLE__SHIFT                                                    0x1e
#define DCCG_GATE_DISABLE_CNTL__DISPCLK_DCCG_GATE_DISABLE_MASK                                                0x00000001L
#define DCCG_GATE_DISABLE_CNTL__DISPCLK_R_DCCG_GATE_DISABLE_MASK                                              0x00000002L
#define DCCG_GATE_DISABLE_CNTL__SOCCLK_GATE_DISABLE_MASK                                                      0x00000004L
#define DCCG_GATE_DISABLE_CNTL__DPREFCLK_GATE_DISABLE_MASK                                                    0x00000008L
#define DCCG_GATE_DISABLE_CNTL__DACACLK_GATE_DISABLE_MASK                                                     0x00000010L
#define DCCG_GATE_DISABLE_CNTL__DVOACLK_GATE_DISABLE_MASK                                                     0x00000040L
#define DCCG_GATE_DISABLE_CNTL__DPREFCLK_R_DCCG_GATE_DISABLE_MASK                                             0x00000100L
#define DCCG_GATE_DISABLE_CNTL__DPPCLK_GATE_DISABLE_MASK                                                      0x00000200L
#define DCCG_GATE_DISABLE_CNTL__AOMCLK0_GATE_DISABLE_MASK                                                     0x00020000L
#define DCCG_GATE_DISABLE_CNTL__AOMCLK1_GATE_DISABLE_MASK                                                     0x00040000L
#define DCCG_GATE_DISABLE_CNTL__AOMCLK2_GATE_DISABLE_MASK                                                     0x00080000L
#define DCCG_GATE_DISABLE_CNTL__AUDIO_DTO2_CLK_GATE_DISABLE_MASK                                              0x00200000L
#define DCCG_GATE_DISABLE_CNTL__DPREFCLK_GTC_GATE_DISABLE_MASK                                                0x00400000L
#define DCCG_GATE_DISABLE_CNTL__UNB_DB_CLK_GATE_DISABLE_MASK                                                  0x00800000L
#define DCCG_GATE_DISABLE_CNTL__REFCLK_GATE_DISABLE_MASK                                                      0x04000000L
#define DCCG_GATE_DISABLE_CNTL__REFCLK_R_DIG_GATE_DISABLE_MASK                                                0x08000000L
#define DCCG_GATE_DISABLE_CNTL__DSICLK_GATE_DISABLE_MASK                                                      0x10000000L
#define DCCG_GATE_DISABLE_CNTL__BYTECLK_GATE_DISABLE_MASK                                                     0x20000000L
#define DCCG_GATE_DISABLE_CNTL__ESCCLK_GATE_DISABLE_MASK                                                      0x40000000L
//DISPCLK_CGTT_BLK_CTRL_REG
#define DISPCLK_CGTT_BLK_CTRL_REG__DISPCLK_TURN_ON_DELAY__SHIFT                                               0x0
#define DISPCLK_CGTT_BLK_CTRL_REG__DISPCLK_TURN_OFF_DELAY__SHIFT                                              0x4
#define DISPCLK_CGTT_BLK_CTRL_REG__DISPCLK_TURN_ON_DELAY_MASK                                                 0x0000000FL
#define DISPCLK_CGTT_BLK_CTRL_REG__DISPCLK_TURN_OFF_DELAY_MASK                                                0x00000FF0L
//SOCCLK_CGTT_BLK_CTRL_REG
#define SOCCLK_CGTT_BLK_CTRL_REG__SOCCLK_TURN_ON_DELAY__SHIFT                                                 0x0
#define SOCCLK_CGTT_BLK_CTRL_REG__SOCCLK_TURN_OFF_DELAY__SHIFT                                                0x4
#define SOCCLK_CGTT_BLK_CTRL_REG__SOCCLK_TURN_ON_DELAY_MASK                                                   0x0000000FL
#define SOCCLK_CGTT_BLK_CTRL_REG__SOCCLK_TURN_OFF_DELAY_MASK                                                  0x00000FF0L
//DCCG_CAC_STATUS
#define DCCG_CAC_STATUS__CAC_STATUS_RDDATA__SHIFT                                                             0x0
#define DCCG_CAC_STATUS__CAC_STATUS_RDDATA_MASK                                                               0xFFFFFFFFL
//PIXCLK1_RESYNC_CNTL
#define PIXCLK1_RESYNC_CNTL__PIXCLK1_RESYNC_ENABLE__SHIFT                                                     0x0
#define PIXCLK1_RESYNC_CNTL__DCCG_DEEP_COLOR_CNTL1__SHIFT                                                     0x4
#define PIXCLK1_RESYNC_CNTL__PIXCLK1_RESYNC_ENABLE_MASK                                                       0x00000001L
#define PIXCLK1_RESYNC_CNTL__DCCG_DEEP_COLOR_CNTL1_MASK                                                       0x00000030L
//PIXCLK2_RESYNC_CNTL
#define PIXCLK2_RESYNC_CNTL__PIXCLK2_RESYNC_ENABLE__SHIFT                                                     0x0
#define PIXCLK2_RESYNC_CNTL__DCCG_DEEP_COLOR_CNTL2__SHIFT                                                     0x4
#define PIXCLK2_RESYNC_CNTL__PIXCLK2_RESYNC_ENABLE_MASK                                                       0x00000001L
#define PIXCLK2_RESYNC_CNTL__DCCG_DEEP_COLOR_CNTL2_MASK                                                       0x00000030L
//PIXCLK0_RESYNC_CNTL
#define PIXCLK0_RESYNC_CNTL__PIXCLK0_RESYNC_ENABLE__SHIFT                                                     0x0
#define PIXCLK0_RESYNC_CNTL__DCCG_DEEP_COLOR_CNTL0__SHIFT                                                     0x4
#define PIXCLK0_RESYNC_CNTL__PIXCLK0_RESYNC_ENABLE_MASK                                                       0x00000001L
#define PIXCLK0_RESYNC_CNTL__DCCG_DEEP_COLOR_CNTL0_MASK                                                       0x00000030L
//MICROSECOND_TIME_BASE_DIV
#define MICROSECOND_TIME_BASE_DIV__MICROSECOND_TIME_BASE_DIV__SHIFT                                           0x0
#define MICROSECOND_TIME_BASE_DIV__XTAL_REF_DIV__SHIFT                                                        0x8
#define MICROSECOND_TIME_BASE_DIV__XTAL_REF_SEL__SHIFT                                                        0x10
#define MICROSECOND_TIME_BASE_DIV__XTAL_REF_CLOCK_SOURCE_SEL__SHIFT                                           0x11
#define MICROSECOND_TIME_BASE_DIV__MICROSECOND_TIME_BASE_CLOCK_SOURCE_SEL__SHIFT                              0x14
#define MICROSECOND_TIME_BASE_DIV__MICROSECOND_TIME_BASE_DIV_MASK                                             0x0000007FL
#define MICROSECOND_TIME_BASE_DIV__XTAL_REF_DIV_MASK                                                          0x00007F00L
#define MICROSECOND_TIME_BASE_DIV__XTAL_REF_SEL_MASK                                                          0x00010000L
#define MICROSECOND_TIME_BASE_DIV__XTAL_REF_CLOCK_SOURCE_SEL_MASK                                             0x00020000L
#define MICROSECOND_TIME_BASE_DIV__MICROSECOND_TIME_BASE_CLOCK_SOURCE_SEL_MASK                                0x00100000L
//DCCG_GATE_DISABLE_CNTL2
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKA_FE_GATE_DISABLE__SHIFT                                               0x0
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKB_FE_GATE_DISABLE__SHIFT                                               0x1
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKC_FE_GATE_DISABLE__SHIFT                                               0x2
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKD_FE_GATE_DISABLE__SHIFT                                               0x3
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKE_FE_GATE_DISABLE__SHIFT                                               0x4
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKF_FE_GATE_DISABLE__SHIFT                                               0x5
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKG_FE_GATE_DISABLE__SHIFT                                               0x6
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKA_GATE_DISABLE__SHIFT                                                  0x10
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKB_GATE_DISABLE__SHIFT                                                  0x11
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKC_GATE_DISABLE__SHIFT                                                  0x12
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKD_GATE_DISABLE__SHIFT                                                  0x13
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKE_GATE_DISABLE__SHIFT                                                  0x14
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKF_GATE_DISABLE__SHIFT                                                  0x15
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKG_GATE_DISABLE__SHIFT                                                  0x16
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKA_FE_GATE_DISABLE_MASK                                                 0x00000001L
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKB_FE_GATE_DISABLE_MASK                                                 0x00000002L
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKC_FE_GATE_DISABLE_MASK                                                 0x00000004L
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKD_FE_GATE_DISABLE_MASK                                                 0x00000008L
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKE_FE_GATE_DISABLE_MASK                                                 0x00000010L
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKF_FE_GATE_DISABLE_MASK                                                 0x00000020L
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKG_FE_GATE_DISABLE_MASK                                                 0x00000040L
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKA_GATE_DISABLE_MASK                                                    0x00010000L
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKB_GATE_DISABLE_MASK                                                    0x00020000L
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKC_GATE_DISABLE_MASK                                                    0x00040000L
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKD_GATE_DISABLE_MASK                                                    0x00080000L
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKE_GATE_DISABLE_MASK                                                    0x00100000L
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKF_GATE_DISABLE_MASK                                                    0x00200000L
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKG_GATE_DISABLE_MASK                                                    0x00400000L
//SYMCLK_CGTT_BLK_CTRL_REG
#define SYMCLK_CGTT_BLK_CTRL_REG__SYMCLK_TURN_ON_DELAY__SHIFT                                                 0x0
#define SYMCLK_CGTT_BLK_CTRL_REG__SYMCLK_TURN_OFF_DELAY__SHIFT                                                0x4
#define SYMCLK_CGTT_BLK_CTRL_REG__SYMCLK_TURN_ON_DELAY_MASK                                                   0x0000000FL
#define SYMCLK_CGTT_BLK_CTRL_REG__SYMCLK_TURN_OFF_DELAY_MASK                                                  0x00000FF0L
//PHYPLLF_PIXCLK_RESYNC_CNTL
#define PHYPLLF_PIXCLK_RESYNC_CNTL__PHYPLLF_PIXCLK_RESYNC_ENABLE__SHIFT                                       0x0
#define PHYPLLF_PIXCLK_RESYNC_CNTL__PHYPLLF_DCCG_DEEP_COLOR_CNTL__SHIFT                                       0x4
#define PHYPLLF_PIXCLK_RESYNC_CNTL__PHYPLLF_PIXCLK_ENABLE__SHIFT                                              0x8
#define PHYPLLF_PIXCLK_RESYNC_CNTL__PHYPLLF_PIXCLK_RESYNC_ENABLE_MASK                                         0x00000001L
#define PHYPLLF_PIXCLK_RESYNC_CNTL__PHYPLLF_DCCG_DEEP_COLOR_CNTL_MASK                                         0x00000030L
#define PHYPLLF_PIXCLK_RESYNC_CNTL__PHYPLLF_PIXCLK_ENABLE_MASK                                                0x00000100L
//DCCG_DISP_CNTL_REG
#define DCCG_DISP_CNTL_REG__ALLOW_SR_ON_TRANS_REQ__SHIFT                                                      0x8
#define DCCG_DISP_CNTL_REG__ALLOW_SR_ON_TRANS_REQ_MASK                                                        0x00000100L
//OTG0_PIXEL_RATE_CNTL
#define OTG0_PIXEL_RATE_CNTL__OTG0_PIXEL_RATE_SOURCE__SHIFT                                                   0x0
#define OTG0_PIXEL_RATE_CNTL__DP_DTO0_ENABLE__SHIFT                                                           0x4
#define OTG0_PIXEL_RATE_CNTL__DP_DTO0_DS_DISABLE__SHIFT                                                       0x5
#define OTG0_PIXEL_RATE_CNTL__OTG0_ADD_PIXEL__SHIFT                                                           0x8
#define OTG0_PIXEL_RATE_CNTL__OTG0_DROP_PIXEL__SHIFT                                                          0x9
#define OTG0_PIXEL_RATE_CNTL__OTG0_DISPOUT_FIFO_ERROR__SHIFT                                                  0xe
#define OTG0_PIXEL_RATE_CNTL__OTG0_DISPOUT_ERROR_COUNT__SHIFT                                                 0x10
#define OTG0_PIXEL_RATE_CNTL__OTG0_PIXEL_RATE_SOURCE_MASK                                                     0x00000003L
#define OTG0_PIXEL_RATE_CNTL__DP_DTO0_ENABLE_MASK                                                             0x00000010L
#define OTG0_PIXEL_RATE_CNTL__DP_DTO0_DS_DISABLE_MASK                                                         0x00000020L
#define OTG0_PIXEL_RATE_CNTL__OTG0_ADD_PIXEL_MASK                                                             0x00000100L
#define OTG0_PIXEL_RATE_CNTL__OTG0_DROP_PIXEL_MASK                                                            0x00000200L
#define OTG0_PIXEL_RATE_CNTL__OTG0_DISPOUT_FIFO_ERROR_MASK                                                    0x0000C000L
#define OTG0_PIXEL_RATE_CNTL__OTG0_DISPOUT_ERROR_COUNT_MASK                                                   0x0FFF0000L
//DP_DTO0_PHASE
#define DP_DTO0_PHASE__DP_DTO0_PHASE__SHIFT                                                                   0x0
#define DP_DTO0_PHASE__DP_DTO0_PHASE_MASK                                                                     0xFFFFFFFFL
//DP_DTO0_MODULO
#define DP_DTO0_MODULO__DP_DTO0_MODULO__SHIFT                                                                 0x0
#define DP_DTO0_MODULO__DP_DTO0_MODULO_MASK                                                                   0xFFFFFFFFL
//OTG0_PHYPLL_PIXEL_RATE_CNTL
#define OTG0_PHYPLL_PIXEL_RATE_CNTL__OTG0_PHYPLL_PIXEL_RATE_SOURCE__SHIFT                                     0x0
#define OTG0_PHYPLL_PIXEL_RATE_CNTL__OTG0_PIXEL_RATE_PLL_SOURCE__SHIFT                                        0x4
#define OTG0_PHYPLL_PIXEL_RATE_CNTL__OTG0_PHYPLL_PIXEL_RATE_SOURCE_MASK                                       0x00000007L
#define OTG0_PHYPLL_PIXEL_RATE_CNTL__OTG0_PIXEL_RATE_PLL_SOURCE_MASK                                          0x00000010L
//OTG1_PIXEL_RATE_CNTL
#define OTG1_PIXEL_RATE_CNTL__OTG1_PIXEL_RATE_SOURCE__SHIFT                                                   0x0
#define OTG1_PIXEL_RATE_CNTL__DP_DTO1_ENABLE__SHIFT                                                           0x4
#define OTG1_PIXEL_RATE_CNTL__DP_DTO1_DS_DISABLE__SHIFT                                                       0x5
#define OTG1_PIXEL_RATE_CNTL__OTG1_ADD_PIXEL__SHIFT                                                           0x8
#define OTG1_PIXEL_RATE_CNTL__OTG1_DROP_PIXEL__SHIFT                                                          0x9
#define OTG1_PIXEL_RATE_CNTL__OTG1_DISPOUT_FIFO_ERROR__SHIFT                                                  0xe
#define OTG1_PIXEL_RATE_CNTL__OTG1_DISPOUT_ERROR_COUNT__SHIFT                                                 0x10
#define OTG1_PIXEL_RATE_CNTL__OTG1_PIXEL_RATE_SOURCE_MASK                                                     0x00000003L
#define OTG1_PIXEL_RATE_CNTL__DP_DTO1_ENABLE_MASK                                                             0x00000010L
#define OTG1_PIXEL_RATE_CNTL__DP_DTO1_DS_DISABLE_MASK                                                         0x00000020L
#define OTG1_PIXEL_RATE_CNTL__OTG1_ADD_PIXEL_MASK                                                             0x00000100L
#define OTG1_PIXEL_RATE_CNTL__OTG1_DROP_PIXEL_MASK                                                            0x00000200L
#define OTG1_PIXEL_RATE_CNTL__OTG1_DISPOUT_FIFO_ERROR_MASK                                                    0x0000C000L
#define OTG1_PIXEL_RATE_CNTL__OTG1_DISPOUT_ERROR_COUNT_MASK                                                   0x0FFF0000L
//DP_DTO1_PHASE
#define DP_DTO1_PHASE__DP_DTO1_PHASE__SHIFT                                                                   0x0
#define DP_DTO1_PHASE__DP_DTO1_PHASE_MASK                                                                     0xFFFFFFFFL
//DP_DTO1_MODULO
#define DP_DTO1_MODULO__DP_DTO1_MODULO__SHIFT                                                                 0x0
#define DP_DTO1_MODULO__DP_DTO1_MODULO_MASK                                                                   0xFFFFFFFFL
//OTG1_PHYPLL_PIXEL_RATE_CNTL
#define OTG1_PHYPLL_PIXEL_RATE_CNTL__OTG1_PHYPLL_PIXEL_RATE_SOURCE__SHIFT                                     0x0
#define OTG1_PHYPLL_PIXEL_RATE_CNTL__OTG1_PIXEL_RATE_PLL_SOURCE__SHIFT                                        0x4
#define OTG1_PHYPLL_PIXEL_RATE_CNTL__OTG1_PHYPLL_PIXEL_RATE_SOURCE_MASK                                       0x00000007L
#define OTG1_PHYPLL_PIXEL_RATE_CNTL__OTG1_PIXEL_RATE_PLL_SOURCE_MASK                                          0x00000010L
//OTG2_PIXEL_RATE_CNTL
#define OTG2_PIXEL_RATE_CNTL__OTG2_PIXEL_RATE_SOURCE__SHIFT                                                   0x0
#define OTG2_PIXEL_RATE_CNTL__DP_DTO2_ENABLE__SHIFT                                                           0x4
#define OTG2_PIXEL_RATE_CNTL__DP_DTO2_DS_DISABLE__SHIFT                                                       0x5
#define OTG2_PIXEL_RATE_CNTL__OTG2_ADD_PIXEL__SHIFT                                                           0x8
#define OTG2_PIXEL_RATE_CNTL__OTG2_DROP_PIXEL__SHIFT                                                          0x9
#define OTG2_PIXEL_RATE_CNTL__OTG2_DISPOUT_FIFO_ERROR__SHIFT                                                  0xe
#define OTG2_PIXEL_RATE_CNTL__OTG2_DISPOUT_ERROR_COUNT__SHIFT                                                 0x10
#define OTG2_PIXEL_RATE_CNTL__OTG2_PIXEL_RATE_SOURCE_MASK                                                     0x00000003L
#define OTG2_PIXEL_RATE_CNTL__DP_DTO2_ENABLE_MASK                                                             0x00000010L
#define OTG2_PIXEL_RATE_CNTL__DP_DTO2_DS_DISABLE_MASK                                                         0x00000020L
#define OTG2_PIXEL_RATE_CNTL__OTG2_ADD_PIXEL_MASK                                                             0x00000100L
#define OTG2_PIXEL_RATE_CNTL__OTG2_DROP_PIXEL_MASK                                                            0x00000200L
#define OTG2_PIXEL_RATE_CNTL__OTG2_DISPOUT_FIFO_ERROR_MASK                                                    0x0000C000L
#define OTG2_PIXEL_RATE_CNTL__OTG2_DISPOUT_ERROR_COUNT_MASK                                                   0x0FFF0000L
//DP_DTO2_PHASE
#define DP_DTO2_PHASE__DP_DTO2_PHASE__SHIFT                                                                   0x0
#define DP_DTO2_PHASE__DP_DTO2_PHASE_MASK                                                                     0xFFFFFFFFL
//DP_DTO2_MODULO
#define DP_DTO2_MODULO__DP_DTO2_MODULO__SHIFT                                                                 0x0
#define DP_DTO2_MODULO__DP_DTO2_MODULO_MASK                                                                   0xFFFFFFFFL
//OTG2_PHYPLL_PIXEL_RATE_CNTL
#define OTG2_PHYPLL_PIXEL_RATE_CNTL__OTG2_PHYPLL_PIXEL_RATE_SOURCE__SHIFT                                     0x0
#define OTG2_PHYPLL_PIXEL_RATE_CNTL__OTG2_PIXEL_RATE_PLL_SOURCE__SHIFT                                        0x4
#define OTG2_PHYPLL_PIXEL_RATE_CNTL__OTG2_PHYPLL_PIXEL_RATE_SOURCE_MASK                                       0x00000007L
#define OTG2_PHYPLL_PIXEL_RATE_CNTL__OTG2_PIXEL_RATE_PLL_SOURCE_MASK                                          0x00000010L
//OTG3_PIXEL_RATE_CNTL
#define OTG3_PIXEL_RATE_CNTL__OTG3_PIXEL_RATE_SOURCE__SHIFT                                                   0x0
#define OTG3_PIXEL_RATE_CNTL__DP_DTO3_ENABLE__SHIFT                                                           0x4
#define OTG3_PIXEL_RATE_CNTL__DP_DTO3_DS_DISABLE__SHIFT                                                       0x5
#define OTG3_PIXEL_RATE_CNTL__OTG3_ADD_PIXEL__SHIFT                                                           0x8
#define OTG3_PIXEL_RATE_CNTL__OTG3_DROP_PIXEL__SHIFT                                                          0x9
#define OTG3_PIXEL_RATE_CNTL__OTG3_DISPOUT_FIFO_ERROR__SHIFT                                                  0xe
#define OTG3_PIXEL_RATE_CNTL__OTG3_DISPOUT_ERROR_COUNT__SHIFT                                                 0x10
#define OTG3_PIXEL_RATE_CNTL__OTG3_PIXEL_RATE_SOURCE_MASK                                                     0x00000003L
#define OTG3_PIXEL_RATE_CNTL__DP_DTO3_ENABLE_MASK                                                             0x00000010L
#define OTG3_PIXEL_RATE_CNTL__DP_DTO3_DS_DISABLE_MASK                                                         0x00000020L
#define OTG3_PIXEL_RATE_CNTL__OTG3_ADD_PIXEL_MASK                                                             0x00000100L
#define OTG3_PIXEL_RATE_CNTL__OTG3_DROP_PIXEL_MASK                                                            0x00000200L
#define OTG3_PIXEL_RATE_CNTL__OTG3_DISPOUT_FIFO_ERROR_MASK                                                    0x0000C000L
#define OTG3_PIXEL_RATE_CNTL__OTG3_DISPOUT_ERROR_COUNT_MASK                                                   0x0FFF0000L
//DP_DTO3_PHASE
#define DP_DTO3_PHASE__DP_DTO3_PHASE__SHIFT                                                                   0x0
#define DP_DTO3_PHASE__DP_DTO3_PHASE_MASK                                                                     0xFFFFFFFFL
//DP_DTO3_MODULO
#define DP_DTO3_MODULO__DP_DTO3_MODULO__SHIFT                                                                 0x0
#define DP_DTO3_MODULO__DP_DTO3_MODULO_MASK                                                                   0xFFFFFFFFL
//OTG3_PHYPLL_PIXEL_RATE_CNTL
#define OTG3_PHYPLL_PIXEL_RATE_CNTL__OTG3_PHYPLL_PIXEL_RATE_SOURCE__SHIFT                                     0x0
#define OTG3_PHYPLL_PIXEL_RATE_CNTL__OTG3_PIXEL_RATE_PLL_SOURCE__SHIFT                                        0x4
#define OTG3_PHYPLL_PIXEL_RATE_CNTL__OTG3_PHYPLL_PIXEL_RATE_SOURCE_MASK                                       0x00000007L
#define OTG3_PHYPLL_PIXEL_RATE_CNTL__OTG3_PIXEL_RATE_PLL_SOURCE_MASK                                          0x00000010L
//OTG4_PIXEL_RATE_CNTL
#define OTG4_PIXEL_RATE_CNTL__OTG4_PIXEL_RATE_SOURCE__SHIFT                                                   0x0
#define OTG4_PIXEL_RATE_CNTL__DP_DTO4_ENABLE__SHIFT                                                           0x4
#define OTG4_PIXEL_RATE_CNTL__DP_DTO4_DS_DISABLE__SHIFT                                                       0x5
#define OTG4_PIXEL_RATE_CNTL__OTG4_ADD_PIXEL__SHIFT                                                           0x8
#define OTG4_PIXEL_RATE_CNTL__OTG4_DROP_PIXEL__SHIFT                                                          0x9
#define OTG4_PIXEL_RATE_CNTL__OTG4_DISPOUT_FIFO_ERROR__SHIFT                                                  0xe
#define OTG4_PIXEL_RATE_CNTL__OTG4_DISPOUT_ERROR_COUNT__SHIFT                                                 0x10
#define OTG4_PIXEL_RATE_CNTL__OTG4_PIXEL_RATE_SOURCE_MASK                                                     0x00000003L
#define OTG4_PIXEL_RATE_CNTL__DP_DTO4_ENABLE_MASK                                                             0x00000010L
#define OTG4_PIXEL_RATE_CNTL__DP_DTO4_DS_DISABLE_MASK                                                         0x00000020L
#define OTG4_PIXEL_RATE_CNTL__OTG4_ADD_PIXEL_MASK                                                             0x00000100L
#define OTG4_PIXEL_RATE_CNTL__OTG4_DROP_PIXEL_MASK                                                            0x00000200L
#define OTG4_PIXEL_RATE_CNTL__OTG4_DISPOUT_FIFO_ERROR_MASK                                                    0x0000C000L
#define OTG4_PIXEL_RATE_CNTL__OTG4_DISPOUT_ERROR_COUNT_MASK                                                   0x0FFF0000L
//DP_DTO4_PHASE
#define DP_DTO4_PHASE__DP_DTO4_PHASE__SHIFT                                                                   0x0
#define DP_DTO4_PHASE__DP_DTO4_PHASE_MASK                                                                     0xFFFFFFFFL
//DP_DTO4_MODULO
#define DP_DTO4_MODULO__DP_DTO4_MODULO__SHIFT                                                                 0x0
#define DP_DTO4_MODULO__DP_DTO4_MODULO_MASK                                                                   0xFFFFFFFFL
//OTG4_PHYPLL_PIXEL_RATE_CNTL
#define OTG4_PHYPLL_PIXEL_RATE_CNTL__OTG4_PHYPLL_PIXEL_RATE_SOURCE__SHIFT                                     0x0
#define OTG4_PHYPLL_PIXEL_RATE_CNTL__OTG4_PIXEL_RATE_PLL_SOURCE__SHIFT                                        0x4
#define OTG4_PHYPLL_PIXEL_RATE_CNTL__OTG4_PHYPLL_PIXEL_RATE_SOURCE_MASK                                       0x00000007L
#define OTG4_PHYPLL_PIXEL_RATE_CNTL__OTG4_PIXEL_RATE_PLL_SOURCE_MASK                                          0x00000010L
//OTG5_PIXEL_RATE_CNTL
#define OTG5_PIXEL_RATE_CNTL__OTG5_PIXEL_RATE_SOURCE__SHIFT                                                   0x0
#define OTG5_PIXEL_RATE_CNTL__DP_DTO5_ENABLE__SHIFT                                                           0x4
#define OTG5_PIXEL_RATE_CNTL__DP_DTO5_DS_DISABLE__SHIFT                                                       0x5
#define OTG5_PIXEL_RATE_CNTL__OTG5_ADD_PIXEL__SHIFT                                                           0x8
#define OTG5_PIXEL_RATE_CNTL__OTG5_DROP_PIXEL__SHIFT                                                          0x9
#define OTG5_PIXEL_RATE_CNTL__OTG5_DISPOUT_FIFO_ERROR__SHIFT                                                  0xe
#define OTG5_PIXEL_RATE_CNTL__OTG5_DISPOUT_ERROR_COUNT__SHIFT                                                 0x10
#define OTG5_PIXEL_RATE_CNTL__OTG5_PIXEL_RATE_SOURCE_MASK                                                     0x00000003L
#define OTG5_PIXEL_RATE_CNTL__DP_DTO5_ENABLE_MASK                                                             0x00000010L
#define OTG5_PIXEL_RATE_CNTL__DP_DTO5_DS_DISABLE_MASK                                                         0x00000020L
#define OTG5_PIXEL_RATE_CNTL__OTG5_ADD_PIXEL_MASK                                                             0x00000100L
#define OTG5_PIXEL_RATE_CNTL__OTG5_DROP_PIXEL_MASK                                                            0x00000200L
#define OTG5_PIXEL_RATE_CNTL__OTG5_DISPOUT_FIFO_ERROR_MASK                                                    0x0000C000L
#define OTG5_PIXEL_RATE_CNTL__OTG5_DISPOUT_ERROR_COUNT_MASK                                                   0x0FFF0000L
//DP_DTO5_PHASE
#define DP_DTO5_PHASE__DP_DTO5_PHASE__SHIFT                                                                   0x0
#define DP_DTO5_PHASE__DP_DTO5_PHASE_MASK                                                                     0xFFFFFFFFL
//DP_DTO5_MODULO
#define DP_DTO5_MODULO__DP_DTO5_MODULO__SHIFT                                                                 0x0
#define DP_DTO5_MODULO__DP_DTO5_MODULO_MASK                                                                   0xFFFFFFFFL
//OTG5_PHYPLL_PIXEL_RATE_CNTL
#define OTG5_PHYPLL_PIXEL_RATE_CNTL__OTG5_PHYPLL_PIXEL_RATE_SOURCE__SHIFT                                     0x0
#define OTG5_PHYPLL_PIXEL_RATE_CNTL__OTG5_PIXEL_RATE_PLL_SOURCE__SHIFT                                        0x4
#define OTG5_PHYPLL_PIXEL_RATE_CNTL__OTG5_PHYPLL_PIXEL_RATE_SOURCE_MASK                                       0x00000007L
#define OTG5_PHYPLL_PIXEL_RATE_CNTL__OTG5_PIXEL_RATE_PLL_SOURCE_MASK                                          0x00000010L
//DPPCLK_CGTT_BLK_CTRL_REG
#define DPPCLK_CGTT_BLK_CTRL_REG__DPPCLK_TURN_ON_DELAY__SHIFT                                                 0x0
#define DPPCLK_CGTT_BLK_CTRL_REG__DPPCLK_TURN_OFF_DELAY__SHIFT                                                0x4
#define DPPCLK_CGTT_BLK_CTRL_REG__DPPCLK_TURN_ON_DELAY_MASK                                                   0x0000000FL
#define DPPCLK_CGTT_BLK_CTRL_REG__DPPCLK_TURN_OFF_DELAY_MASK                                                  0x00000FF0L
//SYMCLKA_CLOCK_ENABLE
#define SYMCLKA_CLOCK_ENABLE__SYMCLKA_CLOCK_ENABLE__SHIFT                                                     0x0
#define SYMCLKA_CLOCK_ENABLE__SYMCLKA_FE_FORCE_EN__SHIFT                                                      0x4
#define SYMCLKA_CLOCK_ENABLE__SYMCLKA_FE_FORCE_SRC__SHIFT                                                     0x8
#define SYMCLKA_CLOCK_ENABLE__SYMCLKA_CLOCK_ENABLE_MASK                                                       0x00000001L
#define SYMCLKA_CLOCK_ENABLE__SYMCLKA_FE_FORCE_EN_MASK                                                        0x00000010L
#define SYMCLKA_CLOCK_ENABLE__SYMCLKA_FE_FORCE_SRC_MASK                                                       0x00000700L
//SYMCLKB_CLOCK_ENABLE
#define SYMCLKB_CLOCK_ENABLE__SYMCLKB_CLOCK_ENABLE__SHIFT                                                     0x0
#define SYMCLKB_CLOCK_ENABLE__SYMCLKB_FE_FORCE_EN__SHIFT                                                      0x4
#define SYMCLKB_CLOCK_ENABLE__SYMCLKB_FE_FORCE_SRC__SHIFT                                                     0x8
#define SYMCLKB_CLOCK_ENABLE__SYMCLKB_CLOCK_ENABLE_MASK                                                       0x00000001L
#define SYMCLKB_CLOCK_ENABLE__SYMCLKB_FE_FORCE_EN_MASK                                                        0x00000010L
#define SYMCLKB_CLOCK_ENABLE__SYMCLKB_FE_FORCE_SRC_MASK                                                       0x00000700L
//SYMCLKC_CLOCK_ENABLE
#define SYMCLKC_CLOCK_ENABLE__SYMCLKC_CLOCK_ENABLE__SHIFT                                                     0x0
#define SYMCLKC_CLOCK_ENABLE__SYMCLKC_FE_FORCE_EN__SHIFT                                                      0x4
#define SYMCLKC_CLOCK_ENABLE__SYMCLKC_FE_FORCE_SRC__SHIFT                                                     0x8
#define SYMCLKC_CLOCK_ENABLE__SYMCLKC_CLOCK_ENABLE_MASK                                                       0x00000001L
#define SYMCLKC_CLOCK_ENABLE__SYMCLKC_FE_FORCE_EN_MASK                                                        0x00000010L
#define SYMCLKC_CLOCK_ENABLE__SYMCLKC_FE_FORCE_SRC_MASK                                                       0x00000700L
//SYMCLKD_CLOCK_ENABLE
#define SYMCLKD_CLOCK_ENABLE__SYMCLKD_CLOCK_ENABLE__SHIFT                                                     0x0
#define SYMCLKD_CLOCK_ENABLE__SYMCLKD_FE_FORCE_EN__SHIFT                                                      0x4
#define SYMCLKD_CLOCK_ENABLE__SYMCLKD_FE_FORCE_SRC__SHIFT                                                     0x8
#define SYMCLKD_CLOCK_ENABLE__SYMCLKD_CLOCK_ENABLE_MASK                                                       0x00000001L
#define SYMCLKD_CLOCK_ENABLE__SYMCLKD_FE_FORCE_EN_MASK                                                        0x00000010L
#define SYMCLKD_CLOCK_ENABLE__SYMCLKD_FE_FORCE_SRC_MASK                                                       0x00000700L
//SYMCLKE_CLOCK_ENABLE
#define SYMCLKE_CLOCK_ENABLE__SYMCLKE_CLOCK_ENABLE__SHIFT                                                     0x0
#define SYMCLKE_CLOCK_ENABLE__SYMCLKE_FE_FORCE_EN__SHIFT                                                      0x4
#define SYMCLKE_CLOCK_ENABLE__SYMCLKE_FE_FORCE_SRC__SHIFT                                                     0x8
#define SYMCLKE_CLOCK_ENABLE__SYMCLKE_CLOCK_ENABLE_MASK                                                       0x00000001L
#define SYMCLKE_CLOCK_ENABLE__SYMCLKE_FE_FORCE_EN_MASK                                                        0x00000010L
#define SYMCLKE_CLOCK_ENABLE__SYMCLKE_FE_FORCE_SRC_MASK                                                       0x00000700L
//SYMCLKF_CLOCK_ENABLE
#define SYMCLKF_CLOCK_ENABLE__SYMCLKF_CLOCK_ENABLE__SHIFT                                                     0x0
#define SYMCLKF_CLOCK_ENABLE__SYMCLKF_FE_FORCE_EN__SHIFT                                                      0x4
#define SYMCLKF_CLOCK_ENABLE__SYMCLKF_FE_FORCE_SRC__SHIFT                                                     0x8
#define SYMCLKF_CLOCK_ENABLE__SYMCLKF_CLOCK_ENABLE_MASK                                                       0x00000001L
#define SYMCLKF_CLOCK_ENABLE__SYMCLKF_FE_FORCE_EN_MASK                                                        0x00000010L
#define SYMCLKF_CLOCK_ENABLE__SYMCLKF_FE_FORCE_SRC_MASK                                                       0x00000700L
//DCCG_SOFT_RESET
#define DCCG_SOFT_RESET__REFCLK_SOFT_RESET__SHIFT                                                             0x0
#define DCCG_SOFT_RESET__PCIE_REFCLK_SOFT_RESET__SHIFT                                                        0x1
#define DCCG_SOFT_RESET__SOFT_RESET_DVO__SHIFT                                                                0x2
#define DCCG_SOFT_RESET__DVO_ENABLE_RST__SHIFT                                                                0x3
#define DCCG_SOFT_RESET__AUDIO_DTO2_CLK_SOFT_RESET__SHIFT                                                     0x4
#define DCCG_SOFT_RESET__DPREFCLK_SOFT_RESET__SHIFT                                                           0x8
#define DCCG_SOFT_RESET__AMCLK0_SOFT_RESET__SHIFT                                                             0xc
#define DCCG_SOFT_RESET__AMCLK1_SOFT_RESET__SHIFT                                                             0xd
#define DCCG_SOFT_RESET__P0PLL_CFG_IF_SOFT_RESET__SHIFT                                                       0xe
#define DCCG_SOFT_RESET__P1PLL_CFG_IF_SOFT_RESET__SHIFT                                                       0xf
#define DCCG_SOFT_RESET__P2PLL_CFG_IF_SOFT_RESET__SHIFT                                                       0x10
#define DCCG_SOFT_RESET__A0PLL_CFG_IF_SOFT_RESET__SHIFT                                                       0x11
#define DCCG_SOFT_RESET__A1PLL_CFG_IF_SOFT_RESET__SHIFT                                                       0x12
#define DCCG_SOFT_RESET__C0PLL_CFG_IF_SOFT_RESET__SHIFT                                                       0x13
#define DCCG_SOFT_RESET__C1PLL_CFG_IF_SOFT_RESET__SHIFT                                                       0x14
#define DCCG_SOFT_RESET__C2PLL_CFG_IF_SOFT_RESET__SHIFT                                                       0x15
#define DCCG_SOFT_RESET__REFCLK_SOFT_RESET_MASK                                                               0x00000001L
#define DCCG_SOFT_RESET__PCIE_REFCLK_SOFT_RESET_MASK                                                          0x00000002L
#define DCCG_SOFT_RESET__SOFT_RESET_DVO_MASK                                                                  0x00000004L
#define DCCG_SOFT_RESET__DVO_ENABLE_RST_MASK                                                                  0x00000008L
#define DCCG_SOFT_RESET__AUDIO_DTO2_CLK_SOFT_RESET_MASK                                                       0x00000010L
#define DCCG_SOFT_RESET__DPREFCLK_SOFT_RESET_MASK                                                             0x00000100L
#define DCCG_SOFT_RESET__AMCLK0_SOFT_RESET_MASK                                                               0x00001000L
#define DCCG_SOFT_RESET__AMCLK1_SOFT_RESET_MASK                                                               0x00002000L
#define DCCG_SOFT_RESET__P0PLL_CFG_IF_SOFT_RESET_MASK                                                         0x00004000L
#define DCCG_SOFT_RESET__P1PLL_CFG_IF_SOFT_RESET_MASK                                                         0x00008000L
#define DCCG_SOFT_RESET__P2PLL_CFG_IF_SOFT_RESET_MASK                                                         0x00010000L
#define DCCG_SOFT_RESET__A0PLL_CFG_IF_SOFT_RESET_MASK                                                         0x00020000L
#define DCCG_SOFT_RESET__A1PLL_CFG_IF_SOFT_RESET_MASK                                                         0x00040000L
#define DCCG_SOFT_RESET__C0PLL_CFG_IF_SOFT_RESET_MASK                                                         0x00080000L
#define DCCG_SOFT_RESET__C1PLL_CFG_IF_SOFT_RESET_MASK                                                         0x00100000L
#define DCCG_SOFT_RESET__C2PLL_CFG_IF_SOFT_RESET_MASK                                                         0x00200000L
//DVOACLKD_CNTL
#define DVOACLKD_CNTL__DVOACLKD_FINE_SKEW_CNTL__SHIFT                                                         0x0
#define DVOACLKD_CNTL__DVOACLKD_COARSE_SKEW_CNTL__SHIFT                                                       0x8
#define DVOACLKD_CNTL__DVOACLKD_FINE_ADJUST_EN__SHIFT                                                         0x10
#define DVOACLKD_CNTL__DVOACLKD_COARSE_ADJUST_EN__SHIFT                                                       0x11
#define DVOACLKD_CNTL__DVOACLKD_IN_PHASE__SHIFT                                                               0x12
#define DVOACLKD_CNTL__DVOACLKD_FINE_SKEW_CNTL_MASK                                                           0x00000007L
#define DVOACLKD_CNTL__DVOACLKD_COARSE_SKEW_CNTL_MASK                                                         0x00001F00L
#define DVOACLKD_CNTL__DVOACLKD_FINE_ADJUST_EN_MASK                                                           0x00010000L
#define DVOACLKD_CNTL__DVOACLKD_COARSE_ADJUST_EN_MASK                                                         0x00020000L
#define DVOACLKD_CNTL__DVOACLKD_IN_PHASE_MASK                                                                 0x00040000L
//DVOACLKC_MVP_CNTL
#define DVOACLKC_MVP_CNTL__DVOACLKC_MVP_FINE_SKEW_CNTL__SHIFT                                                 0x0
#define DVOACLKC_MVP_CNTL__DVOACLKC_MVP_COARSE_SKEW_CNTL__SHIFT                                               0x8
#define DVOACLKC_MVP_CNTL__DVOACLKC_MVP_FINE_ADJUST_EN__SHIFT                                                 0x10
#define DVOACLKC_MVP_CNTL__DVOACLKC_MVP_COARSE_ADJUST_EN__SHIFT                                               0x11
#define DVOACLKC_MVP_CNTL__DVOACLKC_MVP_IN_PHASE__SHIFT                                                       0x12
#define DVOACLKC_MVP_CNTL__DVOACLKC_MVP_SKEW_PHASE_OVERRIDE__SHIFT                                            0x14
#define DVOACLKC_MVP_CNTL__DVOACLKC_MVP_FINE_SKEW_CNTL_MASK                                                   0x00000007L
#define DVOACLKC_MVP_CNTL__DVOACLKC_MVP_COARSE_SKEW_CNTL_MASK                                                 0x00001F00L
#define DVOACLKC_MVP_CNTL__DVOACLKC_MVP_FINE_ADJUST_EN_MASK                                                   0x00010000L
#define DVOACLKC_MVP_CNTL__DVOACLKC_MVP_COARSE_ADJUST_EN_MASK                                                 0x00020000L
#define DVOACLKC_MVP_CNTL__DVOACLKC_MVP_IN_PHASE_MASK                                                         0x00040000L
#define DVOACLKC_MVP_CNTL__DVOACLKC_MVP_SKEW_PHASE_OVERRIDE_MASK                                              0x00100000L
//DVOACLKC_CNTL
#define DVOACLKC_CNTL__DVOACLKC_FINE_SKEW_CNTL__SHIFT                                                         0x0
#define DVOACLKC_CNTL__DVOACLKC_COARSE_SKEW_CNTL__SHIFT                                                       0x8
#define DVOACLKC_CNTL__DVOACLKC_FINE_ADJUST_EN__SHIFT                                                         0x10
#define DVOACLKC_CNTL__DVOACLKC_COARSE_ADJUST_EN__SHIFT                                                       0x11
#define DVOACLKC_CNTL__DVOACLKC_IN_PHASE__SHIFT                                                               0x12
#define DVOACLKC_CNTL__DVOACLKC_FINE_SKEW_CNTL_MASK                                                           0x00000007L
#define DVOACLKC_CNTL__DVOACLKC_COARSE_SKEW_CNTL_MASK                                                         0x00001F00L
#define DVOACLKC_CNTL__DVOACLKC_FINE_ADJUST_EN_MASK                                                           0x00010000L
#define DVOACLKC_CNTL__DVOACLKC_COARSE_ADJUST_EN_MASK                                                         0x00020000L
#define DVOACLKC_CNTL__DVOACLKC_IN_PHASE_MASK                                                                 0x00040000L
//DCCG_AUDIO_DTO_SOURCE
#define DCCG_AUDIO_DTO_SOURCE__DCCG_AUDIO_DTO0_SOURCE_SEL__SHIFT                                              0x0
#define DCCG_AUDIO_DTO_SOURCE__DCCG_AUDIO_DTO_SEL__SHIFT                                                      0x4
#define DCCG_AUDIO_DTO_SOURCE__DCCG_AUDIO_DTO2_SOURCE_SEL__SHIFT                                              0xc
#define DCCG_AUDIO_DTO_SOURCE__DCCG_AUDIO_DTO2_CLOCK_EN__SHIFT                                                0x10
#define DCCG_AUDIO_DTO_SOURCE__DCCG_AUDIO_DTO2_USE_512FBR_DTO__SHIFT                                          0x14
#define DCCG_AUDIO_DTO_SOURCE__DCCG_AUDIO_DTO0_USE_512FBR_DTO__SHIFT                                          0x18
#define DCCG_AUDIO_DTO_SOURCE__DCCG_AUDIO_DTO1_USE_512FBR_DTO__SHIFT                                          0x1c
#define DCCG_AUDIO_DTO_SOURCE__DCCG_AUDIO_DTO0_SOURCE_SEL_MASK                                                0x00000007L
#define DCCG_AUDIO_DTO_SOURCE__DCCG_AUDIO_DTO_SEL_MASK                                                        0x00000030L
#define DCCG_AUDIO_DTO_SOURCE__DCCG_AUDIO_DTO2_SOURCE_SEL_MASK                                                0x00003000L
#define DCCG_AUDIO_DTO_SOURCE__DCCG_AUDIO_DTO2_CLOCK_EN_MASK                                                  0x00010000L
#define DCCG_AUDIO_DTO_SOURCE__DCCG_AUDIO_DTO2_USE_512FBR_DTO_MASK                                            0x00100000L
#define DCCG_AUDIO_DTO_SOURCE__DCCG_AUDIO_DTO0_USE_512FBR_DTO_MASK                                            0x01000000L
#define DCCG_AUDIO_DTO_SOURCE__DCCG_AUDIO_DTO1_USE_512FBR_DTO_MASK                                            0x10000000L
//DCCG_AUDIO_DTO0_PHASE
#define DCCG_AUDIO_DTO0_PHASE__DCCG_AUDIO_DTO0_PHASE__SHIFT                                                   0x0
#define DCCG_AUDIO_DTO0_PHASE__DCCG_AUDIO_DTO0_PHASE_MASK                                                     0xFFFFFFFFL
//DCCG_AUDIO_DTO0_MODULE
#define DCCG_AUDIO_DTO0_MODULE__DCCG_AUDIO_DTO0_MODULE__SHIFT                                                 0x0
#define DCCG_AUDIO_DTO0_MODULE__DCCG_AUDIO_DTO0_MODULE_MASK                                                   0xFFFFFFFFL
//DCCG_AUDIO_DTO1_PHASE
#define DCCG_AUDIO_DTO1_PHASE__DCCG_AUDIO_DTO1_PHASE__SHIFT                                                   0x0
#define DCCG_AUDIO_DTO1_PHASE__DCCG_AUDIO_DTO1_PHASE_MASK                                                     0xFFFFFFFFL
//DCCG_AUDIO_DTO1_MODULE
#define DCCG_AUDIO_DTO1_MODULE__DCCG_AUDIO_DTO1_MODULE__SHIFT                                                 0x0
#define DCCG_AUDIO_DTO1_MODULE__DCCG_AUDIO_DTO1_MODULE_MASK                                                   0xFFFFFFFFL
//DCCG_VSYNC_OTG0_LATCH_VALUE
#define DCCG_VSYNC_OTG0_LATCH_VALUE__DCCG_VSYNC_CNT_OTG0_LATCH_VALUE__SHIFT                                   0x0
#define DCCG_VSYNC_OTG0_LATCH_VALUE__DCCG_VSYNC_CNT_OTG0_LATCH_VALUE_MASK                                     0xFFFFFFFFL
//DCCG_VSYNC_OTG1_LATCH_VALUE
#define DCCG_VSYNC_OTG1_LATCH_VALUE__DCCG_VSYNC_CNT_OTG1_LATCH_VALUE__SHIFT                                   0x0
#define DCCG_VSYNC_OTG1_LATCH_VALUE__DCCG_VSYNC_CNT_OTG1_LATCH_VALUE_MASK                                     0xFFFFFFFFL
//DCCG_VSYNC_OTG2_LATCH_VALUE
#define DCCG_VSYNC_OTG2_LATCH_VALUE__DCCG_VSYNC_CNT_OTG2_LATCH_VALUE__SHIFT                                   0x0
#define DCCG_VSYNC_OTG2_LATCH_VALUE__DCCG_VSYNC_CNT_OTG2_LATCH_VALUE_MASK                                     0xFFFFFFFFL
//DCCG_VSYNC_OTG3_LATCH_VALUE
#define DCCG_VSYNC_OTG3_LATCH_VALUE__DCCG_VSYNC_CNT_OTG3_LATCH_VALUE__SHIFT                                   0x0
#define DCCG_VSYNC_OTG3_LATCH_VALUE__DCCG_VSYNC_CNT_OTG3_LATCH_VALUE_MASK                                     0xFFFFFFFFL
//DCCG_VSYNC_OTG4_LATCH_VALUE
#define DCCG_VSYNC_OTG4_LATCH_VALUE__DCCG_VSYNC_CNT_OTG4_LATCH_VALUE__SHIFT                                   0x0
#define DCCG_VSYNC_OTG4_LATCH_VALUE__DCCG_VSYNC_CNT_OTG4_LATCH_VALUE_MASK                                     0xFFFFFFFFL
//DCCG_VSYNC_OTG5_LATCH_VALUE
#define DCCG_VSYNC_OTG5_LATCH_VALUE__DCCG_VSYNC_CNT_OTG5_LATCH_VALUE__SHIFT                                   0x0
#define DCCG_VSYNC_OTG5_LATCH_VALUE__DCCG_VSYNC_CNT_OTG5_LATCH_VALUE_MASK                                     0xFFFFFFFFL
//DCCG_VSYNC_CNT_CTRL
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_CNT_ENABLE__SHIFT                                                     0x0
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_CNT_REFCLK_SEL__SHIFT                                                 0x1
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_CNT_SW_RESET__SHIFT                                                   0x2
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_CNT_RESET_SEL__SHIFT                                                  0x3
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_CNT_EXT_TRIG_SEL__SHIFT                                               0x4
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_CNT_FRAME_CNT__SHIFT                                                  0x8
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_OTG0_LATCH_EN__SHIFT                                                  0x10
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_OTG1_LATCH_EN__SHIFT                                                  0x11
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_OTG2_LATCH_EN__SHIFT                                                  0x12
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_OTG3_LATCH_EN__SHIFT                                                  0x13
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_OTG4_LATCH_EN__SHIFT                                                  0x14
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_OTG5_LATCH_EN__SHIFT                                                  0x15
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_OTG0_VSYNC_TRIG_SEL__SHIFT                                            0x18
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_OTG1_VSYNC_TRIG_SEL__SHIFT                                            0x19
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_OTG2_VSYNC_TRIG_SEL__SHIFT                                            0x1a
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_OTG3_VSYNC_TRIG_SEL__SHIFT                                            0x1b
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_OTG4_VSYNC_TRIG_SEL__SHIFT                                            0x1c
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_OTG5_VSYNC_TRIG_SEL__SHIFT                                            0x1d
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_CNT_ENABLE_MASK                                                       0x00000001L
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_CNT_REFCLK_SEL_MASK                                                   0x00000002L
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_CNT_SW_RESET_MASK                                                     0x00000004L
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_CNT_RESET_SEL_MASK                                                    0x00000008L
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_CNT_EXT_TRIG_SEL_MASK                                                 0x000000F0L
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_CNT_FRAME_CNT_MASK                                                    0x00000F00L
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_OTG0_LATCH_EN_MASK                                                    0x00010000L
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_OTG1_LATCH_EN_MASK                                                    0x00020000L
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_OTG2_LATCH_EN_MASK                                                    0x00040000L
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_OTG3_LATCH_EN_MASK                                                    0x00080000L
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_OTG4_LATCH_EN_MASK                                                    0x00100000L
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_OTG5_LATCH_EN_MASK                                                    0x00200000L
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_OTG0_VSYNC_TRIG_SEL_MASK                                              0x01000000L
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_OTG1_VSYNC_TRIG_SEL_MASK                                              0x02000000L
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_OTG2_VSYNC_TRIG_SEL_MASK                                              0x04000000L
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_OTG3_VSYNC_TRIG_SEL_MASK                                              0x08000000L
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_OTG4_VSYNC_TRIG_SEL_MASK                                              0x10000000L
#define DCCG_VSYNC_CNT_CTRL__DCCG_VSYNC_OTG5_VSYNC_TRIG_SEL_MASK                                              0x20000000L
//DCCG_VSYNC_CNT_INT_CTRL
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG0_LATCH_INTERRUPT__SHIFT                                   0x0
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG0_LATCH_INTERRUPT_CLEAR__SHIFT                             0x0
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG1_LATCH_INTERRUPT__SHIFT                                   0x1
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG1_LATCH_INTERRUPT_CLEAR__SHIFT                             0x1
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG2_LATCH_INTERRUPT__SHIFT                                   0x2
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG2_LATCH_INTERRUPT_CLEAR__SHIFT                             0x2
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG3_LATCH_INTERRUPT__SHIFT                                   0x3
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG3_LATCH_INTERRUPT_CLEAR__SHIFT                             0x3
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG4_LATCH_INTERRUPT__SHIFT                                   0x4
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG4_LATCH_INTERRUPT_CLEAR__SHIFT                             0x4
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG5_LATCH_INTERRUPT__SHIFT                                   0x5
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG5_LATCH_INTERRUPT_CLEAR__SHIFT                             0x5
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG0_LATCH_MASK__SHIFT                                        0x8
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG1_LATCH_MASK__SHIFT                                        0x9
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG2_LATCH_MASK__SHIFT                                        0xa
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG3_LATCH_MASK__SHIFT                                        0xb
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG4_LATCH_MASK__SHIFT                                        0xc
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG5_LATCH_MASK__SHIFT                                        0xd
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG0_LATCH_INTERRUPT_MASK                                     0x00000001L
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG0_LATCH_INTERRUPT_CLEAR_MASK                               0x00000001L
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG1_LATCH_INTERRUPT_MASK                                     0x00000002L
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG1_LATCH_INTERRUPT_CLEAR_MASK                               0x00000002L
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG2_LATCH_INTERRUPT_MASK                                     0x00000004L
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG2_LATCH_INTERRUPT_CLEAR_MASK                               0x00000004L
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG3_LATCH_INTERRUPT_MASK                                     0x00000008L
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG3_LATCH_INTERRUPT_CLEAR_MASK                               0x00000008L
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG4_LATCH_INTERRUPT_MASK                                     0x00000010L
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG4_LATCH_INTERRUPT_CLEAR_MASK                               0x00000010L
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG5_LATCH_INTERRUPT_MASK                                     0x00000020L
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG5_LATCH_INTERRUPT_CLEAR_MASK                               0x00000020L
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG0_LATCH_MASK_MASK                                          0x00000100L
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG1_LATCH_MASK_MASK                                          0x00000200L
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG2_LATCH_MASK_MASK                                          0x00000400L
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG3_LATCH_MASK_MASK                                          0x00000800L
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG4_LATCH_MASK_MASK                                          0x00001000L
#define DCCG_VSYNC_CNT_INT_CTRL__DCCG_VSYNC_CNT_OTG5_LATCH_MASK_MASK                                          0x00002000L
//DCCG_TEST_CLK_SEL
#define DCCG_TEST_CLK_SEL__DCCG_TEST_CLK_GENERICA_SEL__SHIFT                                                  0x0
#define DCCG_TEST_CLK_SEL__DCCG_TEST_CLK_GENERICA_INV__SHIFT                                                  0xc
#define DCCG_TEST_CLK_SEL__DCCG_TEST_CLK_GENERICB_SEL__SHIFT                                                  0x10
#define DCCG_TEST_CLK_SEL__DCCG_TEST_CLK_GENERICB_INV__SHIFT                                                  0x1c
#define DCCG_TEST_CLK_SEL__DCCG_TEST_CLK_GENERICA_SEL_MASK                                                    0x000001FFL
#define DCCG_TEST_CLK_SEL__DCCG_TEST_CLK_GENERICA_INV_MASK                                                    0x00001000L
#define DCCG_TEST_CLK_SEL__DCCG_TEST_CLK_GENERICB_SEL_MASK                                                    0x01FF0000L
#define DCCG_TEST_CLK_SEL__DCCG_TEST_CLK_GENERICB_INV_MASK                                                    0x10000000L


// addressBlock: dce_dc_dccg_dccg_dfs_dispdec
//DENTIST_DISPCLK_CNTL
#define DENTIST_DISPCLK_CNTL__DENTIST_DISPCLK_WDIVIDER__SHIFT                                                 0x0
#define DENTIST_DISPCLK_CNTL__DENTIST_DISPCLK_RDIVIDER__SHIFT                                                 0x8
#define DENTIST_DISPCLK_CNTL__DENTIST_DISPCLK_CHG_MODE__SHIFT                                                 0xf
#define DENTIST_DISPCLK_CNTL__DENTIST_DISPCLK_CHGTOG__SHIFT                                                   0x11
#define DENTIST_DISPCLK_CNTL__DENTIST_DISPCLK_DONETOG__SHIFT                                                  0x12
#define DENTIST_DISPCLK_CNTL__DENTIST_DISPCLK_CHG_DONE__SHIFT                                                 0x13
#define DENTIST_DISPCLK_CNTL__DENTIST_DPREFCLK_CHG_DONE__SHIFT                                                0x14
#define DENTIST_DISPCLK_CNTL__DENTIST_DPREFCLK_CHGTOG__SHIFT                                                  0x15
#define DENTIST_DISPCLK_CNTL__DENTIST_DPREFCLK_DONETOG__SHIFT                                                 0x16
#define DENTIST_DISPCLK_CNTL__DENTIST_DPREFCLK_WDIVIDER__SHIFT                                                0x18
#define DENTIST_DISPCLK_CNTL__DENTIST_DISPCLK_WDIVIDER_MASK                                                   0x0000007FL
#define DENTIST_DISPCLK_CNTL__DENTIST_DISPCLK_RDIVIDER_MASK                                                   0x00007F00L
#define DENTIST_DISPCLK_CNTL__DENTIST_DISPCLK_CHG_MODE_MASK                                                   0x00018000L
#define DENTIST_DISPCLK_CNTL__DENTIST_DISPCLK_CHGTOG_MASK                                                     0x00020000L
#define DENTIST_DISPCLK_CNTL__DENTIST_DISPCLK_DONETOG_MASK                                                    0x00040000L
#define DENTIST_DISPCLK_CNTL__DENTIST_DISPCLK_CHG_DONE_MASK                                                   0x00080000L
#define DENTIST_DISPCLK_CNTL__DENTIST_DPREFCLK_CHG_DONE_MASK                                                  0x00100000L
#define DENTIST_DISPCLK_CNTL__DENTIST_DPREFCLK_CHGTOG_MASK                                                    0x00200000L
#define DENTIST_DISPCLK_CNTL__DENTIST_DPREFCLK_DONETOG_MASK                                                   0x00400000L
#define DENTIST_DISPCLK_CNTL__DENTIST_DPREFCLK_WDIVIDER_MASK                                                  0x7F000000L


// addressBlock: dce_dc_dccg_dccg_dcperfmon0_dc_perfmon_dispdec
//DC_PERFMON0_PERFCOUNTER_CNTL
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_EVENT_SEL__SHIFT                                            0x0
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_CVALUE_SEL__SHIFT                                           0x9
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_INC_MODE__SHIFT                                             0xc
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_HW_CNTL_SEL__SHIFT                                          0xf
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_RUNEN_MODE__SHIFT                                           0x10
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_CNTOFF_START_DIS__SHIFT                                     0x16
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_RESTART_EN__SHIFT                                           0x17
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_INT_EN__SHIFT                                               0x18
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_OFF_MASK__SHIFT                                             0x19
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_ACTIVE__SHIFT                                               0x1a
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_CNTL_SEL__SHIFT                                             0x1d
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_EVENT_SEL_MASK                                              0x000001FFL
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_CVALUE_SEL_MASK                                             0x00000E00L
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_INC_MODE_MASK                                               0x00007000L
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_HW_CNTL_SEL_MASK                                            0x00008000L
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_RUNEN_MODE_MASK                                             0x00010000L
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_CNTOFF_START_DIS_MASK                                       0x00400000L
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_RESTART_EN_MASK                                             0x00800000L
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_INT_EN_MASK                                                 0x01000000L
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_OFF_MASK_MASK                                               0x02000000L
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_ACTIVE_MASK                                                 0x04000000L
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_CNTL_SEL_MASK                                               0xE0000000L
//DC_PERFMON0_PERFCOUNTER_CNTL2
#define DC_PERFMON0_PERFCOUNTER_CNTL2__PERFCOUNTER_COUNTED_VALUE_TYPE__SHIFT                                  0x0
#define DC_PERFMON0_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP1_SEL__SHIFT                                        0x2
#define DC_PERFMON0_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP2_SEL__SHIFT                                        0x3
#define DC_PERFMON0_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTOFF_SEL__SHIFT                                          0x8
#define DC_PERFMON0_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTL2_SEL__SHIFT                                           0x1d
#define DC_PERFMON0_PERFCOUNTER_CNTL2__PERFCOUNTER_COUNTED_VALUE_TYPE_MASK                                    0x00000003L
#define DC_PERFMON0_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP1_SEL_MASK                                          0x00000004L
#define DC_PERFMON0_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP2_SEL_MASK                                          0x00000008L
#define DC_PERFMON0_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTOFF_SEL_MASK                                            0x00003F00L
#define DC_PERFMON0_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTL2_SEL_MASK                                             0xE0000000L
//DC_PERFMON0_PERFCOUNTER_STATE
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_CNT0_STATE__SHIFT                                          0x0
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL0__SHIFT                                          0x2
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_CNT1_STATE__SHIFT                                          0x4
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL1__SHIFT                                          0x6
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_CNT2_STATE__SHIFT                                          0x8
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL2__SHIFT                                          0xa
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_CNT3_STATE__SHIFT                                          0xc
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL3__SHIFT                                          0xe
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_CNT4_STATE__SHIFT                                          0x10
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL4__SHIFT                                          0x12
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_CNT5_STATE__SHIFT                                          0x14
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL5__SHIFT                                          0x16
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_CNT6_STATE__SHIFT                                          0x18
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL6__SHIFT                                          0x1a
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_CNT7_STATE__SHIFT                                          0x1c
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL7__SHIFT                                          0x1e
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_CNT0_STATE_MASK                                            0x00000003L
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL0_MASK                                            0x00000004L
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_CNT1_STATE_MASK                                            0x00000030L
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL1_MASK                                            0x00000040L
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_CNT2_STATE_MASK                                            0x00000300L
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL2_MASK                                            0x00000400L
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_CNT3_STATE_MASK                                            0x00003000L
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL3_MASK                                            0x00004000L
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_CNT4_STATE_MASK                                            0x00030000L
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL4_MASK                                            0x00040000L
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_CNT5_STATE_MASK                                            0x00300000L
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL5_MASK                                            0x00400000L
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_CNT6_STATE_MASK                                            0x03000000L
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL6_MASK                                            0x04000000L
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_CNT7_STATE_MASK                                            0x30000000L
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL7_MASK                                            0x40000000L
//DC_PERFMON0_PERFMON_CNTL
#define DC_PERFMON0_PERFMON_CNTL__PERFMON_STATE__SHIFT                                                        0x0
#define DC_PERFMON0_PERFMON_CNTL__PERFMON_RPT_COUNT__SHIFT                                                    0x8
#define DC_PERFMON0_PERFMON_CNTL__PERFMON_CNTOFF_AND_OR__SHIFT                                                0x1c
#define DC_PERFMON0_PERFMON_CNTL__PERFMON_CNTOFF_INT_EN__SHIFT                                                0x1d
#define DC_PERFMON0_PERFMON_CNTL__PERFMON_CNTOFF_INT_STATUS__SHIFT                                            0x1e
#define DC_PERFMON0_PERFMON_CNTL__PERFMON_CNTOFF_INT_ACK__SHIFT                                               0x1f
#define DC_PERFMON0_PERFMON_CNTL__PERFMON_STATE_MASK                                                          0x00000003L
#define DC_PERFMON0_PERFMON_CNTL__PERFMON_RPT_COUNT_MASK                                                      0x0FFFFF00L
#define DC_PERFMON0_PERFMON_CNTL__PERFMON_CNTOFF_AND_OR_MASK                                                  0x10000000L
#define DC_PERFMON0_PERFMON_CNTL__PERFMON_CNTOFF_INT_EN_MASK                                                  0x20000000L
#define DC_PERFMON0_PERFMON_CNTL__PERFMON_CNTOFF_INT_STATUS_MASK                                              0x40000000L
#define DC_PERFMON0_PERFMON_CNTL__PERFMON_CNTOFF_INT_ACK_MASK                                                 0x80000000L
//DC_PERFMON0_PERFMON_CNTL2
#define DC_PERFMON0_PERFMON_CNTL2__PERFMON_CNTOFF_INT_TYPE__SHIFT                                             0x0
#define DC_PERFMON0_PERFMON_CNTL2__PERFMON_CLK_ENABLE__SHIFT                                                  0x1
#define DC_PERFMON0_PERFMON_CNTL2__PERFMON_RUN_ENABLE_START_SEL__SHIFT                                        0x2
#define DC_PERFMON0_PERFMON_CNTL2__PERFMON_RUN_ENABLE_STOP_SEL__SHIFT                                         0xa
#define DC_PERFMON0_PERFMON_CNTL2__PERFMON_CNTOFF_INT_TYPE_MASK                                               0x00000001L
#define DC_PERFMON0_PERFMON_CNTL2__PERFMON_CLK_ENABLE_MASK                                                    0x00000002L
#define DC_PERFMON0_PERFMON_CNTL2__PERFMON_RUN_ENABLE_START_SEL_MASK                                          0x000003FCL
#define DC_PERFMON0_PERFMON_CNTL2__PERFMON_RUN_ENABLE_STOP_SEL_MASK                                           0x0003FC00L
//DC_PERFMON0_PERFMON_CVALUE_INT_MISC
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_STATUS__SHIFT                                   0x0
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_STATUS__SHIFT                                   0x1
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_STATUS__SHIFT                                   0x2
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_STATUS__SHIFT                                   0x3
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_STATUS__SHIFT                                   0x4
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_STATUS__SHIFT                                   0x5
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_STATUS__SHIFT                                   0x6
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_STATUS__SHIFT                                   0x7
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_ACK__SHIFT                                      0x8
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_ACK__SHIFT                                      0x9
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_ACK__SHIFT                                      0xa
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_ACK__SHIFT                                      0xb
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_ACK__SHIFT                                      0xc
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_ACK__SHIFT                                      0xd
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_ACK__SHIFT                                      0xe
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_ACK__SHIFT                                      0xf
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFMON_CVALUE_HI__SHIFT                                         0x10
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_STATUS_MASK                                     0x00000001L
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_STATUS_MASK                                     0x00000002L
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_STATUS_MASK                                     0x00000004L
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_STATUS_MASK                                     0x00000008L
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_STATUS_MASK                                     0x00000010L
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_STATUS_MASK                                     0x00000020L
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_STATUS_MASK                                     0x00000040L
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_STATUS_MASK                                     0x00000080L
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_ACK_MASK                                        0x00000100L
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_ACK_MASK                                        0x00000200L
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_ACK_MASK                                        0x00000400L
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_ACK_MASK                                        0x00000800L
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_ACK_MASK                                        0x00001000L
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_ACK_MASK                                        0x00002000L
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_ACK_MASK                                        0x00004000L
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_ACK_MASK                                        0x00008000L
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFMON_CVALUE_HI_MASK                                           0xFFFF0000L
//DC_PERFMON0_PERFMON_CVALUE_LOW
#define DC_PERFMON0_PERFMON_CVALUE_LOW__PERFMON_CVALUE_LOW__SHIFT                                             0x0
#define DC_PERFMON0_PERFMON_CVALUE_LOW__PERFMON_CVALUE_LOW_MASK                                               0xFFFFFFFFL
//DC_PERFMON0_PERFMON_HI
#define DC_PERFMON0_PERFMON_HI__PERFMON_HI__SHIFT                                                             0x0
#define DC_PERFMON0_PERFMON_HI__PERFMON_READ_SEL__SHIFT                                                       0x1d
#define DC_PERFMON0_PERFMON_HI__PERFMON_HI_MASK                                                               0x0000FFFFL
#define DC_PERFMON0_PERFMON_HI__PERFMON_READ_SEL_MASK                                                         0xE0000000L
//DC_PERFMON0_PERFMON_LOW
#define DC_PERFMON0_PERFMON_LOW__PERFMON_LOW__SHIFT                                                           0x0
#define DC_PERFMON0_PERFMON_LOW__PERFMON_LOW_MASK                                                             0xFFFFFFFFL


// addressBlock: dce_dc_dccg_dccg_dcperfmon1_dc_perfmon_dispdec
//DC_PERFMON1_PERFCOUNTER_CNTL
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_EVENT_SEL__SHIFT                                            0x0
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_CVALUE_SEL__SHIFT                                           0x9
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_INC_MODE__SHIFT                                             0xc
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_HW_CNTL_SEL__SHIFT                                          0xf
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_RUNEN_MODE__SHIFT                                           0x10
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_CNTOFF_START_DIS__SHIFT                                     0x16
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_RESTART_EN__SHIFT                                           0x17
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_INT_EN__SHIFT                                               0x18
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_OFF_MASK__SHIFT                                             0x19
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_ACTIVE__SHIFT                                               0x1a
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_CNTL_SEL__SHIFT                                             0x1d
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_EVENT_SEL_MASK                                              0x000001FFL
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_CVALUE_SEL_MASK                                             0x00000E00L
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_INC_MODE_MASK                                               0x00007000L
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_HW_CNTL_SEL_MASK                                            0x00008000L
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_RUNEN_MODE_MASK                                             0x00010000L
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_CNTOFF_START_DIS_MASK                                       0x00400000L
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_RESTART_EN_MASK                                             0x00800000L
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_INT_EN_MASK                                                 0x01000000L
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_OFF_MASK_MASK                                               0x02000000L
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_ACTIVE_MASK                                                 0x04000000L
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_CNTL_SEL_MASK                                               0xE0000000L
//DC_PERFMON1_PERFCOUNTER_CNTL2
#define DC_PERFMON1_PERFCOUNTER_CNTL2__PERFCOUNTER_COUNTED_VALUE_TYPE__SHIFT                                  0x0
#define DC_PERFMON1_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP1_SEL__SHIFT                                        0x2
#define DC_PERFMON1_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP2_SEL__SHIFT                                        0x3
#define DC_PERFMON1_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTOFF_SEL__SHIFT                                          0x8
#define DC_PERFMON1_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTL2_SEL__SHIFT                                           0x1d
#define DC_PERFMON1_PERFCOUNTER_CNTL2__PERFCOUNTER_COUNTED_VALUE_TYPE_MASK                                    0x00000003L
#define DC_PERFMON1_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP1_SEL_MASK                                          0x00000004L
#define DC_PERFMON1_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP2_SEL_MASK                                          0x00000008L
#define DC_PERFMON1_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTOFF_SEL_MASK                                            0x00003F00L
#define DC_PERFMON1_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTL2_SEL_MASK                                             0xE0000000L
//DC_PERFMON1_PERFCOUNTER_STATE
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_CNT0_STATE__SHIFT                                          0x0
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL0__SHIFT                                          0x2
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_CNT1_STATE__SHIFT                                          0x4
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL1__SHIFT                                          0x6
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_CNT2_STATE__SHIFT                                          0x8
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL2__SHIFT                                          0xa
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_CNT3_STATE__SHIFT                                          0xc
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL3__SHIFT                                          0xe
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_CNT4_STATE__SHIFT                                          0x10
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL4__SHIFT                                          0x12
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_CNT5_STATE__SHIFT                                          0x14
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL5__SHIFT                                          0x16
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_CNT6_STATE__SHIFT                                          0x18
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL6__SHIFT                                          0x1a
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_CNT7_STATE__SHIFT                                          0x1c
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL7__SHIFT                                          0x1e
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_CNT0_STATE_MASK                                            0x00000003L
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL0_MASK                                            0x00000004L
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_CNT1_STATE_MASK                                            0x00000030L
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL1_MASK                                            0x00000040L
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_CNT2_STATE_MASK                                            0x00000300L
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL2_MASK                                            0x00000400L
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_CNT3_STATE_MASK                                            0x00003000L
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL3_MASK                                            0x00004000L
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_CNT4_STATE_MASK                                            0x00030000L
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL4_MASK                                            0x00040000L
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_CNT5_STATE_MASK                                            0x00300000L
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL5_MASK                                            0x00400000L
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_CNT6_STATE_MASK                                            0x03000000L
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL6_MASK                                            0x04000000L
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_CNT7_STATE_MASK                                            0x30000000L
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL7_MASK                                            0x40000000L
//DC_PERFMON1_PERFMON_CNTL
#define DC_PERFMON1_PERFMON_CNTL__PERFMON_STATE__SHIFT                                                        0x0
#define DC_PERFMON1_PERFMON_CNTL__PERFMON_RPT_COUNT__SHIFT                                                    0x8
#define DC_PERFMON1_PERFMON_CNTL__PERFMON_CNTOFF_AND_OR__SHIFT                                                0x1c
#define DC_PERFMON1_PERFMON_CNTL__PERFMON_CNTOFF_INT_EN__SHIFT                                                0x1d
#define DC_PERFMON1_PERFMON_CNTL__PERFMON_CNTOFF_INT_STATUS__SHIFT                                            0x1e
#define DC_PERFMON1_PERFMON_CNTL__PERFMON_CNTOFF_INT_ACK__SHIFT                                               0x1f
#define DC_PERFMON1_PERFMON_CNTL__PERFMON_STATE_MASK                                                          0x00000003L
#define DC_PERFMON1_PERFMON_CNTL__PERFMON_RPT_COUNT_MASK                                                      0x0FFFFF00L
#define DC_PERFMON1_PERFMON_CNTL__PERFMON_CNTOFF_AND_OR_MASK                                                  0x10000000L
#define DC_PERFMON1_PERFMON_CNTL__PERFMON_CNTOFF_INT_EN_MASK                                                  0x20000000L
#define DC_PERFMON1_PERFMON_CNTL__PERFMON_CNTOFF_INT_STATUS_MASK                                              0x40000000L
#define DC_PERFMON1_PERFMON_CNTL__PERFMON_CNTOFF_INT_ACK_MASK                                                 0x80000000L
//DC_PERFMON1_PERFMON_CNTL2
#define DC_PERFMON1_PERFMON_CNTL2__PERFMON_CNTOFF_INT_TYPE__SHIFT                                             0x0
#define DC_PERFMON1_PERFMON_CNTL2__PERFMON_CLK_ENABLE__SHIFT                                                  0x1
#define DC_PERFMON1_PERFMON_CNTL2__PERFMON_RUN_ENABLE_START_SEL__SHIFT                                        0x2
#define DC_PERFMON1_PERFMON_CNTL2__PERFMON_RUN_ENABLE_STOP_SEL__SHIFT                                         0xa
#define DC_PERFMON1_PERFMON_CNTL2__PERFMON_CNTOFF_INT_TYPE_MASK                                               0x00000001L
#define DC_PERFMON1_PERFMON_CNTL2__PERFMON_CLK_ENABLE_MASK                                                    0x00000002L
#define DC_PERFMON1_PERFMON_CNTL2__PERFMON_RUN_ENABLE_START_SEL_MASK                                          0x000003FCL
#define DC_PERFMON1_PERFMON_CNTL2__PERFMON_RUN_ENABLE_STOP_SEL_MASK                                           0x0003FC00L
//DC_PERFMON1_PERFMON_CVALUE_INT_MISC
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_STATUS__SHIFT                                   0x0
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_STATUS__SHIFT                                   0x1
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_STATUS__SHIFT                                   0x2
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_STATUS__SHIFT                                   0x3
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_STATUS__SHIFT                                   0x4
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_STATUS__SHIFT                                   0x5
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_STATUS__SHIFT                                   0x6
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_STATUS__SHIFT                                   0x7
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_ACK__SHIFT                                      0x8
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_ACK__SHIFT                                      0x9
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_ACK__SHIFT                                      0xa
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_ACK__SHIFT                                      0xb
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_ACK__SHIFT                                      0xc
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_ACK__SHIFT                                      0xd
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_ACK__SHIFT                                      0xe
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_ACK__SHIFT                                      0xf
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFMON_CVALUE_HI__SHIFT                                         0x10
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_STATUS_MASK                                     0x00000001L
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_STATUS_MASK                                     0x00000002L
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_STATUS_MASK                                     0x00000004L
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_STATUS_MASK                                     0x00000008L
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_STATUS_MASK                                     0x00000010L
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_STATUS_MASK                                     0x00000020L
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_STATUS_MASK                                     0x00000040L
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_STATUS_MASK                                     0x00000080L
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_ACK_MASK                                        0x00000100L
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_ACK_MASK                                        0x00000200L
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_ACK_MASK                                        0x00000400L
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_ACK_MASK                                        0x00000800L
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_ACK_MASK                                        0x00001000L
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_ACK_MASK                                        0x00002000L
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_ACK_MASK                                        0x00004000L
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_ACK_MASK                                        0x00008000L
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFMON_CVALUE_HI_MASK                                           0xFFFF0000L
//DC_PERFMON1_PERFMON_CVALUE_LOW
#define DC_PERFMON1_PERFMON_CVALUE_LOW__PERFMON_CVALUE_LOW__SHIFT                                             0x0
#define DC_PERFMON1_PERFMON_CVALUE_LOW__PERFMON_CVALUE_LOW_MASK                                               0xFFFFFFFFL
//DC_PERFMON1_PERFMON_HI
#define DC_PERFMON1_PERFMON_HI__PERFMON_HI__SHIFT                                                             0x0
#define DC_PERFMON1_PERFMON_HI__PERFMON_READ_SEL__SHIFT                                                       0x1d
#define DC_PERFMON1_PERFMON_HI__PERFMON_HI_MASK                                                               0x0000FFFFL
#define DC_PERFMON1_PERFMON_HI__PERFMON_READ_SEL_MASK                                                         0xE0000000L
//DC_PERFMON1_PERFMON_LOW
#define DC_PERFMON1_PERFMON_LOW__PERFMON_LOW__SHIFT                                                           0x0
#define DC_PERFMON1_PERFMON_LOW__PERFMON_LOW_MASK                                                             0xFFFFFFFFL


// addressBlock: dce_dc_dccg_dccg_pll_dispdec
//PLL_MACRO_CNTL_RESERVED0
#define PLL_MACRO_CNTL_RESERVED0__PLL_MACRO_CNTL_RESERVED__SHIFT                                              0x0
#define PLL_MACRO_CNTL_RESERVED0__PLL_MACRO_CNTL_RESERVED_MASK                                                0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED1
#define PLL_MACRO_CNTL_RESERVED1__PLL_MACRO_CNTL_RESERVED__SHIFT                                              0x0
#define PLL_MACRO_CNTL_RESERVED1__PLL_MACRO_CNTL_RESERVED_MASK                                                0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED2
#define PLL_MACRO_CNTL_RESERVED2__PLL_MACRO_CNTL_RESERVED__SHIFT                                              0x0
#define PLL_MACRO_CNTL_RESERVED2__PLL_MACRO_CNTL_RESERVED_MASK                                                0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED3
#define PLL_MACRO_CNTL_RESERVED3__PLL_MACRO_CNTL_RESERVED__SHIFT                                              0x0
#define PLL_MACRO_CNTL_RESERVED3__PLL_MACRO_CNTL_RESERVED_MASK                                                0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED4
#define PLL_MACRO_CNTL_RESERVED4__PLL_MACRO_CNTL_RESERVED__SHIFT                                              0x0
#define PLL_MACRO_CNTL_RESERVED4__PLL_MACRO_CNTL_RESERVED_MASK                                                0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED5
#define PLL_MACRO_CNTL_RESERVED5__PLL_MACRO_CNTL_RESERVED__SHIFT                                              0x0
#define PLL_MACRO_CNTL_RESERVED5__PLL_MACRO_CNTL_RESERVED_MASK                                                0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED6
#define PLL_MACRO_CNTL_RESERVED6__PLL_MACRO_CNTL_RESERVED__SHIFT                                              0x0
#define PLL_MACRO_CNTL_RESERVED6__PLL_MACRO_CNTL_RESERVED_MASK                                                0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED7
#define PLL_MACRO_CNTL_RESERVED7__PLL_MACRO_CNTL_RESERVED__SHIFT                                              0x0
#define PLL_MACRO_CNTL_RESERVED7__PLL_MACRO_CNTL_RESERVED_MASK                                                0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED8
#define PLL_MACRO_CNTL_RESERVED8__PLL_MACRO_CNTL_RESERVED__SHIFT                                              0x0
#define PLL_MACRO_CNTL_RESERVED8__PLL_MACRO_CNTL_RESERVED_MASK                                                0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED9
#define PLL_MACRO_CNTL_RESERVED9__PLL_MACRO_CNTL_RESERVED__SHIFT                                              0x0
#define PLL_MACRO_CNTL_RESERVED9__PLL_MACRO_CNTL_RESERVED_MASK                                                0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED10
#define PLL_MACRO_CNTL_RESERVED10__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED10__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED11
#define PLL_MACRO_CNTL_RESERVED11__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED11__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED12
#define PLL_MACRO_CNTL_RESERVED12__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED12__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED13
#define PLL_MACRO_CNTL_RESERVED13__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED13__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED14
#define PLL_MACRO_CNTL_RESERVED14__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED14__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED15
#define PLL_MACRO_CNTL_RESERVED15__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED15__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED16
#define PLL_MACRO_CNTL_RESERVED16__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED16__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED17
#define PLL_MACRO_CNTL_RESERVED17__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED17__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED18
#define PLL_MACRO_CNTL_RESERVED18__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED18__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED19
#define PLL_MACRO_CNTL_RESERVED19__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED19__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED20
#define PLL_MACRO_CNTL_RESERVED20__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED20__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED21
#define PLL_MACRO_CNTL_RESERVED21__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED21__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED22
#define PLL_MACRO_CNTL_RESERVED22__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED22__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED23
#define PLL_MACRO_CNTL_RESERVED23__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED23__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED24
#define PLL_MACRO_CNTL_RESERVED24__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED24__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED25
#define PLL_MACRO_CNTL_RESERVED25__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED25__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED26
#define PLL_MACRO_CNTL_RESERVED26__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED26__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED27
#define PLL_MACRO_CNTL_RESERVED27__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED27__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED28
#define PLL_MACRO_CNTL_RESERVED28__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED28__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED29
#define PLL_MACRO_CNTL_RESERVED29__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED29__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED30
#define PLL_MACRO_CNTL_RESERVED30__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED30__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED31
#define PLL_MACRO_CNTL_RESERVED31__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED31__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED32
#define PLL_MACRO_CNTL_RESERVED32__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED32__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED33
#define PLL_MACRO_CNTL_RESERVED33__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED33__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED34
#define PLL_MACRO_CNTL_RESERVED34__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED34__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED35
#define PLL_MACRO_CNTL_RESERVED35__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED35__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED36
#define PLL_MACRO_CNTL_RESERVED36__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED36__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED37
#define PLL_MACRO_CNTL_RESERVED37__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED37__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED38
#define PLL_MACRO_CNTL_RESERVED38__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED38__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED39
#define PLL_MACRO_CNTL_RESERVED39__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED39__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED40
#define PLL_MACRO_CNTL_RESERVED40__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED40__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED41
#define PLL_MACRO_CNTL_RESERVED41__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED41__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL


// addressBlock: dce_dc_dmu_rbbmif_dispdec
//RBBMIF_TIMEOUT
#define RBBMIF_TIMEOUT__RBBMIF_TIMEOUT_DELAY__SHIFT                                                           0x0
#define RBBMIF_TIMEOUT__RBBMIF_TIMEOUT_TO_REQ_HOLD__SHIFT                                                     0x14
#define RBBMIF_TIMEOUT__RBBMIF_TIMEOUT_DELAY_MASK                                                             0x000FFFFFL
#define RBBMIF_TIMEOUT__RBBMIF_TIMEOUT_TO_REQ_HOLD_MASK                                                       0xFFF00000L
//RBBMIF_STATUS
#define RBBMIF_STATUS__RBBMIF_TIMEOUT_CLIENTS_DEC__SHIFT                                                      0x0
#define RBBMIF_STATUS__RBBMIF_TIMEOUT_CLIENTS_DEC_MASK                                                        0x3FFFFFFFL
//RBBMIF_INT_STATUS
#define RBBMIF_INT_STATUS__RBBMIF_TIMEOUT_OP__SHIFT                                                           0x1c
#define RBBMIF_INT_STATUS__RBBMIF_TIMEOUT_RDWR_STATUS__SHIFT                                                  0x1d
#define RBBMIF_INT_STATUS__RBBMIF_TIMEOUT_ACK__SHIFT                                                          0x1e
#define RBBMIF_INT_STATUS__RBBMIF_TIMEOUT_MASK__SHIFT                                                         0x1f
#define RBBMIF_INT_STATUS__RBBMIF_TIMEOUT_OP_MASK                                                             0x10000000L
#define RBBMIF_INT_STATUS__RBBMIF_TIMEOUT_RDWR_STATUS_MASK                                                    0x20000000L
#define RBBMIF_INT_STATUS__RBBMIF_TIMEOUT_ACK_MASK                                                            0x40000000L
#define RBBMIF_INT_STATUS__RBBMIF_TIMEOUT_MASK_MASK                                                           0x80000000L
//RBBMIF_TIMEOUT_DIS
#define RBBMIF_TIMEOUT_DIS__CLIENT0_TIMEOUT_DIS__SHIFT                                                        0x0
#define RBBMIF_TIMEOUT_DIS__CLIENT1_TIMEOUT_DIS__SHIFT                                                        0x1
#define RBBMIF_TIMEOUT_DIS__CLIENT2_TIMEOUT_DIS__SHIFT                                                        0x2
#define RBBMIF_TIMEOUT_DIS__CLIENT3_TIMEOUT_DIS__SHIFT                                                        0x3
#define RBBMIF_TIMEOUT_DIS__CLIENT4_TIMEOUT_DIS__SHIFT                                                        0x4
#define RBBMIF_TIMEOUT_DIS__CLIENT5_TIMEOUT_DIS__SHIFT                                                        0x5
#define RBBMIF_TIMEOUT_DIS__CLIENT6_TIMEOUT_DIS__SHIFT                                                        0x6
#define RBBMIF_TIMEOUT_DIS__CLIENT7_TIMEOUT_DIS__SHIFT                                                        0x7
#define RBBMIF_TIMEOUT_DIS__CLIENT8_TIMEOUT_DIS__SHIFT                                                        0x8
#define RBBMIF_TIMEOUT_DIS__CLIENT9_TIMEOUT_DIS__SHIFT                                                        0x9
#define RBBMIF_TIMEOUT_DIS__CLIENT10_TIMEOUT_DIS__SHIFT                                                       0xa
#define RBBMIF_TIMEOUT_DIS__CLIENT11_TIMEOUT_DIS__SHIFT                                                       0xb
#define RBBMIF_TIMEOUT_DIS__CLIENT12_TIMEOUT_DIS__SHIFT                                                       0xc
#define RBBMIF_TIMEOUT_DIS__CLIENT13_TIMEOUT_DIS__SHIFT                                                       0xd
#define RBBMIF_TIMEOUT_DIS__CLIENT14_TIMEOUT_DIS__SHIFT                                                       0xe
#define RBBMIF_TIMEOUT_DIS__CLIENT15_TIMEOUT_DIS__SHIFT                                                       0xf
#define RBBMIF_TIMEOUT_DIS__CLIENT16_TIMEOUT_DIS__SHIFT                                                       0x10
#define RBBMIF_TIMEOUT_DIS__CLIENT17_TIMEOUT_DIS__SHIFT                                                       0x11
#define RBBMIF_TIMEOUT_DIS__CLIENT18_TIMEOUT_DIS__SHIFT                                                       0x12
#define RBBMIF_TIMEOUT_DIS__CLIENT19_TIMEOUT_DIS__SHIFT                                                       0x13
#define RBBMIF_TIMEOUT_DIS__CLIENT20_TIMEOUT_DIS__SHIFT                                                       0x14
#define RBBMIF_TIMEOUT_DIS__CLIENT21_TIMEOUT_DIS__SHIFT                                                       0x15
#define RBBMIF_TIMEOUT_DIS__CLIENT22_TIMEOUT_DIS__SHIFT                                                       0x16
#define RBBMIF_TIMEOUT_DIS__CLIENT23_TIMEOUT_DIS__SHIFT                                                       0x17
#define RBBMIF_TIMEOUT_DIS__CLIENT24_TIMEOUT_DIS__SHIFT                                                       0x18
#define RBBMIF_TIMEOUT_DIS__CLIENT25_TIMEOUT_DIS__SHIFT                                                       0x19
#define RBBMIF_TIMEOUT_DIS__CLIENT26_TIMEOUT_DIS__SHIFT                                                       0x1a
#define RBBMIF_TIMEOUT_DIS__CLIENT27_TIMEOUT_DIS__SHIFT                                                       0x1b
#define RBBMIF_TIMEOUT_DIS__CLIENT28_TIMEOUT_DIS__SHIFT                                                       0x1c
#define RBBMIF_TIMEOUT_DIS__CLIENT29_TIMEOUT_DIS__SHIFT                                                       0x1d
#define RBBMIF_TIMEOUT_DIS__CLIENT0_TIMEOUT_DIS_MASK                                                          0x00000001L
#define RBBMIF_TIMEOUT_DIS__CLIENT1_TIMEOUT_DIS_MASK                                                          0x00000002L
#define RBBMIF_TIMEOUT_DIS__CLIENT2_TIMEOUT_DIS_MASK                                                          0x00000004L
#define RBBMIF_TIMEOUT_DIS__CLIENT3_TIMEOUT_DIS_MASK                                                          0x00000008L
#define RBBMIF_TIMEOUT_DIS__CLIENT4_TIMEOUT_DIS_MASK                                                          0x00000010L
#define RBBMIF_TIMEOUT_DIS__CLIENT5_TIMEOUT_DIS_MASK                                                          0x00000020L
#define RBBMIF_TIMEOUT_DIS__CLIENT6_TIMEOUT_DIS_MASK                                                          0x00000040L
#define RBBMIF_TIMEOUT_DIS__CLIENT7_TIMEOUT_DIS_MASK                                                          0x00000080L
#define RBBMIF_TIMEOUT_DIS__CLIENT8_TIMEOUT_DIS_MASK                                                          0x00000100L
#define RBBMIF_TIMEOUT_DIS__CLIENT9_TIMEOUT_DIS_MASK                                                          0x00000200L
#define RBBMIF_TIMEOUT_DIS__CLIENT10_TIMEOUT_DIS_MASK                                                         0x00000400L
#define RBBMIF_TIMEOUT_DIS__CLIENT11_TIMEOUT_DIS_MASK                                                         0x00000800L
#define RBBMIF_TIMEOUT_DIS__CLIENT12_TIMEOUT_DIS_MASK                                                         0x00001000L
#define RBBMIF_TIMEOUT_DIS__CLIENT13_TIMEOUT_DIS_MASK                                                         0x00002000L
#define RBBMIF_TIMEOUT_DIS__CLIENT14_TIMEOUT_DIS_MASK                                                         0x00004000L
#define RBBMIF_TIMEOUT_DIS__CLIENT15_TIMEOUT_DIS_MASK                                                         0x00008000L
#define RBBMIF_TIMEOUT_DIS__CLIENT16_TIMEOUT_DIS_MASK                                                         0x00010000L
#define RBBMIF_TIMEOUT_DIS__CLIENT17_TIMEOUT_DIS_MASK                                                         0x00020000L
#define RBBMIF_TIMEOUT_DIS__CLIENT18_TIMEOUT_DIS_MASK                                                         0x00040000L
#define RBBMIF_TIMEOUT_DIS__CLIENT19_TIMEOUT_DIS_MASK                                                         0x00080000L
#define RBBMIF_TIMEOUT_DIS__CLIENT20_TIMEOUT_DIS_MASK                                                         0x00100000L
#define RBBMIF_TIMEOUT_DIS__CLIENT21_TIMEOUT_DIS_MASK                                                         0x00200000L
#define RBBMIF_TIMEOUT_DIS__CLIENT22_TIMEOUT_DIS_MASK                                                         0x00400000L
#define RBBMIF_TIMEOUT_DIS__CLIENT23_TIMEOUT_DIS_MASK                                                         0x00800000L
#define RBBMIF_TIMEOUT_DIS__CLIENT24_TIMEOUT_DIS_MASK                                                         0x01000000L
#define RBBMIF_TIMEOUT_DIS__CLIENT25_TIMEOUT_DIS_MASK                                                         0x02000000L
#define RBBMIF_TIMEOUT_DIS__CLIENT26_TIMEOUT_DIS_MASK                                                         0x04000000L
#define RBBMIF_TIMEOUT_DIS__CLIENT27_TIMEOUT_DIS_MASK                                                         0x08000000L
#define RBBMIF_TIMEOUT_DIS__CLIENT28_TIMEOUT_DIS_MASK                                                         0x10000000L
#define RBBMIF_TIMEOUT_DIS__CLIENT29_TIMEOUT_DIS_MASK                                                         0x20000000L
//RBBMIF_STATUS_FLAG
#define RBBMIF_STATUS_FLAG__RBBMIF_STATE__SHIFT                                                               0x0
#define RBBMIF_STATUS_FLAG__RBBMIF_READ_TIMEOUT__SHIFT                                                        0x4
#define RBBMIF_STATUS_FLAG__RBBMIF_FIFO_EMPTY__SHIFT                                                          0x5
#define RBBMIF_STATUS_FLAG__RBBMIF_FIFO_FULL__SHIFT                                                           0x6
#define RBBMIF_STATUS_FLAG__RBBMIF_INVALID_ACCESS_FLAG__SHIFT                                                 0x8
#define RBBMIF_STATUS_FLAG__RBBMIF_INVALID_ACCESS_TYPE__SHIFT                                                 0x9
#define RBBMIF_STATUS_FLAG__RBBMIF_INVALID_ACCESS_ADDR__SHIFT                                                 0x10
#define RBBMIF_STATUS_FLAG__RBBMIF_STATE_MASK                                                                 0x00000003L
#define RBBMIF_STATUS_FLAG__RBBMIF_READ_TIMEOUT_MASK                                                          0x00000010L
#define RBBMIF_STATUS_FLAG__RBBMIF_FIFO_EMPTY_MASK                                                            0x00000020L
#define RBBMIF_STATUS_FLAG__RBBMIF_FIFO_FULL_MASK                                                             0x00000040L
#define RBBMIF_STATUS_FLAG__RBBMIF_INVALID_ACCESS_FLAG_MASK                                                   0x00000100L
#define RBBMIF_STATUS_FLAG__RBBMIF_INVALID_ACCESS_TYPE_MASK                                                   0x00000E00L
#define RBBMIF_STATUS_FLAG__RBBMIF_INVALID_ACCESS_ADDR_MASK                                                   0xFFFF0000L


// addressBlock: dce_dc_dmu_dc_pg_dispdec
//DOMAIN0_PG_CONFIG
#define DOMAIN0_PG_CONFIG__DOMAIN0_POWER_FORCEON__SHIFT                                                       0x0
#define DOMAIN0_PG_CONFIG__DOMAIN0_POWER_GATE__SHIFT                                                          0x8
#define DOMAIN0_PG_CONFIG__DOMAIN0_POWER_FORCEON_MASK                                                         0x00000001L
#define DOMAIN0_PG_CONFIG__DOMAIN0_POWER_GATE_MASK                                                            0x00000100L
//DOMAIN0_PG_STATUS
#define DOMAIN0_PG_STATUS__DOMAIN0_DESIRED_PWR_STATE__SHIFT                                                   0x1c
#define DOMAIN0_PG_STATUS__DOMAIN0_PGFSM_PWR_STATUS__SHIFT                                                    0x1e
#define DOMAIN0_PG_STATUS__DOMAIN0_DESIRED_PWR_STATE_MASK                                                     0x10000000L
#define DOMAIN0_PG_STATUS__DOMAIN0_PGFSM_PWR_STATUS_MASK                                                      0xC0000000L
//DOMAIN1_PG_CONFIG
#define DOMAIN1_PG_CONFIG__DOMAIN1_POWER_FORCEON__SHIFT                                                       0x0
#define DOMAIN1_PG_CONFIG__DOMAIN1_POWER_GATE__SHIFT                                                          0x8
#define DOMAIN1_PG_CONFIG__DOMAIN1_POWER_FORCEON_MASK                                                         0x00000001L
#define DOMAIN1_PG_CONFIG__DOMAIN1_POWER_GATE_MASK                                                            0x00000100L
//DOMAIN1_PG_STATUS
#define DOMAIN1_PG_STATUS__DOMAIN1_DESIRED_PWR_STATE__SHIFT                                                   0x1c
#define DOMAIN1_PG_STATUS__DOMAIN1_PGFSM_PWR_STATUS__SHIFT                                                    0x1e
#define DOMAIN1_PG_STATUS__DOMAIN1_DESIRED_PWR_STATE_MASK                                                     0x10000000L
#define DOMAIN1_PG_STATUS__DOMAIN1_PGFSM_PWR_STATUS_MASK                                                      0xC0000000L
//DOMAIN2_PG_CONFIG
#define DOMAIN2_PG_CONFIG__DOMAIN2_POWER_FORCEON__SHIFT                                                       0x0
#define DOMAIN2_PG_CONFIG__DOMAIN2_POWER_GATE__SHIFT                                                          0x8
#define DOMAIN2_PG_CONFIG__DOMAIN2_POWER_FORCEON_MASK                                                         0x00000001L
#define DOMAIN2_PG_CONFIG__DOMAIN2_POWER_GATE_MASK                                                            0x00000100L
//DOMAIN2_PG_STATUS
#define DOMAIN2_PG_STATUS__DOMAIN2_DESIRED_PWR_STATE__SHIFT                                                   0x1c
#define DOMAIN2_PG_STATUS__DOMAIN2_PGFSM_PWR_STATUS__SHIFT                                                    0x1e
#define DOMAIN2_PG_STATUS__DOMAIN2_DESIRED_PWR_STATE_MASK                                                     0x10000000L
#define DOMAIN2_PG_STATUS__DOMAIN2_PGFSM_PWR_STATUS_MASK                                                      0xC0000000L
//DOMAIN3_PG_CONFIG
#define DOMAIN3_PG_CONFIG__DOMAIN3_POWER_FORCEON__SHIFT                                                       0x0
#define DOMAIN3_PG_CONFIG__DOMAIN3_POWER_GATE__SHIFT                                                          0x8
#define DOMAIN3_PG_CONFIG__DOMAIN3_POWER_FORCEON_MASK                                                         0x00000001L
#define DOMAIN3_PG_CONFIG__DOMAIN3_POWER_GATE_MASK                                                            0x00000100L
//DOMAIN3_PG_STATUS
#define DOMAIN3_PG_STATUS__DOMAIN3_DESIRED_PWR_STATE__SHIFT                                                   0x1c
#define DOMAIN3_PG_STATUS__DOMAIN3_PGFSM_PWR_STATUS__SHIFT                                                    0x1e
#define DOMAIN3_PG_STATUS__DOMAIN3_DESIRED_PWR_STATE_MASK                                                     0x10000000L
#define DOMAIN3_PG_STATUS__DOMAIN3_PGFSM_PWR_STATUS_MASK                                                      0xC0000000L
//DOMAIN4_PG_CONFIG
#define DOMAIN4_PG_CONFIG__DOMAIN4_POWER_FORCEON__SHIFT                                                       0x0
#define DOMAIN4_PG_CONFIG__DOMAIN4_POWER_GATE__SHIFT                                                          0x8
#define DOMAIN4_PG_CONFIG__DOMAIN4_POWER_FORCEON_MASK                                                         0x00000001L
#define DOMAIN4_PG_CONFIG__DOMAIN4_POWER_GATE_MASK                                                            0x00000100L
//DOMAIN4_PG_STATUS
#define DOMAIN4_PG_STATUS__DOMAIN4_DESIRED_PWR_STATE__SHIFT                                                   0x1c
#define DOMAIN4_PG_STATUS__DOMAIN4_PGFSM_PWR_STATUS__SHIFT                                                    0x1e
#define DOMAIN4_PG_STATUS__DOMAIN4_DESIRED_PWR_STATE_MASK                                                     0x10000000L
#define DOMAIN4_PG_STATUS__DOMAIN4_PGFSM_PWR_STATUS_MASK                                                      0xC0000000L
//DOMAIN5_PG_CONFIG
#define DOMAIN5_PG_CONFIG__DOMAIN5_POWER_FORCEON__SHIFT                                                       0x0
#define DOMAIN5_PG_CONFIG__DOMAIN5_POWER_GATE__SHIFT                                                          0x8
#define DOMAIN5_PG_CONFIG__DOMAIN5_POWER_FORCEON_MASK                                                         0x00000001L
#define DOMAIN5_PG_CONFIG__DOMAIN5_POWER_GATE_MASK                                                            0x00000100L
//DOMAIN5_PG_STATUS
#define DOMAIN5_PG_STATUS__DOMAIN5_DESIRED_PWR_STATE__SHIFT                                                   0x1c
#define DOMAIN5_PG_STATUS__DOMAIN5_PGFSM_PWR_STATUS__SHIFT                                                    0x1e
#define DOMAIN5_PG_STATUS__DOMAIN5_DESIRED_PWR_STATE_MASK                                                     0x10000000L
#define DOMAIN5_PG_STATUS__DOMAIN5_PGFSM_PWR_STATUS_MASK                                                      0xC0000000L
//DOMAIN6_PG_CONFIG
#define DOMAIN6_PG_CONFIG__DOMAIN6_POWER_FORCEON__SHIFT                                                       0x0
#define DOMAIN6_PG_CONFIG__DOMAIN6_POWER_GATE__SHIFT                                                          0x8
#define DOMAIN6_PG_CONFIG__DOMAIN6_POWER_FORCEON_MASK                                                         0x00000001L
#define DOMAIN6_PG_CONFIG__DOMAIN6_POWER_GATE_MASK                                                            0x00000100L
//DOMAIN6_PG_STATUS
#define DOMAIN6_PG_STATUS__DOMAIN6_DESIRED_PWR_STATE__SHIFT                                                   0x1c
#define DOMAIN6_PG_STATUS__DOMAIN6_PGFSM_PWR_STATUS__SHIFT                                                    0x1e
#define DOMAIN6_PG_STATUS__DOMAIN6_DESIRED_PWR_STATE_MASK                                                     0x10000000L
#define DOMAIN6_PG_STATUS__DOMAIN6_PGFSM_PWR_STATUS_MASK                                                      0xC0000000L
//DOMAIN7_PG_CONFIG
#define DOMAIN7_PG_CONFIG__DOMAIN7_POWER_FORCEON__SHIFT                                                       0x0
#define DOMAIN7_PG_CONFIG__DOMAIN7_POWER_GATE__SHIFT                                                          0x8
#define DOMAIN7_PG_CONFIG__DOMAIN7_POWER_FORCEON_MASK                                                         0x00000001L
#define DOMAIN7_PG_CONFIG__DOMAIN7_POWER_GATE_MASK                                                            0x00000100L
//DOMAIN7_PG_STATUS
#define DOMAIN7_PG_STATUS__DOMAIN7_DESIRED_PWR_STATE__SHIFT                                                   0x1c
#define DOMAIN7_PG_STATUS__DOMAIN7_PGFSM_PWR_STATUS__SHIFT                                                    0x1e
#define DOMAIN7_PG_STATUS__DOMAIN7_DESIRED_PWR_STATE_MASK                                                     0x10000000L
#define DOMAIN7_PG_STATUS__DOMAIN7_PGFSM_PWR_STATUS_MASK                                                      0xC0000000L
//DOMAIN8_PG_CONFIG
#define DOMAIN8_PG_CONFIG__DOMAIN8_POWER_FORCEON__SHIFT                                                       0x0
#define DOMAIN8_PG_CONFIG__DOMAIN8_POWER_GATE__SHIFT                                                          0x8
#define DOMAIN8_PG_CONFIG__DOMAIN8_POWER_FORCEON_MASK                                                         0x00000001L
#define DOMAIN8_PG_CONFIG__DOMAIN8_POWER_GATE_MASK                                                            0x00000100L
//DOMAIN8_PG_STATUS
#define DOMAIN8_PG_STATUS__DOMAIN8_DESIRED_PWR_STATE__SHIFT                                                   0x1c
#define DOMAIN8_PG_STATUS__DOMAIN8_PGFSM_PWR_STATUS__SHIFT                                                    0x1e
#define DOMAIN8_PG_STATUS__DOMAIN8_DESIRED_PWR_STATE_MASK                                                     0x10000000L
#define DOMAIN8_PG_STATUS__DOMAIN8_PGFSM_PWR_STATUS_MASK                                                      0xC0000000L
//DOMAIN9_PG_CONFIG
#define DOMAIN9_PG_CONFIG__DOMAIN9_POWER_FORCEON__SHIFT                                                       0x0
#define DOMAIN9_PG_CONFIG__DOMAIN9_POWER_GATE__SHIFT                                                          0x8
#define DOMAIN9_PG_CONFIG__DOMAIN9_POWER_FORCEON_MASK                                                         0x00000001L
#define DOMAIN9_PG_CONFIG__DOMAIN9_POWER_GATE_MASK                                                            0x00000100L
//DOMAIN9_PG_STATUS
#define DOMAIN9_PG_STATUS__DOMAIN9_DESIRED_PWR_STATE__SHIFT                                                   0x1c
#define DOMAIN9_PG_STATUS__DOMAIN9_PGFSM_PWR_STATUS__SHIFT                                                    0x1e
#define DOMAIN9_PG_STATUS__DOMAIN9_DESIRED_PWR_STATE_MASK                                                     0x10000000L
#define DOMAIN9_PG_STATUS__DOMAIN9_PGFSM_PWR_STATUS_MASK                                                      0xC0000000L
//DOMAIN10_PG_CONFIG
#define DOMAIN10_PG_CONFIG__DOMAIN10_POWER_FORCEON__SHIFT                                                     0x0
#define DOMAIN10_PG_CONFIG__DOMAIN10_POWER_GATE__SHIFT                                                        0x8
#define DOMAIN10_PG_CONFIG__DOMAIN10_POWER_FORCEON_MASK                                                       0x00000001L
#define DOMAIN10_PG_CONFIG__DOMAIN10_POWER_GATE_MASK                                                          0x00000100L
//DOMAIN10_PG_STATUS
#define DOMAIN10_PG_STATUS__DOMAIN10_DESIRED_PWR_STATE__SHIFT                                                 0x1c
#define DOMAIN10_PG_STATUS__DOMAIN10_PGFSM_PWR_STATUS__SHIFT                                                  0x1e
#define DOMAIN10_PG_STATUS__DOMAIN10_DESIRED_PWR_STATE_MASK                                                   0x10000000L
#define DOMAIN10_PG_STATUS__DOMAIN10_PGFSM_PWR_STATUS_MASK                                                    0xC0000000L
//DOMAIN11_PG_CONFIG
#define DOMAIN11_PG_CONFIG__DOMAIN11_POWER_FORCEON__SHIFT                                                     0x0
#define DOMAIN11_PG_CONFIG__DOMAIN11_POWER_GATE__SHIFT                                                        0x8
#define DOMAIN11_PG_CONFIG__DOMAIN11_POWER_FORCEON_MASK                                                       0x00000001L
#define DOMAIN11_PG_CONFIG__DOMAIN11_POWER_GATE_MASK                                                          0x00000100L
//DOMAIN11_PG_STATUS
#define DOMAIN11_PG_STATUS__DOMAIN11_DESIRED_PWR_STATE__SHIFT                                                 0x1c
#define DOMAIN11_PG_STATUS__DOMAIN11_PGFSM_PWR_STATUS__SHIFT                                                  0x1e
#define DOMAIN11_PG_STATUS__DOMAIN11_DESIRED_PWR_STATE_MASK                                                   0x10000000L
#define DOMAIN11_PG_STATUS__DOMAIN11_PGFSM_PWR_STATUS_MASK                                                    0xC0000000L
//DOMAIN12_PG_CONFIG
#define DOMAIN12_PG_CONFIG__DOMAIN12_POWER_FORCEON__SHIFT                                                     0x0
#define DOMAIN12_PG_CONFIG__DOMAIN12_POWER_GATE__SHIFT                                                        0x8
#define DOMAIN12_PG_CONFIG__DOMAIN12_POWER_FORCEON_MASK                                                       0x00000001L
#define DOMAIN12_PG_CONFIG__DOMAIN12_POWER_GATE_MASK                                                          0x00000100L
//DOMAIN12_PG_STATUS
#define DOMAIN12_PG_STATUS__DOMAIN12_DESIRED_PWR_STATE__SHIFT                                                 0x1c
#define DOMAIN12_PG_STATUS__DOMAIN12_PGFSM_PWR_STATUS__SHIFT                                                  0x1e
#define DOMAIN12_PG_STATUS__DOMAIN12_DESIRED_PWR_STATE_MASK                                                   0x10000000L
#define DOMAIN12_PG_STATUS__DOMAIN12_PGFSM_PWR_STATUS_MASK                                                    0xC0000000L
//DOMAIN13_PG_CONFIG
#define DOMAIN13_PG_CONFIG__DOMAIN13_POWER_FORCEON__SHIFT                                                     0x0
#define DOMAIN13_PG_CONFIG__DOMAIN13_POWER_GATE__SHIFT                                                        0x8
#define DOMAIN13_PG_CONFIG__DOMAIN13_POWER_FORCEON_MASK                                                       0x00000001L
#define DOMAIN13_PG_CONFIG__DOMAIN13_POWER_GATE_MASK                                                          0x00000100L
//DOMAIN13_PG_STATUS
#define DOMAIN13_PG_STATUS__DOMAIN13_DESIRED_PWR_STATE__SHIFT                                                 0x1c
#define DOMAIN13_PG_STATUS__DOMAIN13_PGFSM_PWR_STATUS__SHIFT                                                  0x1e
#define DOMAIN13_PG_STATUS__DOMAIN13_DESIRED_PWR_STATE_MASK                                                   0x10000000L
#define DOMAIN13_PG_STATUS__DOMAIN13_PGFSM_PWR_STATUS_MASK                                                    0xC0000000L
//DOMAIN14_PG_CONFIG
#define DOMAIN14_PG_CONFIG__DOMAIN14_POWER_FORCEON__SHIFT                                                     0x0
#define DOMAIN14_PG_CONFIG__DOMAIN14_POWER_GATE__SHIFT                                                        0x8
#define DOMAIN14_PG_CONFIG__DOMAIN14_POWER_FORCEON_MASK                                                       0x00000001L
#define DOMAIN14_PG_CONFIG__DOMAIN14_POWER_GATE_MASK                                                          0x00000100L
//DOMAIN14_PG_STATUS
#define DOMAIN14_PG_STATUS__DOMAIN14_DESIRED_PWR_STATE__SHIFT                                                 0x1c
#define DOMAIN14_PG_STATUS__DOMAIN14_PGFSM_PWR_STATUS__SHIFT                                                  0x1e
#define DOMAIN14_PG_STATUS__DOMAIN14_DESIRED_PWR_STATE_MASK                                                   0x10000000L
#define DOMAIN14_PG_STATUS__DOMAIN14_PGFSM_PWR_STATUS_MASK                                                    0xC0000000L
//DOMAIN15_PG_CONFIG
#define DOMAIN15_PG_CONFIG__DOMAIN15_POWER_FORCEON__SHIFT                                                     0x0
#define DOMAIN15_PG_CONFIG__DOMAIN15_POWER_GATE__SHIFT                                                        0x8
#define DOMAIN15_PG_CONFIG__DOMAIN15_POWER_FORCEON_MASK                                                       0x00000001L
#define DOMAIN15_PG_CONFIG__DOMAIN15_POWER_GATE_MASK                                                          0x00000100L
//DOMAIN15_PG_STATUS
#define DOMAIN15_PG_STATUS__DOMAIN15_DESIRED_PWR_STATE__SHIFT                                                 0x1c
#define DOMAIN15_PG_STATUS__DOMAIN15_PGFSM_PWR_STATUS__SHIFT                                                  0x1e
#define DOMAIN15_PG_STATUS__DOMAIN15_DESIRED_PWR_STATE_MASK                                                   0x10000000L
#define DOMAIN15_PG_STATUS__DOMAIN15_PGFSM_PWR_STATUS_MASK                                                    0xC0000000L
//DCPG_INTERRUPT_STATUS
#define DCPG_INTERRUPT_STATUS__DOMAIN0_POWER_UP_INT_OCCURRED__SHIFT                                           0x0
#define DCPG_INTERRUPT_STATUS__DOMAIN0_POWER_DOWN_INT_OCCURRED__SHIFT                                         0x1
#define DCPG_INTERRUPT_STATUS__DOMAIN1_POWER_UP_INT_OCCURRED__SHIFT                                           0x2
#define DCPG_INTERRUPT_STATUS__DOMAIN1_POWER_DOWN_INT_OCCURRED__SHIFT                                         0x3
#define DCPG_INTERRUPT_STATUS__DOMAIN2_POWER_UP_INT_OCCURRED__SHIFT                                           0x4
#define DCPG_INTERRUPT_STATUS__DOMAIN2_POWER_DOWN_INT_OCCURRED__SHIFT                                         0x5
#define DCPG_INTERRUPT_STATUS__DOMAIN3_POWER_UP_INT_OCCURRED__SHIFT                                           0x6
#define DCPG_INTERRUPT_STATUS__DOMAIN3_POWER_DOWN_INT_OCCURRED__SHIFT                                         0x7
#define DCPG_INTERRUPT_STATUS__DOMAIN4_POWER_UP_INT_OCCURRED__SHIFT                                           0x8
#define DCPG_INTERRUPT_STATUS__DOMAIN4_POWER_DOWN_INT_OCCURRED__SHIFT                                         0x9
#define DCPG_INTERRUPT_STATUS__DOMAIN5_POWER_UP_INT_OCCURRED__SHIFT                                           0xa
#define DCPG_INTERRUPT_STATUS__DOMAIN5_POWER_DOWN_INT_OCCURRED__SHIFT                                         0xb
#define DCPG_INTERRUPT_STATUS__DOMAIN6_POWER_UP_INT_OCCURRED__SHIFT                                           0xc
#define DCPG_INTERRUPT_STATUS__DOMAIN6_POWER_DOWN_INT_OCCURRED__SHIFT                                         0xd
#define DCPG_INTERRUPT_STATUS__DOMAIN7_POWER_UP_INT_OCCURRED__SHIFT                                           0xe
#define DCPG_INTERRUPT_STATUS__DOMAIN7_POWER_DOWN_INT_OCCURRED__SHIFT                                         0xf
#define DCPG_INTERRUPT_STATUS__DOMAIN8_POWER_UP_INT_OCCURRED__SHIFT                                           0x10
#define DCPG_INTERRUPT_STATUS__DOMAIN8_POWER_DOWN_INT_OCCURRED__SHIFT                                         0x11
#define DCPG_INTERRUPT_STATUS__DOMAIN9_POWER_UP_INT_OCCURRED__SHIFT                                           0x12
#define DCPG_INTERRUPT_STATUS__DOMAIN9_POWER_DOWN_INT_OCCURRED__SHIFT                                         0x13
#define DCPG_INTERRUPT_STATUS__DOMAIN10_POWER_UP_INT_OCCURRED__SHIFT                                          0x14
#define DCPG_INTERRUPT_STATUS__DOMAIN10_POWER_DOWN_INT_OCCURRED__SHIFT                                        0x15
#define DCPG_INTERRUPT_STATUS__DOMAIN11_POWER_UP_INT_OCCURRED__SHIFT                                          0x16
#define DCPG_INTERRUPT_STATUS__DOMAIN11_POWER_DOWN_INT_OCCURRED__SHIFT                                        0x17
#define DCPG_INTERRUPT_STATUS__DOMAIN12_POWER_UP_INT_OCCURRED__SHIFT                                          0x18
#define DCPG_INTERRUPT_STATUS__DOMAIN12_POWER_DOWN_INT_OCCURRED__SHIFT                                        0x19
#define DCPG_INTERRUPT_STATUS__DOMAIN13_POWER_UP_INT_OCCURRED__SHIFT                                          0x1a
#define DCPG_INTERRUPT_STATUS__DOMAIN13_POWER_DOWN_INT_OCCURRED__SHIFT                                        0x1b
#define DCPG_INTERRUPT_STATUS__DOMAIN14_POWER_UP_INT_OCCURRED__SHIFT                                          0x1c
#define DCPG_INTERRUPT_STATUS__DOMAIN14_POWER_DOWN_INT_OCCURRED__SHIFT                                        0x1d
#define DCPG_INTERRUPT_STATUS__DOMAIN15_POWER_UP_INT_OCCURRED__SHIFT                                          0x1e
#define DCPG_INTERRUPT_STATUS__DOMAIN15_POWER_DOWN_INT_OCCURRED__SHIFT                                        0x1f
#define DCPG_INTERRUPT_STATUS__DOMAIN0_POWER_UP_INT_OCCURRED_MASK                                             0x00000001L
#define DCPG_INTERRUPT_STATUS__DOMAIN0_POWER_DOWN_INT_OCCURRED_MASK                                           0x00000002L
#define DCPG_INTERRUPT_STATUS__DOMAIN1_POWER_UP_INT_OCCURRED_MASK                                             0x00000004L
#define DCPG_INTERRUPT_STATUS__DOMAIN1_POWER_DOWN_INT_OCCURRED_MASK                                           0x00000008L
#define DCPG_INTERRUPT_STATUS__DOMAIN2_POWER_UP_INT_OCCURRED_MASK                                             0x00000010L
#define DCPG_INTERRUPT_STATUS__DOMAIN2_POWER_DOWN_INT_OCCURRED_MASK                                           0x00000020L
#define DCPG_INTERRUPT_STATUS__DOMAIN3_POWER_UP_INT_OCCURRED_MASK                                             0x00000040L
#define DCPG_INTERRUPT_STATUS__DOMAIN3_POWER_DOWN_INT_OCCURRED_MASK                                           0x00000080L
#define DCPG_INTERRUPT_STATUS__DOMAIN4_POWER_UP_INT_OCCURRED_MASK                                             0x00000100L
#define DCPG_INTERRUPT_STATUS__DOMAIN4_POWER_DOWN_INT_OCCURRED_MASK                                           0x00000200L
#define DCPG_INTERRUPT_STATUS__DOMAIN5_POWER_UP_INT_OCCURRED_MASK                                             0x00000400L
#define DCPG_INTERRUPT_STATUS__DOMAIN5_POWER_DOWN_INT_OCCURRED_MASK                                           0x00000800L
#define DCPG_INTERRUPT_STATUS__DOMAIN6_POWER_UP_INT_OCCURRED_MASK                                             0x00001000L
#define DCPG_INTERRUPT_STATUS__DOMAIN6_POWER_DOWN_INT_OCCURRED_MASK                                           0x00002000L
#define DCPG_INTERRUPT_STATUS__DOMAIN7_POWER_UP_INT_OCCURRED_MASK                                             0x00004000L
#define DCPG_INTERRUPT_STATUS__DOMAIN7_POWER_DOWN_INT_OCCURRED_MASK                                           0x00008000L
#define DCPG_INTERRUPT_STATUS__DOMAIN8_POWER_UP_INT_OCCURRED_MASK                                             0x00010000L
#define DCPG_INTERRUPT_STATUS__DOMAIN8_POWER_DOWN_INT_OCCURRED_MASK                                           0x00020000L
#define DCPG_INTERRUPT_STATUS__DOMAIN9_POWER_UP_INT_OCCURRED_MASK                                             0x00040000L
#define DCPG_INTERRUPT_STATUS__DOMAIN9_POWER_DOWN_INT_OCCURRED_MASK                                           0x00080000L
#define DCPG_INTERRUPT_STATUS__DOMAIN10_POWER_UP_INT_OCCURRED_MASK                                            0x00100000L
#define DCPG_INTERRUPT_STATUS__DOMAIN10_POWER_DOWN_INT_OCCURRED_MASK                                          0x00200000L
#define DCPG_INTERRUPT_STATUS__DOMAIN11_POWER_UP_INT_OCCURRED_MASK                                            0x00400000L
#define DCPG_INTERRUPT_STATUS__DOMAIN11_POWER_DOWN_INT_OCCURRED_MASK                                          0x00800000L
#define DCPG_INTERRUPT_STATUS__DOMAIN12_POWER_UP_INT_OCCURRED_MASK                                            0x01000000L
#define DCPG_INTERRUPT_STATUS__DOMAIN12_POWER_DOWN_INT_OCCURRED_MASK                                          0x02000000L
#define DCPG_INTERRUPT_STATUS__DOMAIN13_POWER_UP_INT_OCCURRED_MASK                                            0x04000000L
#define DCPG_INTERRUPT_STATUS__DOMAIN13_POWER_DOWN_INT_OCCURRED_MASK                                          0x08000000L
#define DCPG_INTERRUPT_STATUS__DOMAIN14_POWER_UP_INT_OCCURRED_MASK                                            0x10000000L
#define DCPG_INTERRUPT_STATUS__DOMAIN14_POWER_DOWN_INT_OCCURRED_MASK                                          0x20000000L
#define DCPG_INTERRUPT_STATUS__DOMAIN15_POWER_UP_INT_OCCURRED_MASK                                            0x40000000L
#define DCPG_INTERRUPT_STATUS__DOMAIN15_POWER_DOWN_INT_OCCURRED_MASK                                          0x80000000L
//DCPG_INTERRUPT_CONTROL_1
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN0_POWER_UP_INT_MASK__SHIFT                                            0x0
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN0_POWER_UP_INT_CLEAR__SHIFT                                           0x1
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN0_POWER_DOWN_INT_MASK__SHIFT                                          0x2
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN0_POWER_DOWN_INT_CLEAR__SHIFT                                         0x3
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN1_POWER_UP_INT_MASK__SHIFT                                            0x4
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN1_POWER_UP_INT_CLEAR__SHIFT                                           0x5
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN1_POWER_DOWN_INT_MASK__SHIFT                                          0x6
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN1_POWER_DOWN_INT_CLEAR__SHIFT                                         0x7
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN2_POWER_UP_INT_MASK__SHIFT                                            0x8
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN2_POWER_UP_INT_CLEAR__SHIFT                                           0x9
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN2_POWER_DOWN_INT_MASK__SHIFT                                          0xa
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN2_POWER_DOWN_INT_CLEAR__SHIFT                                         0xb
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN3_POWER_UP_INT_MASK__SHIFT                                            0xc
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN3_POWER_UP_INT_CLEAR__SHIFT                                           0xd
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN3_POWER_DOWN_INT_MASK__SHIFT                                          0xe
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN3_POWER_DOWN_INT_CLEAR__SHIFT                                         0xf
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN4_POWER_UP_INT_MASK__SHIFT                                            0x10
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN4_POWER_UP_INT_CLEAR__SHIFT                                           0x11
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN4_POWER_DOWN_INT_MASK__SHIFT                                          0x12
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN4_POWER_DOWN_INT_CLEAR__SHIFT                                         0x13
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN5_POWER_UP_INT_MASK__SHIFT                                            0x14
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN5_POWER_UP_INT_CLEAR__SHIFT                                           0x15
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN5_POWER_DOWN_INT_MASK__SHIFT                                          0x16
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN5_POWER_DOWN_INT_CLEAR__SHIFT                                         0x17
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN6_POWER_UP_INT_MASK__SHIFT                                            0x18
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN6_POWER_UP_INT_CLEAR__SHIFT                                           0x19
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN6_POWER_DOWN_INT_MASK__SHIFT                                          0x1a
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN6_POWER_DOWN_INT_CLEAR__SHIFT                                         0x1b
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN7_POWER_UP_INT_MASK__SHIFT                                            0x1c
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN7_POWER_UP_INT_CLEAR__SHIFT                                           0x1d
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN7_POWER_DOWN_INT_MASK__SHIFT                                          0x1e
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN7_POWER_DOWN_INT_CLEAR__SHIFT                                         0x1f
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN0_POWER_UP_INT_MASK_MASK                                              0x00000001L
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN0_POWER_UP_INT_CLEAR_MASK                                             0x00000002L
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN0_POWER_DOWN_INT_MASK_MASK                                            0x00000004L
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN0_POWER_DOWN_INT_CLEAR_MASK                                           0x00000008L
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN1_POWER_UP_INT_MASK_MASK                                              0x00000010L
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN1_POWER_UP_INT_CLEAR_MASK                                             0x00000020L
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN1_POWER_DOWN_INT_MASK_MASK                                            0x00000040L
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN1_POWER_DOWN_INT_CLEAR_MASK                                           0x00000080L
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN2_POWER_UP_INT_MASK_MASK                                              0x00000100L
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN2_POWER_UP_INT_CLEAR_MASK                                             0x00000200L
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN2_POWER_DOWN_INT_MASK_MASK                                            0x00000400L
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN2_POWER_DOWN_INT_CLEAR_MASK                                           0x00000800L
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN3_POWER_UP_INT_MASK_MASK                                              0x00001000L
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN3_POWER_UP_INT_CLEAR_MASK                                             0x00002000L
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN3_POWER_DOWN_INT_MASK_MASK                                            0x00004000L
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN3_POWER_DOWN_INT_CLEAR_MASK                                           0x00008000L
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN4_POWER_UP_INT_MASK_MASK                                              0x00010000L
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN4_POWER_UP_INT_CLEAR_MASK                                             0x00020000L
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN4_POWER_DOWN_INT_MASK_MASK                                            0x00040000L
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN4_POWER_DOWN_INT_CLEAR_MASK                                           0x00080000L
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN5_POWER_UP_INT_MASK_MASK                                              0x00100000L
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN5_POWER_UP_INT_CLEAR_MASK                                             0x00200000L
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN5_POWER_DOWN_INT_MASK_MASK                                            0x00400000L
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN5_POWER_DOWN_INT_CLEAR_MASK                                           0x00800000L
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN6_POWER_UP_INT_MASK_MASK                                              0x01000000L
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN6_POWER_UP_INT_CLEAR_MASK                                             0x02000000L
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN6_POWER_DOWN_INT_MASK_MASK                                            0x04000000L
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN6_POWER_DOWN_INT_CLEAR_MASK                                           0x08000000L
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN7_POWER_UP_INT_MASK_MASK                                              0x10000000L
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN7_POWER_UP_INT_CLEAR_MASK                                             0x20000000L
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN7_POWER_DOWN_INT_MASK_MASK                                            0x40000000L
#define DCPG_INTERRUPT_CONTROL_1__DOMAIN7_POWER_DOWN_INT_CLEAR_MASK                                           0x80000000L
//DCPG_INTERRUPT_CONTROL_2
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN8_POWER_UP_INT_MASK__SHIFT                                            0x0
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN8_POWER_UP_INT_CLEAR__SHIFT                                           0x1
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN8_POWER_DOWN_INT_MASK__SHIFT                                          0x2
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN8_POWER_DOWN_INT_CLEAR__SHIFT                                         0x3
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN9_POWER_UP_INT_MASK__SHIFT                                            0x4
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN9_POWER_UP_INT_CLEAR__SHIFT                                           0x5
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN9_POWER_DOWN_INT_MASK__SHIFT                                          0x6
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN9_POWER_DOWN_INT_CLEAR__SHIFT                                         0x7
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN10_POWER_UP_INT_MASK__SHIFT                                           0x8
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN10_POWER_UP_INT_CLEAR__SHIFT                                          0x9
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN10_POWER_DOWN_INT_MASK__SHIFT                                         0xa
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN10_POWER_DOWN_INT_CLEAR__SHIFT                                        0xb
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN11_POWER_UP_INT_MASK__SHIFT                                           0xc
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN11_POWER_UP_INT_CLEAR__SHIFT                                          0xd
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN11_POWER_DOWN_INT_MASK__SHIFT                                         0xe
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN11_POWER_DOWN_INT_CLEAR__SHIFT                                        0xf
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN12_POWER_UP_INT_MASK__SHIFT                                           0x10
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN12_POWER_UP_INT_CLEAR__SHIFT                                          0x11
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN12_POWER_DOWN_INT_MASK__SHIFT                                         0x12
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN12_POWER_DOWN_INT_CLEAR__SHIFT                                        0x13
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN13_POWER_UP_INT_MASK__SHIFT                                           0x14
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN13_POWER_UP_INT_CLEAR__SHIFT                                          0x15
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN13_POWER_DOWN_INT_MASK__SHIFT                                         0x16
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN13_POWER_DOWN_INT_CLEAR__SHIFT                                        0x17
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN14_POWER_UP_INT_MASK__SHIFT                                           0x18
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN14_POWER_UP_INT_CLEAR__SHIFT                                          0x19
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN14_POWER_DOWN_INT_MASK__SHIFT                                         0x1a
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN14_POWER_DOWN_INT_CLEAR__SHIFT                                        0x1b
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN15_POWER_UP_INT_MASK__SHIFT                                           0x1c
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN15_POWER_UP_INT_CLEAR__SHIFT                                          0x1d
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN15_POWER_DOWN_INT_MASK__SHIFT                                         0x1e
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN15_POWER_DOWN_INT_CLEAR__SHIFT                                        0x1f
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN8_POWER_UP_INT_MASK_MASK                                              0x00000001L
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN8_POWER_UP_INT_CLEAR_MASK                                             0x00000002L
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN8_POWER_DOWN_INT_MASK_MASK                                            0x00000004L
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN8_POWER_DOWN_INT_CLEAR_MASK                                           0x00000008L
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN9_POWER_UP_INT_MASK_MASK                                              0x00000010L
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN9_POWER_UP_INT_CLEAR_MASK                                             0x00000020L
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN9_POWER_DOWN_INT_MASK_MASK                                            0x00000040L
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN9_POWER_DOWN_INT_CLEAR_MASK                                           0x00000080L
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN10_POWER_UP_INT_MASK_MASK                                             0x00000100L
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN10_POWER_UP_INT_CLEAR_MASK                                            0x00000200L
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN10_POWER_DOWN_INT_MASK_MASK                                           0x00000400L
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN10_POWER_DOWN_INT_CLEAR_MASK                                          0x00000800L
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN11_POWER_UP_INT_MASK_MASK                                             0x00001000L
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN11_POWER_UP_INT_CLEAR_MASK                                            0x00002000L
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN11_POWER_DOWN_INT_MASK_MASK                                           0x00004000L
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN11_POWER_DOWN_INT_CLEAR_MASK                                          0x00008000L
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN12_POWER_UP_INT_MASK_MASK                                             0x00010000L
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN12_POWER_UP_INT_CLEAR_MASK                                            0x00020000L
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN12_POWER_DOWN_INT_MASK_MASK                                           0x00040000L
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN12_POWER_DOWN_INT_CLEAR_MASK                                          0x00080000L
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN13_POWER_UP_INT_MASK_MASK                                             0x00100000L
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN13_POWER_UP_INT_CLEAR_MASK                                            0x00200000L
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN13_POWER_DOWN_INT_MASK_MASK                                           0x00400000L
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN13_POWER_DOWN_INT_CLEAR_MASK                                          0x00800000L
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN14_POWER_UP_INT_MASK_MASK                                             0x01000000L
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN14_POWER_UP_INT_CLEAR_MASK                                            0x02000000L
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN14_POWER_DOWN_INT_MASK_MASK                                           0x04000000L
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN14_POWER_DOWN_INT_CLEAR_MASK                                          0x08000000L
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN15_POWER_UP_INT_MASK_MASK                                             0x10000000L
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN15_POWER_UP_INT_CLEAR_MASK                                            0x20000000L
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN15_POWER_DOWN_INT_MASK_MASK                                           0x40000000L
#define DCPG_INTERRUPT_CONTROL_2__DOMAIN15_POWER_DOWN_INT_CLEAR_MASK                                          0x80000000L
//DC_IP_REQUEST_CNTL
#define DC_IP_REQUEST_CNTL__IP_REQUEST_EN__SHIFT                                                              0x0
#define DC_IP_REQUEST_CNTL__IP_REQUEST_EN_MASK                                                                0x00000001L
//DC_PGCNTL_STATUS_REG


// addressBlock: dce_dc_dmu_dmu_dcperfmon_dc_perfmon_dispdec
//DC_PERFMON2_PERFCOUNTER_CNTL
#define DC_PERFMON2_PERFCOUNTER_CNTL__PERFCOUNTER_EVENT_SEL__SHIFT                                            0x0
#define DC_PERFMON2_PERFCOUNTER_CNTL__PERFCOUNTER_CVALUE_SEL__SHIFT                                           0x9
#define DC_PERFMON2_PERFCOUNTER_CNTL__PERFCOUNTER_INC_MODE__SHIFT                                             0xc
#define DC_PERFMON2_PERFCOUNTER_CNTL__PERFCOUNTER_HW_CNTL_SEL__SHIFT                                          0xf
#define DC_PERFMON2_PERFCOUNTER_CNTL__PERFCOUNTER_RUNEN_MODE__SHIFT                                           0x10
#define DC_PERFMON2_PERFCOUNTER_CNTL__PERFCOUNTER_CNTOFF_START_DIS__SHIFT                                     0x16
#define DC_PERFMON2_PERFCOUNTER_CNTL__PERFCOUNTER_RESTART_EN__SHIFT                                           0x17
#define DC_PERFMON2_PERFCOUNTER_CNTL__PERFCOUNTER_INT_EN__SHIFT                                               0x18
#define DC_PERFMON2_PERFCOUNTER_CNTL__PERFCOUNTER_OFF_MASK__SHIFT                                             0x19
#define DC_PERFMON2_PERFCOUNTER_CNTL__PERFCOUNTER_ACTIVE__SHIFT                                               0x1a
#define DC_PERFMON2_PERFCOUNTER_CNTL__PERFCOUNTER_CNTL_SEL__SHIFT                                             0x1d
#define DC_PERFMON2_PERFCOUNTER_CNTL__PERFCOUNTER_EVENT_SEL_MASK                                              0x000001FFL
#define DC_PERFMON2_PERFCOUNTER_CNTL__PERFCOUNTER_CVALUE_SEL_MASK                                             0x00000E00L
#define DC_PERFMON2_PERFCOUNTER_CNTL__PERFCOUNTER_INC_MODE_MASK                                               0x00007000L
#define DC_PERFMON2_PERFCOUNTER_CNTL__PERFCOUNTER_HW_CNTL_SEL_MASK                                            0x00008000L
#define DC_PERFMON2_PERFCOUNTER_CNTL__PERFCOUNTER_RUNEN_MODE_MASK                                             0x00010000L
#define DC_PERFMON2_PERFCOUNTER_CNTL__PERFCOUNTER_CNTOFF_START_DIS_MASK                                       0x00400000L
#define DC_PERFMON2_PERFCOUNTER_CNTL__PERFCOUNTER_RESTART_EN_MASK                                             0x00800000L
#define DC_PERFMON2_PERFCOUNTER_CNTL__PERFCOUNTER_INT_EN_MASK                                                 0x01000000L
#define DC_PERFMON2_PERFCOUNTER_CNTL__PERFCOUNTER_OFF_MASK_MASK                                               0x02000000L
#define DC_PERFMON2_PERFCOUNTER_CNTL__PERFCOUNTER_ACTIVE_MASK                                                 0x04000000L
#define DC_PERFMON2_PERFCOUNTER_CNTL__PERFCOUNTER_CNTL_SEL_MASK                                               0xE0000000L
//DC_PERFMON2_PERFCOUNTER_CNTL2
#define DC_PERFMON2_PERFCOUNTER_CNTL2__PERFCOUNTER_COUNTED_VALUE_TYPE__SHIFT                                  0x0
#define DC_PERFMON2_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP1_SEL__SHIFT                                        0x2
#define DC_PERFMON2_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP2_SEL__SHIFT                                        0x3
#define DC_PERFMON2_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTOFF_SEL__SHIFT                                          0x8
#define DC_PERFMON2_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTL2_SEL__SHIFT                                           0x1d
#define DC_PERFMON2_PERFCOUNTER_CNTL2__PERFCOUNTER_COUNTED_VALUE_TYPE_MASK                                    0x00000003L
#define DC_PERFMON2_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP1_SEL_MASK                                          0x00000004L
#define DC_PERFMON2_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP2_SEL_MASK                                          0x00000008L
#define DC_PERFMON2_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTOFF_SEL_MASK                                            0x00003F00L
#define DC_PERFMON2_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTL2_SEL_MASK                                             0xE0000000L
//DC_PERFMON2_PERFCOUNTER_STATE
#define DC_PERFMON2_PERFCOUNTER_STATE__PERFCOUNTER_CNT0_STATE__SHIFT                                          0x0
#define DC_PERFMON2_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL0__SHIFT                                          0x2
#define DC_PERFMON2_PERFCOUNTER_STATE__PERFCOUNTER_CNT1_STATE__SHIFT                                          0x4
#define DC_PERFMON2_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL1__SHIFT                                          0x6
#define DC_PERFMON2_PERFCOUNTER_STATE__PERFCOUNTER_CNT2_STATE__SHIFT                                          0x8
#define DC_PERFMON2_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL2__SHIFT                                          0xa
#define DC_PERFMON2_PERFCOUNTER_STATE__PERFCOUNTER_CNT3_STATE__SHIFT                                          0xc
#define DC_PERFMON2_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL3__SHIFT                                          0xe
#define DC_PERFMON2_PERFCOUNTER_STATE__PERFCOUNTER_CNT4_STATE__SHIFT                                          0x10
#define DC_PERFMON2_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL4__SHIFT                                          0x12
#define DC_PERFMON2_PERFCOUNTER_STATE__PERFCOUNTER_CNT5_STATE__SHIFT                                          0x14
#define DC_PERFMON2_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL5__SHIFT                                          0x16
#define DC_PERFMON2_PERFCOUNTER_STATE__PERFCOUNTER_CNT6_STATE__SHIFT                                          0x18
#define DC_PERFMON2_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL6__SHIFT                                          0x1a
#define DC_PERFMON2_PERFCOUNTER_STATE__PERFCOUNTER_CNT7_STATE__SHIFT                                          0x1c
#define DC_PERFMON2_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL7__SHIFT                                          0x1e
#define DC_PERFMON2_PERFCOUNTER_STATE__PERFCOUNTER_CNT0_STATE_MASK                                            0x00000003L
#define DC_PERFMON2_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL0_MASK                                            0x00000004L
#define DC_PERFMON2_PERFCOUNTER_STATE__PERFCOUNTER_CNT1_STATE_MASK                                            0x00000030L
#define DC_PERFMON2_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL1_MASK                                            0x00000040L
#define DC_PERFMON2_PERFCOUNTER_STATE__PERFCOUNTER_CNT2_STATE_MASK                                            0x00000300L
#define DC_PERFMON2_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL2_MASK                                            0x00000400L
#define DC_PERFMON2_PERFCOUNTER_STATE__PERFCOUNTER_CNT3_STATE_MASK                                            0x00003000L
#define DC_PERFMON2_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL3_MASK                                            0x00004000L
#define DC_PERFMON2_PERFCOUNTER_STATE__PERFCOUNTER_CNT4_STATE_MASK                                            0x00030000L
#define DC_PERFMON2_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL4_MASK                                            0x00040000L
#define DC_PERFMON2_PERFCOUNTER_STATE__PERFCOUNTER_CNT5_STATE_MASK                                            0x00300000L
#define DC_PERFMON2_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL5_MASK                                            0x00400000L
#define DC_PERFMON2_PERFCOUNTER_STATE__PERFCOUNTER_CNT6_STATE_MASK                                            0x03000000L
#define DC_PERFMON2_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL6_MASK                                            0x04000000L
#define DC_PERFMON2_PERFCOUNTER_STATE__PERFCOUNTER_CNT7_STATE_MASK                                            0x30000000L
#define DC_PERFMON2_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL7_MASK                                            0x40000000L
//DC_PERFMON2_PERFMON_CNTL
#define DC_PERFMON2_PERFMON_CNTL__PERFMON_STATE__SHIFT                                                        0x0
#define DC_PERFMON2_PERFMON_CNTL__PERFMON_RPT_COUNT__SHIFT                                                    0x8
#define DC_PERFMON2_PERFMON_CNTL__PERFMON_CNTOFF_AND_OR__SHIFT                                                0x1c
#define DC_PERFMON2_PERFMON_CNTL__PERFMON_CNTOFF_INT_EN__SHIFT                                                0x1d
#define DC_PERFMON2_PERFMON_CNTL__PERFMON_CNTOFF_INT_STATUS__SHIFT                                            0x1e
#define DC_PERFMON2_PERFMON_CNTL__PERFMON_CNTOFF_INT_ACK__SHIFT                                               0x1f
#define DC_PERFMON2_PERFMON_CNTL__PERFMON_STATE_MASK                                                          0x00000003L
#define DC_PERFMON2_PERFMON_CNTL__PERFMON_RPT_COUNT_MASK                                                      0x0FFFFF00L
#define DC_PERFMON2_PERFMON_CNTL__PERFMON_CNTOFF_AND_OR_MASK                                                  0x10000000L
#define DC_PERFMON2_PERFMON_CNTL__PERFMON_CNTOFF_INT_EN_MASK                                                  0x20000000L
#define DC_PERFMON2_PERFMON_CNTL__PERFMON_CNTOFF_INT_STATUS_MASK                                              0x40000000L
#define DC_PERFMON2_PERFMON_CNTL__PERFMON_CNTOFF_INT_ACK_MASK                                                 0x80000000L
//DC_PERFMON2_PERFMON_CNTL2
#define DC_PERFMON2_PERFMON_CNTL2__PERFMON_CNTOFF_INT_TYPE__SHIFT                                             0x0
#define DC_PERFMON2_PERFMON_CNTL2__PERFMON_CLK_ENABLE__SHIFT                                                  0x1
#define DC_PERFMON2_PERFMON_CNTL2__PERFMON_RUN_ENABLE_START_SEL__SHIFT                                        0x2
#define DC_PERFMON2_PERFMON_CNTL2__PERFMON_RUN_ENABLE_STOP_SEL__SHIFT                                         0xa
#define DC_PERFMON2_PERFMON_CNTL2__PERFMON_CNTOFF_INT_TYPE_MASK                                               0x00000001L
#define DC_PERFMON2_PERFMON_CNTL2__PERFMON_CLK_ENABLE_MASK                                                    0x00000002L
#define DC_PERFMON2_PERFMON_CNTL2__PERFMON_RUN_ENABLE_START_SEL_MASK                                          0x000003FCL
#define DC_PERFMON2_PERFMON_CNTL2__PERFMON_RUN_ENABLE_STOP_SEL_MASK                                           0x0003FC00L
//DC_PERFMON2_PERFMON_CVALUE_INT_MISC
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_STATUS__SHIFT                                   0x0
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_STATUS__SHIFT                                   0x1
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_STATUS__SHIFT                                   0x2
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_STATUS__SHIFT                                   0x3
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_STATUS__SHIFT                                   0x4
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_STATUS__SHIFT                                   0x5
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_STATUS__SHIFT                                   0x6
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_STATUS__SHIFT                                   0x7
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_ACK__SHIFT                                      0x8
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_ACK__SHIFT                                      0x9
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_ACK__SHIFT                                      0xa
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_ACK__SHIFT                                      0xb
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_ACK__SHIFT                                      0xc
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_ACK__SHIFT                                      0xd
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_ACK__SHIFT                                      0xe
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_ACK__SHIFT                                      0xf
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFMON_CVALUE_HI__SHIFT                                         0x10
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_STATUS_MASK                                     0x00000001L
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_STATUS_MASK                                     0x00000002L
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_STATUS_MASK                                     0x00000004L
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_STATUS_MASK                                     0x00000008L
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_STATUS_MASK                                     0x00000010L
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_STATUS_MASK                                     0x00000020L
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_STATUS_MASK                                     0x00000040L
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_STATUS_MASK                                     0x00000080L
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_ACK_MASK                                        0x00000100L
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_ACK_MASK                                        0x00000200L
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_ACK_MASK                                        0x00000400L
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_ACK_MASK                                        0x00000800L
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_ACK_MASK                                        0x00001000L
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_ACK_MASK                                        0x00002000L
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_ACK_MASK                                        0x00004000L
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_ACK_MASK                                        0x00008000L
#define DC_PERFMON2_PERFMON_CVALUE_INT_MISC__PERFMON_CVALUE_HI_MASK                                           0xFFFF0000L
//DC_PERFMON2_PERFMON_CVALUE_LOW
#define DC_PERFMON2_PERFMON_CVALUE_LOW__PERFMON_CVALUE_LOW__SHIFT                                             0x0
#define DC_PERFMON2_PERFMON_CVALUE_LOW__PERFMON_CVALUE_LOW_MASK                                               0xFFFFFFFFL
//DC_PERFMON2_PERFMON_HI
#define DC_PERFMON2_PERFMON_HI__PERFMON_HI__SHIFT                                                             0x0
#define DC_PERFMON2_PERFMON_HI__PERFMON_READ_SEL__SHIFT                                                       0x1d
#define DC_PERFMON2_PERFMON_HI__PERFMON_HI_MASK                                                               0x0000FFFFL
#define DC_PERFMON2_PERFMON_HI__PERFMON_READ_SEL_MASK                                                         0xE0000000L
//DC_PERFMON2_PERFMON_LOW
#define DC_PERFMON2_PERFMON_LOW__PERFMON_LOW__SHIFT                                                           0x0
#define DC_PERFMON2_PERFMON_LOW__PERFMON_LOW_MASK                                                             0xFFFFFFFFL


// addressBlock: dce_dc_dmu_dmu_misc_dispdec
//CC_DC_PIPE_DIS
#define CC_DC_PIPE_DIS__DC_PIPE_DIS__SHIFT                                                                    0x0
#define CC_DC_PIPE_DIS__DC_PIPE_DIS_MASK                                                                      0x000000FFL
//DMU_CLK_CNTL
#define DMU_CLK_CNTL__DMU_TEST_CLK_SEL__SHIFT                                                                 0x0
#define DMU_CLK_CNTL__DISPCLK_R_DMU_GATE_DIS__SHIFT                                                           0x2
#define DMU_CLK_CNTL__DISPCLK_G_DMCU_GATE_DIS__SHIFT                                                          0x3
#define DMU_CLK_CNTL__DMU_TEST_CLK_SEL_MASK                                                                   0x00000003L
#define DMU_CLK_CNTL__DISPCLK_R_DMU_GATE_DIS_MASK                                                             0x00000004L
#define DMU_CLK_CNTL__DISPCLK_G_DMCU_GATE_DIS_MASK                                                            0x00000008L
//DMU_MEM_PWR_CNTL
#define DMU_MEM_PWR_CNTL__DMCU_ERAM_MEM_PWR_MODE_SEL__SHIFT                                                   0x0
#define DMU_MEM_PWR_CNTL__DMCU_ERAM_MEM_PWR_FORCE__SHIFT                                                      0x1
#define DMU_MEM_PWR_CNTL__DMCU_ERAM_MEM_PWR_DIS__SHIFT                                                        0x3
#define DMU_MEM_PWR_CNTL__DMCU_ERAM_MEM_PWR_STATE__SHIFT                                                      0x4
#define DMU_MEM_PWR_CNTL__DMCU_IRAM_MEM_PWR_FORCE__SHIFT                                                      0x8
#define DMU_MEM_PWR_CNTL__DMCU_IRAM_MEM_PWR_DIS__SHIFT                                                        0x9
#define DMU_MEM_PWR_CNTL__DMCU_IRAM_MEM_PWR_STATE__SHIFT                                                      0xa
#define DMU_MEM_PWR_CNTL__DMCU_ERAM_MEM_PWR_MODE_SEL_MASK                                                     0x00000001L
#define DMU_MEM_PWR_CNTL__DMCU_ERAM_MEM_PWR_FORCE_MASK                                                        0x00000006L
#define DMU_MEM_PWR_CNTL__DMCU_ERAM_MEM_PWR_DIS_MASK                                                          0x00000008L
#define DMU_MEM_PWR_CNTL__DMCU_ERAM_MEM_PWR_STATE_MASK                                                        0x00000030L
#define DMU_MEM_PWR_CNTL__DMCU_IRAM_MEM_PWR_FORCE_MASK                                                        0x00000100L
#define DMU_MEM_PWR_CNTL__DMCU_IRAM_MEM_PWR_DIS_MASK                                                          0x00000200L
#define DMU_MEM_PWR_CNTL__DMCU_IRAM_MEM_PWR_STATE_MASK                                                        0x00000400L
//DMCU_SMU_INTERRUPT_CNTL
#define DMCU_SMU_INTERRUPT_CNTL__DMCU_SMU_STATIC_SCREEN_INT__SHIFT                                            0x0
#define DMCU_SMU_INTERRUPT_CNTL__DMCU_SMU_STATIC_SCREEN_STATUS__SHIFT                                         0x10
#define DMCU_SMU_INTERRUPT_CNTL__DMCU_SMU_STATIC_SCREEN_INT_MASK                                              0x00000001L
#define DMCU_SMU_INTERRUPT_CNTL__DMCU_SMU_STATIC_SCREEN_STATUS_MASK                                           0xFFFF0000L
//SMU_INTERRUPT_CONTROL
#define SMU_INTERRUPT_CONTROL__DC_SMU_INT_ENABLE__SHIFT                                                       0x0
#define SMU_INTERRUPT_CONTROL__DC_SMU_INT_STATUS__SHIFT                                                       0x4
#define SMU_INTERRUPT_CONTROL__DC_SMU_INT_EVENT__SHIFT                                                        0x10
#define SMU_INTERRUPT_CONTROL__DC_SMU_INT_ENABLE_MASK                                                         0x00000001L
#define SMU_INTERRUPT_CONTROL__DC_SMU_INT_STATUS_MASK                                                         0x00000010L
#define SMU_INTERRUPT_CONTROL__DC_SMU_INT_EVENT_MASK                                                          0xFFFF0000L


// addressBlock: dce_dc_dmu_dmcu_dispdec
//DMCU_CTRL
#define DMCU_CTRL__RESET_UC__SHIFT                                                                            0x0
#define DMCU_CTRL__IGNORE_PWRMGT__SHIFT                                                                       0x1
#define DMCU_CTRL__DISABLE_IRQ_TO_UC__SHIFT                                                                   0x2
#define DMCU_CTRL__DISABLE_XIRQ_TO_UC__SHIFT                                                                  0x3
#define DMCU_CTRL__DMCU_ENABLE__SHIFT                                                                         0x4
#define DMCU_CTRL__DMCU_DYN_CLK_GATING_EN__SHIFT                                                              0x8
#define DMCU_CTRL__UC_REG_RD_TIMEOUT__SHIFT                                                                   0x10
#define DMCU_CTRL__RESET_UC_MASK                                                                              0x00000001L
#define DMCU_CTRL__IGNORE_PWRMGT_MASK                                                                         0x00000002L
#define DMCU_CTRL__DISABLE_IRQ_TO_UC_MASK                                                                     0x00000004L
#define DMCU_CTRL__DISABLE_XIRQ_TO_UC_MASK                                                                    0x00000008L
#define DMCU_CTRL__DMCU_ENABLE_MASK                                                                           0x00000010L
#define DMCU_CTRL__DMCU_DYN_CLK_GATING_EN_MASK                                                                0x00000100L
#define DMCU_CTRL__UC_REG_RD_TIMEOUT_MASK                                                                     0xFFFF0000L
//DMCU_STATUS
#define DMCU_STATUS__UC_IN_RESET__SHIFT                                                                       0x0
#define DMCU_STATUS__UC_IN_WAIT_MODE__SHIFT                                                                   0x1
#define DMCU_STATUS__UC_IN_STOP_MODE__SHIFT                                                                   0x2
#define DMCU_STATUS__UC_IN_RESET_MASK                                                                         0x00000001L
#define DMCU_STATUS__UC_IN_WAIT_MODE_MASK                                                                     0x00000002L
#define DMCU_STATUS__UC_IN_STOP_MODE_MASK                                                                     0x00000004L
//DMCU_PC_START_ADDR
#define DMCU_PC_START_ADDR__PC_START_ADDR_LSB__SHIFT                                                          0x0
#define DMCU_PC_START_ADDR__PC_START_ADDR_MSB__SHIFT                                                          0x8
#define DMCU_PC_START_ADDR__PC_START_ADDR_LSB_MASK                                                            0x000000FFL
#define DMCU_PC_START_ADDR__PC_START_ADDR_MSB_MASK                                                            0x0000FF00L
//DMCU_FW_START_ADDR
#define DMCU_FW_START_ADDR__FW_START_ADDR_LSB__SHIFT                                                          0x0
#define DMCU_FW_START_ADDR__FW_START_ADDR_MSB__SHIFT                                                          0x8
#define DMCU_FW_START_ADDR__FW_START_ADDR_LSB_MASK                                                            0x000000FFL
#define DMCU_FW_START_ADDR__FW_START_ADDR_MSB_MASK                                                            0x0000FF00L
//DMCU_FW_END_ADDR
#define DMCU_FW_END_ADDR__FW_END_ADDR_LSB__SHIFT                                                              0x0
#define DMCU_FW_END_ADDR__FW_END_ADDR_MSB__SHIFT                                                              0x8
#define DMCU_FW_END_ADDR__FW_END_ADDR_LSB_MASK                                                                0x000000FFL
#define DMCU_FW_END_ADDR__FW_END_ADDR_MSB_MASK                                                                0x0000FF00L
//DMCU_FW_ISR_START_ADDR
#define DMCU_FW_ISR_START_ADDR__FW_ISR_START_ADDR_LSB__SHIFT                                                  0x0
#define DMCU_FW_ISR_START_ADDR__FW_ISR_START_ADDR_MSB__SHIFT                                                  0x8
#define DMCU_FW_ISR_START_ADDR__FW_ISR_START_ADDR_LSB_MASK                                                    0x000000FFL
#define DMCU_FW_ISR_START_ADDR__FW_ISR_START_ADDR_MSB_MASK                                                    0x0000FF00L
//DMCU_FW_CS_HI
#define DMCU_FW_CS_HI__FW_CHECKSUM_HI__SHIFT                                                                  0x0
#define DMCU_FW_CS_HI__FW_CHECKSUM_HI_MASK                                                                    0xFFFFFFFFL
//DMCU_FW_CS_LO
#define DMCU_FW_CS_LO__FW_CHECKSUM_LO__SHIFT                                                                  0x0
#define DMCU_FW_CS_LO__FW_CHECKSUM_LO_MASK                                                                    0xFFFFFFFFL
//DMCU_RAM_ACCESS_CTRL
#define DMCU_RAM_ACCESS_CTRL__ERAM_WR_ADDR_AUTO_INC__SHIFT                                                    0x0
#define DMCU_RAM_ACCESS_CTRL__ERAM_RD_ADDR_AUTO_INC__SHIFT                                                    0x1
#define DMCU_RAM_ACCESS_CTRL__IRAM_WR_ADDR_AUTO_INC__SHIFT                                                    0x2
#define DMCU_RAM_ACCESS_CTRL__IRAM_RD_ADDR_AUTO_INC__SHIFT                                                    0x3
#define DMCU_RAM_ACCESS_CTRL__ERAM_HOST_ACCESS_EN__SHIFT                                                      0x4
#define DMCU_RAM_ACCESS_CTRL__IRAM_HOST_ACCESS_EN__SHIFT                                                      0x5
#define DMCU_RAM_ACCESS_CTRL__ERAM_WR_ADDR_AUTO_INC_MASK                                                      0x00000001L
#define DMCU_RAM_ACCESS_CTRL__ERAM_RD_ADDR_AUTO_INC_MASK                                                      0x00000002L
#define DMCU_RAM_ACCESS_CTRL__IRAM_WR_ADDR_AUTO_INC_MASK                                                      0x00000004L
#define DMCU_RAM_ACCESS_CTRL__IRAM_RD_ADDR_AUTO_INC_MASK                                                      0x00000008L
#define DMCU_RAM_ACCESS_CTRL__ERAM_HOST_ACCESS_EN_MASK                                                        0x00000010L
#define DMCU_RAM_ACCESS_CTRL__IRAM_HOST_ACCESS_EN_MASK                                                        0x00000020L
//DMCU_ERAM_WR_CTRL
#define DMCU_ERAM_WR_CTRL__ERAM_WR_ADDR__SHIFT                                                                0x0
#define DMCU_ERAM_WR_CTRL__ERAM_WR_BE__SHIFT                                                                  0x10
#define DMCU_ERAM_WR_CTRL__ERAM_WR_BYTE_MODE__SHIFT                                                           0x14
#define DMCU_ERAM_WR_CTRL__ERAM_WR_ADDR_MASK                                                                  0x0000FFFFL
#define DMCU_ERAM_WR_CTRL__ERAM_WR_BE_MASK                                                                    0x000F0000L
#define DMCU_ERAM_WR_CTRL__ERAM_WR_BYTE_MODE_MASK                                                             0x00100000L
//DMCU_ERAM_WR_DATA
#define DMCU_ERAM_WR_DATA__ERAM_WR_DATA__SHIFT                                                                0x0
#define DMCU_ERAM_WR_DATA__ERAM_WR_DATA_MASK                                                                  0xFFFFFFFFL
//DMCU_ERAM_RD_CTRL
#define DMCU_ERAM_RD_CTRL__ERAM_RD_ADDR__SHIFT                                                                0x0
#define DMCU_ERAM_RD_CTRL__ERAM_RD_BE__SHIFT                                                                  0x10
#define DMCU_ERAM_RD_CTRL__ERAM_RD_BYTE_MODE__SHIFT                                                           0x14
#define DMCU_ERAM_RD_CTRL__ERAM_RD_ADDR_MASK                                                                  0x0000FFFFL
#define DMCU_ERAM_RD_CTRL__ERAM_RD_BE_MASK                                                                    0x000F0000L
#define DMCU_ERAM_RD_CTRL__ERAM_RD_BYTE_MODE_MASK                                                             0x00100000L
//DMCU_ERAM_RD_DATA
#define DMCU_ERAM_RD_DATA__ERAM_RD_DATA__SHIFT                                                                0x0
#define DMCU_ERAM_RD_DATA__ERAM_RD_DATA_MASK                                                                  0xFFFFFFFFL
//DMCU_IRAM_WR_CTRL
#define DMCU_IRAM_WR_CTRL__IRAM_WR_ADDR__SHIFT                                                                0x0
#define DMCU_IRAM_WR_CTRL__IRAM_WR_ADDR_MASK                                                                  0x000003FFL
//DMCU_IRAM_WR_DATA
#define DMCU_IRAM_WR_DATA__IRAM_WR_DATA__SHIFT                                                                0x0
#define DMCU_IRAM_WR_DATA__IRAM_WR_DATA_MASK                                                                  0x000000FFL
//DMCU_IRAM_RD_CTRL
#define DMCU_IRAM_RD_CTRL__IRAM_RD_ADDR__SHIFT                                                                0x0
#define DMCU_IRAM_RD_CTRL__IRAM_RD_ADDR_MASK                                                                  0x000003FFL
//DMCU_IRAM_RD_DATA
#define DMCU_IRAM_RD_DATA__IRAM_RD_DATA__SHIFT                                                                0x0
#define DMCU_IRAM_RD_DATA__IRAM_RD_DATA_MASK                                                                  0x000000FFL
//DMCU_EVENT_TRIGGER
#define DMCU_EVENT_TRIGGER__GEN_SW_INT_TO_UC__SHIFT                                                           0x0
#define DMCU_EVENT_TRIGGER__UC_INTERNAL_INT_CODE__SHIFT                                                       0x10
#define DMCU_EVENT_TRIGGER__GEN_UC_INTERNAL_INT_TO_HOST__SHIFT                                                0x17
#define DMCU_EVENT_TRIGGER__GEN_SW_INT_TO_UC_MASK                                                             0x00000001L
#define DMCU_EVENT_TRIGGER__UC_INTERNAL_INT_CODE_MASK                                                         0x007F0000L
#define DMCU_EVENT_TRIGGER__GEN_UC_INTERNAL_INT_TO_HOST_MASK                                                  0x00800000L
//DMCU_UC_INTERNAL_INT_STATUS
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_IRQ_N_PIN__SHIFT                                                  0x0
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_XIRQ_N_PIN__SHIFT                                                 0x1
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_SOFTWARE_INTERRUPT__SHIFT                                         0x2
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_ILLEGAL_OPCODE_TRAP__SHIFT                                        0x3
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_OUTPUT_COMPARE_4__SHIFT                                     0x4
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_OUTPUT_COMPARE_3__SHIFT                                     0x5
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_OUTPUT_COMPARE_2__SHIFT                                     0x6
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_OUTPUT_COMPARE_1__SHIFT                                     0x7
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_OVERFLOW__SHIFT                                             0x8
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_REAL_TIME_INTERRUPT__SHIFT                                        0x9
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_INPUT_CAPTURE_4_OUTPUT_COMPARE_5__SHIFT                     0xa
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_INPUT_CAPTURE_3__SHIFT                                      0xb
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_INPUT_CAPTURE_2__SHIFT                                      0xc
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_INPUT_CAPTURE_1__SHIFT                                      0xd
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_PULSE_ACCUMULATOR_INPUT_EDGE__SHIFT                               0xe
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_PULSE_ACCUMULATOR_OVERFLOW__SHIFT                                 0xf
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_IRQ_N_PIN_MASK                                                    0x00000001L
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_XIRQ_N_PIN_MASK                                                   0x00000002L
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_SOFTWARE_INTERRUPT_MASK                                           0x00000004L
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_ILLEGAL_OPCODE_TRAP_MASK                                          0x00000008L
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_OUTPUT_COMPARE_4_MASK                                       0x00000010L
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_OUTPUT_COMPARE_3_MASK                                       0x00000020L
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_OUTPUT_COMPARE_2_MASK                                       0x00000040L
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_OUTPUT_COMPARE_1_MASK                                       0x00000080L
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_OVERFLOW_MASK                                               0x00000100L
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_REAL_TIME_INTERRUPT_MASK                                          0x00000200L
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_INPUT_CAPTURE_4_OUTPUT_COMPARE_5_MASK                       0x00000400L
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_INPUT_CAPTURE_3_MASK                                        0x00000800L
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_INPUT_CAPTURE_2_MASK                                        0x00001000L
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_INPUT_CAPTURE_1_MASK                                        0x00002000L
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_PULSE_ACCUMULATOR_INPUT_EDGE_MASK                                 0x00004000L
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_PULSE_ACCUMULATOR_OVERFLOW_MASK                                   0x00008000L
//DMCU_SS_INTERRUPT_CNTL_STATUS
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN1_INT_STATUS__SHIFT                                       0xd
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN1_INT_OCCURRED__SHIFT                                     0xe
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN1_INT_CLEAR__SHIFT                                        0xe
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN2_INT_STATUS__SHIFT                                       0xf
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN2_INT_OCCURRED__SHIFT                                     0x10
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN2_INT_CLEAR__SHIFT                                        0x10
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN3_INT_STATUS__SHIFT                                       0x11
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN3_INT_OCCURRED__SHIFT                                     0x12
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN3_INT_CLEAR__SHIFT                                        0x12
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN4_INT_STATUS__SHIFT                                       0x13
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN4_INT_OCCURRED__SHIFT                                     0x14
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN4_INT_CLEAR__SHIFT                                        0x14
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN5_INT_STATUS__SHIFT                                       0x15
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN5_INT_OCCURRED__SHIFT                                     0x16
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN5_INT_CLEAR__SHIFT                                        0x16
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN6_INT_STATUS__SHIFT                                       0x17
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN6_INT_OCCURRED__SHIFT                                     0x18
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN6_INT_CLEAR__SHIFT                                        0x18
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN1_INT_STATUS_MASK                                         0x00002000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN1_INT_OCCURRED_MASK                                       0x00004000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN1_INT_CLEAR_MASK                                          0x00004000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN2_INT_STATUS_MASK                                         0x00008000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN2_INT_OCCURRED_MASK                                       0x00010000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN2_INT_CLEAR_MASK                                          0x00010000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN3_INT_STATUS_MASK                                         0x00020000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN3_INT_OCCURRED_MASK                                       0x00040000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN3_INT_CLEAR_MASK                                          0x00040000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN4_INT_STATUS_MASK                                         0x00080000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN4_INT_OCCURRED_MASK                                       0x00100000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN4_INT_CLEAR_MASK                                          0x00100000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN5_INT_STATUS_MASK                                         0x00200000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN5_INT_OCCURRED_MASK                                       0x00400000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN5_INT_CLEAR_MASK                                          0x00400000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN6_INT_STATUS_MASK                                         0x00800000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN6_INT_OCCURRED_MASK                                       0x01000000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN6_INT_CLEAR_MASK                                          0x01000000L
//DMCU_INTERRUPT_STATUS
#define DMCU_INTERRUPT_STATUS__ABM1_HG_READY_INT_OCCURRED__SHIFT                                              0x0
#define DMCU_INTERRUPT_STATUS__ABM1_HG_READY_INT_CLEAR__SHIFT                                                 0x0
#define DMCU_INTERRUPT_STATUS__ABM1_LS_READY_INT_OCCURRED__SHIFT                                              0x1
#define DMCU_INTERRUPT_STATUS__ABM1_LS_READY_INT_CLEAR__SHIFT                                                 0x1
#define DMCU_INTERRUPT_STATUS__ABM1_BL_UPDATE_INT_OCCURRED__SHIFT                                             0x2
#define DMCU_INTERRUPT_STATUS__ABM1_BL_UPDATE_INT_CLEAR__SHIFT                                                0x2
#define DMCU_INTERRUPT_STATUS__MCP_INT_OCCURRED__SHIFT                                                        0x3
#define DMCU_INTERRUPT_STATUS__EXTERNAL_SW_INT_OCCURRED__SHIFT                                                0x8
#define DMCU_INTERRUPT_STATUS__EXTERNAL_SW_INT_CLEAR__SHIFT                                                   0x8
#define DMCU_INTERRUPT_STATUS__SCP_INT_OCCURRED__SHIFT                                                        0x9
#define DMCU_INTERRUPT_STATUS__UC_INTERNAL_INT_OCCURRED__SHIFT                                                0xa
#define DMCU_INTERRUPT_STATUS__UC_INTERNAL_INT_CLEAR__SHIFT                                                   0xa
#define DMCU_INTERRUPT_STATUS__UC_REG_RD_TIMEOUT_INT_OCCURRED__SHIFT                                          0xb
#define DMCU_INTERRUPT_STATUS__UC_REG_RD_TIMEOUT_INT_CLEAR__SHIFT                                             0xb
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN0_POWER_UP_INT_OCCURRED__SHIFT                                  0xc
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN0_POWER_UP_INT_CLEAR__SHIFT                                     0xc
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN1_POWER_UP_INT_OCCURRED__SHIFT                                  0xd
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN1_POWER_UP_INT_CLEAR__SHIFT                                     0xd
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN2_POWER_UP_INT_OCCURRED__SHIFT                                  0xe
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN2_POWER_UP_INT_CLEAR__SHIFT                                     0xe
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN3_POWER_UP_INT_OCCURRED__SHIFT                                  0xf
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN3_POWER_UP_INT_CLEAR__SHIFT                                     0xf
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN4_POWER_UP_INT_OCCURRED__SHIFT                                  0x10
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN4_POWER_UP_INT_CLEAR__SHIFT                                     0x10
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN5_POWER_UP_INT_OCCURRED__SHIFT                                  0x11
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN5_POWER_UP_INT_CLEAR__SHIFT                                     0x11
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN0_POWER_DOWN_INT_OCCURRED__SHIFT                                0x12
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN0_POWER_DOWN_INT_CLEAR__SHIFT                                   0x12
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN1_POWER_DOWN_INT_OCCURRED__SHIFT                                0x13
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN1_POWER_DOWN_INT_CLEAR__SHIFT                                   0x13
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN2_POWER_DOWN_INT_OCCURRED__SHIFT                                0x14
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN2_POWER_DOWN_INT_CLEAR__SHIFT                                   0x14
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN3_POWER_DOWN_INT_OCCURRED__SHIFT                                0x15
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN3_POWER_DOWN_INT_CLEAR__SHIFT                                   0x15
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN4_POWER_DOWN_INT_OCCURRED__SHIFT                                0x16
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN4_POWER_DOWN_INT_CLEAR__SHIFT                                   0x16
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN5_POWER_DOWN_INT_OCCURRED__SHIFT                                0x17
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN5_POWER_DOWN_INT_CLEAR__SHIFT                                   0x17
#define DMCU_INTERRUPT_STATUS__VBLANK1_INT_OCCURRED__SHIFT                                                    0x18
#define DMCU_INTERRUPT_STATUS__VBLANK1_INT_CLEAR__SHIFT                                                       0x18
#define DMCU_INTERRUPT_STATUS__VBLANK2_INT_OCCURRED__SHIFT                                                    0x19
#define DMCU_INTERRUPT_STATUS__VBLANK2_INT_CLEAR__SHIFT                                                       0x19
#define DMCU_INTERRUPT_STATUS__VBLANK3_INT_OCCURRED__SHIFT                                                    0x1a
#define DMCU_INTERRUPT_STATUS__VBLANK3_INT_CLEAR__SHIFT                                                       0x1a
#define DMCU_INTERRUPT_STATUS__VBLANK4_INT_OCCURRED__SHIFT                                                    0x1b
#define DMCU_INTERRUPT_STATUS__VBLANK4_INT_CLEAR__SHIFT                                                       0x1b
#define DMCU_INTERRUPT_STATUS__VBLANK5_INT_OCCURRED__SHIFT                                                    0x1c
#define DMCU_INTERRUPT_STATUS__VBLANK5_INT_CLEAR__SHIFT                                                       0x1c
#define DMCU_INTERRUPT_STATUS__VBLANK6_INT_OCCURRED__SHIFT                                                    0x1d
#define DMCU_INTERRUPT_STATUS__VBLANK6_INT_CLEAR__SHIFT                                                       0x1d
#define DMCU_INTERRUPT_STATUS__ABM1_HG_READY_INT_OCCURRED_MASK                                                0x00000001L
#define DMCU_INTERRUPT_STATUS__ABM1_HG_READY_INT_CLEAR_MASK                                                   0x00000001L
#define DMCU_INTERRUPT_STATUS__ABM1_LS_READY_INT_OCCURRED_MASK                                                0x00000002L
#define DMCU_INTERRUPT_STATUS__ABM1_LS_READY_INT_CLEAR_MASK                                                   0x00000002L
#define DMCU_INTERRUPT_STATUS__ABM1_BL_UPDATE_INT_OCCURRED_MASK                                               0x00000004L
#define DMCU_INTERRUPT_STATUS__ABM1_BL_UPDATE_INT_CLEAR_MASK                                                  0x00000004L
#define DMCU_INTERRUPT_STATUS__MCP_INT_OCCURRED_MASK                                                          0x00000008L
#define DMCU_INTERRUPT_STATUS__EXTERNAL_SW_INT_OCCURRED_MASK                                                  0x00000100L
#define DMCU_INTERRUPT_STATUS__EXTERNAL_SW_INT_CLEAR_MASK                                                     0x00000100L
#define DMCU_INTERRUPT_STATUS__SCP_INT_OCCURRED_MASK                                                          0x00000200L
#define DMCU_INTERRUPT_STATUS__UC_INTERNAL_INT_OCCURRED_MASK                                                  0x00000400L
#define DMCU_INTERRUPT_STATUS__UC_INTERNAL_INT_CLEAR_MASK                                                     0x00000400L
#define DMCU_INTERRUPT_STATUS__UC_REG_RD_TIMEOUT_INT_OCCURRED_MASK                                            0x00000800L
#define DMCU_INTERRUPT_STATUS__UC_REG_RD_TIMEOUT_INT_CLEAR_MASK                                               0x00000800L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN0_POWER_UP_INT_OCCURRED_MASK                                    0x00001000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN0_POWER_UP_INT_CLEAR_MASK                                       0x00001000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN1_POWER_UP_INT_OCCURRED_MASK                                    0x00002000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN1_POWER_UP_INT_CLEAR_MASK                                       0x00002000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN2_POWER_UP_INT_OCCURRED_MASK                                    0x00004000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN2_POWER_UP_INT_CLEAR_MASK                                       0x00004000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN3_POWER_UP_INT_OCCURRED_MASK                                    0x00008000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN3_POWER_UP_INT_CLEAR_MASK                                       0x00008000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN4_POWER_UP_INT_OCCURRED_MASK                                    0x00010000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN4_POWER_UP_INT_CLEAR_MASK                                       0x00010000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN5_POWER_UP_INT_OCCURRED_MASK                                    0x00020000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN5_POWER_UP_INT_CLEAR_MASK                                       0x00020000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN0_POWER_DOWN_INT_OCCURRED_MASK                                  0x00040000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN0_POWER_DOWN_INT_CLEAR_MASK                                     0x00040000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN1_POWER_DOWN_INT_OCCURRED_MASK                                  0x00080000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN1_POWER_DOWN_INT_CLEAR_MASK                                     0x00080000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN2_POWER_DOWN_INT_OCCURRED_MASK                                  0x00100000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN2_POWER_DOWN_INT_CLEAR_MASK                                     0x00100000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN3_POWER_DOWN_INT_OCCURRED_MASK                                  0x00200000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN3_POWER_DOWN_INT_CLEAR_MASK                                     0x00200000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN4_POWER_DOWN_INT_OCCURRED_MASK                                  0x00400000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN4_POWER_DOWN_INT_CLEAR_MASK                                     0x00400000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN5_POWER_DOWN_INT_OCCURRED_MASK                                  0x00800000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DOMAIN5_POWER_DOWN_INT_CLEAR_MASK                                     0x00800000L
#define DMCU_INTERRUPT_STATUS__VBLANK1_INT_OCCURRED_MASK                                                      0x01000000L
#define DMCU_INTERRUPT_STATUS__VBLANK1_INT_CLEAR_MASK                                                         0x01000000L
#define DMCU_INTERRUPT_STATUS__VBLANK2_INT_OCCURRED_MASK                                                      0x02000000L
#define DMCU_INTERRUPT_STATUS__VBLANK2_INT_CLEAR_MASK                                                         0x02000000L
#define DMCU_INTERRUPT_STATUS__VBLANK3_INT_OCCURRED_MASK                                                      0x04000000L
#define DMCU_INTERRUPT_STATUS__VBLANK3_INT_CLEAR_MASK                                                         0x04000000L
#define DMCU_INTERRUPT_STATUS__VBLANK4_INT_OCCURRED_MASK                                                      0x08000000L
#define DMCU_INTERRUPT_STATUS__VBLANK4_INT_CLEAR_MASK                                                         0x08000000L
#define DMCU_INTERRUPT_STATUS__VBLANK5_INT_OCCURRED_MASK                                                      0x10000000L
#define DMCU_INTERRUPT_STATUS__VBLANK5_INT_CLEAR_MASK                                                         0x10000000L
#define DMCU_INTERRUPT_STATUS__VBLANK6_INT_OCCURRED_MASK                                                      0x20000000L
#define DMCU_INTERRUPT_STATUS__VBLANK6_INT_CLEAR_MASK                                                         0x20000000L
//DMCU_INTERRUPT_STATUS_1
#define DMCU_INTERRUPT_STATUS_1__OTG0_RANGE_TIMING_UPDATE_OCCURRED__SHIFT                                     0x6
#define DMCU_INTERRUPT_STATUS_1__OTG0_RANGE_TIMING_UPDATE_CLEAR__SHIFT                                        0x6
#define DMCU_INTERRUPT_STATUS_1__OTG1_RANGE_TIMING_UPDATE_OCCURRED__SHIFT                                     0x7
#define DMCU_INTERRUPT_STATUS_1__OTG1_RANGE_TIMING_UPDATE_CLEAR__SHIFT                                        0x7
#define DMCU_INTERRUPT_STATUS_1__OTG2_RANGE_TIMING_UPDATE_OCCURRED__SHIFT                                     0x8
#define DMCU_INTERRUPT_STATUS_1__OTG2_RANGE_TIMING_UPDATE_CLEAR__SHIFT                                        0x8
#define DMCU_INTERRUPT_STATUS_1__OTG3_RANGE_TIMING_UPDATE_OCCURRED__SHIFT                                     0x9
#define DMCU_INTERRUPT_STATUS_1__OTG3_RANGE_TIMING_UPDATE_CLEAR__SHIFT                                        0x9
#define DMCU_INTERRUPT_STATUS_1__OTG4_RANGE_TIMING_UPDATE_OCCURRED__SHIFT                                     0xa
#define DMCU_INTERRUPT_STATUS_1__OTG4_RANGE_TIMING_UPDATE_CLEAR__SHIFT                                        0xa
#define DMCU_INTERRUPT_STATUS_1__OTG5_RANGE_TIMING_UPDATE_OCCURRED__SHIFT                                     0xb
#define DMCU_INTERRUPT_STATUS_1__OTG5_RANGE_TIMING_UPDATE_CLEAR__SHIFT                                        0xb
#define DMCU_INTERRUPT_STATUS_1__DMCU_GENERIC_INTERRUPT_OCCURRED__SHIFT                                       0xd
#define DMCU_INTERRUPT_STATUS_1__DMCU_GENERIC_INTERRUPT_CLEAR__SHIFT                                          0xd
#define DMCU_INTERRUPT_STATUS_1__OTG0_RANGE_TIMING_UPDATE_OCCURRED_MASK                                       0x00000040L
#define DMCU_INTERRUPT_STATUS_1__OTG0_RANGE_TIMING_UPDATE_CLEAR_MASK                                          0x00000040L
#define DMCU_INTERRUPT_STATUS_1__OTG1_RANGE_TIMING_UPDATE_OCCURRED_MASK                                       0x00000080L
#define DMCU_INTERRUPT_STATUS_1__OTG1_RANGE_TIMING_UPDATE_CLEAR_MASK                                          0x00000080L
#define DMCU_INTERRUPT_STATUS_1__OTG2_RANGE_TIMING_UPDATE_OCCURRED_MASK                                       0x00000100L
#define DMCU_INTERRUPT_STATUS_1__OTG2_RANGE_TIMING_UPDATE_CLEAR_MASK                                          0x00000100L
#define DMCU_INTERRUPT_STATUS_1__OTG3_RANGE_TIMING_UPDATE_OCCURRED_MASK                                       0x00000200L
#define DMCU_INTERRUPT_STATUS_1__OTG3_RANGE_TIMING_UPDATE_CLEAR_MASK                                          0x00000200L
#define DMCU_INTERRUPT_STATUS_1__OTG4_RANGE_TIMING_UPDATE_OCCURRED_MASK                                       0x00000400L
#define DMCU_INTERRUPT_STATUS_1__OTG4_RANGE_TIMING_UPDATE_CLEAR_MASK                                          0x00000400L
#define DMCU_INTERRUPT_STATUS_1__OTG5_RANGE_TIMING_UPDATE_OCCURRED_MASK                                       0x00000800L
#define DMCU_INTERRUPT_STATUS_1__OTG5_RANGE_TIMING_UPDATE_CLEAR_MASK                                          0x00000800L
#define DMCU_INTERRUPT_STATUS_1__DMCU_GENERIC_INTERRUPT_OCCURRED_MASK                                         0x00002000L
#define DMCU_INTERRUPT_STATUS_1__DMCU_GENERIC_INTERRUPT_CLEAR_MASK                                            0x00002000L
//DMCU_INTERRUPT_TO_HOST_EN_MASK
#define DMCU_INTERRUPT_TO_HOST_EN_MASK__ABM0_HG_READY_INT_MASK__SHIFT                                         0x0
#define DMCU_INTERRUPT_TO_HOST_EN_MASK__ABM0_LS_READY_INT_MASK__SHIFT                                         0x1
#define DMCU_INTERRUPT_TO_HOST_EN_MASK__ABM0_BL_UPDATE_INT_MASK__SHIFT                                        0x2
#define DMCU_INTERRUPT_TO_HOST_EN_MASK__ABM1_HG_READY_INT_MASK__SHIFT                                         0x3
#define DMCU_INTERRUPT_TO_HOST_EN_MASK__ABM1_LS_READY_INT_MASK__SHIFT                                         0x4
#define DMCU_INTERRUPT_TO_HOST_EN_MASK__ABM1_BL_UPDATE_INT_MASK__SHIFT                                        0x5
#define DMCU_INTERRUPT_TO_HOST_EN_MASK__SCP_INT_MASK__SHIFT                                                   0x9
#define DMCU_INTERRUPT_TO_HOST_EN_MASK__UC_INTERNAL_INT_MASK__SHIFT                                           0xa
#define DMCU_INTERRUPT_TO_HOST_EN_MASK__UC_REG_RD_TIMEOUT_INT_MASK__SHIFT                                     0xb
#define DMCU_INTERRUPT_TO_HOST_EN_MASK__ABM0_HG_READY_INT_MASK_MASK                                           0x00000001L
#define DMCU_INTERRUPT_TO_HOST_EN_MASK__ABM0_LS_READY_INT_MASK_MASK                                           0x00000002L
#define DMCU_INTERRUPT_TO_HOST_EN_MASK__ABM0_BL_UPDATE_INT_MASK_MASK                                          0x00000004L
#define DMCU_INTERRUPT_TO_HOST_EN_MASK__ABM1_HG_READY_INT_MASK_MASK                                           0x00000008L
#define DMCU_INTERRUPT_TO_HOST_EN_MASK__ABM1_LS_READY_INT_MASK_MASK                                           0x00000010L
#define DMCU_INTERRUPT_TO_HOST_EN_MASK__ABM1_BL_UPDATE_INT_MASK_MASK                                          0x00000020L
#define DMCU_INTERRUPT_TO_HOST_EN_MASK__SCP_INT_MASK_MASK                                                     0x00000200L
#define DMCU_INTERRUPT_TO_HOST_EN_MASK__UC_INTERNAL_INT_MASK_MASK                                             0x00000400L
#define DMCU_INTERRUPT_TO_HOST_EN_MASK__UC_REG_RD_TIMEOUT_INT_MASK_MASK                                       0x00000800L
//DMCU_INTERRUPT_TO_UC_EN_MASK
#define DMCU_INTERRUPT_TO_UC_EN_MASK__ABM1_HG_READY_INT_TO_UC_EN__SHIFT                                       0x0
#define DMCU_INTERRUPT_TO_UC_EN_MASK__ABM1_LS_READY_INT_TO_UC_EN__SHIFT                                       0x1
#define DMCU_INTERRUPT_TO_UC_EN_MASK__ABM1_BL_UPDATE_INT_TO_UC_EN__SHIFT                                      0x2
#define DMCU_INTERRUPT_TO_UC_EN_MASK__MCP_INT_TO_UC_EN__SHIFT                                                 0x3
#define DMCU_INTERRUPT_TO_UC_EN_MASK__STATIC_SCREEN1_INT_TO_UC_EN__SHIFT                                      0x6
#define DMCU_INTERRUPT_TO_UC_EN_MASK__STATIC_SCREEN2_INT_TO_UC_EN__SHIFT                                      0x7
#define DMCU_INTERRUPT_TO_UC_EN_MASK__EXTERNAL_SW_INT_TO_UC_EN__SHIFT                                         0x8
#define DMCU_INTERRUPT_TO_UC_EN_MASK__STATIC_SCREEN3_INT_TO_UC_EN__SHIFT                                      0x9
#define DMCU_INTERRUPT_TO_UC_EN_MASK__STATIC_SCREEN4_INT_TO_UC_EN__SHIFT                                      0xa
#define DMCU_INTERRUPT_TO_UC_EN_MASK__STATIC_SCREEN5_INT_TO_UC_EN__SHIFT                                      0xb
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DOMAIN0_POWER_UP_INT_TO_UC_EN__SHIFT                           0xc
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DOMAIN1_POWER_UP_INT_TO_UC_EN__SHIFT                           0xd
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DOMAIN2_POWER_UP_INT_TO_UC_EN__SHIFT                           0xe
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DOMAIN3_POWER_UP_INT_TO_UC_EN__SHIFT                           0xf
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DOMAIN4_POWER_UP_INT_TO_UC_EN__SHIFT                           0x10
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DOMAIN5_POWER_UP_INT_TO_UC_EN__SHIFT                           0x11
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DOMAIN0_POWER_DOWN_INT_TO_UC_EN__SHIFT                         0x12
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DOMAIN1_POWER_DOWN_INT_TO_UC_EN__SHIFT                         0x13
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DOMAIN2_POWER_DOWN_INT_TO_UC_EN__SHIFT                         0x14
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DOMAIN3_POWER_DOWN_INT_TO_UC_EN__SHIFT                         0x15
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DOMAIN4_POWER_DOWN_INT_TO_UC_EN__SHIFT                         0x16
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DOMAIN5_POWER_DOWN_INT_TO_UC_EN__SHIFT                         0x17
#define DMCU_INTERRUPT_TO_UC_EN_MASK__VBLANK1_INT_TO_UC_EN__SHIFT                                             0x18
#define DMCU_INTERRUPT_TO_UC_EN_MASK__VBLANK2_INT_TO_UC_EN__SHIFT                                             0x19
#define DMCU_INTERRUPT_TO_UC_EN_MASK__VBLANK3_INT_TO_UC_EN__SHIFT                                             0x1a
#define DMCU_INTERRUPT_TO_UC_EN_MASK__VBLANK4_INT_TO_UC_EN__SHIFT                                             0x1b
#define DMCU_INTERRUPT_TO_UC_EN_MASK__VBLANK5_INT_TO_UC_EN__SHIFT                                             0x1c
#define DMCU_INTERRUPT_TO_UC_EN_MASK__VBLANK6_INT_TO_UC_EN__SHIFT                                             0x1d
#define DMCU_INTERRUPT_TO_UC_EN_MASK__STATIC_SCREEN6_INT_TO_UC_EN__SHIFT                                      0x1e
#define DMCU_INTERRUPT_TO_UC_EN_MASK__ABM1_HG_READY_INT_TO_UC_EN_MASK                                         0x00000001L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__ABM1_LS_READY_INT_TO_UC_EN_MASK                                         0x00000002L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__ABM1_BL_UPDATE_INT_TO_UC_EN_MASK                                        0x00000004L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__MCP_INT_TO_UC_EN_MASK                                                   0x00000008L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__STATIC_SCREEN1_INT_TO_UC_EN_MASK                                        0x00000040L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__STATIC_SCREEN2_INT_TO_UC_EN_MASK                                        0x00000080L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__EXTERNAL_SW_INT_TO_UC_EN_MASK                                           0x00000100L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__STATIC_SCREEN3_INT_TO_UC_EN_MASK                                        0x00000200L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__STATIC_SCREEN4_INT_TO_UC_EN_MASK                                        0x00000400L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__STATIC_SCREEN5_INT_TO_UC_EN_MASK                                        0x00000800L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DOMAIN0_POWER_UP_INT_TO_UC_EN_MASK                             0x00001000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DOMAIN1_POWER_UP_INT_TO_UC_EN_MASK                             0x00002000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DOMAIN2_POWER_UP_INT_TO_UC_EN_MASK                             0x00004000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DOMAIN3_POWER_UP_INT_TO_UC_EN_MASK                             0x00008000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DOMAIN4_POWER_UP_INT_TO_UC_EN_MASK                             0x00010000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DOMAIN5_POWER_UP_INT_TO_UC_EN_MASK                             0x00020000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DOMAIN0_POWER_DOWN_INT_TO_UC_EN_MASK                           0x00040000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DOMAIN1_POWER_DOWN_INT_TO_UC_EN_MASK                           0x00080000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DOMAIN2_POWER_DOWN_INT_TO_UC_EN_MASK                           0x00100000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DOMAIN3_POWER_DOWN_INT_TO_UC_EN_MASK                           0x00200000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DOMAIN4_POWER_DOWN_INT_TO_UC_EN_MASK                           0x00400000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DOMAIN5_POWER_DOWN_INT_TO_UC_EN_MASK                           0x00800000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__VBLANK1_INT_TO_UC_EN_MASK                                               0x01000000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__VBLANK2_INT_TO_UC_EN_MASK                                               0x02000000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__VBLANK3_INT_TO_UC_EN_MASK                                               0x04000000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__VBLANK4_INT_TO_UC_EN_MASK                                               0x08000000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__VBLANK5_INT_TO_UC_EN_MASK                                               0x10000000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__VBLANK6_INT_TO_UC_EN_MASK                                               0x20000000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__STATIC_SCREEN6_INT_TO_UC_EN_MASK                                        0x40000000L
//DMCU_INTERRUPT_TO_UC_EN_MASK_1
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__OTG0_RANGE_TIMING_UPDATE_INT_TO_UC_EN__SHIFT                          0x6
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__OTG1_RANGE_TIMING_UPDATE_INT_TO_UC_EN__SHIFT                          0x7
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__OTG2_RANGE_TIMING_UPDATE_INT_TO_UC_EN__SHIFT                          0x8
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__OTG3_RANGE_TIMING_UPDATE_INT_TO_UC_EN__SHIFT                          0x9
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__OTG4_RANGE_TIMING_UPDATE_INT_TO_UC_EN__SHIFT                          0xa
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__OTG5_RANGE_TIMING_UPDATE_INT_TO_UC_EN__SHIFT                          0xb
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__DMCU_GENERIC_INT_TO_UC_EN__SHIFT                                      0xd
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__OTG0_RANGE_TIMING_UPDATE_INT_TO_UC_EN_MASK                            0x00000040L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__OTG1_RANGE_TIMING_UPDATE_INT_TO_UC_EN_MASK                            0x00000080L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__OTG2_RANGE_TIMING_UPDATE_INT_TO_UC_EN_MASK                            0x00000100L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__OTG3_RANGE_TIMING_UPDATE_INT_TO_UC_EN_MASK                            0x00000200L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__OTG4_RANGE_TIMING_UPDATE_INT_TO_UC_EN_MASK                            0x00000400L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__OTG5_RANGE_TIMING_UPDATE_INT_TO_UC_EN_MASK                            0x00000800L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__DMCU_GENERIC_INT_TO_UC_EN_MASK                                        0x00002000L
//DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__ABM1_HG_READY_INT_XIRQ_IRQ_SEL__SHIFT                              0x0
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__ABM1_LS_READY_INT_XIRQ_IRQ_SEL__SHIFT                              0x1
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__ABM1_BL_UPDATE_INT_XIRQ_IRQ_SEL__SHIFT                             0x2
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__MCP_INT_XIRQ_IRQ_SEL__SHIFT                                        0x3
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__STATIC_SCREEN1_INT_XIRQ_IRQ_SEL__SHIFT                             0x6
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__STATIC_SCREEN2_INT_XIRQ_IRQ_SEL__SHIFT                             0x7
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__EXTERNAL_SW_INT_XIRQ_IRQ_SEL__SHIFT                                0x8
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__STATIC_SCREEN3_INT_XIRQ_IRQ_SEL__SHIFT                             0x9
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__STATIC_SCREEN4_INT_XIRQ_IRQ_SEL__SHIFT                             0xa
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__STATIC_SCREEN5_INT_XIRQ_IRQ_SEL__SHIFT                             0xb
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DOMAIN0_POWER_UP_INT_XIRQ_IRQ_SEL__SHIFT                  0xc
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DOMAIN1_POWER_UP_INT_XIRQ_IRQ_SEL__SHIFT                  0xd
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DOMAIN2_POWER_UP_INT_XIRQ_IRQ_SEL__SHIFT                  0xe
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DOMAIN3_POWER_UP_INT_XIRQ_IRQ_SEL__SHIFT                  0xf
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DOMAIN4_POWER_UP_INT_XIRQ_IRQ_SEL__SHIFT                  0x10
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DOMAIN5_POWER_UP_INT_XIRQ_IRQ_SEL__SHIFT                  0x11
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DOMAIN0_POWER_DOWN_INT_XIRQ_IRQ_SEL__SHIFT                0x12
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DOMAIN1_POWER_DOWN_INT_XIRQ_IRQ_SEL__SHIFT                0x13
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DOMAIN2_POWER_DOWN_INT_XIRQ_IRQ_SEL__SHIFT                0x14
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DOMAIN3_POWER_DOWN_INT_XIRQ_IRQ_SEL__SHIFT                0x15
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DOMAIN4_POWER_DOWN_INT_XIRQ_IRQ_SEL__SHIFT                0x16
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DOMAIN5_POWER_DOWN_INT_XIRQ_IRQ_SEL__SHIFT                0x17
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__VBLANK1_INT_XIRQ_IRQ_SEL__SHIFT                                    0x18
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__VBLANK2_INT_XIRQ_IRQ_SEL__SHIFT                                    0x19
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__VBLANK3_INT_XIRQ_IRQ_SEL__SHIFT                                    0x1a
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__VBLANK4_INT_XIRQ_IRQ_SEL__SHIFT                                    0x1b
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__VBLANK5_INT_XIRQ_IRQ_SEL__SHIFT                                    0x1c
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__VBLANK6_INT_XIRQ_IRQ_SEL__SHIFT                                    0x1d
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__STATIC_SCREEN6_INT_XIRQ_IRQ_SEL__SHIFT                             0x1e
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__ABM1_HG_READY_INT_XIRQ_IRQ_SEL_MASK                                0x00000001L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__ABM1_LS_READY_INT_XIRQ_IRQ_SEL_MASK                                0x00000002L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__ABM1_BL_UPDATE_INT_XIRQ_IRQ_SEL_MASK                               0x00000004L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__MCP_INT_XIRQ_IRQ_SEL_MASK                                          0x00000008L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__STATIC_SCREEN1_INT_XIRQ_IRQ_SEL_MASK                               0x00000040L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__STATIC_SCREEN2_INT_XIRQ_IRQ_SEL_MASK                               0x00000080L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__EXTERNAL_SW_INT_XIRQ_IRQ_SEL_MASK                                  0x00000100L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__STATIC_SCREEN3_INT_XIRQ_IRQ_SEL_MASK                               0x00000200L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__STATIC_SCREEN4_INT_XIRQ_IRQ_SEL_MASK                               0x00000400L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__STATIC_SCREEN5_INT_XIRQ_IRQ_SEL_MASK                               0x00000800L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DOMAIN0_POWER_UP_INT_XIRQ_IRQ_SEL_MASK                    0x00001000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DOMAIN1_POWER_UP_INT_XIRQ_IRQ_SEL_MASK                    0x00002000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DOMAIN2_POWER_UP_INT_XIRQ_IRQ_SEL_MASK                    0x00004000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DOMAIN3_POWER_UP_INT_XIRQ_IRQ_SEL_MASK                    0x00008000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DOMAIN4_POWER_UP_INT_XIRQ_IRQ_SEL_MASK                    0x00010000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DOMAIN5_POWER_UP_INT_XIRQ_IRQ_SEL_MASK                    0x00020000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DOMAIN0_POWER_DOWN_INT_XIRQ_IRQ_SEL_MASK                  0x00040000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DOMAIN1_POWER_DOWN_INT_XIRQ_IRQ_SEL_MASK                  0x00080000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DOMAIN2_POWER_DOWN_INT_XIRQ_IRQ_SEL_MASK                  0x00100000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DOMAIN3_POWER_DOWN_INT_XIRQ_IRQ_SEL_MASK                  0x00200000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DOMAIN4_POWER_DOWN_INT_XIRQ_IRQ_SEL_MASK                  0x00400000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DOMAIN5_POWER_DOWN_INT_XIRQ_IRQ_SEL_MASK                  0x00800000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__VBLANK1_INT_XIRQ_IRQ_SEL_MASK                                      0x01000000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__VBLANK2_INT_XIRQ_IRQ_SEL_MASK                                      0x02000000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__VBLANK3_INT_XIRQ_IRQ_SEL_MASK                                      0x04000000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__VBLANK4_INT_XIRQ_IRQ_SEL_MASK                                      0x08000000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__VBLANK5_INT_XIRQ_IRQ_SEL_MASK                                      0x10000000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__VBLANK6_INT_XIRQ_IRQ_SEL_MASK                                      0x20000000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__STATIC_SCREEN6_INT_XIRQ_IRQ_SEL_MASK                               0x40000000L
//DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__OTG0_RANGE_TIMING_UPDATE_INT_XIRQ_IRQ_SEL__SHIFT                 0x6
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__OTG1_RANGE_TIMING_UPDATE_INT_XIRQ_IRQ_SEL__SHIFT                 0x7
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__OTG2_RANGE_TIMING_UPDATE_INT_XIRQ_IRQ_SEL__SHIFT                 0x8
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__OTG3_RANGE_TIMING_UPDATE_INT_XIRQ_IRQ_SEL__SHIFT                 0x9
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__OTG4_RANGE_TIMING_UPDATE_INT_XIRQ_IRQ_SEL__SHIFT                 0xa
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__OTG5_RANGE_TIMING_UPDATE_INT_XIRQ_IRQ_SEL__SHIFT                 0xb
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__DMCU_GENERIC_INT_XIRQ_IRQ_SEL__SHIFT                             0xd
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__OTG0_RANGE_TIMING_UPDATE_INT_XIRQ_IRQ_SEL_MASK                   0x00000040L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__OTG1_RANGE_TIMING_UPDATE_INT_XIRQ_IRQ_SEL_MASK                   0x00000080L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__OTG2_RANGE_TIMING_UPDATE_INT_XIRQ_IRQ_SEL_MASK                   0x00000100L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__OTG3_RANGE_TIMING_UPDATE_INT_XIRQ_IRQ_SEL_MASK                   0x00000200L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__OTG4_RANGE_TIMING_UPDATE_INT_XIRQ_IRQ_SEL_MASK                   0x00000400L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__OTG5_RANGE_TIMING_UPDATE_INT_XIRQ_IRQ_SEL_MASK                   0x00000800L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__DMCU_GENERIC_INT_XIRQ_IRQ_SEL_MASK                               0x00002000L
//DC_DMCU_SCRATCH
#define DC_DMCU_SCRATCH__DMCU_SCRATCH__SHIFT                                                                  0x0
#define DC_DMCU_SCRATCH__DMCU_SCRATCH_MASK                                                                    0xFFFFFFFFL
//DMCU_INT_CNT
#define DMCU_INT_CNT__DMCU_ABM1_HG_READY_INT_CNT__SHIFT                                                       0x0
#define DMCU_INT_CNT__DMCU_ABM1_LS_READY_INT_CNT__SHIFT                                                       0x8
#define DMCU_INT_CNT__DMCU_ABM1_BL_UPDATE_INT_CNT__SHIFT                                                      0x10
#define DMCU_INT_CNT__DMCU_ABM1_HG_READY_INT_CNT_MASK                                                         0x000000FFL
#define DMCU_INT_CNT__DMCU_ABM1_LS_READY_INT_CNT_MASK                                                         0x0000FF00L
#define DMCU_INT_CNT__DMCU_ABM1_BL_UPDATE_INT_CNT_MASK                                                        0x00FF0000L
//DMCU_FW_CHECKSUM_SMPL_BYTE_POS
#define DMCU_FW_CHECKSUM_SMPL_BYTE_POS__DMCU_FW_CHECKSUM_LO_SMPL_BYTE_POS__SHIFT                              0x0
#define DMCU_FW_CHECKSUM_SMPL_BYTE_POS__DMCU_FW_CHECKSUM_HI_SMPL_BYTE_POS__SHIFT                              0x2
#define DMCU_FW_CHECKSUM_SMPL_BYTE_POS__DMCU_FW_CHECKSUM_LO_SMPL_BYTE_POS_MASK                                0x00000003L
#define DMCU_FW_CHECKSUM_SMPL_BYTE_POS__DMCU_FW_CHECKSUM_HI_SMPL_BYTE_POS_MASK                                0x0000000CL
//DMCU_UC_CLK_GATING_CNTL
#define DMCU_UC_CLK_GATING_CNTL__UC_IRAM_RD_DELAY__SHIFT                                                      0x0
#define DMCU_UC_CLK_GATING_CNTL__UC_ERAM_RD_DELAY__SHIFT                                                      0x8
#define DMCU_UC_CLK_GATING_CNTL__UC_RBBM_RD_CLK_GATING_EN__SHIFT                                              0x10
#define DMCU_UC_CLK_GATING_CNTL__UC_IRAM_RD_DELAY_MASK                                                        0x00000007L
#define DMCU_UC_CLK_GATING_CNTL__UC_ERAM_RD_DELAY_MASK                                                        0x00000700L
#define DMCU_UC_CLK_GATING_CNTL__UC_RBBM_RD_CLK_GATING_EN_MASK                                                0x00010000L
//MASTER_COMM_DATA_REG1
#define MASTER_COMM_DATA_REG1__MASTER_COMM_DATA_REG1_BYTE0__SHIFT                                             0x0
#define MASTER_COMM_DATA_REG1__MASTER_COMM_DATA_REG1_BYTE1__SHIFT                                             0x8
#define MASTER_COMM_DATA_REG1__MASTER_COMM_DATA_REG1_BYTE2__SHIFT                                             0x10
#define MASTER_COMM_DATA_REG1__MASTER_COMM_DATA_REG1_BYTE3__SHIFT                                             0x18
#define MASTER_COMM_DATA_REG1__MASTER_COMM_DATA_REG1_BYTE0_MASK                                               0x000000FFL
#define MASTER_COMM_DATA_REG1__MASTER_COMM_DATA_REG1_BYTE1_MASK                                               0x0000FF00L
#define MASTER_COMM_DATA_REG1__MASTER_COMM_DATA_REG1_BYTE2_MASK                                               0x00FF0000L
#define MASTER_COMM_DATA_REG1__MASTER_COMM_DATA_REG1_BYTE3_MASK                                               0xFF000000L
//MASTER_COMM_DATA_REG2
#define MASTER_COMM_DATA_REG2__MASTER_COMM_DATA_REG2_BYTE0__SHIFT                                             0x0
#define MASTER_COMM_DATA_REG2__MASTER_COMM_DATA_REG2_BYTE1__SHIFT                                             0x8
#define MASTER_COMM_DATA_REG2__MASTER_COMM_DATA_REG2_BYTE2__SHIFT                                             0x10
#define MASTER_COMM_DATA_REG2__MASTER_COMM_DATA_REG2_BYTE3__SHIFT                                             0x18
#define MASTER_COMM_DATA_REG2__MASTER_COMM_DATA_REG2_BYTE0_MASK                                               0x000000FFL
#define MASTER_COMM_DATA_REG2__MASTER_COMM_DATA_REG2_BYTE1_MASK                                               0x0000FF00L
#define MASTER_COMM_DATA_REG2__MASTER_COMM_DATA_REG2_BYTE2_MASK                                               0x00FF0000L
#define MASTER_COMM_DATA_REG2__MASTER_COMM_DATA_REG2_BYTE3_MASK                                               0xFF000000L
//MASTER_COMM_DATA_REG3
#define MASTER_COMM_DATA_REG3__MASTER_COMM_DATA_REG3_BYTE0__SHIFT                                             0x0
#define MASTER_COMM_DATA_REG3__MASTER_COMM_DATA_REG3_BYTE1__SHIFT                                             0x8
#define MASTER_COMM_DATA_REG3__MASTER_COMM_DATA_REG3_BYTE2__SHIFT                                             0x10
#define MASTER_COMM_DATA_REG3__MASTER_COMM_DATA_REG3_BYTE3__SHIFT                                             0x18
#define MASTER_COMM_DATA_REG3__MASTER_COMM_DATA_REG3_BYTE0_MASK                                               0x000000FFL
#define MASTER_COMM_DATA_REG3__MASTER_COMM_DATA_REG3_BYTE1_MASK                                               0x0000FF00L
#define MASTER_COMM_DATA_REG3__MASTER_COMM_DATA_REG3_BYTE2_MASK                                               0x00FF0000L
#define MASTER_COMM_DATA_REG3__MASTER_COMM_DATA_REG3_BYTE3_MASK                                               0xFF000000L
//MASTER_COMM_CMD_REG
#define MASTER_COMM_CMD_REG__MASTER_COMM_CMD_REG_BYTE0__SHIFT                                                 0x0
#define MASTER_COMM_CMD_REG__MASTER_COMM_CMD_REG_BYTE1__SHIFT                                                 0x8
#define MASTER_COMM_CMD_REG__MASTER_COMM_CMD_REG_BYTE2__SHIFT                                                 0x10
#define MASTER_COMM_CMD_REG__MASTER_COMM_CMD_REG_BYTE3__SHIFT                                                 0x18
#define MASTER_COMM_CMD_REG__MASTER_COMM_CMD_REG_BYTE0_MASK                                                   0x000000FFL
#define MASTER_COMM_CMD_REG__MASTER_COMM_CMD_REG_BYTE1_MASK                                                   0x0000FF00L
#define MASTER_COMM_CMD_REG__MASTER_COMM_CMD_REG_BYTE2_MASK                                                   0x00FF0000L
#define MASTER_COMM_CMD_REG__MASTER_COMM_CMD_REG_BYTE3_MASK                                                   0xFF000000L
//MASTER_COMM_CNTL_REG
#define MASTER_COMM_CNTL_REG__MASTER_COMM_INTERRUPT__SHIFT                                                    0x0
#define MASTER_COMM_CNTL_REG__MASTER_COMM_INTERRUPT_MASK                                                      0x00000001L
//SLAVE_COMM_DATA_REG1
#define SLAVE_COMM_DATA_REG1__SLAVE_COMM_DATA_REG1_BYTE0__SHIFT                                               0x0
#define SLAVE_COMM_DATA_REG1__SLAVE_COMM_DATA_REG1_BYTE1__SHIFT                                               0x8
#define SLAVE_COMM_DATA_REG1__SLAVE_COMM_DATA_REG1_BYTE2__SHIFT                                               0x10
#define SLAVE_COMM_DATA_REG1__SLAVE_COMM_DATA_REG1_BYTE3__SHIFT                                               0x18
#define SLAVE_COMM_DATA_REG1__SLAVE_COMM_DATA_REG1_BYTE0_MASK                                                 0x000000FFL
#define SLAVE_COMM_DATA_REG1__SLAVE_COMM_DATA_REG1_BYTE1_MASK                                                 0x0000FF00L
#define SLAVE_COMM_DATA_REG1__SLAVE_COMM_DATA_REG1_BYTE2_MASK                                                 0x00FF0000L
#define SLAVE_COMM_DATA_REG1__SLAVE_COMM_DATA_REG1_BYTE3_MASK                                                 0xFF000000L
//SLAVE_COMM_DATA_REG2
#define SLAVE_COMM_DATA_REG2__SLAVE_COMM_DATA_REG2_BYTE0__SHIFT                                               0x0
#define SLAVE_COMM_DATA_REG2__SLAVE_COMM_DATA_REG2_BYTE1__SHIFT                                               0x8
#define SLAVE_COMM_DATA_REG2__SLAVE_COMM_DATA_REG2_BYTE2__SHIFT                                               0x10
#define SLAVE_COMM_DATA_REG2__SLAVE_COMM_DATA_REG2_BYTE3__SHIFT                                               0x18
#define SLAVE_COMM_DATA_REG2__SLAVE_COMM_DATA_REG2_BYTE0_MASK                                                 0x000000FFL
#define SLAVE_COMM_DATA_REG2__SLAVE_COMM_DATA_REG2_BYTE1_MASK                                                 0x0000FF00L
#define SLAVE_COMM_DATA_REG2__SLAVE_COMM_DATA_REG2_BYTE2_MASK                                                 0x00FF0000L
#define SLAVE_COMM_DATA_REG2__SLAVE_COMM_DATA_REG2_BYTE3_MASK                                                 0xFF000000L
//SLAVE_COMM_DATA_REG3
#define SLAVE_COMM_DATA_REG3__SLAVE_COMM_DATA_REG3_BYTE0__SHIFT                                               0x0
#define SLAVE_COMM_DATA_REG3__SLAVE_COMM_DATA_REG3_BYTE1__SHIFT                                               0x8
#define SLAVE_COMM_DATA_REG3__SLAVE_COMM_DATA_REG3_BYTE2__SHIFT                                               0x10
#define SLAVE_COMM_DATA_REG3__SLAVE_COMM_DATA_REG3_BYTE3__SHIFT                                               0x18
#define SLAVE_COMM_DATA_REG3__SLAVE_COMM_DATA_REG3_BYTE0_MASK                                                 0x000000FFL
#define SLAVE_COMM_DATA_REG3__SLAVE_COMM_DATA_REG3_BYTE1_MASK                                                 0x0000FF00L
#define SLAVE_COMM_DATA_REG3__SLAVE_COMM_DATA_REG3_BYTE2_MASK                                                 0x00FF0000L
#define SLAVE_COMM_DATA_REG3__SLAVE_COMM_DATA_REG3_BYTE3_MASK                                                 0xFF000000L
//SLAVE_COMM_CMD_REG
#define SLAVE_COMM_CMD_REG__SLAVE_COMM_CMD_REG_BYTE0__SHIFT                                                   0x0
#define SLAVE_COMM_CMD_REG__SLAVE_COMM_CMD_REG_BYTE1__SHIFT                                                   0x8
#define SLAVE_COMM_CMD_REG__SLAVE_COMM_CMD_REG_BYTE2__SHIFT                                                   0x10
#define SLAVE_COMM_CMD_REG__SLAVE_COMM_CMD_REG_BYTE3__SHIFT                                                   0x18
#define SLAVE_COMM_CMD_REG__SLAVE_COMM_CMD_REG_BYTE0_MASK                                                     0x000000FFL
#define SLAVE_COMM_CMD_REG__SLAVE_COMM_CMD_REG_BYTE1_MASK                                                     0x0000FF00L
#define SLAVE_COMM_CMD_REG__SLAVE_COMM_CMD_REG_BYTE2_MASK                                                     0x00FF0000L
#define SLAVE_COMM_CMD_REG__SLAVE_COMM_CMD_REG_BYTE3_MASK                                                     0xFF000000L
//SLAVE_COMM_CNTL_REG
#define SLAVE_COMM_CNTL_REG__SLAVE_COMM_INTERRUPT__SHIFT                                                      0x0
#define SLAVE_COMM_CNTL_REG__COMM_PORT_MSG_TO_HOST_IN_PROGRESS__SHIFT                                         0x8
#define SLAVE_COMM_CNTL_REG__SLAVE_COMM_INTERRUPT_MASK                                                        0x00000001L
#define SLAVE_COMM_CNTL_REG__COMM_PORT_MSG_TO_HOST_IN_PROGRESS_MASK                                           0x00000100L
//DMCU_PERFMON_INTERRUPT_STATUS1
#define DMCU_PERFMON_INTERRUPT_STATUS1__DMU_PERFMON_COUNTER_INT_OCCURRED__SHIFT                               0x0
#define DMCU_PERFMON_INTERRUPT_STATUS1__DMU_PERFMON_COUNTER_INT_CLEAR__SHIFT                                  0x0
#define DMCU_PERFMON_INTERRUPT_STATUS1__DIO_PERFMON_COUNTER_INT_OCCURRED__SHIFT                               0x1
#define DMCU_PERFMON_INTERRUPT_STATUS1__DIO_PERFMON_COUNTER_INT_CLEAR__SHIFT                                  0x1
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER_INT_OCCURRED__SHIFT                              0x2
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER_INT_CLEAR__SHIFT                                 0x2
#define DMCU_PERFMON_INTERRUPT_STATUS1__DMU_PERFMON_COUNTER_INT_OCCURRED_MASK                                 0x00000001L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DMU_PERFMON_COUNTER_INT_CLEAR_MASK                                    0x00000001L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DIO_PERFMON_COUNTER_INT_OCCURRED_MASK                                 0x00000002L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DIO_PERFMON_COUNTER_INT_CLEAR_MASK                                    0x00000002L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER_INT_OCCURRED_MASK                                0x00000004L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER_INT_CLEAR_MASK                                   0x00000004L
//DMCU_PERFMON_INTERRUPT_STATUS2
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBP0_PERFMON_COUNTER_INT_OCCURRED__SHIFT                             0x0
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBP0_PERFMON_COUNTER_INT_CLEAR__SHIFT                                0x0
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBP1_PERFMON_COUNTER_INT_OCCURRED__SHIFT                             0x1
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBP1_PERFMON_COUNTER_INT_CLEAR__SHIFT                                0x1
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBP2_PERFMON_COUNTER_INT_OCCURRED__SHIFT                             0x2
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBP2_PERFMON_COUNTER_INT_CLEAR__SHIFT                                0x2
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBP3_PERFMON_COUNTER_INT_OCCURRED__SHIFT                             0x3
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBP3_PERFMON_COUNTER_INT_CLEAR__SHIFT                                0x3
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBP4_PERFMON_COUNTER_INT_OCCURRED__SHIFT                             0x4
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBP4_PERFMON_COUNTER_INT_CLEAR__SHIFT                                0x4
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBP5_PERFMON_COUNTER_INT_OCCURRED__SHIFT                             0x5
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBP5_PERFMON_COUNTER_INT_CLEAR__SHIFT                                0x5
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBP6_PERFMON_COUNTER_INT_OCCURRED__SHIFT                             0x6
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBP6_PERFMON_COUNTER_INT_CLEAR__SHIFT                                0x6
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBP7_PERFMON_COUNTER_INT_OCCURRED__SHIFT                             0x7
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBP7_PERFMON_COUNTER_INT_CLEAR__SHIFT                                0x7
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBBUB_PERFMON_COUNTER_INT_OCCURRED__SHIFT                            0x8
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBBUB_PERFMON_COUNTER_INT_CLEAR__SHIFT                               0x8
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBP0_PERFMON_COUNTER_INT_OCCURRED_MASK                               0x00000001L
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBP0_PERFMON_COUNTER_INT_CLEAR_MASK                                  0x00000001L
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBP1_PERFMON_COUNTER_INT_OCCURRED_MASK                               0x00000002L
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBP1_PERFMON_COUNTER_INT_CLEAR_MASK                                  0x00000002L
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBP2_PERFMON_COUNTER_INT_OCCURRED_MASK                               0x00000004L
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBP2_PERFMON_COUNTER_INT_CLEAR_MASK                                  0x00000004L
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBP3_PERFMON_COUNTER_INT_OCCURRED_MASK                               0x00000008L
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBP3_PERFMON_COUNTER_INT_CLEAR_MASK                                  0x00000008L
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBP4_PERFMON_COUNTER_INT_OCCURRED_MASK                               0x00000010L
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBP4_PERFMON_COUNTER_INT_CLEAR_MASK                                  0x00000010L
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBP5_PERFMON_COUNTER_INT_OCCURRED_MASK                               0x00000020L
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBP5_PERFMON_COUNTER_INT_CLEAR_MASK                                  0x00000020L
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBP6_PERFMON_COUNTER_INT_OCCURRED_MASK                               0x00000040L
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBP6_PERFMON_COUNTER_INT_CLEAR_MASK                                  0x00000040L
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBP7_PERFMON_COUNTER_INT_OCCURRED_MASK                               0x00000080L
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBP7_PERFMON_COUNTER_INT_CLEAR_MASK                                  0x00000080L
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBBUB_PERFMON_COUNTER_INT_OCCURRED_MASK                              0x00000100L
#define DMCU_PERFMON_INTERRUPT_STATUS2__HUBBUB_PERFMON_COUNTER_INT_CLEAR_MASK                                 0x00000100L
//DMCU_PERFMON_INTERRUPT_STATUS3
#define DMCU_PERFMON_INTERRUPT_STATUS3__DPP0_PERFMON_COUNTER_INT_OCCURRED__SHIFT                              0x0
#define DMCU_PERFMON_INTERRUPT_STATUS3__DPP0_PERFMON_COUNTER_INT_CLEAR__SHIFT                                 0x0
#define DMCU_PERFMON_INTERRUPT_STATUS3__DPP1_PERFMON_COUNTER_INT_OCCURRED__SHIFT                              0x1
#define DMCU_PERFMON_INTERRUPT_STATUS3__DPP1_PERFMON_COUNTER_INT_CLEAR__SHIFT                                 0x1
#define DMCU_PERFMON_INTERRUPT_STATUS3__DPP2_PERFMON_COUNTER_INT_OCCURRED__SHIFT                              0x2
#define DMCU_PERFMON_INTERRUPT_STATUS3__DPP2_PERFMON_COUNTER_INT_CLEAR__SHIFT                                 0x2
#define DMCU_PERFMON_INTERRUPT_STATUS3__DPP3_PERFMON_COUNTER_INT_OCCURRED__SHIFT                              0x3
#define DMCU_PERFMON_INTERRUPT_STATUS3__DPP3_PERFMON_COUNTER_INT_CLEAR__SHIFT                                 0x3
#define DMCU_PERFMON_INTERRUPT_STATUS3__DPP4_PERFMON_COUNTER_INT_OCCURRED__SHIFT                              0x4
#define DMCU_PERFMON_INTERRUPT_STATUS3__DPP4_PERFMON_COUNTER_INT_CLEAR__SHIFT                                 0x4
#define DMCU_PERFMON_INTERRUPT_STATUS3__DPP5_PERFMON_COUNTER_INT_OCCURRED__SHIFT                              0x5
#define DMCU_PERFMON_INTERRUPT_STATUS3__DPP5_PERFMON_COUNTER_INT_CLEAR__SHIFT                                 0x5
#define DMCU_PERFMON_INTERRUPT_STATUS3__DPP6_PERFMON_COUNTER_INT_OCCURRED__SHIFT                              0x6
#define DMCU_PERFMON_INTERRUPT_STATUS3__DPP6_PERFMON_COUNTER_INT_CLEAR__SHIFT                                 0x6
#define DMCU_PERFMON_INTERRUPT_STATUS3__DPP7_PERFMON_COUNTER_INT_OCCURRED__SHIFT                              0x7
#define DMCU_PERFMON_INTERRUPT_STATUS3__DPP7_PERFMON_COUNTER_INT_CLEAR__SHIFT                                 0x7
#define DMCU_PERFMON_INTERRUPT_STATUS3__DPP0_PERFMON_COUNTER_INT_OCCURRED_MASK                                0x00000001L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DPP0_PERFMON_COUNTER_INT_CLEAR_MASK                                   0x00000001L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DPP1_PERFMON_COUNTER_INT_OCCURRED_MASK                                0x00000002L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DPP1_PERFMON_COUNTER_INT_CLEAR_MASK                                   0x00000002L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DPP2_PERFMON_COUNTER_INT_OCCURRED_MASK                                0x00000004L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DPP2_PERFMON_COUNTER_INT_CLEAR_MASK                                   0x00000004L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DPP3_PERFMON_COUNTER_INT_OCCURRED_MASK                                0x00000008L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DPP3_PERFMON_COUNTER_INT_CLEAR_MASK                                   0x00000008L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DPP4_PERFMON_COUNTER_INT_OCCURRED_MASK                                0x00000010L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DPP4_PERFMON_COUNTER_INT_CLEAR_MASK                                   0x00000010L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DPP5_PERFMON_COUNTER_INT_OCCURRED_MASK                                0x00000020L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DPP5_PERFMON_COUNTER_INT_CLEAR_MASK                                   0x00000020L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DPP6_PERFMON_COUNTER_INT_OCCURRED_MASK                                0x00000040L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DPP6_PERFMON_COUNTER_INT_CLEAR_MASK                                   0x00000040L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DPP7_PERFMON_COUNTER_INT_OCCURRED_MASK                                0x00000080L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DPP7_PERFMON_COUNTER_INT_CLEAR_MASK                                   0x00000080L
//DMCU_PERFMON_INTERRUPT_STATUS4
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB0_PERFMON_COUNTER_INT_OCCURRED__SHIFT                               0x0
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB0_PERFMON_COUNTER_INT_CLEAR__SHIFT                                  0x0
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB1_PERFMON_COUNTER_INT_OCCURRED__SHIFT                               0x1
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB1_PERFMON_COUNTER_INT_CLEAR__SHIFT                                  0x1
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER_INT_OCCURRED__SHIFT                             0x2
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER_INT_CLEAR__SHIFT                                0x2
#define DMCU_PERFMON_INTERRUPT_STATUS4__MMHUBBUB_PERFMON_COUNTER_INT_OCCURRED__SHIFT                          0x3
#define DMCU_PERFMON_INTERRUPT_STATUS4__MMHUBBUB_PERFMON_COUNTER_INT_CLEAR__SHIFT                             0x3
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB0_PERFMON_COUNTER_INT_OCCURRED_MASK                                 0x00000001L
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB0_PERFMON_COUNTER_INT_CLEAR_MASK                                    0x00000001L
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB1_PERFMON_COUNTER_INT_OCCURRED_MASK                                 0x00000002L
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB1_PERFMON_COUNTER_INT_CLEAR_MASK                                    0x00000002L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER_INT_OCCURRED_MASK                               0x00000004L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER_INT_CLEAR_MASK                                  0x00000004L
#define DMCU_PERFMON_INTERRUPT_STATUS4__MMHUBBUB_PERFMON_COUNTER_INT_OCCURRED_MASK                            0x00000008L
#define DMCU_PERFMON_INTERRUPT_STATUS4__MMHUBBUB_PERFMON_COUNTER_INT_CLEAR_MASK                               0x00000008L
//DMCU_PERFMON_INTERRUPT_STATUS5
#define DMCU_PERFMON_INTERRUPT_STATUS5__MPC_PERFMON_COUNTER_INT_OCCURRED__SHIFT                               0x0
#define DMCU_PERFMON_INTERRUPT_STATUS5__MPC_PERFMON_COUNTER_INT_CLEAR__SHIFT                                  0x0
#define DMCU_PERFMON_INTERRUPT_STATUS5__OPP_PERFMON_COUNTER_INT_OCCURRED__SHIFT                               0x1
#define DMCU_PERFMON_INTERRUPT_STATUS5__OPP_PERFMON_COUNTER_INT_CLEAR__SHIFT                                  0x1
#define DMCU_PERFMON_INTERRUPT_STATUS5__OPTC_PERFMON_COUNTER_INT_OCCURRED__SHIFT                              0x2
#define DMCU_PERFMON_INTERRUPT_STATUS5__OPTC_PERFMON_COUNTER_INT_CLEAR__SHIFT                                 0x2
#define DMCU_PERFMON_INTERRUPT_STATUS5__HDA_PERFMON_COUNTER_INT_OCCURRED__SHIFT                               0x3
#define DMCU_PERFMON_INTERRUPT_STATUS5__HDA_PERFMON_COUNTER_INT_CLEAR__SHIFT                                  0x3
#define DMCU_PERFMON_INTERRUPT_STATUS5__MPC_PERFMON_COUNTER_INT_OCCURRED_MASK                                 0x00000001L
#define DMCU_PERFMON_INTERRUPT_STATUS5__MPC_PERFMON_COUNTER_INT_CLEAR_MASK                                    0x00000001L
#define DMCU_PERFMON_INTERRUPT_STATUS5__OPP_PERFMON_COUNTER_INT_OCCURRED_MASK                                 0x00000002L
#define DMCU_PERFMON_INTERRUPT_STATUS5__OPP_PERFMON_COUNTER_INT_CLEAR_MASK                                    0x00000002L
#define DMCU_PERFMON_INTERRUPT_STATUS5__OPTC_PERFMON_COUNTER_INT_OCCURRED_MASK                                0x00000004L
#define DMCU_PERFMON_INTERRUPT_STATUS5__OPTC_PERFMON_COUNTER_INT_CLEAR_MASK                                   0x00000004L
#define DMCU_PERFMON_INTERRUPT_STATUS5__HDA_PERFMON_COUNTER_INT_OCCURRED_MASK                                 0x00000008L
#define DMCU_PERFMON_INTERRUPT_STATUS5__HDA_PERFMON_COUNTER_INT_CLEAR_MASK                                    0x00000008L
//DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DMU_PERFMON_COUNTER_INT_TO_UC_EN__SHIFT                        0x0
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DIO_PERFMON_COUNTER_INT_TO_UC_EN__SHIFT                        0x1
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCCG_PERFMON_COUNTER_INT_TO_UC_EN__SHIFT                       0x2
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DMU_PERFMON_COUNTER_INT_TO_UC_EN_MASK                          0x00000001L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DIO_PERFMON_COUNTER_INT_TO_UC_EN_MASK                          0x00000002L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCCG_PERFMON_COUNTER_INT_TO_UC_EN_MASK                         0x00000004L
//DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__HUBP0_PERFMON_COUNTER_INT_TO_UC_EN__SHIFT                      0x0
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__HUBP1_PERFMON_COUNTER_INT_TO_UC_EN__SHIFT                      0x1
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__HUBP2_PERFMON_COUNTER_INT_TO_UC_EN__SHIFT                      0x2
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__HUBP3_PERFMON_COUNTER_INT_TO_UC_EN__SHIFT                      0x3
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__HUBP4_PERFMON_COUNTER_INT_TO_UC_EN__SHIFT                      0x4
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__HUBP5_PERFMON_COUNTER_INT_TO_UC_EN__SHIFT                      0x5
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__HUBP6_PERFMON_COUNTER_INT_TO_UC_EN__SHIFT                      0x6
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__HUBP7_PERFMON_COUNTER_INT_TO_UC_EN__SHIFT                      0x7
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__HUBBUB_PERFMON_COUNTER_INT_TO_UC_EN__SHIFT                     0x8
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__HUBP0_PERFMON_COUNTER_INT_TO_UC_EN_MASK                        0x00000001L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__HUBP1_PERFMON_COUNTER_INT_TO_UC_EN_MASK                        0x00000002L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__HUBP2_PERFMON_COUNTER_INT_TO_UC_EN_MASK                        0x00000004L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__HUBP3_PERFMON_COUNTER_INT_TO_UC_EN_MASK                        0x00000008L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__HUBP4_PERFMON_COUNTER_INT_TO_UC_EN_MASK                        0x00000010L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__HUBP5_PERFMON_COUNTER_INT_TO_UC_EN_MASK                        0x00000020L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__HUBP6_PERFMON_COUNTER_INT_TO_UC_EN_MASK                        0x00000040L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__HUBP7_PERFMON_COUNTER_INT_TO_UC_EN_MASK                        0x00000080L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__HUBBUB_PERFMON_COUNTER_INT_TO_UC_EN_MASK                       0x00000100L
//DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DPP0_PERFMON_COUNTER_INT_TO_UC_EN__SHIFT                       0x0
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DPP1_PERFMON_COUNTER_INT_TO_UC_EN__SHIFT                       0x1
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DPP2_PERFMON_COUNTER_INT_TO_UC_EN__SHIFT                       0x2
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DPP3_PERFMON_COUNTER_INT_TO_UC_EN__SHIFT                       0x3
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DPP4_PERFMON_COUNTER_INT_TO_UC_EN__SHIFT                       0x4
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DPP5_PERFMON_COUNTER_INT_TO_UC_EN__SHIFT                       0x5
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DPP6_PERFMON_COUNTER_INT_TO_UC_EN__SHIFT                       0x6
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DPP7_PERFMON_COUNTER_INT_TO_UC_EN__SHIFT                       0x7
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DPP0_PERFMON_COUNTER_INT_TO_UC_EN_MASK                         0x00000001L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DPP1_PERFMON_COUNTER_INT_TO_UC_EN_MASK                         0x00000002L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DPP2_PERFMON_COUNTER_INT_TO_UC_EN_MASK                         0x00000004L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DPP3_PERFMON_COUNTER_INT_TO_UC_EN_MASK                         0x00000008L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DPP4_PERFMON_COUNTER_INT_TO_UC_EN_MASK                         0x00000010L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DPP5_PERFMON_COUNTER_INT_TO_UC_EN_MASK                         0x00000020L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DPP6_PERFMON_COUNTER_INT_TO_UC_EN_MASK                         0x00000040L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DPP7_PERFMON_COUNTER_INT_TO_UC_EN_MASK                         0x00000080L
//DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__WB0_PERFMON_COUNTER_INT_TO_UC_EN__SHIFT                        0x0
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__WB1_PERFMON_COUNTER_INT_TO_UC_EN__SHIFT                        0x1
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCCG_PERFMON2_COUNTER_INT_TO_UC_EN__SHIFT                      0x2
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__MMHUBBUB_PERFMON_COUNTER_INT_TO_UC_EN__SHIFT                   0x3
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__WB0_PERFMON_COUNTER_INT_TO_UC_EN_MASK                          0x00000001L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__WB1_PERFMON_COUNTER_INT_TO_UC_EN_MASK                          0x00000002L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCCG_PERFMON2_COUNTER_INT_TO_UC_EN_MASK                        0x00000004L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__MMHUBBUB_PERFMON_COUNTER_INT_TO_UC_EN_MASK                     0x00000008L
//DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__MPC_PERFMON_COUNTER_INT_TO_UC_EN__SHIFT                        0x0
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__OPP_PERFMON_COUNTER_INT_TO_UC_EN__SHIFT                        0x1
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__OPTC_PERFMON_COUNTER_INT_TO_UC_EN__SHIFT                       0x2
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__HDA_PERFMON_COUNTER_INT_TO_UC_EN__SHIFT                        0x3
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__MPC_PERFMON_COUNTER_INT_TO_UC_EN_MASK                          0x00000001L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__OPP_PERFMON_COUNTER_INT_TO_UC_EN_MASK                          0x00000002L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__OPTC_PERFMON_COUNTER_INT_TO_UC_EN_MASK                         0x00000004L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__HDA_PERFMON_COUNTER_INT_TO_UC_EN_MASK                          0x00000008L
//DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DMU_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL__SHIFT               0x0
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DIO_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL__SHIFT               0x1
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCCG_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL__SHIFT              0x2
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DMU_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL_MASK                 0x00000001L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DIO_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL_MASK                 0x00000002L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCCG_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL_MASK                0x00000004L
//DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__HUBP0_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL__SHIFT             0x0
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__HUBP1_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL__SHIFT             0x1
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__HUBP2_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL__SHIFT             0x2
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__HUBP3_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL__SHIFT             0x3
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__HUBP4_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL__SHIFT             0x4
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__HUBP5_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL__SHIFT             0x5
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__HUBP6_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL__SHIFT             0x6
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__HUBP7_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL__SHIFT             0x7
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__HUBBUB_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL__SHIFT            0x8
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__HUBP0_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL_MASK               0x00000001L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__HUBP1_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL_MASK               0x00000002L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__HUBP2_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL_MASK               0x00000004L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__HUBP3_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL_MASK               0x00000008L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__HUBP4_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL_MASK               0x00000010L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__HUBP5_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL_MASK               0x00000020L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__HUBP6_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL_MASK               0x00000040L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__HUBP7_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL_MASK               0x00000080L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__HUBBUB_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL_MASK              0x00000100L
//DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DPP0_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL__SHIFT              0x0
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DPP1_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL__SHIFT              0x1
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DPP2_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL__SHIFT              0x2
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DPP3_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL__SHIFT              0x3
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DPP4_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL__SHIFT              0x4
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DPP5_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL__SHIFT              0x5
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DPP6_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL__SHIFT              0x6
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DPP7_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL__SHIFT              0x7
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DPP0_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL_MASK                0x00000001L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DPP1_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL_MASK                0x00000002L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DPP2_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL_MASK                0x00000004L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DPP3_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL_MASK                0x00000008L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DPP4_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL_MASK                0x00000010L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DPP5_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL_MASK                0x00000020L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DPP6_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL_MASK                0x00000040L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DPP7_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL_MASK                0x00000080L
//DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__WB0_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL__SHIFT               0x0
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__WB1_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL__SHIFT               0x1
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCCG_PERFMON2_COUNTER_INT_XIRQ_IRQ_SEL__SHIFT             0x2
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__MMHUBBUB_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL__SHIFT          0x3
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__WB0_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL_MASK                 0x00000001L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__WB1_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL_MASK                 0x00000002L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCCG_PERFMON2_COUNTER_INT_XIRQ_IRQ_SEL_MASK               0x00000004L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__MMHUBBUB_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL_MASK            0x00000008L
//DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__MPC_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL__SHIFT               0x0
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__OPTC_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL__SHIFT              0x1
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__OPP_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL__SHIFT               0x2
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__HDA_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL__SHIFT               0x3
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__MPC_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL_MASK                 0x00000001L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__OPTC_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL_MASK                0x00000002L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__OPP_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL_MASK                 0x00000004L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__HDA_PERFMON_COUNTER_INT_XIRQ_IRQ_SEL_MASK                 0x00000008L
//DMCU_DPRX_INTERRUPT_STATUS1
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_MSA_RECEIVED_INT_OCCURRED__SHIFT                              0x0
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_MSA_RECEIVED_INT_CLEAR__SHIFT                                 0x0
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_VBID_VID_STREAM_STATUS_TOGGLED_INT_OCCURRED__SHIFT            0x1
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_VBID_VID_STREAM_STATUS_TOGGLED_INT_CLEAR__SHIFT               0x1
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_VERTICAL_INT0_OCCURRED__SHIFT                                 0x2
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_VERTICAL_INT0_CLEAR__SHIFT                                    0x2
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_VERTICAL_INT1_OCCURRED__SHIFT                                 0x3
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_VERTICAL_INT1_CLEAR__SHIFT                                    0x3
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_SDP_RECEIVED_INT_OCCURRED__SHIFT                              0x4
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_SDP_RECEIVED_INT_CLEAR__SHIFT                                 0x4
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_MSA_RECEIVED_INT_OCCURRED__SHIFT                              0x5
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_MSA_RECEIVED_INT_CLEAR__SHIFT                                 0x5
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_VBID_VID_STREAM_STATUS_TOGGLED_INT_OCCURRED__SHIFT            0x6
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_VBID_VID_STREAM_STATUS_TOGGLED_INT_CLEAR__SHIFT               0x6
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_VERTICAL_INT0_OCCURRED__SHIFT                                 0x7
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_VERTICAL_INT0_CLEAR__SHIFT                                    0x7
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_VERTICAL_INT1_OCCURRED__SHIFT                                 0x8
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_VERTICAL_INT1_CLEAR__SHIFT                                    0x8
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_SDP_RECEIVED_INT_OCCURRED__SHIFT                              0x9
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_SDP_RECEIVED_INT_CLEAR__SHIFT                                 0x9
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_BS_INTERVAL_ERROR_THRESH_EXCEEDED_INT_OCCURRED__SHIFT       0xa
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_BS_INTERVAL_ERROR_THRESH_EXCEEDED_INT_CLEAR__SHIFT          0xa
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_SR_INTERVAL_ERROR_THRESH_EXCEEDED_INT_OCCURRED__SHIFT       0xb
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_SR_INTERVAL_ERROR_THRESH_EXCEEDED_INT_CLEAR__SHIFT          0xb
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_SYMBOL_ERROR_THRESH_EXCEEDED_INT_OCCURRED__SHIFT            0xc
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_SYMBOL_ERROR_THRESH_EXCEEDED_INT_CLEAR__SHIFT               0xc
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_DISPARITY_ERROR_THRESH_EXCEEDED_INT_OCCURRED__SHIFT         0xd
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_DISPARITY_ERROR_THRESH_EXCEEDED_INT_CLEAR__SHIFT            0xd
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_TRAINING_ERROR_THRESH_EXCEEDED_INT_OCCURRED__SHIFT          0xe
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_TRAINING_ERROR_THRESH_EXCEEDED_INT_CLEAR__SHIFT             0xe
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_TEST_PATTERN_ERROR_THRESH_EXCEEDED_INT_OCCURRED__SHIFT      0xf
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_TEST_PATTERN_ERROR_THRESH_EXCEEDED_INT_CLEAR__SHIFT         0xf
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_ECF_ERROR_THRESH_EXCEEDED_INT_OCCURRED__SHIFT               0x10
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_ECF_ERROR_THRESH_EXCEEDED_INT_CLEAR__SHIFT                  0x10
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_DETECT_SR_LOCK_INT_OCCURRED__SHIFT                          0x11
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_DETECT_SR_LOCK_INT_CLEAR__SHIFT                             0x11
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_LOSS_OF_ALIGN_INT_OCCURRED__SHIFT                           0x12
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_LOSS_OF_ALIGN_INT_CLEAR__SHIFT                              0x12
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_LOSS_OF_DESKEW_INT_OCCURRED__SHIFT                          0x13
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_LOSS_OF_DESKEW_INT_CLEAR__SHIFT                             0x13
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_EXCESSIVE_ERROR_INT_OCCURRED__SHIFT                         0x14
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_EXCESSIVE_ERROR_INT_CLEAR__SHIFT                            0x14
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_DESKEW_FIFO_OVERFLOW_INT_OCCURRED__SHIFT                    0x15
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_DESKEW_FIFO_OVERFLOW_INT_CLEAR__SHIFT                       0x15
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_AUX_INT_OCCURRED__SHIFT                                      0x16
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_AUX_INT_CLEAR__SHIFT                                         0x16
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_I2C_INT_OCCURRED__SHIFT                                      0x17
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_I2C_INT_CLEAR__SHIFT                                         0x17
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_CPU_INT_OCCURRED__SHIFT                                      0x18
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_CPU_INT_CLEAR__SHIFT                                         0x18
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_MSG1_TIMEOUT_INT_OCCURRED__SHIFT                             0x19
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_MSG1_TIMEOUT_INT_CLEAR__SHIFT                                0x19
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_MSG2_TIMEOUT_INT_OCCURRED__SHIFT                             0x1a
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_MSG2_TIMEOUT_INT_CLEAR__SHIFT                                0x1a
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_MSG3_TIMEOUT_INT_OCCURRED__SHIFT                             0x1b
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_MSG3_TIMEOUT_INT_CLEAR__SHIFT                                0x1b
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_MSG4_TIMEOUT_INT_OCCURRED__SHIFT                             0x1c
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_MSG4_TIMEOUT_INT_CLEAR__SHIFT                                0x1c
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_MSA_RECEIVED_INT_OCCURRED_MASK                                0x00000001L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_MSA_RECEIVED_INT_CLEAR_MASK                                   0x00000001L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_VBID_VID_STREAM_STATUS_TOGGLED_INT_OCCURRED_MASK              0x00000002L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_VBID_VID_STREAM_STATUS_TOGGLED_INT_CLEAR_MASK                 0x00000002L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_VERTICAL_INT0_OCCURRED_MASK                                   0x00000004L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_VERTICAL_INT0_CLEAR_MASK                                      0x00000004L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_VERTICAL_INT1_OCCURRED_MASK                                   0x00000008L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_VERTICAL_INT1_CLEAR_MASK                                      0x00000008L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_SDP_RECEIVED_INT_OCCURRED_MASK                                0x00000010L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_SDP_RECEIVED_INT_CLEAR_MASK                                   0x00000010L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_MSA_RECEIVED_INT_OCCURRED_MASK                                0x00000020L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_MSA_RECEIVED_INT_CLEAR_MASK                                   0x00000020L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_VBID_VID_STREAM_STATUS_TOGGLED_INT_OCCURRED_MASK              0x00000040L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_VBID_VID_STREAM_STATUS_TOGGLED_INT_CLEAR_MASK                 0x00000040L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_VERTICAL_INT0_OCCURRED_MASK                                   0x00000080L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_VERTICAL_INT0_CLEAR_MASK                                      0x00000080L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_VERTICAL_INT1_OCCURRED_MASK                                   0x00000100L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_VERTICAL_INT1_CLEAR_MASK                                      0x00000100L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_SDP_RECEIVED_INT_OCCURRED_MASK                                0x00000200L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_SDP_RECEIVED_INT_CLEAR_MASK                                   0x00000200L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_BS_INTERVAL_ERROR_THRESH_EXCEEDED_INT_OCCURRED_MASK         0x00000400L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_BS_INTERVAL_ERROR_THRESH_EXCEEDED_INT_CLEAR_MASK            0x00000400L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_SR_INTERVAL_ERROR_THRESH_EXCEEDED_INT_OCCURRED_MASK         0x00000800L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_SR_INTERVAL_ERROR_THRESH_EXCEEDED_INT_CLEAR_MASK            0x00000800L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_SYMBOL_ERROR_THRESH_EXCEEDED_INT_OCCURRED_MASK              0x00001000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_SYMBOL_ERROR_THRESH_EXCEEDED_INT_CLEAR_MASK                 0x00001000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_DISPARITY_ERROR_THRESH_EXCEEDED_INT_OCCURRED_MASK           0x00002000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_DISPARITY_ERROR_THRESH_EXCEEDED_INT_CLEAR_MASK              0x00002000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_TRAINING_ERROR_THRESH_EXCEEDED_INT_OCCURRED_MASK            0x00004000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_TRAINING_ERROR_THRESH_EXCEEDED_INT_CLEAR_MASK               0x00004000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_TEST_PATTERN_ERROR_THRESH_EXCEEDED_INT_OCCURRED_MASK        0x00008000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_TEST_PATTERN_ERROR_THRESH_EXCEEDED_INT_CLEAR_MASK           0x00008000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_ECF_ERROR_THRESH_EXCEEDED_INT_OCCURRED_MASK                 0x00010000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_ECF_ERROR_THRESH_EXCEEDED_INT_CLEAR_MASK                    0x00010000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_DETECT_SR_LOCK_INT_OCCURRED_MASK                            0x00020000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_DETECT_SR_LOCK_INT_CLEAR_MASK                               0x00020000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_LOSS_OF_ALIGN_INT_OCCURRED_MASK                             0x00040000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_LOSS_OF_ALIGN_INT_CLEAR_MASK                                0x00040000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_LOSS_OF_DESKEW_INT_OCCURRED_MASK                            0x00080000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_LOSS_OF_DESKEW_INT_CLEAR_MASK                               0x00080000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_EXCESSIVE_ERROR_INT_OCCURRED_MASK                           0x00100000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_EXCESSIVE_ERROR_INT_CLEAR_MASK                              0x00100000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_DESKEW_FIFO_OVERFLOW_INT_OCCURRED_MASK                      0x00200000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_DESKEW_FIFO_OVERFLOW_INT_CLEAR_MASK                         0x00200000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_AUX_INT_OCCURRED_MASK                                        0x00400000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_AUX_INT_CLEAR_MASK                                           0x00400000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_I2C_INT_OCCURRED_MASK                                        0x00800000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_I2C_INT_CLEAR_MASK                                           0x00800000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_CPU_INT_OCCURRED_MASK                                        0x01000000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_CPU_INT_CLEAR_MASK                                           0x01000000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_MSG1_TIMEOUT_INT_OCCURRED_MASK                               0x02000000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_MSG1_TIMEOUT_INT_CLEAR_MASK                                  0x02000000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_MSG2_TIMEOUT_INT_OCCURRED_MASK                               0x04000000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_MSG2_TIMEOUT_INT_CLEAR_MASK                                  0x04000000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_MSG3_TIMEOUT_INT_OCCURRED_MASK                               0x08000000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_MSG3_TIMEOUT_INT_CLEAR_MASK                                  0x08000000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_MSG4_TIMEOUT_INT_OCCURRED_MASK                               0x10000000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_MSG4_TIMEOUT_INT_CLEAR_MASK                                  0x10000000L
//DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD0P0_MSA_RECEIVED_INT_TO_UC_EN__SHIFT                       0x0
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD0P0_VBID_VID_STREAM_STATUS_TOGGLED_INT_TO_UC_EN__SHIFT     0x1
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD0P0_VERTICAL_INT0_TO_UC_EN__SHIFT                          0x2
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD0P0_VERTICAL_INT1_TO_UC_EN__SHIFT                          0x3
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD0P0_SDP_RECEIVED_INT_TO_UC_EN__SHIFT                       0x4
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD1P0_MSA_RECEIVED_INT_TO_UC_EN__SHIFT                       0x5
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD1P0_VBID_VID_STREAM_STATUS_TOGGLED_INT_TO_UC_EN__SHIFT     0x6
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD1P0_VERTICAL_INT0_TO_UC_EN__SHIFT                          0x7
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD1P0_VERTICAL_INT1_TO_UC_EN__SHIFT                          0x8
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD1P0_SDP_RECEIVED_INT_TO_UC_EN__SHIFT                       0x9
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_BS_INTERVAL_ERROR_THRESH_EXCEEDED_INT_TO_UC_EN__SHIFT  0xa
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_SR_INTERVAL_ERROR_THRESH_EXCEEDED_INT_TO_UC_EN__SHIFT  0xb
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_SYMBOL_ERROR_THRESH_EXCEEDED_INT_TO_UC_EN__SHIFT     0xc
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_DISPARITY_ERROR_THRESH_EXCEEDED_INT_TO_UC_EN__SHIFT  0xd
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_TRAINING_ERROR_THRESH_EXCEEDED_INT_TO_UC_EN__SHIFT   0xe
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_TEST_PATTERN_ERROR_THRESH_EXCEEDED_INT_TO_UC_EN__SHIFT  0xf
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_ECF_ERROR_THRESH_EXCEEDED_INT_TO_UC_EN__SHIFT        0x10
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_DETECT_SR_LOCK_INT_TO_UC_EN__SHIFT                   0x11
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_LOSS_OF_ALIGN_INT_TO_UC_EN__SHIFT                    0x12
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_LOSS_OF_DESKEW_INT_TO_UC_EN__SHIFT                   0x13
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_EXCESSIVE_ERROR_INT_TO_UC_EN__SHIFT                  0x14
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_DESKEW_FIFO_OVERFLOW_INT_TO_UC_EN__SHIFT             0x15
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_AUX_P0_AUX_INT_TO_UC_EN__SHIFT                               0x16
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_AUX_P0_I2C_INT_TO_UC_EN__SHIFT                               0x17
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_AUX_P0_CPU_INT_TO_UC_EN__SHIFT                               0x18
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_AUX_P0_MSG1_TIMEOUT_INT_TO_UC_EN__SHIFT                      0x19
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_AUX_P0_MSG2_TIMEOUT_INT_TO_UC_EN__SHIFT                      0x1a
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_AUX_P0_MSG3_TIMEOUT_INT_TO_UC_EN__SHIFT                      0x1b
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_AUX_P0_MSG4_TIMEOUT_INT_TO_UC_EN__SHIFT                      0x1c
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD0P0_MSA_RECEIVED_INT_TO_UC_EN_MASK                         0x00000001L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD0P0_VBID_VID_STREAM_STATUS_TOGGLED_INT_TO_UC_EN_MASK       0x00000002L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD0P0_VERTICAL_INT0_TO_UC_EN_MASK                            0x00000004L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD0P0_VERTICAL_INT1_TO_UC_EN_MASK                            0x00000008L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD0P0_SDP_RECEIVED_INT_TO_UC_EN_MASK                         0x00000010L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD1P0_MSA_RECEIVED_INT_TO_UC_EN_MASK                         0x00000020L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD1P0_VBID_VID_STREAM_STATUS_TOGGLED_INT_TO_UC_EN_MASK       0x00000040L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD1P0_VERTICAL_INT0_TO_UC_EN_MASK                            0x00000080L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD1P0_VERTICAL_INT1_TO_UC_EN_MASK                            0x00000100L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD1P0_SDP_RECEIVED_INT_TO_UC_EN_MASK                         0x00000200L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_BS_INTERVAL_ERROR_THRESH_EXCEEDED_INT_TO_UC_EN_MASK  0x00000400L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_SR_INTERVAL_ERROR_THRESH_EXCEEDED_INT_TO_UC_EN_MASK  0x00000800L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_SYMBOL_ERROR_THRESH_EXCEEDED_INT_TO_UC_EN_MASK       0x00001000L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_DISPARITY_ERROR_THRESH_EXCEEDED_INT_TO_UC_EN_MASK    0x00002000L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_TRAINING_ERROR_THRESH_EXCEEDED_INT_TO_UC_EN_MASK     0x00004000L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_TEST_PATTERN_ERROR_THRESH_EXCEEDED_INT_TO_UC_EN_MASK  0x00008000L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_ECF_ERROR_THRESH_EXCEEDED_INT_TO_UC_EN_MASK          0x00010000L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_DETECT_SR_LOCK_INT_TO_UC_EN_MASK                     0x00020000L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_LOSS_OF_ALIGN_INT_TO_UC_EN_MASK                      0x00040000L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_LOSS_OF_DESKEW_INT_TO_UC_EN_MASK                     0x00080000L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_EXCESSIVE_ERROR_INT_TO_UC_EN_MASK                    0x00100000L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_DESKEW_FIFO_OVERFLOW_INT_TO_UC_EN_MASK               0x00200000L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_AUX_P0_AUX_INT_TO_UC_EN_MASK                                 0x00400000L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_AUX_P0_I2C_INT_TO_UC_EN_MASK                                 0x00800000L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_AUX_P0_CPU_INT_TO_UC_EN_MASK                                 0x01000000L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_AUX_P0_MSG1_TIMEOUT_INT_TO_UC_EN_MASK                        0x02000000L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_AUX_P0_MSG2_TIMEOUT_INT_TO_UC_EN_MASK                        0x04000000L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_AUX_P0_MSG3_TIMEOUT_INT_TO_UC_EN_MASK                        0x08000000L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_AUX_P0_MSG4_TIMEOUT_INT_TO_UC_EN_MASK                        0x10000000L
//DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD0P0_MSA_RECEIVED_INT_XIRQ_IRQ_SEL__SHIFT              0x0
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD0P0_VBID_VID_STREAM_STATUS_TOGGLED_INT_XIRQ_IRQ_SEL__SHIFT  0x1
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD0P0_VERTICAL_INT0_XIRQ_IRQ_SEL__SHIFT                 0x2
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD0P0_VERTICAL_INT1_XIRQ_IRQ_SEL__SHIFT                 0x3
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD0P0_SDP_RECEIVED_INT_XIRQ_IRQ_SEL__SHIFT              0x4
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD1P0_MSA_RECEIVED_INT_XIRQ_IRQ_SEL__SHIFT              0x5
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD1P0_VBID_VID_STREAM_STATUS_TOGGLED_INT_XIRQ_IRQ_SEL__SHIFT  0x6
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD1P0_VERTICAL_INT0_XIRQ_IRQ_SEL__SHIFT                 0x7
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD1P0_VERTICAL_INT1_XIRQ_IRQ_SEL__SHIFT                 0x8
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD1P0_SDP_RECEIVED_INT_XIRQ_IRQ_SEL__SHIFT              0x9
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_BS_INTERVAL_ERROR_THRESH_EXCEEDED_INT_XIRQ_IRQ_SEL__SHIFT  0xa
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_SR_INTERVAL_ERROR_THRESH_EXCEEDED_INT_XIRQ_IRQ_SEL__SHIFT  0xb
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_SYMBOL_ERROR_THRESH_EXCEEDED_INT_XIRQ_IRQ_SEL__SHIFT  0xc
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_DISPARITY_ERROR_THRESH_EXCEEDED_INT_XIRQ_IRQ_SEL__SHIFT  0xd
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_TRAINING_ERROR_THRESH_EXCEEDED_INT_XIRQ_IRQ_SEL__SHIFT  0xe
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_TEST_PATTERN_ERROR_THRESH_EXCEEDED_INT_XIRQ_IRQ_SEL__SHIFT  0xf
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_ECF_ERROR_THRESH_EXCEEDED_INT_XIRQ_IRQ_SEL__SHIFT  0x10
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_DETECT_SR_LOCK_INT_XIRQ_IRQ_SEL__SHIFT          0x11
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_LOSS_OF_ALIGN_INT_XIRQ_IRQ_SEL__SHIFT           0x12
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_LOSS_OF_DESKEW_INT_XIRQ_IRQ_SEL__SHIFT          0x13
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_EXCESSIVE_ERROR_INT_XIRQ_IRQ_SEL__SHIFT         0x14
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_DESKEW_FIFO_OVERFLOW_INT_XIRQ_IRQ_SEL__SHIFT    0x15
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_AUX_P0_AUX_INT_XIRQ_IRQ_SEL__SHIFT                      0x16
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_AUX_P0_I2C_INT_XIRQ_IRQ_SEL__SHIFT                      0x17
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_AUX_P0_CPU_INT_XIRQ_IRQ_SEL__SHIFT                      0x18
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_AUX_P0_MSG1_TIMEOUT_INT_XIRQ_IRQ_SEL__SHIFT             0x19
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_AUX_P0_MSG2_TIMEOUT_INT_XIRQ_IRQ_SEL__SHIFT             0x1a
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_AUX_P0_MSG3_TIMEOUT_INT_XIRQ_IRQ_SEL__SHIFT             0x1b
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_AUX_P0_MSG4_TIMEOUT_INT_XIRQ_IRQ_SEL__SHIFT             0x1c
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD0P0_MSA_RECEIVED_INT_XIRQ_IRQ_SEL_MASK                0x00000001L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD0P0_VBID_VID_STREAM_STATUS_TOGGLED_INT_XIRQ_IRQ_SEL_MASK  0x00000002L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD0P0_VERTICAL_INT0_XIRQ_IRQ_SEL_MASK                   0x00000004L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD0P0_VERTICAL_INT1_XIRQ_IRQ_SEL_MASK                   0x00000008L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD0P0_SDP_RECEIVED_INT_XIRQ_IRQ_SEL_MASK                0x00000010L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD1P0_MSA_RECEIVED_INT_XIRQ_IRQ_SEL_MASK                0x00000020L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD1P0_VBID_VID_STREAM_STATUS_TOGGLED_INT_XIRQ_IRQ_SEL_MASK  0x00000040L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD1P0_VERTICAL_INT0_XIRQ_IRQ_SEL_MASK                   0x00000080L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD1P0_VERTICAL_INT1_XIRQ_IRQ_SEL_MASK                   0x00000100L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD1P0_SDP_RECEIVED_INT_XIRQ_IRQ_SEL_MASK                0x00000200L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_BS_INTERVAL_ERROR_THRESH_EXCEEDED_INT_XIRQ_IRQ_SEL_MASK  0x00000400L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_SR_INTERVAL_ERROR_THRESH_EXCEEDED_INT_XIRQ_IRQ_SEL_MASK  0x00000800L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_SYMBOL_ERROR_THRESH_EXCEEDED_INT_XIRQ_IRQ_SEL_MASK  0x00001000L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_DISPARITY_ERROR_THRESH_EXCEEDED_INT_XIRQ_IRQ_SEL_MASK  0x00002000L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_TRAINING_ERROR_THRESH_EXCEEDED_INT_XIRQ_IRQ_SEL_MASK  0x00004000L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_TEST_PATTERN_ERROR_THRESH_EXCEEDED_INT_XIRQ_IRQ_SEL_MASK  0x00008000L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_ECF_ERROR_THRESH_EXCEEDED_INT_XIRQ_IRQ_SEL_MASK  0x00010000L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_DETECT_SR_LOCK_INT_XIRQ_IRQ_SEL_MASK            0x00020000L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_LOSS_OF_ALIGN_INT_XIRQ_IRQ_SEL_MASK             0x00040000L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_LOSS_OF_DESKEW_INT_XIRQ_IRQ_SEL_MASK            0x00080000L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_EXCESSIVE_ERROR_INT_XIRQ_IRQ_SEL_MASK           0x00100000L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_DESKEW_FIFO_OVERFLOW_INT_XIRQ_IRQ_SEL_MASK      0x00200000L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_AUX_P0_AUX_INT_XIRQ_IRQ_SEL_MASK                        0x00400000L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_AUX_P0_I2C_INT_XIRQ_IRQ_SEL_MASK                        0x00800000L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_AUX_P0_CPU_INT_XIRQ_IRQ_SEL_MASK                        0x01000000L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_AUX_P0_MSG1_TIMEOUT_INT_XIRQ_IRQ_SEL_MASK               0x02000000L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_AUX_P0_MSG2_TIMEOUT_INT_XIRQ_IRQ_SEL_MASK               0x04000000L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_AUX_P0_MSG3_TIMEOUT_INT_XIRQ_IRQ_SEL_MASK               0x08000000L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_AUX_P0_MSG4_TIMEOUT_INT_XIRQ_IRQ_SEL_MASK               0x10000000L
//DMCU_INTERRUPT_STATUS_CONTINUE
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN6_POWER_UP_INT_OCCURRED__SHIFT                         0x0
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN6_POWER_UP_INT_CLEAR__SHIFT                            0x0
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN7_POWER_UP_INT_OCCURRED__SHIFT                         0x1
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN7_POWER_UP_INT_CLEAR__SHIFT                            0x1
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN8_POWER_UP_INT_OCCURRED__SHIFT                         0x2
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN8_POWER_UP_INT_CLEAR__SHIFT                            0x2
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN9_POWER_UP_INT_OCCURRED__SHIFT                         0x3
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN9_POWER_UP_INT_CLEAR__SHIFT                            0x3
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN10_POWER_UP_INT_OCCURRED__SHIFT                        0x4
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN10_POWER_UP_INT_CLEAR__SHIFT                           0x4
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN11_POWER_UP_INT_OCCURRED__SHIFT                        0x5
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN11_POWER_UP_INT_CLEAR__SHIFT                           0x5
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN12_POWER_UP_INT_OCCURRED__SHIFT                        0x6
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN12_POWER_UP_INT_CLEAR__SHIFT                           0x6
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN13_POWER_UP_INT_OCCURRED__SHIFT                        0x7
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN13_POWER_UP_INT_CLEAR__SHIFT                           0x7
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN14_POWER_UP_INT_OCCURRED__SHIFT                        0x8
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN14_POWER_UP_INT_CLEAR__SHIFT                           0x8
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN15_POWER_UP_INT_OCCURRED__SHIFT                        0x9
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN15_POWER_UP_INT_CLEAR__SHIFT                           0x9
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN6_POWER_DOWN_INT_OCCURRED__SHIFT                       0xa
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN6_POWER_DOWN_INT_CLEAR__SHIFT                          0xa
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN7_POWER_DOWN_INT_OCCURRED__SHIFT                       0xb
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN7_POWER_DOWN_INT_CLEAR__SHIFT                          0xb
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN8_POWER_DOWN_INT_OCCURRED__SHIFT                       0xc
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN8_POWER_DOWN_INT_CLEAR__SHIFT                          0xc
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN9_POWER_DOWN_INT_OCCURRED__SHIFT                       0xd
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN9_POWER_DOWN_INT_CLEAR__SHIFT                          0xd
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN10_POWER_DOWN_INT_OCCURRED__SHIFT                      0xe
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN10_POWER_DOWN_INT_CLEAR__SHIFT                         0xe
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN11_POWER_DOWN_INT_OCCURRED__SHIFT                      0xf
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN11_POWER_DOWN_INT_CLEAR__SHIFT                         0xf
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN12_POWER_DOWN_INT_OCCURRED__SHIFT                      0x10
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN12_POWER_DOWN_INT_CLEAR__SHIFT                         0x10
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN13_POWER_DOWN_INT_OCCURRED__SHIFT                      0x11
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN13_POWER_DOWN_INT_CLEAR__SHIFT                         0x11
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN14_POWER_DOWN_INT_OCCURRED__SHIFT                      0x12
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN14_POWER_DOWN_INT_CLEAR__SHIFT                         0x12
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN15_POWER_DOWN_INT_OCCURRED__SHIFT                      0x13
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN15_POWER_DOWN_INT_CLEAR__SHIFT                         0x13
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG0_OCCURRED__SHIFT                          0x14
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG0_CLEAR__SHIFT                             0x14
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG1_OCCURRED__SHIFT                          0x15
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG1_CLEAR__SHIFT                             0x15
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG2_OCCURRED__SHIFT                          0x16
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG2_CLEAR__SHIFT                             0x16
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG3_OCCURRED__SHIFT                          0x17
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG3_CLEAR__SHIFT                             0x17
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG4_OCCURRED__SHIFT                          0x18
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG4_CLEAR__SHIFT                             0x18
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG5_OCCURRED__SHIFT                          0x19
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG5_CLEAR__SHIFT                             0x19
#define DMCU_INTERRUPT_STATUS_CONTINUE__ABM0_HG_READY_INT_OCCURRED__SHIFT                                     0x1a
#define DMCU_INTERRUPT_STATUS_CONTINUE__ABM0_HG_READY_INT_CLEAR__SHIFT                                        0x1a
#define DMCU_INTERRUPT_STATUS_CONTINUE__ABM0_LS_READY_INT_OCCURRED__SHIFT                                     0x1b
#define DMCU_INTERRUPT_STATUS_CONTINUE__ABM0_LS_READY_INT_CLEAR__SHIFT                                        0x1b
#define DMCU_INTERRUPT_STATUS_CONTINUE__ABM0_BL_UPDATE_INT_OCCURRED__SHIFT                                    0x1c
#define DMCU_INTERRUPT_STATUS_CONTINUE__ABM0_BL_UPDATE_INT_CLEAR__SHIFT                                       0x1c
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN6_POWER_UP_INT_OCCURRED_MASK                           0x00000001L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN6_POWER_UP_INT_CLEAR_MASK                              0x00000001L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN7_POWER_UP_INT_OCCURRED_MASK                           0x00000002L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN7_POWER_UP_INT_CLEAR_MASK                              0x00000002L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN8_POWER_UP_INT_OCCURRED_MASK                           0x00000004L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN8_POWER_UP_INT_CLEAR_MASK                              0x00000004L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN9_POWER_UP_INT_OCCURRED_MASK                           0x00000008L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN9_POWER_UP_INT_CLEAR_MASK                              0x00000008L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN10_POWER_UP_INT_OCCURRED_MASK                          0x00000010L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN10_POWER_UP_INT_CLEAR_MASK                             0x00000010L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN11_POWER_UP_INT_OCCURRED_MASK                          0x00000020L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN11_POWER_UP_INT_CLEAR_MASK                             0x00000020L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN12_POWER_UP_INT_OCCURRED_MASK                          0x00000040L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN12_POWER_UP_INT_CLEAR_MASK                             0x00000040L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN13_POWER_UP_INT_OCCURRED_MASK                          0x00000080L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN13_POWER_UP_INT_CLEAR_MASK                             0x00000080L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN14_POWER_UP_INT_OCCURRED_MASK                          0x00000100L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN14_POWER_UP_INT_CLEAR_MASK                             0x00000100L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN15_POWER_UP_INT_OCCURRED_MASK                          0x00000200L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN15_POWER_UP_INT_CLEAR_MASK                             0x00000200L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN6_POWER_DOWN_INT_OCCURRED_MASK                         0x00000400L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN6_POWER_DOWN_INT_CLEAR_MASK                            0x00000400L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN7_POWER_DOWN_INT_OCCURRED_MASK                         0x00000800L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN7_POWER_DOWN_INT_CLEAR_MASK                            0x00000800L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN8_POWER_DOWN_INT_OCCURRED_MASK                         0x00001000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN8_POWER_DOWN_INT_CLEAR_MASK                            0x00001000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN9_POWER_DOWN_INT_OCCURRED_MASK                         0x00002000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN9_POWER_DOWN_INT_CLEAR_MASK                            0x00002000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN10_POWER_DOWN_INT_OCCURRED_MASK                        0x00004000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN10_POWER_DOWN_INT_CLEAR_MASK                           0x00004000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN11_POWER_DOWN_INT_OCCURRED_MASK                        0x00008000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN11_POWER_DOWN_INT_CLEAR_MASK                           0x00008000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN12_POWER_DOWN_INT_OCCURRED_MASK                        0x00010000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN12_POWER_DOWN_INT_CLEAR_MASK                           0x00010000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN13_POWER_DOWN_INT_OCCURRED_MASK                        0x00020000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN13_POWER_DOWN_INT_CLEAR_MASK                           0x00020000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN14_POWER_DOWN_INT_OCCURRED_MASK                        0x00040000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN14_POWER_DOWN_INT_CLEAR_MASK                           0x00040000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN15_POWER_DOWN_INT_OCCURRED_MASK                        0x00080000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCPG_IHC_DOMAIN15_POWER_DOWN_INT_CLEAR_MASK                           0x00080000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG0_OCCURRED_MASK                            0x00100000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG0_CLEAR_MASK                               0x00100000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG1_OCCURRED_MASK                            0x00200000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG1_CLEAR_MASK                               0x00200000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG2_OCCURRED_MASK                            0x00400000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG2_CLEAR_MASK                               0x00400000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG3_OCCURRED_MASK                            0x00800000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG3_CLEAR_MASK                               0x00800000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG4_OCCURRED_MASK                            0x01000000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG4_CLEAR_MASK                               0x01000000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG5_OCCURRED_MASK                            0x02000000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG5_CLEAR_MASK                               0x02000000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__ABM0_HG_READY_INT_OCCURRED_MASK                                       0x04000000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__ABM0_HG_READY_INT_CLEAR_MASK                                          0x04000000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__ABM0_LS_READY_INT_OCCURRED_MASK                                       0x08000000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__ABM0_LS_READY_INT_CLEAR_MASK                                          0x08000000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__ABM0_BL_UPDATE_INT_OCCURRED_MASK                                      0x10000000L
#define DMCU_INTERRUPT_STATUS_CONTINUE__ABM0_BL_UPDATE_INT_CLEAR_MASK                                         0x10000000L
//DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN6_POWER_UP_INT_TO_UC_EN__SHIFT                  0x0
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN7_POWER_UP_INT_TO_UC_EN__SHIFT                  0x1
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN8_POWER_UP_INT_TO_UC_EN__SHIFT                  0x2
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN9_POWER_UP_INT_TO_UC_EN__SHIFT                  0x3
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN10_POWER_UP_INT_TO_UC_EN__SHIFT                 0x4
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN11_POWER_UP_INT_TO_UC_EN__SHIFT                 0x5
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN12_POWER_UP_INT_TO_UC_EN__SHIFT                 0x6
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN13_POWER_UP_INT_TO_UC_EN__SHIFT                 0x7
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN14_POWER_UP_INT_TO_UC_EN__SHIFT                 0x8
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN15_POWER_UP_INT_TO_UC_EN__SHIFT                 0x9
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN6_POWER_DOWN_INT_TO_UC_EN__SHIFT                0xa
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN7_POWER_DOWN_INT_TO_UC_EN__SHIFT                0xb
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN8_POWER_DOWN_INT_TO_UC_EN__SHIFT                0xc
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN9_POWER_DOWN_INT_TO_UC_EN__SHIFT                0xd
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN10_POWER_DOWN_INT_TO_UC_EN__SHIFT               0xe
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN11_POWER_DOWN_INT_TO_UC_EN__SHIFT               0xf
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN12_POWER_DOWN_INT_TO_UC_EN__SHIFT               0x10
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN13_POWER_DOWN_INT_TO_UC_EN__SHIFT               0x11
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN14_POWER_DOWN_INT_TO_UC_EN__SHIFT               0x12
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN15_POWER_DOWN_INT_TO_UC_EN__SHIFT               0x13
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG0_TO_UC_EN__SHIFT                   0x14
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG1_TO_UC_EN__SHIFT                   0x15
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG2_TO_UC_EN__SHIFT                   0x16
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG3_TO_UC_EN__SHIFT                   0x17
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG4_TO_UC_EN__SHIFT                   0x18
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG5_TO_UC_EN__SHIFT                   0x19
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__ABM0_HG_READY_INT_TO_UC_EN__SHIFT                              0x1a
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__ABM0_LS_READY_INT_TO_UC_EN__SHIFT                              0x1b
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__ABM0_BL_UPDATE_INT_TO_UC_EN__SHIFT                             0x1c
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN6_POWER_UP_INT_TO_UC_EN_MASK                    0x00000001L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN7_POWER_UP_INT_TO_UC_EN_MASK                    0x00000002L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN8_POWER_UP_INT_TO_UC_EN_MASK                    0x00000004L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN9_POWER_UP_INT_TO_UC_EN_MASK                    0x00000008L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN10_POWER_UP_INT_TO_UC_EN_MASK                   0x00000010L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN11_POWER_UP_INT_TO_UC_EN_MASK                   0x00000020L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN12_POWER_UP_INT_TO_UC_EN_MASK                   0x00000040L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN13_POWER_UP_INT_TO_UC_EN_MASK                   0x00000080L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN14_POWER_UP_INT_TO_UC_EN_MASK                   0x00000100L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN15_POWER_UP_INT_TO_UC_EN_MASK                   0x00000200L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN6_POWER_DOWN_INT_TO_UC_EN_MASK                  0x00000400L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN7_POWER_DOWN_INT_TO_UC_EN_MASK                  0x00000800L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN8_POWER_DOWN_INT_TO_UC_EN_MASK                  0x00001000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN9_POWER_DOWN_INT_TO_UC_EN_MASK                  0x00002000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN10_POWER_DOWN_INT_TO_UC_EN_MASK                 0x00004000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN11_POWER_DOWN_INT_TO_UC_EN_MASK                 0x00008000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN12_POWER_DOWN_INT_TO_UC_EN_MASK                 0x00010000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN13_POWER_DOWN_INT_TO_UC_EN_MASK                 0x00020000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN14_POWER_DOWN_INT_TO_UC_EN_MASK                 0x00040000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCPG_IHC_DOMAIN15_POWER_DOWN_INT_TO_UC_EN_MASK                 0x00080000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG0_TO_UC_EN_MASK                     0x00100000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG1_TO_UC_EN_MASK                     0x00200000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG2_TO_UC_EN_MASK                     0x00400000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG3_TO_UC_EN_MASK                     0x00800000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG4_TO_UC_EN_MASK                     0x01000000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG5_TO_UC_EN_MASK                     0x02000000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__ABM0_HG_READY_INT_TO_UC_EN_MASK                                0x04000000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__ABM0_LS_READY_INT_TO_UC_EN_MASK                                0x08000000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE__ABM0_BL_UPDATE_INT_TO_UC_EN_MASK                               0x10000000L
//DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN6_POWER_UP_INT_XIRQ_IRQ_SEL__SHIFT         0x0
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN7_POWER_UP_INT_XIRQ_IRQ_SEL__SHIFT         0x1
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN8_POWER_UP_INT_XIRQ_IRQ_SEL__SHIFT         0x2
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN9_POWER_UP_INT_XIRQ_IRQ_SEL__SHIFT         0x3
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN10_POWER_UP_INT_XIRQ_IRQ_SEL__SHIFT        0x4
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN11_POWER_UP_INT_XIRQ_IRQ_SEL__SHIFT        0x5
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN12_POWER_UP_INT_XIRQ_IRQ_SEL__SHIFT        0x6
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN13_POWER_UP_INT_XIRQ_IRQ_SEL__SHIFT        0x7
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN14_POWER_UP_INT_XIRQ_IRQ_SEL__SHIFT        0x8
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN15_POWER_UP_INT_XIRQ_IRQ_SEL__SHIFT        0x9
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN6_POWER_DOWN_INT_XIRQ_IRQ_SEL__SHIFT       0xa
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN7_POWER_DOWN_INT_XIRQ_IRQ_SEL__SHIFT       0xb
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN8_POWER_DOWN_INT_XIRQ_IRQ_SEL__SHIFT       0xc
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN9_POWER_DOWN_INT_XIRQ_IRQ_SEL__SHIFT       0xd
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN10_POWER_DOWN_INT_XIRQ_IRQ_SEL__SHIFT      0xe
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN11_POWER_DOWN_INT_XIRQ_IRQ_SEL__SHIFT      0xf
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN12_POWER_DOWN_INT_XIRQ_IRQ_SEL__SHIFT      0x10
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN13_POWER_DOWN_INT_XIRQ_IRQ_SEL__SHIFT      0x11
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN14_POWER_DOWN_INT_XIRQ_IRQ_SEL__SHIFT      0x12
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN15_POWER_DOWN_INT_XIRQ_IRQ_SEL__SHIFT      0x13
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG0_XIRQ_IRQ_SEL__SHIFT          0x14
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG1_XIRQ_IRQ_SEL__SHIFT          0x15
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG2_XIRQ_IRQ_SEL__SHIFT          0x16
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG3_XIRQ_IRQ_SEL__SHIFT          0x17
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG4_XIRQ_IRQ_SEL__SHIFT          0x18
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG5_XIRQ_IRQ_SEL__SHIFT          0x19
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__ABM0_HG_READY_INT_XIRQ_IRQ_SEL__SHIFT                     0x1a
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__ABM0_LS_READY_INT_XIRQ_IRQ_SEL__SHIFT                     0x1b
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__ABM0_BL_UPDATE_INT_XIRQ_IRQ_SEL__SHIFT                    0x1c
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN6_POWER_UP_INT_XIRQ_IRQ_SEL_MASK           0x00000001L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN7_POWER_UP_INT_XIRQ_IRQ_SEL_MASK           0x00000002L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN8_POWER_UP_INT_XIRQ_IRQ_SEL_MASK           0x00000004L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN9_POWER_UP_INT_XIRQ_IRQ_SEL_MASK           0x00000008L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN10_POWER_UP_INT_XIRQ_IRQ_SEL_MASK          0x00000010L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN11_POWER_UP_INT_XIRQ_IRQ_SEL_MASK          0x00000020L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN12_POWER_UP_INT_XIRQ_IRQ_SEL_MASK          0x00000040L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN13_POWER_UP_INT_XIRQ_IRQ_SEL_MASK          0x00000080L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN14_POWER_UP_INT_XIRQ_IRQ_SEL_MASK          0x00000100L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN15_POWER_UP_INT_XIRQ_IRQ_SEL_MASK          0x00000200L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN6_POWER_DOWN_INT_XIRQ_IRQ_SEL_MASK         0x00000400L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN7_POWER_DOWN_INT_XIRQ_IRQ_SEL_MASK         0x00000800L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN8_POWER_DOWN_INT_XIRQ_IRQ_SEL_MASK         0x00001000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN9_POWER_DOWN_INT_XIRQ_IRQ_SEL_MASK         0x00002000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN10_POWER_DOWN_INT_XIRQ_IRQ_SEL_MASK        0x00004000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN11_POWER_DOWN_INT_XIRQ_IRQ_SEL_MASK        0x00008000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN12_POWER_DOWN_INT_XIRQ_IRQ_SEL_MASK        0x00010000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN13_POWER_DOWN_INT_XIRQ_IRQ_SEL_MASK        0x00020000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN14_POWER_DOWN_INT_XIRQ_IRQ_SEL_MASK        0x00040000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCPG_IHC_DOMAIN15_POWER_DOWN_INT_XIRQ_IRQ_SEL_MASK        0x00080000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG0_XIRQ_IRQ_SEL_MASK            0x00100000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG1_XIRQ_IRQ_SEL_MASK            0x00200000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG2_XIRQ_IRQ_SEL_MASK            0x00400000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG3_XIRQ_IRQ_SEL_MASK            0x00800000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG4_XIRQ_IRQ_SEL_MASK            0x01000000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__DCCG_DMCU_INT_VSYNC_CNT_OTG5_XIRQ_IRQ_SEL_MASK            0x02000000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__ABM0_HG_READY_INT_XIRQ_IRQ_SEL_MASK                       0x04000000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__ABM0_LS_READY_INT_XIRQ_IRQ_SEL_MASK                       0x08000000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE__ABM0_BL_UPDATE_INT_XIRQ_IRQ_SEL_MASK                      0x10000000L
//DMCU_INT_CNT_CONTINUE
#define DMCU_INT_CNT_CONTINUE__DMCU_ABM0_HG_READY_INT_CNT__SHIFT                                              0x0
#define DMCU_INT_CNT_CONTINUE__DMCU_ABM0_LS_READY_INT_CNT__SHIFT                                              0x8
#define DMCU_INT_CNT_CONTINUE__DMCU_ABM0_BL_UPDATE_INT_CNT__SHIFT                                             0x10
#define DMCU_INT_CNT_CONTINUE__DMCU_ABM0_HG_READY_INT_CNT_MASK                                                0x000000FFL
#define DMCU_INT_CNT_CONTINUE__DMCU_ABM0_LS_READY_INT_CNT_MASK                                                0x0000FF00L
#define DMCU_INT_CNT_CONTINUE__DMCU_ABM0_BL_UPDATE_INT_CNT_MASK                                               0x00FF0000L


// addressBlock: dce_dc_dmu_ihc_dispdec
//DC_GPU_TIMER_START_POSITION_V_UPDATE
#define DC_GPU_TIMER_START_POSITION_V_UPDATE__DC_GPU_TIMER_START_POSITION_D1_V_UPDATE__SHIFT                  0x0
#define DC_GPU_TIMER_START_POSITION_V_UPDATE__DC_GPU_TIMER_START_POSITION_D2_V_UPDATE__SHIFT                  0x4
#define DC_GPU_TIMER_START_POSITION_V_UPDATE__DC_GPU_TIMER_START_POSITION_D3_V_UPDATE__SHIFT                  0x8
#define DC_GPU_TIMER_START_POSITION_V_UPDATE__DC_GPU_TIMER_START_POSITION_D4_V_UPDATE__SHIFT                  0xc
#define DC_GPU_TIMER_START_POSITION_V_UPDATE__DC_GPU_TIMER_START_POSITION_D5_V_UPDATE__SHIFT                  0x10
#define DC_GPU_TIMER_START_POSITION_V_UPDATE__DC_GPU_TIMER_START_POSITION_D6_V_UPDATE__SHIFT                  0x14
#define DC_GPU_TIMER_START_POSITION_V_UPDATE__DC_GPU_TIMER_START_POSITION_D1_V_UPDATE_MASK                    0x00000007L
#define DC_GPU_TIMER_START_POSITION_V_UPDATE__DC_GPU_TIMER_START_POSITION_D2_V_UPDATE_MASK                    0x00000070L
#define DC_GPU_TIMER_START_POSITION_V_UPDATE__DC_GPU_TIMER_START_POSITION_D3_V_UPDATE_MASK                    0x00000700L
#define DC_GPU_TIMER_START_POSITION_V_UPDATE__DC_GPU_TIMER_START_POSITION_D4_V_UPDATE_MASK                    0x00007000L
#define DC_GPU_TIMER_START_POSITION_V_UPDATE__DC_GPU_TIMER_START_POSITION_D5_V_UPDATE_MASK                    0x00070000L
#define DC_GPU_TIMER_START_POSITION_V_UPDATE__DC_GPU_TIMER_START_POSITION_D6_V_UPDATE_MASK                    0x00700000L
//DC_GPU_TIMER_START_POSITION_VSTARTUP
#define DC_GPU_TIMER_START_POSITION_VSTARTUP__DC_GPU_TIMER_START_POSITION_D1_VSTARTUP__SHIFT                  0x0
#define DC_GPU_TIMER_START_POSITION_VSTARTUP__DC_GPU_TIMER_START_POSITION_D2_VSTARTUP__SHIFT                  0x4
#define DC_GPU_TIMER_START_POSITION_VSTARTUP__DC_GPU_TIMER_START_POSITION_D3_VSTARTUP__SHIFT                  0x8
#define DC_GPU_TIMER_START_POSITION_VSTARTUP__DC_GPU_TIMER_START_POSITION_D4_VSTARTUP__SHIFT                  0xc
#define DC_GPU_TIMER_START_POSITION_VSTARTUP__DC_GPU_TIMER_START_POSITION_D5_VSTARTUP__SHIFT                  0x10
#define DC_GPU_TIMER_START_POSITION_VSTARTUP__DC_GPU_TIMER_START_POSITION_D6_VSTARTUP__SHIFT                  0x14
#define DC_GPU_TIMER_START_POSITION_VSTARTUP__DC_GPU_TIMER_START_POSITION_D1_VSTARTUP_MASK                    0x00000007L
#define DC_GPU_TIMER_START_POSITION_VSTARTUP__DC_GPU_TIMER_START_POSITION_D2_VSTARTUP_MASK                    0x00000070L
#define DC_GPU_TIMER_START_POSITION_VSTARTUP__DC_GPU_TIMER_START_POSITION_D3_VSTARTUP_MASK                    0x00000700L
#define DC_GPU_TIMER_START_POSITION_VSTARTUP__DC_GPU_TIMER_START_POSITION_D4_VSTARTUP_MASK                    0x00007000L
#define DC_GPU_TIMER_START_POSITION_VSTARTUP__DC_GPU_TIMER_START_POSITION_D5_VSTARTUP_MASK                    0x00070000L
#define DC_GPU_TIMER_START_POSITION_VSTARTUP__DC_GPU_TIMER_START_POSITION_D6_VSTARTUP_MASK                    0x00700000L
//DC_GPU_TIMER_READ
#define DC_GPU_TIMER_READ__DC_GPU_TIMER_READ__SHIFT                                                           0x0
#define DC_GPU_TIMER_READ__DC_GPU_TIMER_READ_MASK                                                             0xFFFFFFFFL
//DC_GPU_TIMER_READ_CNTL
#define DC_GPU_TIMER_READ_CNTL__DC_GPU_TIMER_READ_SELECT__SHIFT                                               0x0
#define DC_GPU_TIMER_READ_CNTL__DC_GPU_TIMER_START_POSITION_D1_VSYNC_NOM__SHIFT                               0x8
#define DC_GPU_TIMER_READ_CNTL__DC_GPU_TIMER_START_POSITION_D2_VSYNC_NOM__SHIFT                               0xb
#define DC_GPU_TIMER_READ_CNTL__DC_GPU_TIMER_START_POSITION_D3_VSYNC_NOM__SHIFT                               0xe
#define DC_GPU_TIMER_READ_CNTL__DC_GPU_TIMER_START_POSITION_D4_VSYNC_NOM__SHIFT                               0x11
#define DC_GPU_TIMER_READ_CNTL__DC_GPU_TIMER_START_POSITION_D5_VSYNC_NOM__SHIFT                               0x14
#define DC_GPU_TIMER_READ_CNTL__DC_GPU_TIMER_START_POSITION_D6_VSYNC_NOM__SHIFT                               0x17
#define DC_GPU_TIMER_READ_CNTL__DC_GPU_TIMER_READ_SELECT_MASK                                                 0x0000007FL
#define DC_GPU_TIMER_READ_CNTL__DC_GPU_TIMER_START_POSITION_D1_VSYNC_NOM_MASK                                 0x00000700L
#define DC_GPU_TIMER_READ_CNTL__DC_GPU_TIMER_START_POSITION_D2_VSYNC_NOM_MASK                                 0x00003800L
#define DC_GPU_TIMER_READ_CNTL__DC_GPU_TIMER_START_POSITION_D3_VSYNC_NOM_MASK                                 0x0001C000L
#define DC_GPU_TIMER_READ_CNTL__DC_GPU_TIMER_START_POSITION_D4_VSYNC_NOM_MASK                                 0x000E0000L
#define DC_GPU_TIMER_READ_CNTL__DC_GPU_TIMER_START_POSITION_D5_VSYNC_NOM_MASK                                 0x00700000L
#define DC_GPU_TIMER_READ_CNTL__DC_GPU_TIMER_START_POSITION_D6_VSYNC_NOM_MASK                                 0x03800000L
//DISP_INTERRUPT_STATUS
#define DISP_INTERRUPT_STATUS__OPTC1_DATA_UNDERFLOW_INTERRUPT__SHIFT                                          0x1
#define DISP_INTERRUPT_STATUS__OTG1_IHC_SNAPSHOT_INTERRUPT__SHIFT                                             0x4
#define DISP_INTERRUPT_STATUS__OTG1_IHC_FORCE_VSYNC_NEXT_LINE_INTERRUPT__SHIFT                                0x5
#define DISP_INTERRUPT_STATUS__OTG1_IHC_FORCE_COUNT_NOW_INTERRUPT__SHIFT                                      0x6
#define DISP_INTERRUPT_STATUS__OTG1_IHC_TRIGA_INTERRUPT__SHIFT                                                0x7
#define DISP_INTERRUPT_STATUS__OTG1_IHC_TRIGB_INTERRUPT__SHIFT                                                0x8
#define DISP_INTERRUPT_STATUS__OTG1_IHC_VSYNC_NOM_INTERRUPT__SHIFT                                            0x9
#define DISP_INTERRUPT_STATUS__OTG1_IHC_SET_V_TOTAL_MIN_EVENT_OCCURED_INT__SHIFT                              0xa
#define DISP_INTERRUPT_STATUS__DIGA_DP_FAST_TRAINING_COMPLETE_INTERRUPT__SHIFT                                0xf
#define DISP_INTERRUPT_STATUS__DIGA_DP_VID_STREAM_DISABLE_INTERRUPT__SHIFT                                    0x10
#define DISP_INTERRUPT_STATUS__DC_HPD1_INTERRUPT__SHIFT                                                       0x11
#define DISP_INTERRUPT_STATUS__DC_HPD1_RX_INTERRUPT__SHIFT                                                    0x12
#define DISP_INTERRUPT_STATUS__AUX1_SW_DONE_INTERRUPT__SHIFT                                                  0x13
#define DISP_INTERRUPT_STATUS__AUX1_LS_DONE_INTERRUPT__SHIFT                                                  0x14
#define DISP_INTERRUPT_STATUS__DACA_AUTODETECT_GENERITE_INTERRUPT__SHIFT                                      0x16
#define DISP_INTERRUPT_STATUS__RBBMIF_IHC_TIMEOUT_INTERRUPT__SHIFT                                            0x17
#define DISP_INTERRUPT_STATUS__DC_I2C_SW_DONE_INTERRUPT__SHIFT                                                0x18
#define DISP_INTERRUPT_STATUS__DMCU_UC_INTERNAL_INT__SHIFT                                                    0x1a
#define DISP_INTERRUPT_STATUS__ABM1_HG_READY_INT__SHIFT                                                       0x1c
#define DISP_INTERRUPT_STATUS__ABM1_LS_READY_INT__SHIFT                                                       0x1d
#define DISP_INTERRUPT_STATUS__ABM1_BL_UPDATE_INT__SHIFT                                                      0x1e
#define DISP_INTERRUPT_STATUS__DISP_INTERRUPT_STATUS_CONTINUE__SHIFT                                          0x1f
#define DISP_INTERRUPT_STATUS__OPTC1_DATA_UNDERFLOW_INTERRUPT_MASK                                            0x00000002L
#define DISP_INTERRUPT_STATUS__OTG1_IHC_SNAPSHOT_INTERRUPT_MASK                                               0x00000010L
#define DISP_INTERRUPT_STATUS__OTG1_IHC_FORCE_VSYNC_NEXT_LINE_INTERRUPT_MASK                                  0x00000020L
#define DISP_INTERRUPT_STATUS__OTG1_IHC_FORCE_COUNT_NOW_INTERRUPT_MASK                                        0x00000040L
#define DISP_INTERRUPT_STATUS__OTG1_IHC_TRIGA_INTERRUPT_MASK                                                  0x00000080L
#define DISP_INTERRUPT_STATUS__OTG1_IHC_TRIGB_INTERRUPT_MASK                                                  0x00000100L
#define DISP_INTERRUPT_STATUS__OTG1_IHC_VSYNC_NOM_INTERRUPT_MASK                                              0x00000200L
#define DISP_INTERRUPT_STATUS__OTG1_IHC_SET_V_TOTAL_MIN_EVENT_OCCURED_INT_MASK                                0x00000400L
#define DISP_INTERRUPT_STATUS__DIGA_DP_FAST_TRAINING_COMPLETE_INTERRUPT_MASK                                  0x00008000L
#define DISP_INTERRUPT_STATUS__DIGA_DP_VID_STREAM_DISABLE_INTERRUPT_MASK                                      0x00010000L
#define DISP_INTERRUPT_STATUS__DC_HPD1_INTERRUPT_MASK                                                         0x00020000L
#define DISP_INTERRUPT_STATUS__DC_HPD1_RX_INTERRUPT_MASK                                                      0x00040000L
#define DISP_INTERRUPT_STATUS__AUX1_SW_DONE_INTERRUPT_MASK                                                    0x00080000L
#define DISP_INTERRUPT_STATUS__AUX1_LS_DONE_INTERRUPT_MASK                                                    0x00100000L
#define DISP_INTERRUPT_STATUS__DACA_AUTODETECT_GENERITE_INTERRUPT_MASK                                        0x00400000L
#define DISP_INTERRUPT_STATUS__RBBMIF_IHC_TIMEOUT_INTERRUPT_MASK                                              0x00800000L
#define DISP_INTERRUPT_STATUS__DC_I2C_SW_DONE_INTERRUPT_MASK                                                  0x01000000L
#define DISP_INTERRUPT_STATUS__DMCU_UC_INTERNAL_INT_MASK                                                      0x04000000L
#define DISP_INTERRUPT_STATUS__ABM1_HG_READY_INT_MASK                                                         0x10000000L
#define DISP_INTERRUPT_STATUS__ABM1_LS_READY_INT_MASK                                                         0x20000000L
#define DISP_INTERRUPT_STATUS__ABM1_BL_UPDATE_INT_MASK                                                        0x40000000L
#define DISP_INTERRUPT_STATUS__DISP_INTERRUPT_STATUS_CONTINUE_MASK                                            0x80000000L
//DISP_INTERRUPT_STATUS_CONTINUE
#define DISP_INTERRUPT_STATUS_CONTINUE__OPTC2_DATA_UNDERFLOW_INTERRUPT__SHIFT                                 0x1
#define DISP_INTERRUPT_STATUS_CONTINUE__OTG2_IHC_SNAPSHOT_INTERRUPT__SHIFT                                    0x4
#define DISP_INTERRUPT_STATUS_CONTINUE__OTG2_IHC_FORCE_VSYNC_NEXT_LINE_INTERRUPT__SHIFT                       0x5
#define DISP_INTERRUPT_STATUS_CONTINUE__OTG2_IHC_FORCE_COUNT_NOW_INTERRUPT__SHIFT                             0x6
#define DISP_INTERRUPT_STATUS_CONTINUE__OTG2_IHC_TRIGA_INTERRUPT__SHIFT                                       0x7
#define DISP_INTERRUPT_STATUS_CONTINUE__OTG2_IHC_TRIGB_INTERRUPT__SHIFT                                       0x8
#define DISP_INTERRUPT_STATUS_CONTINUE__OTG2_IHC_VSYNC_NOM_INTERRUPT__SHIFT                                   0x9
#define DISP_INTERRUPT_STATUS_CONTINUE__OTG2_IHC_SET_V_TOTAL_MIN_EVENT_OCCURED_INT__SHIFT                     0xa
#define DISP_INTERRUPT_STATUS_CONTINUE__DIGB_DP_FAST_TRAINING_COMPLETE_INTERRUPT__SHIFT                       0xf
#define DISP_INTERRUPT_STATUS_CONTINUE__DIGB_DP_VID_STREAM_DISABLE_INTERRUPT__SHIFT                           0x10
#define DISP_INTERRUPT_STATUS_CONTINUE__DC_HPD2_INTERRUPT__SHIFT                                              0x11
#define DISP_INTERRUPT_STATUS_CONTINUE__DC_HPD2_RX_INTERRUPT__SHIFT                                           0x12
#define DISP_INTERRUPT_STATUS_CONTINUE__AUX2_SW_DONE_INTERRUPT__SHIFT                                         0x13
#define DISP_INTERRUPT_STATUS_CONTINUE__AUX2_LS_DONE_INTERRUPT__SHIFT                                         0x14
#define DISP_INTERRUPT_STATUS_CONTINUE__OTG1_IHC_EXT_TIMING_SYNC_LOSS_INTERRUPT__SHIFT                        0x19
#define DISP_INTERRUPT_STATUS_CONTINUE__OTG1_IHC_EXT_TIMING_SYNC_INTERRUPT__SHIFT                             0x1a
#define DISP_INTERRUPT_STATUS_CONTINUE__OTG1_IHC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT__SHIFT                      0x1b
#define DISP_INTERRUPT_STATUS_CONTINUE__OTG1_IHC_VERTICAL_INTERRUPT0__SHIFT                                   0x1c
#define DISP_INTERRUPT_STATUS_CONTINUE__OTG1_IHC_VERTICAL_INTERRUPT1__SHIFT                                   0x1d
#define DISP_INTERRUPT_STATUS_CONTINUE__OTG1_IHC_VERTICAL_INTERRUPT2__SHIFT                                   0x1e
#define DISP_INTERRUPT_STATUS_CONTINUE__DISP_INTERRUPT_STATUS_CONTINUE2__SHIFT                                0x1f
#define DISP_INTERRUPT_STATUS_CONTINUE__OPTC2_DATA_UNDERFLOW_INTERRUPT_MASK                                   0x00000002L
#define DISP_INTERRUPT_STATUS_CONTINUE__OTG2_IHC_SNAPSHOT_INTERRUPT_MASK                                      0x00000010L
#define DISP_INTERRUPT_STATUS_CONTINUE__OTG2_IHC_FORCE_VSYNC_NEXT_LINE_INTERRUPT_MASK                         0x00000020L
#define DISP_INTERRUPT_STATUS_CONTINUE__OTG2_IHC_FORCE_COUNT_NOW_INTERRUPT_MASK                               0x00000040L
#define DISP_INTERRUPT_STATUS_CONTINUE__OTG2_IHC_TRIGA_INTERRUPT_MASK                                         0x00000080L
#define DISP_INTERRUPT_STATUS_CONTINUE__OTG2_IHC_TRIGB_INTERRUPT_MASK                                         0x00000100L
#define DISP_INTERRUPT_STATUS_CONTINUE__OTG2_IHC_VSYNC_NOM_INTERRUPT_MASK                                     0x00000200L
#define DISP_INTERRUPT_STATUS_CONTINUE__OTG2_IHC_SET_V_TOTAL_MIN_EVENT_OCCURED_INT_MASK                       0x00000400L
#define DISP_INTERRUPT_STATUS_CONTINUE__DIGB_DP_FAST_TRAINING_COMPLETE_INTERRUPT_MASK                         0x00008000L
#define DISP_INTERRUPT_STATUS_CONTINUE__DIGB_DP_VID_STREAM_DISABLE_INTERRUPT_MASK                             0x00010000L
#define DISP_INTERRUPT_STATUS_CONTINUE__DC_HPD2_INTERRUPT_MASK                                                0x00020000L
#define DISP_INTERRUPT_STATUS_CONTINUE__DC_HPD2_RX_INTERRUPT_MASK                                             0x00040000L
#define DISP_INTERRUPT_STATUS_CONTINUE__AUX2_SW_DONE_INTERRUPT_MASK                                           0x00080000L
#define DISP_INTERRUPT_STATUS_CONTINUE__AUX2_LS_DONE_INTERRUPT_MASK                                           0x00100000L
#define DISP_INTERRUPT_STATUS_CONTINUE__OTG1_IHC_EXT_TIMING_SYNC_LOSS_INTERRUPT_MASK                          0x02000000L
#define DISP_INTERRUPT_STATUS_CONTINUE__OTG1_IHC_EXT_TIMING_SYNC_INTERRUPT_MASK                               0x04000000L
#define DISP_INTERRUPT_STATUS_CONTINUE__OTG1_IHC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_MASK                        0x08000000L
#define DISP_INTERRUPT_STATUS_CONTINUE__OTG1_IHC_VERTICAL_INTERRUPT0_MASK                                     0x10000000L
#define DISP_INTERRUPT_STATUS_CONTINUE__OTG1_IHC_VERTICAL_INTERRUPT1_MASK                                     0x20000000L
#define DISP_INTERRUPT_STATUS_CONTINUE__OTG1_IHC_VERTICAL_INTERRUPT2_MASK                                     0x40000000L
#define DISP_INTERRUPT_STATUS_CONTINUE__DISP_INTERRUPT_STATUS_CONTINUE2_MASK                                  0x80000000L
//DISP_INTERRUPT_STATUS_CONTINUE2
#define DISP_INTERRUPT_STATUS_CONTINUE2__OPTC3_DATA_UNDERFLOW_INTERRUPT__SHIFT                                0x1
#define DISP_INTERRUPT_STATUS_CONTINUE2__OTG3_IHC_SNAPSHOT_INTERRUPT__SHIFT                                   0x4
#define DISP_INTERRUPT_STATUS_CONTINUE2__OTG3_IHC_FORCE_VSYNC_NEXT_LINE_INTERRUPT__SHIFT                      0x5
#define DISP_INTERRUPT_STATUS_CONTINUE2__OTG3_IHC_FORCE_COUNT_NOW_INTERRUPT__SHIFT                            0x6
#define DISP_INTERRUPT_STATUS_CONTINUE2__OTG3_IHC_TRIGA_INTERRUPT__SHIFT                                      0x7
#define DISP_INTERRUPT_STATUS_CONTINUE2__OTG3_IHC_TRIGB_INTERRUPT__SHIFT                                      0x8
#define DISP_INTERRUPT_STATUS_CONTINUE2__OTG3_IHC_VSYNC_NOM_INTERRUPT__SHIFT                                  0x9
#define DISP_INTERRUPT_STATUS_CONTINUE2__OTG3_IHC_SET_V_TOTAL_MIN_EVENT_OCCURED_INT__SHIFT                    0xa
#define DISP_INTERRUPT_STATUS_CONTINUE2__DIGC_DP_FAST_TRAINING_COMPLETE_INTERRUPT__SHIFT                      0xf
#define DISP_INTERRUPT_STATUS_CONTINUE2__DIGC_DP_VID_STREAM_DISABLE_INTERRUPT__SHIFT                          0x10
#define DISP_INTERRUPT_STATUS_CONTINUE2__DC_HPD3_INTERRUPT__SHIFT                                             0x11
#define DISP_INTERRUPT_STATUS_CONTINUE2__DC_HPD3_RX_INTERRUPT__SHIFT                                          0x12
#define DISP_INTERRUPT_STATUS_CONTINUE2__AUX3_SW_DONE_INTERRUPT__SHIFT                                        0x13
#define DISP_INTERRUPT_STATUS_CONTINUE2__AUX3_LS_DONE_INTERRUPT__SHIFT                                        0x14
#define DISP_INTERRUPT_STATUS_CONTINUE2__OTG2_IHC_EXT_TIMING_SYNC_LOSS_INTERRUPT__SHIFT                       0x19
#define DISP_INTERRUPT_STATUS_CONTINUE2__OTG2_IHC_EXT_TIMING_SYNC_INTERRUPT__SHIFT                            0x1a
#define DISP_INTERRUPT_STATUS_CONTINUE2__OTG2_IHC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT__SHIFT                     0x1b
#define DISP_INTERRUPT_STATUS_CONTINUE2__OTG2_IHC_VERTICAL_INTERRUPT0__SHIFT                                  0x1c
#define DISP_INTERRUPT_STATUS_CONTINUE2__OTG2_IHC_VERTICAL_INTERRUPT1__SHIFT                                  0x1d
#define DISP_INTERRUPT_STATUS_CONTINUE2__OTG2_IHC_VERTICAL_INTERRUPT2__SHIFT                                  0x1e
#define DISP_INTERRUPT_STATUS_CONTINUE2__DISP_INTERRUPT_STATUS_CONTINUE3__SHIFT                               0x1f
#define DISP_INTERRUPT_STATUS_CONTINUE2__OPTC3_DATA_UNDERFLOW_INTERRUPT_MASK                                  0x00000002L
#define DISP_INTERRUPT_STATUS_CONTINUE2__OTG3_IHC_SNAPSHOT_INTERRUPT_MASK                                     0x00000010L
#define DISP_INTERRUPT_STATUS_CONTINUE2__OTG3_IHC_FORCE_VSYNC_NEXT_LINE_INTERRUPT_MASK                        0x00000020L
#define DISP_INTERRUPT_STATUS_CONTINUE2__OTG3_IHC_FORCE_COUNT_NOW_INTERRUPT_MASK                              0x00000040L
#define DISP_INTERRUPT_STATUS_CONTINUE2__OTG3_IHC_TRIGA_INTERRUPT_MASK                                        0x00000080L
#define DISP_INTERRUPT_STATUS_CONTINUE2__OTG3_IHC_TRIGB_INTERRUPT_MASK                                        0x00000100L
#define DISP_INTERRUPT_STATUS_CONTINUE2__OTG3_IHC_VSYNC_NOM_INTERRUPT_MASK                                    0x00000200L
#define DISP_INTERRUPT_STATUS_CONTINUE2__OTG3_IHC_SET_V_TOTAL_MIN_EVENT_OCCURED_INT_MASK                      0x00000400L
#define DISP_INTERRUPT_STATUS_CONTINUE2__DIGC_DP_FAST_TRAINING_COMPLETE_INTERRUPT_MASK                        0x00008000L
#define DISP_INTERRUPT_STATUS_CONTINUE2__DIGC_DP_VID_STREAM_DISABLE_INTERRUPT_MASK                            0x00010000L
#define DISP_INTERRUPT_STATUS_CONTINUE2__DC_HPD3_INTERRUPT_MASK                                               0x00020000L
#define DISP_INTERRUPT_STATUS_CONTINUE2__DC_HPD3_RX_INTERRUPT_MASK                                            0x00040000L
#define DISP_INTERRUPT_STATUS_CONTINUE2__AUX3_SW_DONE_INTERRUPT_MASK                                          0x00080000L
#define DISP_INTERRUPT_STATUS_CONTINUE2__AUX3_LS_DONE_INTERRUPT_MASK                                          0x00100000L
#define DISP_INTERRUPT_STATUS_CONTINUE2__OTG2_IHC_EXT_TIMING_SYNC_LOSS_INTERRUPT_MASK                         0x02000000L
#define DISP_INTERRUPT_STATUS_CONTINUE2__OTG2_IHC_EXT_TIMING_SYNC_INTERRUPT_MASK                              0x04000000L
#define DISP_INTERRUPT_STATUS_CONTINUE2__OTG2_IHC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_MASK                       0x08000000L
#define DISP_INTERRUPT_STATUS_CONTINUE2__OTG2_IHC_VERTICAL_INTERRUPT0_MASK                                    0x10000000L
#define DISP_INTERRUPT_STATUS_CONTINUE2__OTG2_IHC_VERTICAL_INTERRUPT1_MASK                                    0x20000000L
#define DISP_INTERRUPT_STATUS_CONTINUE2__OTG2_IHC_VERTICAL_INTERRUPT2_MASK                                    0x40000000L
#define DISP_INTERRUPT_STATUS_CONTINUE2__DISP_INTERRUPT_STATUS_CONTINUE3_MASK                                 0x80000000L
//DISP_INTERRUPT_STATUS_CONTINUE3
#define DISP_INTERRUPT_STATUS_CONTINUE3__OPTC4_DATA_UNDERFLOW_INTERRUPT__SHIFT                                0x1
#define DISP_INTERRUPT_STATUS_CONTINUE3__OTG4_IHC_SNAPSHOT_INTERRUPT__SHIFT                                   0x4
#define DISP_INTERRUPT_STATUS_CONTINUE3__OTG4_IHC_FORCE_VSYNC_NEXT_LINE_INTERRUPT__SHIFT                      0x5
#define DISP_INTERRUPT_STATUS_CONTINUE3__OTG4_IHC_FORCE_COUNT_NOW_INTERRUPT__SHIFT                            0x6
#define DISP_INTERRUPT_STATUS_CONTINUE3__OTG4_IHC_TRIGA_INTERRUPT__SHIFT                                      0x7
#define DISP_INTERRUPT_STATUS_CONTINUE3__OTG4_IHC_TRIGB_INTERRUPT__SHIFT                                      0x8
#define DISP_INTERRUPT_STATUS_CONTINUE3__OTG4_IHC_VSYNC_NOM_INTERRUPT__SHIFT                                  0x9
#define DISP_INTERRUPT_STATUS_CONTINUE3__OTG4_IHC_SET_V_TOTAL_MIN_EVENT_OCCURED_INT__SHIFT                    0xa
#define DISP_INTERRUPT_STATUS_CONTINUE3__DIGD_DP_FAST_TRAINING_COMPLETE_INTERRUPT__SHIFT                      0xf
#define DISP_INTERRUPT_STATUS_CONTINUE3__DIGD_DP_VID_STREAM_DISABLE_INTERRUPT__SHIFT                          0x10
#define DISP_INTERRUPT_STATUS_CONTINUE3__DC_HPD4_INTERRUPT__SHIFT                                             0x11
#define DISP_INTERRUPT_STATUS_CONTINUE3__DC_HPD4_RX_INTERRUPT__SHIFT                                          0x12
#define DISP_INTERRUPT_STATUS_CONTINUE3__AUX4_SW_DONE_INTERRUPT__SHIFT                                        0x13
#define DISP_INTERRUPT_STATUS_CONTINUE3__AUX4_LS_DONE_INTERRUPT__SHIFT                                        0x14
#define DISP_INTERRUPT_STATUS_CONTINUE3__WBSCL0_HOST_CONFLICT_INTERRUPT__SHIFT                                0x17
#define DISP_INTERRUPT_STATUS_CONTINUE3__WBSCL0_DATA_OVERFLOW_INTERRUPT__SHIFT                                0x18
#define DISP_INTERRUPT_STATUS_CONTINUE3__OTG3_IHC_EXT_TIMING_SYNC_LOSS_INTERRUPT__SHIFT                       0x19
#define DISP_INTERRUPT_STATUS_CONTINUE3__OTG3_IHC_EXT_TIMING_SYNC_INTERRUPT__SHIFT                            0x1a
#define DISP_INTERRUPT_STATUS_CONTINUE3__OTG3_IHC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT__SHIFT                     0x1b
#define DISP_INTERRUPT_STATUS_CONTINUE3__OTG3_IHC_VERTICAL_INTERRUPT0__SHIFT                                  0x1c
#define DISP_INTERRUPT_STATUS_CONTINUE3__OTG3_IHC_VERTICAL_INTERRUPT1__SHIFT                                  0x1d
#define DISP_INTERRUPT_STATUS_CONTINUE3__OTG3_IHC_VERTICAL_INTERRUPT2__SHIFT                                  0x1e
#define DISP_INTERRUPT_STATUS_CONTINUE3__DISP_INTERRUPT_STATUS_CONTINUE4__SHIFT                               0x1f
#define DISP_INTERRUPT_STATUS_CONTINUE3__OPTC4_DATA_UNDERFLOW_INTERRUPT_MASK                                  0x00000002L
#define DISP_INTERRUPT_STATUS_CONTINUE3__OTG4_IHC_SNAPSHOT_INTERRUPT_MASK                                     0x00000010L
#define DISP_INTERRUPT_STATUS_CONTINUE3__OTG4_IHC_FORCE_VSYNC_NEXT_LINE_INTERRUPT_MASK                        0x00000020L
#define DISP_INTERRUPT_STATUS_CONTINUE3__OTG4_IHC_FORCE_COUNT_NOW_INTERRUPT_MASK                              0x00000040L
#define DISP_INTERRUPT_STATUS_CONTINUE3__OTG4_IHC_TRIGA_INTERRUPT_MASK                                        0x00000080L
#define DISP_INTERRUPT_STATUS_CONTINUE3__OTG4_IHC_TRIGB_INTERRUPT_MASK                                        0x00000100L
#define DISP_INTERRUPT_STATUS_CONTINUE3__OTG4_IHC_VSYNC_NOM_INTERRUPT_MASK                                    0x00000200L
#define DISP_INTERRUPT_STATUS_CONTINUE3__OTG4_IHC_SET_V_TOTAL_MIN_EVENT_OCCURED_INT_MASK                      0x00000400L
#define DISP_INTERRUPT_STATUS_CONTINUE3__DIGD_DP_FAST_TRAINING_COMPLETE_INTERRUPT_MASK                        0x00008000L
#define DISP_INTERRUPT_STATUS_CONTINUE3__DIGD_DP_VID_STREAM_DISABLE_INTERRUPT_MASK                            0x00010000L
#define DISP_INTERRUPT_STATUS_CONTINUE3__DC_HPD4_INTERRUPT_MASK                                               0x00020000L
#define DISP_INTERRUPT_STATUS_CONTINUE3__DC_HPD4_RX_INTERRUPT_MASK                                            0x00040000L
#define DISP_INTERRUPT_STATUS_CONTINUE3__AUX4_SW_DONE_INTERRUPT_MASK                                          0x00080000L
#define DISP_INTERRUPT_STATUS_CONTINUE3__AUX4_LS_DONE_INTERRUPT_MASK                                          0x00100000L
#define DISP_INTERRUPT_STATUS_CONTINUE3__WBSCL0_HOST_CONFLICT_INTERRUPT_MASK                                  0x00800000L
#define DISP_INTERRUPT_STATUS_CONTINUE3__WBSCL0_DATA_OVERFLOW_INTERRUPT_MASK                                  0x01000000L
#define DISP_INTERRUPT_STATUS_CONTINUE3__OTG3_IHC_EXT_TIMING_SYNC_LOSS_INTERRUPT_MASK                         0x02000000L
#define DISP_INTERRUPT_STATUS_CONTINUE3__OTG3_IHC_EXT_TIMING_SYNC_INTERRUPT_MASK                              0x04000000L
#define DISP_INTERRUPT_STATUS_CONTINUE3__OTG3_IHC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_MASK                       0x08000000L
#define DISP_INTERRUPT_STATUS_CONTINUE3__OTG3_IHC_VERTICAL_INTERRUPT0_MASK                                    0x10000000L
#define DISP_INTERRUPT_STATUS_CONTINUE3__OTG3_IHC_VERTICAL_INTERRUPT1_MASK                                    0x20000000L
#define DISP_INTERRUPT_STATUS_CONTINUE3__OTG3_IHC_VERTICAL_INTERRUPT2_MASK                                    0x40000000L
#define DISP_INTERRUPT_STATUS_CONTINUE3__DISP_INTERRUPT_STATUS_CONTINUE4_MASK                                 0x80000000L
//DISP_INTERRUPT_STATUS_CONTINUE4
#define DISP_INTERRUPT_STATUS_CONTINUE4__OPTC5_DATA_UNDERFLOW_INTERRUPT__SHIFT                                0x0
#define DISP_INTERRUPT_STATUS_CONTINUE4__OPTC6_DATA_UNDERFLOW_INTERRUPT__SHIFT                                0x1
#define DISP_INTERRUPT_STATUS_CONTINUE4__OTG5_IHC_SNAPSHOT_INTERRUPT__SHIFT                                   0x4
#define DISP_INTERRUPT_STATUS_CONTINUE4__OTG5_IHC_FORCE_VSYNC_NEXT_LINE_INTERRUPT__SHIFT                      0x5
#define DISP_INTERRUPT_STATUS_CONTINUE4__OTG5_IHC_FORCE_COUNT_NOW_INTERRUPT__SHIFT                            0x6
#define DISP_INTERRUPT_STATUS_CONTINUE4__OTG5_IHC_TRIGA_INTERRUPT__SHIFT                                      0x7
#define DISP_INTERRUPT_STATUS_CONTINUE4__OTG5_IHC_TRIGB_INTERRUPT__SHIFT                                      0x8
#define DISP_INTERRUPT_STATUS_CONTINUE4__OTG5_IHC_VSYNC_NOM_INTERRUPT__SHIFT                                  0x9
#define DISP_INTERRUPT_STATUS_CONTINUE4__OTG5_IHC_SET_V_TOTAL_MIN_EVENT_OCCURED_INT__SHIFT                    0xa
#define DISP_INTERRUPT_STATUS_CONTINUE4__DIGE_DP_FAST_TRAINING_COMPLETE_INTERRUPT__SHIFT                      0xf
#define DISP_INTERRUPT_STATUS_CONTINUE4__DIGE_DP_VID_STREAM_DISABLE_INTERRUPT__SHIFT                          0x10
#define DISP_INTERRUPT_STATUS_CONTINUE4__DC_HPD5_INTERRUPT__SHIFT                                             0x11
#define DISP_INTERRUPT_STATUS_CONTINUE4__DC_HPD5_RX_INTERRUPT__SHIFT                                          0x12
#define DISP_INTERRUPT_STATUS_CONTINUE4__AUX5_SW_DONE_INTERRUPT__SHIFT                                        0x13
#define DISP_INTERRUPT_STATUS_CONTINUE4__AUX5_LS_DONE_INTERRUPT__SHIFT                                        0x14
#define DISP_INTERRUPT_STATUS_CONTINUE4__OTG4_IHC_EXT_TIMING_SYNC_LOSS_INTERRUPT__SHIFT                       0x16
#define DISP_INTERRUPT_STATUS_CONTINUE4__OTG4_IHC_EXT_TIMING_SYNC_INTERRUPT__SHIFT                            0x17
#define DISP_INTERRUPT_STATUS_CONTINUE4__OTG4_IHC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT__SHIFT                     0x18
#define DISP_INTERRUPT_STATUS_CONTINUE4__OTG5_IHC_EXT_TIMING_SYNC_LOSS_INTERRUPT__SHIFT                       0x19
#define DISP_INTERRUPT_STATUS_CONTINUE4__OTG5_IHC_EXT_TIMING_SYNC_INTERRUPT__SHIFT                            0x1a
#define DISP_INTERRUPT_STATUS_CONTINUE4__OTG5_IHC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT__SHIFT                     0x1b
#define DISP_INTERRUPT_STATUS_CONTINUE4__OTG4_IHC_VERTICAL_INTERRUPT0__SHIFT                                  0x1c
#define DISP_INTERRUPT_STATUS_CONTINUE4__OTG4_IHC_VERTICAL_INTERRUPT1__SHIFT                                  0x1d
#define DISP_INTERRUPT_STATUS_CONTINUE4__OTG4_IHC_VERTICAL_INTERRUPT2__SHIFT                                  0x1e
#define DISP_INTERRUPT_STATUS_CONTINUE4__DISP_INTERRUPT_STATUS_CONTINUE5__SHIFT                               0x1f
#define DISP_INTERRUPT_STATUS_CONTINUE4__OPTC5_DATA_UNDERFLOW_INTERRUPT_MASK                                  0x00000001L
#define DISP_INTERRUPT_STATUS_CONTINUE4__OPTC6_DATA_UNDERFLOW_INTERRUPT_MASK                                  0x00000002L
#define DISP_INTERRUPT_STATUS_CONTINUE4__OTG5_IHC_SNAPSHOT_INTERRUPT_MASK                                     0x00000010L
#define DISP_INTERRUPT_STATUS_CONTINUE4__OTG5_IHC_FORCE_VSYNC_NEXT_LINE_INTERRUPT_MASK                        0x00000020L
#define DISP_INTERRUPT_STATUS_CONTINUE4__OTG5_IHC_FORCE_COUNT_NOW_INTERRUPT_MASK                              0x00000040L
#define DISP_INTERRUPT_STATUS_CONTINUE4__OTG5_IHC_TRIGA_INTERRUPT_MASK                                        0x00000080L
#define DISP_INTERRUPT_STATUS_CONTINUE4__OTG5_IHC_TRIGB_INTERRUPT_MASK                                        0x00000100L
#define DISP_INTERRUPT_STATUS_CONTINUE4__OTG5_IHC_VSYNC_NOM_INTERRUPT_MASK                                    0x00000200L
#define DISP_INTERRUPT_STATUS_CONTINUE4__OTG5_IHC_SET_V_TOTAL_MIN_EVENT_OCCURED_INT_MASK                      0x00000400L
#define DISP_INTERRUPT_STATUS_CONTINUE4__DIGE_DP_FAST_TRAINING_COMPLETE_INTERRUPT_MASK                        0x00008000L
#define DISP_INTERRUPT_STATUS_CONTINUE4__DIGE_DP_VID_STREAM_DISABLE_INTERRUPT_MASK                            0x00010000L
#define DISP_INTERRUPT_STATUS_CONTINUE4__DC_HPD5_INTERRUPT_MASK                                               0x00020000L
#define DISP_INTERRUPT_STATUS_CONTINUE4__DC_HPD5_RX_INTERRUPT_MASK                                            0x00040000L
#define DISP_INTERRUPT_STATUS_CONTINUE4__AUX5_SW_DONE_INTERRUPT_MASK                                          0x00080000L
#define DISP_INTERRUPT_STATUS_CONTINUE4__AUX5_LS_DONE_INTERRUPT_MASK                                          0x00100000L
#define DISP_INTERRUPT_STATUS_CONTINUE4__OTG4_IHC_EXT_TIMING_SYNC_LOSS_INTERRUPT_MASK                         0x00400000L
#define DISP_INTERRUPT_STATUS_CONTINUE4__OTG4_IHC_EXT_TIMING_SYNC_INTERRUPT_MASK                              0x00800000L
#define DISP_INTERRUPT_STATUS_CONTINUE4__OTG4_IHC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_MASK                       0x01000000L
#define DISP_INTERRUPT_STATUS_CONTINUE4__OTG5_IHC_EXT_TIMING_SYNC_LOSS_INTERRUPT_MASK                         0x02000000L
#define DISP_INTERRUPT_STATUS_CONTINUE4__OTG5_IHC_EXT_TIMING_SYNC_INTERRUPT_MASK                              0x04000000L
#define DISP_INTERRUPT_STATUS_CONTINUE4__OTG5_IHC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_MASK                       0x08000000L
#define DISP_INTERRUPT_STATUS_CONTINUE4__OTG4_IHC_VERTICAL_INTERRUPT0_MASK                                    0x10000000L
#define DISP_INTERRUPT_STATUS_CONTINUE4__OTG4_IHC_VERTICAL_INTERRUPT1_MASK                                    0x20000000L
#define DISP_INTERRUPT_STATUS_CONTINUE4__OTG4_IHC_VERTICAL_INTERRUPT2_MASK                                    0x40000000L
#define DISP_INTERRUPT_STATUS_CONTINUE4__DISP_INTERRUPT_STATUS_CONTINUE5_MASK                                 0x80000000L
//DISP_INTERRUPT_STATUS_CONTINUE5
#define DISP_INTERRUPT_STATUS_CONTINUE5__OTG6_IHC_SNAPSHOT_INTERRUPT__SHIFT                                   0x4
#define DISP_INTERRUPT_STATUS_CONTINUE5__OTG6_IHC_FORCE_VSYNC_NEXT_LINE_INTERRUPT__SHIFT                      0x5
#define DISP_INTERRUPT_STATUS_CONTINUE5__OTG6_IHC_FORCE_COUNT_NOW_INTERRUPT__SHIFT                            0x6
#define DISP_INTERRUPT_STATUS_CONTINUE5__OTG6_IHC_TRIGA_INTERRUPT__SHIFT                                      0x7
#define DISP_INTERRUPT_STATUS_CONTINUE5__OTG6_IHC_TRIGB_INTERRUPT__SHIFT                                      0x8
#define DISP_INTERRUPT_STATUS_CONTINUE5__OTG6_IHC_VSYNC_NOM_INTERRUPT__SHIFT                                  0x9
#define DISP_INTERRUPT_STATUS_CONTINUE5__OTG6_IHC_SET_V_TOTAL_MIN_EVENT_OCCURED_INT__SHIFT                    0xa
#define DISP_INTERRUPT_STATUS_CONTINUE5__DIGF_DP_FAST_TRAINING_COMPLETE_INTERRUPT__SHIFT                      0xf
#define DISP_INTERRUPT_STATUS_CONTINUE5__DIGF_DP_VID_STREAM_DISABLE_INTERRUPT__SHIFT                          0x10
#define DISP_INTERRUPT_STATUS_CONTINUE5__DC_HPD6_INTERRUPT__SHIFT                                             0x11
#define DISP_INTERRUPT_STATUS_CONTINUE5__DC_HPD6_RX_INTERRUPT__SHIFT                                          0x12
#define DISP_INTERRUPT_STATUS_CONTINUE5__AUX6_SW_DONE_INTERRUPT__SHIFT                                        0x13
#define DISP_INTERRUPT_STATUS_CONTINUE5__AUX6_LS_DONE_INTERRUPT__SHIFT                                        0x14
#define DISP_INTERRUPT_STATUS_CONTINUE5__OTG6_IHC_EXT_TIMING_SYNC_LOSS_INTERRUPT__SHIFT                       0x16
#define DISP_INTERRUPT_STATUS_CONTINUE5__OTG6_IHC_EXT_TIMING_SYNC_INTERRUPT__SHIFT                            0x17
#define DISP_INTERRUPT_STATUS_CONTINUE5__OTG6_IHC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT__SHIFT                     0x18
#define DISP_INTERRUPT_STATUS_CONTINUE5__OTG5_IHC_VERTICAL_INTERRUPT0__SHIFT                                  0x19
#define DISP_INTERRUPT_STATUS_CONTINUE5__OTG5_IHC_VERTICAL_INTERRUPT1__SHIFT                                  0x1a
#define DISP_INTERRUPT_STATUS_CONTINUE5__OTG5_IHC_VERTICAL_INTERRUPT2__SHIFT                                  0x1b
#define DISP_INTERRUPT_STATUS_CONTINUE5__OTG6_IHC_VERTICAL_INTERRUPT0__SHIFT                                  0x1c
#define DISP_INTERRUPT_STATUS_CONTINUE5__OTG6_IHC_VERTICAL_INTERRUPT1__SHIFT                                  0x1d
#define DISP_INTERRUPT_STATUS_CONTINUE5__OTG6_IHC_VERTICAL_INTERRUPT2__SHIFT                                  0x1e
#define DISP_INTERRUPT_STATUS_CONTINUE5__DISP_INTERRUPT_STATUS_CONTINUE6__SHIFT                               0x1f
#define DISP_INTERRUPT_STATUS_CONTINUE5__OTG6_IHC_SNAPSHOT_INTERRUPT_MASK                                     0x00000010L
#define DISP_INTERRUPT_STATUS_CONTINUE5__OTG6_IHC_FORCE_VSYNC_NEXT_LINE_INTERRUPT_MASK                        0x00000020L
#define DISP_INTERRUPT_STATUS_CONTINUE5__OTG6_IHC_FORCE_COUNT_NOW_INTERRUPT_MASK                              0x00000040L
#define DISP_INTERRUPT_STATUS_CONTINUE5__OTG6_IHC_TRIGA_INTERRUPT_MASK                                        0x00000080L
#define DISP_INTERRUPT_STATUS_CONTINUE5__OTG6_IHC_TRIGB_INTERRUPT_MASK                                        0x00000100L
#define DISP_INTERRUPT_STATUS_CONTINUE5__OTG6_IHC_VSYNC_NOM_INTERRUPT_MASK                                    0x00000200L
#define DISP_INTERRUPT_STATUS_CONTINUE5__OTG6_IHC_SET_V_TOTAL_MIN_EVENT_OCCURED_INT_MASK                      0x00000400L
#define DISP_INTERRUPT_STATUS_CONTINUE5__DIGF_DP_FAST_TRAINING_COMPLETE_INTERRUPT_MASK                        0x00008000L
#define DISP_INTERRUPT_STATUS_CONTINUE5__DIGF_DP_VID_STREAM_DISABLE_INTERRUPT_MASK                            0x00010000L
#define DISP_INTERRUPT_STATUS_CONTINUE5__DC_HPD6_INTERRUPT_MASK                                               0x00020000L
#define DISP_INTERRUPT_STATUS_CONTINUE5__DC_HPD6_RX_INTERRUPT_MASK                                            0x00040000L
#define DISP_INTERRUPT_STATUS_CONTINUE5__AUX6_SW_DONE_INTERRUPT_MASK                                          0x00080000L
#define DISP_INTERRUPT_STATUS_CONTINUE5__AUX6_LS_DONE_INTERRUPT_MASK                                          0x00100000L
#define DISP_INTERRUPT_STATUS_CONTINUE5__OTG6_IHC_EXT_TIMING_SYNC_LOSS_INTERRUPT_MASK                         0x00400000L
#define DISP_INTERRUPT_STATUS_CONTINUE5__OTG6_IHC_EXT_TIMING_SYNC_INTERRUPT_MASK                              0x00800000L
#define DISP_INTERRUPT_STATUS_CONTINUE5__OTG6_IHC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_MASK                       0x01000000L
#define DISP_INTERRUPT_STATUS_CONTINUE5__OTG5_IHC_VERTICAL_INTERRUPT0_MASK                                    0x02000000L
#define DISP_INTERRUPT_STATUS_CONTINUE5__OTG5_IHC_VERTICAL_INTERRUPT1_MASK                                    0x04000000L
#define DISP_INTERRUPT_STATUS_CONTINUE5__OTG5_IHC_VERTICAL_INTERRUPT2_MASK                                    0x08000000L
#define DISP_INTERRUPT_STATUS_CONTINUE5__OTG6_IHC_VERTICAL_INTERRUPT0_MASK                                    0x10000000L
#define DISP_INTERRUPT_STATUS_CONTINUE5__OTG6_IHC_VERTICAL_INTERRUPT1_MASK                                    0x20000000L
#define DISP_INTERRUPT_STATUS_CONTINUE5__OTG6_IHC_VERTICAL_INTERRUPT2_MASK                                    0x40000000L
#define DISP_INTERRUPT_STATUS_CONTINUE5__DISP_INTERRUPT_STATUS_CONTINUE6_MASK                                 0x80000000L
//DISP_INTERRUPT_STATUS_CONTINUE6
#define DISP_INTERRUPT_STATUS_CONTINUE6__MCIF_CWB0_IHIF_INTERRUPT__SHIFT                                      0x9
#define DISP_INTERRUPT_STATUS_CONTINUE6__MCIF_CWB1_IHIF_INTERRUPT__SHIFT                                      0xa
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX1_GTC_SYNC_LOCK_DONE_INTERRUPT__SHIFT                             0x11
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX1_GTC_SYNC_ERROR_INTERRUPT__SHIFT                                 0x12
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX2_GTC_SYNC_LOCK_DONE_INTERRUPT__SHIFT                             0x13
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX2_GTC_SYNC_ERROR_INTERRUPT__SHIFT                                 0x14
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX3_GTC_SYNC_LOCK_DONE_INTERRUPT__SHIFT                             0x15
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX3_GTC_SYNC_ERROR_INTERRUPT__SHIFT                                 0x16
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX4_GTC_SYNC_LOCK_DONE_INTERRUPT__SHIFT                             0x17
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX4_GTC_SYNC_ERROR_INTERRUPT__SHIFT                                 0x18
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX5_GTC_SYNC_LOCK_DONE_INTERRUPT__SHIFT                             0x19
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX5_GTC_SYNC_ERROR_INTERRUPT__SHIFT                                 0x1a
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX6_GTC_SYNC_LOCK_DONE_INTERRUPT__SHIFT                             0x1b
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX6_GTC_SYNC_ERROR_INTERRUPT__SHIFT                                 0x1c
#define DISP_INTERRUPT_STATUS_CONTINUE6__MCIF_DWB0_IHIF_INTERRUPT__SHIFT                                      0x1d
#define DISP_INTERRUPT_STATUS_CONTINUE6__MCIF_DWB1_IHIF_INTERRUPT__SHIFT                                      0x1e
#define DISP_INTERRUPT_STATUS_CONTINUE6__DISP_INTERRUPT_STATUS_CONTINUE7__SHIFT                               0x1f
#define DISP_INTERRUPT_STATUS_CONTINUE6__MCIF_CWB0_IHIF_INTERRUPT_MASK                                        0x00000200L
#define DISP_INTERRUPT_STATUS_CONTINUE6__MCIF_CWB1_IHIF_INTERRUPT_MASK                                        0x00000400L
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX1_GTC_SYNC_LOCK_DONE_INTERRUPT_MASK                               0x00020000L
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX1_GTC_SYNC_ERROR_INTERRUPT_MASK                                   0x00040000L
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX2_GTC_SYNC_LOCK_DONE_INTERRUPT_MASK                               0x00080000L
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX2_GTC_SYNC_ERROR_INTERRUPT_MASK                                   0x00100000L
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX3_GTC_SYNC_LOCK_DONE_INTERRUPT_MASK                               0x00200000L
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX3_GTC_SYNC_ERROR_INTERRUPT_MASK                                   0x00400000L
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX4_GTC_SYNC_LOCK_DONE_INTERRUPT_MASK                               0x00800000L
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX4_GTC_SYNC_ERROR_INTERRUPT_MASK                                   0x01000000L
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX5_GTC_SYNC_LOCK_DONE_INTERRUPT_MASK                               0x02000000L
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX5_GTC_SYNC_ERROR_INTERRUPT_MASK                                   0x04000000L
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX6_GTC_SYNC_LOCK_DONE_INTERRUPT_MASK                               0x08000000L
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX6_GTC_SYNC_ERROR_INTERRUPT_MASK                                   0x10000000L
#define DISP_INTERRUPT_STATUS_CONTINUE6__MCIF_DWB0_IHIF_INTERRUPT_MASK                                        0x20000000L
#define DISP_INTERRUPT_STATUS_CONTINUE6__MCIF_DWB1_IHIF_INTERRUPT_MASK                                        0x40000000L
#define DISP_INTERRUPT_STATUS_CONTINUE6__DISP_INTERRUPT_STATUS_CONTINUE7_MASK                                 0x80000000L
//DISP_INTERRUPT_STATUS_CONTINUE7
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCCG_PERFMON_COUNTER0_INTERRUPT__SHIFT                               0x0
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCCG_PERFMON_COUNTER1_INTERRUPT__SHIFT                               0x1
#define DISP_INTERRUPT_STATUS_CONTINUE7__DMU_PERFMON_COUNTER0_INTERRUPT__SHIFT                                0x9
#define DISP_INTERRUPT_STATUS_CONTINUE7__DMU_PERFMON_COUNTER1_INTERRUPT__SHIFT                                0xa
#define DISP_INTERRUPT_STATUS_CONTINUE7__DIO_PERFMON_COUNTER0_INTERRUPT__SHIFT                                0x12
#define DISP_INTERRUPT_STATUS_CONTINUE7__DIO_PERFMON_COUNTER1_INTERRUPT__SHIFT                                0x13
#define DISP_INTERRUPT_STATUS_CONTINUE7__WB0_PERFMON_COUNTER0_INTERRUPT__SHIFT                                0x1b
#define DISP_INTERRUPT_STATUS_CONTINUE7__WB0_PERFMON_COUNTER1_INTERRUPT__SHIFT                                0x1c
#define DISP_INTERRUPT_STATUS_CONTINUE7__DISP_INTERRUPT_STATUS_CONTINUE8__SHIFT                               0x1f
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCCG_PERFMON_COUNTER0_INTERRUPT_MASK                                 0x00000001L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCCG_PERFMON_COUNTER1_INTERRUPT_MASK                                 0x00000002L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DMU_PERFMON_COUNTER0_INTERRUPT_MASK                                  0x00000200L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DMU_PERFMON_COUNTER1_INTERRUPT_MASK                                  0x00000400L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DIO_PERFMON_COUNTER0_INTERRUPT_MASK                                  0x00040000L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DIO_PERFMON_COUNTER1_INTERRUPT_MASK                                  0x00080000L
#define DISP_INTERRUPT_STATUS_CONTINUE7__WB0_PERFMON_COUNTER0_INTERRUPT_MASK                                  0x08000000L
#define DISP_INTERRUPT_STATUS_CONTINUE7__WB0_PERFMON_COUNTER1_INTERRUPT_MASK                                  0x10000000L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DISP_INTERRUPT_STATUS_CONTINUE8_MASK                                 0x80000000L
//DISP_INTERRUPT_STATUS_CONTINUE8
#define DISP_INTERRUPT_STATUS_CONTINUE8__DPP0_PERFMON_COUNTER0_INTERRUPT__SHIFT                               0x0
#define DISP_INTERRUPT_STATUS_CONTINUE8__DPP0_PERFMON_COUNTER1_INTERRUPT__SHIFT                               0x1
#define DISP_INTERRUPT_STATUS_CONTINUE8__DPP1_PERFMON_COUNTER0_INTERRUPT__SHIFT                               0x9
#define DISP_INTERRUPT_STATUS_CONTINUE8__DPP1_PERFMON_COUNTER1_INTERRUPT__SHIFT                               0xa
#define DISP_INTERRUPT_STATUS_CONTINUE8__DPP2_PERFMON_COUNTER0_INTERRUPT__SHIFT                               0x12
#define DISP_INTERRUPT_STATUS_CONTINUE8__DPP2_PERFMON_COUNTER1_INTERRUPT__SHIFT                               0x13
#define DISP_INTERRUPT_STATUS_CONTINUE8__DISP_INTERRUPT_STATUS_CONTINUE9__SHIFT                               0x1f
#define DISP_INTERRUPT_STATUS_CONTINUE8__DPP0_PERFMON_COUNTER0_INTERRUPT_MASK                                 0x00000001L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DPP0_PERFMON_COUNTER1_INTERRUPT_MASK                                 0x00000002L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DPP1_PERFMON_COUNTER0_INTERRUPT_MASK                                 0x00000200L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DPP1_PERFMON_COUNTER1_INTERRUPT_MASK                                 0x00000400L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DPP2_PERFMON_COUNTER0_INTERRUPT_MASK                                 0x00040000L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DPP2_PERFMON_COUNTER1_INTERRUPT_MASK                                 0x00080000L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DISP_INTERRUPT_STATUS_CONTINUE9_MASK                                 0x80000000L
//DISP_INTERRUPT_STATUS_CONTINUE9
#define DISP_INTERRUPT_STATUS_CONTINUE9__DPP3_PERFMON_COUNTER0_INTERRUPT__SHIFT                               0x0
#define DISP_INTERRUPT_STATUS_CONTINUE9__DPP3_PERFMON_COUNTER1_INTERRUPT__SHIFT                               0x1
#define DISP_INTERRUPT_STATUS_CONTINUE9__DPP4_PERFMON_COUNTER0_INTERRUPT__SHIFT                               0x9
#define DISP_INTERRUPT_STATUS_CONTINUE9__DPP4_PERFMON_COUNTER1_INTERRUPT__SHIFT                               0xa
#define DISP_INTERRUPT_STATUS_CONTINUE9__DPP5_PERFMON_COUNTER0_INTERRUPT__SHIFT                               0x12
#define DISP_INTERRUPT_STATUS_CONTINUE9__DPP5_PERFMON_COUNTER1_INTERRUPT__SHIFT                               0x13
#define DISP_INTERRUPT_STATUS_CONTINUE9__WBSCL1_HOST_CONFLICT_INTERRUPT__SHIFT                                0x1c
#define DISP_INTERRUPT_STATUS_CONTINUE9__WBSCL1_DATA_OVERFLOW_INTERRUPT__SHIFT                                0x1d
#define DISP_INTERRUPT_STATUS_CONTINUE9__DISP_INTERRUPT_STATUS_CONTINUE10__SHIFT                              0x1f
#define DISP_INTERRUPT_STATUS_CONTINUE9__DPP3_PERFMON_COUNTER0_INTERRUPT_MASK                                 0x00000001L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DPP3_PERFMON_COUNTER1_INTERRUPT_MASK                                 0x00000002L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DPP4_PERFMON_COUNTER0_INTERRUPT_MASK                                 0x00000200L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DPP4_PERFMON_COUNTER1_INTERRUPT_MASK                                 0x00000400L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DPP5_PERFMON_COUNTER0_INTERRUPT_MASK                                 0x00040000L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DPP5_PERFMON_COUNTER1_INTERRUPT_MASK                                 0x00080000L
#define DISP_INTERRUPT_STATUS_CONTINUE9__WBSCL1_HOST_CONFLICT_INTERRUPT_MASK                                  0x10000000L
#define DISP_INTERRUPT_STATUS_CONTINUE9__WBSCL1_DATA_OVERFLOW_INTERRUPT_MASK                                  0x20000000L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DISP_INTERRUPT_STATUS_CONTINUE10_MASK                                0x80000000L
//DISP_INTERRUPT_STATUS_CONTINUE10
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_IHC_VSYNC_OTG0_LATCH_INT__SHIFT                                0x0
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_IHC_VSYNC_OTG1_LATCH_INT__SHIFT                                0x1
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_IHC_VSYNC_OTG2_LATCH_INT__SHIFT                                0x2
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_IHC_VSYNC_OTG3_LATCH_INT__SHIFT                                0x3
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_IHC_VSYNC_OTG4_LATCH_INT__SHIFT                                0x4
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_IHC_VSYNC_OTG5_LATCH_INT__SHIFT                                0x5
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_PERFMON2_COUNTER0_INTERRUPT__SHIFT                             0xc
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_PERFMON2_COUNTER1_INTERRUPT__SHIFT                             0xd
#define DISP_INTERRUPT_STATUS_CONTINUE10__OTG1_IHC_RANGE_TIMING_UPDATE__SHIFT                                 0x16
#define DISP_INTERRUPT_STATUS_CONTINUE10__OTG2_IHC_RANGE_TIMING_UPDATE__SHIFT                                 0x17
#define DISP_INTERRUPT_STATUS_CONTINUE10__OTG3_IHC_RANGE_TIMING_UPDATE__SHIFT                                 0x18
#define DISP_INTERRUPT_STATUS_CONTINUE10__OTG4_IHC_RANGE_TIMING_UPDATE__SHIFT                                 0x19
#define DISP_INTERRUPT_STATUS_CONTINUE10__OTG5_IHC_RANGE_TIMING_UPDATE__SHIFT                                 0x1a
#define DISP_INTERRUPT_STATUS_CONTINUE10__OTG6_IHC_RANGE_TIMING_UPDATE__SHIFT                                 0x1b
#define DISP_INTERRUPT_STATUS_CONTINUE10__DISP_INTERRUPT_STATUS_CONTINUE11__SHIFT                             0x1f
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_IHC_VSYNC_OTG0_LATCH_INT_MASK                                  0x00000001L
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_IHC_VSYNC_OTG1_LATCH_INT_MASK                                  0x00000002L
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_IHC_VSYNC_OTG2_LATCH_INT_MASK                                  0x00000004L
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_IHC_VSYNC_OTG3_LATCH_INT_MASK                                  0x00000008L
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_IHC_VSYNC_OTG4_LATCH_INT_MASK                                  0x00000010L
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_IHC_VSYNC_OTG5_LATCH_INT_MASK                                  0x00000020L
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_PERFMON2_COUNTER0_INTERRUPT_MASK                               0x00001000L
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_PERFMON2_COUNTER1_INTERRUPT_MASK                               0x00002000L
#define DISP_INTERRUPT_STATUS_CONTINUE10__OTG1_IHC_RANGE_TIMING_UPDATE_MASK                                   0x00400000L
#define DISP_INTERRUPT_STATUS_CONTINUE10__OTG2_IHC_RANGE_TIMING_UPDATE_MASK                                   0x00800000L
#define DISP_INTERRUPT_STATUS_CONTINUE10__OTG3_IHC_RANGE_TIMING_UPDATE_MASK                                   0x01000000L
#define DISP_INTERRUPT_STATUS_CONTINUE10__OTG4_IHC_RANGE_TIMING_UPDATE_MASK                                   0x02000000L
#define DISP_INTERRUPT_STATUS_CONTINUE10__OTG5_IHC_RANGE_TIMING_UPDATE_MASK                                   0x04000000L
#define DISP_INTERRUPT_STATUS_CONTINUE10__OTG6_IHC_RANGE_TIMING_UPDATE_MASK                                   0x08000000L
#define DISP_INTERRUPT_STATUS_CONTINUE10__DISP_INTERRUPT_STATUS_CONTINUE11_MASK                               0x80000000L
//DISP_INTERRUPT_STATUS_CONTINUE11
#define DISP_INTERRUPT_STATUS_CONTINUE11__WB1_PERFMON_COUNTER0_INTERRUPT__SHIFT                               0x6
#define DISP_INTERRUPT_STATUS_CONTINUE11__WB1_PERFMON_COUNTER1_INTERRUPT__SHIFT                               0x7
#define DISP_INTERRUPT_STATUS_CONTINUE11__MPCC0_STALL_INTERRUPT__SHIFT                                        0xf
#define DISP_INTERRUPT_STATUS_CONTINUE11__MPCC1_STALL_INTERRUPT__SHIFT                                        0x10
#define DISP_INTERRUPT_STATUS_CONTINUE11__MPCC2_STALL_INTERRUPT__SHIFT                                        0x11
#define DISP_INTERRUPT_STATUS_CONTINUE11__MPCC3_STALL_INTERRUPT__SHIFT                                        0x12
#define DISP_INTERRUPT_STATUS_CONTINUE11__MPCC4_STALL_INTERRUPT__SHIFT                                        0x13
#define DISP_INTERRUPT_STATUS_CONTINUE11__MPCC5_STALL_INTERRUPT__SHIFT                                        0x14
#define DISP_INTERRUPT_STATUS_CONTINUE11__MPCC6_STALL_INTERRUPT__SHIFT                                        0x15
#define DISP_INTERRUPT_STATUS_CONTINUE11__MPCC7_STALL_INTERRUPT__SHIFT                                        0x16
#define DISP_INTERRUPT_STATUS_CONTINUE11__VGA_IHC_VGA_CRT_INTERRUPT__SHIFT                                    0x17
#define DISP_INTERRUPT_STATUS_CONTINUE11__DISP_INTERRUPT_STATUS_CONTINUE12__SHIFT                             0x1f
#define DISP_INTERRUPT_STATUS_CONTINUE11__WB1_PERFMON_COUNTER0_INTERRUPT_MASK                                 0x00000040L
#define DISP_INTERRUPT_STATUS_CONTINUE11__WB1_PERFMON_COUNTER1_INTERRUPT_MASK                                 0x00000080L
#define DISP_INTERRUPT_STATUS_CONTINUE11__MPCC0_STALL_INTERRUPT_MASK                                          0x00008000L
#define DISP_INTERRUPT_STATUS_CONTINUE11__MPCC1_STALL_INTERRUPT_MASK                                          0x00010000L
#define DISP_INTERRUPT_STATUS_CONTINUE11__MPCC2_STALL_INTERRUPT_MASK                                          0x00020000L
#define DISP_INTERRUPT_STATUS_CONTINUE11__MPCC3_STALL_INTERRUPT_MASK                                          0x00040000L
#define DISP_INTERRUPT_STATUS_CONTINUE11__MPCC4_STALL_INTERRUPT_MASK                                          0x00080000L
#define DISP_INTERRUPT_STATUS_CONTINUE11__MPCC5_STALL_INTERRUPT_MASK                                          0x00100000L
#define DISP_INTERRUPT_STATUS_CONTINUE11__MPCC6_STALL_INTERRUPT_MASK                                          0x00200000L
#define DISP_INTERRUPT_STATUS_CONTINUE11__MPCC7_STALL_INTERRUPT_MASK                                          0x00400000L
#define DISP_INTERRUPT_STATUS_CONTINUE11__VGA_IHC_VGA_CRT_INTERRUPT_MASK                                      0x00800000L
#define DISP_INTERRUPT_STATUS_CONTINUE11__DISP_INTERRUPT_STATUS_CONTINUE12_MASK                               0x80000000L
//DISP_INTERRUPT_STATUS_CONTINUE12
#define DISP_INTERRUPT_STATUS_CONTINUE12__MPC_PERFMON_COUNTER0_INTERRUPT__SHIFT                               0x0
#define DISP_INTERRUPT_STATUS_CONTINUE12__MPC_PERFMON_COUNTER1_INTERRUPT__SHIFT                               0x1
#define DISP_INTERRUPT_STATUS_CONTINUE12__DPP6_PERFMON_COUNTER0_INTERRUPT__SHIFT                              0x9
#define DISP_INTERRUPT_STATUS_CONTINUE12__DPP6_PERFMON_COUNTER1_INTERRUPT__SHIFT                              0xa
#define DISP_INTERRUPT_STATUS_CONTINUE12__DPP7_PERFMON_COUNTER0_INTERRUPT__SHIFT                              0x12
#define DISP_INTERRUPT_STATUS_CONTINUE12__DPP7_PERFMON_COUNTER1_INTERRUPT__SHIFT                              0x13
#define DISP_INTERRUPT_STATUS_CONTINUE12__DISP_INTERRUPT_STATUS_CONTINUE13__SHIFT                             0x1f
#define DISP_INTERRUPT_STATUS_CONTINUE12__MPC_PERFMON_COUNTER0_INTERRUPT_MASK                                 0x00000001L
#define DISP_INTERRUPT_STATUS_CONTINUE12__MPC_PERFMON_COUNTER1_INTERRUPT_MASK                                 0x00000002L
#define DISP_INTERRUPT_STATUS_CONTINUE12__DPP6_PERFMON_COUNTER0_INTERRUPT_MASK                                0x00000200L
#define DISP_INTERRUPT_STATUS_CONTINUE12__DPP6_PERFMON_COUNTER1_INTERRUPT_MASK                                0x00000400L
#define DISP_INTERRUPT_STATUS_CONTINUE12__DPP7_PERFMON_COUNTER0_INTERRUPT_MASK                                0x00040000L
#define DISP_INTERRUPT_STATUS_CONTINUE12__DPP7_PERFMON_COUNTER1_INTERRUPT_MASK                                0x00080000L
#define DISP_INTERRUPT_STATUS_CONTINUE12__DISP_INTERRUPT_STATUS_CONTINUE13_MASK                               0x80000000L
//DISP_INTERRUPT_STATUS_CONTINUE13
#define DISP_INTERRUPT_STATUS_CONTINUE13__HUBBUB_PERFMON_COUNTER0_INTERRUPT__SHIFT                            0x0
#define DISP_INTERRUPT_STATUS_CONTINUE13__HUBBUB_PERFMON_COUNTER1_INTERRUPT__SHIFT                            0x1
#define DISP_INTERRUPT_STATUS_CONTINUE13__DCPG_IHC_DOMAIN0_POWER_UP_INTERRUPT__SHIFT                          0x9
#define DISP_INTERRUPT_STATUS_CONTINUE13__DCPG_IHC_DOMAIN1_POWER_UP_INTERRUPT__SHIFT                          0xa
#define DISP_INTERRUPT_STATUS_CONTINUE13__DCPG_IHC_DOMAIN2_POWER_UP_INTERRUPT__SHIFT                          0xb
#define DISP_INTERRUPT_STATUS_CONTINUE13__DCPG_IHC_DOMAIN3_POWER_UP_INTERRUPT__SHIFT                          0xc
#define DISP_INTERRUPT_STATUS_CONTINUE13__DCPG_IHC_DOMAIN4_POWER_UP_INTERRUPT__SHIFT                          0xd
#define DISP_INTERRUPT_STATUS_CONTINUE13__DCPG_IHC_DOMAIN5_POWER_UP_INTERRUPT__SHIFT                          0xe
#define DISP_INTERRUPT_STATUS_CONTINUE13__DCPG_IHC_DOMAIN6_POWER_UP_INTERRUPT__SHIFT                          0xf
#define DISP_INTERRUPT_STATUS_CONTINUE13__DCPG_IHC_DOMAIN7_POWER_UP_INTERRUPT__SHIFT                          0x10
#define DISP_INTERRUPT_STATUS_CONTINUE13__HUBP0_PERFMON_COUNTER0_INTERRUPT__SHIFT                             0x12
#define DISP_INTERRUPT_STATUS_CONTINUE13__HUBP0_PERFMON_COUNTER1_INTERRUPT__SHIFT                             0x13
#define DISP_INTERRUPT_STATUS_CONTINUE13__HUBP0_IHC_VBLANK_INTERRUPT__SHIFT                                   0x1b
#define DISP_INTERRUPT_STATUS_CONTINUE13__HUBP0_IHC_VLINE_INTERRUPT__SHIFT                                    0x1c
#define DISP_INTERRUPT_STATUS_CONTINUE13__HUBP0_IHC_VLINE2_INTERRUPT__SHIFT                                   0x1d
#define DISP_INTERRUPT_STATUS_CONTINUE13__HUBP0_IHC_VM_CONTEXT_ERROR_INTERRUPT__SHIFT                         0x1e
#define DISP_INTERRUPT_STATUS_CONTINUE13__DISP_INTERRUPT_STATUS_CONTINUE14__SHIFT                             0x1f
#define DISP_INTERRUPT_STATUS_CONTINUE13__HUBBUB_PERFMON_COUNTER0_INTERRUPT_MASK                              0x00000001L
#define DISP_INTERRUPT_STATUS_CONTINUE13__HUBBUB_PERFMON_COUNTER1_INTERRUPT_MASK                              0x00000002L
#define DISP_INTERRUPT_STATUS_CONTINUE13__DCPG_IHC_DOMAIN0_POWER_UP_INTERRUPT_MASK                            0x00000200L
#define DISP_INTERRUPT_STATUS_CONTINUE13__DCPG_IHC_DOMAIN1_POWER_UP_INTERRUPT_MASK                            0x00000400L
#define DISP_INTERRUPT_STATUS_CONTINUE13__DCPG_IHC_DOMAIN2_POWER_UP_INTERRUPT_MASK                            0x00000800L
#define DISP_INTERRUPT_STATUS_CONTINUE13__DCPG_IHC_DOMAIN3_POWER_UP_INTERRUPT_MASK                            0x00001000L
#define DISP_INTERRUPT_STATUS_CONTINUE13__DCPG_IHC_DOMAIN4_POWER_UP_INTERRUPT_MASK                            0x00002000L
#define DISP_INTERRUPT_STATUS_CONTINUE13__DCPG_IHC_DOMAIN5_POWER_UP_INTERRUPT_MASK                            0x00004000L
#define DISP_INTERRUPT_STATUS_CONTINUE13__DCPG_IHC_DOMAIN6_POWER_UP_INTERRUPT_MASK                            0x00008000L
#define DISP_INTERRUPT_STATUS_CONTINUE13__DCPG_IHC_DOMAIN7_POWER_UP_INTERRUPT_MASK                            0x00010000L
#define DISP_INTERRUPT_STATUS_CONTINUE13__HUBP0_PERFMON_COUNTER0_INTERRUPT_MASK                               0x00040000L
#define DISP_INTERRUPT_STATUS_CONTINUE13__HUBP0_PERFMON_COUNTER1_INTERRUPT_MASK                               0x00080000L
#define DISP_INTERRUPT_STATUS_CONTINUE13__HUBP0_IHC_VBLANK_INTERRUPT_MASK                                     0x08000000L
#define DISP_INTERRUPT_STATUS_CONTINUE13__HUBP0_IHC_VLINE_INTERRUPT_MASK                                      0x10000000L
#define DISP_INTERRUPT_STATUS_CONTINUE13__HUBP0_IHC_VLINE2_INTERRUPT_MASK                                     0x20000000L
#define DISP_INTERRUPT_STATUS_CONTINUE13__HUBP0_IHC_VM_CONTEXT_ERROR_INTERRUPT_MASK                           0x40000000L
#define DISP_INTERRUPT_STATUS_CONTINUE13__DISP_INTERRUPT_STATUS_CONTINUE14_MASK                               0x80000000L
//DISP_INTERRUPT_STATUS_CONTINUE14
#define DISP_INTERRUPT_STATUS_CONTINUE14__HUBP1_PERFMON_COUNTER0_INTERRUPT__SHIFT                             0x0
#define DISP_INTERRUPT_STATUS_CONTINUE14__HUBP1_PERFMON_COUNTER1_INTERRUPT__SHIFT                             0x1
#define DISP_INTERRUPT_STATUS_CONTINUE14__HUBP2_PERFMON_COUNTER0_INTERRUPT__SHIFT                             0x9
#define DISP_INTERRUPT_STATUS_CONTINUE14__HUBP2_PERFMON_COUNTER1_INTERRUPT__SHIFT                             0xa
#define DISP_INTERRUPT_STATUS_CONTINUE14__HUBP3_PERFMON_COUNTER0_INTERRUPT__SHIFT                             0x12
#define DISP_INTERRUPT_STATUS_CONTINUE14__HUBP3_PERFMON_COUNTER1_INTERRUPT__SHIFT                             0x13
#define DISP_INTERRUPT_STATUS_CONTINUE14__HUBP1_IHC_VBLANK_INTERRUPT__SHIFT                                   0x1b
#define DISP_INTERRUPT_STATUS_CONTINUE14__HUBP1_IHC_VLINE_INTERRUPT__SHIFT                                    0x1c
#define DISP_INTERRUPT_STATUS_CONTINUE14__HUBP1_IHC_VLINE2_INTERRUPT__SHIFT                                   0x1d
#define DISP_INTERRUPT_STATUS_CONTINUE14__HUBP1_IHC_VM_CONTEXT_ERROR_INTERRUPT__SHIFT                         0x1e
#define DISP_INTERRUPT_STATUS_CONTINUE14__DISP_INTERRUPT_STATUS_CONTINUE15__SHIFT                             0x1f
#define DISP_INTERRUPT_STATUS_CONTINUE14__HUBP1_PERFMON_COUNTER0_INTERRUPT_MASK                               0x00000001L
#define DISP_INTERRUPT_STATUS_CONTINUE14__HUBP1_PERFMON_COUNTER1_INTERRUPT_MASK                               0x00000002L
#define DISP_INTERRUPT_STATUS_CONTINUE14__HUBP2_PERFMON_COUNTER0_INTERRUPT_MASK                               0x00000200L
#define DISP_INTERRUPT_STATUS_CONTINUE14__HUBP2_PERFMON_COUNTER1_INTERRUPT_MASK                               0x00000400L
#define DISP_INTERRUPT_STATUS_CONTINUE14__HUBP3_PERFMON_COUNTER0_INTERRUPT_MASK                               0x00040000L
#define DISP_INTERRUPT_STATUS_CONTINUE14__HUBP3_PERFMON_COUNTER1_INTERRUPT_MASK                               0x00080000L
#define DISP_INTERRUPT_STATUS_CONTINUE14__HUBP1_IHC_VBLANK_INTERRUPT_MASK                                     0x08000000L
#define DISP_INTERRUPT_STATUS_CONTINUE14__HUBP1_IHC_VLINE_INTERRUPT_MASK                                      0x10000000L
#define DISP_INTERRUPT_STATUS_CONTINUE14__HUBP1_IHC_VLINE2_INTERRUPT_MASK                                     0x20000000L
#define DISP_INTERRUPT_STATUS_CONTINUE14__HUBP1_IHC_VM_CONTEXT_ERROR_INTERRUPT_MASK                           0x40000000L
#define DISP_INTERRUPT_STATUS_CONTINUE14__DISP_INTERRUPT_STATUS_CONTINUE15_MASK                               0x80000000L
//DISP_INTERRUPT_STATUS_CONTINUE15
#define DISP_INTERRUPT_STATUS_CONTINUE15__HUBP4_PERFMON_COUNTER0_INTERRUPT__SHIFT                             0x0
#define DISP_INTERRUPT_STATUS_CONTINUE15__HUBP4_PERFMON_COUNTER1_INTERRUPT__SHIFT                             0x1
#define DISP_INTERRUPT_STATUS_CONTINUE15__HUBP5_PERFMON_COUNTER0_INTERRUPT__SHIFT                             0x9
#define DISP_INTERRUPT_STATUS_CONTINUE15__HUBP5_PERFMON_COUNTER1_INTERRUPT__SHIFT                             0xa
#define DISP_INTERRUPT_STATUS_CONTINUE15__HUBP6_PERFMON_COUNTER0_INTERRUPT__SHIFT                             0x12
#define DISP_INTERRUPT_STATUS_CONTINUE15__HUBP6_PERFMON_COUNTER1_INTERRUPT__SHIFT                             0x13
#define DISP_INTERRUPT_STATUS_CONTINUE15__HUBP2_IHC_VBLANK_INTERRUPT__SHIFT                                   0x1b
#define DISP_INTERRUPT_STATUS_CONTINUE15__HUBP2_IHC_VLINE_INTERRUPT__SHIFT                                    0x1c
#define DISP_INTERRUPT_STATUS_CONTINUE15__HUBP2_IHC_VLINE2_INTERRUPT__SHIFT                                   0x1d
#define DISP_INTERRUPT_STATUS_CONTINUE15__HUBP2_IHC_VM_CONTEXT_ERROR_INTERRUPT__SHIFT                         0x1e
#define DISP_INTERRUPT_STATUS_CONTINUE15__DISP_INTERRUPT_STATUS_CONTINUE16__SHIFT                             0x1f
#define DISP_INTERRUPT_STATUS_CONTINUE15__HUBP4_PERFMON_COUNTER0_INTERRUPT_MASK                               0x00000001L
#define DISP_INTERRUPT_STATUS_CONTINUE15__HUBP4_PERFMON_COUNTER1_INTERRUPT_MASK                               0x00000002L
#define DISP_INTERRUPT_STATUS_CONTINUE15__HUBP5_PERFMON_COUNTER0_INTERRUPT_MASK                               0x00000200L
#define DISP_INTERRUPT_STATUS_CONTINUE15__HUBP5_PERFMON_COUNTER1_INTERRUPT_MASK                               0x00000400L
#define DISP_INTERRUPT_STATUS_CONTINUE15__HUBP6_PERFMON_COUNTER0_INTERRUPT_MASK                               0x00040000L
#define DISP_INTERRUPT_STATUS_CONTINUE15__HUBP6_PERFMON_COUNTER1_INTERRUPT_MASK                               0x00080000L
#define DISP_INTERRUPT_STATUS_CONTINUE15__HUBP2_IHC_VBLANK_INTERRUPT_MASK                                     0x08000000L
#define DISP_INTERRUPT_STATUS_CONTINUE15__HUBP2_IHC_VLINE_INTERRUPT_MASK                                      0x10000000L
#define DISP_INTERRUPT_STATUS_CONTINUE15__HUBP2_IHC_VLINE2_INTERRUPT_MASK                                     0x20000000L
#define DISP_INTERRUPT_STATUS_CONTINUE15__HUBP2_IHC_VM_CONTEXT_ERROR_INTERRUPT_MASK                           0x40000000L
#define DISP_INTERRUPT_STATUS_CONTINUE15__DISP_INTERRUPT_STATUS_CONTINUE16_MASK                               0x80000000L
//DISP_INTERRUPT_STATUS_CONTINUE16
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP7_PERFMON_COUNTER0_INTERRUPT__SHIFT                             0x0
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP7_PERFMON_COUNTER1_INTERRUPT__SHIFT                             0x1
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP3_IHC_VBLANK_INTERRUPT__SHIFT                                   0x9
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP3_IHC_VLINE_INTERRUPT__SHIFT                                    0xa
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP3_IHC_VLINE2_INTERRUPT__SHIFT                                   0xb
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP4_IHC_VBLANK_INTERRUPT__SHIFT                                   0xc
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP4_IHC_VLINE_INTERRUPT__SHIFT                                    0xd
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP4_IHC_VLINE2_INTERRUPT__SHIFT                                   0xe
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP5_IHC_VBLANK_INTERRUPT__SHIFT                                   0xf
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP5_IHC_VLINE_INTERRUPT__SHIFT                                    0x10
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP5_IHC_VLINE2_INTERRUPT__SHIFT                                   0x11
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP6_IHC_VBLANK_INTERRUPT__SHIFT                                   0x12
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP6_IHC_VLINE_INTERRUPT__SHIFT                                    0x13
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP6_IHC_VLINE2_INTERRUPT__SHIFT                                   0x14
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP7_IHC_VBLANK_INTERRUPT__SHIFT                                   0x15
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP7_IHC_VLINE_INTERRUPT__SHIFT                                    0x16
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP7_IHC_VLINE2_INTERRUPT__SHIFT                                   0x17
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP3_IHC_VM_CONTEXT_ERROR_INTERRUPT__SHIFT                         0x18
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP4_IHC_VM_CONTEXT_ERROR_INTERRUPT__SHIFT                         0x19
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP5_IHC_VM_CONTEXT_ERROR_INTERRUPT__SHIFT                         0x1a
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP6_IHC_VM_CONTEXT_ERROR_INTERRUPT__SHIFT                         0x1b
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP7_IHC_VM_CONTEXT_ERROR_INTERRUPT__SHIFT                         0x1c
#define DISP_INTERRUPT_STATUS_CONTINUE16__DISP_INTERRUPT_STATUS_CONTINUE17__SHIFT                             0x1f
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP7_PERFMON_COUNTER0_INTERRUPT_MASK                               0x00000001L
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP7_PERFMON_COUNTER1_INTERRUPT_MASK                               0x00000002L
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP3_IHC_VBLANK_INTERRUPT_MASK                                     0x00000200L
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP3_IHC_VLINE_INTERRUPT_MASK                                      0x00000400L
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP3_IHC_VLINE2_INTERRUPT_MASK                                     0x00000800L
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP4_IHC_VBLANK_INTERRUPT_MASK                                     0x00001000L
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP4_IHC_VLINE_INTERRUPT_MASK                                      0x00002000L
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP4_IHC_VLINE2_INTERRUPT_MASK                                     0x00004000L
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP5_IHC_VBLANK_INTERRUPT_MASK                                     0x00008000L
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP5_IHC_VLINE_INTERRUPT_MASK                                      0x00010000L
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP5_IHC_VLINE2_INTERRUPT_MASK                                     0x00020000L
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP6_IHC_VBLANK_INTERRUPT_MASK                                     0x00040000L
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP6_IHC_VLINE_INTERRUPT_MASK                                      0x00080000L
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP6_IHC_VLINE2_INTERRUPT_MASK                                     0x00100000L
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP7_IHC_VBLANK_INTERRUPT_MASK                                     0x00200000L
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP7_IHC_VLINE_INTERRUPT_MASK                                      0x00400000L
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP7_IHC_VLINE2_INTERRUPT_MASK                                     0x00800000L
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP3_IHC_VM_CONTEXT_ERROR_INTERRUPT_MASK                           0x01000000L
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP4_IHC_VM_CONTEXT_ERROR_INTERRUPT_MASK                           0x02000000L
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP5_IHC_VM_CONTEXT_ERROR_INTERRUPT_MASK                           0x04000000L
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP6_IHC_VM_CONTEXT_ERROR_INTERRUPT_MASK                           0x08000000L
#define DISP_INTERRUPT_STATUS_CONTINUE16__HUBP7_IHC_VM_CONTEXT_ERROR_INTERRUPT_MASK                           0x10000000L
#define DISP_INTERRUPT_STATUS_CONTINUE16__DISP_INTERRUPT_STATUS_CONTINUE17_MASK                               0x80000000L
//DISP_INTERRUPT_STATUS_CONTINUE17
#define DISP_INTERRUPT_STATUS_CONTINUE17__OPP_PERFMON_COUNTER0_INTERRUPT__SHIFT                               0x0
#define DISP_INTERRUPT_STATUS_CONTINUE17__OPP_PERFMON_COUNTER1_INTERRUPT__SHIFT                               0x1
#define DISP_INTERRUPT_STATUS_CONTINUE17__HUBP0_IHC_FLIP_INTERRUPT__SHIFT                                     0x2
#define DISP_INTERRUPT_STATUS_CONTINUE17__HUBP1_IHC_FLIP_INTERRUPT__SHIFT                                     0x3
#define DISP_INTERRUPT_STATUS_CONTINUE17__HUBP2_IHC_FLIP_INTERRUPT__SHIFT                                     0x4
#define DISP_INTERRUPT_STATUS_CONTINUE17__HUBP3_IHC_FLIP_INTERRUPT__SHIFT                                     0x5
#define DISP_INTERRUPT_STATUS_CONTINUE17__HUBP4_IHC_FLIP_INTERRUPT__SHIFT                                     0x6
#define DISP_INTERRUPT_STATUS_CONTINUE17__HUBP5_IHC_FLIP_INTERRUPT__SHIFT                                     0x7
#define DISP_INTERRUPT_STATUS_CONTINUE17__HUBP6_IHC_FLIP_INTERRUPT__SHIFT                                     0x8
#define DISP_INTERRUPT_STATUS_CONTINUE17__HUBP7_IHC_FLIP_INTERRUPT__SHIFT                                     0x9
#define DISP_INTERRUPT_STATUS_CONTINUE17__OPTC_PERFMON_COUNTER0_INTERRUPT__SHIFT                              0xa
#define DISP_INTERRUPT_STATUS_CONTINUE17__OPTC_PERFMON_COUNTER1_INTERRUPT__SHIFT                              0xb
#define DISP_INTERRUPT_STATUS_CONTINUE17__MMHUBBUB_PERFMON_COUNTER0_INTERRUPT__SHIFT                          0x12
#define DISP_INTERRUPT_STATUS_CONTINUE17__MMHUBBUB_PERFMON_COUNTER1_INTERRUPT__SHIFT                          0x13
#define DISP_INTERRUPT_STATUS_CONTINUE17__HUBP0_IHC_FLIP_AWAY_INTERRUPT__SHIFT                                0x14
#define DISP_INTERRUPT_STATUS_CONTINUE17__HUBP1_IHC_FLIP_AWAY_INTERRUPT__SHIFT                                0x15
#define DISP_INTERRUPT_STATUS_CONTINUE17__HUBP2_IHC_FLIP_AWAY_INTERRUPT__SHIFT                                0x16
#define DISP_INTERRUPT_STATUS_CONTINUE17__HUBP3_IHC_FLIP_AWAY_INTERRUPT__SHIFT                                0x17
#define DISP_INTERRUPT_STATUS_CONTINUE17__HUBP4_IHC_FLIP_AWAY_INTERRUPT__SHIFT                                0x18
#define DISP_INTERRUPT_STATUS_CONTINUE17__HUBP5_IHC_FLIP_AWAY_INTERRUPT__SHIFT                                0x19
#define DISP_INTERRUPT_STATUS_CONTINUE17__HUBP6_IHC_FLIP_AWAY_INTERRUPT__SHIFT                                0x1a
#define DISP_INTERRUPT_STATUS_CONTINUE17__HUBP7_IHC_FLIP_AWAY_INTERRUPT__SHIFT                                0x1b
#define DISP_INTERRUPT_STATUS_CONTINUE17__DISP_INTERRUPT_STATUS_CONTINUE18__SHIFT                             0x1f
#define DISP_INTERRUPT_STATUS_CONTINUE17__OPP_PERFMON_COUNTER0_INTERRUPT_MASK                                 0x00000001L
#define DISP_INTERRUPT_STATUS_CONTINUE17__OPP_PERFMON_COUNTER1_INTERRUPT_MASK                                 0x00000002L
#define DISP_INTERRUPT_STATUS_CONTINUE17__HUBP0_IHC_FLIP_INTERRUPT_MASK                                       0x00000004L
#define DISP_INTERRUPT_STATUS_CONTINUE17__HUBP1_IHC_FLIP_INTERRUPT_MASK                                       0x00000008L
#define DISP_INTERRUPT_STATUS_CONTINUE17__HUBP2_IHC_FLIP_INTERRUPT_MASK                                       0x00000010L
#define DISP_INTERRUPT_STATUS_CONTINUE17__HUBP3_IHC_FLIP_INTERRUPT_MASK                                       0x00000020L
#define DISP_INTERRUPT_STATUS_CONTINUE17__HUBP4_IHC_FLIP_INTERRUPT_MASK                                       0x00000040L
#define DISP_INTERRUPT_STATUS_CONTINUE17__HUBP5_IHC_FLIP_INTERRUPT_MASK                                       0x00000080L
#define DISP_INTERRUPT_STATUS_CONTINUE17__HUBP6_IHC_FLIP_INTERRUPT_MASK                                       0x00000100L
#define DISP_INTERRUPT_STATUS_CONTINUE17__HUBP7_IHC_FLIP_INTERRUPT_MASK                                       0x00000200L
#define DISP_INTERRUPT_STATUS_CONTINUE17__OPTC_PERFMON_COUNTER0_INTERRUPT_MASK                                0x00000400L
#define DISP_INTERRUPT_STATUS_CONTINUE17__OPTC_PERFMON_COUNTER1_INTERRUPT_MASK                                0x00000800L
#define DISP_INTERRUPT_STATUS_CONTINUE17__MMHUBBUB_PERFMON_COUNTER0_INTERRUPT_MASK                            0x00040000L
#define DISP_INTERRUPT_STATUS_CONTINUE17__MMHUBBUB_PERFMON_COUNTER1_INTERRUPT_MASK                            0x00080000L
#define DISP_INTERRUPT_STATUS_CONTINUE17__HUBP0_IHC_FLIP_AWAY_INTERRUPT_MASK                                  0x00100000L
#define DISP_INTERRUPT_STATUS_CONTINUE17__HUBP1_IHC_FLIP_AWAY_INTERRUPT_MASK                                  0x00200000L
#define DISP_INTERRUPT_STATUS_CONTINUE17__HUBP2_IHC_FLIP_AWAY_INTERRUPT_MASK                                  0x00400000L
#define DISP_INTERRUPT_STATUS_CONTINUE17__HUBP3_IHC_FLIP_AWAY_INTERRUPT_MASK                                  0x00800000L
#define DISP_INTERRUPT_STATUS_CONTINUE17__HUBP4_IHC_FLIP_AWAY_INTERRUPT_MASK                                  0x01000000L
#define DISP_INTERRUPT_STATUS_CONTINUE17__HUBP5_IHC_FLIP_AWAY_INTERRUPT_MASK                                  0x02000000L
#define DISP_INTERRUPT_STATUS_CONTINUE17__HUBP6_IHC_FLIP_AWAY_INTERRUPT_MASK                                  0x04000000L
#define DISP_INTERRUPT_STATUS_CONTINUE17__HUBP7_IHC_FLIP_AWAY_INTERRUPT_MASK                                  0x08000000L
#define DISP_INTERRUPT_STATUS_CONTINUE17__DISP_INTERRUPT_STATUS_CONTINUE18_MASK                               0x80000000L
//DISP_INTERRUPT_STATUS_CONTINUE18
#define DISP_INTERRUPT_STATUS_CONTINUE18__AZ_PERFMON_COUNTER0_INTERRUPT__SHIFT                                0x0
#define DISP_INTERRUPT_STATUS_CONTINUE18__AZ_PERFMON_COUNTER1_INTERRUPT__SHIFT                                0x1
#define DISP_INTERRUPT_STATUS_CONTINUE18__DCIO_DPCS_TXA_IHC_ERROR_INTERRUPT__SHIFT                            0x9
#define DISP_INTERRUPT_STATUS_CONTINUE18__DCIO_DPCS_TXB_IHC_ERROR_INTERRUPT__SHIFT                            0xa
#define DISP_INTERRUPT_STATUS_CONTINUE18__DCIO_DPCS_TXC_IHC_ERROR_INTERRUPT__SHIFT                            0xb
#define DISP_INTERRUPT_STATUS_CONTINUE18__DCIO_DPCS_TXD_IHC_ERROR_INTERRUPT__SHIFT                            0xc
#define DISP_INTERRUPT_STATUS_CONTINUE18__DCIO_DPCS_TXE_IHC_ERROR_INTERRUPT__SHIFT                            0xd
#define DISP_INTERRUPT_STATUS_CONTINUE18__DCIO_DPCS_TXF_IHC_ERROR_INTERRUPT__SHIFT                            0xe
#define DISP_INTERRUPT_STATUS_CONTINUE18__DCIO_DPCS_TXG_IHC_ERROR_INTERRUPT__SHIFT                            0xf
#define DISP_INTERRUPT_STATUS_CONTINUE18__DCIO_DPCS_RXA_IHC_ERROR_INTERRUPT__SHIFT                            0x10
#define DISP_INTERRUPT_STATUS_CONTINUE18__DCPG_IHC_DOMAIN0_POWER_DOWN_INTERRUPT__SHIFT                        0x11
#define DISP_INTERRUPT_STATUS_CONTINUE18__DCPG_IHC_DOMAIN1_POWER_DOWN_INTERRUPT__SHIFT                        0x12
#define DISP_INTERRUPT_STATUS_CONTINUE18__DCPG_IHC_DOMAIN2_POWER_DOWN_INTERRUPT__SHIFT                        0x13
#define DISP_INTERRUPT_STATUS_CONTINUE18__DCPG_IHC_DOMAIN3_POWER_DOWN_INTERRUPT__SHIFT                        0x14
#define DISP_INTERRUPT_STATUS_CONTINUE18__DCPG_IHC_DOMAIN4_POWER_DOWN_INTERRUPT__SHIFT                        0x15
#define DISP_INTERRUPT_STATUS_CONTINUE18__DCPG_IHC_DOMAIN5_POWER_DOWN_INTERRUPT__SHIFT                        0x16
#define DISP_INTERRUPT_STATUS_CONTINUE18__DCPG_IHC_DOMAIN6_POWER_DOWN_INTERRUPT__SHIFT                        0x17
#define DISP_INTERRUPT_STATUS_CONTINUE18__DCPG_IHC_DOMAIN7_POWER_DOWN_INTERRUPT__SHIFT                        0x18
#define DISP_INTERRUPT_STATUS_CONTINUE18__DISP_INTERRUPT_STATUS_CONTINUE19__SHIFT                             0x1f
#define DISP_INTERRUPT_STATUS_CONTINUE18__AZ_PERFMON_COUNTER0_INTERRUPT_MASK                                  0x00000001L
#define DISP_INTERRUPT_STATUS_CONTINUE18__AZ_PERFMON_COUNTER1_INTERRUPT_MASK                                  0x00000002L
#define DISP_INTERRUPT_STATUS_CONTINUE18__DCIO_DPCS_TXA_IHC_ERROR_INTERRUPT_MASK                              0x00000200L
#define DISP_INTERRUPT_STATUS_CONTINUE18__DCIO_DPCS_TXB_IHC_ERROR_INTERRUPT_MASK                              0x00000400L
#define DISP_INTERRUPT_STATUS_CONTINUE18__DCIO_DPCS_TXC_IHC_ERROR_INTERRUPT_MASK                              0x00000800L
#define DISP_INTERRUPT_STATUS_CONTINUE18__DCIO_DPCS_TXD_IHC_ERROR_INTERRUPT_MASK                              0x00001000L
#define DISP_INTERRUPT_STATUS_CONTINUE18__DCIO_DPCS_TXE_IHC_ERROR_INTERRUPT_MASK                              0x00002000L
#define DISP_INTERRUPT_STATUS_CONTINUE18__DCIO_DPCS_TXF_IHC_ERROR_INTERRUPT_MASK                              0x00004000L
#define DISP_INTERRUPT_STATUS_CONTINUE18__DCIO_DPCS_TXG_IHC_ERROR_INTERRUPT_MASK                              0x00008000L
#define DISP_INTERRUPT_STATUS_CONTINUE18__DCIO_DPCS_RXA_IHC_ERROR_INTERRUPT_MASK                              0x00010000L
#define DISP_INTERRUPT_STATUS_CONTINUE18__DCPG_IHC_DOMAIN0_POWER_DOWN_INTERRUPT_MASK                          0x00020000L
#define DISP_INTERRUPT_STATUS_CONTINUE18__DCPG_IHC_DOMAIN1_POWER_DOWN_INTERRUPT_MASK                          0x00040000L
#define DISP_INTERRUPT_STATUS_CONTINUE18__DCPG_IHC_DOMAIN2_POWER_DOWN_INTERRUPT_MASK                          0x00080000L
#define DISP_INTERRUPT_STATUS_CONTINUE18__DCPG_IHC_DOMAIN3_POWER_DOWN_INTERRUPT_MASK                          0x00100000L
#define DISP_INTERRUPT_STATUS_CONTINUE18__DCPG_IHC_DOMAIN4_POWER_DOWN_INTERRUPT_MASK                          0x00200000L
#define DISP_INTERRUPT_STATUS_CONTINUE18__DCPG_IHC_DOMAIN5_POWER_DOWN_INTERRUPT_MASK                          0x00400000L
#define DISP_INTERRUPT_STATUS_CONTINUE18__DCPG_IHC_DOMAIN6_POWER_DOWN_INTERRUPT_MASK                          0x00800000L
#define DISP_INTERRUPT_STATUS_CONTINUE18__DCPG_IHC_DOMAIN7_POWER_DOWN_INTERRUPT_MASK                          0x01000000L
#define DISP_INTERRUPT_STATUS_CONTINUE18__DISP_INTERRUPT_STATUS_CONTINUE19_MASK                               0x80000000L
//DISP_INTERRUPT_STATUS_CONTINUE19
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT0_AUDIO_FORMAT_CHANGED_INT__SHIFT                    0x0
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT1_AUDIO_FORMAT_CHANGED_INT__SHIFT                    0x1
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT2_AUDIO_FORMAT_CHANGED_INT__SHIFT                    0x2
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT3_AUDIO_FORMAT_CHANGED_INT__SHIFT                    0x3
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT4_AUDIO_FORMAT_CHANGED_INT__SHIFT                    0x4
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT5_AUDIO_FORMAT_CHANGED_INT__SHIFT                    0x5
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT6_AUDIO_FORMAT_CHANGED_INT__SHIFT                    0x6
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT7_AUDIO_FORMAT_CHANGED_INT__SHIFT                    0x7
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT0_AUDIO_ENABLED_INT__SHIFT                           0x8
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT1_AUDIO_ENABLED_INT__SHIFT                           0x9
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT2_AUDIO_ENABLED_INT__SHIFT                           0xa
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT3_AUDIO_ENABLED_INT__SHIFT                           0xb
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT4_AUDIO_ENABLED_INT__SHIFT                           0xc
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT5_AUDIO_ENABLED_INT__SHIFT                           0xd
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT6_AUDIO_ENABLED_INT__SHIFT                           0xe
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT7_AUDIO_ENABLED_INT__SHIFT                           0xf
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT0_AUDIO_DISABLED_INT__SHIFT                          0x10
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT1_AUDIO_DISABLED_INT__SHIFT                          0x11
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT2_AUDIO_DISABLED_INT__SHIFT                          0x12
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT3_AUDIO_DISABLED_INT__SHIFT                          0x13
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT4_AUDIO_DISABLED_INT__SHIFT                          0x14
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT5_AUDIO_DISABLED_INT__SHIFT                          0x15
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT6_AUDIO_DISABLED_INT__SHIFT                          0x16
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT7_AUDIO_DISABLED_INT__SHIFT                          0x17
#define DISP_INTERRUPT_STATUS_CONTINUE19__DIGG_DP_FAST_TRAINING_COMPLETE_INTERRUPT__SHIFT                     0x1c
#define DISP_INTERRUPT_STATUS_CONTINUE19__DIGG_DP_VID_STREAM_DISABLE_INTERRUPT__SHIFT                         0x1d
#define DISP_INTERRUPT_STATUS_CONTINUE19__DISP_INTERRUPT_STATUS_CONTINUE20__SHIFT                             0x1f
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT0_AUDIO_FORMAT_CHANGED_INT_MASK                      0x00000001L
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT1_AUDIO_FORMAT_CHANGED_INT_MASK                      0x00000002L
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT2_AUDIO_FORMAT_CHANGED_INT_MASK                      0x00000004L
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT3_AUDIO_FORMAT_CHANGED_INT_MASK                      0x00000008L
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT4_AUDIO_FORMAT_CHANGED_INT_MASK                      0x00000010L
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT5_AUDIO_FORMAT_CHANGED_INT_MASK                      0x00000020L
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT6_AUDIO_FORMAT_CHANGED_INT_MASK                      0x00000040L
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT7_AUDIO_FORMAT_CHANGED_INT_MASK                      0x00000080L
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT0_AUDIO_ENABLED_INT_MASK                             0x00000100L
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT1_AUDIO_ENABLED_INT_MASK                             0x00000200L
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT2_AUDIO_ENABLED_INT_MASK                             0x00000400L
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT3_AUDIO_ENABLED_INT_MASK                             0x00000800L
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT4_AUDIO_ENABLED_INT_MASK                             0x00001000L
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT5_AUDIO_ENABLED_INT_MASK                             0x00002000L
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT6_AUDIO_ENABLED_INT_MASK                             0x00004000L
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT7_AUDIO_ENABLED_INT_MASK                             0x00008000L
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT0_AUDIO_DISABLED_INT_MASK                            0x00010000L
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT1_AUDIO_DISABLED_INT_MASK                            0x00020000L
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT2_AUDIO_DISABLED_INT_MASK                            0x00040000L
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT3_AUDIO_DISABLED_INT_MASK                            0x00080000L
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT4_AUDIO_DISABLED_INT_MASK                            0x00100000L
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT5_AUDIO_DISABLED_INT_MASK                            0x00200000L
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT6_AUDIO_DISABLED_INT_MASK                            0x00400000L
#define DISP_INTERRUPT_STATUS_CONTINUE19__AZ_IHC_ENDPOINT7_AUDIO_DISABLED_INT_MASK                            0x00800000L
#define DISP_INTERRUPT_STATUS_CONTINUE19__DIGG_DP_FAST_TRAINING_COMPLETE_INTERRUPT_MASK                       0x10000000L
#define DISP_INTERRUPT_STATUS_CONTINUE19__DIGG_DP_VID_STREAM_DISABLE_INTERRUPT_MASK                           0x20000000L
#define DISP_INTERRUPT_STATUS_CONTINUE19__DISP_INTERRUPT_STATUS_CONTINUE20_MASK                               0x80000000L
//DISP_INTERRUPT_STATUS_CONTINUE20
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG1_IHC_CPU_SS_INTERRUPT__SHIFT                                    0x0
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG2_IHC_CPU_SS_INTERRUPT__SHIFT                                    0x1
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG3_IHC_CPU_SS_INTERRUPT__SHIFT                                    0x2
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG4_IHC_CPU_SS_INTERRUPT__SHIFT                                    0x3
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG5_IHC_CPU_SS_INTERRUPT__SHIFT                                    0x4
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG6_IHC_CPU_SS_INTERRUPT__SHIFT                                    0x5
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG1_IHC_V_UPDATE_INTERRUPT__SHIFT                                  0x6
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG2_IHC_V_UPDATE_INTERRUPT__SHIFT                                  0x7
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG3_IHC_V_UPDATE_INTERRUPT__SHIFT                                  0x8
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG4_IHC_V_UPDATE_INTERRUPT__SHIFT                                  0x9
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG5_IHC_V_UPDATE_INTERRUPT__SHIFT                                  0xa
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG6_IHC_V_UPDATE_INTERRUPT__SHIFT                                  0xb
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG1_IHC_GSL_VSYNC_GAP_INTERRUPT__SHIFT                             0xc
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG2_IHC_GSL_VSYNC_GAP_INTERRUPT__SHIFT                             0xd
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG3_IHC_GSL_VSYNC_GAP_INTERRUPT__SHIFT                             0xe
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG4_IHC_GSL_VSYNC_GAP_INTERRUPT__SHIFT                             0xf
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG5_IHC_GSL_VSYNC_GAP_INTERRUPT__SHIFT                             0x10
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG6_IHC_GSL_VSYNC_GAP_INTERRUPT__SHIFT                             0x11
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG1_IHC_VSTARTUP_INTERRUPT__SHIFT                                  0x12
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG2_IHC_VSTARTUP_INTERRUPT__SHIFT                                  0x13
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG3_IHC_VSTARTUP_INTERRUPT__SHIFT                                  0x14
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG4_IHC_VSTARTUP_INTERRUPT__SHIFT                                  0x15
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG5_IHC_VSTARTUP_INTERRUPT__SHIFT                                  0x16
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG6_IHC_VSTARTUP_INTERRUPT__SHIFT                                  0x17
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG1_IHC_VREADY_INTERRUPT__SHIFT                                    0x18
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG2_IHC_VREADY_INTERRUPT__SHIFT                                    0x19
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG3_IHC_VREADY_INTERRUPT__SHIFT                                    0x1a
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG4_IHC_VREADY_INTERRUPT__SHIFT                                    0x1b
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG5_IHC_VREADY_INTERRUPT__SHIFT                                    0x1c
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG6_IHC_VREADY_INTERRUPT__SHIFT                                    0x1d
#define DISP_INTERRUPT_STATUS_CONTINUE20__DISP_INTERRUPT_STATUS_CONTINUE21__SHIFT                             0x1f
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG1_IHC_CPU_SS_INTERRUPT_MASK                                      0x00000001L
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG2_IHC_CPU_SS_INTERRUPT_MASK                                      0x00000002L
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG3_IHC_CPU_SS_INTERRUPT_MASK                                      0x00000004L
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG4_IHC_CPU_SS_INTERRUPT_MASK                                      0x00000008L
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG5_IHC_CPU_SS_INTERRUPT_MASK                                      0x00000010L
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG6_IHC_CPU_SS_INTERRUPT_MASK                                      0x00000020L
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG1_IHC_V_UPDATE_INTERRUPT_MASK                                    0x00000040L
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG2_IHC_V_UPDATE_INTERRUPT_MASK                                    0x00000080L
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG3_IHC_V_UPDATE_INTERRUPT_MASK                                    0x00000100L
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG4_IHC_V_UPDATE_INTERRUPT_MASK                                    0x00000200L
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG5_IHC_V_UPDATE_INTERRUPT_MASK                                    0x00000400L
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG6_IHC_V_UPDATE_INTERRUPT_MASK                                    0x00000800L
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG1_IHC_GSL_VSYNC_GAP_INTERRUPT_MASK                               0x00001000L
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG2_IHC_GSL_VSYNC_GAP_INTERRUPT_MASK                               0x00002000L
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG3_IHC_GSL_VSYNC_GAP_INTERRUPT_MASK                               0x00004000L
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG4_IHC_GSL_VSYNC_GAP_INTERRUPT_MASK                               0x00008000L
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG5_IHC_GSL_VSYNC_GAP_INTERRUPT_MASK                               0x00010000L
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG6_IHC_GSL_VSYNC_GAP_INTERRUPT_MASK                               0x00020000L
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG1_IHC_VSTARTUP_INTERRUPT_MASK                                    0x00040000L
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG2_IHC_VSTARTUP_INTERRUPT_MASK                                    0x00080000L
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG3_IHC_VSTARTUP_INTERRUPT_MASK                                    0x00100000L
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG4_IHC_VSTARTUP_INTERRUPT_MASK                                    0x00200000L
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG5_IHC_VSTARTUP_INTERRUPT_MASK                                    0x00400000L
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG6_IHC_VSTARTUP_INTERRUPT_MASK                                    0x00800000L
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG1_IHC_VREADY_INTERRUPT_MASK                                      0x01000000L
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG2_IHC_VREADY_INTERRUPT_MASK                                      0x02000000L
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG3_IHC_VREADY_INTERRUPT_MASK                                      0x04000000L
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG4_IHC_VREADY_INTERRUPT_MASK                                      0x08000000L
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG5_IHC_VREADY_INTERRUPT_MASK                                      0x10000000L
#define DISP_INTERRUPT_STATUS_CONTINUE20__OTG6_IHC_VREADY_INTERRUPT_MASK                                      0x20000000L
#define DISP_INTERRUPT_STATUS_CONTINUE20__DISP_INTERRUPT_STATUS_CONTINUE21_MASK                               0x80000000L
//DISP_INTERRUPT_STATUS_CONTINUE21
#define DISP_INTERRUPT_STATUS_CONTINUE21__DOUT_IHC_I2C_DDC1_HW_DONE_INTERRUPT__SHIFT                          0x0
#define DISP_INTERRUPT_STATUS_CONTINUE21__DOUT_IHC_I2C_DDC2_HW_DONE_INTERRUPT__SHIFT                          0x1
#define DISP_INTERRUPT_STATUS_CONTINUE21__DOUT_IHC_I2C_DDC3_HW_DONE_INTERRUPT__SHIFT                          0x2
#define DISP_INTERRUPT_STATUS_CONTINUE21__DOUT_IHC_I2C_DDC4_HW_DONE_INTERRUPT__SHIFT                          0x3
#define DISP_INTERRUPT_STATUS_CONTINUE21__DOUT_IHC_I2C_DDC5_HW_DONE_INTERRUPT__SHIFT                          0x4
#define DISP_INTERRUPT_STATUS_CONTINUE21__DOUT_IHC_I2C_DDC6_HW_DONE_INTERRUPT__SHIFT                          0x5
#define DISP_INTERRUPT_STATUS_CONTINUE21__DOUT_IHC_I2C_DDCVGA_HW_DONE_INTERRUPT__SHIFT                        0x6
#define DISP_INTERRUPT_STATUS_CONTINUE21__DC_I2C_DDC1_READ_REQUEST_INTERRUPT__SHIFT                           0x7
#define DISP_INTERRUPT_STATUS_CONTINUE21__DC_I2C_DDC2_READ_REQUEST_INTERRUPT__SHIFT                           0x8
#define DISP_INTERRUPT_STATUS_CONTINUE21__DC_I2C_DDC3_READ_REQUEST_INTERRUPT__SHIFT                           0x9
#define DISP_INTERRUPT_STATUS_CONTINUE21__DC_I2C_DDC4_READ_REQUEST_INTERRUPT__SHIFT                           0xa
#define DISP_INTERRUPT_STATUS_CONTINUE21__DC_I2C_DDC5_READ_REQUEST_INTERRUPT__SHIFT                           0xb
#define DISP_INTERRUPT_STATUS_CONTINUE21__DC_I2C_DDC6_READ_REQUEST_INTERRUPT__SHIFT                           0xc
#define DISP_INTERRUPT_STATUS_CONTINUE21__DC_I2C_VGA_READ_REQUEST_INTERRUPT__SHIFT                            0xd
#define DISP_INTERRUPT_STATUS_CONTINUE21__GENERIC_I2C_DDC_READ_REUEST_INTERRUPT__SHIFT                        0xe
#define DISP_INTERRUPT_STATUS_CONTINUE21__DIGH_DP_FAST_TRAINING_COMPLETE_INTERRUPT__SHIFT                     0x1c
#define DISP_INTERRUPT_STATUS_CONTINUE21__DIGH_DP_VID_STREAM_DISABLE_INTERRUPT__SHIFT                         0x1d
#define DISP_INTERRUPT_STATUS_CONTINUE21__DISP_INTERRUPT_STATUS_CONTINUE22__SHIFT                             0x1f
#define DISP_INTERRUPT_STATUS_CONTINUE21__DOUT_IHC_I2C_DDC1_HW_DONE_INTERRUPT_MASK                            0x00000001L
#define DISP_INTERRUPT_STATUS_CONTINUE21__DOUT_IHC_I2C_DDC2_HW_DONE_INTERRUPT_MASK                            0x00000002L
#define DISP_INTERRUPT_STATUS_CONTINUE21__DOUT_IHC_I2C_DDC3_HW_DONE_INTERRUPT_MASK                            0x00000004L
#define DISP_INTERRUPT_STATUS_CONTINUE21__DOUT_IHC_I2C_DDC4_HW_DONE_INTERRUPT_MASK                            0x00000008L
#define DISP_INTERRUPT_STATUS_CONTINUE21__DOUT_IHC_I2C_DDC5_HW_DONE_INTERRUPT_MASK                            0x00000010L
#define DISP_INTERRUPT_STATUS_CONTINUE21__DOUT_IHC_I2C_DDC6_HW_DONE_INTERRUPT_MASK                            0x00000020L
#define DISP_INTERRUPT_STATUS_CONTINUE21__DOUT_IHC_I2C_DDCVGA_HW_DONE_INTERRUPT_MASK                          0x00000040L
#define DISP_INTERRUPT_STATUS_CONTINUE21__DC_I2C_DDC1_READ_REQUEST_INTERRUPT_MASK                             0x00000080L
#define DISP_INTERRUPT_STATUS_CONTINUE21__DC_I2C_DDC2_READ_REQUEST_INTERRUPT_MASK                             0x00000100L
#define DISP_INTERRUPT_STATUS_CONTINUE21__DC_I2C_DDC3_READ_REQUEST_INTERRUPT_MASK                             0x00000200L
#define DISP_INTERRUPT_STATUS_CONTINUE21__DC_I2C_DDC4_READ_REQUEST_INTERRUPT_MASK                             0x00000400L
#define DISP_INTERRUPT_STATUS_CONTINUE21__DC_I2C_DDC5_READ_REQUEST_INTERRUPT_MASK                             0x00000800L
#define DISP_INTERRUPT_STATUS_CONTINUE21__DC_I2C_DDC6_READ_REQUEST_INTERRUPT_MASK                             0x00001000L
#define DISP_INTERRUPT_STATUS_CONTINUE21__DC_I2C_VGA_READ_REQUEST_INTERRUPT_MASK                              0x00002000L
#define DISP_INTERRUPT_STATUS_CONTINUE21__GENERIC_I2C_DDC_READ_REUEST_INTERRUPT_MASK                          0x00004000L
#define DISP_INTERRUPT_STATUS_CONTINUE21__DIGH_DP_FAST_TRAINING_COMPLETE_INTERRUPT_MASK                       0x10000000L
#define DISP_INTERRUPT_STATUS_CONTINUE21__DIGH_DP_VID_STREAM_DISABLE_INTERRUPT_MASK                           0x20000000L
#define DISP_INTERRUPT_STATUS_CONTINUE21__DISP_INTERRUPT_STATUS_CONTINUE22_MASK                               0x80000000L
//DISP_INTERRUPT_STATUS_CONTINUE22
#define DISP_INTERRUPT_STATUS_CONTINUE22__DCPG_IHC_DOMAIN8_POWER_UP_INTERRUPT__SHIFT                          0x0
#define DISP_INTERRUPT_STATUS_CONTINUE22__DCPG_IHC_DOMAIN9_POWER_UP_INTERRUPT__SHIFT                          0x1
#define DISP_INTERRUPT_STATUS_CONTINUE22__DCPG_IHC_DOMAIN10_POWER_UP_INTERRUPT__SHIFT                         0x2
#define DISP_INTERRUPT_STATUS_CONTINUE22__DCPG_IHC_DOMAIN11_POWER_UP_INTERRUPT__SHIFT                         0x3
#define DISP_INTERRUPT_STATUS_CONTINUE22__DCPG_IHC_DOMAIN12_POWER_UP_INTERRUPT__SHIFT                         0x4
#define DISP_INTERRUPT_STATUS_CONTINUE22__DCPG_IHC_DOMAIN13_POWER_UP_INTERRUPT__SHIFT                         0x5
#define DISP_INTERRUPT_STATUS_CONTINUE22__DCPG_IHC_DOMAIN14_POWER_UP_INTERRUPT__SHIFT                         0x6
#define DISP_INTERRUPT_STATUS_CONTINUE22__DCPG_IHC_DOMAIN15_POWER_UP_INTERRUPT__SHIFT                         0x7
#define DISP_INTERRUPT_STATUS_CONTINUE22__DCPG_IHC_DOMAIN8_POWER_DOWN_INTERRUPT__SHIFT                        0x8
#define DISP_INTERRUPT_STATUS_CONTINUE22__DCPG_IHC_DOMAIN9_POWER_DOWN_INTERRUPT__SHIFT                        0x9
#define DISP_INTERRUPT_STATUS_CONTINUE22__DCPG_IHC_DOMAIN10_POWER_DOWN_INTERRUPT__SHIFT                       0xa
#define DISP_INTERRUPT_STATUS_CONTINUE22__DCPG_IHC_DOMAIN11_POWER_DOWN_INTERRUPT__SHIFT                       0xb
#define DISP_INTERRUPT_STATUS_CONTINUE22__DCPG_IHC_DOMAIN12_POWER_DOWN_INTERRUPT__SHIFT                       0xc
#define DISP_INTERRUPT_STATUS_CONTINUE22__DCPG_IHC_DOMAIN13_POWER_DOWN_INTERRUPT__SHIFT                       0xd
#define DISP_INTERRUPT_STATUS_CONTINUE22__DCPG_IHC_DOMAIN14_POWER_DOWN_INTERRUPT__SHIFT                       0xe
#define DISP_INTERRUPT_STATUS_CONTINUE22__DCPG_IHC_DOMAIN15_POWER_DOWN_INTERRUPT__SHIFT                       0xf
#define DISP_INTERRUPT_STATUS_CONTINUE22__ABM0_HG_READY_INT__SHIFT                                            0x10
#define DISP_INTERRUPT_STATUS_CONTINUE22__ABM0_LS_READY_INT__SHIFT                                            0x11
#define DISP_INTERRUPT_STATUS_CONTINUE22__ABM0_BL_UPDATE_INT__SHIFT                                           0x12
#define DISP_INTERRUPT_STATUS_CONTINUE22__OTG0_IHC_V_UPDATE_NO_LOCK_INTERRUPT__SHIFT                          0x13
#define DISP_INTERRUPT_STATUS_CONTINUE22__OTG1_IHC_V_UPDATE_NO_LOCK_INTERRUPT__SHIFT                          0x14
#define DISP_INTERRUPT_STATUS_CONTINUE22__OTG2_IHC_V_UPDATE_NO_LOCK_INTERRUPT__SHIFT                          0x15
#define DISP_INTERRUPT_STATUS_CONTINUE22__OTG3_IHC_V_UPDATE_NO_LOCK_INTERRUPT__SHIFT                          0x16
#define DISP_INTERRUPT_STATUS_CONTINUE22__OTG4_IHC_V_UPDATE_NO_LOCK_INTERRUPT__SHIFT                          0x17
#define DISP_INTERRUPT_STATUS_CONTINUE22__OTG5_IHC_V_UPDATE_NO_LOCK_INTERRUPT__SHIFT                          0x18
#define DISP_INTERRUPT_STATUS_CONTINUE22__DCPG_IHC_DOMAIN8_POWER_UP_INTERRUPT_MASK                            0x00000001L
#define DISP_INTERRUPT_STATUS_CONTINUE22__DCPG_IHC_DOMAIN9_POWER_UP_INTERRUPT_MASK                            0x00000002L
#define DISP_INTERRUPT_STATUS_CONTINUE22__DCPG_IHC_DOMAIN10_POWER_UP_INTERRUPT_MASK                           0x00000004L
#define DISP_INTERRUPT_STATUS_CONTINUE22__DCPG_IHC_DOMAIN11_POWER_UP_INTERRUPT_MASK                           0x00000008L
#define DISP_INTERRUPT_STATUS_CONTINUE22__DCPG_IHC_DOMAIN12_POWER_UP_INTERRUPT_MASK                           0x00000010L
#define DISP_INTERRUPT_STATUS_CONTINUE22__DCPG_IHC_DOMAIN13_POWER_UP_INTERRUPT_MASK                           0x00000020L
#define DISP_INTERRUPT_STATUS_CONTINUE22__DCPG_IHC_DOMAIN14_POWER_UP_INTERRUPT_MASK                           0x00000040L
#define DISP_INTERRUPT_STATUS_CONTINUE22__DCPG_IHC_DOMAIN15_POWER_UP_INTERRUPT_MASK                           0x00000080L
#define DISP_INTERRUPT_STATUS_CONTINUE22__DCPG_IHC_DOMAIN8_POWER_DOWN_INTERRUPT_MASK                          0x00000100L
#define DISP_INTERRUPT_STATUS_CONTINUE22__DCPG_IHC_DOMAIN9_POWER_DOWN_INTERRUPT_MASK                          0x00000200L
#define DISP_INTERRUPT_STATUS_CONTINUE22__DCPG_IHC_DOMAIN10_POWER_DOWN_INTERRUPT_MASK                         0x00000400L
#define DISP_INTERRUPT_STATUS_CONTINUE22__DCPG_IHC_DOMAIN11_POWER_DOWN_INTERRUPT_MASK                         0x00000800L
#define DISP_INTERRUPT_STATUS_CONTINUE22__DCPG_IHC_DOMAIN12_POWER_DOWN_INTERRUPT_MASK                         0x00001000L
#define DISP_INTERRUPT_STATUS_CONTINUE22__DCPG_IHC_DOMAIN13_POWER_DOWN_INTERRUPT_MASK                         0x00002000L
#define DISP_INTERRUPT_STATUS_CONTINUE22__DCPG_IHC_DOMAIN14_POWER_DOWN_INTERRUPT_MASK                         0x00004000L
#define DISP_INTERRUPT_STATUS_CONTINUE22__DCPG_IHC_DOMAIN15_POWER_DOWN_INTERRUPT_MASK                         0x00008000L
#define DISP_INTERRUPT_STATUS_CONTINUE22__ABM0_HG_READY_INT_MASK                                              0x00010000L
#define DISP_INTERRUPT_STATUS_CONTINUE22__ABM0_LS_READY_INT_MASK                                              0x00020000L
#define DISP_INTERRUPT_STATUS_CONTINUE22__ABM0_BL_UPDATE_INT_MASK                                             0x00040000L
#define DISP_INTERRUPT_STATUS_CONTINUE22__OTG0_IHC_V_UPDATE_NO_LOCK_INTERRUPT_MASK                            0x00080000L
#define DISP_INTERRUPT_STATUS_CONTINUE22__OTG1_IHC_V_UPDATE_NO_LOCK_INTERRUPT_MASK                            0x00100000L
#define DISP_INTERRUPT_STATUS_CONTINUE22__OTG2_IHC_V_UPDATE_NO_LOCK_INTERRUPT_MASK                            0x00200000L
#define DISP_INTERRUPT_STATUS_CONTINUE22__OTG3_IHC_V_UPDATE_NO_LOCK_INTERRUPT_MASK                            0x00400000L
#define DISP_INTERRUPT_STATUS_CONTINUE22__OTG4_IHC_V_UPDATE_NO_LOCK_INTERRUPT_MASK                            0x00800000L
#define DISP_INTERRUPT_STATUS_CONTINUE22__OTG5_IHC_V_UPDATE_NO_LOCK_INTERRUPT_MASK                            0x01000000L
//DC_GPU_TIMER_START_POSITION_VREADY
#define DC_GPU_TIMER_START_POSITION_VREADY__DC_GPU_TIMER_START_POSITION_D1_VREADY__SHIFT                      0x0
#define DC_GPU_TIMER_START_POSITION_VREADY__DC_GPU_TIMER_START_POSITION_D2_VREADY__SHIFT                      0x4
#define DC_GPU_TIMER_START_POSITION_VREADY__DC_GPU_TIMER_START_POSITION_D3_VREADY__SHIFT                      0x8
#define DC_GPU_TIMER_START_POSITION_VREADY__DC_GPU_TIMER_START_POSITION_D4_VREADY__SHIFT                      0xc
#define DC_GPU_TIMER_START_POSITION_VREADY__DC_GPU_TIMER_START_POSITION_D5_VREADY__SHIFT                      0x10
#define DC_GPU_TIMER_START_POSITION_VREADY__DC_GPU_TIMER_START_POSITION_D6_VREADY__SHIFT                      0x14
#define DC_GPU_TIMER_START_POSITION_VREADY__DC_GPU_TIMER_START_POSITION_D1_VREADY_MASK                        0x00000007L
#define DC_GPU_TIMER_START_POSITION_VREADY__DC_GPU_TIMER_START_POSITION_D2_VREADY_MASK                        0x00000070L
#define DC_GPU_TIMER_START_POSITION_VREADY__DC_GPU_TIMER_START_POSITION_D3_VREADY_MASK                        0x00000700L
#define DC_GPU_TIMER_START_POSITION_VREADY__DC_GPU_TIMER_START_POSITION_D4_VREADY_MASK                        0x00007000L
#define DC_GPU_TIMER_START_POSITION_VREADY__DC_GPU_TIMER_START_POSITION_D5_VREADY_MASK                        0x00070000L
#define DC_GPU_TIMER_START_POSITION_VREADY__DC_GPU_TIMER_START_POSITION_D6_VREADY_MASK                        0x00700000L
//DC_GPU_TIMER_START_POSITION_FLIP
#define DC_GPU_TIMER_START_POSITION_FLIP__DC_GPU_TIMER_START_POSITION_D1_FLIP__SHIFT                          0x0
#define DC_GPU_TIMER_START_POSITION_FLIP__DC_GPU_TIMER_START_POSITION_D2_FLIP__SHIFT                          0x4
#define DC_GPU_TIMER_START_POSITION_FLIP__DC_GPU_TIMER_START_POSITION_D3_FLIP__SHIFT                          0x8
#define DC_GPU_TIMER_START_POSITION_FLIP__DC_GPU_TIMER_START_POSITION_D4_FLIP__SHIFT                          0xc
#define DC_GPU_TIMER_START_POSITION_FLIP__DC_GPU_TIMER_START_POSITION_D5_FLIP__SHIFT                          0x10
#define DC_GPU_TIMER_START_POSITION_FLIP__DC_GPU_TIMER_START_POSITION_D6_FLIP__SHIFT                          0x14
#define DC_GPU_TIMER_START_POSITION_FLIP__DC_GPU_TIMER_START_POSITION_D7_FLIP__SHIFT                          0x18
#define DC_GPU_TIMER_START_POSITION_FLIP__DC_GPU_TIMER_START_POSITION_D8_FLIP__SHIFT                          0x1c
#define DC_GPU_TIMER_START_POSITION_FLIP__DC_GPU_TIMER_START_POSITION_D1_FLIP_MASK                            0x00000007L
#define DC_GPU_TIMER_START_POSITION_FLIP__DC_GPU_TIMER_START_POSITION_D2_FLIP_MASK                            0x00000070L
#define DC_GPU_TIMER_START_POSITION_FLIP__DC_GPU_TIMER_START_POSITION_D3_FLIP_MASK                            0x00000700L
#define DC_GPU_TIMER_START_POSITION_FLIP__DC_GPU_TIMER_START_POSITION_D4_FLIP_MASK                            0x00007000L
#define DC_GPU_TIMER_START_POSITION_FLIP__DC_GPU_TIMER_START_POSITION_D5_FLIP_MASK                            0x00070000L
#define DC_GPU_TIMER_START_POSITION_FLIP__DC_GPU_TIMER_START_POSITION_D6_FLIP_MASK                            0x00700000L
#define DC_GPU_TIMER_START_POSITION_FLIP__DC_GPU_TIMER_START_POSITION_D7_FLIP_MASK                            0x07000000L
#define DC_GPU_TIMER_START_POSITION_FLIP__DC_GPU_TIMER_START_POSITION_D8_FLIP_MASK                            0x70000000L
//DC_GPU_TIMER_START_POSITION_V_UPDATE_NO_LOCK
#define DC_GPU_TIMER_START_POSITION_V_UPDATE_NO_LOCK__DC_GPU_TIMER_START_POSITION_D1_V_UPDATE_NO_LOCK__SHIFT  0x0
#define DC_GPU_TIMER_START_POSITION_V_UPDATE_NO_LOCK__DC_GPU_TIMER_START_POSITION_D2_V_UPDATE_NO_LOCK__SHIFT  0x4
#define DC_GPU_TIMER_START_POSITION_V_UPDATE_NO_LOCK__DC_GPU_TIMER_START_POSITION_D3_V_UPDATE_NO_LOCK__SHIFT  0x8
#define DC_GPU_TIMER_START_POSITION_V_UPDATE_NO_LOCK__DC_GPU_TIMER_START_POSITION_D4_V_UPDATE_NO_LOCK__SHIFT  0xc
#define DC_GPU_TIMER_START_POSITION_V_UPDATE_NO_LOCK__DC_GPU_TIMER_START_POSITION_D5_V_UPDATE_NO_LOCK__SHIFT  0x10
#define DC_GPU_TIMER_START_POSITION_V_UPDATE_NO_LOCK__DC_GPU_TIMER_START_POSITION_D6_V_UPDATE_NO_LOCK__SHIFT  0x14
#define DC_GPU_TIMER_START_POSITION_V_UPDATE_NO_LOCK__DC_GPU_TIMER_START_POSITION_D1_V_UPDATE_NO_LOCK_MASK    0x00000007L
#define DC_GPU_TIMER_START_POSITION_V_UPDATE_NO_LOCK__DC_GPU_TIMER_START_POSITION_D2_V_UPDATE_NO_LOCK_MASK    0x00000070L
#define DC_GPU_TIMER_START_POSITION_V_UPDATE_NO_LOCK__DC_GPU_TIMER_START_POSITION_D3_V_UPDATE_NO_LOCK_MASK    0x00000700L
#define DC_GPU_TIMER_START_POSITION_V_UPDATE_NO_LOCK__DC_GPU_TIMER_START_POSITION_D4_V_UPDATE_NO_LOCK_MASK    0x00007000L
#define DC_GPU_TIMER_START_POSITION_V_UPDATE_NO_LOCK__DC_GPU_TIMER_START_POSITION_D5_V_UPDATE_NO_LOCK_MASK    0x00070000L
#define DC_GPU_TIMER_START_POSITION_V_UPDATE_NO_LOCK__DC_GPU_TIMER_START_POSITION_D6_V_UPDATE_NO_LOCK_MASK    0x00700000L
//DC_GPU_TIMER_START_POSITION_FLIP_AWAY
#define DC_GPU_TIMER_START_POSITION_FLIP_AWAY__DC_GPU_TIMER_START_POSITION_D1_FLIP_AWAY__SHIFT                0x0
#define DC_GPU_TIMER_START_POSITION_FLIP_AWAY__DC_GPU_TIMER_START_POSITION_D2_FLIP_AWAY__SHIFT                0x4
#define DC_GPU_TIMER_START_POSITION_FLIP_AWAY__DC_GPU_TIMER_START_POSITION_D3_FLIP_AWAY__SHIFT                0x8
#define DC_GPU_TIMER_START_POSITION_FLIP_AWAY__DC_GPU_TIMER_START_POSITION_D4_FLIP_AWAY__SHIFT                0xc
#define DC_GPU_TIMER_START_POSITION_FLIP_AWAY__DC_GPU_TIMER_START_POSITION_D5_FLIP_AWAY__SHIFT                0x10
#define DC_GPU_TIMER_START_POSITION_FLIP_AWAY__DC_GPU_TIMER_START_POSITION_D6_FLIP_AWAY__SHIFT                0x14
#define DC_GPU_TIMER_START_POSITION_FLIP_AWAY__DC_GPU_TIMER_START_POSITION_D7_FLIP_AWAY__SHIFT                0x18
#define DC_GPU_TIMER_START_POSITION_FLIP_AWAY__DC_GPU_TIMER_START_POSITION_D8_FLIP_AWAY__SHIFT                0x1c
#define DC_GPU_TIMER_START_POSITION_FLIP_AWAY__DC_GPU_TIMER_START_POSITION_D1_FLIP_AWAY_MASK                  0x00000007L
#define DC_GPU_TIMER_START_POSITION_FLIP_AWAY__DC_GPU_TIMER_START_POSITION_D2_FLIP_AWAY_MASK                  0x00000070L
#define DC_GPU_TIMER_START_POSITION_FLIP_AWAY__DC_GPU_TIMER_START_POSITION_D3_FLIP_AWAY_MASK                  0x00000700L
#define DC_GPU_TIMER_START_POSITION_FLIP_AWAY__DC_GPU_TIMER_START_POSITION_D4_FLIP_AWAY_MASK                  0x00007000L
#define DC_GPU_TIMER_START_POSITION_FLIP_AWAY__DC_GPU_TIMER_START_POSITION_D5_FLIP_AWAY_MASK                  0x00070000L
#define DC_GPU_TIMER_START_POSITION_FLIP_AWAY__DC_GPU_TIMER_START_POSITION_D6_FLIP_AWAY_MASK                  0x00700000L
#define DC_GPU_TIMER_START_POSITION_FLIP_AWAY__DC_GPU_TIMER_START_POSITION_D7_FLIP_AWAY_MASK                  0x07000000L
#define DC_GPU_TIMER_START_POSITION_FLIP_AWAY__DC_GPU_TIMER_START_POSITION_D8_FLIP_AWAY_MASK                  0x70000000L


// addressBlock: dce_dc_wb0_dispdec_cnv_dispdec
//CNV0_WB_ENABLE
#define CNV0_WB_ENABLE__WB_ENABLE__SHIFT                                                                      0x0
#define CNV0_WB_ENABLE__WB_ENABLE_MASK                                                                        0x00000001L
//CNV0_WB_EC_CONFIG
#define CNV0_WB_EC_CONFIG__DISPCLK_R_WB_GATE_DIS__SHIFT                                                       0x0
#define CNV0_WB_EC_CONFIG__DISPCLK_G_WB_GATE_DIS__SHIFT                                                       0x1
#define CNV0_WB_EC_CONFIG__DISPCLK_G_WBSCL_GATE_DIS__SHIFT                                                    0x2
#define CNV0_WB_EC_CONFIG__WB_TEST_CLK_SEL__SHIFT                                                             0x3
#define CNV0_WB_EC_CONFIG__WB_LB_LS_DIS__SHIFT                                                                0x7
#define CNV0_WB_EC_CONFIG__WB_LB_SD_DIS__SHIFT                                                                0x8
#define CNV0_WB_EC_CONFIG__WB_LUT_LS_DIS__SHIFT                                                               0x9
#define CNV0_WB_EC_CONFIG__WBSCL_LB_MEM_PWR_MODE_SEL__SHIFT                                                   0xc
#define CNV0_WB_EC_CONFIG__WBSCL_LB_MEM_PWR_DIS__SHIFT                                                        0xe
#define CNV0_WB_EC_CONFIG__WBSCL_LB_MEM_PWR_FORCE__SHIFT                                                      0xf
#define CNV0_WB_EC_CONFIG__WBSCL_LB_MEM_PWR_STATE_SM__SHIFT                                                   0x11
#define CNV0_WB_EC_CONFIG__WBSCL_LB_MEM_PWR_STATE_BG__SHIFT                                                   0x13
#define CNV0_WB_EC_CONFIG__WBSCL_LB_MEM_PWR_STATE__SHIFT                                                      0x15
#define CNV0_WB_EC_CONFIG__WB_RAM_PW_SAVE_MODE__SHIFT                                                         0x17
#define CNV0_WB_EC_CONFIG__LB_MEM_PWR_STATE_SM__SHIFT                                                         0x18
#define CNV0_WB_EC_CONFIG__LB_MEM_PWR_STATE_BG__SHIFT                                                         0x1a
#define CNV0_WB_EC_CONFIG__LB_MEM_PWR_STATE__SHIFT                                                            0x1c
#define CNV0_WB_EC_CONFIG__LUT_MEM_PWR_STATE__SHIFT                                                           0x1e
#define CNV0_WB_EC_CONFIG__DISPCLK_R_WB_GATE_DIS_MASK                                                         0x00000001L
#define CNV0_WB_EC_CONFIG__DISPCLK_G_WB_GATE_DIS_MASK                                                         0x00000002L
#define CNV0_WB_EC_CONFIG__DISPCLK_G_WBSCL_GATE_DIS_MASK                                                      0x00000004L
#define CNV0_WB_EC_CONFIG__WB_TEST_CLK_SEL_MASK                                                               0x00000078L
#define CNV0_WB_EC_CONFIG__WB_LB_LS_DIS_MASK                                                                  0x00000080L
#define CNV0_WB_EC_CONFIG__WB_LB_SD_DIS_MASK                                                                  0x00000100L
#define CNV0_WB_EC_CONFIG__WB_LUT_LS_DIS_MASK                                                                 0x00000200L
#define CNV0_WB_EC_CONFIG__WBSCL_LB_MEM_PWR_MODE_SEL_MASK                                                     0x00003000L
#define CNV0_WB_EC_CONFIG__WBSCL_LB_MEM_PWR_DIS_MASK                                                          0x00004000L
#define CNV0_WB_EC_CONFIG__WBSCL_LB_MEM_PWR_FORCE_MASK                                                        0x00018000L
#define CNV0_WB_EC_CONFIG__WBSCL_LB_MEM_PWR_STATE_SM_MASK                                                     0x00060000L
#define CNV0_WB_EC_CONFIG__WBSCL_LB_MEM_PWR_STATE_BG_MASK                                                     0x00180000L
#define CNV0_WB_EC_CONFIG__WBSCL_LB_MEM_PWR_STATE_MASK                                                        0x00600000L
#define CNV0_WB_EC_CONFIG__WB_RAM_PW_SAVE_MODE_MASK                                                           0x00800000L
#define CNV0_WB_EC_CONFIG__LB_MEM_PWR_STATE_SM_MASK                                                           0x03000000L
#define CNV0_WB_EC_CONFIG__LB_MEM_PWR_STATE_BG_MASK                                                           0x0C000000L
#define CNV0_WB_EC_CONFIG__LB_MEM_PWR_STATE_MASK                                                              0x30000000L
#define CNV0_WB_EC_CONFIG__LUT_MEM_PWR_STATE_MASK                                                             0xC0000000L
//CNV0_CNV_MODE
#define CNV0_CNV_MODE__CNV_FRAME_CAPTURE_RATE__SHIFT                                                          0x8
#define CNV0_CNV_MODE__CNV_WINDOW_CROP_EN__SHIFT                                                              0xc
#define CNV0_CNV_MODE__CNV_STEREO_TYPE__SHIFT                                                                 0xd
#define CNV0_CNV_MODE__CNV_INTERLACED_MODE__SHIFT                                                             0xf
#define CNV0_CNV_MODE__CNV_EYE_SELECTION__SHIFT                                                               0x10
#define CNV0_CNV_MODE__CNV_STEREO_POLARITY__SHIFT                                                             0x12
#define CNV0_CNV_MODE__CNV_INTERLACED_FIELD_ORDER__SHIFT                                                      0x13
#define CNV0_CNV_MODE__CNV_STEREO_SPLIT__SHIFT                                                                0x14
#define CNV0_CNV_MODE__CNV_NEW_CONTENT__SHIFT                                                                 0x18
#define CNV0_CNV_MODE__CNV_FRAME_CAPTURE_EN__SHIFT                                                            0x1f
#define CNV0_CNV_MODE__CNV_FRAME_CAPTURE_RATE_MASK                                                            0x00000300L
#define CNV0_CNV_MODE__CNV_WINDOW_CROP_EN_MASK                                                                0x00001000L
#define CNV0_CNV_MODE__CNV_STEREO_TYPE_MASK                                                                   0x00006000L
#define CNV0_CNV_MODE__CNV_INTERLACED_MODE_MASK                                                               0x00008000L
#define CNV0_CNV_MODE__CNV_EYE_SELECTION_MASK                                                                 0x00030000L
#define CNV0_CNV_MODE__CNV_STEREO_POLARITY_MASK                                                               0x00040000L
#define CNV0_CNV_MODE__CNV_INTERLACED_FIELD_ORDER_MASK                                                        0x00080000L
#define CNV0_CNV_MODE__CNV_STEREO_SPLIT_MASK                                                                  0x00100000L
#define CNV0_CNV_MODE__CNV_NEW_CONTENT_MASK                                                                   0x01000000L
#define CNV0_CNV_MODE__CNV_FRAME_CAPTURE_EN_MASK                                                              0x80000000L
//CNV0_CNV_WINDOW_START
#define CNV0_CNV_WINDOW_START__CNV_WINDOW_START_X__SHIFT                                                      0x0
#define CNV0_CNV_WINDOW_START__CNV_WINDOW_START_Y__SHIFT                                                      0x10
#define CNV0_CNV_WINDOW_START__CNV_WINDOW_START_X_MASK                                                        0x00000FFFL
#define CNV0_CNV_WINDOW_START__CNV_WINDOW_START_Y_MASK                                                        0x0FFF0000L
//CNV0_CNV_WINDOW_SIZE
#define CNV0_CNV_WINDOW_SIZE__CNV_WINDOW_WIDTH__SHIFT                                                         0x0
#define CNV0_CNV_WINDOW_SIZE__CNV_WINDOW_HEIGHT__SHIFT                                                        0x10
#define CNV0_CNV_WINDOW_SIZE__CNV_WINDOW_WIDTH_MASK                                                           0x00000FFFL
#define CNV0_CNV_WINDOW_SIZE__CNV_WINDOW_HEIGHT_MASK                                                          0x0FFF0000L
//CNV0_CNV_UPDATE
#define CNV0_CNV_UPDATE__CNV_UPDATE_PENDING__SHIFT                                                            0x0
#define CNV0_CNV_UPDATE__CNV_UPDATE_TAKEN__SHIFT                                                              0x8
#define CNV0_CNV_UPDATE__CNV_UPDATE_LOCK__SHIFT                                                               0x10
#define CNV0_CNV_UPDATE__CNV_UPDATE_PENDING_MASK                                                              0x00000001L
#define CNV0_CNV_UPDATE__CNV_UPDATE_TAKEN_MASK                                                                0x00000100L
#define CNV0_CNV_UPDATE__CNV_UPDATE_LOCK_MASK                                                                 0x00010000L
//CNV0_CNV_SOURCE_SIZE
#define CNV0_CNV_SOURCE_SIZE__CNV_SOURCE_WIDTH__SHIFT                                                         0x0
#define CNV0_CNV_SOURCE_SIZE__CNV_SOURCE_HEIGHT__SHIFT                                                        0x10
#define CNV0_CNV_SOURCE_SIZE__CNV_SOURCE_WIDTH_MASK                                                           0x00007FFFL
#define CNV0_CNV_SOURCE_SIZE__CNV_SOURCE_HEIGHT_MASK                                                          0x7FFF0000L
//CNV0_CNV_CSC_CONTROL
#define CNV0_CNV_CSC_CONTROL__CNV_CSC_BYPASS__SHIFT                                                           0x0
#define CNV0_CNV_CSC_CONTROL__CNV_CSC_BYPASS_MASK                                                             0x00000001L
//CNV0_CNV_CSC_C11_C12
#define CNV0_CNV_CSC_C11_C12__CNV_CSC_C11__SHIFT                                                              0x0
#define CNV0_CNV_CSC_C11_C12__CNV_CSC_C12__SHIFT                                                              0x10
#define CNV0_CNV_CSC_C11_C12__CNV_CSC_C11_MASK                                                                0x00001FFFL
#define CNV0_CNV_CSC_C11_C12__CNV_CSC_C12_MASK                                                                0x1FFF0000L
//CNV0_CNV_CSC_C13_C14
#define CNV0_CNV_CSC_C13_C14__CNV_CSC_C13__SHIFT                                                              0x0
#define CNV0_CNV_CSC_C13_C14__CNV_CSC_C14__SHIFT                                                              0x10
#define CNV0_CNV_CSC_C13_C14__CNV_CSC_C13_MASK                                                                0x00001FFFL
#define CNV0_CNV_CSC_C13_C14__CNV_CSC_C14_MASK                                                                0x7FFF0000L
//CNV0_CNV_CSC_C21_C22
#define CNV0_CNV_CSC_C21_C22__CNV_CSC_C21__SHIFT                                                              0x0
#define CNV0_CNV_CSC_C21_C22__CNV_CSC_C22__SHIFT                                                              0x10
#define CNV0_CNV_CSC_C21_C22__CNV_CSC_C21_MASK                                                                0x00001FFFL
#define CNV0_CNV_CSC_C21_C22__CNV_CSC_C22_MASK                                                                0x1FFF0000L
//CNV0_CNV_CSC_C23_C24
#define CNV0_CNV_CSC_C23_C24__CNV_CSC_C23__SHIFT                                                              0x0
#define CNV0_CNV_CSC_C23_C24__CNV_CSC_C24__SHIFT                                                              0x10
#define CNV0_CNV_CSC_C23_C24__CNV_CSC_C23_MASK                                                                0x00001FFFL
#define CNV0_CNV_CSC_C23_C24__CNV_CSC_C24_MASK                                                                0x7FFF0000L
//CNV0_CNV_CSC_C31_C32
#define CNV0_CNV_CSC_C31_C32__CNV_CSC_C31__SHIFT                                                              0x0
#define CNV0_CNV_CSC_C31_C32__CNV_CSC_C32__SHIFT                                                              0x10
#define CNV0_CNV_CSC_C31_C32__CNV_CSC_C31_MASK                                                                0x00001FFFL
#define CNV0_CNV_CSC_C31_C32__CNV_CSC_C32_MASK                                                                0x1FFF0000L
//CNV0_CNV_CSC_C33_C34
#define CNV0_CNV_CSC_C33_C34__CNV_CSC_C33__SHIFT                                                              0x0
#define CNV0_CNV_CSC_C33_C34__CNV_CSC_C34__SHIFT                                                              0x10
#define CNV0_CNV_CSC_C33_C34__CNV_CSC_C33_MASK                                                                0x00001FFFL
#define CNV0_CNV_CSC_C33_C34__CNV_CSC_C34_MASK                                                                0x7FFF0000L
//CNV0_CNV_CSC_ROUND_OFFSET_R
#define CNV0_CNV_CSC_ROUND_OFFSET_R__CNV_CSC_ROUND_OFFSET_R__SHIFT                                            0x0
#define CNV0_CNV_CSC_ROUND_OFFSET_R__CNV_CSC_ROUND_OFFSET_R_MASK                                              0x0000FFFFL
//CNV0_CNV_CSC_ROUND_OFFSET_G
#define CNV0_CNV_CSC_ROUND_OFFSET_G__CNV_CSC_ROUND_OFFSET_G__SHIFT                                            0x0
#define CNV0_CNV_CSC_ROUND_OFFSET_G__CNV_CSC_ROUND_OFFSET_G_MASK                                              0x0000FFFFL
//CNV0_CNV_CSC_ROUND_OFFSET_B
#define CNV0_CNV_CSC_ROUND_OFFSET_B__CNV_CSC_ROUND_OFFSET_B__SHIFT                                            0x0
#define CNV0_CNV_CSC_ROUND_OFFSET_B__CNV_CSC_ROUND_OFFSET_B_MASK                                              0x0000FFFFL
//CNV0_CNV_CSC_CLAMP_R
#define CNV0_CNV_CSC_CLAMP_R__CNV_CSC_CLAMP_UPPER_R__SHIFT                                                    0x0
#define CNV0_CNV_CSC_CLAMP_R__CNV_CSC_CLAMP_LOWER_R__SHIFT                                                    0x10
#define CNV0_CNV_CSC_CLAMP_R__CNV_CSC_CLAMP_UPPER_R_MASK                                                      0x0000FFFFL
#define CNV0_CNV_CSC_CLAMP_R__CNV_CSC_CLAMP_LOWER_R_MASK                                                      0xFFFF0000L
//CNV0_CNV_CSC_CLAMP_G
#define CNV0_CNV_CSC_CLAMP_G__CNV_CSC_CLAMP_UPPER_G__SHIFT                                                    0x0
#define CNV0_CNV_CSC_CLAMP_G__CNV_CSC_CLAMP_LOWER_G__SHIFT                                                    0x10
#define CNV0_CNV_CSC_CLAMP_G__CNV_CSC_CLAMP_UPPER_G_MASK                                                      0x0000FFFFL
#define CNV0_CNV_CSC_CLAMP_G__CNV_CSC_CLAMP_LOWER_G_MASK                                                      0xFFFF0000L
//CNV0_CNV_CSC_CLAMP_B
#define CNV0_CNV_CSC_CLAMP_B__CNV_CSC_CLAMP_UPPER_B__SHIFT                                                    0x0
#define CNV0_CNV_CSC_CLAMP_B__CNV_CSC_CLAMP_LOWER_B__SHIFT                                                    0x10
#define CNV0_CNV_CSC_CLAMP_B__CNV_CSC_CLAMP_UPPER_B_MASK                                                      0x0000FFFFL
#define CNV0_CNV_CSC_CLAMP_B__CNV_CSC_CLAMP_LOWER_B_MASK                                                      0xFFFF0000L
//CNV0_CNV_TEST_CNTL
#define CNV0_CNV_TEST_CNTL__CNV_TEST_CRC_EN__SHIFT                                                            0x4
#define CNV0_CNV_TEST_CNTL__CNV_TEST_CRC_CONT_EN__SHIFT                                                       0x8
#define CNV0_CNV_TEST_CNTL__CNV_TEST_CRC_DE_ONLY__SHIFT                                                       0x10
#define CNV0_CNV_TEST_CNTL__CNV_TEST_CRC_EN_MASK                                                              0x00000010L
#define CNV0_CNV_TEST_CNTL__CNV_TEST_CRC_CONT_EN_MASK                                                         0x00000100L
#define CNV0_CNV_TEST_CNTL__CNV_TEST_CRC_DE_ONLY_MASK                                                         0x00010000L
//CNV0_CNV_TEST_CRC_RED
#define CNV0_CNV_TEST_CRC_RED__CNV_TEST_CRC_RED_MASK__SHIFT                                                   0x4
#define CNV0_CNV_TEST_CRC_RED__CNV_TEST_CRC_SIG_RED__SHIFT                                                    0x10
#define CNV0_CNV_TEST_CRC_RED__CNV_TEST_CRC_RED_MASK_MASK                                                     0x0000FFF0L
#define CNV0_CNV_TEST_CRC_RED__CNV_TEST_CRC_SIG_RED_MASK                                                      0xFFFF0000L
//CNV0_CNV_TEST_CRC_GREEN
#define CNV0_CNV_TEST_CRC_GREEN__CNV_TEST_CRC_GREEN_MASK__SHIFT                                               0x4
#define CNV0_CNV_TEST_CRC_GREEN__CNV_TEST_CRC_SIG_GREEN__SHIFT                                                0x10
#define CNV0_CNV_TEST_CRC_GREEN__CNV_TEST_CRC_GREEN_MASK_MASK                                                 0x0000FFF0L
#define CNV0_CNV_TEST_CRC_GREEN__CNV_TEST_CRC_SIG_GREEN_MASK                                                  0xFFFF0000L
//CNV0_CNV_TEST_CRC_BLUE
#define CNV0_CNV_TEST_CRC_BLUE__CNV_TEST_CRC_BLUE_MASK__SHIFT                                                 0x4
#define CNV0_CNV_TEST_CRC_BLUE__CNV_TEST_CRC_SIG_BLUE__SHIFT                                                  0x10
#define CNV0_CNV_TEST_CRC_BLUE__CNV_TEST_CRC_BLUE_MASK_MASK                                                   0x0000FFF0L
#define CNV0_CNV_TEST_CRC_BLUE__CNV_TEST_CRC_SIG_BLUE_MASK                                                    0xFFFF0000L
//CNV0_CNV_INPUT_SELECT
#define CNV0_CNV_INPUT_SELECT__CNV_INPUT_SRC_SELECT__SHIFT                                                    0x0
#define CNV0_CNV_INPUT_SELECT__CNV_INPUT_PIPE_SELECT__SHIFT                                                   0x2
#define CNV0_CNV_INPUT_SELECT__CNV_INPUT_SRC_SELECT_MASK                                                      0x00000003L
#define CNV0_CNV_INPUT_SELECT__CNV_INPUT_PIPE_SELECT_MASK                                                     0x0000001CL
//CNV0_WB_SOFT_RESET
#define CNV0_WB_SOFT_RESET__WB_SOFT_RESET__SHIFT                                                              0x0
#define CNV0_WB_SOFT_RESET__WB_SOFT_RESET_MASK                                                                0x00000001L
//CNV0_WB_WARM_UP_MODE_CTL1
#define CNV0_WB_WARM_UP_MODE_CTL1__WIDTH_WARMUP__SHIFT                                                        0x0
#define CNV0_WB_WARM_UP_MODE_CTL1__HEIGHT_WARMUP__SHIFT                                                       0x10
#define CNV0_WB_WARM_UP_MODE_CTL1__GMC_WARM_UP_ENABLE__SHIFT                                                  0x1f
#define CNV0_WB_WARM_UP_MODE_CTL1__WIDTH_WARMUP_MASK                                                          0x00007FFFL
#define CNV0_WB_WARM_UP_MODE_CTL1__HEIGHT_WARMUP_MASK                                                         0x7FFF0000L
#define CNV0_WB_WARM_UP_MODE_CTL1__GMC_WARM_UP_ENABLE_MASK                                                    0x80000000L
//CNV0_WB_WARM_UP_MODE_CTL2
#define CNV0_WB_WARM_UP_MODE_CTL2__DATA_VALUE_WARMUP__SHIFT                                                   0x0
#define CNV0_WB_WARM_UP_MODE_CTL2__MODE_WARMUP__SHIFT                                                         0x8
#define CNV0_WB_WARM_UP_MODE_CTL2__DATA_VALUE_WARMUP_MASK                                                     0x000000FFL
#define CNV0_WB_WARM_UP_MODE_CTL2__MODE_WARMUP_MASK                                                           0x00000100L


// addressBlock: dce_dc_wb0_dispdec_wbscl_dispdec
//WBSCL0_WBSCL_COEF_RAM_SELECT
#define WBSCL0_WBSCL_COEF_RAM_SELECT__WBSCL_COEF_RAM_TAP_PAIR_IDX__SHIFT                                      0x0
#define WBSCL0_WBSCL_COEF_RAM_SELECT__WBSCL_COEF_RAM_PHASE__SHIFT                                             0x8
#define WBSCL0_WBSCL_COEF_RAM_SELECT__WBSCL_COEF_RAM_FILTER_TYPE__SHIFT                                       0x10
#define WBSCL0_WBSCL_COEF_RAM_SELECT__WBSCL_COEF_RAM_TAP_PAIR_IDX_MASK                                        0x00000007L
#define WBSCL0_WBSCL_COEF_RAM_SELECT__WBSCL_COEF_RAM_PHASE_MASK                                               0x00000F00L
#define WBSCL0_WBSCL_COEF_RAM_SELECT__WBSCL_COEF_RAM_FILTER_TYPE_MASK                                         0x00030000L
//WBSCL0_WBSCL_COEF_RAM_TAP_DATA
#define WBSCL0_WBSCL_COEF_RAM_TAP_DATA__WBSCL_COEF_RAM_EVEN_TAP_COEF__SHIFT                                   0x0
#define WBSCL0_WBSCL_COEF_RAM_TAP_DATA__WBSCL_COEF_RAM_EVEN_TAP_COEF_EN__SHIFT                                0xf
#define WBSCL0_WBSCL_COEF_RAM_TAP_DATA__WBSCL_COEF_RAM_ODD_TAP_COEF__SHIFT                                    0x10
#define WBSCL0_WBSCL_COEF_RAM_TAP_DATA__WBSCL_COEF_RAM_ODD_TAP_COEF_EN__SHIFT                                 0x1f
#define WBSCL0_WBSCL_COEF_RAM_TAP_DATA__WBSCL_COEF_RAM_EVEN_TAP_COEF_MASK                                     0x00003FFFL
#define WBSCL0_WBSCL_COEF_RAM_TAP_DATA__WBSCL_COEF_RAM_EVEN_TAP_COEF_EN_MASK                                  0x00008000L
#define WBSCL0_WBSCL_COEF_RAM_TAP_DATA__WBSCL_COEF_RAM_ODD_TAP_COEF_MASK                                      0x3FFF0000L
#define WBSCL0_WBSCL_COEF_RAM_TAP_DATA__WBSCL_COEF_RAM_ODD_TAP_COEF_EN_MASK                                   0x80000000L
//WBSCL0_WBSCL_MODE
#define WBSCL0_WBSCL_MODE__WBSCL_MODE__SHIFT                                                                  0x0
#define WBSCL0_WBSCL_MODE__WBSCL_MODE_MASK                                                                    0x00000003L
//WBSCL0_WBSCL_TAP_CONTROL
#define WBSCL0_WBSCL_TAP_CONTROL__WBSCL_V_NUM_OF_TAPS_Y_RGB__SHIFT                                            0x0
#define WBSCL0_WBSCL_TAP_CONTROL__WBSCL_V_NUM_OF_TAPS_CBCR__SHIFT                                             0x4
#define WBSCL0_WBSCL_TAP_CONTROL__WBSCL_H_NUM_OF_TAPS_Y_RGB__SHIFT                                            0x8
#define WBSCL0_WBSCL_TAP_CONTROL__WBSCL_H_NUM_OF_TAPS_CBCR__SHIFT                                             0xc
#define WBSCL0_WBSCL_TAP_CONTROL__WBSCL_V_NUM_OF_TAPS_Y_RGB_MASK                                              0x0000000FL
#define WBSCL0_WBSCL_TAP_CONTROL__WBSCL_V_NUM_OF_TAPS_CBCR_MASK                                               0x000000F0L
#define WBSCL0_WBSCL_TAP_CONTROL__WBSCL_H_NUM_OF_TAPS_Y_RGB_MASK                                              0x00000F00L
#define WBSCL0_WBSCL_TAP_CONTROL__WBSCL_H_NUM_OF_TAPS_CBCR_MASK                                               0x0000F000L
//WBSCL0_WBSCL_DEST_SIZE
#define WBSCL0_WBSCL_DEST_SIZE__WBSCL_DEST_HEIGHT__SHIFT                                                      0x0
#define WBSCL0_WBSCL_DEST_SIZE__WBSCL_DEST_WIDTH__SHIFT                                                       0x10
#define WBSCL0_WBSCL_DEST_SIZE__WBSCL_DEST_HEIGHT_MASK                                                        0x00007FFFL
#define WBSCL0_WBSCL_DEST_SIZE__WBSCL_DEST_WIDTH_MASK                                                         0x7FFF0000L
//WBSCL0_WBSCL_HORZ_FILTER_SCALE_RATIO
#define WBSCL0_WBSCL_HORZ_FILTER_SCALE_RATIO__WBSCL_H_SCALE_RATIO__SHIFT                                      0x0
#define WBSCL0_WBSCL_HORZ_FILTER_SCALE_RATIO__WBSCL_H_SCALE_RATIO_MASK                                        0x07FFFFFFL
//WBSCL0_WBSCL_HORZ_FILTER_INIT_Y_RGB
#define WBSCL0_WBSCL_HORZ_FILTER_INIT_Y_RGB__WBSCL_H_INIT_FRAC_Y_RGB__SHIFT                                   0x0
#define WBSCL0_WBSCL_HORZ_FILTER_INIT_Y_RGB__WBSCL_H_INIT_INT_Y_RGB__SHIFT                                    0x18
#define WBSCL0_WBSCL_HORZ_FILTER_INIT_Y_RGB__WBSCL_H_INIT_FRAC_Y_RGB_MASK                                     0x00FFFFFFL
#define WBSCL0_WBSCL_HORZ_FILTER_INIT_Y_RGB__WBSCL_H_INIT_INT_Y_RGB_MASK                                      0x1F000000L
//WBSCL0_WBSCL_HORZ_FILTER_INIT_CBCR
#define WBSCL0_WBSCL_HORZ_FILTER_INIT_CBCR__WBSCL_H_INIT_FRAC_CBCR__SHIFT                                     0x0
#define WBSCL0_WBSCL_HORZ_FILTER_INIT_CBCR__WBSCL_H_INIT_INT_CBCR__SHIFT                                      0x18
#define WBSCL0_WBSCL_HORZ_FILTER_INIT_CBCR__WBSCL_H_INIT_FRAC_CBCR_MASK                                       0x00FFFFFFL
#define WBSCL0_WBSCL_HORZ_FILTER_INIT_CBCR__WBSCL_H_INIT_INT_CBCR_MASK                                        0x1F000000L
//WBSCL0_WBSCL_VERT_FILTER_SCALE_RATIO
#define WBSCL0_WBSCL_VERT_FILTER_SCALE_RATIO__WBSCL_V_SCALE_RATIO__SHIFT                                      0x0
#define WBSCL0_WBSCL_VERT_FILTER_SCALE_RATIO__WBSCL_V_SCALE_RATIO_MASK                                        0x07FFFFFFL
//WBSCL0_WBSCL_VERT_FILTER_INIT_Y_RGB
#define WBSCL0_WBSCL_VERT_FILTER_INIT_Y_RGB__WBSCL_V_INIT_FRAC_Y_RGB__SHIFT                                   0x0
#define WBSCL0_WBSCL_VERT_FILTER_INIT_Y_RGB__WBSCL_V_INIT_INT_Y_RGB__SHIFT                                    0x18
#define WBSCL0_WBSCL_VERT_FILTER_INIT_Y_RGB__WBSCL_V_INIT_FRAC_Y_RGB_MASK                                     0x00FFFFFFL
#define WBSCL0_WBSCL_VERT_FILTER_INIT_Y_RGB__WBSCL_V_INIT_INT_Y_RGB_MASK                                      0x1F000000L
//WBSCL0_WBSCL_VERT_FILTER_INIT_CBCR
#define WBSCL0_WBSCL_VERT_FILTER_INIT_CBCR__WBSCL_V_INIT_FRAC_CBCR__SHIFT                                     0x0
#define WBSCL0_WBSCL_VERT_FILTER_INIT_CBCR__WBSCL_V_INIT_INT_CBCR__SHIFT                                      0x18
#define WBSCL0_WBSCL_VERT_FILTER_INIT_CBCR__WBSCL_V_INIT_FRAC_CBCR_MASK                                       0x00FFFFFFL
#define WBSCL0_WBSCL_VERT_FILTER_INIT_CBCR__WBSCL_V_INIT_INT_CBCR_MASK                                        0x1F000000L
//WBSCL0_WBSCL_ROUND_OFFSET
#define WBSCL0_WBSCL_ROUND_OFFSET__WBSCL_ROUND_OFFSET_Y_RGB__SHIFT                                            0x0
#define WBSCL0_WBSCL_ROUND_OFFSET__WBSCL_ROUND_OFFSET_CBCR__SHIFT                                             0x10
#define WBSCL0_WBSCL_ROUND_OFFSET__WBSCL_ROUND_OFFSET_Y_RGB_MASK                                              0x0000FFFFL
#define WBSCL0_WBSCL_ROUND_OFFSET__WBSCL_ROUND_OFFSET_CBCR_MASK                                               0xFFFF0000L
//WBSCL0_WBSCL_CLAMP
#define WBSCL0_WBSCL_CLAMP__WBSCL_CLAMP_UPPER_Y_RGB__SHIFT                                                    0x0
#define WBSCL0_WBSCL_CLAMP__WBSCL_CLAMP_LOWER_Y_RGB__SHIFT                                                    0x8
#define WBSCL0_WBSCL_CLAMP__WBSCL_CLAMP_UPPER_CBCR__SHIFT                                                     0x10
#define WBSCL0_WBSCL_CLAMP__WBSCL_CLAMP_LOWER_CBCR__SHIFT                                                     0x18
#define WBSCL0_WBSCL_CLAMP__WBSCL_CLAMP_UPPER_Y_RGB_MASK                                                      0x000000FFL
#define WBSCL0_WBSCL_CLAMP__WBSCL_CLAMP_LOWER_Y_RGB_MASK                                                      0x0000FF00L
#define WBSCL0_WBSCL_CLAMP__WBSCL_CLAMP_UPPER_CBCR_MASK                                                       0x00FF0000L
#define WBSCL0_WBSCL_CLAMP__WBSCL_CLAMP_LOWER_CBCR_MASK                                                       0xFF000000L
//WBSCL0_WBSCL_OVERFLOW_STATUS
#define WBSCL0_WBSCL_OVERFLOW_STATUS__WBSCL_DATA_OVERFLOW_FLAG__SHIFT                                         0x0
#define WBSCL0_WBSCL_OVERFLOW_STATUS__WBSCL_DATA_OVERFLOW_ACK__SHIFT                                          0x8
#define WBSCL0_WBSCL_OVERFLOW_STATUS__WBSCL_DATA_OVERFLOW_MASK__SHIFT                                         0xc
#define WBSCL0_WBSCL_OVERFLOW_STATUS__WBSCL_DATA_OVERFLOW_INT_STATUS__SHIFT                                   0x10
#define WBSCL0_WBSCL_OVERFLOW_STATUS__WBSCL_DATA_OVERFLOW_INT_TYPE__SHIFT                                     0x14
#define WBSCL0_WBSCL_OVERFLOW_STATUS__WBSCL_DATA_OVERFLOW_FLAG_MASK                                           0x00000001L
#define WBSCL0_WBSCL_OVERFLOW_STATUS__WBSCL_DATA_OVERFLOW_ACK_MASK                                            0x00000100L
#define WBSCL0_WBSCL_OVERFLOW_STATUS__WBSCL_DATA_OVERFLOW_MASK_MASK                                           0x00001000L
#define WBSCL0_WBSCL_OVERFLOW_STATUS__WBSCL_DATA_OVERFLOW_INT_STATUS_MASK                                     0x00010000L
#define WBSCL0_WBSCL_OVERFLOW_STATUS__WBSCL_DATA_OVERFLOW_INT_TYPE_MASK                                       0x00100000L
//WBSCL0_WBSCL_COEF_RAM_CONFLICT_STATUS
#define WBSCL0_WBSCL_COEF_RAM_CONFLICT_STATUS__WBSCL_HOST_CONFLICT_FLAG__SHIFT                                0x0
#define WBSCL0_WBSCL_COEF_RAM_CONFLICT_STATUS__WBSCL_HOST_CONFLICT_ACK__SHIFT                                 0x8
#define WBSCL0_WBSCL_COEF_RAM_CONFLICT_STATUS__WBSCL_HOST_CONFLICT_MASK__SHIFT                                0xc
#define WBSCL0_WBSCL_COEF_RAM_CONFLICT_STATUS__WBSCL_HOST_CONFLICT_INT_STATUS__SHIFT                          0x10
#define WBSCL0_WBSCL_COEF_RAM_CONFLICT_STATUS__WBSCL_HOST_CONFLICT_INT_TYPE__SHIFT                            0x14
#define WBSCL0_WBSCL_COEF_RAM_CONFLICT_STATUS__WBSCL_HOST_CONFLICT_FLAG_MASK                                  0x00000001L
#define WBSCL0_WBSCL_COEF_RAM_CONFLICT_STATUS__WBSCL_HOST_CONFLICT_ACK_MASK                                   0x00000100L
#define WBSCL0_WBSCL_COEF_RAM_CONFLICT_STATUS__WBSCL_HOST_CONFLICT_MASK_MASK                                  0x00001000L
#define WBSCL0_WBSCL_COEF_RAM_CONFLICT_STATUS__WBSCL_HOST_CONFLICT_INT_STATUS_MASK                            0x00010000L
#define WBSCL0_WBSCL_COEF_RAM_CONFLICT_STATUS__WBSCL_HOST_CONFLICT_INT_TYPE_MASK                              0x00100000L
//WBSCL0_WBSCL_OUTSIDE_PIX_STRATEGY
#define WBSCL0_WBSCL_OUTSIDE_PIX_STRATEGY__WBSCL_OUTSIDE_PIX_STRATEGY__SHIFT                                  0x0
#define WBSCL0_WBSCL_OUTSIDE_PIX_STRATEGY__WBSCL_BLACK_COLOR_B_CB__SHIFT                                      0x8
#define WBSCL0_WBSCL_OUTSIDE_PIX_STRATEGY__WBSCL_BLACK_COLOR_G_Y__SHIFT                                       0x10
#define WBSCL0_WBSCL_OUTSIDE_PIX_STRATEGY__WBSCL_BLACK_COLOR_R_CR__SHIFT                                      0x18
#define WBSCL0_WBSCL_OUTSIDE_PIX_STRATEGY__WBSCL_OUTSIDE_PIX_STRATEGY_MASK                                    0x00000001L
#define WBSCL0_WBSCL_OUTSIDE_PIX_STRATEGY__WBSCL_BLACK_COLOR_B_CB_MASK                                        0x0000FF00L
#define WBSCL0_WBSCL_OUTSIDE_PIX_STRATEGY__WBSCL_BLACK_COLOR_G_Y_MASK                                         0x00FF0000L
#define WBSCL0_WBSCL_OUTSIDE_PIX_STRATEGY__WBSCL_BLACK_COLOR_R_CR_MASK                                        0xFF000000L
//WBSCL0_WBSCL_TEST_CNTL
#define WBSCL0_WBSCL_TEST_CNTL__WBSCL_TEST_CRC_EN__SHIFT                                                      0x4
#define WBSCL0_WBSCL_TEST_CNTL__WBSCL_TEST_CRC_CONT_EN__SHIFT                                                 0x8
#define WBSCL0_WBSCL_TEST_CNTL__WBSCL_TEST_CRC_DE_ONLY__SHIFT                                                 0x10
#define WBSCL0_WBSCL_TEST_CNTL__WBSCL_TEST_CRC_EN_MASK                                                        0x00000010L
#define WBSCL0_WBSCL_TEST_CNTL__WBSCL_TEST_CRC_CONT_EN_MASK                                                   0x00000100L
#define WBSCL0_WBSCL_TEST_CNTL__WBSCL_TEST_CRC_DE_ONLY_MASK                                                   0x00010000L
//WBSCL0_WBSCL_TEST_CRC_RED
#define WBSCL0_WBSCL_TEST_CRC_RED__WBSCL_TEST_CRC_RED_MASK__SHIFT                                             0x8
#define WBSCL0_WBSCL_TEST_CRC_RED__WBSCL_TEST_CRC_SIG_RED__SHIFT                                              0x10
#define WBSCL0_WBSCL_TEST_CRC_RED__WBSCL_TEST_CRC_RED_MASK_MASK                                               0x0000FF00L
#define WBSCL0_WBSCL_TEST_CRC_RED__WBSCL_TEST_CRC_SIG_RED_MASK                                                0xFFFF0000L
//WBSCL0_WBSCL_TEST_CRC_GREEN
#define WBSCL0_WBSCL_TEST_CRC_GREEN__WBSCL_TEST_CRC_GREEN_MASK__SHIFT                                         0x0
#define WBSCL0_WBSCL_TEST_CRC_GREEN__WBSCL_TEST_CRC_SIG_GREEN__SHIFT                                          0x10
#define WBSCL0_WBSCL_TEST_CRC_GREEN__WBSCL_TEST_CRC_GREEN_MASK_MASK                                           0x0000FFFFL
#define WBSCL0_WBSCL_TEST_CRC_GREEN__WBSCL_TEST_CRC_SIG_GREEN_MASK                                            0xFFFF0000L
//WBSCL0_WBSCL_TEST_CRC_BLUE
#define WBSCL0_WBSCL_TEST_CRC_BLUE__WBSCL_TEST_CRC_BLUE_MASK__SHIFT                                           0x8
#define WBSCL0_WBSCL_TEST_CRC_BLUE__WBSCL_TEST_CRC_SIG_BLUE__SHIFT                                            0x10
#define WBSCL0_WBSCL_TEST_CRC_BLUE__WBSCL_TEST_CRC_BLUE_MASK_MASK                                             0x0000FF00L
#define WBSCL0_WBSCL_TEST_CRC_BLUE__WBSCL_TEST_CRC_SIG_BLUE_MASK                                              0xFFFF0000L
//WBSCL0_WBSCL_BACKPRESSURE_CNT_EN
#define WBSCL0_WBSCL_BACKPRESSURE_CNT_EN__WBSCL_BACKPRESSURE_CNT_EN__SHIFT                                    0x0
#define WBSCL0_WBSCL_BACKPRESSURE_CNT_EN__WBSCL_BACKPRESSURE_CNT_EN_MASK                                      0x00000001L
//WBSCL0_WB_MCIF_BACKPRESSURE_CNT
#define WBSCL0_WB_MCIF_BACKPRESSURE_CNT__WB_MCIF_Y_MAX_BACKPRESSURE__SHIFT                                    0x0
#define WBSCL0_WB_MCIF_BACKPRESSURE_CNT__WB_MCIF_C_MAX_BACKPRESSURE__SHIFT                                    0x10
#define WBSCL0_WB_MCIF_BACKPRESSURE_CNT__WB_MCIF_Y_MAX_BACKPRESSURE_MASK                                      0x0000FFFFL
#define WBSCL0_WB_MCIF_BACKPRESSURE_CNT__WB_MCIF_C_MAX_BACKPRESSURE_MASK                                      0xFFFF0000L
//WBSCL0_WBSCL_RAM_SHUTDOWN
#define WBSCL0_WBSCL_RAM_SHUTDOWN__WBSCL_RAM_SHUTDOWN_SEL__SHIFT                                              0x0
#define WBSCL0_WBSCL_RAM_SHUTDOWN__WBSCL_RAM_SHUTDOWN_SEL_MASK                                                0x00000003L


// addressBlock: dce_dc_wb0_dispdec_wb_dcperfmon_dc_perfmon_dispdec
//DC_PERFMON3_PERFCOUNTER_CNTL
#define DC_PERFMON3_PERFCOUNTER_CNTL__PERFCOUNTER_EVENT_SEL__SHIFT                                            0x0
#define DC_PERFMON3_PERFCOUNTER_CNTL__PERFCOUNTER_CVALUE_SEL__SHIFT                                           0x9
#define DC_PERFMON3_PERFCOUNTER_CNTL__PERFCOUNTER_INC_MODE__SHIFT                                             0xc
#define DC_PERFMON3_PERFCOUNTER_CNTL__PERFCOUNTER_HW_CNTL_SEL__SHIFT                                          0xf
#define DC_PERFMON3_PERFCOUNTER_CNTL__PERFCOUNTER_RUNEN_MODE__SHIFT                                           0x10
#define DC_PERFMON3_PERFCOUNTER_CNTL__PERFCOUNTER_CNTOFF_START_DIS__SHIFT                                     0x16
#define DC_PERFMON3_PERFCOUNTER_CNTL__PERFCOUNTER_RESTART_EN__SHIFT                                           0x17
#define DC_PERFMON3_PERFCOUNTER_CNTL__PERFCOUNTER_INT_EN__SHIFT                                               0x18
#define DC_PERFMON3_PERFCOUNTER_CNTL__PERFCOUNTER_OFF_MASK__SHIFT                                             0x19
#define DC_PERFMON3_PERFCOUNTER_CNTL__PERFCOUNTER_ACTIVE__SHIFT                                               0x1a
#define DC_PERFMON3_PERFCOUNTER_CNTL__PERFCOUNTER_CNTL_SEL__SHIFT                                             0x1d
#define DC_PERFMON3_PERFCOUNTER_CNTL__PERFCOUNTER_EVENT_SEL_MASK                                              0x000001FFL
#define DC_PERFMON3_PERFCOUNTER_CNTL__PERFCOUNTER_CVALUE_SEL_MASK                                             0x00000E00L
#define DC_PERFMON3_PERFCOUNTER_CNTL__PERFCOUNTER_INC_MODE_MASK                                               0x00007000L
#define DC_PERFMON3_PERFCOUNTER_CNTL__PERFCOUNTER_HW_CNTL_SEL_MASK                                            0x00008000L
#define DC_PERFMON3_PERFCOUNTER_CNTL__PERFCOUNTER_RUNEN_MODE_MASK                                             0x00010000L
#define DC_PERFMON3_PERFCOUNTER_CNTL__PERFCOUNTER_CNTOFF_START_DIS_MASK                                       0x00400000L
#define DC_PERFMON3_PERFCOUNTER_CNTL__PERFCOUNTER_RESTART_EN_MASK                                             0x00800000L
#define DC_PERFMON3_PERFCOUNTER_CNTL__PERFCOUNTER_INT_EN_MASK                                                 0x01000000L
#define DC_PERFMON3_PERFCOUNTER_CNTL__PERFCOUNTER_OFF_MASK_MASK                                               0x02000000L
#define DC_PERFMON3_PERFCOUNTER_CNTL__PERFCOUNTER_ACTIVE_MASK                                                 0x04000000L
#define DC_PERFMON3_PERFCOUNTER_CNTL__PERFCOUNTER_CNTL_SEL_MASK                                               0xE0000000L
//DC_PERFMON3_PERFCOUNTER_CNTL2
#define DC_PERFMON3_PERFCOUNTER_CNTL2__PERFCOUNTER_COUNTED_VALUE_TYPE__SHIFT                                  0x0
#define DC_PERFMON3_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP1_SEL__SHIFT                                        0x2
#define DC_PERFMON3_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP2_SEL__SHIFT                                        0x3
#define DC_PERFMON3_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTOFF_SEL__SHIFT                                          0x8
#define DC_PERFMON3_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTL2_SEL__SHIFT                                           0x1d
#define DC_PERFMON3_PERFCOUNTER_CNTL2__PERFCOUNTER_COUNTED_VALUE_TYPE_MASK                                    0x00000003L
#define DC_PERFMON3_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP1_SEL_MASK                                          0x00000004L
#define DC_PERFMON3_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP2_SEL_MASK                                          0x00000008L
#define DC_PERFMON3_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTOFF_SEL_MASK                                            0x00003F00L
#define DC_PERFMON3_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTL2_SEL_MASK                                             0xE0000000L
//DC_PERFMON3_PERFCOUNTER_STATE
#define DC_PERFMON3_PERFCOUNTER_STATE__PERFCOUNTER_CNT0_STATE__SHIFT                                          0x0
#define DC_PERFMON3_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL0__SHIFT                                          0x2
#define DC_PERFMON3_PERFCOUNTER_STATE__PERFCOUNTER_CNT1_STATE__SHIFT                                          0x4
#define DC_PERFMON3_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL1__SHIFT                                          0x6
#define DC_PERFMON3_PERFCOUNTER_STATE__PERFCOUNTER_CNT2_STATE__SHIFT                                          0x8
#define DC_PERFMON3_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL2__SHIFT                                          0xa
#define DC_PERFMON3_PERFCOUNTER_STATE__PERFCOUNTER_CNT3_STATE__SHIFT                                          0xc
#define DC_PERFMON3_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL3__SHIFT                                          0xe
#define DC_PERFMON3_PERFCOUNTER_STATE__PERFCOUNTER_CNT4_STATE__SHIFT                                          0x10
#define DC_PERFMON3_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL4__SHIFT                                          0x12
#define DC_PERFMON3_PERFCOUNTER_STATE__PERFCOUNTER_CNT5_STATE__SHIFT                                          0x14
#define DC_PERFMON3_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL5__SHIFT                                          0x16
#define DC_PERFMON3_PERFCOUNTER_STATE__PERFCOUNTER_CNT6_STATE__SHIFT                                          0x18
#define DC_PERFMON3_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL6__SHIFT                                          0x1a
#define DC_PERFMON3_PERFCOUNTER_STATE__PERFCOUNTER_CNT7_STATE__SHIFT                                          0x1c
#define DC_PERFMON3_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL7__SHIFT                                          0x1e
#define DC_PERFMON3_PERFCOUNTER_STATE__PERFCOUNTER_CNT0_STATE_MASK                                            0x00000003L
#define DC_PERFMON3_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL0_MASK                                            0x00000004L
#define DC_PERFMON3_PERFCOUNTER_STATE__PERFCOUNTER_CNT1_STATE_MASK                                            0x00000030L
#define DC_PERFMON3_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL1_MASK                                            0x00000040L
#define DC_PERFMON3_PERFCOUNTER_STATE__PERFCOUNTER_CNT2_STATE_MASK                                            0x00000300L
#define DC_PERFMON3_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL2_MASK                                            0x00000400L
#define DC_PERFMON3_PERFCOUNTER_STATE__PERFCOUNTER_CNT3_STATE_MASK                                            0x00003000L
#define DC_PERFMON3_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL3_MASK                                            0x00004000L
#define DC_PERFMON3_PERFCOUNTER_STATE__PERFCOUNTER_CNT4_STATE_MASK                                            0x00030000L
#define DC_PERFMON3_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL4_MASK                                            0x00040000L
#define DC_PERFMON3_PERFCOUNTER_STATE__PERFCOUNTER_CNT5_STATE_MASK                                            0x00300000L
#define DC_PERFMON3_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL5_MASK                                            0x00400000L
#define DC_PERFMON3_PERFCOUNTER_STATE__PERFCOUNTER_CNT6_STATE_MASK                                            0x03000000L
#define DC_PERFMON3_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL6_MASK                                            0x04000000L
#define DC_PERFMON3_PERFCOUNTER_STATE__PERFCOUNTER_CNT7_STATE_MASK                                            0x30000000L
#define DC_PERFMON3_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL7_MASK                                            0x40000000L
//DC_PERFMON3_PERFMON_CNTL
#define DC_PERFMON3_PERFMON_CNTL__PERFMON_STATE__SHIFT                                                        0x0
#define DC_PERFMON3_PERFMON_CNTL__PERFMON_RPT_COUNT__SHIFT                                                    0x8
#define DC_PERFMON3_PERFMON_CNTL__PERFMON_CNTOFF_AND_OR__SHIFT                                                0x1c
#define DC_PERFMON3_PERFMON_CNTL__PERFMON_CNTOFF_INT_EN__SHIFT                                                0x1d
#define DC_PERFMON3_PERFMON_CNTL__PERFMON_CNTOFF_INT_STATUS__SHIFT                                            0x1e
#define DC_PERFMON3_PERFMON_CNTL__PERFMON_CNTOFF_INT_ACK__SHIFT                                               0x1f
#define DC_PERFMON3_PERFMON_CNTL__PERFMON_STATE_MASK                                                          0x00000003L
#define DC_PERFMON3_PERFMON_CNTL__PERFMON_RPT_COUNT_MASK                                                      0x0FFFFF00L
#define DC_PERFMON3_PERFMON_CNTL__PERFMON_CNTOFF_AND_OR_MASK                                                  0x10000000L
#define DC_PERFMON3_PERFMON_CNTL__PERFMON_CNTOFF_INT_EN_MASK                                                  0x20000000L
#define DC_PERFMON3_PERFMON_CNTL__PERFMON_CNTOFF_INT_STATUS_MASK                                              0x40000000L
#define DC_PERFMON3_PERFMON_CNTL__PERFMON_CNTOFF_INT_ACK_MASK                                                 0x80000000L
//DC_PERFMON3_PERFMON_CNTL2
#define DC_PERFMON3_PERFMON_CNTL2__PERFMON_CNTOFF_INT_TYPE__SHIFT                                             0x0
#define DC_PERFMON3_PERFMON_CNTL2__PERFMON_CLK_ENABLE__SHIFT                                                  0x1
#define DC_PERFMON3_PERFMON_CNTL2__PERFMON_RUN_ENABLE_START_SEL__SHIFT                                        0x2
#define DC_PERFMON3_PERFMON_CNTL2__PERFMON_RUN_ENABLE_STOP_SEL__SHIFT                                         0xa
#define DC_PERFMON3_PERFMON_CNTL2__PERFMON_CNTOFF_INT_TYPE_MASK                                               0x00000001L
#define DC_PERFMON3_PERFMON_CNTL2__PERFMON_CLK_ENABLE_MASK                                                    0x00000002L
#define DC_PERFMON3_PERFMON_CNTL2__PERFMON_RUN_ENABLE_START_SEL_MASK                                          0x000003FCL
#define DC_PERFMON3_PERFMON_CNTL2__PERFMON_RUN_ENABLE_STOP_SEL_MASK                                           0x0003FC00L
//DC_PERFMON3_PERFMON_CVALUE_INT_MISC
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_STATUS__SHIFT                                   0x0
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_STATUS__SHIFT                                   0x1
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_STATUS__SHIFT                                   0x2
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_STATUS__SHIFT                                   0x3
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_STATUS__SHIFT                                   0x4
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_STATUS__SHIFT                                   0x5
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_STATUS__SHIFT                                   0x6
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_STATUS__SHIFT                                   0x7
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_ACK__SHIFT                                      0x8
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_ACK__SHIFT                                      0x9
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_ACK__SHIFT                                      0xa
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_ACK__SHIFT                                      0xb
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_ACK__SHIFT                                      0xc
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_ACK__SHIFT                                      0xd
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_ACK__SHIFT                                      0xe
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_ACK__SHIFT                                      0xf
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFMON_CVALUE_HI__SHIFT                                         0x10
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_STATUS_MASK                                     0x00000001L
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_STATUS_MASK                                     0x00000002L
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_STATUS_MASK                                     0x00000004L
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_STATUS_MASK                                     0x00000008L
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_STATUS_MASK                                     0x00000010L
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_STATUS_MASK                                     0x00000020L
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_STATUS_MASK                                     0x00000040L
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_STATUS_MASK                                     0x00000080L
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_ACK_MASK                                        0x00000100L
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_ACK_MASK                                        0x00000200L
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_ACK_MASK                                        0x00000400L
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_ACK_MASK                                        0x00000800L
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_ACK_MASK                                        0x00001000L
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_ACK_MASK                                        0x00002000L
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_ACK_MASK                                        0x00004000L
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_ACK_MASK                                        0x00008000L
#define DC_PERFMON3_PERFMON_CVALUE_INT_MISC__PERFMON_CVALUE_HI_MASK                                           0xFFFF0000L
//DC_PERFMON3_PERFMON_CVALUE_LOW
#define DC_PERFMON3_PERFMON_CVALUE_LOW__PERFMON_CVALUE_LOW__SHIFT                                             0x0
#define DC_PERFMON3_PERFMON_CVALUE_LOW__PERFMON_CVALUE_LOW_MASK                                               0xFFFFFFFFL
//DC_PERFMON3_PERFMON_HI
#define DC_PERFMON3_PERFMON_HI__PERFMON_HI__SHIFT                                                             0x0
#define DC_PERFMON3_PERFMON_HI__PERFMON_READ_SEL__SHIFT                                                       0x1d
#define DC_PERFMON3_PERFMON_HI__PERFMON_HI_MASK                                                               0x0000FFFFL
#define DC_PERFMON3_PERFMON_HI__PERFMON_READ_SEL_MASK                                                         0xE0000000L
//DC_PERFMON3_PERFMON_LOW
#define DC_PERFMON3_PERFMON_LOW__PERFMON_LOW__SHIFT                                                           0x0
#define DC_PERFMON3_PERFMON_LOW__PERFMON_LOW_MASK                                                             0xFFFFFFFFL


// addressBlock: dce_dc_wb1_dispdec_cnv_dispdec
//CNV1_WB_ENABLE
#define CNV1_WB_ENABLE__WB_ENABLE__SHIFT                                                                      0x0
#define CNV1_WB_ENABLE__WB_ENABLE_MASK                                                                        0x00000001L
//CNV1_WB_EC_CONFIG
#define CNV1_WB_EC_CONFIG__DISPCLK_R_WB_GATE_DIS__SHIFT                                                       0x0
#define CNV1_WB_EC_CONFIG__DISPCLK_G_WB_GATE_DIS__SHIFT                                                       0x1
#define CNV1_WB_EC_CONFIG__DISPCLK_G_WBSCL_GATE_DIS__SHIFT                                                    0x2
#define CNV1_WB_EC_CONFIG__WB_TEST_CLK_SEL__SHIFT                                                             0x3
#define CNV1_WB_EC_CONFIG__WB_LB_LS_DIS__SHIFT                                                                0x7
#define CNV1_WB_EC_CONFIG__WB_LB_SD_DIS__SHIFT                                                                0x8
#define CNV1_WB_EC_CONFIG__WB_LUT_LS_DIS__SHIFT                                                               0x9
#define CNV1_WB_EC_CONFIG__WBSCL_LB_MEM_PWR_MODE_SEL__SHIFT                                                   0xc
#define CNV1_WB_EC_CONFIG__WBSCL_LB_MEM_PWR_DIS__SHIFT                                                        0xe
#define CNV1_WB_EC_CONFIG__WBSCL_LB_MEM_PWR_FORCE__SHIFT                                                      0xf
#define CNV1_WB_EC_CONFIG__WBSCL_LB_MEM_PWR_STATE_SM__SHIFT                                                   0x11
#define CNV1_WB_EC_CONFIG__WBSCL_LB_MEM_PWR_STATE_BG__SHIFT                                                   0x13
#define CNV1_WB_EC_CONFIG__WBSCL_LB_MEM_PWR_STATE__SHIFT                                                      0x15
#define CNV1_WB_EC_CONFIG__WB_RAM_PW_SAVE_MODE__SHIFT                                                         0x17
#define CNV1_WB_EC_CONFIG__LB_MEM_PWR_STATE_SM__SHIFT                                                         0x18
#define CNV1_WB_EC_CONFIG__LB_MEM_PWR_STATE_BG__SHIFT                                                         0x1a
#define CNV1_WB_EC_CONFIG__LB_MEM_PWR_STATE__SHIFT                                                            0x1c
#define CNV1_WB_EC_CONFIG__LUT_MEM_PWR_STATE__SHIFT                                                           0x1e
#define CNV1_WB_EC_CONFIG__DISPCLK_R_WB_GATE_DIS_MASK                                                         0x00000001L
#define CNV1_WB_EC_CONFIG__DISPCLK_G_WB_GATE_DIS_MASK                                                         0x00000002L
#define CNV1_WB_EC_CONFIG__DISPCLK_G_WBSCL_GATE_DIS_MASK                                                      0x00000004L
#define CNV1_WB_EC_CONFIG__WB_TEST_CLK_SEL_MASK                                                               0x00000078L
#define CNV1_WB_EC_CONFIG__WB_LB_LS_DIS_MASK                                                                  0x00000080L
#define CNV1_WB_EC_CONFIG__WB_LB_SD_DIS_MASK                                                                  0x00000100L
#define CNV1_WB_EC_CONFIG__WB_LUT_LS_DIS_MASK                                                                 0x00000200L
#define CNV1_WB_EC_CONFIG__WBSCL_LB_MEM_PWR_MODE_SEL_MASK                                                     0x00003000L
#define CNV1_WB_EC_CONFIG__WBSCL_LB_MEM_PWR_DIS_MASK                                                          0x00004000L
#define CNV1_WB_EC_CONFIG__WBSCL_LB_MEM_PWR_FORCE_MASK                                                        0x00018000L
#define CNV1_WB_EC_CONFIG__WBSCL_LB_MEM_PWR_STATE_SM_MASK                                                     0x00060000L
#define CNV1_WB_EC_CONFIG__WBSCL_LB_MEM_PWR_STATE_BG_MASK                                                     0x00180000L
#define CNV1_WB_EC_CONFIG__WBSCL_LB_MEM_PWR_STATE_MASK                                                        0x00600000L
#define CNV1_WB_EC_CONFIG__WB_RAM_PW_SAVE_MODE_MASK                                                           0x00800000L
#define CNV1_WB_EC_CONFIG__LB_MEM_PWR_STATE_SM_MASK                                                           0x03000000L
#define CNV1_WB_EC_CONFIG__LB_MEM_PWR_STATE_BG_MASK                                                           0x0C000000L
#define CNV1_WB_EC_CONFIG__LB_MEM_PWR_STATE_MASK                                                              0x30000000L
#define CNV1_WB_EC_CONFIG__LUT_MEM_PWR_STATE_MASK                                                             0xC0000000L
//CNV1_CNV_MODE
#define CNV1_CNV_MODE__CNV_FRAME_CAPTURE_RATE__SHIFT                                                          0x8
#define CNV1_CNV_MODE__CNV_WINDOW_CROP_EN__SHIFT                                                              0xc
#define CNV1_CNV_MODE__CNV_STEREO_TYPE__SHIFT                                                                 0xd
#define CNV1_CNV_MODE__CNV_INTERLACED_MODE__SHIFT                                                             0xf
#define CNV1_CNV_MODE__CNV_EYE_SELECTION__SHIFT                                                               0x10
#define CNV1_CNV_MODE__CNV_STEREO_POLARITY__SHIFT                                                             0x12
#define CNV1_CNV_MODE__CNV_INTERLACED_FIELD_ORDER__SHIFT                                                      0x13
#define CNV1_CNV_MODE__CNV_STEREO_SPLIT__SHIFT                                                                0x14
#define CNV1_CNV_MODE__CNV_NEW_CONTENT__SHIFT                                                                 0x18
#define CNV1_CNV_MODE__CNV_FRAME_CAPTURE_EN__SHIFT                                                            0x1f
#define CNV1_CNV_MODE__CNV_FRAME_CAPTURE_RATE_MASK                                                            0x00000300L
#define CNV1_CNV_MODE__CNV_WINDOW_CROP_EN_MASK                                                                0x00001000L
#define CNV1_CNV_MODE__CNV_STEREO_TYPE_MASK                                                                   0x00006000L
#define CNV1_CNV_MODE__CNV_INTERLACED_MODE_MASK                                                               0x00008000L
#define CNV1_CNV_MODE__CNV_EYE_SELECTION_MASK                                                                 0x00030000L
#define CNV1_CNV_MODE__CNV_STEREO_POLARITY_MASK                                                               0x00040000L
#define CNV1_CNV_MODE__CNV_INTERLACED_FIELD_ORDER_MASK                                                        0x00080000L
#define CNV1_CNV_MODE__CNV_STEREO_SPLIT_MASK                                                                  0x00100000L
#define CNV1_CNV_MODE__CNV_NEW_CONTENT_MASK                                                                   0x01000000L
#define CNV1_CNV_MODE__CNV_FRAME_CAPTURE_EN_MASK                                                              0x80000000L
//CNV1_CNV_WINDOW_START
#define CNV1_CNV_WINDOW_START__CNV_WINDOW_START_X__SHIFT                                                      0x0
#define CNV1_CNV_WINDOW_START__CNV_WINDOW_START_Y__SHIFT                                                      0x10
#define CNV1_CNV_WINDOW_START__CNV_WINDOW_START_X_MASK                                                        0x00000FFFL
#define CNV1_CNV_WINDOW_START__CNV_WINDOW_START_Y_MASK                                                        0x0FFF0000L
//CNV1_CNV_WINDOW_SIZE
#define CNV1_CNV_WINDOW_SIZE__CNV_WINDOW_WIDTH__SHIFT                                                         0x0
#define CNV1_CNV_WINDOW_SIZE__CNV_WINDOW_HEIGHT__SHIFT                                                        0x10
#define CNV1_CNV_WINDOW_SIZE__CNV_WINDOW_WIDTH_MASK                                                           0x00000FFFL
#define CNV1_CNV_WINDOW_SIZE__CNV_WINDOW_HEIGHT_MASK                                                          0x0FFF0000L
//CNV1_CNV_UPDATE
#define CNV1_CNV_UPDATE__CNV_UPDATE_PENDING__SHIFT                                                            0x0
#define CNV1_CNV_UPDATE__CNV_UPDATE_TAKEN__SHIFT                                                              0x8
#define CNV1_CNV_UPDATE__CNV_UPDATE_LOCK__SHIFT                                                               0x10
#define CNV1_CNV_UPDATE__CNV_UPDATE_PENDING_MASK                                                              0x00000001L
#define CNV1_CNV_UPDATE__CNV_UPDATE_TAKEN_MASK                                                                0x00000100L
#define CNV1_CNV_UPDATE__CNV_UPDATE_LOCK_MASK                                                                 0x00010000L
//CNV1_CNV_SOURCE_SIZE
#define CNV1_CNV_SOURCE_SIZE__CNV_SOURCE_WIDTH__SHIFT                                                         0x0
#define CNV1_CNV_SOURCE_SIZE__CNV_SOURCE_HEIGHT__SHIFT                                                        0x10
#define CNV1_CNV_SOURCE_SIZE__CNV_SOURCE_WIDTH_MASK                                                           0x00007FFFL
#define CNV1_CNV_SOURCE_SIZE__CNV_SOURCE_HEIGHT_MASK                                                          0x7FFF0000L
//CNV1_CNV_CSC_CONTROL
#define CNV1_CNV_CSC_CONTROL__CNV_CSC_BYPASS__SHIFT                                                           0x0
#define CNV1_CNV_CSC_CONTROL__CNV_CSC_BYPASS_MASK                                                             0x00000001L
//CNV1_CNV_CSC_C11_C12
#define CNV1_CNV_CSC_C11_C12__CNV_CSC_C11__SHIFT                                                              0x0
#define CNV1_CNV_CSC_C11_C12__CNV_CSC_C12__SHIFT                                                              0x10
#define CNV1_CNV_CSC_C11_C12__CNV_CSC_C11_MASK                                                                0x00001FFFL
#define CNV1_CNV_CSC_C11_C12__CNV_CSC_C12_MASK                                                                0x1FFF0000L
//CNV1_CNV_CSC_C13_C14
#define CNV1_CNV_CSC_C13_C14__CNV_CSC_C13__SHIFT                                                              0x0
#define CNV1_CNV_CSC_C13_C14__CNV_CSC_C14__SHIFT                                                              0x10
#define CNV1_CNV_CSC_C13_C14__CNV_CSC_C13_MASK                                                                0x00001FFFL
#define CNV1_CNV_CSC_C13_C14__CNV_CSC_C14_MASK                                                                0x7FFF0000L
//CNV1_CNV_CSC_C21_C22
#define CNV1_CNV_CSC_C21_C22__CNV_CSC_C21__SHIFT                                                              0x0
#define CNV1_CNV_CSC_C21_C22__CNV_CSC_C22__SHIFT                                                              0x10
#define CNV1_CNV_CSC_C21_C22__CNV_CSC_C21_MASK                                                                0x00001FFFL
#define CNV1_CNV_CSC_C21_C22__CNV_CSC_C22_MASK                                                                0x1FFF0000L
//CNV1_CNV_CSC_C23_C24
#define CNV1_CNV_CSC_C23_C24__CNV_CSC_C23__SHIFT                                                              0x0
#define CNV1_CNV_CSC_C23_C24__CNV_CSC_C24__SHIFT                                                              0x10
#define CNV1_CNV_CSC_C23_C24__CNV_CSC_C23_MASK                                                                0x00001FFFL
#define CNV1_CNV_CSC_C23_C24__CNV_CSC_C24_MASK                                                                0x7FFF0000L
//CNV1_CNV_CSC_C31_C32
#define CNV1_CNV_CSC_C31_C32__CNV_CSC_C31__SHIFT                                                              0x0
#define CNV1_CNV_CSC_C31_C32__CNV_CSC_C32__SHIFT                                                              0x10
#define CNV1_CNV_CSC_C31_C32__CNV_CSC_C31_MASK                                                                0x00001FFFL
#define CNV1_CNV_CSC_C31_C32__CNV_CSC_C32_MASK                                                                0x1FFF0000L
//CNV1_CNV_CSC_C33_C34
#define CNV1_CNV_CSC_C33_C34__CNV_CSC_C33__SHIFT                                                              0x0
#define CNV1_CNV_CSC_C33_C34__CNV_CSC_C34__SHIFT                                                              0x10
#define CNV1_CNV_CSC_C33_C34__CNV_CSC_C33_MASK                                                                0x00001FFFL
#define CNV1_CNV_CSC_C33_C34__CNV_CSC_C34_MASK                                                                0x7FFF0000L
//CNV1_CNV_CSC_ROUND_OFFSET_R
#define CNV1_CNV_CSC_ROUND_OFFSET_R__CNV_CSC_ROUND_OFFSET_R__SHIFT                                            0x0
#define CNV1_CNV_CSC_ROUND_OFFSET_R__CNV_CSC_ROUND_OFFSET_R_MASK                                              0x0000FFFFL
//CNV1_CNV_CSC_ROUND_OFFSET_G
#define CNV1_CNV_CSC_ROUND_OFFSET_G__CNV_CSC_ROUND_OFFSET_G__SHIFT                                            0x0
#define CNV1_CNV_CSC_ROUND_OFFSET_G__CNV_CSC_ROUND_OFFSET_G_MASK                                              0x0000FFFFL
//CNV1_CNV_CSC_ROUND_OFFSET_B
#define CNV1_CNV_CSC_ROUND_OFFSET_B__CNV_CSC_ROUND_OFFSET_B__SHIFT                                            0x0
#define CNV1_CNV_CSC_ROUND_OFFSET_B__CNV_CSC_ROUND_OFFSET_B_MASK                                              0x0000FFFFL
//CNV1_CNV_CSC_CLAMP_R
#define CNV1_CNV_CSC_CLAMP_R__CNV_CSC_CLAMP_UPPER_R__SHIFT                                                    0x0
#define CNV1_CNV_CSC_CLAMP_R__CNV_CSC_CLAMP_LOWER_R__SHIFT                                                    0x10
#define CNV1_CNV_CSC_CLAMP_R__CNV_CSC_CLAMP_UPPER_R_MASK                                                      0x0000FFFFL
#define CNV1_CNV_CSC_CLAMP_R__CNV_CSC_CLAMP_LOWER_R_MASK                                                      0xFFFF0000L
//CNV1_CNV_CSC_CLAMP_G
#define CNV1_CNV_CSC_CLAMP_G__CNV_CSC_CLAMP_UPPER_G__SHIFT                                                    0x0
#define CNV1_CNV_CSC_CLAMP_G__CNV_CSC_CLAMP_LOWER_G__SHIFT                                                    0x10
#define CNV1_CNV_CSC_CLAMP_G__CNV_CSC_CLAMP_UPPER_G_MASK                                                      0x0000FFFFL
#define CNV1_CNV_CSC_CLAMP_G__CNV_CSC_CLAMP_LOWER_G_MASK                                                      0xFFFF0000L
//CNV1_CNV_CSC_CLAMP_B
#define CNV1_CNV_CSC_CLAMP_B__CNV_CSC_CLAMP_UPPER_B__SHIFT                                                    0x0
#define CNV1_CNV_CSC_CLAMP_B__CNV_CSC_CLAMP_LOWER_B__SHIFT                                                    0x10
#define CNV1_CNV_CSC_CLAMP_B__CNV_CSC_CLAMP_UPPER_B_MASK                                                      0x0000FFFFL
#define CNV1_CNV_CSC_CLAMP_B__CNV_CSC_CLAMP_LOWER_B_MASK                                                      0xFFFF0000L
//CNV1_CNV_TEST_CNTL
#define CNV1_CNV_TEST_CNTL__CNV_TEST_CRC_EN__SHIFT                                                            0x4
#define CNV1_CNV_TEST_CNTL__CNV_TEST_CRC_CONT_EN__SHIFT                                                       0x8
#define CNV1_CNV_TEST_CNTL__CNV_TEST_CRC_DE_ONLY__SHIFT                                                       0x10
#define CNV1_CNV_TEST_CNTL__CNV_TEST_CRC_EN_MASK                                                              0x00000010L
#define CNV1_CNV_TEST_CNTL__CNV_TEST_CRC_CONT_EN_MASK                                                         0x00000100L
#define CNV1_CNV_TEST_CNTL__CNV_TEST_CRC_DE_ONLY_MASK                                                         0x00010000L
//CNV1_CNV_TEST_CRC_RED
#define CNV1_CNV_TEST_CRC_RED__CNV_TEST_CRC_RED_MASK__SHIFT                                                   0x4
#define CNV1_CNV_TEST_CRC_RED__CNV_TEST_CRC_SIG_RED__SHIFT                                                    0x10
#define CNV1_CNV_TEST_CRC_RED__CNV_TEST_CRC_RED_MASK_MASK                                                     0x0000FFF0L
#define CNV1_CNV_TEST_CRC_RED__CNV_TEST_CRC_SIG_RED_MASK                                                      0xFFFF0000L
//CNV1_CNV_TEST_CRC_GREEN
#define CNV1_CNV_TEST_CRC_GREEN__CNV_TEST_CRC_GREEN_MASK__SHIFT                                               0x4
#define CNV1_CNV_TEST_CRC_GREEN__CNV_TEST_CRC_SIG_GREEN__SHIFT                                                0x10
#define CNV1_CNV_TEST_CRC_GREEN__CNV_TEST_CRC_GREEN_MASK_MASK                                                 0x0000FFF0L
#define CNV1_CNV_TEST_CRC_GREEN__CNV_TEST_CRC_SIG_GREEN_MASK                                                  0xFFFF0000L
//CNV1_CNV_TEST_CRC_BLUE
#define CNV1_CNV_TEST_CRC_BLUE__CNV_TEST_CRC_BLUE_MASK__SHIFT                                                 0x4
#define CNV1_CNV_TEST_CRC_BLUE__CNV_TEST_CRC_SIG_BLUE__SHIFT                                                  0x10
#define CNV1_CNV_TEST_CRC_BLUE__CNV_TEST_CRC_BLUE_MASK_MASK                                                   0x0000FFF0L
#define CNV1_CNV_TEST_CRC_BLUE__CNV_TEST_CRC_SIG_BLUE_MASK                                                    0xFFFF0000L
//CNV1_CNV_INPUT_SELECT
#define CNV1_CNV_INPUT_SELECT__CNV_INPUT_SRC_SELECT__SHIFT                                                    0x0
#define CNV1_CNV_INPUT_SELECT__CNV_INPUT_PIPE_SELECT__SHIFT                                                   0x2
#define CNV1_CNV_INPUT_SELECT__CNV_INPUT_SRC_SELECT_MASK                                                      0x00000003L
#define CNV1_CNV_INPUT_SELECT__CNV_INPUT_PIPE_SELECT_MASK                                                     0x0000001CL
//CNV1_WB_SOFT_RESET
#define CNV1_WB_SOFT_RESET__WB_SOFT_RESET__SHIFT                                                              0x0
#define CNV1_WB_SOFT_RESET__WB_SOFT_RESET_MASK                                                                0x00000001L
//CNV1_WB_WARM_UP_MODE_CTL1
#define CNV1_WB_WARM_UP_MODE_CTL1__WIDTH_WARMUP__SHIFT                                                        0x0
#define CNV1_WB_WARM_UP_MODE_CTL1__HEIGHT_WARMUP__SHIFT                                                       0x10
#define CNV1_WB_WARM_UP_MODE_CTL1__GMC_WARM_UP_ENABLE__SHIFT                                                  0x1f
#define CNV1_WB_WARM_UP_MODE_CTL1__WIDTH_WARMUP_MASK                                                          0x00007FFFL
#define CNV1_WB_WARM_UP_MODE_CTL1__HEIGHT_WARMUP_MASK                                                         0x7FFF0000L
#define CNV1_WB_WARM_UP_MODE_CTL1__GMC_WARM_UP_ENABLE_MASK                                                    0x80000000L
//CNV1_WB_WARM_UP_MODE_CTL2
#define CNV1_WB_WARM_UP_MODE_CTL2__DATA_VALUE_WARMUP__SHIFT                                                   0x0
#define CNV1_WB_WARM_UP_MODE_CTL2__MODE_WARMUP__SHIFT                                                         0x8
#define CNV1_WB_WARM_UP_MODE_CTL2__DATA_VALUE_WARMUP_MASK                                                     0x000000FFL
#define CNV1_WB_WARM_UP_MODE_CTL2__MODE_WARMUP_MASK                                                           0x00000100L


// addressBlock: dce_dc_wb1_dispdec_wbscl_dispdec
//WBSCL1_WBSCL_COEF_RAM_SELECT
#define WBSCL1_WBSCL_COEF_RAM_SELECT__WBSCL_COEF_RAM_TAP_PAIR_IDX__SHIFT                                      0x0
#define WBSCL1_WBSCL_COEF_RAM_SELECT__WBSCL_COEF_RAM_PHASE__SHIFT                                             0x8
#define WBSCL1_WBSCL_COEF_RAM_SELECT__WBSCL_COEF_RAM_FILTER_TYPE__SHIFT                                       0x10
#define WBSCL1_WBSCL_COEF_RAM_SELECT__WBSCL_COEF_RAM_TAP_PAIR_IDX_MASK                                        0x00000007L
#define WBSCL1_WBSCL_COEF_RAM_SELECT__WBSCL_COEF_RAM_PHASE_MASK                                               0x00000F00L
#define WBSCL1_WBSCL_COEF_RAM_SELECT__WBSCL_COEF_RAM_FILTER_TYPE_MASK                                         0x00030000L
//WBSCL1_WBSCL_COEF_RAM_TAP_DATA
#define WBSCL1_WBSCL_COEF_RAM_TAP_DATA__WBSCL_COEF_RAM_EVEN_TAP_COEF__SHIFT                                   0x0
#define WBSCL1_WBSCL_COEF_RAM_TAP_DATA__WBSCL_COEF_RAM_EVEN_TAP_COEF_EN__SHIFT                                0xf
#define WBSCL1_WBSCL_COEF_RAM_TAP_DATA__WBSCL_COEF_RAM_ODD_TAP_COEF__SHIFT                                    0x10
#define WBSCL1_WBSCL_COEF_RAM_TAP_DATA__WBSCL_COEF_RAM_ODD_TAP_COEF_EN__SHIFT                                 0x1f
#define WBSCL1_WBSCL_COEF_RAM_TAP_DATA__WBSCL_COEF_RAM_EVEN_TAP_COEF_MASK                                     0x00003FFFL
#define WBSCL1_WBSCL_COEF_RAM_TAP_DATA__WBSCL_COEF_RAM_EVEN_TAP_COEF_EN_MASK                                  0x00008000L
#define WBSCL1_WBSCL_COEF_RAM_TAP_DATA__WBSCL_COEF_RAM_ODD_TAP_COEF_MASK                                      0x3FFF0000L
#define WBSCL1_WBSCL_COEF_RAM_TAP_DATA__WBSCL_COEF_RAM_ODD_TAP_COEF_EN_MASK                                   0x80000000L
//WBSCL1_WBSCL_MODE
#define WBSCL1_WBSCL_MODE__WBSCL_MODE__SHIFT                                                                  0x0
#define WBSCL1_WBSCL_MODE__WBSCL_MODE_MASK                                                                    0x00000003L
//WBSCL1_WBSCL_TAP_CONTROL
#define WBSCL1_WBSCL_TAP_CONTROL__WBSCL_V_NUM_OF_TAPS_Y_RGB__SHIFT                                            0x0
#define WBSCL1_WBSCL_TAP_CONTROL__WBSCL_V_NUM_OF_TAPS_CBCR__SHIFT                                             0x4
#define WBSCL1_WBSCL_TAP_CONTROL__WBSCL_H_NUM_OF_TAPS_Y_RGB__SHIFT                                            0x8
#define WBSCL1_WBSCL_TAP_CONTROL__WBSCL_H_NUM_OF_TAPS_CBCR__SHIFT                                             0xc
#define WBSCL1_WBSCL_TAP_CONTROL__WBSCL_V_NUM_OF_TAPS_Y_RGB_MASK                                              0x0000000FL
#define WBSCL1_WBSCL_TAP_CONTROL__WBSCL_V_NUM_OF_TAPS_CBCR_MASK                                               0x000000F0L
#define WBSCL1_WBSCL_TAP_CONTROL__WBSCL_H_NUM_OF_TAPS_Y_RGB_MASK                                              0x00000F00L
#define WBSCL1_WBSCL_TAP_CONTROL__WBSCL_H_NUM_OF_TAPS_CBCR_MASK                                               0x0000F000L
//WBSCL1_WBSCL_DEST_SIZE
#define WBSCL1_WBSCL_DEST_SIZE__WBSCL_DEST_HEIGHT__SHIFT                                                      0x0
#define WBSCL1_WBSCL_DEST_SIZE__WBSCL_DEST_WIDTH__SHIFT                                                       0x10
#define WBSCL1_WBSCL_DEST_SIZE__WBSCL_DEST_HEIGHT_MASK                                                        0x00007FFFL
#define WBSCL1_WBSCL_DEST_SIZE__WBSCL_DEST_WIDTH_MASK                                                         0x7FFF0000L
//WBSCL1_WBSCL_HORZ_FILTER_SCALE_RATIO
#define WBSCL1_WBSCL_HORZ_FILTER_SCALE_RATIO__WBSCL_H_SCALE_RATIO__SHIFT                                      0x0
#define WBSCL1_WBSCL_HORZ_FILTER_SCALE_RATIO__WBSCL_H_SCALE_RATIO_MASK                                        0x07FFFFFFL
//WBSCL1_WBSCL_HORZ_FILTER_INIT_Y_RGB
#define WBSCL1_WBSCL_HORZ_FILTER_INIT_Y_RGB__WBSCL_H_INIT_FRAC_Y_RGB__SHIFT                                   0x0
#define WBSCL1_WBSCL_HORZ_FILTER_INIT_Y_RGB__WBSCL_H_INIT_INT_Y_RGB__SHIFT                                    0x18
#define WBSCL1_WBSCL_HORZ_FILTER_INIT_Y_RGB__WBSCL_H_INIT_FRAC_Y_RGB_MASK                                     0x00FFFFFFL
#define WBSCL1_WBSCL_HORZ_FILTER_INIT_Y_RGB__WBSCL_H_INIT_INT_Y_RGB_MASK                                      0x1F000000L
//WBSCL1_WBSCL_HORZ_FILTER_INIT_CBCR
#define WBSCL1_WBSCL_HORZ_FILTER_INIT_CBCR__WBSCL_H_INIT_FRAC_CBCR__SHIFT                                     0x0
#define WBSCL1_WBSCL_HORZ_FILTER_INIT_CBCR__WBSCL_H_INIT_INT_CBCR__SHIFT                                      0x18
#define WBSCL1_WBSCL_HORZ_FILTER_INIT_CBCR__WBSCL_H_INIT_FRAC_CBCR_MASK                                       0x00FFFFFFL
#define WBSCL1_WBSCL_HORZ_FILTER_INIT_CBCR__WBSCL_H_INIT_INT_CBCR_MASK                                        0x1F000000L
//WBSCL1_WBSCL_VERT_FILTER_SCALE_RATIO
#define WBSCL1_WBSCL_VERT_FILTER_SCALE_RATIO__WBSCL_V_SCALE_RATIO__SHIFT                                      0x0
#define WBSCL1_WBSCL_VERT_FILTER_SCALE_RATIO__WBSCL_V_SCALE_RATIO_MASK                                        0x07FFFFFFL
//WBSCL1_WBSCL_VERT_FILTER_INIT_Y_RGB
#define WBSCL1_WBSCL_VERT_FILTER_INIT_Y_RGB__WBSCL_V_INIT_FRAC_Y_RGB__SHIFT                                   0x0
#define WBSCL1_WBSCL_VERT_FILTER_INIT_Y_RGB__WBSCL_V_INIT_INT_Y_RGB__SHIFT                                    0x18
#define WBSCL1_WBSCL_VERT_FILTER_INIT_Y_RGB__WBSCL_V_INIT_FRAC_Y_RGB_MASK                                     0x00FFFFFFL
#define WBSCL1_WBSCL_VERT_FILTER_INIT_Y_RGB__WBSCL_V_INIT_INT_Y_RGB_MASK                                      0x1F000000L
//WBSCL1_WBSCL_VERT_FILTER_INIT_CBCR
#define WBSCL1_WBSCL_VERT_FILTER_INIT_CBCR__WBSCL_V_INIT_FRAC_CBCR__SHIFT                                     0x0
#define WBSCL1_WBSCL_VERT_FILTER_INIT_CBCR__WBSCL_V_INIT_INT_CBCR__SHIFT                                      0x18
#define WBSCL1_WBSCL_VERT_FILTER_INIT_CBCR__WBSCL_V_INIT_FRAC_CBCR_MASK                                       0x00FFFFFFL
#define WBSCL1_WBSCL_VERT_FILTER_INIT_CBCR__WBSCL_V_INIT_INT_CBCR_MASK                                        0x1F000000L
//WBSCL1_WBSCL_ROUND_OFFSET
#define WBSCL1_WBSCL_ROUND_OFFSET__WBSCL_ROUND_OFFSET_Y_RGB__SHIFT                                            0x0
#define WBSCL1_WBSCL_ROUND_OFFSET__WBSCL_ROUND_OFFSET_CBCR__SHIFT                                             0x10
#define WBSCL1_WBSCL_ROUND_OFFSET__WBSCL_ROUND_OFFSET_Y_RGB_MASK                                              0x0000FFFFL
#define WBSCL1_WBSCL_ROUND_OFFSET__WBSCL_ROUND_OFFSET_CBCR_MASK                                               0xFFFF0000L
//WBSCL1_WBSCL_CLAMP
#define WBSCL1_WBSCL_CLAMP__WBSCL_CLAMP_UPPER_Y_RGB__SHIFT                                                    0x0
#define WBSCL1_WBSCL_CLAMP__WBSCL_CLAMP_LOWER_Y_RGB__SHIFT                                                    0x8
#define WBSCL1_WBSCL_CLAMP__WBSCL_CLAMP_UPPER_CBCR__SHIFT                                                     0x10
#define WBSCL1_WBSCL_CLAMP__WBSCL_CLAMP_LOWER_CBCR__SHIFT                                                     0x18
#define WBSCL1_WBSCL_CLAMP__WBSCL_CLAMP_UPPER_Y_RGB_MASK                                                      0x000000FFL
#define WBSCL1_WBSCL_CLAMP__WBSCL_CLAMP_LOWER_Y_RGB_MASK                                                      0x0000FF00L
#define WBSCL1_WBSCL_CLAMP__WBSCL_CLAMP_UPPER_CBCR_MASK                                                       0x00FF0000L
#define WBSCL1_WBSCL_CLAMP__WBSCL_CLAMP_LOWER_CBCR_MASK                                                       0xFF000000L
//WBSCL1_WBSCL_OVERFLOW_STATUS
#define WBSCL1_WBSCL_OVERFLOW_STATUS__WBSCL_DATA_OVERFLOW_FLAG__SHIFT                                         0x0
#define WBSCL1_WBSCL_OVERFLOW_STATUS__WBSCL_DATA_OVERFLOW_ACK__SHIFT                                          0x8
#define WBSCL1_WBSCL_OVERFLOW_STATUS__WBSCL_DATA_OVERFLOW_MASK__SHIFT                                         0xc
#define WBSCL1_WBSCL_OVERFLOW_STATUS__WBSCL_DATA_OVERFLOW_INT_STATUS__SHIFT                                   0x10
#define WBSCL1_WBSCL_OVERFLOW_STATUS__WBSCL_DATA_OVERFLOW_INT_TYPE__SHIFT                                     0x14
#define WBSCL1_WBSCL_OVERFLOW_STATUS__WBSCL_DATA_OVERFLOW_FLAG_MASK                                           0x00000001L
#define WBSCL1_WBSCL_OVERFLOW_STATUS__WBSCL_DATA_OVERFLOW_ACK_MASK                                            0x00000100L
#define WBSCL1_WBSCL_OVERFLOW_STATUS__WBSCL_DATA_OVERFLOW_MASK_MASK                                           0x00001000L
#define WBSCL1_WBSCL_OVERFLOW_STATUS__WBSCL_DATA_OVERFLOW_INT_STATUS_MASK                                     0x00010000L
#define WBSCL1_WBSCL_OVERFLOW_STATUS__WBSCL_DATA_OVERFLOW_INT_TYPE_MASK                                       0x00100000L
//WBSCL1_WBSCL_COEF_RAM_CONFLICT_STATUS
#define WBSCL1_WBSCL_COEF_RAM_CONFLICT_STATUS__WBSCL_HOST_CONFLICT_FLAG__SHIFT                                0x0
#define WBSCL1_WBSCL_COEF_RAM_CONFLICT_STATUS__WBSCL_HOST_CONFLICT_ACK__SHIFT                                 0x8
#define WBSCL1_WBSCL_COEF_RAM_CONFLICT_STATUS__WBSCL_HOST_CONFLICT_MASK__SHIFT                                0xc
#define WBSCL1_WBSCL_COEF_RAM_CONFLICT_STATUS__WBSCL_HOST_CONFLICT_INT_STATUS__SHIFT                          0x10
#define WBSCL1_WBSCL_COEF_RAM_CONFLICT_STATUS__WBSCL_HOST_CONFLICT_INT_TYPE__SHIFT                            0x14
#define WBSCL1_WBSCL_COEF_RAM_CONFLICT_STATUS__WBSCL_HOST_CONFLICT_FLAG_MASK                                  0x00000001L
#define WBSCL1_WBSCL_COEF_RAM_CONFLICT_STATUS__WBSCL_HOST_CONFLICT_ACK_MASK                                   0x00000100L
#define WBSCL1_WBSCL_COEF_RAM_CONFLICT_STATUS__WBSCL_HOST_CONFLICT_MASK_MASK                                  0x00001000L
#define WBSCL1_WBSCL_COEF_RAM_CONFLICT_STATUS__WBSCL_HOST_CONFLICT_INT_STATUS_MASK                            0x00010000L
#define WBSCL1_WBSCL_COEF_RAM_CONFLICT_STATUS__WBSCL_HOST_CONFLICT_INT_TYPE_MASK                              0x00100000L
//WBSCL1_WBSCL_OUTSIDE_PIX_STRATEGY
#define WBSCL1_WBSCL_OUTSIDE_PIX_STRATEGY__WBSCL_OUTSIDE_PIX_STRATEGY__SHIFT                                  0x0
#define WBSCL1_WBSCL_OUTSIDE_PIX_STRATEGY__WBSCL_BLACK_COLOR_B_CB__SHIFT                                      0x8
#define WBSCL1_WBSCL_OUTSIDE_PIX_STRATEGY__WBSCL_BLACK_COLOR_G_Y__SHIFT                                       0x10
#define WBSCL1_WBSCL_OUTSIDE_PIX_STRATEGY__WBSCL_BLACK_COLOR_R_CR__SHIFT                                      0x18
#define WBSCL1_WBSCL_OUTSIDE_PIX_STRATEGY__WBSCL_OUTSIDE_PIX_STRATEGY_MASK                                    0x00000001L
#define WBSCL1_WBSCL_OUTSIDE_PIX_STRATEGY__WBSCL_BLACK_COLOR_B_CB_MASK                                        0x0000FF00L
#define WBSCL1_WBSCL_OUTSIDE_PIX_STRATEGY__WBSCL_BLACK_COLOR_G_Y_MASK                                         0x00FF0000L
#define WBSCL1_WBSCL_OUTSIDE_PIX_STRATEGY__WBSCL_BLACK_COLOR_R_CR_MASK                                        0xFF000000L
//WBSCL1_WBSCL_TEST_CNTL
#define WBSCL1_WBSCL_TEST_CNTL__WBSCL_TEST_CRC_EN__SHIFT                                                      0x4
#define WBSCL1_WBSCL_TEST_CNTL__WBSCL_TEST_CRC_CONT_EN__SHIFT                                                 0x8
#define WBSCL1_WBSCL_TEST_CNTL__WBSCL_TEST_CRC_DE_ONLY__SHIFT                                                 0x10
#define WBSCL1_WBSCL_TEST_CNTL__WBSCL_TEST_CRC_EN_MASK                                                        0x00000010L
#define WBSCL1_WBSCL_TEST_CNTL__WBSCL_TEST_CRC_CONT_EN_MASK                                                   0x00000100L
#define WBSCL1_WBSCL_TEST_CNTL__WBSCL_TEST_CRC_DE_ONLY_MASK                                                   0x00010000L
//WBSCL1_WBSCL_TEST_CRC_RED
#define WBSCL1_WBSCL_TEST_CRC_RED__WBSCL_TEST_CRC_RED_MASK__SHIFT                                             0x8
#define WBSCL1_WBSCL_TEST_CRC_RED__WBSCL_TEST_CRC_SIG_RED__SHIFT                                              0x10
#define WBSCL1_WBSCL_TEST_CRC_RED__WBSCL_TEST_CRC_RED_MASK_MASK                                               0x0000FF00L
#define WBSCL1_WBSCL_TEST_CRC_RED__WBSCL_TEST_CRC_SIG_RED_MASK                                                0xFFFF0000L
//WBSCL1_WBSCL_TEST_CRC_GREEN
#define WBSCL1_WBSCL_TEST_CRC_GREEN__WBSCL_TEST_CRC_GREEN_MASK__SHIFT                                         0x0
#define WBSCL1_WBSCL_TEST_CRC_GREEN__WBSCL_TEST_CRC_SIG_GREEN__SHIFT                                          0x10
#define WBSCL1_WBSCL_TEST_CRC_GREEN__WBSCL_TEST_CRC_GREEN_MASK_MASK                                           0x0000FFFFL
#define WBSCL1_WBSCL_TEST_CRC_GREEN__WBSCL_TEST_CRC_SIG_GREEN_MASK                                            0xFFFF0000L
//WBSCL1_WBSCL_TEST_CRC_BLUE
#define WBSCL1_WBSCL_TEST_CRC_BLUE__WBSCL_TEST_CRC_BLUE_MASK__SHIFT                                           0x8
#define WBSCL1_WBSCL_TEST_CRC_BLUE__WBSCL_TEST_CRC_SIG_BLUE__SHIFT                                            0x10
#define WBSCL1_WBSCL_TEST_CRC_BLUE__WBSCL_TEST_CRC_BLUE_MASK_MASK                                             0x0000FF00L
#define WBSCL1_WBSCL_TEST_CRC_BLUE__WBSCL_TEST_CRC_SIG_BLUE_MASK                                              0xFFFF0000L
//WBSCL1_WBSCL_BACKPRESSURE_CNT_EN
#define WBSCL1_WBSCL_BACKPRESSURE_CNT_EN__WBSCL_BACKPRESSURE_CNT_EN__SHIFT                                    0x0
#define WBSCL1_WBSCL_BACKPRESSURE_CNT_EN__WBSCL_BACKPRESSURE_CNT_EN_MASK                                      0x00000001L
//WBSCL1_WB_MCIF_BACKPRESSURE_CNT
#define WBSCL1_WB_MCIF_BACKPRESSURE_CNT__WB_MCIF_Y_MAX_BACKPRESSURE__SHIFT                                    0x0
#define WBSCL1_WB_MCIF_BACKPRESSURE_CNT__WB_MCIF_C_MAX_BACKPRESSURE__SHIFT                                    0x10
#define WBSCL1_WB_MCIF_BACKPRESSURE_CNT__WB_MCIF_Y_MAX_BACKPRESSURE_MASK                                      0x0000FFFFL
#define WBSCL1_WB_MCIF_BACKPRESSURE_CNT__WB_MCIF_C_MAX_BACKPRESSURE_MASK                                      0xFFFF0000L
//WBSCL1_WBSCL_RAM_SHUTDOWN
#define WBSCL1_WBSCL_RAM_SHUTDOWN__WBSCL_RAM_SHUTDOWN_SEL__SHIFT                                              0x0
#define WBSCL1_WBSCL_RAM_SHUTDOWN__WBSCL_RAM_SHUTDOWN_SEL_MASK                                                0x00000003L


// addressBlock: dce_dc_wb1_dispdec_wb_dcperfmon_dc_perfmon_dispdec
//DC_PERFMON4_PERFCOUNTER_CNTL
#define DC_PERFMON4_PERFCOUNTER_CNTL__PERFCOUNTER_EVENT_SEL__SHIFT                                            0x0
#define DC_PERFMON4_PERFCOUNTER_CNTL__PERFCOUNTER_CVALUE_SEL__SHIFT                                           0x9
#define DC_PERFMON4_PERFCOUNTER_CNTL__PERFCOUNTER_INC_MODE__SHIFT                                             0xc
#define DC_PERFMON4_PERFCOUNTER_CNTL__PERFCOUNTER_HW_CNTL_SEL__SHIFT                                          0xf
#define DC_PERFMON4_PERFCOUNTER_CNTL__PERFCOUNTER_RUNEN_MODE__SHIFT                                           0x10
#define DC_PERFMON4_PERFCOUNTER_CNTL__PERFCOUNTER_CNTOFF_START_DIS__SHIFT                                     0x16
#define DC_PERFMON4_PERFCOUNTER_CNTL__PERFCOUNTER_RESTART_EN__SHIFT                                           0x17
#define DC_PERFMON4_PERFCOUNTER_CNTL__PERFCOUNTER_INT_EN__SHIFT                                               0x18
#define DC_PERFMON4_PERFCOUNTER_CNTL__PERFCOUNTER_OFF_MASK__SHIFT                                             0x19
#define DC_PERFMON4_PERFCOUNTER_CNTL__PERFCOUNTER_ACTIVE__SHIFT                                               0x1a
#define DC_PERFMON4_PERFCOUNTER_CNTL__PERFCOUNTER_CNTL_SEL__SHIFT                                             0x1d
#define DC_PERFMON4_PERFCOUNTER_CNTL__PERFCOUNTER_EVENT_SEL_MASK                                              0x000001FFL
#define DC_PERFMON4_PERFCOUNTER_CNTL__PERFCOUNTER_CVALUE_SEL_MASK                                             0x00000E00L
#define DC_PERFMON4_PERFCOUNTER_CNTL__PERFCOUNTER_INC_MODE_MASK                                               0x00007000L
#define DC_PERFMON4_PERFCOUNTER_CNTL__PERFCOUNTER_HW_CNTL_SEL_MASK                                            0x00008000L
#define DC_PERFMON4_PERFCOUNTER_CNTL__PERFCOUNTER_RUNEN_MODE_MASK                                             0x00010000L
#define DC_PERFMON4_PERFCOUNTER_CNTL__PERFCOUNTER_CNTOFF_START_DIS_MASK                                       0x00400000L
#define DC_PERFMON4_PERFCOUNTER_CNTL__PERFCOUNTER_RESTART_EN_MASK                                             0x00800000L
#define DC_PERFMON4_PERFCOUNTER_CNTL__PERFCOUNTER_INT_EN_MASK                                                 0x01000000L
#define DC_PERFMON4_PERFCOUNTER_CNTL__PERFCOUNTER_OFF_MASK_MASK                                               0x02000000L
#define DC_PERFMON4_PERFCOUNTER_CNTL__PERFCOUNTER_ACTIVE_MASK                                                 0x04000000L
#define DC_PERFMON4_PERFCOUNTER_CNTL__PERFCOUNTER_CNTL_SEL_MASK                                               0xE0000000L
//DC_PERFMON4_PERFCOUNTER_CNTL2
#define DC_PERFMON4_PERFCOUNTER_CNTL2__PERFCOUNTER_COUNTED_VALUE_TYPE__SHIFT                                  0x0
#define DC_PERFMON4_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP1_SEL__SHIFT                                        0x2
#define DC_PERFMON4_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP2_SEL__SHIFT                                        0x3
#define DC_PERFMON4_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTOFF_SEL__SHIFT                                          0x8
#define DC_PERFMON4_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTL2_SEL__SHIFT                                           0x1d
#define DC_PERFMON4_PERFCOUNTER_CNTL2__PERFCOUNTER_COUNTED_VALUE_TYPE_MASK                                    0x00000003L
#define DC_PERFMON4_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP1_SEL_MASK                                          0x00000004L
#define DC_PERFMON4_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP2_SEL_MASK                                          0x00000008L
#define DC_PERFMON4_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTOFF_SEL_MASK                                            0x00003F00L
#define DC_PERFMON4_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTL2_SEL_MASK                                             0xE0000000L
//DC_PERFMON4_PERFCOUNTER_STATE
#define DC_PERFMON4_PERFCOUNTER_STATE__PERFCOUNTER_CNT0_STATE__SHIFT                                          0x0
#define DC_PERFMON4_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL0__SHIFT                                          0x2
#define DC_PERFMON4_PERFCOUNTER_STATE__PERFCOUNTER_CNT1_STATE__SHIFT                                          0x4
#define DC_PERFMON4_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL1__SHIFT                                          0x6
#define DC_PERFMON4_PERFCOUNTER_STATE__PERFCOUNTER_CNT2_STATE__SHIFT                                          0x8
#define DC_PERFMON4_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL2__SHIFT                                          0xa
#define DC_PERFMON4_PERFCOUNTER_STATE__PERFCOUNTER_CNT3_STATE__SHIFT                                          0xc
#define DC_PERFMON4_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL3__SHIFT                                          0xe
#define DC_PERFMON4_PERFCOUNTER_STATE__PERFCOUNTER_CNT4_STATE__SHIFT                                          0x10
#define DC_PERFMON4_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL4__SHIFT                                          0x12
#define DC_PERFMON4_PERFCOUNTER_STATE__PERFCOUNTER_CNT5_STATE__SHIFT                                          0x14
#define DC_PERFMON4_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL5__SHIFT                                          0x16
#define DC_PERFMON4_PERFCOUNTER_STATE__PERFCOUNTER_CNT6_STATE__SHIFT                                          0x18
#define DC_PERFMON4_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL6__SHIFT                                          0x1a
#define DC_PERFMON4_PERFCOUNTER_STATE__PERFCOUNTER_CNT7_STATE__SHIFT                                          0x1c
#define DC_PERFMON4_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL7__SHIFT                                          0x1e
#define DC_PERFMON4_PERFCOUNTER_STATE__PERFCOUNTER_CNT0_STATE_MASK                                            0x00000003L
#define DC_PERFMON4_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL0_MASK                                            0x00000004L
#define DC_PERFMON4_PERFCOUNTER_STATE__PERFCOUNTER_CNT1_STATE_MASK                                            0x00000030L
#define DC_PERFMON4_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL1_MASK                                            0x00000040L
#define DC_PERFMON4_PERFCOUNTER_STATE__PERFCOUNTER_CNT2_STATE_MASK                                            0x00000300L
#define DC_PERFMON4_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL2_MASK                                            0x00000400L
#define DC_PERFMON4_PERFCOUNTER_STATE__PERFCOUNTER_CNT3_STATE_MASK                                            0x00003000L
#define DC_PERFMON4_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL3_MASK                                            0x00004000L
#define DC_PERFMON4_PERFCOUNTER_STATE__PERFCOUNTER_CNT4_STATE_MASK                                            0x00030000L
#define DC_PERFMON4_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL4_MASK                                            0x00040000L
#define DC_PERFMON4_PERFCOUNTER_STATE__PERFCOUNTER_CNT5_STATE_MASK                                            0x00300000L
#define DC_PERFMON4_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL5_MASK                                            0x00400000L
#define DC_PERFMON4_PERFCOUNTER_STATE__PERFCOUNTER_CNT6_STATE_MASK                                            0x03000000L
#define DC_PERFMON4_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL6_MASK                                            0x04000000L
#define DC_PERFMON4_PERFCOUNTER_STATE__PERFCOUNTER_CNT7_STATE_MASK                                            0x30000000L
#define DC_PERFMON4_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL7_MASK                                            0x40000000L
//DC_PERFMON4_PERFMON_CNTL
#define DC_PERFMON4_PERFMON_CNTL__PERFMON_STATE__SHIFT                                                        0x0
#define DC_PERFMON4_PERFMON_CNTL__PERFMON_RPT_COUNT__SHIFT                                                    0x8
#define DC_PERFMON4_PERFMON_CNTL__PERFMON_CNTOFF_AND_OR__SHIFT                                                0x1c
#define DC_PERFMON4_PERFMON_CNTL__PERFMON_CNTOFF_INT_EN__SHIFT                                                0x1d
#define DC_PERFMON4_PERFMON_CNTL__PERFMON_CNTOFF_INT_STATUS__SHIFT                                            0x1e
#define DC_PERFMON4_PERFMON_CNTL__PERFMON_CNTOFF_INT_ACK__SHIFT                                               0x1f
#define DC_PERFMON4_PERFMON_CNTL__PERFMON_STATE_MASK                                                          0x00000003L
#define DC_PERFMON4_PERFMON_CNTL__PERFMON_RPT_COUNT_MASK                                                      0x0FFFFF00L
#define DC_PERFMON4_PERFMON_CNTL__PERFMON_CNTOFF_AND_OR_MASK                                                  0x10000000L
#define DC_PERFMON4_PERFMON_CNTL__PERFMON_CNTOFF_INT_EN_MASK                                                  0x20000000L
#define DC_PERFMON4_PERFMON_CNTL__PERFMON_CNTOFF_INT_STATUS_MASK                                              0x40000000L
#define DC_PERFMON4_PERFMON_CNTL__PERFMON_CNTOFF_INT_ACK_MASK                                                 0x80000000L
//DC_PERFMON4_PERFMON_CNTL2
#define DC_PERFMON4_PERFMON_CNTL2__PERFMON_CNTOFF_INT_TYPE__SHIFT                                             0x0
#define DC_PERFMON4_PERFMON_CNTL2__PERFMON_CLK_ENABLE__SHIFT                                                  0x1
#define DC_PERFMON4_PERFMON_CNTL2__PERFMON_RUN_ENABLE_START_SEL__SHIFT                                        0x2
#define DC_PERFMON4_PERFMON_CNTL2__PERFMON_RUN_ENABLE_STOP_SEL__SHIFT                                         0xa
#define DC_PERFMON4_PERFMON_CNTL2__PERFMON_CNTOFF_INT_TYPE_MASK                                               0x00000001L
#define DC_PERFMON4_PERFMON_CNTL2__PERFMON_CLK_ENABLE_MASK                                                    0x00000002L
#define DC_PERFMON4_PERFMON_CNTL2__PERFMON_RUN_ENABLE_START_SEL_MASK                                          0x000003FCL
#define DC_PERFMON4_PERFMON_CNTL2__PERFMON_RUN_ENABLE_STOP_SEL_MASK                                           0x0003FC00L
//DC_PERFMON4_PERFMON_CVALUE_INT_MISC
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_STATUS__SHIFT                                   0x0
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_STATUS__SHIFT                                   0x1
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_STATUS__SHIFT                                   0x2
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_STATUS__SHIFT                                   0x3
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_STATUS__SHIFT                                   0x4
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_STATUS__SHIFT                                   0x5
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_STATUS__SHIFT                                   0x6
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_STATUS__SHIFT                                   0x7
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_ACK__SHIFT                                      0x8
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_ACK__SHIFT                                      0x9
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_ACK__SHIFT                                      0xa
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_ACK__SHIFT                                      0xb
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_ACK__SHIFT                                      0xc
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_ACK__SHIFT                                      0xd
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_ACK__SHIFT                                      0xe
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_ACK__SHIFT                                      0xf
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFMON_CVALUE_HI__SHIFT                                         0x10
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_STATUS_MASK                                     0x00000001L
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_STATUS_MASK                                     0x00000002L
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_STATUS_MASK                                     0x00000004L
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_STATUS_MASK                                     0x00000008L
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_STATUS_MASK                                     0x00000010L
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_STATUS_MASK                                     0x00000020L
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_STATUS_MASK                                     0x00000040L
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_STATUS_MASK                                     0x00000080L
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_ACK_MASK                                        0x00000100L
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_ACK_MASK                                        0x00000200L
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_ACK_MASK                                        0x00000400L
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_ACK_MASK                                        0x00000800L
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_ACK_MASK                                        0x00001000L
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_ACK_MASK                                        0x00002000L
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_ACK_MASK                                        0x00004000L
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_ACK_MASK                                        0x00008000L
#define DC_PERFMON4_PERFMON_CVALUE_INT_MISC__PERFMON_CVALUE_HI_MASK                                           0xFFFF0000L
//DC_PERFMON4_PERFMON_CVALUE_LOW
#define DC_PERFMON4_PERFMON_CVALUE_LOW__PERFMON_CVALUE_LOW__SHIFT                                             0x0
#define DC_PERFMON4_PERFMON_CVALUE_LOW__PERFMON_CVALUE_LOW_MASK                                               0xFFFFFFFFL
//DC_PERFMON4_PERFMON_HI
#define DC_PERFMON4_PERFMON_HI__PERFMON_HI__SHIFT                                                             0x0
#define DC_PERFMON4_PERFMON_HI__PERFMON_READ_SEL__SHIFT                                                       0x1d
#define DC_PERFMON4_PERFMON_HI__PERFMON_HI_MASK                                                               0x0000FFFFL
#define DC_PERFMON4_PERFMON_HI__PERFMON_READ_SEL_MASK                                                         0xE0000000L
//DC_PERFMON4_PERFMON_LOW
#define DC_PERFMON4_PERFMON_LOW__PERFMON_LOW__SHIFT                                                           0x0
#define DC_PERFMON4_PERFMON_LOW__PERFMON_LOW_MASK                                                             0xFFFFFFFFL


// addressBlock: dce_dc_mmhubbub_mcif_wb0_dispdec
//MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_ENABLE__SHIFT                                      0x0
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUF_DUALSIZE_REQ__SHIFT                                   0x1
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_INT_EN__SHIFT                                   0x4
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_INT_ACK__SHIFT                                  0x5
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_SLICE_INT_EN__SHIFT                             0x6
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_OVERRUN_INT_EN__SHIFT                           0x7
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_LOCK__SHIFT                                     0x8
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_P_VMID__SHIFT                                             0x10
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUF_ADDR_FENCE_EN__SHIFT                                  0x18
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_ENABLE_MASK                                        0x00000001L
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUF_DUALSIZE_REQ_MASK                                     0x00000002L
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_INT_EN_MASK                                     0x00000010L
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_INT_ACK_MASK                                    0x00000020L
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_SLICE_INT_EN_MASK                               0x00000040L
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_OVERRUN_INT_EN_MASK                             0x00000080L
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_LOCK_MASK                                       0x00000F00L
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_P_VMID_MASK                                               0x000F0000L
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUF_ADDR_FENCE_EN_MASK                                    0x01000000L
//MCIF_WB0_MCIF_WB_BUFMGR_CUR_LINE_R
#define MCIF_WB0_MCIF_WB_BUFMGR_CUR_LINE_R__MCIF_WB_BUFMGR_CUR_LINE_R__SHIFT                                  0x0
#define MCIF_WB0_MCIF_WB_BUFMGR_CUR_LINE_R__MCIF_WB_BUFMGR_CUR_LINE_R_MASK                                    0x00001FFFL
//MCIF_WB0_MCIF_WB_BUFMGR_STATUS
#define MCIF_WB0_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_VCE_INT_STATUS__SHIFT                                  0x0
#define MCIF_WB0_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_SW_INT_STATUS__SHIFT                                   0x1
#define MCIF_WB0_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_SW_OVERRUN_INT_STATUS__SHIFT                           0x2
#define MCIF_WB0_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_CUR_BUF__SHIFT                                         0x4
#define MCIF_WB0_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUF_DUALSIZE_STATUS__SHIFT                                    0x7
#define MCIF_WB0_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_BUFTAG__SHIFT                                          0x8
#define MCIF_WB0_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_CUR_LINE_L__SHIFT                                      0xc
#define MCIF_WB0_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_NEXT_BUF__SHIFT                                        0x1c
#define MCIF_WB0_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_VCE_INT_STATUS_MASK                                    0x00000001L
#define MCIF_WB0_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_SW_INT_STATUS_MASK                                     0x00000002L
#define MCIF_WB0_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_SW_OVERRUN_INT_STATUS_MASK                             0x00000004L
#define MCIF_WB0_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_CUR_BUF_MASK                                           0x00000070L
#define MCIF_WB0_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUF_DUALSIZE_STATUS_MASK                                      0x00000080L
#define MCIF_WB0_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_BUFTAG_MASK                                            0x00000F00L
#define MCIF_WB0_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_CUR_LINE_L_MASK                                        0x01FFF000L
#define MCIF_WB0_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_NEXT_BUF_MASK                                          0x70000000L
//MCIF_WB0_MCIF_WB_BUF_PITCH
#define MCIF_WB0_MCIF_WB_BUF_PITCH__MCIF_WB_BUF_LUMA_PITCH__SHIFT                                             0x8
#define MCIF_WB0_MCIF_WB_BUF_PITCH__MCIF_WB_BUF_CHROMA_PITCH__SHIFT                                           0x18
#define MCIF_WB0_MCIF_WB_BUF_PITCH__MCIF_WB_BUF_LUMA_PITCH_MASK                                               0x0000FF00L
#define MCIF_WB0_MCIF_WB_BUF_PITCH__MCIF_WB_BUF_CHROMA_PITCH_MASK                                             0xFF000000L
//MCIF_WB0_MCIF_WB_BUF_1_STATUS
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_ACTIVE__SHIFT                                            0x0
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_SW_LOCKED__SHIFT                                         0x1
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_VCE_LOCKED__SHIFT                                        0x2
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_OVERFLOW__SHIFT                                          0x3
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_DISABLE__SHIFT                                           0x4
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_MODE__SHIFT                                              0x5
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_BUFTAG__SHIFT                                            0x8
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_NXT_BUF__SHIFT                                           0xc
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_FIELD__SHIFT                                             0xf
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_CUR_LINE_L__SHIFT                                        0x10
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_LONG_LINE_ERROR__SHIFT                                   0x1d
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_SHORT_LINE_ERROR__SHIFT                                  0x1e
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_FRAME_LENGTH_ERROR__SHIFT                                0x1f
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_ACTIVE_MASK                                              0x00000001L
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_SW_LOCKED_MASK                                           0x00000002L
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_VCE_LOCKED_MASK                                          0x00000004L
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_OVERFLOW_MASK                                            0x00000008L
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_DISABLE_MASK                                             0x00000010L
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_MODE_MASK                                                0x000000E0L
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_BUFTAG_MASK                                              0x00000F00L
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_NXT_BUF_MASK                                             0x00007000L
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_FIELD_MASK                                               0x00008000L
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_CUR_LINE_L_MASK                                          0x1FFF0000L
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_LONG_LINE_ERROR_MASK                                     0x20000000L
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_SHORT_LINE_ERROR_MASK                                    0x40000000L
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_FRAME_LENGTH_ERROR_MASK                                  0x80000000L
//MCIF_WB0_MCIF_WB_BUF_1_STATUS2
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_CUR_LINE_R__SHIFT                                       0x0
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_NEW_CONTENT__SHIFT                                      0xd
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_COLOR_DEPTH__SHIFT                                      0xe
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_Y_OVERRUN__SHIFT                                        0x11
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_C_OVERRUN__SHIFT                                        0x12
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_CUR_LINE_R_MASK                                         0x00001FFFL
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_NEW_CONTENT_MASK                                        0x00002000L
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_COLOR_DEPTH_MASK                                        0x00004000L
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_Y_OVERRUN_MASK                                          0x00020000L
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_C_OVERRUN_MASK                                          0x00040000L
//MCIF_WB0_MCIF_WB_BUF_2_STATUS
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_ACTIVE__SHIFT                                            0x0
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_SW_LOCKED__SHIFT                                         0x1
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_VCE_LOCKED__SHIFT                                        0x2
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_OVERFLOW__SHIFT                                          0x3
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_DISABLE__SHIFT                                           0x4
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_MODE__SHIFT                                              0x5
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_BUFTAG__SHIFT                                            0x8
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_NXT_BUF__SHIFT                                           0xc
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_FIELD__SHIFT                                             0xf
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_CUR_LINE_L__SHIFT                                        0x10
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_LONG_LINE_ERROR__SHIFT                                   0x1d
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_SHORT_LINE_ERROR__SHIFT                                  0x1e
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_FRAME_LENGTH_ERROR__SHIFT                                0x1f
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_ACTIVE_MASK                                              0x00000001L
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_SW_LOCKED_MASK                                           0x00000002L
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_VCE_LOCKED_MASK                                          0x00000004L
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_OVERFLOW_MASK                                            0x00000008L
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_DISABLE_MASK                                             0x00000010L
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_MODE_MASK                                                0x000000E0L
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_BUFTAG_MASK                                              0x00000F00L
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_NXT_BUF_MASK                                             0x00007000L
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_FIELD_MASK                                               0x00008000L
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_CUR_LINE_L_MASK                                          0x1FFF0000L
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_LONG_LINE_ERROR_MASK                                     0x20000000L
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_SHORT_LINE_ERROR_MASK                                    0x40000000L
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_FRAME_LENGTH_ERROR_MASK                                  0x80000000L
//MCIF_WB0_MCIF_WB_BUF_2_STATUS2
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_CUR_LINE_R__SHIFT                                       0x0
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_NEW_CONTENT__SHIFT                                      0xd
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_COLOR_DEPTH__SHIFT                                      0xe
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_Y_OVERRUN__SHIFT                                        0x11
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_C_OVERRUN__SHIFT                                        0x12
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_CUR_LINE_R_MASK                                         0x00001FFFL
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_NEW_CONTENT_MASK                                        0x00002000L
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_COLOR_DEPTH_MASK                                        0x00004000L
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_Y_OVERRUN_MASK                                          0x00020000L
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_C_OVERRUN_MASK                                          0x00040000L
//MCIF_WB0_MCIF_WB_BUF_3_STATUS
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_ACTIVE__SHIFT                                            0x0
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_SW_LOCKED__SHIFT                                         0x1
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_VCE_LOCKED__SHIFT                                        0x2
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_OVERFLOW__SHIFT                                          0x3
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_DISABLE__SHIFT                                           0x4
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_MODE__SHIFT                                              0x5
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_BUFTAG__SHIFT                                            0x8
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_NXT_BUF__SHIFT                                           0xc
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_FIELD__SHIFT                                             0xf
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_CUR_LINE_L__SHIFT                                        0x10
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_LONG_LINE_ERROR__SHIFT                                   0x1d
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_SHORT_LINE_ERROR__SHIFT                                  0x1e
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_FRAME_LENGTH_ERROR__SHIFT                                0x1f
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_ACTIVE_MASK                                              0x00000001L
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_SW_LOCKED_MASK                                           0x00000002L
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_VCE_LOCKED_MASK                                          0x00000004L
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_OVERFLOW_MASK                                            0x00000008L
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_DISABLE_MASK                                             0x00000010L
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_MODE_MASK                                                0x000000E0L
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_BUFTAG_MASK                                              0x00000F00L
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_NXT_BUF_MASK                                             0x00007000L
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_FIELD_MASK                                               0x00008000L
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_CUR_LINE_L_MASK                                          0x1FFF0000L
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_LONG_LINE_ERROR_MASK                                     0x20000000L
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_SHORT_LINE_ERROR_MASK                                    0x40000000L
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_FRAME_LENGTH_ERROR_MASK                                  0x80000000L
//MCIF_WB0_MCIF_WB_BUF_3_STATUS2
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_CUR_LINE_R__SHIFT                                       0x0
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_NEW_CONTENT__SHIFT                                      0xd
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_COLOR_DEPTH__SHIFT                                      0xe
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_Y_OVERRUN__SHIFT                                        0x11
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_C_OVERRUN__SHIFT                                        0x12
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_CUR_LINE_R_MASK                                         0x00001FFFL
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_NEW_CONTENT_MASK                                        0x00002000L
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_COLOR_DEPTH_MASK                                        0x00004000L
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_Y_OVERRUN_MASK                                          0x00020000L
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_C_OVERRUN_MASK                                          0x00040000L
//MCIF_WB0_MCIF_WB_BUF_4_STATUS
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_ACTIVE__SHIFT                                            0x0
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_SW_LOCKED__SHIFT                                         0x1
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_VCE_LOCKED__SHIFT                                        0x2
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_OVERFLOW__SHIFT                                          0x3
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_DISABLE__SHIFT                                           0x4
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_MODE__SHIFT                                              0x5
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_BUFTAG__SHIFT                                            0x8
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_NXT_BUF__SHIFT                                           0xc
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_FIELD__SHIFT                                             0xf
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_CUR_LINE_L__SHIFT                                        0x10
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_LONG_LINE_ERROR__SHIFT                                   0x1d
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_SHORT_LINE_ERROR__SHIFT                                  0x1e
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_FRAME_LENGTH_ERROR__SHIFT                                0x1f
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_ACTIVE_MASK                                              0x00000001L
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_SW_LOCKED_MASK                                           0x00000002L
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_VCE_LOCKED_MASK                                          0x00000004L
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_OVERFLOW_MASK                                            0x00000008L
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_DISABLE_MASK                                             0x00000010L
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_MODE_MASK                                                0x000000E0L
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_BUFTAG_MASK                                              0x00000F00L
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_NXT_BUF_MASK                                             0x00007000L
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_FIELD_MASK                                               0x00008000L
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_CUR_LINE_L_MASK                                          0x1FFF0000L
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_LONG_LINE_ERROR_MASK                                     0x20000000L
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_SHORT_LINE_ERROR_MASK                                    0x40000000L
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_FRAME_LENGTH_ERROR_MASK                                  0x80000000L
//MCIF_WB0_MCIF_WB_BUF_4_STATUS2
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_CUR_LINE_R__SHIFT                                       0x0
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_NEW_CONTENT__SHIFT                                      0xd
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_COLOR_DEPTH__SHIFT                                      0xe
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_Y_OVERRUN__SHIFT                                        0x11
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_C_OVERRUN__SHIFT                                        0x12
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_CUR_LINE_R_MASK                                         0x00001FFFL
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_NEW_CONTENT_MASK                                        0x00002000L
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_COLOR_DEPTH_MASK                                        0x00004000L
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_Y_OVERRUN_MASK                                          0x00020000L
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_C_OVERRUN_MASK                                          0x00040000L
//MCIF_WB0_MCIF_WB_ARBITRATION_CONTROL
#define MCIF_WB0_MCIF_WB_ARBITRATION_CONTROL__MCIF_WB_CLIENT_ARBITRATION_SLICE__SHIFT                         0x0
#define MCIF_WB0_MCIF_WB_ARBITRATION_CONTROL__MCIF_WB_TIME_PER_PIXEL__SHIFT                                   0x16
#define MCIF_WB0_MCIF_WB_ARBITRATION_CONTROL__MCIF_WB_CLIENT_ARBITRATION_SLICE_MASK                           0x00000003L
#define MCIF_WB0_MCIF_WB_ARBITRATION_CONTROL__MCIF_WB_TIME_PER_PIXEL_MASK                                     0xFFC00000L
//MCIF_WB0_MCIF_WB_SCLK_CHANGE
#define MCIF_WB0_MCIF_WB_SCLK_CHANGE__WM_CHANGE_ACK_FORCE_ON__SHIFT                                           0x0
#define MCIF_WB0_MCIF_WB_SCLK_CHANGE__MCIF_WB_CLI_WATERMARK_MASK__SHIFT                                       0x1
#define MCIF_WB0_MCIF_WB_SCLK_CHANGE__WM_CHANGE_ACK_FORCE_ON_MASK                                             0x00000001L
#define MCIF_WB0_MCIF_WB_SCLK_CHANGE__MCIF_WB_CLI_WATERMARK_MASK_MASK                                         0x0000000EL
//MCIF_WB0_MCIF_WB_BUF_1_ADDR_Y
#define MCIF_WB0_MCIF_WB_BUF_1_ADDR_Y__MCIF_WB_BUF_1_ADDR_Y__SHIFT                                            0x0
#define MCIF_WB0_MCIF_WB_BUF_1_ADDR_Y__MCIF_WB_BUF_1_ADDR_Y_MASK                                              0xFFFFFFFFL
//MCIF_WB0_MCIF_WB_BUF_1_ADDR_Y_OFFSET
#define MCIF_WB0_MCIF_WB_BUF_1_ADDR_Y_OFFSET__MCIF_WB_BUF_1_ADDR_Y_OFFSET__SHIFT                              0x0
#define MCIF_WB0_MCIF_WB_BUF_1_ADDR_Y_OFFSET__MCIF_WB_BUF_1_ADDR_Y_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB0_MCIF_WB_BUF_1_ADDR_C
#define MCIF_WB0_MCIF_WB_BUF_1_ADDR_C__MCIF_WB_BUF_1_ADDR_C__SHIFT                                            0x0
#define MCIF_WB0_MCIF_WB_BUF_1_ADDR_C__MCIF_WB_BUF_1_ADDR_C_MASK                                              0xFFFFFFFFL
//MCIF_WB0_MCIF_WB_BUF_1_ADDR_C_OFFSET
#define MCIF_WB0_MCIF_WB_BUF_1_ADDR_C_OFFSET__MCIF_WB_BUF_1_ADDR_C_OFFSET__SHIFT                              0x0
#define MCIF_WB0_MCIF_WB_BUF_1_ADDR_C_OFFSET__MCIF_WB_BUF_1_ADDR_C_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB0_MCIF_WB_BUF_2_ADDR_Y
#define MCIF_WB0_MCIF_WB_BUF_2_ADDR_Y__MCIF_WB_BUF_2_ADDR_Y__SHIFT                                            0x0
#define MCIF_WB0_MCIF_WB_BUF_2_ADDR_Y__MCIF_WB_BUF_2_ADDR_Y_MASK                                              0xFFFFFFFFL
//MCIF_WB0_MCIF_WB_BUF_2_ADDR_Y_OFFSET
#define MCIF_WB0_MCIF_WB_BUF_2_ADDR_Y_OFFSET__MCIF_WB_BUF_2_ADDR_Y_OFFSET__SHIFT                              0x0
#define MCIF_WB0_MCIF_WB_BUF_2_ADDR_Y_OFFSET__MCIF_WB_BUF_2_ADDR_Y_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB0_MCIF_WB_BUF_2_ADDR_C
#define MCIF_WB0_MCIF_WB_BUF_2_ADDR_C__MCIF_WB_BUF_2_ADDR_C__SHIFT                                            0x0
#define MCIF_WB0_MCIF_WB_BUF_2_ADDR_C__MCIF_WB_BUF_2_ADDR_C_MASK                                              0xFFFFFFFFL
//MCIF_WB0_MCIF_WB_BUF_2_ADDR_C_OFFSET
#define MCIF_WB0_MCIF_WB_BUF_2_ADDR_C_OFFSET__MCIF_WB_BUF_2_ADDR_C_OFFSET__SHIFT                              0x0
#define MCIF_WB0_MCIF_WB_BUF_2_ADDR_C_OFFSET__MCIF_WB_BUF_2_ADDR_C_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB0_MCIF_WB_BUF_3_ADDR_Y
#define MCIF_WB0_MCIF_WB_BUF_3_ADDR_Y__MCIF_WB_BUF_3_ADDR_Y__SHIFT                                            0x0
#define MCIF_WB0_MCIF_WB_BUF_3_ADDR_Y__MCIF_WB_BUF_3_ADDR_Y_MASK                                              0xFFFFFFFFL
//MCIF_WB0_MCIF_WB_BUF_3_ADDR_Y_OFFSET
#define MCIF_WB0_MCIF_WB_BUF_3_ADDR_Y_OFFSET__MCIF_WB_BUF_3_ADDR_Y_OFFSET__SHIFT                              0x0
#define MCIF_WB0_MCIF_WB_BUF_3_ADDR_Y_OFFSET__MCIF_WB_BUF_3_ADDR_Y_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB0_MCIF_WB_BUF_3_ADDR_C
#define MCIF_WB0_MCIF_WB_BUF_3_ADDR_C__MCIF_WB_BUF_3_ADDR_C__SHIFT                                            0x0
#define MCIF_WB0_MCIF_WB_BUF_3_ADDR_C__MCIF_WB_BUF_3_ADDR_C_MASK                                              0xFFFFFFFFL
//MCIF_WB0_MCIF_WB_BUF_3_ADDR_C_OFFSET
#define MCIF_WB0_MCIF_WB_BUF_3_ADDR_C_OFFSET__MCIF_WB_BUF_3_ADDR_C_OFFSET__SHIFT                              0x0
#define MCIF_WB0_MCIF_WB_BUF_3_ADDR_C_OFFSET__MCIF_WB_BUF_3_ADDR_C_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB0_MCIF_WB_BUF_4_ADDR_Y
#define MCIF_WB0_MCIF_WB_BUF_4_ADDR_Y__MCIF_WB_BUF_4_ADDR_Y__SHIFT                                            0x0
#define MCIF_WB0_MCIF_WB_BUF_4_ADDR_Y__MCIF_WB_BUF_4_ADDR_Y_MASK                                              0xFFFFFFFFL
//MCIF_WB0_MCIF_WB_BUF_4_ADDR_Y_OFFSET
#define MCIF_WB0_MCIF_WB_BUF_4_ADDR_Y_OFFSET__MCIF_WB_BUF_4_ADDR_Y_OFFSET__SHIFT                              0x0
#define MCIF_WB0_MCIF_WB_BUF_4_ADDR_Y_OFFSET__MCIF_WB_BUF_4_ADDR_Y_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB0_MCIF_WB_BUF_4_ADDR_C
#define MCIF_WB0_MCIF_WB_BUF_4_ADDR_C__MCIF_WB_BUF_4_ADDR_C__SHIFT                                            0x0
#define MCIF_WB0_MCIF_WB_BUF_4_ADDR_C__MCIF_WB_BUF_4_ADDR_C_MASK                                              0xFFFFFFFFL
//MCIF_WB0_MCIF_WB_BUF_4_ADDR_C_OFFSET
#define MCIF_WB0_MCIF_WB_BUF_4_ADDR_C_OFFSET__MCIF_WB_BUF_4_ADDR_C_OFFSET__SHIFT                              0x0
#define MCIF_WB0_MCIF_WB_BUF_4_ADDR_C_OFFSET__MCIF_WB_BUF_4_ADDR_C_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB0_MCIF_WB_BUFMGR_VCE_CONTROL
#define MCIF_WB0_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_LOCK_IGNORE__SHIFT                            0x0
#define MCIF_WB0_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_INT_EN__SHIFT                                 0x4
#define MCIF_WB0_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_INT_ACK__SHIFT                                0x5
#define MCIF_WB0_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_SLICE_INT_EN__SHIFT                           0x6
#define MCIF_WB0_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_LOCK__SHIFT                                   0x8
#define MCIF_WB0_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_SLICE_SIZE__SHIFT                                 0x10
#define MCIF_WB0_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_LOCK_IGNORE_MASK                              0x00000001L
#define MCIF_WB0_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_INT_EN_MASK                                   0x00000010L
#define MCIF_WB0_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_INT_ACK_MASK                                  0x00000020L
#define MCIF_WB0_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_SLICE_INT_EN_MASK                             0x00000040L
#define MCIF_WB0_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_LOCK_MASK                                     0x00000F00L
#define MCIF_WB0_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_SLICE_SIZE_MASK                                   0x1FFF0000L
//MCIF_WB0_MCIF_WB_NB_PSTATE_LATENCY_WATERMARK
#define MCIF_WB0_MCIF_WB_NB_PSTATE_LATENCY_WATERMARK__NB_PSTATE_CHANGE_REFRESH_WATERMARK__SHIFT               0x0
#define MCIF_WB0_MCIF_WB_NB_PSTATE_LATENCY_WATERMARK__NB_PSTATE_CHANGE_REFRESH_WATERMARK_MASK                 0x0001FFFFL
//MCIF_WB0_MCIF_WB_NB_PSTATE_CONTROL
#define MCIF_WB0_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_CHANGE_URGENT_DURING_REQUEST__SHIFT                     0x0
#define MCIF_WB0_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_CHANGE_FORCE_ON__SHIFT                                  0x1
#define MCIF_WB0_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_ALLOW_FOR_URGENT__SHIFT                                 0x2
#define MCIF_WB0_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_CHANGE_WATERMARK_MASK__SHIFT                            0x4
#define MCIF_WB0_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_CHANGE_URGENT_DURING_REQUEST_MASK                       0x00000001L
#define MCIF_WB0_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_CHANGE_FORCE_ON_MASK                                    0x00000002L
#define MCIF_WB0_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_ALLOW_FOR_URGENT_MASK                                   0x00000004L
#define MCIF_WB0_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_CHANGE_WATERMARK_MASK_MASK                              0x00000070L
//MCIF_WB0_MCIF_WB_WATERMARK
#define MCIF_WB0_MCIF_WB_WATERMARK__MCIF_WB_CLI_WATERMARK__SHIFT                                              0x0
#define MCIF_WB0_MCIF_WB_WATERMARK__MCIF_WB_CLI_WATERMARK_MASK                                                0x0000FFFFL
//MCIF_WB0_MCIF_WB_CLOCK_GATER_CONTROL
#define MCIF_WB0_MCIF_WB_CLOCK_GATER_CONTROL__MCIF_WB_CLI_CLOCK_GATER_OVERRIDE__SHIFT                         0x0
#define MCIF_WB0_MCIF_WB_CLOCK_GATER_CONTROL__MCIF_WB_CLI_CLOCK_GATER_OVERRIDE_MASK                           0x00000001L
//MCIF_WB0_MCIF_WB_WARM_UP_CNTL
#define MCIF_WB0_MCIF_WB_WARM_UP_CNTL__MCIF_WB_PITCH_SIZE_WARMUP__SHIFT                                       0x8
#define MCIF_WB0_MCIF_WB_WARM_UP_CNTL__MCIF_WB_PITCH_SIZE_WARMUP_MASK                                         0x0000FF00L
//MCIF_WB0_MCIF_WB_SELF_REFRESH_CONTROL
#define MCIF_WB0_MCIF_WB_SELF_REFRESH_CONTROL__DIS_REFRESH_UNDER_NBPREQ__SHIFT                                0x0
#define MCIF_WB0_MCIF_WB_SELF_REFRESH_CONTROL__PERFRAME_SELF_REFRESH__SHIFT                                   0x1
#define MCIF_WB0_MCIF_WB_SELF_REFRESH_CONTROL__DIS_REFRESH_UNDER_NBPREQ_MASK                                  0x00000001L
#define MCIF_WB0_MCIF_WB_SELF_REFRESH_CONTROL__PERFRAME_SELF_REFRESH_MASK                                     0x00000002L
//MCIF_WB0_MULTI_LEVEL_QOS_CTRL
#define MCIF_WB0_MULTI_LEVEL_QOS_CTRL__MAX_SCALED_TIME_TO_URGENT__SHIFT                                       0x0
#define MCIF_WB0_MULTI_LEVEL_QOS_CTRL__MAX_SCALED_TIME_TO_URGENT_MASK                                         0x003FFFFFL
//MCIF_WB0_MCIF_WB_BUF_LUMA_SIZE
#define MCIF_WB0_MCIF_WB_BUF_LUMA_SIZE__MCIF_WB_BUF_LUMA_SIZE__SHIFT                                          0x0
#define MCIF_WB0_MCIF_WB_BUF_LUMA_SIZE__MCIF_WB_BUF_LUMA_SIZE_MASK                                            0x000FFFFFL
//MCIF_WB0_MCIF_WB_BUF_CHROMA_SIZE
#define MCIF_WB0_MCIF_WB_BUF_CHROMA_SIZE__MCIF_WB_BUF_CHROMA_SIZE__SHIFT                                      0x0
#define MCIF_WB0_MCIF_WB_BUF_CHROMA_SIZE__MCIF_WB_BUF_CHROMA_SIZE_MASK                                        0x000FFFFFL


// addressBlock: dce_dc_mmhubbub_mcif_wb1_dispdec
//MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_ENABLE__SHIFT                                      0x0
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUF_DUALSIZE_REQ__SHIFT                                   0x1
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_INT_EN__SHIFT                                   0x4
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_INT_ACK__SHIFT                                  0x5
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_SLICE_INT_EN__SHIFT                             0x6
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_OVERRUN_INT_EN__SHIFT                           0x7
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_LOCK__SHIFT                                     0x8
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_P_VMID__SHIFT                                             0x10
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUF_ADDR_FENCE_EN__SHIFT                                  0x18
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_ENABLE_MASK                                        0x00000001L
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUF_DUALSIZE_REQ_MASK                                     0x00000002L
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_INT_EN_MASK                                     0x00000010L
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_INT_ACK_MASK                                    0x00000020L
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_SLICE_INT_EN_MASK                               0x00000040L
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_OVERRUN_INT_EN_MASK                             0x00000080L
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_LOCK_MASK                                       0x00000F00L
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_P_VMID_MASK                                               0x000F0000L
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUF_ADDR_FENCE_EN_MASK                                    0x01000000L
//MCIF_WB1_MCIF_WB_BUFMGR_CUR_LINE_R
#define MCIF_WB1_MCIF_WB_BUFMGR_CUR_LINE_R__MCIF_WB_BUFMGR_CUR_LINE_R__SHIFT                                  0x0
#define MCIF_WB1_MCIF_WB_BUFMGR_CUR_LINE_R__MCIF_WB_BUFMGR_CUR_LINE_R_MASK                                    0x00001FFFL
//MCIF_WB1_MCIF_WB_BUFMGR_STATUS
#define MCIF_WB1_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_VCE_INT_STATUS__SHIFT                                  0x0
#define MCIF_WB1_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_SW_INT_STATUS__SHIFT                                   0x1
#define MCIF_WB1_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_SW_OVERRUN_INT_STATUS__SHIFT                           0x2
#define MCIF_WB1_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_CUR_BUF__SHIFT                                         0x4
#define MCIF_WB1_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUF_DUALSIZE_STATUS__SHIFT                                    0x7
#define MCIF_WB1_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_BUFTAG__SHIFT                                          0x8
#define MCIF_WB1_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_CUR_LINE_L__SHIFT                                      0xc
#define MCIF_WB1_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_NEXT_BUF__SHIFT                                        0x1c
#define MCIF_WB1_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_VCE_INT_STATUS_MASK                                    0x00000001L
#define MCIF_WB1_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_SW_INT_STATUS_MASK                                     0x00000002L
#define MCIF_WB1_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_SW_OVERRUN_INT_STATUS_MASK                             0x00000004L
#define MCIF_WB1_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_CUR_BUF_MASK                                           0x00000070L
#define MCIF_WB1_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUF_DUALSIZE_STATUS_MASK                                      0x00000080L
#define MCIF_WB1_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_BUFTAG_MASK                                            0x00000F00L
#define MCIF_WB1_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_CUR_LINE_L_MASK                                        0x01FFF000L
#define MCIF_WB1_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_NEXT_BUF_MASK                                          0x70000000L
//MCIF_WB1_MCIF_WB_BUF_PITCH
#define MCIF_WB1_MCIF_WB_BUF_PITCH__MCIF_WB_BUF_LUMA_PITCH__SHIFT                                             0x8
#define MCIF_WB1_MCIF_WB_BUF_PITCH__MCIF_WB_BUF_CHROMA_PITCH__SHIFT                                           0x18
#define MCIF_WB1_MCIF_WB_BUF_PITCH__MCIF_WB_BUF_LUMA_PITCH_MASK                                               0x0000FF00L
#define MCIF_WB1_MCIF_WB_BUF_PITCH__MCIF_WB_BUF_CHROMA_PITCH_MASK                                             0xFF000000L
//MCIF_WB1_MCIF_WB_BUF_1_STATUS
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_ACTIVE__SHIFT                                            0x0
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_SW_LOCKED__SHIFT                                         0x1
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_VCE_LOCKED__SHIFT                                        0x2
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_OVERFLOW__SHIFT                                          0x3
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_DISABLE__SHIFT                                           0x4
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_MODE__SHIFT                                              0x5
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_BUFTAG__SHIFT                                            0x8
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_NXT_BUF__SHIFT                                           0xc
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_FIELD__SHIFT                                             0xf
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_CUR_LINE_L__SHIFT                                        0x10
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_LONG_LINE_ERROR__SHIFT                                   0x1d
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_SHORT_LINE_ERROR__SHIFT                                  0x1e
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_FRAME_LENGTH_ERROR__SHIFT                                0x1f
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_ACTIVE_MASK                                              0x00000001L
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_SW_LOCKED_MASK                                           0x00000002L
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_VCE_LOCKED_MASK                                          0x00000004L
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_OVERFLOW_MASK                                            0x00000008L
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_DISABLE_MASK                                             0x00000010L
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_MODE_MASK                                                0x000000E0L
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_BUFTAG_MASK                                              0x00000F00L
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_NXT_BUF_MASK                                             0x00007000L
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_FIELD_MASK                                               0x00008000L
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_CUR_LINE_L_MASK                                          0x1FFF0000L
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_LONG_LINE_ERROR_MASK                                     0x20000000L
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_SHORT_LINE_ERROR_MASK                                    0x40000000L
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_FRAME_LENGTH_ERROR_MASK                                  0x80000000L
//MCIF_WB1_MCIF_WB_BUF_1_STATUS2
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_CUR_LINE_R__SHIFT                                       0x0
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_NEW_CONTENT__SHIFT                                      0xd
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_COLOR_DEPTH__SHIFT                                      0xe
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_Y_OVERRUN__SHIFT                                        0x11
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_C_OVERRUN__SHIFT                                        0x12
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_CUR_LINE_R_MASK                                         0x00001FFFL
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_NEW_CONTENT_MASK                                        0x00002000L
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_COLOR_DEPTH_MASK                                        0x00004000L
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_Y_OVERRUN_MASK                                          0x00020000L
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_C_OVERRUN_MASK                                          0x00040000L
//MCIF_WB1_MCIF_WB_BUF_2_STATUS
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_ACTIVE__SHIFT                                            0x0
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_SW_LOCKED__SHIFT                                         0x1
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_VCE_LOCKED__SHIFT                                        0x2
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_OVERFLOW__SHIFT                                          0x3
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_DISABLE__SHIFT                                           0x4
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_MODE__SHIFT                                              0x5
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_BUFTAG__SHIFT                                            0x8
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_NXT_BUF__SHIFT                                           0xc
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_FIELD__SHIFT                                             0xf
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_CUR_LINE_L__SHIFT                                        0x10
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_LONG_LINE_ERROR__SHIFT                                   0x1d
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_SHORT_LINE_ERROR__SHIFT                                  0x1e
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_FRAME_LENGTH_ERROR__SHIFT                                0x1f
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_ACTIVE_MASK                                              0x00000001L
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_SW_LOCKED_MASK                                           0x00000002L
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_VCE_LOCKED_MASK                                          0x00000004L
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_OVERFLOW_MASK                                            0x00000008L
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_DISABLE_MASK                                             0x00000010L
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_MODE_MASK                                                0x000000E0L
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_BUFTAG_MASK                                              0x00000F00L
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_NXT_BUF_MASK                                             0x00007000L
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_FIELD_MASK                                               0x00008000L
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_CUR_LINE_L_MASK                                          0x1FFF0000L
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_LONG_LINE_ERROR_MASK                                     0x20000000L
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_SHORT_LINE_ERROR_MASK                                    0x40000000L
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_FRAME_LENGTH_ERROR_MASK                                  0x80000000L
//MCIF_WB1_MCIF_WB_BUF_2_STATUS2
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_CUR_LINE_R__SHIFT                                       0x0
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_NEW_CONTENT__SHIFT                                      0xd
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_COLOR_DEPTH__SHIFT                                      0xe
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_Y_OVERRUN__SHIFT                                        0x11
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_C_OVERRUN__SHIFT                                        0x12
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_CUR_LINE_R_MASK                                         0x00001FFFL
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_NEW_CONTENT_MASK                                        0x00002000L
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_COLOR_DEPTH_MASK                                        0x00004000L
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_Y_OVERRUN_MASK                                          0x00020000L
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_C_OVERRUN_MASK                                          0x00040000L
//MCIF_WB1_MCIF_WB_BUF_3_STATUS
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_ACTIVE__SHIFT                                            0x0
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_SW_LOCKED__SHIFT                                         0x1
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_VCE_LOCKED__SHIFT                                        0x2
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_OVERFLOW__SHIFT                                          0x3
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_DISABLE__SHIFT                                           0x4
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_MODE__SHIFT                                              0x5
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_BUFTAG__SHIFT                                            0x8
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_NXT_BUF__SHIFT                                           0xc
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_FIELD__SHIFT                                             0xf
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_CUR_LINE_L__SHIFT                                        0x10
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_LONG_LINE_ERROR__SHIFT                                   0x1d
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_SHORT_LINE_ERROR__SHIFT                                  0x1e
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_FRAME_LENGTH_ERROR__SHIFT                                0x1f
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_ACTIVE_MASK                                              0x00000001L
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_SW_LOCKED_MASK                                           0x00000002L
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_VCE_LOCKED_MASK                                          0x00000004L
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_OVERFLOW_MASK                                            0x00000008L
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_DISABLE_MASK                                             0x00000010L
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_MODE_MASK                                                0x000000E0L
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_BUFTAG_MASK                                              0x00000F00L
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_NXT_BUF_MASK                                             0x00007000L
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_FIELD_MASK                                               0x00008000L
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_CUR_LINE_L_MASK                                          0x1FFF0000L
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_LONG_LINE_ERROR_MASK                                     0x20000000L
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_SHORT_LINE_ERROR_MASK                                    0x40000000L
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_FRAME_LENGTH_ERROR_MASK                                  0x80000000L
//MCIF_WB1_MCIF_WB_BUF_3_STATUS2
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_CUR_LINE_R__SHIFT                                       0x0
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_NEW_CONTENT__SHIFT                                      0xd
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_COLOR_DEPTH__SHIFT                                      0xe
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_Y_OVERRUN__SHIFT                                        0x11
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_C_OVERRUN__SHIFT                                        0x12
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_CUR_LINE_R_MASK                                         0x00001FFFL
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_NEW_CONTENT_MASK                                        0x00002000L
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_COLOR_DEPTH_MASK                                        0x00004000L
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_Y_OVERRUN_MASK                                          0x00020000L
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_C_OVERRUN_MASK                                          0x00040000L
//MCIF_WB1_MCIF_WB_BUF_4_STATUS
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_ACTIVE__SHIFT                                            0x0
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_SW_LOCKED__SHIFT                                         0x1
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_VCE_LOCKED__SHIFT                                        0x2
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_OVERFLOW__SHIFT                                          0x3
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_DISABLE__SHIFT                                           0x4
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_MODE__SHIFT                                              0x5
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_BUFTAG__SHIFT                                            0x8
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_NXT_BUF__SHIFT                                           0xc
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_FIELD__SHIFT                                             0xf
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_CUR_LINE_L__SHIFT                                        0x10
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_LONG_LINE_ERROR__SHIFT                                   0x1d
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_SHORT_LINE_ERROR__SHIFT                                  0x1e
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_FRAME_LENGTH_ERROR__SHIFT                                0x1f
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_ACTIVE_MASK                                              0x00000001L
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_SW_LOCKED_MASK                                           0x00000002L
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_VCE_LOCKED_MASK                                          0x00000004L
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_OVERFLOW_MASK                                            0x00000008L
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_DISABLE_MASK                                             0x00000010L
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_MODE_MASK                                                0x000000E0L
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_BUFTAG_MASK                                              0x00000F00L
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_NXT_BUF_MASK                                             0x00007000L
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_FIELD_MASK                                               0x00008000L
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_CUR_LINE_L_MASK                                          0x1FFF0000L
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_LONG_LINE_ERROR_MASK                                     0x20000000L
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_SHORT_LINE_ERROR_MASK                                    0x40000000L
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_FRAME_LENGTH_ERROR_MASK                                  0x80000000L
//MCIF_WB1_MCIF_WB_BUF_4_STATUS2
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_CUR_LINE_R__SHIFT                                       0x0
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_NEW_CONTENT__SHIFT                                      0xd
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_COLOR_DEPTH__SHIFT                                      0xe
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_Y_OVERRUN__SHIFT                                        0x11
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_C_OVERRUN__SHIFT                                        0x12
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_CUR_LINE_R_MASK                                         0x00001FFFL
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_NEW_CONTENT_MASK                                        0x00002000L
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_COLOR_DEPTH_MASK                                        0x00004000L
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_Y_OVERRUN_MASK                                          0x00020000L
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_C_OVERRUN_MASK                                          0x00040000L
//MCIF_WB1_MCIF_WB_ARBITRATION_CONTROL
#define MCIF_WB1_MCIF_WB_ARBITRATION_CONTROL__MCIF_WB_CLIENT_ARBITRATION_SLICE__SHIFT                         0x0
#define MCIF_WB1_MCIF_WB_ARBITRATION_CONTROL__MCIF_WB_TIME_PER_PIXEL__SHIFT                                   0x16
#define MCIF_WB1_MCIF_WB_ARBITRATION_CONTROL__MCIF_WB_CLIENT_ARBITRATION_SLICE_MASK                           0x00000003L
#define MCIF_WB1_MCIF_WB_ARBITRATION_CONTROL__MCIF_WB_TIME_PER_PIXEL_MASK                                     0xFFC00000L
//MCIF_WB1_MCIF_WB_SCLK_CHANGE
#define MCIF_WB1_MCIF_WB_SCLK_CHANGE__WM_CHANGE_ACK_FORCE_ON__SHIFT                                           0x0
#define MCIF_WB1_MCIF_WB_SCLK_CHANGE__MCIF_WB_CLI_WATERMARK_MASK__SHIFT                                       0x1
#define MCIF_WB1_MCIF_WB_SCLK_CHANGE__WM_CHANGE_ACK_FORCE_ON_MASK                                             0x00000001L
#define MCIF_WB1_MCIF_WB_SCLK_CHANGE__MCIF_WB_CLI_WATERMARK_MASK_MASK                                         0x0000000EL
//MCIF_WB1_MCIF_WB_BUF_1_ADDR_Y
#define MCIF_WB1_MCIF_WB_BUF_1_ADDR_Y__MCIF_WB_BUF_1_ADDR_Y__SHIFT                                            0x0
#define MCIF_WB1_MCIF_WB_BUF_1_ADDR_Y__MCIF_WB_BUF_1_ADDR_Y_MASK                                              0xFFFFFFFFL
//MCIF_WB1_MCIF_WB_BUF_1_ADDR_Y_OFFSET
#define MCIF_WB1_MCIF_WB_BUF_1_ADDR_Y_OFFSET__MCIF_WB_BUF_1_ADDR_Y_OFFSET__SHIFT                              0x0
#define MCIF_WB1_MCIF_WB_BUF_1_ADDR_Y_OFFSET__MCIF_WB_BUF_1_ADDR_Y_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB1_MCIF_WB_BUF_1_ADDR_C
#define MCIF_WB1_MCIF_WB_BUF_1_ADDR_C__MCIF_WB_BUF_1_ADDR_C__SHIFT                                            0x0
#define MCIF_WB1_MCIF_WB_BUF_1_ADDR_C__MCIF_WB_BUF_1_ADDR_C_MASK                                              0xFFFFFFFFL
//MCIF_WB1_MCIF_WB_BUF_1_ADDR_C_OFFSET
#define MCIF_WB1_MCIF_WB_BUF_1_ADDR_C_OFFSET__MCIF_WB_BUF_1_ADDR_C_OFFSET__SHIFT                              0x0
#define MCIF_WB1_MCIF_WB_BUF_1_ADDR_C_OFFSET__MCIF_WB_BUF_1_ADDR_C_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB1_MCIF_WB_BUF_2_ADDR_Y
#define MCIF_WB1_MCIF_WB_BUF_2_ADDR_Y__MCIF_WB_BUF_2_ADDR_Y__SHIFT                                            0x0
#define MCIF_WB1_MCIF_WB_BUF_2_ADDR_Y__MCIF_WB_BUF_2_ADDR_Y_MASK                                              0xFFFFFFFFL
//MCIF_WB1_MCIF_WB_BUF_2_ADDR_Y_OFFSET
#define MCIF_WB1_MCIF_WB_BUF_2_ADDR_Y_OFFSET__MCIF_WB_BUF_2_ADDR_Y_OFFSET__SHIFT                              0x0
#define MCIF_WB1_MCIF_WB_BUF_2_ADDR_Y_OFFSET__MCIF_WB_BUF_2_ADDR_Y_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB1_MCIF_WB_BUF_2_ADDR_C
#define MCIF_WB1_MCIF_WB_BUF_2_ADDR_C__MCIF_WB_BUF_2_ADDR_C__SHIFT                                            0x0
#define MCIF_WB1_MCIF_WB_BUF_2_ADDR_C__MCIF_WB_BUF_2_ADDR_C_MASK                                              0xFFFFFFFFL
//MCIF_WB1_MCIF_WB_BUF_2_ADDR_C_OFFSET
#define MCIF_WB1_MCIF_WB_BUF_2_ADDR_C_OFFSET__MCIF_WB_BUF_2_ADDR_C_OFFSET__SHIFT                              0x0
#define MCIF_WB1_MCIF_WB_BUF_2_ADDR_C_OFFSET__MCIF_WB_BUF_2_ADDR_C_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB1_MCIF_WB_BUF_3_ADDR_Y
#define MCIF_WB1_MCIF_WB_BUF_3_ADDR_Y__MCIF_WB_BUF_3_ADDR_Y__SHIFT                                            0x0
#define MCIF_WB1_MCIF_WB_BUF_3_ADDR_Y__MCIF_WB_BUF_3_ADDR_Y_MASK                                              0xFFFFFFFFL
//MCIF_WB1_MCIF_WB_BUF_3_ADDR_Y_OFFSET
#define MCIF_WB1_MCIF_WB_BUF_3_ADDR_Y_OFFSET__MCIF_WB_BUF_3_ADDR_Y_OFFSET__SHIFT                              0x0
#define MCIF_WB1_MCIF_WB_BUF_3_ADDR_Y_OFFSET__MCIF_WB_BUF_3_ADDR_Y_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB1_MCIF_WB_BUF_3_ADDR_C
#define MCIF_WB1_MCIF_WB_BUF_3_ADDR_C__MCIF_WB_BUF_3_ADDR_C__SHIFT                                            0x0
#define MCIF_WB1_MCIF_WB_BUF_3_ADDR_C__MCIF_WB_BUF_3_ADDR_C_MASK                                              0xFFFFFFFFL
//MCIF_WB1_MCIF_WB_BUF_3_ADDR_C_OFFSET
#define MCIF_WB1_MCIF_WB_BUF_3_ADDR_C_OFFSET__MCIF_WB_BUF_3_ADDR_C_OFFSET__SHIFT                              0x0
#define MCIF_WB1_MCIF_WB_BUF_3_ADDR_C_OFFSET__MCIF_WB_BUF_3_ADDR_C_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB1_MCIF_WB_BUF_4_ADDR_Y
#define MCIF_WB1_MCIF_WB_BUF_4_ADDR_Y__MCIF_WB_BUF_4_ADDR_Y__SHIFT                                            0x0
#define MCIF_WB1_MCIF_WB_BUF_4_ADDR_Y__MCIF_WB_BUF_4_ADDR_Y_MASK                                              0xFFFFFFFFL
//MCIF_WB1_MCIF_WB_BUF_4_ADDR_Y_OFFSET
#define MCIF_WB1_MCIF_WB_BUF_4_ADDR_Y_OFFSET__MCIF_WB_BUF_4_ADDR_Y_OFFSET__SHIFT                              0x0
#define MCIF_WB1_MCIF_WB_BUF_4_ADDR_Y_OFFSET__MCIF_WB_BUF_4_ADDR_Y_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB1_MCIF_WB_BUF_4_ADDR_C
#define MCIF_WB1_MCIF_WB_BUF_4_ADDR_C__MCIF_WB_BUF_4_ADDR_C__SHIFT                                            0x0
#define MCIF_WB1_MCIF_WB_BUF_4_ADDR_C__MCIF_WB_BUF_4_ADDR_C_MASK                                              0xFFFFFFFFL
//MCIF_WB1_MCIF_WB_BUF_4_ADDR_C_OFFSET
#define MCIF_WB1_MCIF_WB_BUF_4_ADDR_C_OFFSET__MCIF_WB_BUF_4_ADDR_C_OFFSET__SHIFT                              0x0
#define MCIF_WB1_MCIF_WB_BUF_4_ADDR_C_OFFSET__MCIF_WB_BUF_4_ADDR_C_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB1_MCIF_WB_BUFMGR_VCE_CONTROL
#define MCIF_WB1_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_LOCK_IGNORE__SHIFT                            0x0
#define MCIF_WB1_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_INT_EN__SHIFT                                 0x4
#define MCIF_WB1_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_INT_ACK__SHIFT                                0x5
#define MCIF_WB1_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_SLICE_INT_EN__SHIFT                           0x6
#define MCIF_WB1_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_LOCK__SHIFT                                   0x8
#define MCIF_WB1_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_SLICE_SIZE__SHIFT                                 0x10
#define MCIF_WB1_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_LOCK_IGNORE_MASK                              0x00000001L
#define MCIF_WB1_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_INT_EN_MASK                                   0x00000010L
#define MCIF_WB1_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_INT_ACK_MASK                                  0x00000020L
#define MCIF_WB1_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_SLICE_INT_EN_MASK                             0x00000040L
#define MCIF_WB1_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_LOCK_MASK                                     0x00000F00L
#define MCIF_WB1_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_SLICE_SIZE_MASK                                   0x1FFF0000L
//MCIF_WB1_MCIF_WB_NB_PSTATE_LATENCY_WATERMARK
#define MCIF_WB1_MCIF_WB_NB_PSTATE_LATENCY_WATERMARK__NB_PSTATE_CHANGE_REFRESH_WATERMARK__SHIFT               0x0
#define MCIF_WB1_MCIF_WB_NB_PSTATE_LATENCY_WATERMARK__NB_PSTATE_CHANGE_REFRESH_WATERMARK_MASK                 0x0001FFFFL
//MCIF_WB1_MCIF_WB_NB_PSTATE_CONTROL
#define MCIF_WB1_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_CHANGE_URGENT_DURING_REQUEST__SHIFT                     0x0
#define MCIF_WB1_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_CHANGE_FORCE_ON__SHIFT                                  0x1
#define MCIF_WB1_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_ALLOW_FOR_URGENT__SHIFT                                 0x2
#define MCIF_WB1_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_CHANGE_WATERMARK_MASK__SHIFT                            0x4
#define MCIF_WB1_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_CHANGE_URGENT_DURING_REQUEST_MASK                       0x00000001L
#define MCIF_WB1_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_CHANGE_FORCE_ON_MASK                                    0x00000002L
#define MCIF_WB1_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_ALLOW_FOR_URGENT_MASK                                   0x00000004L
#define MCIF_WB1_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_CHANGE_WATERMARK_MASK_MASK                              0x00000070L
//MCIF_WB1_MCIF_WB_WATERMARK
#define MCIF_WB1_MCIF_WB_WATERMARK__MCIF_WB_CLI_WATERMARK__SHIFT                                              0x0
#define MCIF_WB1_MCIF_WB_WATERMARK__MCIF_WB_CLI_WATERMARK_MASK                                                0x0000FFFFL
//MCIF_WB1_MCIF_WB_CLOCK_GATER_CONTROL
#define MCIF_WB1_MCIF_WB_CLOCK_GATER_CONTROL__MCIF_WB_CLI_CLOCK_GATER_OVERRIDE__SHIFT                         0x0
#define MCIF_WB1_MCIF_WB_CLOCK_GATER_CONTROL__MCIF_WB_CLI_CLOCK_GATER_OVERRIDE_MASK                           0x00000001L
//MCIF_WB1_MCIF_WB_WARM_UP_CNTL
#define MCIF_WB1_MCIF_WB_WARM_UP_CNTL__MCIF_WB_PITCH_SIZE_WARMUP__SHIFT                                       0x8
#define MCIF_WB1_MCIF_WB_WARM_UP_CNTL__MCIF_WB_PITCH_SIZE_WARMUP_MASK                                         0x0000FF00L
//MCIF_WB1_MCIF_WB_SELF_REFRESH_CONTROL
#define MCIF_WB1_MCIF_WB_SELF_REFRESH_CONTROL__DIS_REFRESH_UNDER_NBPREQ__SHIFT                                0x0
#define MCIF_WB1_MCIF_WB_SELF_REFRESH_CONTROL__PERFRAME_SELF_REFRESH__SHIFT                                   0x1
#define MCIF_WB1_MCIF_WB_SELF_REFRESH_CONTROL__DIS_REFRESH_UNDER_NBPREQ_MASK                                  0x00000001L
#define MCIF_WB1_MCIF_WB_SELF_REFRESH_CONTROL__PERFRAME_SELF_REFRESH_MASK                                     0x00000002L
//MCIF_WB1_MULTI_LEVEL_QOS_CTRL
#define MCIF_WB1_MULTI_LEVEL_QOS_CTRL__MAX_SCALED_TIME_TO_URGENT__SHIFT                                       0x0
#define MCIF_WB1_MULTI_LEVEL_QOS_CTRL__MAX_SCALED_TIME_TO_URGENT_MASK                                         0x003FFFFFL
//MCIF_WB1_MCIF_WB_BUF_LUMA_SIZE
#define MCIF_WB1_MCIF_WB_BUF_LUMA_SIZE__MCIF_WB_BUF_LUMA_SIZE__SHIFT                                          0x0
#define MCIF_WB1_MCIF_WB_BUF_LUMA_SIZE__MCIF_WB_BUF_LUMA_SIZE_MASK                                            0x000FFFFFL
//MCIF_WB1_MCIF_WB_BUF_CHROMA_SIZE
#define MCIF_WB1_MCIF_WB_BUF_CHROMA_SIZE__MCIF_WB_BUF_CHROMA_SIZE__SHIFT                                      0x0
#define MCIF_WB1_MCIF_WB_BUF_CHROMA_SIZE__MCIF_WB_BUF_CHROMA_SIZE_MASK                                        0x000FFFFFL


// addressBlock: dce_dc_mmhubbub_mmhubbub_dispdec
//WBIF0_MISC_CTRL
#define WBIF0_MISC_CTRL__MCIFWB0_WR_COMBINE_TIMEOUT_THRESH__SHIFT                                             0x0
#define WBIF0_MISC_CTRL__MCIF_WB0_SOCCLK_DS_ENABLE__SHIFT                                                     0x10
#define WBIF0_MISC_CTRL__MCIFWB0_WR_COMBINE_TIMEOUT_THRESH_MASK                                               0x000003FFL
#define WBIF0_MISC_CTRL__MCIF_WB0_SOCCLK_DS_ENABLE_MASK                                                       0x00010000L
//WBIF0_SMU_WM_CONTROL
#define WBIF0_SMU_WM_CONTROL__MCIF_WB0_WM_CHG_SEL__SHIFT                                                      0x14
#define WBIF0_SMU_WM_CONTROL__MCIF_WB0_WM_CHG_REQ__SHIFT                                                      0x16
#define WBIF0_SMU_WM_CONTROL__MCIF_WB0_WM_CHG_ACK_INT_DIS__SHIFT                                              0x18
#define WBIF0_SMU_WM_CONTROL__MCIF_WB0_WM_CHG_ACK_INT_STATUS__SHIFT                                           0x19
#define WBIF0_SMU_WM_CONTROL__MCIF_WB0_WM_CHG_SEL_MASK                                                        0x00300000L
#define WBIF0_SMU_WM_CONTROL__MCIF_WB0_WM_CHG_REQ_MASK                                                        0x00400000L
#define WBIF0_SMU_WM_CONTROL__MCIF_WB0_WM_CHG_ACK_INT_DIS_MASK                                                0x01000000L
#define WBIF0_SMU_WM_CONTROL__MCIF_WB0_WM_CHG_ACK_INT_STATUS_MASK                                             0x02000000L
//WBIF0_PHASE0_OUTSTANDING_COUNTER
#define WBIF0_PHASE0_OUTSTANDING_COUNTER__MCIF_WB0_PHASE0_OUTSTANDING_COUNTER__SHIFT                          0x0
#define WBIF0_PHASE0_OUTSTANDING_COUNTER__MCIF_WB0_PHASE0_OUTSTANDING_COUNTER_MASK                            0x07FFFFFFL
//WBIF0_PHASE1_OUTSTANDING_COUNTER
#define WBIF0_PHASE1_OUTSTANDING_COUNTER__MCIF_WB0_PHASE1_OUTSTANDING_COUNTER__SHIFT                          0x0
#define WBIF0_PHASE1_OUTSTANDING_COUNTER__MCIF_WB0_PHASE1_OUTSTANDING_COUNTER_MASK                            0x07FFFFFFL
//WBIF1_MISC_CTRL
#define WBIF1_MISC_CTRL__MCIFWB1_WR_COMBINE_TIMEOUT_THRESH__SHIFT                                             0x0
#define WBIF1_MISC_CTRL__MCIF_WB1_SOCCLK_DS_ENABLE__SHIFT                                                     0x10
#define WBIF1_MISC_CTRL__MCIFWB1_WR_COMBINE_TIMEOUT_THRESH_MASK                                               0x000003FFL
#define WBIF1_MISC_CTRL__MCIF_WB1_SOCCLK_DS_ENABLE_MASK                                                       0x00010000L
//WBIF1_SMU_WM_CONTROL
#define WBIF1_SMU_WM_CONTROL__MCIF_WB1_WM_CHG_SEL__SHIFT                                                      0x14
#define WBIF1_SMU_WM_CONTROL__MCIF_WB1_WM_CHG_REQ__SHIFT                                                      0x16
#define WBIF1_SMU_WM_CONTROL__MCIF_WB1_WM_CHG_ACK_INT_DIS__SHIFT                                              0x18
#define WBIF1_SMU_WM_CONTROL__MCIF_WB1_WM_CHG_ACK_INT_STATUS__SHIFT                                           0x19
#define WBIF1_SMU_WM_CONTROL__MCIF_WB1_WM_CHG_SEL_MASK                                                        0x00300000L
#define WBIF1_SMU_WM_CONTROL__MCIF_WB1_WM_CHG_REQ_MASK                                                        0x00400000L
#define WBIF1_SMU_WM_CONTROL__MCIF_WB1_WM_CHG_ACK_INT_DIS_MASK                                                0x01000000L
#define WBIF1_SMU_WM_CONTROL__MCIF_WB1_WM_CHG_ACK_INT_STATUS_MASK                                             0x02000000L
//WBIF1_PHASE0_OUTSTANDING_COUNTER
#define WBIF1_PHASE0_OUTSTANDING_COUNTER__MCIF_WB1_PHASE0_OUTSTANDING_COUNTER__SHIFT                          0x0
#define WBIF1_PHASE0_OUTSTANDING_COUNTER__MCIF_WB1_PHASE0_OUTSTANDING_COUNTER_MASK                            0x07FFFFFFL
//WBIF1_PHASE1_OUTSTANDING_COUNTER
#define WBIF1_PHASE1_OUTSTANDING_COUNTER__MCIF_WB1_PHASE1_OUTSTANDING_COUNTER__SHIFT                          0x0
#define WBIF1_PHASE1_OUTSTANDING_COUNTER__MCIF_WB1_PHASE1_OUTSTANDING_COUNTER_MASK                            0x07FFFFFFL
//VGA_SRC_SPLIT_CNTL
#define VGA_SRC_SPLIT_CNTL__VGA_SPLIT_SEL__SHIFT                                                              0x0
#define VGA_SRC_SPLIT_CNTL__VGA_SPLIT_SEL_MASK                                                                0x00000003L
//MMHUBBUB_MEM_PWR_STATUS
#define MMHUBBUB_MEM_PWR_STATUS__MCIF_DWB0_LUMA_MEM0_PWR_STATE__SHIFT                                         0x0
#define MMHUBBUB_MEM_PWR_STATUS__MCIF_DWB0_LUMA_MEM1_PWR_STATE__SHIFT                                         0x2
#define MMHUBBUB_MEM_PWR_STATUS__MCIF_DWB0_CHROMA_MEM0_PWR_STATE__SHIFT                                       0x4
#define MMHUBBUB_MEM_PWR_STATUS__MCIF_DWB0_CHROMA_MEM1_PWR_STATE__SHIFT                                       0x6
#define MMHUBBUB_MEM_PWR_STATUS__MCIF_DWB1_LUMA_MEM0_PWR_STATE__SHIFT                                         0x8
#define MMHUBBUB_MEM_PWR_STATUS__MCIF_DWB1_LUMA_MEM1_PWR_STATE__SHIFT                                         0xa
#define MMHUBBUB_MEM_PWR_STATUS__MCIF_DWB1_CHROMA_MEM0_PWR_STATE__SHIFT                                       0xc
#define MMHUBBUB_MEM_PWR_STATUS__MCIF_DWB1_CHROMA_MEM1_PWR_STATE__SHIFT                                       0xe
#define MMHUBBUB_MEM_PWR_STATUS__VGA_MEM_PWR_STATE__SHIFT                                                     0x1f
#define MMHUBBUB_MEM_PWR_STATUS__MCIF_DWB0_LUMA_MEM0_PWR_STATE_MASK                                           0x00000003L
#define MMHUBBUB_MEM_PWR_STATUS__MCIF_DWB0_LUMA_MEM1_PWR_STATE_MASK                                           0x0000000CL
#define MMHUBBUB_MEM_PWR_STATUS__MCIF_DWB0_CHROMA_MEM0_PWR_STATE_MASK                                         0x00000030L
#define MMHUBBUB_MEM_PWR_STATUS__MCIF_DWB0_CHROMA_MEM1_PWR_STATE_MASK                                         0x000000C0L
#define MMHUBBUB_MEM_PWR_STATUS__MCIF_DWB1_LUMA_MEM0_PWR_STATE_MASK                                           0x00000300L
#define MMHUBBUB_MEM_PWR_STATUS__MCIF_DWB1_LUMA_MEM1_PWR_STATE_MASK                                           0x00000C00L
#define MMHUBBUB_MEM_PWR_STATUS__MCIF_DWB1_CHROMA_MEM0_PWR_STATE_MASK                                         0x00003000L
#define MMHUBBUB_MEM_PWR_STATUS__MCIF_DWB1_CHROMA_MEM1_PWR_STATE_MASK                                         0x0000C000L
#define MMHUBBUB_MEM_PWR_STATUS__VGA_MEM_PWR_STATE_MASK                                                       0x80000000L
//MMHUBBUB_MEM_PWR_CNTL
#define MMHUBBUB_MEM_PWR_CNTL__VGA_MEM_PWR_FORCE__SHIFT                                                       0x0
#define MMHUBBUB_MEM_PWR_CNTL__VGA_MEM_PWR_DIS__SHIFT                                                         0x1
#define MMHUBBUB_MEM_PWR_CNTL__MCIF_DWB0_MEM_PWR_FORCE__SHIFT                                                 0x2
#define MMHUBBUB_MEM_PWR_CNTL__MCIF_DWB0_MEM_PWR_DIS__SHIFT                                                   0x4
#define MMHUBBUB_MEM_PWR_CNTL__MCIF_DWB0_MEM_PWR_MODE_SEL__SHIFT                                              0x5
#define MMHUBBUB_MEM_PWR_CNTL__MCIF_DWB0_LUMA_MEM_EN_NUM__SHIFT                                               0x7
#define MMHUBBUB_MEM_PWR_CNTL__MCIF_DWB0_CHROMA_MEM_EN_NUM__SHIFT                                             0x8
#define MMHUBBUB_MEM_PWR_CNTL__MCIF_DWB1_MEM_PWR_FORCE__SHIFT                                                 0x9
#define MMHUBBUB_MEM_PWR_CNTL__MCIF_DWB1_MEM_PWR_DIS__SHIFT                                                   0xb
#define MMHUBBUB_MEM_PWR_CNTL__MCIF_DWB1_MEM_PWR_MODE_SEL__SHIFT                                              0xc
#define MMHUBBUB_MEM_PWR_CNTL__MCIF_DWB1_LUMA_MEM_EN_NUM__SHIFT                                               0xe
#define MMHUBBUB_MEM_PWR_CNTL__MCIF_DWB1_CHROMA_MEM_EN_NUM__SHIFT                                             0xf
#define MMHUBBUB_MEM_PWR_CNTL__VGA_MEM_PWR_FORCE_MASK                                                         0x00000001L
#define MMHUBBUB_MEM_PWR_CNTL__VGA_MEM_PWR_DIS_MASK                                                           0x00000002L
#define MMHUBBUB_MEM_PWR_CNTL__MCIF_DWB0_MEM_PWR_FORCE_MASK                                                   0x0000000CL
#define MMHUBBUB_MEM_PWR_CNTL__MCIF_DWB0_MEM_PWR_DIS_MASK                                                     0x00000010L
#define MMHUBBUB_MEM_PWR_CNTL__MCIF_DWB0_MEM_PWR_MODE_SEL_MASK                                                0x00000060L
#define MMHUBBUB_MEM_PWR_CNTL__MCIF_DWB0_LUMA_MEM_EN_NUM_MASK                                                 0x00000080L
#define MMHUBBUB_MEM_PWR_CNTL__MCIF_DWB0_CHROMA_MEM_EN_NUM_MASK                                               0x00000100L
#define MMHUBBUB_MEM_PWR_CNTL__MCIF_DWB1_MEM_PWR_FORCE_MASK                                                   0x00000600L
#define MMHUBBUB_MEM_PWR_CNTL__MCIF_DWB1_MEM_PWR_DIS_MASK                                                     0x00000800L
#define MMHUBBUB_MEM_PWR_CNTL__MCIF_DWB1_MEM_PWR_MODE_SEL_MASK                                                0x00003000L
#define MMHUBBUB_MEM_PWR_CNTL__MCIF_DWB1_LUMA_MEM_EN_NUM_MASK                                                 0x00004000L
#define MMHUBBUB_MEM_PWR_CNTL__MCIF_DWB1_CHROMA_MEM_EN_NUM_MASK                                               0x00008000L
//MMHUBBUB_CLOCK_CNTL
#define MMHUBBUB_CLOCK_CNTL__MMHUBBUB_TEST_CLK_SEL__SHIFT                                                     0x0
#define MMHUBBUB_CLOCK_CNTL__DISPCLK_R_MMHUBBUB_GATE_DIS__SHIFT                                               0x5
#define MMHUBBUB_CLOCK_CNTL__DISPCLK_G_VGAIF_GATE_DIS__SHIFT                                                  0x6
#define MMHUBBUB_CLOCK_CNTL__SOCCLK_G_VGAIF_GATE_DIS__SHIFT                                                   0x7
#define MMHUBBUB_CLOCK_CNTL__DISPCLK_G_VGA_GATE_DIS__SHIFT                                                    0x8
#define MMHUBBUB_CLOCK_CNTL__DISPCLK_G_WBIF0_GATE_DIS__SHIFT                                                  0x9
#define MMHUBBUB_CLOCK_CNTL__SOCCLK_G_WBIF0_GATE_DIS__SHIFT                                                   0xa
#define MMHUBBUB_CLOCK_CNTL__DISPCLK_G_WBIF1_GATE_DIS__SHIFT                                                  0xb
#define MMHUBBUB_CLOCK_CNTL__SOCCLK_G_WBIF1_GATE_DIS__SHIFT                                                   0xc
#define MMHUBBUB_CLOCK_CNTL__MMHUBBUB_TEST_CLK_SEL_MASK                                                       0x0000001FL
#define MMHUBBUB_CLOCK_CNTL__DISPCLK_R_MMHUBBUB_GATE_DIS_MASK                                                 0x00000020L
#define MMHUBBUB_CLOCK_CNTL__DISPCLK_G_VGAIF_GATE_DIS_MASK                                                    0x00000040L
#define MMHUBBUB_CLOCK_CNTL__SOCCLK_G_VGAIF_GATE_DIS_MASK                                                     0x00000080L
#define MMHUBBUB_CLOCK_CNTL__DISPCLK_G_VGA_GATE_DIS_MASK                                                      0x00000100L
#define MMHUBBUB_CLOCK_CNTL__DISPCLK_G_WBIF0_GATE_DIS_MASK                                                    0x00000200L
#define MMHUBBUB_CLOCK_CNTL__SOCCLK_G_WBIF0_GATE_DIS_MASK                                                     0x00000400L
#define MMHUBBUB_CLOCK_CNTL__DISPCLK_G_WBIF1_GATE_DIS_MASK                                                    0x00000800L
#define MMHUBBUB_CLOCK_CNTL__SOCCLK_G_WBIF1_GATE_DIS_MASK                                                     0x00001000L
//MMHUBBUB_SOFT_RESET
#define MMHUBBUB_SOFT_RESET__VGA_SOFT_RESET__SHIFT                                                            0x0
#define MMHUBBUB_SOFT_RESET__VGAIF_SOFT_RESET__SHIFT                                                          0x1
#define MMHUBBUB_SOFT_RESET__WBIF0_SOFT_RESET__SHIFT                                                          0x2
#define MMHUBBUB_SOFT_RESET__WBIF1_SOFT_RESET__SHIFT                                                          0x3
#define MMHUBBUB_SOFT_RESET__VGA_SOFT_RESET_MASK                                                              0x00000001L
#define MMHUBBUB_SOFT_RESET__VGAIF_SOFT_RESET_MASK                                                            0x00000002L
#define MMHUBBUB_SOFT_RESET__WBIF0_SOFT_RESET_MASK                                                            0x00000004L
#define MMHUBBUB_SOFT_RESET__WBIF1_SOFT_RESET_MASK                                                            0x00000008L


// addressBlock: dce_dc_mmhubbub_vgaif_dispdec
//MCIF_CONTROL
#define MCIF_CONTROL__MCIF_MC_LATENCY_COUNTER_ENABLE__SHIFT                                                   0x1e
#define MCIF_CONTROL__MCIF_MC_LATENCY_COUNTER_URGENT_ONLY__SHIFT                                              0x1f
#define MCIF_CONTROL__MCIF_MC_LATENCY_COUNTER_ENABLE_MASK                                                     0x40000000L
#define MCIF_CONTROL__MCIF_MC_LATENCY_COUNTER_URGENT_ONLY_MASK                                                0x80000000L
//MCIF_WRITE_COMBINE_CONTROL
#define MCIF_WRITE_COMBINE_CONTROL__MCIF_WRITE_COMBINE_TIMEOUT__SHIFT                                         0x0
#define MCIF_WRITE_COMBINE_CONTROL__MCIF_WRITE_COMBINE_TIMEOUT_MASK                                           0x000003FFL
//MCIF_PHASE0_OUTSTANDING_COUNTER
#define MCIF_PHASE0_OUTSTANDING_COUNTER__MCIF_PHASE0_OUTSTANDING_COUNTER__SHIFT                               0x0
#define MCIF_PHASE0_OUTSTANDING_COUNTER__MCIF_PHASE0_OUTSTANDING_COUNTER_MASK                                 0x07FFFFFFL
//MCIF_PHASE1_OUTSTANDING_COUNTER
#define MCIF_PHASE1_OUTSTANDING_COUNTER__MCIF_PHASE1_OUTSTANDING_COUNTER__SHIFT                               0x0
#define MCIF_PHASE1_OUTSTANDING_COUNTER__MCIF_PHASE1_OUTSTANDING_COUNTER_MASK                                 0x07FFFFFFL
//MCIF_PHASE2_OUTSTANDING_COUNTER
#define MCIF_PHASE2_OUTSTANDING_COUNTER__MCIF_PHASE2_OUTSTANDING_COUNTER__SHIFT                               0x0
#define MCIF_PHASE2_OUTSTANDING_COUNTER__MCIF_PHASE2_OUTSTANDING_COUNTER_MASK                                 0x07FFFFFFL


// addressBlock: dce_dc_mmhubbub_mmhubbub_dcperfmon_dc_perfmon_dispdec
//DC_PERFMON5_PERFCOUNTER_CNTL
#define DC_PERFMON5_PERFCOUNTER_CNTL__PERFCOUNTER_EVENT_SEL__SHIFT                                            0x0
#define DC_PERFMON5_PERFCOUNTER_CNTL__PERFCOUNTER_CVALUE_SEL__SHIFT                                           0x9
#define DC_PERFMON5_PERFCOUNTER_CNTL__PERFCOUNTER_INC_MODE__SHIFT                                             0xc
#define DC_PERFMON5_PERFCOUNTER_CNTL__PERFCOUNTER_HW_CNTL_SEL__SHIFT                                          0xf
#define DC_PERFMON5_PERFCOUNTER_CNTL__PERFCOUNTER_RUNEN_MODE__SHIFT                                           0x10
#define DC_PERFMON5_PERFCOUNTER_CNTL__PERFCOUNTER_CNTOFF_START_DIS__SHIFT                                     0x16
#define DC_PERFMON5_PERFCOUNTER_CNTL__PERFCOUNTER_RESTART_EN__SHIFT                                           0x17
#define DC_PERFMON5_PERFCOUNTER_CNTL__PERFCOUNTER_INT_EN__SHIFT                                               0x18
#define DC_PERFMON5_PERFCOUNTER_CNTL__PERFCOUNTER_OFF_MASK__SHIFT                                             0x19
#define DC_PERFMON5_PERFCOUNTER_CNTL__PERFCOUNTER_ACTIVE__SHIFT                                               0x1a
#define DC_PERFMON5_PERFCOUNTER_CNTL__PERFCOUNTER_CNTL_SEL__SHIFT                                             0x1d
#define DC_PERFMON5_PERFCOUNTER_CNTL__PERFCOUNTER_EVENT_SEL_MASK                                              0x000001FFL
#define DC_PERFMON5_PERFCOUNTER_CNTL__PERFCOUNTER_CVALUE_SEL_MASK                                             0x00000E00L
#define DC_PERFMON5_PERFCOUNTER_CNTL__PERFCOUNTER_INC_MODE_MASK                                               0x00007000L
#define DC_PERFMON5_PERFCOUNTER_CNTL__PERFCOUNTER_HW_CNTL_SEL_MASK                                            0x00008000L
#define DC_PERFMON5_PERFCOUNTER_CNTL__PERFCOUNTER_RUNEN_MODE_MASK                                             0x00010000L
#define DC_PERFMON5_PERFCOUNTER_CNTL__PERFCOUNTER_CNTOFF_START_DIS_MASK                                       0x00400000L
#define DC_PERFMON5_PERFCOUNTER_CNTL__PERFCOUNTER_RESTART_EN_MASK                                             0x00800000L
#define DC_PERFMON5_PERFCOUNTER_CNTL__PERFCOUNTER_INT_EN_MASK                                                 0x01000000L
#define DC_PERFMON5_PERFCOUNTER_CNTL__PERFCOUNTER_OFF_MASK_MASK                                               0x02000000L
#define DC_PERFMON5_PERFCOUNTER_CNTL__PERFCOUNTER_ACTIVE_MASK                                                 0x04000000L
#define DC_PERFMON5_PERFCOUNTER_CNTL__PERFCOUNTER_CNTL_SEL_MASK                                               0xE0000000L
//DC_PERFMON5_PERFCOUNTER_CNTL2
#define DC_PERFMON5_PERFCOUNTER_CNTL2__PERFCOUNTER_COUNTED_VALUE_TYPE__SHIFT                                  0x0
#define DC_PERFMON5_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP1_SEL__SHIFT                                        0x2
#define DC_PERFMON5_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP2_SEL__SHIFT                                        0x3
#define DC_PERFMON5_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTOFF_SEL__SHIFT                                          0x8
#define DC_PERFMON5_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTL2_SEL__SHIFT                                           0x1d
#define DC_PERFMON5_PERFCOUNTER_CNTL2__PERFCOUNTER_COUNTED_VALUE_TYPE_MASK                                    0x00000003L
#define DC_PERFMON5_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP1_SEL_MASK                                          0x00000004L
#define DC_PERFMON5_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP2_SEL_MASK                                          0x00000008L
#define DC_PERFMON5_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTOFF_SEL_MASK                                            0x00003F00L
#define DC_PERFMON5_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTL2_SEL_MASK                                             0xE0000000L
//DC_PERFMON5_PERFCOUNTER_STATE
#define DC_PERFMON5_PERFCOUNTER_STATE__PERFCOUNTER_CNT0_STATE__SHIFT                                          0x0
#define DC_PERFMON5_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL0__SHIFT                                          0x2
#define DC_PERFMON5_PERFCOUNTER_STATE__PERFCOUNTER_CNT1_STATE__SHIFT                                          0x4
#define DC_PERFMON5_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL1__SHIFT                                          0x6
#define DC_PERFMON5_PERFCOUNTER_STATE__PERFCOUNTER_CNT2_STATE__SHIFT                                          0x8
#define DC_PERFMON5_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL2__SHIFT                                          0xa
#define DC_PERFMON5_PERFCOUNTER_STATE__PERFCOUNTER_CNT3_STATE__SHIFT                                          0xc
#define DC_PERFMON5_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL3__SHIFT                                          0xe
#define DC_PERFMON5_PERFCOUNTER_STATE__PERFCOUNTER_CNT4_STATE__SHIFT                                          0x10
#define DC_PERFMON5_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL4__SHIFT                                          0x12
#define DC_PERFMON5_PERFCOUNTER_STATE__PERFCOUNTER_CNT5_STATE__SHIFT                                          0x14
#define DC_PERFMON5_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL5__SHIFT                                          0x16
#define DC_PERFMON5_PERFCOUNTER_STATE__PERFCOUNTER_CNT6_STATE__SHIFT                                          0x18
#define DC_PERFMON5_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL6__SHIFT                                          0x1a
#define DC_PERFMON5_PERFCOUNTER_STATE__PERFCOUNTER_CNT7_STATE__SHIFT                                          0x1c
#define DC_PERFMON5_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL7__SHIFT                                          0x1e
#define DC_PERFMON5_PERFCOUNTER_STATE__PERFCOUNTER_CNT0_STATE_MASK                                            0x00000003L
#define DC_PERFMON5_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL0_MASK                                            0x00000004L
#define DC_PERFMON5_PERFCOUNTER_STATE__PERFCOUNTER_CNT1_STATE_MASK                                            0x00000030L
#define DC_PERFMON5_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL1_MASK                                            0x00000040L
#define DC_PERFMON5_PERFCOUNTER_STATE__PERFCOUNTER_CNT2_STATE_MASK                                            0x00000300L
#define DC_PERFMON5_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL2_MASK                                            0x00000400L
#define DC_PERFMON5_PERFCOUNTER_STATE__PERFCOUNTER_CNT3_STATE_MASK                                            0x00003000L
#define DC_PERFMON5_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL3_MASK                                            0x00004000L
#define DC_PERFMON5_PERFCOUNTER_STATE__PERFCOUNTER_CNT4_STATE_MASK                                            0x00030000L
#define DC_PERFMON5_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL4_MASK                                            0x00040000L
#define DC_PERFMON5_PERFCOUNTER_STATE__PERFCOUNTER_CNT5_STATE_MASK                                            0x00300000L
#define DC_PERFMON5_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL5_MASK                                            0x00400000L
#define DC_PERFMON5_PERFCOUNTER_STATE__PERFCOUNTER_CNT6_STATE_MASK                                            0x03000000L
#define DC_PERFMON5_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL6_MASK                                            0x04000000L
#define DC_PERFMON5_PERFCOUNTER_STATE__PERFCOUNTER_CNT7_STATE_MASK                                            0x30000000L
#define DC_PERFMON5_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL7_MASK                                            0x40000000L
//DC_PERFMON5_PERFMON_CNTL
#define DC_PERFMON5_PERFMON_CNTL__PERFMON_STATE__SHIFT                                                        0x0
#define DC_PERFMON5_PERFMON_CNTL__PERFMON_RPT_COUNT__SHIFT                                                    0x8
#define DC_PERFMON5_PERFMON_CNTL__PERFMON_CNTOFF_AND_OR__SHIFT                                                0x1c
#define DC_PERFMON5_PERFMON_CNTL__PERFMON_CNTOFF_INT_EN__SHIFT                                                0x1d
#define DC_PERFMON5_PERFMON_CNTL__PERFMON_CNTOFF_INT_STATUS__SHIFT                                            0x1e
#define DC_PERFMON5_PERFMON_CNTL__PERFMON_CNTOFF_INT_ACK__SHIFT                                               0x1f
#define DC_PERFMON5_PERFMON_CNTL__PERFMON_STATE_MASK                                                          0x00000003L
#define DC_PERFMON5_PERFMON_CNTL__PERFMON_RPT_COUNT_MASK                                                      0x0FFFFF00L
#define DC_PERFMON5_PERFMON_CNTL__PERFMON_CNTOFF_AND_OR_MASK                                                  0x10000000L
#define DC_PERFMON5_PERFMON_CNTL__PERFMON_CNTOFF_INT_EN_MASK                                                  0x20000000L
#define DC_PERFMON5_PERFMON_CNTL__PERFMON_CNTOFF_INT_STATUS_MASK                                              0x40000000L
#define DC_PERFMON5_PERFMON_CNTL__PERFMON_CNTOFF_INT_ACK_MASK                                                 0x80000000L
//DC_PERFMON5_PERFMON_CNTL2
#define DC_PERFMON5_PERFMON_CNTL2__PERFMON_CNTOFF_INT_TYPE__SHIFT                                             0x0
#define DC_PERFMON5_PERFMON_CNTL2__PERFMON_CLK_ENABLE__SHIFT                                                  0x1
#define DC_PERFMON5_PERFMON_CNTL2__PERFMON_RUN_ENABLE_START_SEL__SHIFT                                        0x2
#define DC_PERFMON5_PERFMON_CNTL2__PERFMON_RUN_ENABLE_STOP_SEL__SHIFT                                         0xa
#define DC_PERFMON5_PERFMON_CNTL2__PERFMON_CNTOFF_INT_TYPE_MASK                                               0x00000001L
#define DC_PERFMON5_PERFMON_CNTL2__PERFMON_CLK_ENABLE_MASK                                                    0x00000002L
#define DC_PERFMON5_PERFMON_CNTL2__PERFMON_RUN_ENABLE_START_SEL_MASK                                          0x000003FCL
#define DC_PERFMON5_PERFMON_CNTL2__PERFMON_RUN_ENABLE_STOP_SEL_MASK                                           0x0003FC00L
//DC_PERFMON5_PERFMON_CVALUE_INT_MISC
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_STATUS__SHIFT                                   0x0
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_STATUS__SHIFT                                   0x1
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_STATUS__SHIFT                                   0x2
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_STATUS__SHIFT                                   0x3
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_STATUS__SHIFT                                   0x4
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_STATUS__SHIFT                                   0x5
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_STATUS__SHIFT                                   0x6
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_STATUS__SHIFT                                   0x7
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_ACK__SHIFT                                      0x8
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_ACK__SHIFT                                      0x9
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_ACK__SHIFT                                      0xa
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_ACK__SHIFT                                      0xb
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_ACK__SHIFT                                      0xc
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_ACK__SHIFT                                      0xd
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_ACK__SHIFT                                      0xe
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_ACK__SHIFT                                      0xf
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFMON_CVALUE_HI__SHIFT                                         0x10
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_STATUS_MASK                                     0x00000001L
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_STATUS_MASK                                     0x00000002L
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_STATUS_MASK                                     0x00000004L
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_STATUS_MASK                                     0x00000008L
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_STATUS_MASK                                     0x00000010L
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_STATUS_MASK                                     0x00000020L
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_STATUS_MASK                                     0x00000040L
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_STATUS_MASK                                     0x00000080L
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_ACK_MASK                                        0x00000100L
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_ACK_MASK                                        0x00000200L
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_ACK_MASK                                        0x00000400L
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_ACK_MASK                                        0x00000800L
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_ACK_MASK                                        0x00001000L
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_ACK_MASK                                        0x00002000L
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_ACK_MASK                                        0x00004000L
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_ACK_MASK                                        0x00008000L
#define DC_PERFMON5_PERFMON_CVALUE_INT_MISC__PERFMON_CVALUE_HI_MASK                                           0xFFFF0000L
//DC_PERFMON5_PERFMON_CVALUE_LOW
#define DC_PERFMON5_PERFMON_CVALUE_LOW__PERFMON_CVALUE_LOW__SHIFT                                             0x0
#define DC_PERFMON5_PERFMON_CVALUE_LOW__PERFMON_CVALUE_LOW_MASK                                               0xFFFFFFFFL
//DC_PERFMON5_PERFMON_HI
#define DC_PERFMON5_PERFMON_HI__PERFMON_HI__SHIFT                                                             0x0
#define DC_PERFMON5_PERFMON_HI__PERFMON_READ_SEL__SHIFT                                                       0x1d
#define DC_PERFMON5_PERFMON_HI__PERFMON_HI_MASK                                                               0x0000FFFFL
#define DC_PERFMON5_PERFMON_HI__PERFMON_READ_SEL_MASK                                                         0xE0000000L
//DC_PERFMON5_PERFMON_LOW
#define DC_PERFMON5_PERFMON_LOW__PERFMON_LOW__SHIFT                                                           0x0
#define DC_PERFMON5_PERFMON_LOW__PERFMON_LOW_MASK                                                             0xFFFFFFFFL


// addressBlock: dce_dc_hda_azf0stream0_dispdec
//AZF0STREAM0_AZALIA_STREAM_INDEX
#define AZF0STREAM0_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_INDEX__SHIFT                                       0x0
#define AZF0STREAM0_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_WRITE_EN__SHIFT                                    0x8
#define AZF0STREAM0_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_INDEX_MASK                                         0x000000FFL
#define AZF0STREAM0_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_WRITE_EN_MASK                                      0x00000100L
//AZF0STREAM0_AZALIA_STREAM_DATA
#define AZF0STREAM0_AZALIA_STREAM_DATA__AZALIA_STREAM_REG_DATA__SHIFT                                         0x0
#define AZF0STREAM0_AZALIA_STREAM_DATA__AZALIA_STREAM_REG_DATA_MASK                                           0xFFFFFFFFL


// addressBlock: dce_dc_hda_azf0stream1_dispdec
//AZF0STREAM1_AZALIA_STREAM_INDEX
#define AZF0STREAM1_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_INDEX__SHIFT                                       0x0
#define AZF0STREAM1_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_WRITE_EN__SHIFT                                    0x8
#define AZF0STREAM1_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_INDEX_MASK                                         0x000000FFL
#define AZF0STREAM1_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_WRITE_EN_MASK                                      0x00000100L
//AZF0STREAM1_AZALIA_STREAM_DATA
#define AZF0STREAM1_AZALIA_STREAM_DATA__AZALIA_STREAM_REG_DATA__SHIFT                                         0x0
#define AZF0STREAM1_AZALIA_STREAM_DATA__AZALIA_STREAM_REG_DATA_MASK                                           0xFFFFFFFFL


// addressBlock: dce_dc_hda_azf0stream2_dispdec
//AZF0STREAM2_AZALIA_STREAM_INDEX
#define AZF0STREAM2_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_INDEX__SHIFT                                       0x0
#define AZF0STREAM2_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_WRITE_EN__SHIFT                                    0x8
#define AZF0STREAM2_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_INDEX_MASK                                         0x000000FFL
#define AZF0STREAM2_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_WRITE_EN_MASK                                      0x00000100L
//AZF0STREAM2_AZALIA_STREAM_DATA
#define AZF0STREAM2_AZALIA_STREAM_DATA__AZALIA_STREAM_REG_DATA__SHIFT                                         0x0
#define AZF0STREAM2_AZALIA_STREAM_DATA__AZALIA_STREAM_REG_DATA_MASK                                           0xFFFFFFFFL


// addressBlock: dce_dc_hda_azf0stream3_dispdec
//AZF0STREAM3_AZALIA_STREAM_INDEX
#define AZF0STREAM3_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_INDEX__SHIFT                                       0x0
#define AZF0STREAM3_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_WRITE_EN__SHIFT                                    0x8
#define AZF0STREAM3_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_INDEX_MASK                                         0x000000FFL
#define AZF0STREAM3_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_WRITE_EN_MASK                                      0x00000100L
//AZF0STREAM3_AZALIA_STREAM_DATA
#define AZF0STREAM3_AZALIA_STREAM_DATA__AZALIA_STREAM_REG_DATA__SHIFT                                         0x0
#define AZF0STREAM3_AZALIA_STREAM_DATA__AZALIA_STREAM_REG_DATA_MASK                                           0xFFFFFFFFL


// addressBlock: dce_dc_hda_azf0stream4_dispdec
//AZF0STREAM4_AZALIA_STREAM_INDEX
#define AZF0STREAM4_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_INDEX__SHIFT                                       0x0
#define AZF0STREAM4_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_WRITE_EN__SHIFT                                    0x8
#define AZF0STREAM4_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_INDEX_MASK                                         0x000000FFL
#define AZF0STREAM4_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_WRITE_EN_MASK                                      0x00000100L
//AZF0STREAM4_AZALIA_STREAM_DATA
#define AZF0STREAM4_AZALIA_STREAM_DATA__AZALIA_STREAM_REG_DATA__SHIFT                                         0x0
#define AZF0STREAM4_AZALIA_STREAM_DATA__AZALIA_STREAM_REG_DATA_MASK                                           0xFFFFFFFFL


// addressBlock: dce_dc_hda_azf0stream5_dispdec
//AZF0STREAM5_AZALIA_STREAM_INDEX
#define AZF0STREAM5_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_INDEX__SHIFT                                       0x0
#define AZF0STREAM5_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_WRITE_EN__SHIFT                                    0x8
#define AZF0STREAM5_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_INDEX_MASK                                         0x000000FFL
#define AZF0STREAM5_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_WRITE_EN_MASK                                      0x00000100L
//AZF0STREAM5_AZALIA_STREAM_DATA
#define AZF0STREAM5_AZALIA_STREAM_DATA__AZALIA_STREAM_REG_DATA__SHIFT                                         0x0
#define AZF0STREAM5_AZALIA_STREAM_DATA__AZALIA_STREAM_REG_DATA_MASK                                           0xFFFFFFFFL


// addressBlock: dce_dc_hda_azf0stream6_dispdec
//AZF0STREAM6_AZALIA_STREAM_INDEX
#define AZF0STREAM6_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_INDEX__SHIFT                                       0x0
#define AZF0STREAM6_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_WRITE_EN__SHIFT                                    0x8
#define AZF0STREAM6_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_INDEX_MASK                                         0x000000FFL
#define AZF0STREAM6_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_WRITE_EN_MASK                                      0x00000100L
//AZF0STREAM6_AZALIA_STREAM_DATA
#define AZF0STREAM6_AZALIA_STREAM_DATA__AZALIA_STREAM_REG_DATA__SHIFT                                         0x0
#define AZF0STREAM6_AZALIA_STREAM_DATA__AZALIA_STREAM_REG_DATA_MASK                                           0xFFFFFFFFL


// addressBlock: dce_dc_hda_azf0stream7_dispdec
//AZF0STREAM7_AZALIA_STREAM_INDEX
#define AZF0STREAM7_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_INDEX__SHIFT                                       0x0
#define AZF0STREAM7_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_WRITE_EN__SHIFT                                    0x8
#define AZF0STREAM7_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_INDEX_MASK                                         0x000000FFL
#define AZF0STREAM7_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_WRITE_EN_MASK                                      0x00000100L
//AZF0STREAM7_AZALIA_STREAM_DATA
#define AZF0STREAM7_AZALIA_STREAM_DATA__AZALIA_STREAM_REG_DATA__SHIFT                                         0x0
#define AZF0STREAM7_AZALIA_STREAM_DATA__AZALIA_STREAM_REG_DATA_MASK                                           0xFFFFFFFFL


// addressBlock: dce_dc_hda_az_misc_dispdec
//AZ_CLOCK_CNTL
#define AZ_CLOCK_CNTL__SCLK_G_STREAM_AZ_GATE_DIS__SHIFT                                                       0x0
#define AZ_CLOCK_CNTL__SCLK_R_AZ_GATE_DIS__SHIFT                                                              0x8
#define AZ_CLOCK_CNTL__SCLK_G_CNTL_AZ_GATE_DIS__SHIFT                                                         0x10
#define AZ_CLOCK_CNTL__DCIPG_TEST_CLK_SEL__SHIFT                                                              0x18
#define AZ_CLOCK_CNTL__SCLK_G_STREAM_AZ_GATE_DIS_MASK                                                         0x00000001L
#define AZ_CLOCK_CNTL__SCLK_R_AZ_GATE_DIS_MASK                                                                0x00000100L
#define AZ_CLOCK_CNTL__SCLK_G_CNTL_AZ_GATE_DIS_MASK                                                           0x00010000L
#define AZ_CLOCK_CNTL__DCIPG_TEST_CLK_SEL_MASK                                                                0x1F000000L


// addressBlock: dce_dc_hda_az_dcperfmon_dc_perfmon_dispdec
//DC_PERFMON6_PERFCOUNTER_CNTL
#define DC_PERFMON6_PERFCOUNTER_CNTL__PERFCOUNTER_EVENT_SEL__SHIFT                                            0x0
#define DC_PERFMON6_PERFCOUNTER_CNTL__PERFCOUNTER_CVALUE_SEL__SHIFT                                           0x9
#define DC_PERFMON6_PERFCOUNTER_CNTL__PERFCOUNTER_INC_MODE__SHIFT                                             0xc
#define DC_PERFMON6_PERFCOUNTER_CNTL__PERFCOUNTER_HW_CNTL_SEL__SHIFT                                          0xf
#define DC_PERFMON6_PERFCOUNTER_CNTL__PERFCOUNTER_RUNEN_MODE__SHIFT                                           0x10
#define DC_PERFMON6_PERFCOUNTER_CNTL__PERFCOUNTER_CNTOFF_START_DIS__SHIFT                                     0x16
#define DC_PERFMON6_PERFCOUNTER_CNTL__PERFCOUNTER_RESTART_EN__SHIFT                                           0x17
#define DC_PERFMON6_PERFCOUNTER_CNTL__PERFCOUNTER_INT_EN__SHIFT                                               0x18
#define DC_PERFMON6_PERFCOUNTER_CNTL__PERFCOUNTER_OFF_MASK__SHIFT                                             0x19
#define DC_PERFMON6_PERFCOUNTER_CNTL__PERFCOUNTER_ACTIVE__SHIFT                                               0x1a
#define DC_PERFMON6_PERFCOUNTER_CNTL__PERFCOUNTER_CNTL_SEL__SHIFT                                             0x1d
#define DC_PERFMON6_PERFCOUNTER_CNTL__PERFCOUNTER_EVENT_SEL_MASK                                              0x000001FFL
#define DC_PERFMON6_PERFCOUNTER_CNTL__PERFCOUNTER_CVALUE_SEL_MASK                                             0x00000E00L
#define DC_PERFMON6_PERFCOUNTER_CNTL__PERFCOUNTER_INC_MODE_MASK                                               0x00007000L
#define DC_PERFMON6_PERFCOUNTER_CNTL__PERFCOUNTER_HW_CNTL_SEL_MASK                                            0x00008000L
#define DC_PERFMON6_PERFCOUNTER_CNTL__PERFCOUNTER_RUNEN_MODE_MASK                                             0x00010000L
#define DC_PERFMON6_PERFCOUNTER_CNTL__PERFCOUNTER_CNTOFF_START_DIS_MASK                                       0x00400000L
#define DC_PERFMON6_PERFCOUNTER_CNTL__PERFCOUNTER_RESTART_EN_MASK                                             0x00800000L
#define DC_PERFMON6_PERFCOUNTER_CNTL__PERFCOUNTER_INT_EN_MASK                                                 0x01000000L
#define DC_PERFMON6_PERFCOUNTER_CNTL__PERFCOUNTER_OFF_MASK_MASK                                               0x02000000L
#define DC_PERFMON6_PERFCOUNTER_CNTL__PERFCOUNTER_ACTIVE_MASK                                                 0x04000000L
#define DC_PERFMON6_PERFCOUNTER_CNTL__PERFCOUNTER_CNTL_SEL_MASK                                               0xE0000000L
//DC_PERFMON6_PERFCOUNTER_CNTL2
#define DC_PERFMON6_PERFCOUNTER_CNTL2__PERFCOUNTER_COUNTED_VALUE_TYPE__SHIFT                                  0x0
#define DC_PERFMON6_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP1_SEL__SHIFT                                        0x2
#define DC_PERFMON6_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP2_SEL__SHIFT                                        0x3
#define DC_PERFMON6_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTOFF_SEL__SHIFT                                          0x8
#define DC_PERFMON6_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTL2_SEL__SHIFT                                           0x1d
#define DC_PERFMON6_PERFCOUNTER_CNTL2__PERFCOUNTER_COUNTED_VALUE_TYPE_MASK                                    0x00000003L
#define DC_PERFMON6_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP1_SEL_MASK                                          0x00000004L
#define DC_PERFMON6_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP2_SEL_MASK                                          0x00000008L
#define DC_PERFMON6_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTOFF_SEL_MASK                                            0x00003F00L
#define DC_PERFMON6_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTL2_SEL_MASK                                             0xE0000000L
//DC_PERFMON6_PERFCOUNTER_STATE
#define DC_PERFMON6_PERFCOUNTER_STATE__PERFCOUNTER_CNT0_STATE__SHIFT                                          0x0
#define DC_PERFMON6_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL0__SHIFT                                          0x2
#define DC_PERFMON6_PERFCOUNTER_STATE__PERFCOUNTER_CNT1_STATE__SHIFT                                          0x4
#define DC_PERFMON6_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL1__SHIFT                                          0x6
#define DC_PERFMON6_PERFCOUNTER_STATE__PERFCOUNTER_CNT2_STATE__SHIFT                                          0x8
#define DC_PERFMON6_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL2__SHIFT                                          0xa
#define DC_PERFMON6_PERFCOUNTER_STATE__PERFCOUNTER_CNT3_STATE__SHIFT                                          0xc
#define DC_PERFMON6_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL3__SHIFT                                          0xe
#define DC_PERFMON6_PERFCOUNTER_STATE__PERFCOUNTER_CNT4_STATE__SHIFT                                          0x10
#define DC_PERFMON6_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL4__SHIFT                                          0x12
#define DC_PERFMON6_PERFCOUNTER_STATE__PERFCOUNTER_CNT5_STATE__SHIFT                                          0x14
#define DC_PERFMON6_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL5__SHIFT                                          0x16
#define DC_PERFMON6_PERFCOUNTER_STATE__PERFCOUNTER_CNT6_STATE__SHIFT                                          0x18
#define DC_PERFMON6_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL6__SHIFT                                          0x1a
#define DC_PERFMON6_PERFCOUNTER_STATE__PERFCOUNTER_CNT7_STATE__SHIFT                                          0x1c
#define DC_PERFMON6_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL7__SHIFT                                          0x1e
#define DC_PERFMON6_PERFCOUNTER_STATE__PERFCOUNTER_CNT0_STATE_MASK                                            0x00000003L
#define DC_PERFMON6_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL0_MASK                                            0x00000004L
#define DC_PERFMON6_PERFCOUNTER_STATE__PERFCOUNTER_CNT1_STATE_MASK                                            0x00000030L
#define DC_PERFMON6_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL1_MASK                                            0x00000040L
#define DC_PERFMON6_PERFCOUNTER_STATE__PERFCOUNTER_CNT2_STATE_MASK                                            0x00000300L
#define DC_PERFMON6_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL2_MASK                                            0x00000400L
#define DC_PERFMON6_PERFCOUNTER_STATE__PERFCOUNTER_CNT3_STATE_MASK                                            0x00003000L
#define DC_PERFMON6_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL3_MASK                                            0x00004000L
#define DC_PERFMON6_PERFCOUNTER_STATE__PERFCOUNTER_CNT4_STATE_MASK                                            0x00030000L
#define DC_PERFMON6_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL4_MASK                                            0x00040000L
#define DC_PERFMON6_PERFCOUNTER_STATE__PERFCOUNTER_CNT5_STATE_MASK                                            0x00300000L
#define DC_PERFMON6_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL5_MASK                                            0x00400000L
#define DC_PERFMON6_PERFCOUNTER_STATE__PERFCOUNTER_CNT6_STATE_MASK                                            0x03000000L
#define DC_PERFMON6_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL6_MASK                                            0x04000000L
#define DC_PERFMON6_PERFCOUNTER_STATE__PERFCOUNTER_CNT7_STATE_MASK                                            0x30000000L
#define DC_PERFMON6_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL7_MASK                                            0x40000000L
//DC_PERFMON6_PERFMON_CNTL
#define DC_PERFMON6_PERFMON_CNTL__PERFMON_STATE__SHIFT                                                        0x0
#define DC_PERFMON6_PERFMON_CNTL__PERFMON_RPT_COUNT__SHIFT                                                    0x8
#define DC_PERFMON6_PERFMON_CNTL__PERFMON_CNTOFF_AND_OR__SHIFT                                                0x1c
#define DC_PERFMON6_PERFMON_CNTL__PERFMON_CNTOFF_INT_EN__SHIFT                                                0x1d
#define DC_PERFMON6_PERFMON_CNTL__PERFMON_CNTOFF_INT_STATUS__SHIFT                                            0x1e
#define DC_PERFMON6_PERFMON_CNTL__PERFMON_CNTOFF_INT_ACK__SHIFT                                               0x1f
#define DC_PERFMON6_PERFMON_CNTL__PERFMON_STATE_MASK                                                          0x00000003L
#define DC_PERFMON6_PERFMON_CNTL__PERFMON_RPT_COUNT_MASK                                                      0x0FFFFF00L
#define DC_PERFMON6_PERFMON_CNTL__PERFMON_CNTOFF_AND_OR_MASK                                                  0x10000000L
#define DC_PERFMON6_PERFMON_CNTL__PERFMON_CNTOFF_INT_EN_MASK                                                  0x20000000L
#define DC_PERFMON6_PERFMON_CNTL__PERFMON_CNTOFF_INT_STATUS_MASK                                              0x40000000L
#define DC_PERFMON6_PERFMON_CNTL__PERFMON_CNTOFF_INT_ACK_MASK                                                 0x80000000L
//DC_PERFMON6_PERFMON_CNTL2
#define DC_PERFMON6_PERFMON_CNTL2__PERFMON_CNTOFF_INT_TYPE__SHIFT                                             0x0
#define DC_PERFMON6_PERFMON_CNTL2__PERFMON_CLK_ENABLE__SHIFT                                                  0x1
#define DC_PERFMON6_PERFMON_CNTL2__PERFMON_RUN_ENABLE_START_SEL__SHIFT                                        0x2
#define DC_PERFMON6_PERFMON_CNTL2__PERFMON_RUN_ENABLE_STOP_SEL__SHIFT                                         0xa
#define DC_PERFMON6_PERFMON_CNTL2__PERFMON_CNTOFF_INT_TYPE_MASK                                               0x00000001L
#define DC_PERFMON6_PERFMON_CNTL2__PERFMON_CLK_ENABLE_MASK                                                    0x00000002L
#define DC_PERFMON6_PERFMON_CNTL2__PERFMON_RUN_ENABLE_START_SEL_MASK                                          0x000003FCL
#define DC_PERFMON6_PERFMON_CNTL2__PERFMON_RUN_ENABLE_STOP_SEL_MASK                                           0x0003FC00L
//DC_PERFMON6_PERFMON_CVALUE_INT_MISC
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_STATUS__SHIFT                                   0x0
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_STATUS__SHIFT                                   0x1
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_STATUS__SHIFT                                   0x2
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_STATUS__SHIFT                                   0x3
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_STATUS__SHIFT                                   0x4
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_STATUS__SHIFT                                   0x5
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_STATUS__SHIFT                                   0x6
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_STATUS__SHIFT                                   0x7
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_ACK__SHIFT                                      0x8
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_ACK__SHIFT                                      0x9
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_ACK__SHIFT                                      0xa
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_ACK__SHIFT                                      0xb
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_ACK__SHIFT                                      0xc
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_ACK__SHIFT                                      0xd
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_ACK__SHIFT                                      0xe
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_ACK__SHIFT                                      0xf
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFMON_CVALUE_HI__SHIFT                                         0x10
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_STATUS_MASK                                     0x00000001L
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_STATUS_MASK                                     0x00000002L
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_STATUS_MASK                                     0x00000004L
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_STATUS_MASK                                     0x00000008L
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_STATUS_MASK                                     0x00000010L
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_STATUS_MASK                                     0x00000020L
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_STATUS_MASK                                     0x00000040L
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_STATUS_MASK                                     0x00000080L
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_ACK_MASK                                        0x00000100L
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_ACK_MASK                                        0x00000200L
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_ACK_MASK                                        0x00000400L
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_ACK_MASK                                        0x00000800L
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_ACK_MASK                                        0x00001000L
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_ACK_MASK                                        0x00002000L
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_ACK_MASK                                        0x00004000L
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_ACK_MASK                                        0x00008000L
#define DC_PERFMON6_PERFMON_CVALUE_INT_MISC__PERFMON_CVALUE_HI_MASK                                           0xFFFF0000L
//DC_PERFMON6_PERFMON_CVALUE_LOW
#define DC_PERFMON6_PERFMON_CVALUE_LOW__PERFMON_CVALUE_LOW__SHIFT                                             0x0
#define DC_PERFMON6_PERFMON_CVALUE_LOW__PERFMON_CVALUE_LOW_MASK                                               0xFFFFFFFFL
//DC_PERFMON6_PERFMON_HI
#define DC_PERFMON6_PERFMON_HI__PERFMON_HI__SHIFT                                                             0x0
#define DC_PERFMON6_PERFMON_HI__PERFMON_READ_SEL__SHIFT                                                       0x1d
#define DC_PERFMON6_PERFMON_HI__PERFMON_HI_MASK                                                               0x0000FFFFL
#define DC_PERFMON6_PERFMON_HI__PERFMON_READ_SEL_MASK                                                         0xE0000000L
//DC_PERFMON6_PERFMON_LOW
#define DC_PERFMON6_PERFMON_LOW__PERFMON_LOW__SHIFT                                                           0x0
#define DC_PERFMON6_PERFMON_LOW__PERFMON_LOW_MASK                                                             0xFFFFFFFFL


// addressBlock: dce_dc_hda_azf0endpoint0_dispdec
//AZF0ENDPOINT0_AZALIA_F0_CODEC_ENDPOINT_INDEX
#define AZF0ENDPOINT0_AZALIA_F0_CODEC_ENDPOINT_INDEX__AZALIA_ENDPOINT_REG_INDEX__SHIFT                        0x0
#define AZF0ENDPOINT0_AZALIA_F0_CODEC_ENDPOINT_INDEX__AZALIA_ENDPOINT_REG_INDEX_MASK                          0x00003FFFL
//AZF0ENDPOINT0_AZALIA_F0_CODEC_ENDPOINT_DATA
#define AZF0ENDPOINT0_AZALIA_F0_CODEC_ENDPOINT_DATA__AZALIA_ENDPOINT_REG_DATA__SHIFT                          0x0
#define AZF0ENDPOINT0_AZALIA_F0_CODEC_ENDPOINT_DATA__AZALIA_ENDPOINT_REG_DATA_MASK                            0xFFFFFFFFL


// addressBlock: dce_dc_hda_azf0endpoint1_dispdec
//AZF0ENDPOINT1_AZALIA_F0_CODEC_ENDPOINT_INDEX
#define AZF0ENDPOINT1_AZALIA_F0_CODEC_ENDPOINT_INDEX__AZALIA_ENDPOINT_REG_INDEX__SHIFT                        0x0
#define AZF0ENDPOINT1_AZALIA_F0_CODEC_ENDPOINT_INDEX__AZALIA_ENDPOINT_REG_INDEX_MASK                          0x00003FFFL
//AZF0ENDPOINT1_AZALIA_F0_CODEC_ENDPOINT_DATA
#define AZF0ENDPOINT1_AZALIA_F0_CODEC_ENDPOINT_DATA__AZALIA_ENDPOINT_REG_DATA__SHIFT                          0x0
#define AZF0ENDPOINT1_AZALIA_F0_CODEC_ENDPOINT_DATA__AZALIA_ENDPOINT_REG_DATA_MASK                            0xFFFFFFFFL


// addressBlock: dce_dc_hda_azf0endpoint2_dispdec
//AZF0ENDPOINT2_AZALIA_F0_CODEC_ENDPOINT_INDEX
#define AZF0ENDPOINT2_AZALIA_F0_CODEC_ENDPOINT_INDEX__AZALIA_ENDPOINT_REG_INDEX__SHIFT                        0x0
#define AZF0ENDPOINT2_AZALIA_F0_CODEC_ENDPOINT_INDEX__AZALIA_ENDPOINT_REG_INDEX_MASK                          0x00003FFFL
//AZF0ENDPOINT2_AZALIA_F0_CODEC_ENDPOINT_DATA
#define AZF0ENDPOINT2_AZALIA_F0_CODEC_ENDPOINT_DATA__AZALIA_ENDPOINT_REG_DATA__SHIFT                          0x0
#define AZF0ENDPOINT2_AZALIA_F0_CODEC_ENDPOINT_DATA__AZALIA_ENDPOINT_REG_DATA_MASK                            0xFFFFFFFFL


// addressBlock: dce_dc_hda_azf0endpoint3_dispdec
//AZF0ENDPOINT3_AZALIA_F0_CODEC_ENDPOINT_INDEX
#define AZF0ENDPOINT3_AZALIA_F0_CODEC_ENDPOINT_INDEX__AZALIA_ENDPOINT_REG_INDEX__SHIFT                        0x0
#define AZF0ENDPOINT3_AZALIA_F0_CODEC_ENDPOINT_INDEX__AZALIA_ENDPOINT_REG_INDEX_MASK                          0x00003FFFL
//AZF0ENDPOINT3_AZALIA_F0_CODEC_ENDPOINT_DATA
#define AZF0ENDPOINT3_AZALIA_F0_CODEC_ENDPOINT_DATA__AZALIA_ENDPOINT_REG_DATA__SHIFT                          0x0
#define AZF0ENDPOINT3_AZALIA_F0_CODEC_ENDPOINT_DATA__AZALIA_ENDPOINT_REG_DATA_MASK                            0xFFFFFFFFL


// addressBlock: dce_dc_hda_azf0endpoint4_dispdec
//AZF0ENDPOINT4_AZALIA_F0_CODEC_ENDPOINT_INDEX
#define AZF0ENDPOINT4_AZALIA_F0_CODEC_ENDPOINT_INDEX__AZALIA_ENDPOINT_REG_INDEX__SHIFT                        0x0
#define AZF0ENDPOINT4_AZALIA_F0_CODEC_ENDPOINT_INDEX__AZALIA_ENDPOINT_REG_INDEX_MASK                          0x00003FFFL
//AZF0ENDPOINT4_AZALIA_F0_CODEC_ENDPOINT_DATA
#define AZF0ENDPOINT4_AZALIA_F0_CODEC_ENDPOINT_DATA__AZALIA_ENDPOINT_REG_DATA__SHIFT                          0x0
#define AZF0ENDPOINT4_AZALIA_F0_CODEC_ENDPOINT_DATA__AZALIA_ENDPOINT_REG_DATA_MASK                            0xFFFFFFFFL


// addressBlock: dce_dc_hda_azf0endpoint5_dispdec
//AZF0ENDPOINT5_AZALIA_F0_CODEC_ENDPOINT_INDEX
#define AZF0ENDPOINT5_AZALIA_F0_CODEC_ENDPOINT_INDEX__AZALIA_ENDPOINT_REG_INDEX__SHIFT                        0x0
#define AZF0ENDPOINT5_AZALIA_F0_CODEC_ENDPOINT_INDEX__AZALIA_ENDPOINT_REG_INDEX_MASK                          0x00003FFFL
//AZF0ENDPOINT5_AZALIA_F0_CODEC_ENDPOINT_DATA
#define AZF0ENDPOINT5_AZALIA_F0_CODEC_ENDPOINT_DATA__AZALIA_ENDPOINT_REG_DATA__SHIFT                          0x0
#define AZF0ENDPOINT5_AZALIA_F0_CODEC_ENDPOINT_DATA__AZALIA_ENDPOINT_REG_DATA_MASK                            0xFFFFFFFFL


// addressBlock: dce_dc_hda_azf0endpoint6_dispdec
//AZF0ENDPOINT6_AZALIA_F0_CODEC_ENDPOINT_INDEX
#define AZF0ENDPOINT6_AZALIA_F0_CODEC_ENDPOINT_INDEX__AZALIA_ENDPOINT_REG_INDEX__SHIFT                        0x0
#define AZF0ENDPOINT6_AZALIA_F0_CODEC_ENDPOINT_INDEX__AZALIA_ENDPOINT_REG_INDEX_MASK                          0x00003FFFL
//AZF0ENDPOINT6_AZALIA_F0_CODEC_ENDPOINT_DATA
#define AZF0ENDPOINT6_AZALIA_F0_CODEC_ENDPOINT_DATA__AZALIA_ENDPOINT_REG_DATA__SHIFT                          0x0
#define AZF0ENDPOINT6_AZALIA_F0_CODEC_ENDPOINT_DATA__AZALIA_ENDPOINT_REG_DATA_MASK                            0xFFFFFFFFL


// addressBlock: dce_dc_hda_azf0endpoint7_dispdec
//AZF0ENDPOINT7_AZALIA_F0_CODEC_ENDPOINT_INDEX
#define AZF0ENDPOINT7_AZALIA_F0_CODEC_ENDPOINT_INDEX__AZALIA_ENDPOINT_REG_INDEX__SHIFT                        0x0
#define AZF0ENDPOINT7_AZALIA_F0_CODEC_ENDPOINT_INDEX__AZALIA_ENDPOINT_REG_INDEX_MASK                          0x00003FFFL
//AZF0ENDPOINT7_AZALIA_F0_CODEC_ENDPOINT_DATA
#define AZF0ENDPOINT7_AZALIA_F0_CODEC_ENDPOINT_DATA__AZALIA_ENDPOINT_REG_DATA__SHIFT                          0x0
#define AZF0ENDPOINT7_AZALIA_F0_CODEC_ENDPOINT_DATA__AZALIA_ENDPOINT_REG_DATA_MASK                            0xFFFFFFFFL


// addressBlock: dce_dc_hda_azf0controller_dispdec
//AZALIA_CONTROLLER_CLOCK_GATING
#define AZALIA_CONTROLLER_CLOCK_GATING__ENABLE_CLOCK_GATING__SHIFT                                            0x0
#define AZALIA_CONTROLLER_CLOCK_GATING__CLOCK_ON_STATE__SHIFT                                                 0x4
#define AZALIA_CONTROLLER_CLOCK_GATING__ENABLE_CLOCK_GATING_MASK                                              0x00000001L
#define AZALIA_CONTROLLER_CLOCK_GATING__CLOCK_ON_STATE_MASK                                                   0x00000010L
//AZALIA_AUDIO_DTO
#define AZALIA_AUDIO_DTO__AZALIA_AUDIO_DTO_PHASE__SHIFT                                                       0x0
#define AZALIA_AUDIO_DTO__AZALIA_AUDIO_DTO_MODULE__SHIFT                                                      0x10
#define AZALIA_AUDIO_DTO__AZALIA_AUDIO_DTO_PHASE_MASK                                                         0x0000FFFFL
#define AZALIA_AUDIO_DTO__AZALIA_AUDIO_DTO_MODULE_MASK                                                        0xFFFF0000L
//AZALIA_AUDIO_DTO_CONTROL
#define AZALIA_AUDIO_DTO_CONTROL__AZALIA_AUDIO_FORCE_DTO__SHIFT                                               0x8
#define AZALIA_AUDIO_DTO_CONTROL__AZALIA_AUDIO_FORCE_DTO_MASK                                                 0x00000300L
//AZALIA_SOCCLK_CONTROL
#define AZALIA_SOCCLK_CONTROL__AUDIO_STREAM_SOCCLK_DEEP_SLEEP_EXIT_EN__SHIFT                                  0x1
#define AZALIA_SOCCLK_CONTROL__AUDIO_STREAM_SOCCLK_DEEP_SLEEP_EXIT_EN_MASK                                    0x00000002L
//AZALIA_UNDERFLOW_FILLER_SAMPLE
#define AZALIA_UNDERFLOW_FILLER_SAMPLE__AZALIA_UNDERFLOW_FILLER_SAMPLE__SHIFT                                 0x0
#define AZALIA_UNDERFLOW_FILLER_SAMPLE__AZALIA_UNDERFLOW_FILLER_SAMPLE_MASK                                   0xFFFFFFFFL
//AZALIA_DATA_DMA_CONTROL
#define AZALIA_DATA_DMA_CONTROL__DATA_DMA_NON_SNOOP__SHIFT                                                    0x0
#define AZALIA_DATA_DMA_CONTROL__INPUT_DATA_DMA_NON_SNOOP__SHIFT                                              0x2
#define AZALIA_DATA_DMA_CONTROL__DATA_DMA_ISOCHRONOUS__SHIFT                                                  0x4
#define AZALIA_DATA_DMA_CONTROL__INPUT_DATA_DMA_ISOCHRONOUS__SHIFT                                            0x6
#define AZALIA_DATA_DMA_CONTROL__AZALIA_IOC_GENERATION_METHOD__SHIFT                                          0x10
#define AZALIA_DATA_DMA_CONTROL__AZALIA_UNDERFLOW_CONTROL__SHIFT                                              0x11
#define AZALIA_DATA_DMA_CONTROL__DATA_DMA_NON_SNOOP_MASK                                                      0x00000003L
#define AZALIA_DATA_DMA_CONTROL__INPUT_DATA_DMA_NON_SNOOP_MASK                                                0x0000000CL
#define AZALIA_DATA_DMA_CONTROL__DATA_DMA_ISOCHRONOUS_MASK                                                    0x00000030L
#define AZALIA_DATA_DMA_CONTROL__INPUT_DATA_DMA_ISOCHRONOUS_MASK                                              0x000000C0L
#define AZALIA_DATA_DMA_CONTROL__AZALIA_IOC_GENERATION_METHOD_MASK                                            0x00010000L
#define AZALIA_DATA_DMA_CONTROL__AZALIA_UNDERFLOW_CONTROL_MASK                                                0x00020000L
//AZALIA_BDL_DMA_CONTROL
#define AZALIA_BDL_DMA_CONTROL__BDL_DMA_NON_SNOOP__SHIFT                                                      0x0
#define AZALIA_BDL_DMA_CONTROL__INPUT_BDL_DMA_NON_SNOOP__SHIFT                                                0x2
#define AZALIA_BDL_DMA_CONTROL__BDL_DMA_ISOCHRONOUS__SHIFT                                                    0x4
#define AZALIA_BDL_DMA_CONTROL__INPUT_BDL_DMA_ISOCHRONOUS__SHIFT                                              0x6
#define AZALIA_BDL_DMA_CONTROL__BDL_DMA_NON_SNOOP_MASK                                                        0x00000003L
#define AZALIA_BDL_DMA_CONTROL__INPUT_BDL_DMA_NON_SNOOP_MASK                                                  0x0000000CL
#define AZALIA_BDL_DMA_CONTROL__BDL_DMA_ISOCHRONOUS_MASK                                                      0x00000030L
#define AZALIA_BDL_DMA_CONTROL__INPUT_BDL_DMA_ISOCHRONOUS_MASK                                                0x000000C0L
//AZALIA_RIRB_AND_DP_CONTROL
#define AZALIA_RIRB_AND_DP_CONTROL__RIRB_NON_SNOOP__SHIFT                                                     0x0
#define AZALIA_RIRB_AND_DP_CONTROL__DP_DMA_NON_SNOOP__SHIFT                                                   0x4
#define AZALIA_RIRB_AND_DP_CONTROL__DP_UPDATE_FREQ_DIVIDER__SHIFT                                             0x5
#define AZALIA_RIRB_AND_DP_CONTROL__RIRB_NON_SNOOP_MASK                                                       0x00000001L
#define AZALIA_RIRB_AND_DP_CONTROL__DP_DMA_NON_SNOOP_MASK                                                     0x00000010L
#define AZALIA_RIRB_AND_DP_CONTROL__DP_UPDATE_FREQ_DIVIDER_MASK                                               0x000001E0L
//AZALIA_CORB_DMA_CONTROL
#define AZALIA_CORB_DMA_CONTROL__CORB_DMA_NON_SNOOP__SHIFT                                                    0x0
#define AZALIA_CORB_DMA_CONTROL__CORB_DMA_ISOCHRONOUS__SHIFT                                                  0x4
#define AZALIA_CORB_DMA_CONTROL__CORB_DMA_NON_SNOOP_MASK                                                      0x00000001L
#define AZALIA_CORB_DMA_CONTROL__CORB_DMA_ISOCHRONOUS_MASK                                                    0x00000010L
//AZALIA_APPLICATION_POSITION_IN_CYCLIC_BUFFER
#define AZALIA_APPLICATION_POSITION_IN_CYCLIC_BUFFER__APPLICATION_POSITION_IN_CYCLIC_BUFFER__SHIFT            0x0
#define AZALIA_APPLICATION_POSITION_IN_CYCLIC_BUFFER__APPLICATION_POSITION_IN_CYCLIC_BUFFER_MASK              0xFFFFFFFFL
//AZALIA_CYCLIC_BUFFER_SYNC
#define AZALIA_CYCLIC_BUFFER_SYNC__CYCLIC_BUFFER_SYNC_ENABLE__SHIFT                                           0x0
#define AZALIA_CYCLIC_BUFFER_SYNC__CYCLIC_BUFFER_SYNC_ENABLE_MASK                                             0x00000001L
//AZALIA_GLOBAL_CAPABILITIES
#define AZALIA_GLOBAL_CAPABILITIES__NUMBER_OF_SERIAL_DATA_OUTPUT_SIGNALS__SHIFT                               0x1
#define AZALIA_GLOBAL_CAPABILITIES__NUMBER_OF_SERIAL_DATA_OUTPUT_SIGNALS_MASK                                 0x00000006L
//AZALIA_OUTPUT_PAYLOAD_CAPABILITY
#define AZALIA_OUTPUT_PAYLOAD_CAPABILITY__OUTPUT_PAYLOAD_CAPABILITY__SHIFT                                    0x0
#define AZALIA_OUTPUT_PAYLOAD_CAPABILITY__OUTSTRMPAY__SHIFT                                                   0x10
#define AZALIA_OUTPUT_PAYLOAD_CAPABILITY__OUTPUT_PAYLOAD_CAPABILITY_MASK                                      0x0000FFFFL
#define AZALIA_OUTPUT_PAYLOAD_CAPABILITY__OUTSTRMPAY_MASK                                                     0xFFFF0000L
//AZALIA_OUTPUT_STREAM_ARBITER_CONTROL
#define AZALIA_OUTPUT_STREAM_ARBITER_CONTROL__LATENCY_HIDING_LEVEL__SHIFT                                     0x0
#define AZALIA_OUTPUT_STREAM_ARBITER_CONTROL__SYS_MEM_ACTIVE_ENABLE__SHIFT                                    0x8
#define AZALIA_OUTPUT_STREAM_ARBITER_CONTROL__INPUT_LATENCY_HIDING_LEVEL__SHIFT                               0x10
#define AZALIA_OUTPUT_STREAM_ARBITER_CONTROL__LATENCY_HIDING_LEVEL_MASK                                       0x000000FFL
#define AZALIA_OUTPUT_STREAM_ARBITER_CONTROL__SYS_MEM_ACTIVE_ENABLE_MASK                                      0x00000100L
#define AZALIA_OUTPUT_STREAM_ARBITER_CONTROL__INPUT_LATENCY_HIDING_LEVEL_MASK                                 0x00FF0000L
//AZALIA_INPUT_PAYLOAD_CAPABILITY
#define AZALIA_INPUT_PAYLOAD_CAPABILITY__INPUT_PAYLOAD_CAPABILITY__SHIFT                                      0x0
#define AZALIA_INPUT_PAYLOAD_CAPABILITY__INSTRMPAY__SHIFT                                                     0x10
#define AZALIA_INPUT_PAYLOAD_CAPABILITY__INPUT_PAYLOAD_CAPABILITY_MASK                                        0x0000FFFFL
#define AZALIA_INPUT_PAYLOAD_CAPABILITY__INSTRMPAY_MASK                                                       0xFFFF0000L
//AZALIA_INPUT_CRC0_CONTROL0
#define AZALIA_INPUT_CRC0_CONTROL0__INPUT_CRC_EN__SHIFT                                                       0x0
#define AZALIA_INPUT_CRC0_CONTROL0__INPUT_CRC_BLOCK_MODE__SHIFT                                               0x4
#define AZALIA_INPUT_CRC0_CONTROL0__INPUT_CRC_INSTANCE_SEL__SHIFT                                             0x8
#define AZALIA_INPUT_CRC0_CONTROL0__INPUT_CRC_EN_MASK                                                         0x00000001L
#define AZALIA_INPUT_CRC0_CONTROL0__INPUT_CRC_BLOCK_MODE_MASK                                                 0x00000010L
#define AZALIA_INPUT_CRC0_CONTROL0__INPUT_CRC_INSTANCE_SEL_MASK                                               0x00000700L
//AZALIA_INPUT_CRC0_CONTROL1
#define AZALIA_INPUT_CRC0_CONTROL1__INPUT_CRC_BLOCK_SIZE__SHIFT                                               0x0
#define AZALIA_INPUT_CRC0_CONTROL1__INPUT_CRC_BLOCK_SIZE_MASK                                                 0xFFFFFFFFL
//AZALIA_INPUT_CRC0_CONTROL2
#define AZALIA_INPUT_CRC0_CONTROL2__INPUT_CRC_BLOCK_ITERATION__SHIFT                                          0x0
#define AZALIA_INPUT_CRC0_CONTROL2__INPUT_CRC_BLOCK_ITERATION_MASK                                            0x0000FFFFL
//AZALIA_INPUT_CRC0_CONTROL3
#define AZALIA_INPUT_CRC0_CONTROL3__INPUT_CRC_COMPLETE__SHIFT                                                 0x0
#define AZALIA_INPUT_CRC0_CONTROL3__INPUT_CRC_BLOCK_COMPLETE_PHASE__SHIFT                                     0x4
#define AZALIA_INPUT_CRC0_CONTROL3__INPUT_CRC_CHANNEL_RESULT_SEL__SHIFT                                       0x8
#define AZALIA_INPUT_CRC0_CONTROL3__INPUT_CRC_COMPLETE_MASK                                                   0x00000001L
#define AZALIA_INPUT_CRC0_CONTROL3__INPUT_CRC_BLOCK_COMPLETE_PHASE_MASK                                       0x00000010L
#define AZALIA_INPUT_CRC0_CONTROL3__INPUT_CRC_CHANNEL_RESULT_SEL_MASK                                         0x00000700L
//AZALIA_INPUT_CRC0_RESULT
#define AZALIA_INPUT_CRC0_RESULT__INPUT_CRC_RESULT__SHIFT                                                     0x0
#define AZALIA_INPUT_CRC0_RESULT__INPUT_CRC_RESULT_MASK                                                       0xFFFFFFFFL
//AZALIA_INPUT_CRC1_CONTROL0
#define AZALIA_INPUT_CRC1_CONTROL0__INPUT_CRC_EN__SHIFT                                                       0x0
#define AZALIA_INPUT_CRC1_CONTROL0__INPUT_CRC_BLOCK_MODE__SHIFT                                               0x4
#define AZALIA_INPUT_CRC1_CONTROL0__INPUT_CRC_INSTANCE_SEL__SHIFT                                             0x8
#define AZALIA_INPUT_CRC1_CONTROL0__INPUT_CRC_EN_MASK                                                         0x00000001L
#define AZALIA_INPUT_CRC1_CONTROL0__INPUT_CRC_BLOCK_MODE_MASK                                                 0x00000010L
#define AZALIA_INPUT_CRC1_CONTROL0__INPUT_CRC_INSTANCE_SEL_MASK                                               0x00000700L
//AZALIA_INPUT_CRC1_CONTROL1
#define AZALIA_INPUT_CRC1_CONTROL1__INPUT_CRC_BLOCK_SIZE__SHIFT                                               0x0
#define AZALIA_INPUT_CRC1_CONTROL1__INPUT_CRC_BLOCK_SIZE_MASK                                                 0xFFFFFFFFL
//AZALIA_INPUT_CRC1_CONTROL2
#define AZALIA_INPUT_CRC1_CONTROL2__INPUT_CRC_BLOCK_ITERATION__SHIFT                                          0x0
#define AZALIA_INPUT_CRC1_CONTROL2__INPUT_CRC_BLOCK_ITERATION_MASK                                            0x0000FFFFL
//AZALIA_INPUT_CRC1_CONTROL3
#define AZALIA_INPUT_CRC1_CONTROL3__INPUT_CRC_COMPLETE__SHIFT                                                 0x0
#define AZALIA_INPUT_CRC1_CONTROL3__INPUT_CRC_BLOCK_COMPLETE_PHASE__SHIFT                                     0x4
#define AZALIA_INPUT_CRC1_CONTROL3__INPUT_CRC_CHANNEL_RESULT_SEL__SHIFT                                       0x8
#define AZALIA_INPUT_CRC1_CONTROL3__INPUT_CRC_COMPLETE_MASK                                                   0x00000001L
#define AZALIA_INPUT_CRC1_CONTROL3__INPUT_CRC_BLOCK_COMPLETE_PHASE_MASK                                       0x00000010L
#define AZALIA_INPUT_CRC1_CONTROL3__INPUT_CRC_CHANNEL_RESULT_SEL_MASK                                         0x00000700L
//AZALIA_INPUT_CRC1_RESULT
#define AZALIA_INPUT_CRC1_RESULT__INPUT_CRC_RESULT__SHIFT                                                     0x0
#define AZALIA_INPUT_CRC1_RESULT__INPUT_CRC_RESULT_MASK                                                       0xFFFFFFFFL
//AZALIA_CRC0_CONTROL0
#define AZALIA_CRC0_CONTROL0__CRC_EN__SHIFT                                                                   0x0
#define AZALIA_CRC0_CONTROL0__CRC_BLOCK_MODE__SHIFT                                                           0x4
#define AZALIA_CRC0_CONTROL0__CRC_INSTANCE_SEL__SHIFT                                                         0x8
#define AZALIA_CRC0_CONTROL0__CRC_SOURCE_SEL__SHIFT                                                           0xc
#define AZALIA_CRC0_CONTROL0__CRC_EN_MASK                                                                     0x00000001L
#define AZALIA_CRC0_CONTROL0__CRC_BLOCK_MODE_MASK                                                             0x00000010L
#define AZALIA_CRC0_CONTROL0__CRC_INSTANCE_SEL_MASK                                                           0x00000700L
#define AZALIA_CRC0_CONTROL0__CRC_SOURCE_SEL_MASK                                                             0x00001000L
//AZALIA_CRC0_CONTROL1
#define AZALIA_CRC0_CONTROL1__CRC_BLOCK_SIZE__SHIFT                                                           0x0
#define AZALIA_CRC0_CONTROL1__CRC_BLOCK_SIZE_MASK                                                             0xFFFFFFFFL
//AZALIA_CRC0_CONTROL2
#define AZALIA_CRC0_CONTROL2__CRC_BLOCK_ITERATION__SHIFT                                                      0x0
#define AZALIA_CRC0_CONTROL2__CRC_BLOCK_ITERATION_MASK                                                        0x0000FFFFL
//AZALIA_CRC0_CONTROL3
#define AZALIA_CRC0_CONTROL3__CRC_COMPLETE__SHIFT                                                             0x0
#define AZALIA_CRC0_CONTROL3__CRC_BLOCK_COMPLETE_PHASE__SHIFT                                                 0x4
#define AZALIA_CRC0_CONTROL3__CRC_CHANNEL_RESULT_SEL__SHIFT                                                   0x8
#define AZALIA_CRC0_CONTROL3__CRC_COMPLETE_MASK                                                               0x00000001L
#define AZALIA_CRC0_CONTROL3__CRC_BLOCK_COMPLETE_PHASE_MASK                                                   0x00000010L
#define AZALIA_CRC0_CONTROL3__CRC_CHANNEL_RESULT_SEL_MASK                                                     0x00000700L
//AZALIA_CRC0_RESULT
#define AZALIA_CRC0_RESULT__CRC_RESULT__SHIFT                                                                 0x0
#define AZALIA_CRC0_RESULT__CRC_RESULT_MASK                                                                   0xFFFFFFFFL
//AZALIA_CRC1_CONTROL0
#define AZALIA_CRC1_CONTROL0__CRC_EN__SHIFT                                                                   0x0
#define AZALIA_CRC1_CONTROL0__CRC_BLOCK_MODE__SHIFT                                                           0x4
#define AZALIA_CRC1_CONTROL0__CRC_INSTANCE_SEL__SHIFT                                                         0x8
#define AZALIA_CRC1_CONTROL0__CRC_SOURCE_SEL__SHIFT                                                           0xc
#define AZALIA_CRC1_CONTROL0__CRC_EN_MASK                                                                     0x00000001L
#define AZALIA_CRC1_CONTROL0__CRC_BLOCK_MODE_MASK                                                             0x00000010L
#define AZALIA_CRC1_CONTROL0__CRC_INSTANCE_SEL_MASK                                                           0x00000700L
#define AZALIA_CRC1_CONTROL0__CRC_SOURCE_SEL_MASK                                                             0x00001000L
//AZALIA_CRC1_CONTROL1
#define AZALIA_CRC1_CONTROL1__CRC_BLOCK_SIZE__SHIFT                                                           0x0
#define AZALIA_CRC1_CONTROL1__CRC_BLOCK_SIZE_MASK                                                             0xFFFFFFFFL
//AZALIA_CRC1_CONTROL2
#define AZALIA_CRC1_CONTROL2__CRC_BLOCK_ITERATION__SHIFT                                                      0x0
#define AZALIA_CRC1_CONTROL2__CRC_BLOCK_ITERATION_MASK                                                        0x0000FFFFL
//AZALIA_CRC1_CONTROL3
#define AZALIA_CRC1_CONTROL3__CRC_COMPLETE__SHIFT                                                             0x0
#define AZALIA_CRC1_CONTROL3__CRC_BLOCK_COMPLETE_PHASE__SHIFT                                                 0x4
#define AZALIA_CRC1_CONTROL3__CRC_CHANNEL_RESULT_SEL__SHIFT                                                   0x8
#define AZALIA_CRC1_CONTROL3__CRC_COMPLETE_MASK                                                               0x00000001L
#define AZALIA_CRC1_CONTROL3__CRC_BLOCK_COMPLETE_PHASE_MASK                                                   0x00000010L
#define AZALIA_CRC1_CONTROL3__CRC_CHANNEL_RESULT_SEL_MASK                                                     0x00000700L
//AZALIA_CRC1_RESULT
#define AZALIA_CRC1_RESULT__CRC_RESULT__SHIFT                                                                 0x0
#define AZALIA_CRC1_RESULT__CRC_RESULT_MASK                                                                   0xFFFFFFFFL
//AZALIA_MEM_PWR_CTRL
#define AZALIA_MEM_PWR_CTRL__AZ_MEM_PWR_FORCE__SHIFT                                                          0x0
#define AZALIA_MEM_PWR_CTRL__AZ_MEM_PWR_DIS__SHIFT                                                            0x2
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM0_MEM_PWR_FORCE__SHIFT                                            0x3
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM0_MEM_PWR_DIS__SHIFT                                              0x5
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM1_MEM_PWR_FORCE__SHIFT                                            0x6
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM1_MEM_PWR_DIS__SHIFT                                              0x8
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM2_MEM_PWR_FORCE__SHIFT                                            0x9
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM2_MEM_PWR_DIS__SHIFT                                              0xb
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM3_MEM_PWR_FORCE__SHIFT                                            0xc
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM3_MEM_PWR_DIS__SHIFT                                              0xe
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM4_MEM_PWR_FORCE__SHIFT                                            0xf
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM4_MEM_PWR_DIS__SHIFT                                              0x11
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM5_MEM_PWR_FORCE__SHIFT                                            0x12
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM5_MEM_PWR_DIS__SHIFT                                              0x14
#define AZALIA_MEM_PWR_CTRL__AZ_MEM_PWR_MODE_SEL__SHIFT                                                       0x1c
#define AZALIA_MEM_PWR_CTRL__AZ_MEM_PWR_FORCE_MASK                                                            0x00000003L
#define AZALIA_MEM_PWR_CTRL__AZ_MEM_PWR_DIS_MASK                                                              0x00000004L
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM0_MEM_PWR_FORCE_MASK                                              0x00000018L
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM0_MEM_PWR_DIS_MASK                                                0x00000020L
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM1_MEM_PWR_FORCE_MASK                                              0x000000C0L
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM1_MEM_PWR_DIS_MASK                                                0x00000100L
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM2_MEM_PWR_FORCE_MASK                                              0x00000600L
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM2_MEM_PWR_DIS_MASK                                                0x00000800L
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM3_MEM_PWR_FORCE_MASK                                              0x00003000L
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM3_MEM_PWR_DIS_MASK                                                0x00004000L
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM4_MEM_PWR_FORCE_MASK                                              0x00018000L
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM4_MEM_PWR_DIS_MASK                                                0x00020000L
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM5_MEM_PWR_FORCE_MASK                                              0x000C0000L
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM5_MEM_PWR_DIS_MASK                                                0x00100000L
#define AZALIA_MEM_PWR_CTRL__AZ_MEM_PWR_MODE_SEL_MASK                                                         0x30000000L
//AZALIA_MEM_PWR_STATUS
#define AZALIA_MEM_PWR_STATUS__AZ_MEM_PWR_STATE__SHIFT                                                        0x0
#define AZALIA_MEM_PWR_STATUS__AZ_INPUT_STREAM0_MEM_PWR_STATE__SHIFT                                          0x2
#define AZALIA_MEM_PWR_STATUS__AZ_INPUT_STREAM1_MEM_PWR_STATE__SHIFT                                          0x4
#define AZALIA_MEM_PWR_STATUS__AZ_INPUT_STREAM2_MEM_PWR_STATE__SHIFT                                          0x6
#define AZALIA_MEM_PWR_STATUS__AZ_INPUT_STREAM3_MEM_PWR_STATE__SHIFT                                          0x8
#define AZALIA_MEM_PWR_STATUS__AZ_INPUT_STREAM4_MEM_PWR_STATE__SHIFT                                          0xa
#define AZALIA_MEM_PWR_STATUS__AZ_INPUT_STREAM5_MEM_PWR_STATE__SHIFT                                          0xc
#define AZALIA_MEM_PWR_STATUS__AZ_MEM_PWR_STATE_MASK                                                          0x00000003L
#define AZALIA_MEM_PWR_STATUS__AZ_INPUT_STREAM0_MEM_PWR_STATE_MASK                                            0x0000000CL
#define AZALIA_MEM_PWR_STATUS__AZ_INPUT_STREAM1_MEM_PWR_STATE_MASK                                            0x00000030L
#define AZALIA_MEM_PWR_STATUS__AZ_INPUT_STREAM2_MEM_PWR_STATE_MASK                                            0x000000C0L
#define AZALIA_MEM_PWR_STATUS__AZ_INPUT_STREAM3_MEM_PWR_STATE_MASK                                            0x00000300L
#define AZALIA_MEM_PWR_STATUS__AZ_INPUT_STREAM4_MEM_PWR_STATE_MASK                                            0x00000C00L
#define AZALIA_MEM_PWR_STATUS__AZ_INPUT_STREAM5_MEM_PWR_STATE_MASK                                            0x00003000L


// addressBlock: dce_dc_hda_azf0root_dispdec
//AZALIA_F0_CODEC_ROOT_PARAMETER_VENDOR_AND_DEVICE_ID
#define AZALIA_F0_CODEC_ROOT_PARAMETER_VENDOR_AND_DEVICE_ID__AZALIA_CODEC_ROOT_PARAMETER_VENDOR_AND_DEVICE_ID__SHIFT  0x0
#define AZALIA_F0_CODEC_ROOT_PARAMETER_VENDOR_AND_DEVICE_ID__AZALIA_CODEC_ROOT_PARAMETER_VENDOR_AND_DEVICE_ID_MASK  0xFFFFFFFFL
//AZALIA_F0_CODEC_ROOT_PARAMETER_REVISION_ID
#define AZALIA_F0_CODEC_ROOT_PARAMETER_REVISION_ID__AZALIA_CODEC_ROOT_PARAMETER_REVISION_ID__SHIFT            0x0
#define AZALIA_F0_CODEC_ROOT_PARAMETER_REVISION_ID__AZALIA_CODEC_ROOT_PARAMETER_REVISION_ID_MASK              0xFFFFFFFFL
//AZALIA_F0_CODEC_CHANNEL_COUNT_CONTROL
#define AZALIA_F0_CODEC_CHANNEL_COUNT_CONTROL__HBR_CHANNEL_COUNT__SHIFT                                       0x0
#define AZALIA_F0_CODEC_CHANNEL_COUNT_CONTROL__COMPRESSED_CHANNEL_COUNT__SHIFT                                0x4
#define AZALIA_F0_CODEC_CHANNEL_COUNT_CONTROL__HBR_CHANNEL_COUNT_MASK                                         0x00000007L
#define AZALIA_F0_CODEC_CHANNEL_COUNT_CONTROL__COMPRESSED_CHANNEL_COUNT_MASK                                  0x00000070L
//AZALIA_F0_CODEC_RESYNC_FIFO_CONTROL
#define AZALIA_F0_CODEC_RESYNC_FIFO_CONTROL__RESYNC_FIFO_STARTUP_KEEPOUT_WINDOW__SHIFT                        0x0
#define AZALIA_F0_CODEC_RESYNC_FIFO_CONTROL__RESYNC_FIFO_STARTUP_KEEPOUT_WINDOW_MASK                          0x0000003FL
//AZALIA_F0_CODEC_FUNCTION_PARAMETER_GROUP_TYPE
#define AZALIA_F0_CODEC_FUNCTION_PARAMETER_GROUP_TYPE__AZALIA_CODEC_FUNCTION_PARAMETER_GROUP_TYPE__SHIFT      0x0
#define AZALIA_F0_CODEC_FUNCTION_PARAMETER_GROUP_TYPE__AZALIA_CODEC_FUNCTION_PARAMETER_GROUP_TYPE_MASK        0xFFFFFFFFL
//AZALIA_F0_CODEC_FUNCTION_PARAMETER_SUPPORTED_SIZE_RATES
#define AZALIA_F0_CODEC_FUNCTION_PARAMETER_SUPPORTED_SIZE_RATES__AUDIO_RATE_CAPABILITIES__SHIFT               0x0
#define AZALIA_F0_CODEC_FUNCTION_PARAMETER_SUPPORTED_SIZE_RATES__AUDIO_BIT_CAPABILITIES__SHIFT                0x10
#define AZALIA_F0_CODEC_FUNCTION_PARAMETER_SUPPORTED_SIZE_RATES__AUDIO_RATE_CAPABILITIES_MASK                 0x00000FFFL
#define AZALIA_F0_CODEC_FUNCTION_PARAMETER_SUPPORTED_SIZE_RATES__AUDIO_BIT_CAPABILITIES_MASK                  0x001F0000L
//AZALIA_F0_CODEC_FUNCTION_PARAMETER_STREAM_FORMATS
#define AZALIA_F0_CODEC_FUNCTION_PARAMETER_STREAM_FORMATS__AZALIA_CODEC_FUNCTION_PARAMETER_STREAM_FORMATS__SHIFT  0x0
#define AZALIA_F0_CODEC_FUNCTION_PARAMETER_STREAM_FORMATS__AZALIA_CODEC_FUNCTION_PARAMETER_STREAM_FORMATS_MASK  0xFFFFFFFFL
//AZALIA_F0_CODEC_FUNCTION_PARAMETER_POWER_STATES
#define AZALIA_F0_CODEC_FUNCTION_PARAMETER_POWER_STATES__AZALIA_CODEC_FUNCTION_PARAMETER_POWER_STATES__SHIFT  0x0
#define AZALIA_F0_CODEC_FUNCTION_PARAMETER_POWER_STATES__CLKSTOP__SHIFT                                       0x1e
#define AZALIA_F0_CODEC_FUNCTION_PARAMETER_POWER_STATES__EPSS__SHIFT                                          0x1f
#define AZALIA_F0_CODEC_FUNCTION_PARAMETER_POWER_STATES__AZALIA_CODEC_FUNCTION_PARAMETER_POWER_STATES_MASK    0x3FFFFFFFL
#define AZALIA_F0_CODEC_FUNCTION_PARAMETER_POWER_STATES__CLKSTOP_MASK                                         0x40000000L
#define AZALIA_F0_CODEC_FUNCTION_PARAMETER_POWER_STATES__EPSS_MASK                                            0x80000000L
//AZALIA_F0_CODEC_FUNCTION_CONTROL_POWER_STATE
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_POWER_STATE__POWER_STATE_SET__SHIFT                                  0x0
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_POWER_STATE__POWER_STATE_ACT__SHIFT                                  0x4
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_POWER_STATE__CLKSTOPOK__SHIFT                                        0x9
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_POWER_STATE__POWER_STATE_SETTINGS_RESET__SHIFT                       0xa
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_POWER_STATE__POWER_STATE_SET_MASK                                    0x0000000FL
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_POWER_STATE__POWER_STATE_ACT_MASK                                    0x000000F0L
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_POWER_STATE__CLKSTOPOK_MASK                                          0x00000200L
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_POWER_STATE__POWER_STATE_SETTINGS_RESET_MASK                         0x00000400L
//AZALIA_F0_CODEC_FUNCTION_CONTROL_RESET
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_RESET__CODEC_RESET__SHIFT                                            0x0
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_RESET__CODEC_RESET_MASK                                              0x00000001L
//AZALIA_F0_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID__SUBSYSTEM_ID_BYTE0__SHIFT                     0x0
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID__SUBSYSTEM_ID_BYTE1__SHIFT                     0x8
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID__SUBSYSTEM_ID_BYTE2__SHIFT                     0x10
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID__SUBSYSTEM_ID_BYTE3__SHIFT                     0x18
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID__SUBSYSTEM_ID_BYTE0_MASK                       0x000000FFL
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID__SUBSYSTEM_ID_BYTE1_MASK                       0x0000FF00L
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID__SUBSYSTEM_ID_BYTE2_MASK                       0x00FF0000L
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID__SUBSYSTEM_ID_BYTE3_MASK                       0xFF000000L
//AZALIA_F0_CODEC_FUNCTION_CONTROL_CONVERTER_SYNCHRONIZATION
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_CONVERTER_SYNCHRONIZATION__CONVERTER_SYNCHRONIZATION__SHIFT          0x0
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_CONVERTER_SYNCHRONIZATION__CONVERTER_SYNCHRONIZATION_MASK            0x000000FFL
//CC_RCU_DC_AUDIO_PORT_CONNECTIVITY
#define CC_RCU_DC_AUDIO_PORT_CONNECTIVITY__PORT_CONNECTIVITY__SHIFT                                           0x0
#define CC_RCU_DC_AUDIO_PORT_CONNECTIVITY__PORT_CONNECTIVITY_OVERRIDE_ENABLE__SHIFT                           0x4
#define CC_RCU_DC_AUDIO_PORT_CONNECTIVITY__PORT_CONNECTIVITY_MASK                                             0x00000007L
#define CC_RCU_DC_AUDIO_PORT_CONNECTIVITY__PORT_CONNECTIVITY_OVERRIDE_ENABLE_MASK                             0x00000010L
//CC_RCU_DC_AUDIO_INPUT_PORT_CONNECTIVITY
#define CC_RCU_DC_AUDIO_INPUT_PORT_CONNECTIVITY__INPUT_PORT_CONNECTIVITY__SHIFT                               0x0
#define CC_RCU_DC_AUDIO_INPUT_PORT_CONNECTIVITY__INPUT_PORT_CONNECTIVITY_OVERRIDE_ENABLE__SHIFT               0x4
#define CC_RCU_DC_AUDIO_INPUT_PORT_CONNECTIVITY__INPUT_PORT_CONNECTIVITY_MASK                                 0x00000007L
#define CC_RCU_DC_AUDIO_INPUT_PORT_CONNECTIVITY__INPUT_PORT_CONNECTIVITY_OVERRIDE_ENABLE_MASK                 0x00000010L
//AZALIA_F0_GTC_GROUP_OFFSET0
#define AZALIA_F0_GTC_GROUP_OFFSET0__GTC_GROUP_OFFSET0__SHIFT                                                 0x0
#define AZALIA_F0_GTC_GROUP_OFFSET0__GTC_GROUP_OFFSET0_MASK                                                   0xFFFFFFFFL
//AZALIA_F0_GTC_GROUP_OFFSET1
#define AZALIA_F0_GTC_GROUP_OFFSET1__GTC_GROUP_OFFSET1__SHIFT                                                 0x0
#define AZALIA_F0_GTC_GROUP_OFFSET1__GTC_GROUP_OFFSET1_MASK                                                   0xFFFFFFFFL
//AZALIA_F0_GTC_GROUP_OFFSET2
#define AZALIA_F0_GTC_GROUP_OFFSET2__GTC_GROUP_OFFSET2__SHIFT                                                 0x0
#define AZALIA_F0_GTC_GROUP_OFFSET2__GTC_GROUP_OFFSET2_MASK                                                   0xFFFFFFFFL
//AZALIA_F0_GTC_GROUP_OFFSET3
#define AZALIA_F0_GTC_GROUP_OFFSET3__GTC_GROUP_OFFSET3__SHIFT                                                 0x0
#define AZALIA_F0_GTC_GROUP_OFFSET3__GTC_GROUP_OFFSET3_MASK                                                   0xFFFFFFFFL
//AZALIA_F0_GTC_GROUP_OFFSET4
#define AZALIA_F0_GTC_GROUP_OFFSET4__GTC_GROUP_OFFSET4__SHIFT                                                 0x0
#define AZALIA_F0_GTC_GROUP_OFFSET4__GTC_GROUP_OFFSET4_MASK                                                   0xFFFFFFFFL
//AZALIA_F0_GTC_GROUP_OFFSET5
#define AZALIA_F0_GTC_GROUP_OFFSET5__GTC_GROUP_OFFSET5__SHIFT                                                 0x0
#define AZALIA_F0_GTC_GROUP_OFFSET5__GTC_GROUP_OFFSET5_MASK                                                   0xFFFFFFFFL
//AZALIA_F0_GTC_GROUP_OFFSET6
#define AZALIA_F0_GTC_GROUP_OFFSET6__GTC_GROUP_OFFSET6__SHIFT                                                 0x0
#define AZALIA_F0_GTC_GROUP_OFFSET6__GTC_GROUP_OFFSET6_MASK                                                   0xFFFFFFFFL
//REG_DC_AUDIO_PORT_CONNECTIVITY
#define REG_DC_AUDIO_PORT_CONNECTIVITY__REG_PORT_CONNECTIVITY__SHIFT                                          0x0
#define REG_DC_AUDIO_PORT_CONNECTIVITY__REG_PORT_CONNECTIVITY_OVERRIDE_ENABLE__SHIFT                          0x4
#define REG_DC_AUDIO_PORT_CONNECTIVITY__REG_PORT_CONNECTIVITY_MASK                                            0x00000007L
#define REG_DC_AUDIO_PORT_CONNECTIVITY__REG_PORT_CONNECTIVITY_OVERRIDE_ENABLE_MASK                            0x00000010L
//REG_DC_AUDIO_INPUT_PORT_CONNECTIVITY
#define REG_DC_AUDIO_INPUT_PORT_CONNECTIVITY__REG_INPUT_PORT_CONNECTIVITY__SHIFT                              0x0
#define REG_DC_AUDIO_INPUT_PORT_CONNECTIVITY__REG_INPUT_PORT_CONNECTIVITY_OVERRIDE_ENABLE__SHIFT              0x4
#define REG_DC_AUDIO_INPUT_PORT_CONNECTIVITY__REG_INPUT_PORT_CONNECTIVITY_MASK                                0x00000007L
#define REG_DC_AUDIO_INPUT_PORT_CONNECTIVITY__REG_INPUT_PORT_CONNECTIVITY_OVERRIDE_ENABLE_MASK                0x00000010L


// addressBlock: dce_dc_hda_azf0stream8_dispdec
//AZF0STREAM8_AZALIA_STREAM_INDEX
#define AZF0STREAM8_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_INDEX__SHIFT                                       0x0
#define AZF0STREAM8_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_WRITE_EN__SHIFT                                    0x8
#define AZF0STREAM8_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_INDEX_MASK                                         0x000000FFL
#define AZF0STREAM8_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_WRITE_EN_MASK                                      0x00000100L
//AZF0STREAM8_AZALIA_STREAM_DATA
#define AZF0STREAM8_AZALIA_STREAM_DATA__AZALIA_STREAM_REG_DATA__SHIFT                                         0x0
#define AZF0STREAM8_AZALIA_STREAM_DATA__AZALIA_STREAM_REG_DATA_MASK                                           0xFFFFFFFFL


// addressBlock: dce_dc_hda_azf0stream9_dispdec
//AZF0STREAM9_AZALIA_STREAM_INDEX
#define AZF0STREAM9_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_INDEX__SHIFT                                       0x0
#define AZF0STREAM9_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_WRITE_EN__SHIFT                                    0x8
#define AZF0STREAM9_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_INDEX_MASK                                         0x000000FFL
#define AZF0STREAM9_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_WRITE_EN_MASK                                      0x00000100L
//AZF0STREAM9_AZALIA_STREAM_DATA
#define AZF0STREAM9_AZALIA_STREAM_DATA__AZALIA_STREAM_REG_DATA__SHIFT                                         0x0
#define AZF0STREAM9_AZALIA_STREAM_DATA__AZALIA_STREAM_REG_DATA_MASK                                           0xFFFFFFFFL


// addressBlock: dce_dc_hda_azf0stream10_dispdec
//AZF0STREAM10_AZALIA_STREAM_INDEX
#define AZF0STREAM10_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_INDEX__SHIFT                                      0x0
#define AZF0STREAM10_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_WRITE_EN__SHIFT                                   0x8
#define AZF0STREAM10_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_INDEX_MASK                                        0x000000FFL
#define AZF0STREAM10_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_WRITE_EN_MASK                                     0x00000100L
//AZF0STREAM10_AZALIA_STREAM_DATA
#define AZF0STREAM10_AZALIA_STREAM_DATA__AZALIA_STREAM_REG_DATA__SHIFT                                        0x0
#define AZF0STREAM10_AZALIA_STREAM_DATA__AZALIA_STREAM_REG_DATA_MASK                                          0xFFFFFFFFL


// addressBlock: dce_dc_hda_azf0stream11_dispdec
//AZF0STREAM11_AZALIA_STREAM_INDEX
#define AZF0STREAM11_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_INDEX__SHIFT                                      0x0
#define AZF0STREAM11_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_WRITE_EN__SHIFT                                   0x8
#define AZF0STREAM11_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_INDEX_MASK                                        0x000000FFL
#define AZF0STREAM11_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_WRITE_EN_MASK                                     0x00000100L
//AZF0STREAM11_AZALIA_STREAM_DATA
#define AZF0STREAM11_AZALIA_STREAM_DATA__AZALIA_STREAM_REG_DATA__SHIFT                                        0x0
#define AZF0STREAM11_AZALIA_STREAM_DATA__AZALIA_STREAM_REG_DATA_MASK                                          0xFFFFFFFFL


// addressBlock: dce_dc_hda_azf0stream12_dispdec
//AZF0STREAM12_AZALIA_STREAM_INDEX
#define AZF0STREAM12_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_INDEX__SHIFT                                      0x0
#define AZF0STREAM12_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_WRITE_EN__SHIFT                                   0x8
#define AZF0STREAM12_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_INDEX_MASK                                        0x000000FFL
#define AZF0STREAM12_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_WRITE_EN_MASK                                     0x00000100L
//AZF0STREAM12_AZALIA_STREAM_DATA
#define AZF0STREAM12_AZALIA_STREAM_DATA__AZALIA_STREAM_REG_DATA__SHIFT                                        0x0
#define AZF0STREAM12_AZALIA_STREAM_DATA__AZALIA_STREAM_REG_DATA_MASK                                          0xFFFFFFFFL


// addressBlock: dce_dc_hda_azf0stream13_dispdec
//AZF0STREAM13_AZALIA_STREAM_INDEX
#define AZF0STREAM13_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_INDEX__SHIFT                                      0x0
#define AZF0STREAM13_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_WRITE_EN__SHIFT                                   0x8
#define AZF0STREAM13_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_INDEX_MASK                                        0x000000FFL
#define AZF0STREAM13_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_WRITE_EN_MASK                                     0x00000100L
//AZF0STREAM13_AZALIA_STREAM_DATA
#define AZF0STREAM13_AZALIA_STREAM_DATA__AZALIA_STREAM_REG_DATA__SHIFT                                        0x0
#define AZF0STREAM13_AZALIA_STREAM_DATA__AZALIA_STREAM_REG_DATA_MASK                                          0xFFFFFFFFL


// addressBlock: dce_dc_hda_azf0stream14_dispdec
//AZF0STREAM14_AZALIA_STREAM_INDEX
#define AZF0STREAM14_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_INDEX__SHIFT                                      0x0
#define AZF0STREAM14_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_WRITE_EN__SHIFT                                   0x8
#define AZF0STREAM14_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_INDEX_MASK                                        0x000000FFL
#define AZF0STREAM14_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_WRITE_EN_MASK                                     0x00000100L
//AZF0STREAM14_AZALIA_STREAM_DATA
#define AZF0STREAM14_AZALIA_STREAM_DATA__AZALIA_STREAM_REG_DATA__SHIFT                                        0x0
#define AZF0STREAM14_AZALIA_STREAM_DATA__AZALIA_STREAM_REG_DATA_MASK                                          0xFFFFFFFFL


// addressBlock: dce_dc_hda_azf0stream15_dispdec
//AZF0STREAM15_AZALIA_STREAM_INDEX
#define AZF0STREAM15_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_INDEX__SHIFT                                      0x0
#define AZF0STREAM15_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_WRITE_EN__SHIFT                                   0x8
#define AZF0STREAM15_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_INDEX_MASK                                        0x000000FFL
#define AZF0STREAM15_AZALIA_STREAM_INDEX__AZALIA_STREAM_REG_WRITE_EN_MASK                                     0x00000100L
//AZF0STREAM15_AZALIA_STREAM_DATA
#define AZF0STREAM15_AZALIA_STREAM_DATA__AZALIA_STREAM_REG_DATA__SHIFT                                        0x0
#define AZF0STREAM15_AZALIA_STREAM_DATA__AZALIA_STREAM_REG_DATA_MASK                                          0xFFFFFFFFL


// addressBlock: dce_dc_hda_azf0inputendpoint0_dispdec
//AZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX
#define AZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX__AZALIA_INPUT_ENDPOINT_REG_INDEX__SHIFT       0x0
#define AZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX__AZALIA_INPUT_ENDPOINT_REG_INDEX_MASK         0x00003FFFL
//AZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA
#define AZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA__AZALIA_INPUT_ENDPOINT_REG_DATA__SHIFT         0x0
#define AZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA__AZALIA_INPUT_ENDPOINT_REG_DATA_MASK           0xFFFFFFFFL


// addressBlock: dce_dc_hda_azf0inputendpoint1_dispdec
//AZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX
#define AZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX__AZALIA_INPUT_ENDPOINT_REG_INDEX__SHIFT       0x0
#define AZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX__AZALIA_INPUT_ENDPOINT_REG_INDEX_MASK         0x00003FFFL
//AZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA
#define AZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA__AZALIA_INPUT_ENDPOINT_REG_DATA__SHIFT         0x0
#define AZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA__AZALIA_INPUT_ENDPOINT_REG_DATA_MASK           0xFFFFFFFFL


// addressBlock: dce_dc_hda_azf0inputendpoint2_dispdec
//AZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX
#define AZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX__AZALIA_INPUT_ENDPOINT_REG_INDEX__SHIFT       0x0
#define AZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX__AZALIA_INPUT_ENDPOINT_REG_INDEX_MASK         0x00003FFFL
//AZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA
#define AZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA__AZALIA_INPUT_ENDPOINT_REG_DATA__SHIFT         0x0
#define AZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA__AZALIA_INPUT_ENDPOINT_REG_DATA_MASK           0xFFFFFFFFL


// addressBlock: dce_dc_hda_azf0inputendpoint3_dispdec
//AZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX
#define AZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX__AZALIA_INPUT_ENDPOINT_REG_INDEX__SHIFT       0x0
#define AZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX__AZALIA_INPUT_ENDPOINT_REG_INDEX_MASK         0x00003FFFL
//AZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA
#define AZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA__AZALIA_INPUT_ENDPOINT_REG_DATA__SHIFT         0x0
#define AZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA__AZALIA_INPUT_ENDPOINT_REG_DATA_MASK           0xFFFFFFFFL


// addressBlock: dce_dc_hda_azf0inputendpoint4_dispdec
//AZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX
#define AZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX__AZALIA_INPUT_ENDPOINT_REG_INDEX__SHIFT       0x0
#define AZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX__AZALIA_INPUT_ENDPOINT_REG_INDEX_MASK         0x00003FFFL
//AZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA
#define AZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA__AZALIA_INPUT_ENDPOINT_REG_DATA__SHIFT         0x0
#define AZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA__AZALIA_INPUT_ENDPOINT_REG_DATA_MASK           0xFFFFFFFFL


// addressBlock: dce_dc_hda_azf0inputendpoint5_dispdec
//AZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX
#define AZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX__AZALIA_INPUT_ENDPOINT_REG_INDEX__SHIFT       0x0
#define AZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX__AZALIA_INPUT_ENDPOINT_REG_INDEX_MASK         0x00003FFFL
//AZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA
#define AZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA__AZALIA_INPUT_ENDPOINT_REG_DATA__SHIFT         0x0
#define AZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA__AZALIA_INPUT_ENDPOINT_REG_DATA_MASK           0xFFFFFFFFL


// addressBlock: dce_dc_hda_azf0inputendpoint6_dispdec
//AZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX
#define AZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX__AZALIA_INPUT_ENDPOINT_REG_INDEX__SHIFT       0x0
#define AZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX__AZALIA_INPUT_ENDPOINT_REG_INDEX_MASK         0x00003FFFL
//AZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA
#define AZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA__AZALIA_INPUT_ENDPOINT_REG_DATA__SHIFT         0x0
#define AZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA__AZALIA_INPUT_ENDPOINT_REG_DATA_MASK           0xFFFFFFFFL


// addressBlock: dce_dc_hda_azf0inputendpoint7_dispdec
//AZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX
#define AZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX__AZALIA_INPUT_ENDPOINT_REG_INDEX__SHIFT       0x0
#define AZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX__AZALIA_INPUT_ENDPOINT_REG_INDEX_MASK         0x00003FFFL
//AZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA
#define AZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA__AZALIA_INPUT_ENDPOINT_REG_DATA__SHIFT         0x0
#define AZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA__AZALIA_INPUT_ENDPOINT_REG_DATA_MASK           0xFFFFFFFFL


// addressBlock: dce_dc_dchubbub_hubbub_sdpif_dispdec
//DCHUBBUB_SDPIF_CFG0
#define DCHUBBUB_SDPIF_CFG0__SDPIF_NO_OUTSTANDING_REQ__SHIFT                                                  0x0
#define DCHUBBUB_SDPIF_CFG0__SDPIF_PORT_STATUS__SHIFT                                                         0x1
#define DCHUBBUB_SDPIF_CFG0__SDPIF_DATA_RESPONSE_STATUS__SHIFT                                                0x3
#define DCHUBBUB_SDPIF_CFG0__SDPIF_REQ_CREDIT_ERROR__SHIFT                                                    0x6
#define DCHUBBUB_SDPIF_CFG0__SDPIF_DATA_RESPONSE_STATUS_CLEAR__SHIFT                                          0x7
#define DCHUBBUB_SDPIF_CFG0__SDPIF_REQ_CREDIT_ERROR_CLEAR__SHIFT                                              0x8
#define DCHUBBUB_SDPIF_CFG0__SDPIF_FLUSH_REQ_CREDIT_EN__SHIFT                                                 0x9
#define DCHUBBUB_SDPIF_CFG0__SDPIF_REQ_CREDIT_EN__SHIFT                                                       0xa
#define DCHUBBUB_SDPIF_CFG0__SDPIF_PORT_CONTROL__SHIFT                                                        0xb
#define DCHUBBUB_SDPIF_CFG0__SDPIF_UNIT_ID_BITMASK__SHIFT                                                     0xc
#define DCHUBBUB_SDPIF_CFG0__SDPIF_CREDIT_DISCONNECT_DELAY__SHIFT                                             0x14
#define DCHUBBUB_SDPIF_CFG0__SDPIF_NO_OUTSTANDING_REQ_MASK                                                    0x00000001L
#define DCHUBBUB_SDPIF_CFG0__SDPIF_PORT_STATUS_MASK                                                           0x00000006L
#define DCHUBBUB_SDPIF_CFG0__SDPIF_DATA_RESPONSE_STATUS_MASK                                                  0x00000038L
#define DCHUBBUB_SDPIF_CFG0__SDPIF_REQ_CREDIT_ERROR_MASK                                                      0x00000040L
#define DCHUBBUB_SDPIF_CFG0__SDPIF_DATA_RESPONSE_STATUS_CLEAR_MASK                                            0x00000080L
#define DCHUBBUB_SDPIF_CFG0__SDPIF_REQ_CREDIT_ERROR_CLEAR_MASK                                                0x00000100L
#define DCHUBBUB_SDPIF_CFG0__SDPIF_FLUSH_REQ_CREDIT_EN_MASK                                                   0x00000200L
#define DCHUBBUB_SDPIF_CFG0__SDPIF_REQ_CREDIT_EN_MASK                                                         0x00000400L
#define DCHUBBUB_SDPIF_CFG0__SDPIF_PORT_CONTROL_MASK                                                          0x00000800L
#define DCHUBBUB_SDPIF_CFG0__SDPIF_UNIT_ID_BITMASK_MASK                                                       0x000FF000L
#define DCHUBBUB_SDPIF_CFG0__SDPIF_CREDIT_DISCONNECT_DELAY_MASK                                               0x03F00000L
//DCHUBBUB_SDPIF_CFG1
#define DCHUBBUB_SDPIF_CFG1__SDPIF_INSIDE_FB_IO__SHIFT                                                        0x0
#define DCHUBBUB_SDPIF_CFG1__SDPIF_INSIDE_FB_VC__SHIFT                                                        0x1
#define DCHUBBUB_SDPIF_CFG1__SDPIF_OUTSIDE_FB_IO__SHIFT                                                       0x4
#define DCHUBBUB_SDPIF_CFG1__SDPIF_OUTSIDE_FB_VC__SHIFT                                                       0x5
#define DCHUBBUB_SDPIF_CFG1__SDPIF_INSIDE_FB_IO_MASK                                                          0x00000001L
#define DCHUBBUB_SDPIF_CFG1__SDPIF_INSIDE_FB_VC_MASK                                                          0x0000000EL
#define DCHUBBUB_SDPIF_CFG1__SDPIF_OUTSIDE_FB_IO_MASK                                                         0x00000010L
#define DCHUBBUB_SDPIF_CFG1__SDPIF_OUTSIDE_FB_VC_MASK                                                         0x000000E0L
//DCHUBBUB_FORCE_IO_STATUS_0
#define DCHUBBUB_FORCE_IO_STATUS_0__SDPIF_FORCE_IO_STATUS__SHIFT                                              0x0
#define DCHUBBUB_FORCE_IO_STATUS_0__SDPIF_FORCE_IO_STATUS_STICKY__SHIFT                                       0x1
#define DCHUBBUB_FORCE_IO_STATUS_0__SDPIF_FORCE_IO_STATUS_CLEAR__SHIFT                                        0x2
#define DCHUBBUB_FORCE_IO_STATUS_0__SDPIF_FORCE_IO_STATUS_PIPE_ID__SHIFT                                      0x3
#define DCHUBBUB_FORCE_IO_STATUS_0__SDPIF_FORCE_IO_STATUS_REQUEST_TYPE__SHIFT                                 0x7
#define DCHUBBUB_FORCE_IO_STATUS_0__SDPIF_FORCE_IO_STATUS_ADDR_LO__SHIFT                                      0xa
#define DCHUBBUB_FORCE_IO_STATUS_0__SDPIF_FORCE_IO_STATUS_MASK                                                0x00000001L
#define DCHUBBUB_FORCE_IO_STATUS_0__SDPIF_FORCE_IO_STATUS_STICKY_MASK                                         0x00000002L
#define DCHUBBUB_FORCE_IO_STATUS_0__SDPIF_FORCE_IO_STATUS_CLEAR_MASK                                          0x00000004L
#define DCHUBBUB_FORCE_IO_STATUS_0__SDPIF_FORCE_IO_STATUS_PIPE_ID_MASK                                        0x00000078L
#define DCHUBBUB_FORCE_IO_STATUS_0__SDPIF_FORCE_IO_STATUS_REQUEST_TYPE_MASK                                   0x00000380L
#define DCHUBBUB_FORCE_IO_STATUS_0__SDPIF_FORCE_IO_STATUS_ADDR_LO_MASK                                        0xFFFFFC00L
//DCHUBBUB_FORCE_IO_STATUS_1
#define DCHUBBUB_FORCE_IO_STATUS_1__SDPIF_FORCE_IO_STATUS_ADDR_HI__SHIFT                                      0x0
#define DCHUBBUB_FORCE_IO_STATUS_1__SDPIF_FORCE_IO_STATUS_ADDR_HI_MASK                                        0x001FFFFFL
//DCHUBBUB_SDPIF_FB_BASE
#define DCHUBBUB_SDPIF_FB_BASE__SDPIF_FB_BASE__SHIFT                                                          0x0
#define DCHUBBUB_SDPIF_FB_BASE__SDPIF_FB_BASE_MASK                                                            0x00FFFFFFL
//DCHUBBUB_SDPIF_FB_TOP
#define DCHUBBUB_SDPIF_FB_TOP__SDPIF_FB_TOP__SHIFT                                                            0x0
#define DCHUBBUB_SDPIF_FB_TOP__SDPIF_FB_TOP_MASK                                                              0x00FFFFFFL
//DCHUBBUB_SDPIF_FB_OFFSET
#define DCHUBBUB_SDPIF_FB_OFFSET__SDPIF_FB_OFFSET__SHIFT                                                      0x0
#define DCHUBBUB_SDPIF_FB_OFFSET__SDPIF_FB_OFFSET_MASK                                                        0x00FFFFFFL
//DCHUBBUB_SDPIF_AGP_BOT
#define DCHUBBUB_SDPIF_AGP_BOT__SDPIF_AGP_BOT__SHIFT                                                          0x0
#define DCHUBBUB_SDPIF_AGP_BOT__SDPIF_AGP_BOT_MASK                                                            0x03FFFFFFL
//DCHUBBUB_SDPIF_AGP_TOP
#define DCHUBBUB_SDPIF_AGP_TOP__SDPIF_AGP_TOP__SHIFT                                                          0x0
#define DCHUBBUB_SDPIF_AGP_TOP__SDPIF_AGP_TOP_MASK                                                            0x03FFFFFFL
//DCHUBBUB_SDPIF_AGP_BASE
#define DCHUBBUB_SDPIF_AGP_BASE__SDPIF_AGP_BASE__SHIFT                                                        0x0
#define DCHUBBUB_SDPIF_AGP_BASE__SDPIF_AGP_BASE_MASK                                                          0x03FFFFFFL
//DCHUBBUB_SDPIF_APER_BASE
#define DCHUBBUB_SDPIF_APER_BASE__SDPIF_APER_BASE__SHIFT                                                      0x0
#define DCHUBBUB_SDPIF_APER_BASE__SDPIF_LOCK_DRAM_REGS__SHIFT                                                 0x1c
#define DCHUBBUB_SDPIF_APER_BASE__SDPIF_APER_BASE_MASK                                                        0x0FFFFFFFL
#define DCHUBBUB_SDPIF_APER_BASE__SDPIF_LOCK_DRAM_REGS_MASK                                                   0x10000000L
//DCHUBBUB_SDPIF_APER_TOP
#define DCHUBBUB_SDPIF_APER_TOP__SDPIF_APER_TOP__SHIFT                                                        0x0
#define DCHUBBUB_SDPIF_APER_TOP__SDPIF_APER_TOP_MASK                                                          0x0FFFFFFFL
//DCHUBBUB_SDPIF_APER_DEF_0
#define DCHUBBUB_SDPIF_APER_DEF_0__SDPIF_APER_DEF_0__SHIFT                                                    0x0
#define DCHUBBUB_SDPIF_APER_DEF_0__SDPIF_APER_DEF_0_MASK                                                      0xFFFFFFFFL
//DCHUBBUB_SDPIF_APER_DEF_1
#define DCHUBBUB_SDPIF_APER_DEF_1__SDPIF_APER_DEF_1__SHIFT                                                    0x0
#define DCHUBBUB_SDPIF_APER_DEF_1__SDPIF_APER_DEF_1_MASK                                                      0x0000000FL
//DCHUBBUB_SDPIF_MMIO_CNTRL_0
#define DCHUBBUB_SDPIF_MMIO_CNTRL_0__SDPIF_IOMMU_EN__SHIFT                                                    0x0
#define DCHUBBUB_SDPIF_MMIO_CNTRL_0__SDPIF_IOMMU_EN_MASK                                                      0x00000001L
//DCHUBBUB_SDPIF_MMIO_CNTRL_1
#define DCHUBBUB_SDPIF_MMIO_CNTRL_1__SDPIF_MARC_EN__SHIFT                                                     0x8
#define DCHUBBUB_SDPIF_MMIO_CNTRL_1__SDPIF_MARC_EN_MASK                                                       0x00000100L
//DCHUBBUB_SDPIF_MMIO_CNTRL_W
#define DCHUBBUB_SDPIF_MMIO_CNTRL_W__SDPIF_GMC_IOMMU_BYPASS__SHIFT                                            0xd
#define DCHUBBUB_SDPIF_MMIO_CNTRL_W__SDPIF_GMC_IOMMU_BYPASS_MASK                                              0x00002000L
//DCHUBBUB_SDPIF_MARC_BASE_LO_0
#define DCHUBBUB_SDPIF_MARC_BASE_LO_0__SDPIF_MARC_BASE_LO_0__SHIFT                                            0xc
#define DCHUBBUB_SDPIF_MARC_BASE_LO_0__SDPIF_MARC_BASE_LO_0_MASK                                              0xFFFFF000L
//DCHUBBUB_SDPIF_MARC_BASE_HI_0
#define DCHUBBUB_SDPIF_MARC_BASE_HI_0__SDPIF_MARC_BASE_HI_0__SHIFT                                            0x0
#define DCHUBBUB_SDPIF_MARC_BASE_HI_0__SDPIF_MARC_BASE_HI_0_MASK                                              0x0000FFFFL
//DCHUBBUB_SDPIF_MARC_RELOC_LO_0
#define DCHUBBUB_SDPIF_MARC_RELOC_LO_0__SDPIF_MARC_EN_0__SHIFT                                                0x0
#define DCHUBBUB_SDPIF_MARC_RELOC_LO_0__SDPIF_MARC_RELOC_LO_0__SHIFT                                          0xc
#define DCHUBBUB_SDPIF_MARC_RELOC_LO_0__SDPIF_MARC_EN_0_MASK                                                  0x00000001L
#define DCHUBBUB_SDPIF_MARC_RELOC_LO_0__SDPIF_MARC_RELOC_LO_0_MASK                                            0xFFFFF000L
//DCHUBBUB_SDPIF_MARC_RELOC_HI_0
#define DCHUBBUB_SDPIF_MARC_RELOC_HI_0__SDPIF_MARC_RELOC_HI_0__SHIFT                                          0x0
#define DCHUBBUB_SDPIF_MARC_RELOC_HI_0__SDPIF_MARC_RELOC_HI_0_MASK                                            0x0000FFFFL
//DCHUBBUB_SDPIF_MARC_LENGTH_LO_0
#define DCHUBBUB_SDPIF_MARC_LENGTH_LO_0__SDPIF_MARC_LENGTH_LO_0__SHIFT                                        0xc
#define DCHUBBUB_SDPIF_MARC_LENGTH_LO_0__SDPIF_MARC_LENGTH_LO_0_MASK                                          0xFFFFF000L
//DCHUBBUB_SDPIF_MARC_LENGTH_HI_0
#define DCHUBBUB_SDPIF_MARC_LENGTH_HI_0__SDPIF_MARC_LENGTH_HI_0__SHIFT                                        0x0
#define DCHUBBUB_SDPIF_MARC_LENGTH_HI_0__SDPIF_MARC_LENGTH_HI_0_MASK                                          0x0000FFFFL
//DCHUBBUB_SDPIF_MARC_BASE_LO_1
#define DCHUBBUB_SDPIF_MARC_BASE_LO_1__SDPIF_MARC_BASE_LO_1__SHIFT                                            0xc
#define DCHUBBUB_SDPIF_MARC_BASE_LO_1__SDPIF_MARC_BASE_LO_1_MASK                                              0xFFFFF000L
//DCHUBBUB_SDPIF_MARC_BASE_HI_1
#define DCHUBBUB_SDPIF_MARC_BASE_HI_1__SDPIF_MARC_BASE_HI_1__SHIFT                                            0x0
#define DCHUBBUB_SDPIF_MARC_BASE_HI_1__SDPIF_MARC_BASE_HI_1_MASK                                              0x0000FFFFL
//DCHUBBUB_SDPIF_MARC_RELOC_LO_1
#define DCHUBBUB_SDPIF_MARC_RELOC_LO_1__SDPIF_MARC_EN_1__SHIFT                                                0x0
#define DCHUBBUB_SDPIF_MARC_RELOC_LO_1__SDPIF_MARC_RELOC_LO_1__SHIFT                                          0xc
#define DCHUBBUB_SDPIF_MARC_RELOC_LO_1__SDPIF_MARC_EN_1_MASK                                                  0x00000001L
#define DCHUBBUB_SDPIF_MARC_RELOC_LO_1__SDPIF_MARC_RELOC_LO_1_MASK                                            0xFFFFF000L
//DCHUBBUB_SDPIF_MARC_RELOC_HI_1
#define DCHUBBUB_SDPIF_MARC_RELOC_HI_1__SDPIF_MARC_RELOC_HI_1__SHIFT                                          0x0
#define DCHUBBUB_SDPIF_MARC_RELOC_HI_1__SDPIF_MARC_RELOC_HI_1_MASK                                            0x0000FFFFL
//DCHUBBUB_SDPIF_MARC_LENGTH_LO_1
#define DCHUBBUB_SDPIF_MARC_LENGTH_LO_1__SDPIF_MARC_LENGTH_LO_1__SHIFT                                        0xc
#define DCHUBBUB_SDPIF_MARC_LENGTH_LO_1__SDPIF_MARC_LENGTH_LO_1_MASK                                          0xFFFFF000L
//DCHUBBUB_SDPIF_MARC_LENGTH_HI_1
#define DCHUBBUB_SDPIF_MARC_LENGTH_HI_1__SDPIF_MARC_LENGTH_HI_1__SHIFT                                        0x0
#define DCHUBBUB_SDPIF_MARC_LENGTH_HI_1__SDPIF_MARC_LENGTH_HI_1_MASK                                          0x0000FFFFL
//DCHUBBUB_SDPIF_MARC_BASE_LO_2
#define DCHUBBUB_SDPIF_MARC_BASE_LO_2__SDPIF_MARC_BASE_LO_2__SHIFT                                            0xc
#define DCHUBBUB_SDPIF_MARC_BASE_LO_2__SDPIF_MARC_BASE_LO_2_MASK                                              0xFFFFF000L
//DCHUBBUB_SDPIF_MARC_BASE_HI_2
#define DCHUBBUB_SDPIF_MARC_BASE_HI_2__SDPIF_MARC_BASE_HI_2__SHIFT                                            0x0
#define DCHUBBUB_SDPIF_MARC_BASE_HI_2__SDPIF_MARC_BASE_HI_2_MASK                                              0x0000FFFFL
//DCHUBBUB_SDPIF_MARC_RELOC_LO_2
#define DCHUBBUB_SDPIF_MARC_RELOC_LO_2__SDPIF_MARC_EN_2__SHIFT                                                0x0
#define DCHUBBUB_SDPIF_MARC_RELOC_LO_2__SDPIF_MARC_RELOC_LO_2__SHIFT                                          0xc
#define DCHUBBUB_SDPIF_MARC_RELOC_LO_2__SDPIF_MARC_EN_2_MASK                                                  0x00000001L
#define DCHUBBUB_SDPIF_MARC_RELOC_LO_2__SDPIF_MARC_RELOC_LO_2_MASK                                            0xFFFFF000L
//DCHUBBUB_SDPIF_MARC_RELOC_HI_2
#define DCHUBBUB_SDPIF_MARC_RELOC_HI_2__SDPIF_MARC_RELOC_HI_2__SHIFT                                          0x0
#define DCHUBBUB_SDPIF_MARC_RELOC_HI_2__SDPIF_MARC_RELOC_HI_2_MASK                                            0x0000FFFFL
//DCHUBBUB_SDPIF_MARC_LENGTH_LO_2
#define DCHUBBUB_SDPIF_MARC_LENGTH_LO_2__SDPIF_MARC_LENGTH_LO_2__SHIFT                                        0xc
#define DCHUBBUB_SDPIF_MARC_LENGTH_LO_2__SDPIF_MARC_LENGTH_LO_2_MASK                                          0xFFFFF000L
//DCHUBBUB_SDPIF_MARC_LENGTH_HI_2
#define DCHUBBUB_SDPIF_MARC_LENGTH_HI_2__SDPIF_MARC_LENGTH_HI_2__SHIFT                                        0x0
#define DCHUBBUB_SDPIF_MARC_LENGTH_HI_2__SDPIF_MARC_LENGTH_HI_2_MASK                                          0x0000FFFFL
//DCHUBBUB_SDPIF_MARC_BASE_LO_3
#define DCHUBBUB_SDPIF_MARC_BASE_LO_3__SDPIF_MARC_BASE_LO_3__SHIFT                                            0xc
#define DCHUBBUB_SDPIF_MARC_BASE_LO_3__SDPIF_MARC_BASE_LO_3_MASK                                              0xFFFFF000L
//DCHUBBUB_SDPIF_MARC_BASE_HI_3
#define DCHUBBUB_SDPIF_MARC_BASE_HI_3__SDPIF_MARC_BASE_HI_3__SHIFT                                            0x0
#define DCHUBBUB_SDPIF_MARC_BASE_HI_3__SDPIF_MARC_BASE_HI_3_MASK                                              0x0000FFFFL
//DCHUBBUB_SDPIF_MARC_RELOC_LO_3
#define DCHUBBUB_SDPIF_MARC_RELOC_LO_3__SDPIF_MARC_EN_3__SHIFT                                                0x0
#define DCHUBBUB_SDPIF_MARC_RELOC_LO_3__SDPIF_MARC_RELOC_LO_3__SHIFT                                          0xc
#define DCHUBBUB_SDPIF_MARC_RELOC_LO_3__SDPIF_MARC_EN_3_MASK                                                  0x00000001L
#define DCHUBBUB_SDPIF_MARC_RELOC_LO_3__SDPIF_MARC_RELOC_LO_3_MASK                                            0xFFFFF000L
//DCHUBBUB_SDPIF_MARC_RELOC_HI_3
#define DCHUBBUB_SDPIF_MARC_RELOC_HI_3__SDPIF_MARC_RELOC_HI_3__SHIFT                                          0x0
#define DCHUBBUB_SDPIF_MARC_RELOC_HI_3__SDPIF_MARC_RELOC_HI_3_MASK                                            0x0000FFFFL
//DCHUBBUB_SDPIF_MARC_LENGTH_LO_3
#define DCHUBBUB_SDPIF_MARC_LENGTH_LO_3__SDPIF_MARC_LENGTH_LO_3__SHIFT                                        0xc
#define DCHUBBUB_SDPIF_MARC_LENGTH_LO_3__SDPIF_MARC_LENGTH_LO_3_MASK                                          0xFFFFF000L
//DCHUBBUB_SDPIF_MARC_LENGTH_HI_3
#define DCHUBBUB_SDPIF_MARC_LENGTH_HI_3__SDPIF_MARC_LENGTH_HI_3__SHIFT                                        0x0
#define DCHUBBUB_SDPIF_MARC_LENGTH_HI_3__SDPIF_MARC_LENGTH_HI_3_MASK                                          0x0000FFFFL
//DCHUBBUB_SDPIF_PIPE_SEC_LVL
#define DCHUBBUB_SDPIF_PIPE_SEC_LVL__SDPIF_PIPE0_SEC_LVL__SHIFT                                               0x0
#define DCHUBBUB_SDPIF_PIPE_SEC_LVL__SDPIF_PIPE1_SEC_LVL__SHIFT                                               0x3
#define DCHUBBUB_SDPIF_PIPE_SEC_LVL__SDPIF_PIPE2_SEC_LVL__SHIFT                                               0x6
#define DCHUBBUB_SDPIF_PIPE_SEC_LVL__SDPIF_PIPE3_SEC_LVL__SHIFT                                               0x9
#define DCHUBBUB_SDPIF_PIPE_SEC_LVL__SDPIF_PIPE0_SEC_LVL_MASK                                                 0x00000007L
#define DCHUBBUB_SDPIF_PIPE_SEC_LVL__SDPIF_PIPE1_SEC_LVL_MASK                                                 0x00000038L
#define DCHUBBUB_SDPIF_PIPE_SEC_LVL__SDPIF_PIPE2_SEC_LVL_MASK                                                 0x000001C0L
#define DCHUBBUB_SDPIF_PIPE_SEC_LVL__SDPIF_PIPE3_SEC_LVL_MASK                                                 0x00000E00L
//DCHUBBUB_SDPIF_MEM_PWR_CTRL
#define DCHUBBUB_SDPIF_MEM_PWR_CTRL__DCHUBBUB_SDPIF_MEM_PWR_FORCE__SHIFT                                      0x0
#define DCHUBBUB_SDPIF_MEM_PWR_CTRL__DCHUBBUB_SDPIF_MEM_PWR_DIS__SHIFT                                        0x2
#define DCHUBBUB_SDPIF_MEM_PWR_CTRL__DCHUBBUB_SDPIF_MEM_PWR_FORCE_MASK                                        0x00000003L
#define DCHUBBUB_SDPIF_MEM_PWR_CTRL__DCHUBBUB_SDPIF_MEM_PWR_DIS_MASK                                          0x00000004L
//DCHUBBUB_SDPIF_MEM_PWR_STATUS
#define DCHUBBUB_SDPIF_MEM_PWR_STATUS__DCHUBBUB_SDPIF_MEM_PWR_STATE__SHIFT                                    0x0
#define DCHUBBUB_SDPIF_MEM_PWR_STATUS__DCHUBBUB_SDPIF_MEM_PWR_STATE_MASK                                      0x00000003L


// addressBlock: dce_dc_dchubbub_hubbub_ret_path_dispdec
//DCHUBBUB_RET_PATH_DCC_CFG
#define DCHUBBUB_RET_PATH_DCC_CFG__DCC_VIDEO_FORMAT_EN__SHIFT                                                 0x0
#define DCHUBBUB_RET_PATH_DCC_CFG__DCC_VIDEO_FORMAT_EN_MASK                                                   0x00000001L
//DCHUBBUB_RET_PATH_DCC_CFG0_0
#define DCHUBBUB_RET_PATH_DCC_CFG0_0__DCC_CFG0_CONSTANT_0__SHIFT                                              0x0
#define DCHUBBUB_RET_PATH_DCC_CFG0_0__DCC_CFG0_CONSTANT_0_MASK                                                0xFFFFFFFFL
//DCHUBBUB_RET_PATH_DCC_CFG0_1
#define DCHUBBUB_RET_PATH_DCC_CFG0_1__DCC_CFG0_CONSTANT_1__SHIFT                                              0x0
#define DCHUBBUB_RET_PATH_DCC_CFG0_1__DCC_CFG0_CONSTANT_1_MASK                                                0xFFFFFFFFL
//DCHUBBUB_RET_PATH_DCC_CFG1_0
#define DCHUBBUB_RET_PATH_DCC_CFG1_0__DCC_CFG1_CONSTANT_0__SHIFT                                              0x0
#define DCHUBBUB_RET_PATH_DCC_CFG1_0__DCC_CFG1_CONSTANT_0_MASK                                                0xFFFFFFFFL
//DCHUBBUB_RET_PATH_DCC_CFG1_1
#define DCHUBBUB_RET_PATH_DCC_CFG1_1__DCC_CFG1_CONSTANT_1__SHIFT                                              0x0
#define DCHUBBUB_RET_PATH_DCC_CFG1_1__DCC_CFG1_CONSTANT_1_MASK                                                0xFFFFFFFFL
//DCHUBBUB_RET_PATH_DCC_CFG2_0
#define DCHUBBUB_RET_PATH_DCC_CFG2_0__DCC_CFG2_CONSTANT_0__SHIFT                                              0x0
#define DCHUBBUB_RET_PATH_DCC_CFG2_0__DCC_CFG2_CONSTANT_0_MASK                                                0xFFFFFFFFL
//DCHUBBUB_RET_PATH_DCC_CFG2_1
#define DCHUBBUB_RET_PATH_DCC_CFG2_1__DCC_CFG2_CONSTANT_1__SHIFT                                              0x0
#define DCHUBBUB_RET_PATH_DCC_CFG2_1__DCC_CFG2_CONSTANT_1_MASK                                                0xFFFFFFFFL
//DCHUBBUB_RET_PATH_DCC_CFG3_0
#define DCHUBBUB_RET_PATH_DCC_CFG3_0__DCC_CFG3_CONSTANT_0__SHIFT                                              0x0
#define DCHUBBUB_RET_PATH_DCC_CFG3_0__DCC_CFG3_CONSTANT_0_MASK                                                0xFFFFFFFFL
//DCHUBBUB_RET_PATH_DCC_CFG3_1
#define DCHUBBUB_RET_PATH_DCC_CFG3_1__DCC_CFG3_CONSTANT_1__SHIFT                                              0x0
#define DCHUBBUB_RET_PATH_DCC_CFG3_1__DCC_CFG3_CONSTANT_1_MASK                                                0xFFFFFFFFL
//DCHUBBUB_RET_PATH_DCC_CFG4_0
#define DCHUBBUB_RET_PATH_DCC_CFG4_0__DCC_CFG4_CONSTANT_0__SHIFT                                              0x0
#define DCHUBBUB_RET_PATH_DCC_CFG4_0__DCC_CFG4_CONSTANT_0_MASK                                                0xFFFFFFFFL
//DCHUBBUB_RET_PATH_DCC_CFG4_1
#define DCHUBBUB_RET_PATH_DCC_CFG4_1__DCC_CFG4_CONSTANT_1__SHIFT                                              0x0
#define DCHUBBUB_RET_PATH_DCC_CFG4_1__DCC_CFG4_CONSTANT_1_MASK                                                0xFFFFFFFFL
//DCHUBBUB_RET_PATH_DCC_CFG5_0
#define DCHUBBUB_RET_PATH_DCC_CFG5_0__DCC_CFG5_CONSTANT_0__SHIFT                                              0x0
#define DCHUBBUB_RET_PATH_DCC_CFG5_0__DCC_CFG5_CONSTANT_0_MASK                                                0xFFFFFFFFL
//DCHUBBUB_RET_PATH_DCC_CFG5_1
#define DCHUBBUB_RET_PATH_DCC_CFG5_1__DCC_CFG5_CONSTANT_1__SHIFT                                              0x0
#define DCHUBBUB_RET_PATH_DCC_CFG5_1__DCC_CFG5_CONSTANT_1_MASK                                                0xFFFFFFFFL
//DCHUBBUB_RET_PATH_DCC_CFG6_0
#define DCHUBBUB_RET_PATH_DCC_CFG6_0__DCC_CFG6_CONSTANT_0__SHIFT                                              0x0
#define DCHUBBUB_RET_PATH_DCC_CFG6_0__DCC_CFG6_CONSTANT_0_MASK                                                0xFFFFFFFFL
//DCHUBBUB_RET_PATH_DCC_CFG6_1
#define DCHUBBUB_RET_PATH_DCC_CFG6_1__DCC_CFG6_CONSTANT_1__SHIFT                                              0x0
#define DCHUBBUB_RET_PATH_DCC_CFG6_1__DCC_CFG6_CONSTANT_1_MASK                                                0xFFFFFFFFL
//DCHUBBUB_RET_PATH_DCC_CFG7_0
#define DCHUBBUB_RET_PATH_DCC_CFG7_0__DCC_CFG7_CONSTANT_0__SHIFT                                              0x0
#define DCHUBBUB_RET_PATH_DCC_CFG7_0__DCC_CFG7_CONSTANT_0_MASK                                                0xFFFFFFFFL
//DCHUBBUB_RET_PATH_DCC_CFG7_1
#define DCHUBBUB_RET_PATH_DCC_CFG7_1__DCC_CFG7_CONSTANT_1__SHIFT                                              0x0
#define DCHUBBUB_RET_PATH_DCC_CFG7_1__DCC_CFG7_CONSTANT_1_MASK                                                0xFFFFFFFFL
//DCHUBBUB_RET_PATH_MEM_PWR_CTRL
#define DCHUBBUB_RET_PATH_MEM_PWR_CTRL__DCHUBBUB_RET_PATH_MEM_PWR_FORCE__SHIFT                                0x0
#define DCHUBBUB_RET_PATH_MEM_PWR_CTRL__DCHUBBUB_RET_PATH_MEM_PWR_DIS__SHIFT                                  0x2
#define DCHUBBUB_RET_PATH_MEM_PWR_CTRL__DCHUBBUB_RET_PATH_MEM_PWR_FORCE_MASK                                  0x00000003L
#define DCHUBBUB_RET_PATH_MEM_PWR_CTRL__DCHUBBUB_RET_PATH_MEM_PWR_DIS_MASK                                    0x00000004L
//DCHUBBUB_RET_PATH_MEM_PWR_STATUS
#define DCHUBBUB_RET_PATH_MEM_PWR_STATUS__DCHUBBUB_RET_PATH_MEM_PWR_STATE__SHIFT                              0x0
#define DCHUBBUB_RET_PATH_MEM_PWR_STATUS__DCHUBBUB_RET_PATH_MEM_PWR_STATE_MASK                                0x00000003L
//DCHUBBUB_CRC_CTRL
#define DCHUBBUB_CRC_CTRL__DCHUBBUB_CRC_EN__SHIFT                                                             0x0
#define DCHUBBUB_CRC_CTRL__DCHUBBUB_CRC_CONT_EN__SHIFT                                                        0x1
#define DCHUBBUB_CRC_CTRL__DCHUBBUB_CRC0_ONE_SHOT_PENDING__SHIFT                                              0x2
#define DCHUBBUB_CRC_CTRL__DCHUBBUB_CRC1_ONE_SHOT_PENDING__SHIFT                                              0x3
#define DCHUBBUB_CRC_CTRL__DCHUBBUB_CRC0_SRC_SEL__SHIFT                                                       0x4
#define DCHUBBUB_CRC_CTRL__DCHUBBUB_CRC1_SRC_SEL__SHIFT                                                       0x6
#define DCHUBBUB_CRC_CTRL__DCHUBBUB_CRC_PIPE_SEL__SHIFT                                                       0x8
#define DCHUBBUB_CRC_CTRL__DCHUBBUB_CRC_SURF_SEL__SHIFT                                                       0xc
#define DCHUBBUB_CRC_CTRL__DCHUBBUB_CRC_DATA_SRC_SEL__SHIFT                                                   0xe
#define DCHUBBUB_CRC_CTRL__DCHUBBUB_CRC_EN_MASK                                                               0x00000001L
#define DCHUBBUB_CRC_CTRL__DCHUBBUB_CRC_CONT_EN_MASK                                                          0x00000002L
#define DCHUBBUB_CRC_CTRL__DCHUBBUB_CRC0_ONE_SHOT_PENDING_MASK                                                0x00000004L
#define DCHUBBUB_CRC_CTRL__DCHUBBUB_CRC1_ONE_SHOT_PENDING_MASK                                                0x00000008L
#define DCHUBBUB_CRC_CTRL__DCHUBBUB_CRC0_SRC_SEL_MASK                                                         0x00000030L
#define DCHUBBUB_CRC_CTRL__DCHUBBUB_CRC1_SRC_SEL_MASK                                                         0x000000C0L
#define DCHUBBUB_CRC_CTRL__DCHUBBUB_CRC_PIPE_SEL_MASK                                                         0x00000F00L
#define DCHUBBUB_CRC_CTRL__DCHUBBUB_CRC_SURF_SEL_MASK                                                         0x00003000L
#define DCHUBBUB_CRC_CTRL__DCHUBBUB_CRC_DATA_SRC_SEL_MASK                                                     0x00004000L
//DCHUBBUB_CRC0_VAL_R_G
#define DCHUBBUB_CRC0_VAL_R_G__DCHUBBUB_CRC0_R_CR__SHIFT                                                      0x0
#define DCHUBBUB_CRC0_VAL_R_G__DCHUBBUB_CRC0_G_Y__SHIFT                                                       0x10
#define DCHUBBUB_CRC0_VAL_R_G__DCHUBBUB_CRC0_R_CR_MASK                                                        0x0000FFFFL
#define DCHUBBUB_CRC0_VAL_R_G__DCHUBBUB_CRC0_G_Y_MASK                                                         0xFFFF0000L
//DCHUBBUB_CRC0_VAL_B_A
#define DCHUBBUB_CRC0_VAL_B_A__DCHUBBUB_CRC0_B_CB__SHIFT                                                      0x0
#define DCHUBBUB_CRC0_VAL_B_A__DCHUBBUB_CRC0_ALPHA__SHIFT                                                     0x10
#define DCHUBBUB_CRC0_VAL_B_A__DCHUBBUB_CRC0_B_CB_MASK                                                        0x0000FFFFL
#define DCHUBBUB_CRC0_VAL_B_A__DCHUBBUB_CRC0_ALPHA_MASK                                                       0xFFFF0000L
//DCHUBBUB_CRC1_VAL_R_G
#define DCHUBBUB_CRC1_VAL_R_G__DCHUBBUB_CRC1_R_CR__SHIFT                                                      0x0
#define DCHUBBUB_CRC1_VAL_R_G__DCHUBBUB_CRC1_G_Y__SHIFT                                                       0x10
#define DCHUBBUB_CRC1_VAL_R_G__DCHUBBUB_CRC1_R_CR_MASK                                                        0x0000FFFFL
#define DCHUBBUB_CRC1_VAL_R_G__DCHUBBUB_CRC1_G_Y_MASK                                                         0xFFFF0000L
//DCHUBBUB_CRC1_VAL_B_A
#define DCHUBBUB_CRC1_VAL_B_A__DCHUBBUB_CRC1_B_CB__SHIFT                                                      0x0
#define DCHUBBUB_CRC1_VAL_B_A__DCHUBBUB_CRC1_ALPHA__SHIFT                                                     0x10
#define DCHUBBUB_CRC1_VAL_B_A__DCHUBBUB_CRC1_B_CB_MASK                                                        0x0000FFFFL
#define DCHUBBUB_CRC1_VAL_B_A__DCHUBBUB_CRC1_ALPHA_MASK                                                       0xFFFF0000L


// addressBlock: dce_dc_dchubbub_hubbub_dispdec
//DCHUBBUB_ARB_DF_REQ_OUTSTAND
#define DCHUBBUB_ARB_DF_REQ_OUTSTAND__DCHUBBUB_ARB_MAX_REQ_OUTSTAND__SHIFT                                    0x0
#define DCHUBBUB_ARB_DF_REQ_OUTSTAND__DCHUBBUB_ARB_MIN_REQ_OUTSTAND__SHIFT                                    0x10
#define DCHUBBUB_ARB_DF_REQ_OUTSTAND__DCHUBBUB_ARB_MAX_REQ_OUTSTAND_MASK                                      0x000001FFL
#define DCHUBBUB_ARB_DF_REQ_OUTSTAND__DCHUBBUB_ARB_MIN_REQ_OUTSTAND_MASK                                      0x01FF0000L
//DCHUBBUB_ARB_SAT_LEVEL
#define DCHUBBUB_ARB_SAT_LEVEL__DCHUBBUB_ARB_SAT_LEVEL__SHIFT                                                 0x0
#define DCHUBBUB_ARB_SAT_LEVEL__DCHUBBUB_ARB_SAT_LEVEL_MASK                                                   0xFFFFFFFFL
//DCHUBBUB_ARB_QOS_FORCE
#define DCHUBBUB_ARB_QOS_FORCE__DCHUBBUB_ARB_QOS_FORCE_VALUE__SHIFT                                           0x0
#define DCHUBBUB_ARB_QOS_FORCE__DCHUBBUB_ARB_QOS_FORCE_ENABLE__SHIFT                                          0x8
#define DCHUBBUB_ARB_QOS_FORCE__DCHUBBUB_ARB_QOS_FORCE_VALUE_MASK                                             0x0000000FL
#define DCHUBBUB_ARB_QOS_FORCE__DCHUBBUB_ARB_QOS_FORCE_ENABLE_MASK                                            0x00000100L
//DCHUBBUB_ARB_DRAM_STATE_CNTL
#define DCHUBBUB_ARB_DRAM_STATE_CNTL__DCHUBBUB_ARB_ALLOW_SELF_REFRESH_FORCE_VALUE__SHIFT                      0x0
#define DCHUBBUB_ARB_DRAM_STATE_CNTL__DCHUBBUB_ARB_ALLOW_SELF_REFRESH_FORCE_ENABLE__SHIFT                     0x1
#define DCHUBBUB_ARB_DRAM_STATE_CNTL__DCHUBBUB_ARB_ALLOW_SELF_REFRESH_FORCED_CLEAR_DISABLE__SHIFT             0x2
#define DCHUBBUB_ARB_DRAM_STATE_CNTL__DCHUBBUB_ARB_ALLOW_PSTATE_CHANGE_FORCE_VALUE__SHIFT                     0x4
#define DCHUBBUB_ARB_DRAM_STATE_CNTL__DCHUBBUB_ARB_ALLOW_PSTATE_CHANGE_FORCE_ENABLE__SHIFT                    0x5
#define DCHUBBUB_ARB_DRAM_STATE_CNTL__DCHUBBUB_ARB_ALLOW_SELF_REFRESH_FORCE_VALUE_MASK                        0x00000001L
#define DCHUBBUB_ARB_DRAM_STATE_CNTL__DCHUBBUB_ARB_ALLOW_SELF_REFRESH_FORCE_ENABLE_MASK                       0x00000002L
#define DCHUBBUB_ARB_DRAM_STATE_CNTL__DCHUBBUB_ARB_ALLOW_SELF_REFRESH_FORCED_CLEAR_DISABLE_MASK               0x00000004L
#define DCHUBBUB_ARB_DRAM_STATE_CNTL__DCHUBBUB_ARB_ALLOW_PSTATE_CHANGE_FORCE_VALUE_MASK                       0x00000010L
#define DCHUBBUB_ARB_DRAM_STATE_CNTL__DCHUBBUB_ARB_ALLOW_PSTATE_CHANGE_FORCE_ENABLE_MASK                      0x00000020L
//DCHUBBUB_ARB_DATA_URGENCY_WATERMARK_A
#define DCHUBBUB_ARB_DATA_URGENCY_WATERMARK_A__DCHUBBUB_ARB_DATA_URGENCY_WATERMARK_A__SHIFT                   0x0
#define DCHUBBUB_ARB_DATA_URGENCY_WATERMARK_A__DCHUBBUB_ARB_DATA_URGENCY_WATERMARK_A_MASK                     0x001FFFFFL
//DCHUBBUB_ARB_PTE_META_URGENCY_WATERMARK_A
#define DCHUBBUB_ARB_PTE_META_URGENCY_WATERMARK_A__DCHUBBUB_ARB_PTE_META_URGENCY_WATERMARK_A__SHIFT           0x0
#define DCHUBBUB_ARB_PTE_META_URGENCY_WATERMARK_A__DCHUBBUB_ARB_PTE_META_URGENCY_WATERMARK_A_MASK             0x001FFFFFL
//DCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_A
#define DCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_A__DCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_A__SHIFT               0x0
#define DCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_A__DCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_A_MASK                 0x001FFFFFL
//DCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_A
#define DCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_A__DCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_A__SHIFT                 0x0
#define DCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_A__DCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_A_MASK                   0x001FFFFFL
//DCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_A
#define DCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_A__DCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_A__SHIFT  0x0
#define DCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_A__DCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_A_MASK   0x001FFFFFL
//DCHUBBUB_ARB_DATA_URGENCY_WATERMARK_B
#define DCHUBBUB_ARB_DATA_URGENCY_WATERMARK_B__DCHUBBUB_ARB_DATA_URGENCY_WATERMARK_B__SHIFT                   0x0
#define DCHUBBUB_ARB_DATA_URGENCY_WATERMARK_B__DCHUBBUB_ARB_DATA_URGENCY_WATERMARK_B_MASK                     0x001FFFFFL
//DCHUBBUB_ARB_PTE_META_URGENCY_WATERMARK_B
#define DCHUBBUB_ARB_PTE_META_URGENCY_WATERMARK_B__DCHUBBUB_ARB_PTE_META_URGENCY_WATERMARK_B__SHIFT           0x0
#define DCHUBBUB_ARB_PTE_META_URGENCY_WATERMARK_B__DCHUBBUB_ARB_PTE_META_URGENCY_WATERMARK_B_MASK             0x001FFFFFL
//DCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_B
#define DCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_B__DCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_B__SHIFT               0x0
#define DCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_B__DCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_B_MASK                 0x001FFFFFL
//DCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_B
#define DCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_B__DCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_B__SHIFT                 0x0
#define DCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_B__DCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_B_MASK                   0x001FFFFFL
//DCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_B
#define DCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_B__DCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_B__SHIFT  0x0
#define DCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_B__DCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_B_MASK   0x001FFFFFL
//DCHUBBUB_ARB_DATA_URGENCY_WATERMARK_C
#define DCHUBBUB_ARB_DATA_URGENCY_WATERMARK_C__DCHUBBUB_ARB_DATA_URGENCY_WATERMARK_C__SHIFT                   0x0
#define DCHUBBUB_ARB_DATA_URGENCY_WATERMARK_C__DCHUBBUB_ARB_DATA_URGENCY_WATERMARK_C_MASK                     0x001FFFFFL
//DCHUBBUB_ARB_PTE_META_URGENCY_WATERMARK_C
#define DCHUBBUB_ARB_PTE_META_URGENCY_WATERMARK_C__DCHUBBUB_ARB_PTE_META_URGENCY_WATERMARK_C__SHIFT           0x0
#define DCHUBBUB_ARB_PTE_META_URGENCY_WATERMARK_C__DCHUBBUB_ARB_PTE_META_URGENCY_WATERMARK_C_MASK             0x001FFFFFL
//DCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_C
#define DCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_C__DCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_C__SHIFT               0x0
#define DCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_C__DCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_C_MASK                 0x001FFFFFL
//DCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_C
#define DCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_C__DCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_C__SHIFT                 0x0
#define DCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_C__DCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_C_MASK                   0x001FFFFFL
//DCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_C
#define DCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_C__DCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_C__SHIFT  0x0
#define DCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_C__DCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_C_MASK   0x001FFFFFL
//DCHUBBUB_ARB_DATA_URGENCY_WATERMARK_D
#define DCHUBBUB_ARB_DATA_URGENCY_WATERMARK_D__DCHUBBUB_ARB_DATA_URGENCY_WATERMARK_D__SHIFT                   0x0
#define DCHUBBUB_ARB_DATA_URGENCY_WATERMARK_D__DCHUBBUB_ARB_DATA_URGENCY_WATERMARK_D_MASK                     0x001FFFFFL
//DCHUBBUB_ARB_PTE_META_URGENCY_WATERMARK_D
#define DCHUBBUB_ARB_PTE_META_URGENCY_WATERMARK_D__DCHUBBUB_ARB_PTE_META_URGENCY_WATERMARK_D__SHIFT           0x0
#define DCHUBBUB_ARB_PTE_META_URGENCY_WATERMARK_D__DCHUBBUB_ARB_PTE_META_URGENCY_WATERMARK_D_MASK             0x001FFFFFL
//DCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_D
#define DCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_D__DCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_D__SHIFT               0x0
#define DCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_D__DCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_D_MASK                 0x001FFFFFL
//DCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_D
#define DCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_D__DCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_D__SHIFT                 0x0
#define DCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_D__DCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_D_MASK                   0x001FFFFFL
//DCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_D
#define DCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_D__DCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_D__SHIFT  0x0
#define DCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_D__DCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_D_MASK   0x001FFFFFL
//DCHUBBUB_ARB_WATERMARK_CHANGE_CNTL
#define DCHUBBUB_ARB_WATERMARK_CHANGE_CNTL__DCHUBBUB_ARB_WATERMARK_CHANGE_SELECT__SHIFT                       0x0
#define DCHUBBUB_ARB_WATERMARK_CHANGE_CNTL__DCHUBBUB_ARB_WATERMARK_CHANGE_DONE_INTERRUPT_DISABLE__SHIFT       0x4
#define DCHUBBUB_ARB_WATERMARK_CHANGE_CNTL__DCHUBBUB_ARB_WATERMARK_CHANGE_DONE_INTERRUPT_STATUS__SHIFT        0x5
#define DCHUBBUB_ARB_WATERMARK_CHANGE_CNTL__DCHUBBUB_ARB_WATERMARK_CHANGE_DONE_INTERRUPT_ACK__SHIFT           0x6
#define DCHUBBUB_ARB_WATERMARK_CHANGE_CNTL__DCHUBBUB_ARB_WATERMARK_CHANGE_REQUEST__SHIFT                      0x8
#define DCHUBBUB_ARB_WATERMARK_CHANGE_CNTL__DCHUBBUB_ARB_WATERMARK_CHANGE_SELECT_MASK                         0x00000003L
#define DCHUBBUB_ARB_WATERMARK_CHANGE_CNTL__DCHUBBUB_ARB_WATERMARK_CHANGE_DONE_INTERRUPT_DISABLE_MASK         0x00000010L
#define DCHUBBUB_ARB_WATERMARK_CHANGE_CNTL__DCHUBBUB_ARB_WATERMARK_CHANGE_DONE_INTERRUPT_STATUS_MASK          0x00000020L
#define DCHUBBUB_ARB_WATERMARK_CHANGE_CNTL__DCHUBBUB_ARB_WATERMARK_CHANGE_DONE_INTERRUPT_ACK_MASK             0x00000040L
#define DCHUBBUB_ARB_WATERMARK_CHANGE_CNTL__DCHUBBUB_ARB_WATERMARK_CHANGE_REQUEST_MASK                        0x00000100L
//DCHUBBUB_ARB_TIMEOUT_ENABLE
#define DCHUBBUB_ARB_TIMEOUT_ENABLE__DCHUBBUB_ARB_TIMEOUT_ENABLE__SHIFT                                       0x0
#define DCHUBBUB_ARB_TIMEOUT_ENABLE__DCHUBBUB_ARB_TIMEOUT_ENABLE_MASK                                         0x00000001L
//DCHUBBUB_GLOBAL_TIMER_CNTL
#define DCHUBBUB_GLOBAL_TIMER_CNTL__DCHUBBUB_GLOBAL_TIMER_REFDIV__SHIFT                                       0x0
#define DCHUBBUB_GLOBAL_TIMER_CNTL__DCHUBBUB_GLOBAL_TIMER_ENABLE__SHIFT                                       0xc
#define DCHUBBUB_GLOBAL_TIMER_CNTL__DCHUBBUB_GLOBAL_TIMER_INIT__SHIFT                                         0x10
#define DCHUBBUB_GLOBAL_TIMER_CNTL__DCHUBBUB_GLOBAL_TIMER_REFDIV_MASK                                         0x0000000FL
#define DCHUBBUB_GLOBAL_TIMER_CNTL__DCHUBBUB_GLOBAL_TIMER_ENABLE_MASK                                         0x00001000L
#define DCHUBBUB_GLOBAL_TIMER_CNTL__DCHUBBUB_GLOBAL_TIMER_INIT_MASK                                           0xFFFF0000L
//SURFACE_CHECK0_ADDRESS_LSB
#define SURFACE_CHECK0_ADDRESS_LSB__SURFACE_CHECK0_ADDRESS_LSB__SHIFT                                         0x0
#define SURFACE_CHECK0_ADDRESS_LSB__SURFACE_CHECK0_ADDRESS_LSB_MASK                                           0xFFFFFFFFL
//SURFACE_CHECK0_ADDRESS_MSB
#define SURFACE_CHECK0_ADDRESS_MSB__SURFACE_CHECK0_ADDRESS_MSB__SHIFT                                         0x0
#define SURFACE_CHECK0_ADDRESS_MSB__CHECKER0_SURFACE_INUSE__SHIFT                                             0x1f
#define SURFACE_CHECK0_ADDRESS_MSB__SURFACE_CHECK0_ADDRESS_MSB_MASK                                           0x0000FFFFL
#define SURFACE_CHECK0_ADDRESS_MSB__CHECKER0_SURFACE_INUSE_MASK                                               0x80000000L
//SURFACE_CHECK1_ADDRESS_LSB
#define SURFACE_CHECK1_ADDRESS_LSB__SURFACE_CHECK1_ADDRESS_LSB__SHIFT                                         0x0
#define SURFACE_CHECK1_ADDRESS_LSB__SURFACE_CHECK1_ADDRESS_LSB_MASK                                           0xFFFFFFFFL
//SURFACE_CHECK1_ADDRESS_MSB
#define SURFACE_CHECK1_ADDRESS_MSB__SURFACE_CHECK1_ADDRESS_MSB__SHIFT                                         0x0
#define SURFACE_CHECK1_ADDRESS_MSB__CHECKER1_SURFACE_INUSE__SHIFT                                             0x1f
#define SURFACE_CHECK1_ADDRESS_MSB__SURFACE_CHECK1_ADDRESS_MSB_MASK                                           0x0000FFFFL
#define SURFACE_CHECK1_ADDRESS_MSB__CHECKER1_SURFACE_INUSE_MASK                                               0x80000000L
//SURFACE_CHECK2_ADDRESS_LSB
#define SURFACE_CHECK2_ADDRESS_LSB__SURFACE_CHECK2_ADDRESS_LSB__SHIFT                                         0x0
#define SURFACE_CHECK2_ADDRESS_LSB__SURFACE_CHECK2_ADDRESS_LSB_MASK                                           0xFFFFFFFFL
//SURFACE_CHECK2_ADDRESS_MSB
#define SURFACE_CHECK2_ADDRESS_MSB__SURFACE_CHECK2_ADDRESS_MSB__SHIFT                                         0x0
#define SURFACE_CHECK2_ADDRESS_MSB__CHECKER2_SURFACE_INUSE__SHIFT                                             0x1f
#define SURFACE_CHECK2_ADDRESS_MSB__SURFACE_CHECK2_ADDRESS_MSB_MASK                                           0x0000FFFFL
#define SURFACE_CHECK2_ADDRESS_MSB__CHECKER2_SURFACE_INUSE_MASK                                               0x80000000L
//SURFACE_CHECK3_ADDRESS_LSB
#define SURFACE_CHECK3_ADDRESS_LSB__SURFACE_CHECK3_ADDRESS_LSB__SHIFT                                         0x0
#define SURFACE_CHECK3_ADDRESS_LSB__SURFACE_CHECK3_ADDRESS_LSB_MASK                                           0xFFFFFFFFL
//SURFACE_CHECK3_ADDRESS_MSB
#define SURFACE_CHECK3_ADDRESS_MSB__SURFACE_CHECK3_ADDRESS_MSB__SHIFT                                         0x0
#define SURFACE_CHECK3_ADDRESS_MSB__CHECKER3_SURFACE_INUSE__SHIFT                                             0x1f
#define SURFACE_CHECK3_ADDRESS_MSB__SURFACE_CHECK3_ADDRESS_MSB_MASK                                           0x0000FFFFL
#define SURFACE_CHECK3_ADDRESS_MSB__CHECKER3_SURFACE_INUSE_MASK                                               0x80000000L
//VTG0_CONTROL
#define VTG0_CONTROL__VTG0_FP2__SHIFT                                                                         0x0
#define VTG0_CONTROL__VTG0_VCOUNT_INIT__SHIFT                                                                 0xf
#define VTG0_CONTROL__VTG0_ENABLE__SHIFT                                                                      0x1f
#define VTG0_CONTROL__VTG0_FP2_MASK                                                                           0x00007FFFL
#define VTG0_CONTROL__VTG0_VCOUNT_INIT_MASK                                                                   0x3FFF8000L
#define VTG0_CONTROL__VTG0_ENABLE_MASK                                                                        0x80000000L
//VTG1_CONTROL
#define VTG1_CONTROL__VTG1_FP2__SHIFT                                                                         0x0
#define VTG1_CONTROL__VTG1_VCOUNT_INIT__SHIFT                                                                 0xf
#define VTG1_CONTROL__VTG1_ENABLE__SHIFT                                                                      0x1f
#define VTG1_CONTROL__VTG1_FP2_MASK                                                                           0x00007FFFL
#define VTG1_CONTROL__VTG1_VCOUNT_INIT_MASK                                                                   0x3FFF8000L
#define VTG1_CONTROL__VTG1_ENABLE_MASK                                                                        0x80000000L
//VTG2_CONTROL
#define VTG2_CONTROL__VTG2_FP2__SHIFT                                                                         0x0
#define VTG2_CONTROL__VTG2_VCOUNT_INIT__SHIFT                                                                 0xf
#define VTG2_CONTROL__VTG2_ENABLE__SHIFT                                                                      0x1f
#define VTG2_CONTROL__VTG2_FP2_MASK                                                                           0x00007FFFL
#define VTG2_CONTROL__VTG2_VCOUNT_INIT_MASK                                                                   0x3FFF8000L
#define VTG2_CONTROL__VTG2_ENABLE_MASK                                                                        0x80000000L
//VTG3_CONTROL
#define VTG3_CONTROL__VTG3_FP2__SHIFT                                                                         0x0
#define VTG3_CONTROL__VTG3_VCOUNT_INIT__SHIFT                                                                 0xf
#define VTG3_CONTROL__VTG3_ENABLE__SHIFT                                                                      0x1f
#define VTG3_CONTROL__VTG3_FP2_MASK                                                                           0x00007FFFL
#define VTG3_CONTROL__VTG3_VCOUNT_INIT_MASK                                                                   0x3FFF8000L
#define VTG3_CONTROL__VTG3_ENABLE_MASK                                                                        0x80000000L
//VTG4_CONTROL
#define VTG4_CONTROL__VTG4_FP2__SHIFT                                                                         0x0
#define VTG4_CONTROL__VTG4_VCOUNT_INIT__SHIFT                                                                 0xf
#define VTG4_CONTROL__VTG4_ENABLE__SHIFT                                                                      0x1f
#define VTG4_CONTROL__VTG4_FP2_MASK                                                                           0x00007FFFL
#define VTG4_CONTROL__VTG4_VCOUNT_INIT_MASK                                                                   0x3FFF8000L
#define VTG4_CONTROL__VTG4_ENABLE_MASK                                                                        0x80000000L
//VTG5_CONTROL
#define VTG5_CONTROL__VTG5_FP2__SHIFT                                                                         0x0
#define VTG5_CONTROL__VTG5_VCOUNT_INIT__SHIFT                                                                 0xf
#define VTG5_CONTROL__VTG5_ENABLE__SHIFT                                                                      0x1f
#define VTG5_CONTROL__VTG5_FP2_MASK                                                                           0x00007FFFL
#define VTG5_CONTROL__VTG5_VCOUNT_INIT_MASK                                                                   0x3FFF8000L
#define VTG5_CONTROL__VTG5_ENABLE_MASK                                                                        0x80000000L
//DCHUBBUB_SOFT_RESET
#define DCHUBBUB_SOFT_RESET__DCHUBBUB_GLOBAL_SOFT_RESET__SHIFT                                                0x0
#define DCHUBBUB_SOFT_RESET__ALLOW_CSTATE_SOFT_RESET__SHIFT                                                   0x1
#define DCHUBBUB_SOFT_RESET__GLBFLIP_SOFT_RESET__SHIFT                                                        0x4
#define DCHUBBUB_SOFT_RESET__DCHUBBUB_GLOBAL_SOFT_RESET_MASK                                                  0x00000001L
#define DCHUBBUB_SOFT_RESET__ALLOW_CSTATE_SOFT_RESET_MASK                                                     0x00000002L
#define DCHUBBUB_SOFT_RESET__GLBFLIP_SOFT_RESET_MASK                                                          0x00000010L
//DCHUBBUB_CLOCK_CNTL
#define DCHUBBUB_CLOCK_CNTL__DCHUBBUB_TEST_CLK_SEL__SHIFT                                                     0x0
#define DCHUBBUB_CLOCK_CNTL__DISPCLK_R_DCHUBBUB_GATE_DIS__SHIFT                                               0x5
#define DCHUBBUB_CLOCK_CNTL__DCFCLK_R_DCHUBBUB_GATE_DIS__SHIFT                                                0x6
#define DCHUBBUB_CLOCK_CNTL__DCHUBBUB_TEST_CLK_SEL_MASK                                                       0x0000001FL
#define DCHUBBUB_CLOCK_CNTL__DISPCLK_R_DCHUBBUB_GATE_DIS_MASK                                                 0x00000020L
#define DCHUBBUB_CLOCK_CNTL__DCFCLK_R_DCHUBBUB_GATE_DIS_MASK                                                  0x00000040L
//DCFCLK_CNTL
#define DCFCLK_CNTL__DCFCLK_TURN_ON_DELAY__SHIFT                                                              0x0
#define DCFCLK_CNTL__DCFCLK_TURN_OFF_DELAY__SHIFT                                                             0x4
#define DCFCLK_CNTL__DCFCLK_GATE_DIS__SHIFT                                                                   0x1f
#define DCFCLK_CNTL__DCFCLK_TURN_ON_DELAY_MASK                                                                0x0000000FL
#define DCFCLK_CNTL__DCFCLK_TURN_OFF_DELAY_MASK                                                               0x00000FF0L
#define DCFCLK_CNTL__DCFCLK_GATE_DIS_MASK                                                                     0x80000000L
//DCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL
#define DCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL__DCHUBBUB_LATENCY_CNT_EN__SHIFT                                 0x0
#define DCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL__ARB_LATENCY_PIPE_SEL__SHIFT                                    0x3
#define DCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL__ARB_LATENCY_REQ_TYPE_SEL__SHIFT                                0x7
#define DCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL__DF_LATENCY_URGENT_ONLY__SHIFT                                  0xa
#define DCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL__ROB_FIFO_LEVEL__SHIFT                                          0xb
#define DCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL__ROB_MAX_FIFO_LEVEL__SHIFT                                      0x15
#define DCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL__ROB_MAX_FIFO_LEVEL_RESET__SHIFT                                0x1f
#define DCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL__DCHUBBUB_LATENCY_CNT_EN_MASK                                   0x00000001L
#define DCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL__ARB_LATENCY_PIPE_SEL_MASK                                      0x00000078L
#define DCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL__ARB_LATENCY_REQ_TYPE_SEL_MASK                                  0x00000380L
#define DCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL__DF_LATENCY_URGENT_ONLY_MASK                                    0x00000400L
#define DCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL__ROB_FIFO_LEVEL_MASK                                            0x001FF800L
#define DCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL__ROB_MAX_FIFO_LEVEL_MASK                                        0x7FE00000L
#define DCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL__ROB_MAX_FIFO_LEVEL_RESET_MASK                                  0x80000000L
//DCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL2
#define DCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL2__DCHUBBUB_LATENCY_FRAME_WIN_EN__SHIFT                          0x0
#define DCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL2__DCHUBBUB_LATENCY_FRAME_WIN_SRC_SEL__SHIFT                     0x1
#define DCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL2__DCHUBBUB_LATENCY_FRAME_WIN_DUR__SHIFT                         0x4
#define DCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL2__LATENCY_SOURCE_SEL__SHIFT                                     0xc
#define DCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL2__DCHUBBUB_LATENCY_FRAME_WIN_EN_MASK                            0x00000001L
#define DCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL2__DCHUBBUB_LATENCY_FRAME_WIN_SRC_SEL_MASK                       0x0000000EL
#define DCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL2__DCHUBBUB_LATENCY_FRAME_WIN_DUR_MASK                           0x00000FF0L
#define DCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL2__LATENCY_SOURCE_SEL_MASK                                       0x00007000L
//DCHUBBUB_VLINE_SNAPSHOT
#define DCHUBBUB_VLINE_SNAPSHOT__DCHUBBUB_VLINE_SNAPSHOT__SHIFT                                               0x0
#define DCHUBBUB_VLINE_SNAPSHOT__DCHUBBUB_VLINE_SNAPSHOT_MASK                                                 0x00000001L
//DCHUBBUB_SPARE
#define DCHUBBUB_SPARE__DCHUBBUB_SPARE__SHIFT                                                                 0x0
#define DCHUBBUB_SPARE__DCHUBBUB_SPARE_MASK                                                                   0xFFFFFFFFL


// addressBlock: dce_dc_dchubbub_dchubbub_dcperfmon_dc_perfmon_dispdec
//DC_PERFMON7_PERFCOUNTER_CNTL
#define DC_PERFMON7_PERFCOUNTER_CNTL__PERFCOUNTER_EVENT_SEL__SHIFT                                            0x0
#define DC_PERFMON7_PERFCOUNTER_CNTL__PERFCOUNTER_CVALUE_SEL__SHIFT                                           0x9
#define DC_PERFMON7_PERFCOUNTER_CNTL__PERFCOUNTER_INC_MODE__SHIFT                                             0xc
#define DC_PERFMON7_PERFCOUNTER_CNTL__PERFCOUNTER_HW_CNTL_SEL__SHIFT                                          0xf
#define DC_PERFMON7_PERFCOUNTER_CNTL__PERFCOUNTER_RUNEN_MODE__SHIFT                                           0x10
#define DC_PERFMON7_PERFCOUNTER_CNTL__PERFCOUNTER_CNTOFF_START_DIS__SHIFT                                     0x16
#define DC_PERFMON7_PERFCOUNTER_CNTL__PERFCOUNTER_RESTART_EN__SHIFT                                           0x17
#define DC_PERFMON7_PERFCOUNTER_CNTL__PERFCOUNTER_INT_EN__SHIFT                                               0x18
#define DC_PERFMON7_PERFCOUNTER_CNTL__PERFCOUNTER_OFF_MASK__SHIFT                                             0x19
#define DC_PERFMON7_PERFCOUNTER_CNTL__PERFCOUNTER_ACTIVE__SHIFT                                               0x1a
#define DC_PERFMON7_PERFCOUNTER_CNTL__PERFCOUNTER_CNTL_SEL__SHIFT                                             0x1d
#define DC_PERFMON7_PERFCOUNTER_CNTL__PERFCOUNTER_EVENT_SEL_MASK                                              0x000001FFL
#define DC_PERFMON7_PERFCOUNTER_CNTL__PERFCOUNTER_CVALUE_SEL_MASK                                             0x00000E00L
#define DC_PERFMON7_PERFCOUNTER_CNTL__PERFCOUNTER_INC_MODE_MASK                                               0x00007000L
#define DC_PERFMON7_PERFCOUNTER_CNTL__PERFCOUNTER_HW_CNTL_SEL_MASK                                            0x00008000L
#define DC_PERFMON7_PERFCOUNTER_CNTL__PERFCOUNTER_RUNEN_MODE_MASK                                             0x00010000L
#define DC_PERFMON7_PERFCOUNTER_CNTL__PERFCOUNTER_CNTOFF_START_DIS_MASK                                       0x00400000L
#define DC_PERFMON7_PERFCOUNTER_CNTL__PERFCOUNTER_RESTART_EN_MASK                                             0x00800000L
#define DC_PERFMON7_PERFCOUNTER_CNTL__PERFCOUNTER_INT_EN_MASK                                                 0x01000000L
#define DC_PERFMON7_PERFCOUNTER_CNTL__PERFCOUNTER_OFF_MASK_MASK                                               0x02000000L
#define DC_PERFMON7_PERFCOUNTER_CNTL__PERFCOUNTER_ACTIVE_MASK                                                 0x04000000L
#define DC_PERFMON7_PERFCOUNTER_CNTL__PERFCOUNTER_CNTL_SEL_MASK                                               0xE0000000L
//DC_PERFMON7_PERFCOUNTER_CNTL2
#define DC_PERFMON7_PERFCOUNTER_CNTL2__PERFCOUNTER_COUNTED_VALUE_TYPE__SHIFT                                  0x0
#define DC_PERFMON7_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP1_SEL__SHIFT                                        0x2
#define DC_PERFMON7_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP2_SEL__SHIFT                                        0x3
#define DC_PERFMON7_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTOFF_SEL__SHIFT                                          0x8
#define DC_PERFMON7_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTL2_SEL__SHIFT                                           0x1d
#define DC_PERFMON7_PERFCOUNTER_CNTL2__PERFCOUNTER_COUNTED_VALUE_TYPE_MASK                                    0x00000003L
#define DC_PERFMON7_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP1_SEL_MASK                                          0x00000004L
#define DC_PERFMON7_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP2_SEL_MASK                                          0x00000008L
#define DC_PERFMON7_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTOFF_SEL_MASK                                            0x00003F00L
#define DC_PERFMON7_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTL2_SEL_MASK                                             0xE0000000L
//DC_PERFMON7_PERFCOUNTER_STATE
#define DC_PERFMON7_PERFCOUNTER_STATE__PERFCOUNTER_CNT0_STATE__SHIFT                                          0x0
#define DC_PERFMON7_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL0__SHIFT                                          0x2
#define DC_PERFMON7_PERFCOUNTER_STATE__PERFCOUNTER_CNT1_STATE__SHIFT                                          0x4
#define DC_PERFMON7_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL1__SHIFT                                          0x6
#define DC_PERFMON7_PERFCOUNTER_STATE__PERFCOUNTER_CNT2_STATE__SHIFT                                          0x8
#define DC_PERFMON7_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL2__SHIFT                                          0xa
#define DC_PERFMON7_PERFCOUNTER_STATE__PERFCOUNTER_CNT3_STATE__SHIFT                                          0xc
#define DC_PERFMON7_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL3__SHIFT                                          0xe
#define DC_PERFMON7_PERFCOUNTER_STATE__PERFCOUNTER_CNT4_STATE__SHIFT                                          0x10
#define DC_PERFMON7_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL4__SHIFT                                          0x12
#define DC_PERFMON7_PERFCOUNTER_STATE__PERFCOUNTER_CNT5_STATE__SHIFT                                          0x14
#define DC_PERFMON7_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL5__SHIFT                                          0x16
#define DC_PERFMON7_PERFCOUNTER_STATE__PERFCOUNTER_CNT6_STATE__SHIFT                                          0x18
#define DC_PERFMON7_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL6__SHIFT                                          0x1a
#define DC_PERFMON7_PERFCOUNTER_STATE__PERFCOUNTER_CNT7_STATE__SHIFT                                          0x1c
#define DC_PERFMON7_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL7__SHIFT                                          0x1e
#define DC_PERFMON7_PERFCOUNTER_STATE__PERFCOUNTER_CNT0_STATE_MASK                                            0x00000003L
#define DC_PERFMON7_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL0_MASK                                            0x00000004L
#define DC_PERFMON7_PERFCOUNTER_STATE__PERFCOUNTER_CNT1_STATE_MASK                                            0x00000030L
#define DC_PERFMON7_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL1_MASK                                            0x00000040L
#define DC_PERFMON7_PERFCOUNTER_STATE__PERFCOUNTER_CNT2_STATE_MASK                                            0x00000300L
#define DC_PERFMON7_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL2_MASK                                            0x00000400L
#define DC_PERFMON7_PERFCOUNTER_STATE__PERFCOUNTER_CNT3_STATE_MASK                                            0x00003000L
#define DC_PERFMON7_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL3_MASK                                            0x00004000L
#define DC_PERFMON7_PERFCOUNTER_STATE__PERFCOUNTER_CNT4_STATE_MASK                                            0x00030000L
#define DC_PERFMON7_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL4_MASK                                            0x00040000L
#define DC_PERFMON7_PERFCOUNTER_STATE__PERFCOUNTER_CNT5_STATE_MASK                                            0x00300000L
#define DC_PERFMON7_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL5_MASK                                            0x00400000L
#define DC_PERFMON7_PERFCOUNTER_STATE__PERFCOUNTER_CNT6_STATE_MASK                                            0x03000000L
#define DC_PERFMON7_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL6_MASK                                            0x04000000L
#define DC_PERFMON7_PERFCOUNTER_STATE__PERFCOUNTER_CNT7_STATE_MASK                                            0x30000000L
#define DC_PERFMON7_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL7_MASK                                            0x40000000L
//DC_PERFMON7_PERFMON_CNTL
#define DC_PERFMON7_PERFMON_CNTL__PERFMON_STATE__SHIFT                                                        0x0
#define DC_PERFMON7_PERFMON_CNTL__PERFMON_RPT_COUNT__SHIFT                                                    0x8
#define DC_PERFMON7_PERFMON_CNTL__PERFMON_CNTOFF_AND_OR__SHIFT                                                0x1c
#define DC_PERFMON7_PERFMON_CNTL__PERFMON_CNTOFF_INT_EN__SHIFT                                                0x1d
#define DC_PERFMON7_PERFMON_CNTL__PERFMON_CNTOFF_INT_STATUS__SHIFT                                            0x1e
#define DC_PERFMON7_PERFMON_CNTL__PERFMON_CNTOFF_INT_ACK__SHIFT                                               0x1f
#define DC_PERFMON7_PERFMON_CNTL__PERFMON_STATE_MASK                                                          0x00000003L
#define DC_PERFMON7_PERFMON_CNTL__PERFMON_RPT_COUNT_MASK                                                      0x0FFFFF00L
#define DC_PERFMON7_PERFMON_CNTL__PERFMON_CNTOFF_AND_OR_MASK                                                  0x10000000L
#define DC_PERFMON7_PERFMON_CNTL__PERFMON_CNTOFF_INT_EN_MASK                                                  0x20000000L
#define DC_PERFMON7_PERFMON_CNTL__PERFMON_CNTOFF_INT_STATUS_MASK                                              0x40000000L
#define DC_PERFMON7_PERFMON_CNTL__PERFMON_CNTOFF_INT_ACK_MASK                                                 0x80000000L
//DC_PERFMON7_PERFMON_CNTL2
#define DC_PERFMON7_PERFMON_CNTL2__PERFMON_CNTOFF_INT_TYPE__SHIFT                                             0x0
#define DC_PERFMON7_PERFMON_CNTL2__PERFMON_CLK_ENABLE__SHIFT                                                  0x1
#define DC_PERFMON7_PERFMON_CNTL2__PERFMON_RUN_ENABLE_START_SEL__SHIFT                                        0x2
#define DC_PERFMON7_PERFMON_CNTL2__PERFMON_RUN_ENABLE_STOP_SEL__SHIFT                                         0xa
#define DC_PERFMON7_PERFMON_CNTL2__PERFMON_CNTOFF_INT_TYPE_MASK                                               0x00000001L
#define DC_PERFMON7_PERFMON_CNTL2__PERFMON_CLK_ENABLE_MASK                                                    0x00000002L
#define DC_PERFMON7_PERFMON_CNTL2__PERFMON_RUN_ENABLE_START_SEL_MASK                                          0x000003FCL
#define DC_PERFMON7_PERFMON_CNTL2__PERFMON_RUN_ENABLE_STOP_SEL_MASK                                           0x0003FC00L
//DC_PERFMON7_PERFMON_CVALUE_INT_MISC
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_STATUS__SHIFT                                   0x0
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_STATUS__SHIFT                                   0x1
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_STATUS__SHIFT                                   0x2
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_STATUS__SHIFT                                   0x3
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_STATUS__SHIFT                                   0x4
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_STATUS__SHIFT                                   0x5
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_STATUS__SHIFT                                   0x6
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_STATUS__SHIFT                                   0x7
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_ACK__SHIFT                                      0x8
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_ACK__SHIFT                                      0x9
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_ACK__SHIFT                                      0xa
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_ACK__SHIFT                                      0xb
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_ACK__SHIFT                                      0xc
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_ACK__SHIFT                                      0xd
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_ACK__SHIFT                                      0xe
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_ACK__SHIFT                                      0xf
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFMON_CVALUE_HI__SHIFT                                         0x10
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_STATUS_MASK                                     0x00000001L
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_STATUS_MASK                                     0x00000002L
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_STATUS_MASK                                     0x00000004L
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_STATUS_MASK                                     0x00000008L
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_STATUS_MASK                                     0x00000010L
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_STATUS_MASK                                     0x00000020L
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_STATUS_MASK                                     0x00000040L
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_STATUS_MASK                                     0x00000080L
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_ACK_MASK                                        0x00000100L
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_ACK_MASK                                        0x00000200L
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_ACK_MASK                                        0x00000400L
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_ACK_MASK                                        0x00000800L
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_ACK_MASK                                        0x00001000L
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_ACK_MASK                                        0x00002000L
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_ACK_MASK                                        0x00004000L
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_ACK_MASK                                        0x00008000L
#define DC_PERFMON7_PERFMON_CVALUE_INT_MISC__PERFMON_CVALUE_HI_MASK                                           0xFFFF0000L
//DC_PERFMON7_PERFMON_CVALUE_LOW
#define DC_PERFMON7_PERFMON_CVALUE_LOW__PERFMON_CVALUE_LOW__SHIFT                                             0x0
#define DC_PERFMON7_PERFMON_CVALUE_LOW__PERFMON_CVALUE_LOW_MASK                                               0xFFFFFFFFL
//DC_PERFMON7_PERFMON_HI
#define DC_PERFMON7_PERFMON_HI__PERFMON_HI__SHIFT                                                             0x0
#define DC_PERFMON7_PERFMON_HI__PERFMON_READ_SEL__SHIFT                                                       0x1d
#define DC_PERFMON7_PERFMON_HI__PERFMON_HI_MASK                                                               0x0000FFFFL
#define DC_PERFMON7_PERFMON_HI__PERFMON_READ_SEL_MASK                                                         0xE0000000L
//DC_PERFMON7_PERFMON_LOW
#define DC_PERFMON7_PERFMON_LOW__PERFMON_LOW__SHIFT                                                           0x0
#define DC_PERFMON7_PERFMON_LOW__PERFMON_LOW_MASK                                                             0xFFFFFFFFL


// addressBlock: dce_dc_dcbubp0_dispdec_hubp_dispdec
//HUBP0_DCSURF_SURFACE_CONFIG
#define HUBP0_DCSURF_SURFACE_CONFIG__SURFACE_PIXEL_FORMAT__SHIFT                                              0x0
#define HUBP0_DCSURF_SURFACE_CONFIG__ROTATION_ANGLE__SHIFT                                                    0x8
#define HUBP0_DCSURF_SURFACE_CONFIG__H_MIRROR_EN__SHIFT                                                       0xa
#define HUBP0_DCSURF_SURFACE_CONFIG__SURFACE_PIXEL_FORMAT_MASK                                                0x0000007FL
#define HUBP0_DCSURF_SURFACE_CONFIG__ROTATION_ANGLE_MASK                                                      0x00000300L
#define HUBP0_DCSURF_SURFACE_CONFIG__H_MIRROR_EN_MASK                                                         0x00000400L
//HUBP0_DCSURF_ADDR_CONFIG
#define HUBP0_DCSURF_ADDR_CONFIG__NUM_PIPES__SHIFT                                                            0x0
#define HUBP0_DCSURF_ADDR_CONFIG__NUM_BANKS__SHIFT                                                            0x3
#define HUBP0_DCSURF_ADDR_CONFIG__PIPE_INTERLEAVE__SHIFT                                                      0x6
#define HUBP0_DCSURF_ADDR_CONFIG__NUM_SE__SHIFT                                                               0x8
#define HUBP0_DCSURF_ADDR_CONFIG__NUM_RB_PER_SE__SHIFT                                                        0xa
#define HUBP0_DCSURF_ADDR_CONFIG__MAX_COMPRESSED_FRAGS__SHIFT                                                 0xc
#define HUBP0_DCSURF_ADDR_CONFIG__NUM_PIPES_MASK                                                              0x00000007L
#define HUBP0_DCSURF_ADDR_CONFIG__NUM_BANKS_MASK                                                              0x00000038L
#define HUBP0_DCSURF_ADDR_CONFIG__PIPE_INTERLEAVE_MASK                                                        0x000000C0L
#define HUBP0_DCSURF_ADDR_CONFIG__NUM_SE_MASK                                                                 0x00000300L
#define HUBP0_DCSURF_ADDR_CONFIG__NUM_RB_PER_SE_MASK                                                          0x00000C00L
#define HUBP0_DCSURF_ADDR_CONFIG__MAX_COMPRESSED_FRAGS_MASK                                                   0x00003000L
//HUBP0_DCSURF_TILING_CONFIG
#define HUBP0_DCSURF_TILING_CONFIG__SW_MODE__SHIFT                                                            0x0
#define HUBP0_DCSURF_TILING_CONFIG__DIM_TYPE__SHIFT                                                           0x7
#define HUBP0_DCSURF_TILING_CONFIG__META_LINEAR__SHIFT                                                        0x9
#define HUBP0_DCSURF_TILING_CONFIG__RB_ALIGNED__SHIFT                                                         0xa
#define HUBP0_DCSURF_TILING_CONFIG__PIPE_ALIGNED__SHIFT                                                       0xb
#define HUBP0_DCSURF_TILING_CONFIG__SW_MODE_MASK                                                              0x0000001FL
#define HUBP0_DCSURF_TILING_CONFIG__DIM_TYPE_MASK                                                             0x00000180L
#define HUBP0_DCSURF_TILING_CONFIG__META_LINEAR_MASK                                                          0x00000200L
#define HUBP0_DCSURF_TILING_CONFIG__RB_ALIGNED_MASK                                                           0x00000400L
#define HUBP0_DCSURF_TILING_CONFIG__PIPE_ALIGNED_MASK                                                         0x00000800L
//HUBP0_DCSURF_PRI_VIEWPORT_START
#define HUBP0_DCSURF_PRI_VIEWPORT_START__PRI_VIEWPORT_X_START__SHIFT                                          0x0
#define HUBP0_DCSURF_PRI_VIEWPORT_START__PRI_VIEWPORT_Y_START__SHIFT                                          0x10
#define HUBP0_DCSURF_PRI_VIEWPORT_START__PRI_VIEWPORT_X_START_MASK                                            0x00003FFFL
#define HUBP0_DCSURF_PRI_VIEWPORT_START__PRI_VIEWPORT_Y_START_MASK                                            0x3FFF0000L
//HUBP0_DCSURF_PRI_VIEWPORT_DIMENSION
#define HUBP0_DCSURF_PRI_VIEWPORT_DIMENSION__PRI_VIEWPORT_WIDTH__SHIFT                                        0x0
#define HUBP0_DCSURF_PRI_VIEWPORT_DIMENSION__PRI_VIEWPORT_HEIGHT__SHIFT                                       0x10
#define HUBP0_DCSURF_PRI_VIEWPORT_DIMENSION__PRI_VIEWPORT_WIDTH_MASK                                          0x00003FFFL
#define HUBP0_DCSURF_PRI_VIEWPORT_DIMENSION__PRI_VIEWPORT_HEIGHT_MASK                                         0x3FFF0000L
//HUBP0_DCSURF_PRI_VIEWPORT_START_C
#define HUBP0_DCSURF_PRI_VIEWPORT_START_C__PRI_VIEWPORT_X_START_C__SHIFT                                      0x0
#define HUBP0_DCSURF_PRI_VIEWPORT_START_C__PRI_VIEWPORT_Y_START_C__SHIFT                                      0x10
#define HUBP0_DCSURF_PRI_VIEWPORT_START_C__PRI_VIEWPORT_X_START_C_MASK                                        0x00003FFFL
#define HUBP0_DCSURF_PRI_VIEWPORT_START_C__PRI_VIEWPORT_Y_START_C_MASK                                        0x3FFF0000L
//HUBP0_DCSURF_PRI_VIEWPORT_DIMENSION_C
#define HUBP0_DCSURF_PRI_VIEWPORT_DIMENSION_C__PRI_VIEWPORT_WIDTH_C__SHIFT                                    0x0
#define HUBP0_DCSURF_PRI_VIEWPORT_DIMENSION_C__PRI_VIEWPORT_HEIGHT_C__SHIFT                                   0x10
#define HUBP0_DCSURF_PRI_VIEWPORT_DIMENSION_C__PRI_VIEWPORT_WIDTH_C_MASK                                      0x00003FFFL
#define HUBP0_DCSURF_PRI_VIEWPORT_DIMENSION_C__PRI_VIEWPORT_HEIGHT_C_MASK                                     0x3FFF0000L
//HUBP0_DCSURF_SEC_VIEWPORT_START
#define HUBP0_DCSURF_SEC_VIEWPORT_START__SEC_VIEWPORT_X_START__SHIFT                                          0x0
#define HUBP0_DCSURF_SEC_VIEWPORT_START__SEC_VIEWPORT_Y_START__SHIFT                                          0x10
#define HUBP0_DCSURF_SEC_VIEWPORT_START__SEC_VIEWPORT_X_START_MASK                                            0x00003FFFL
#define HUBP0_DCSURF_SEC_VIEWPORT_START__SEC_VIEWPORT_Y_START_MASK                                            0x3FFF0000L
//HUBP0_DCSURF_SEC_VIEWPORT_DIMENSION
#define HUBP0_DCSURF_SEC_VIEWPORT_DIMENSION__SEC_VIEWPORT_WIDTH__SHIFT                                        0x0
#define HUBP0_DCSURF_SEC_VIEWPORT_DIMENSION__SEC_VIEWPORT_HEIGHT__SHIFT                                       0x10
#define HUBP0_DCSURF_SEC_VIEWPORT_DIMENSION__SEC_VIEWPORT_WIDTH_MASK                                          0x00003FFFL
#define HUBP0_DCSURF_SEC_VIEWPORT_DIMENSION__SEC_VIEWPORT_HEIGHT_MASK                                         0x3FFF0000L
//HUBP0_DCSURF_SEC_VIEWPORT_START_C
#define HUBP0_DCSURF_SEC_VIEWPORT_START_C__SEC_VIEWPORT_X_START_C__SHIFT                                      0x0
#define HUBP0_DCSURF_SEC_VIEWPORT_START_C__SEC_VIEWPORT_Y_START_C__SHIFT                                      0x10
#define HUBP0_DCSURF_SEC_VIEWPORT_START_C__SEC_VIEWPORT_X_START_C_MASK                                        0x00003FFFL
#define HUBP0_DCSURF_SEC_VIEWPORT_START_C__SEC_VIEWPORT_Y_START_C_MASK                                        0x3FFF0000L
//HUBP0_DCSURF_SEC_VIEWPORT_DIMENSION_C
#define HUBP0_DCSURF_SEC_VIEWPORT_DIMENSION_C__SEC_VIEWPORT_WIDTH_C__SHIFT                                    0x0
#define HUBP0_DCSURF_SEC_VIEWPORT_DIMENSION_C__SEC_VIEWPORT_HEIGHT_C__SHIFT                                   0x10
#define HUBP0_DCSURF_SEC_VIEWPORT_DIMENSION_C__SEC_VIEWPORT_WIDTH_C_MASK                                      0x00003FFFL
#define HUBP0_DCSURF_SEC_VIEWPORT_DIMENSION_C__SEC_VIEWPORT_HEIGHT_C_MASK                                     0x3FFF0000L
//HUBP0_DCHUBP_REQ_SIZE_CONFIG
#define HUBP0_DCHUBP_REQ_SIZE_CONFIG__SWATH_HEIGHT__SHIFT                                                     0x0
#define HUBP0_DCHUBP_REQ_SIZE_CONFIG__PTE_ROW_HEIGHT_LINEAR__SHIFT                                            0x4
#define HUBP0_DCHUBP_REQ_SIZE_CONFIG__CHUNK_SIZE__SHIFT                                                       0x8
#define HUBP0_DCHUBP_REQ_SIZE_CONFIG__MIN_CHUNK_SIZE__SHIFT                                                   0xb
#define HUBP0_DCHUBP_REQ_SIZE_CONFIG__META_CHUNK_SIZE__SHIFT                                                  0x10
#define HUBP0_DCHUBP_REQ_SIZE_CONFIG__MIN_META_CHUNK_SIZE__SHIFT                                              0x12
#define HUBP0_DCHUBP_REQ_SIZE_CONFIG__DPTE_GROUP_SIZE__SHIFT                                                  0x14
#define HUBP0_DCHUBP_REQ_SIZE_CONFIG__MPTE_GROUP_SIZE__SHIFT                                                  0x18
#define HUBP0_DCHUBP_REQ_SIZE_CONFIG__SWATH_HEIGHT_MASK                                                       0x00000007L
#define HUBP0_DCHUBP_REQ_SIZE_CONFIG__PTE_ROW_HEIGHT_LINEAR_MASK                                              0x00000070L
#define HUBP0_DCHUBP_REQ_SIZE_CONFIG__CHUNK_SIZE_MASK                                                         0x00000700L
#define HUBP0_DCHUBP_REQ_SIZE_CONFIG__MIN_CHUNK_SIZE_MASK                                                     0x00001800L
#define HUBP0_DCHUBP_REQ_SIZE_CONFIG__META_CHUNK_SIZE_MASK                                                    0x00030000L
#define HUBP0_DCHUBP_REQ_SIZE_CONFIG__MIN_META_CHUNK_SIZE_MASK                                                0x000C0000L
#define HUBP0_DCHUBP_REQ_SIZE_CONFIG__DPTE_GROUP_SIZE_MASK                                                    0x00700000L
#define HUBP0_DCHUBP_REQ_SIZE_CONFIG__MPTE_GROUP_SIZE_MASK                                                    0x07000000L
//HUBP0_DCHUBP_REQ_SIZE_CONFIG_C
#define HUBP0_DCHUBP_REQ_SIZE_CONFIG_C__SWATH_HEIGHT_C__SHIFT                                                 0x0
#define HUBP0_DCHUBP_REQ_SIZE_CONFIG_C__PTE_ROW_HEIGHT_LINEAR_C__SHIFT                                        0x4
#define HUBP0_DCHUBP_REQ_SIZE_CONFIG_C__CHUNK_SIZE_C__SHIFT                                                   0x8
#define HUBP0_DCHUBP_REQ_SIZE_CONFIG_C__MIN_CHUNK_SIZE_C__SHIFT                                               0xb
#define HUBP0_DCHUBP_REQ_SIZE_CONFIG_C__META_CHUNK_SIZE_C__SHIFT                                              0x10
#define HUBP0_DCHUBP_REQ_SIZE_CONFIG_C__MIN_META_CHUNK_SIZE_C__SHIFT                                          0x12
#define HUBP0_DCHUBP_REQ_SIZE_CONFIG_C__DPTE_GROUP_SIZE_C__SHIFT                                              0x14
#define HUBP0_DCHUBP_REQ_SIZE_CONFIG_C__MPTE_GROUP_SIZE_C__SHIFT                                              0x18
#define HUBP0_DCHUBP_REQ_SIZE_CONFIG_C__SWATH_HEIGHT_C_MASK                                                   0x00000007L
#define HUBP0_DCHUBP_REQ_SIZE_CONFIG_C__PTE_ROW_HEIGHT_LINEAR_C_MASK                                          0x00000070L
#define HUBP0_DCHUBP_REQ_SIZE_CONFIG_C__CHUNK_SIZE_C_MASK                                                     0x00000700L
#define HUBP0_DCHUBP_REQ_SIZE_CONFIG_C__MIN_CHUNK_SIZE_C_MASK                                                 0x00001800L
#define HUBP0_DCHUBP_REQ_SIZE_CONFIG_C__META_CHUNK_SIZE_C_MASK                                                0x00030000L
#define HUBP0_DCHUBP_REQ_SIZE_CONFIG_C__MIN_META_CHUNK_SIZE_C_MASK                                            0x000C0000L
#define HUBP0_DCHUBP_REQ_SIZE_CONFIG_C__DPTE_GROUP_SIZE_C_MASK                                                0x00700000L
#define HUBP0_DCHUBP_REQ_SIZE_CONFIG_C__MPTE_GROUP_SIZE_C_MASK                                                0x07000000L
//HUBP0_DCHUBP_CNTL
#define HUBP0_DCHUBP_CNTL__HUBP_BLANK_EN__SHIFT                                                               0x0
#define HUBP0_DCHUBP_CNTL__HUBP_NO_OUTSTANDING_REQ__SHIFT                                                     0x1
#define HUBP0_DCHUBP_CNTL__HUBP_DISABLE__SHIFT                                                                0x2
#define HUBP0_DCHUBP_CNTL__HUBP_IN_BLANK__SHIFT                                                               0x3
#define HUBP0_DCHUBP_CNTL__HUBP_VTG_SEL__SHIFT                                                                0x4
#define HUBP0_DCHUBP_CNTL__HUBP_TTU_DISABLE__SHIFT                                                            0xc
#define HUBP0_DCHUBP_CNTL__HUBP_TTU_MODE__SHIFT                                                               0xd
#define HUBP0_DCHUBP_CNTL__HUBP_UNDERFLOW_STATUS__SHIFT                                                       0x1c
#define HUBP0_DCHUBP_CNTL__HUBP_UNDERFLOW_CLEAR__SHIFT                                                        0x1f
#define HUBP0_DCHUBP_CNTL__HUBP_BLANK_EN_MASK                                                                 0x00000001L
#define HUBP0_DCHUBP_CNTL__HUBP_NO_OUTSTANDING_REQ_MASK                                                       0x00000002L
#define HUBP0_DCHUBP_CNTL__HUBP_DISABLE_MASK                                                                  0x00000004L
#define HUBP0_DCHUBP_CNTL__HUBP_IN_BLANK_MASK                                                                 0x00000008L
#define HUBP0_DCHUBP_CNTL__HUBP_VTG_SEL_MASK                                                                  0x000000F0L
#define HUBP0_DCHUBP_CNTL__HUBP_TTU_DISABLE_MASK                                                              0x00001000L
#define HUBP0_DCHUBP_CNTL__HUBP_TTU_MODE_MASK                                                                 0x0000E000L
#define HUBP0_DCHUBP_CNTL__HUBP_UNDERFLOW_STATUS_MASK                                                         0x70000000L
#define HUBP0_DCHUBP_CNTL__HUBP_UNDERFLOW_CLEAR_MASK                                                          0x80000000L
//HUBP0_HUBP_CLK_CNTL
#define HUBP0_HUBP_CLK_CNTL__HUBP_CLOCK_ENABLE__SHIFT                                                         0x0
#define HUBP0_HUBP_CLK_CNTL__HUBP_DISPCLK_R_GATE_DIS__SHIFT                                                   0x4
#define HUBP0_HUBP_CLK_CNTL__HUBP_DPPCLK_G_GATE_DIS__SHIFT                                                    0x8
#define HUBP0_HUBP_CLK_CNTL__HUBP_DCFCLK_R_GATE_DIS__SHIFT                                                    0xc
#define HUBP0_HUBP_CLK_CNTL__HUBP_DCFCLK_G_GATE_DIS__SHIFT                                                    0x10
#define HUBP0_HUBP_CLK_CNTL__HUBP_DISPCLK_R_CLOCK_ON__SHIFT                                                   0x14
#define HUBP0_HUBP_CLK_CNTL__HUBP_DPPCLK_G_CLOCK_ON__SHIFT                                                    0x15
#define HUBP0_HUBP_CLK_CNTL__HUBP_DCFCLK_R_CLOCK_ON__SHIFT                                                    0x16
#define HUBP0_HUBP_CLK_CNTL__HUBP_DCFCLK_G_CLOCK_ON__SHIFT                                                    0x17
#define HUBP0_HUBP_CLK_CNTL__HUBP_TEST_CLK_SEL__SHIFT                                                         0x1c
#define HUBP0_HUBP_CLK_CNTL__HUBP_CLOCK_ENABLE_MASK                                                           0x00000001L
#define HUBP0_HUBP_CLK_CNTL__HUBP_DISPCLK_R_GATE_DIS_MASK                                                     0x00000010L
#define HUBP0_HUBP_CLK_CNTL__HUBP_DPPCLK_G_GATE_DIS_MASK                                                      0x00000100L
#define HUBP0_HUBP_CLK_CNTL__HUBP_DCFCLK_R_GATE_DIS_MASK                                                      0x00001000L
#define HUBP0_HUBP_CLK_CNTL__HUBP_DCFCLK_G_GATE_DIS_MASK                                                      0x00010000L
#define HUBP0_HUBP_CLK_CNTL__HUBP_DISPCLK_R_CLOCK_ON_MASK                                                     0x00100000L
#define HUBP0_HUBP_CLK_CNTL__HUBP_DPPCLK_G_CLOCK_ON_MASK                                                      0x00200000L
#define HUBP0_HUBP_CLK_CNTL__HUBP_DCFCLK_R_CLOCK_ON_MASK                                                      0x00400000L
#define HUBP0_HUBP_CLK_CNTL__HUBP_DCFCLK_G_CLOCK_ON_MASK                                                      0x00800000L
#define HUBP0_HUBP_CLK_CNTL__HUBP_TEST_CLK_SEL_MASK                                                           0xF0000000L
//HUBP0_DCHUBP_VMPG_CONFIG
#define HUBP0_DCHUBP_VMPG_CONFIG__VMPG_SIZE__SHIFT                                                            0x0
#define HUBP0_DCHUBP_VMPG_CONFIG__VMPG_SIZE_MASK                                                              0x00000001L
//HUBP0_HUBPREQ_DEBUG_DB
#define HUBP0_HUBPREQ_DEBUG_DB__HUBPREQ_DEBUG__SHIFT                                                          0x0
#define HUBP0_HUBPREQ_DEBUG_DB__HUBPREQ_DEBUG_MASK                                                            0xFFFFFFFFL
//HUBP0_HUBP_MEASURE_WIN_CTRL_DCFCLK
#define HUBP0_HUBP_MEASURE_WIN_CTRL_DCFCLK__HUBP_MEASURE_WIN_EN_DCFCLK__SHIFT                                 0x0
#define HUBP0_HUBP_MEASURE_WIN_CTRL_DCFCLK__HUBP_MEASURE_WIN_PERIOD_M1_DCFCLK__SHIFT                          0x4
#define HUBP0_HUBP_MEASURE_WIN_CTRL_DCFCLK__HUBP_PERFMON_START_SEL_DCFCLK__SHIFT                              0xc
#define HUBP0_HUBP_MEASURE_WIN_CTRL_DCFCLK__HUBP_PERFMON_STOP_SEL_DCFCLK__SHIFT                               0x14
#define HUBP0_HUBP_MEASURE_WIN_CTRL_DCFCLK__HUBP_MEASURE_WIN_MODE_DCFCLK__SHIFT                               0x1c
#define HUBP0_HUBP_MEASURE_WIN_CTRL_DCFCLK__HUBP_MEASURE_WIN_EN_DCFCLK_MASK                                   0x00000001L
#define HUBP0_HUBP_MEASURE_WIN_CTRL_DCFCLK__HUBP_MEASURE_WIN_PERIOD_M1_DCFCLK_MASK                            0x00000FF0L
#define HUBP0_HUBP_MEASURE_WIN_CTRL_DCFCLK__HUBP_PERFMON_START_SEL_DCFCLK_MASK                                0x0001F000L
#define HUBP0_HUBP_MEASURE_WIN_CTRL_DCFCLK__HUBP_PERFMON_STOP_SEL_DCFCLK_MASK                                 0x01F00000L
#define HUBP0_HUBP_MEASURE_WIN_CTRL_DCFCLK__HUBP_MEASURE_WIN_MODE_DCFCLK_MASK                                 0x30000000L
//HUBP0_HUBP_MEASURE_WIN_CTRL_DPPCLK
#define HUBP0_HUBP_MEASURE_WIN_CTRL_DPPCLK__HUBP_MEASURE_WIN_EN_DPPCLK__SHIFT                                 0x0
#define HUBP0_HUBP_MEASURE_WIN_CTRL_DPPCLK__HUBP_MEASURE_WIN_SRC_SEL_DPPCLK__SHIFT                            0x1
#define HUBP0_HUBP_MEASURE_WIN_CTRL_DPPCLK__HUBP_MEASURE_WIN_PERIOD_M1_DPPCLK__SHIFT                          0x4
#define HUBP0_HUBP_MEASURE_WIN_CTRL_DPPCLK__HUBP_PERFMON_START_SEL_DPPCLK__SHIFT                              0xc
#define HUBP0_HUBP_MEASURE_WIN_CTRL_DPPCLK__HUBP_PERFMON_STOP_SEL_DPPCLK__SHIFT                               0x14
#define HUBP0_HUBP_MEASURE_WIN_CTRL_DPPCLK__HUBP_MEASURE_WIN_EN_DPPCLK_MASK                                   0x00000001L
#define HUBP0_HUBP_MEASURE_WIN_CTRL_DPPCLK__HUBP_MEASURE_WIN_SRC_SEL_DPPCLK_MASK                              0x00000002L
#define HUBP0_HUBP_MEASURE_WIN_CTRL_DPPCLK__HUBP_MEASURE_WIN_PERIOD_M1_DPPCLK_MASK                            0x00000FF0L
#define HUBP0_HUBP_MEASURE_WIN_CTRL_DPPCLK__HUBP_PERFMON_START_SEL_DPPCLK_MASK                                0x0001F000L
#define HUBP0_HUBP_MEASURE_WIN_CTRL_DPPCLK__HUBP_PERFMON_STOP_SEL_DPPCLK_MASK                                 0x01F00000L


// addressBlock: dce_dc_dcbubp0_dispdec_hubpreq_dispdec
//HUBPREQ0_DCSURF_SURFACE_PITCH
#define HUBPREQ0_DCSURF_SURFACE_PITCH__PITCH__SHIFT                                                           0x0
#define HUBPREQ0_DCSURF_SURFACE_PITCH__META_PITCH__SHIFT                                                      0x10
#define HUBPREQ0_DCSURF_SURFACE_PITCH__PITCH_MASK                                                             0x00003FFFL
#define HUBPREQ0_DCSURF_SURFACE_PITCH__META_PITCH_MASK                                                        0x3FFF0000L
//HUBPREQ0_DCSURF_SURFACE_PITCH_C
#define HUBPREQ0_DCSURF_SURFACE_PITCH_C__PITCH_C__SHIFT                                                       0x0
#define HUBPREQ0_DCSURF_SURFACE_PITCH_C__META_PITCH_C__SHIFT                                                  0x10
#define HUBPREQ0_DCSURF_SURFACE_PITCH_C__PITCH_C_MASK                                                         0x00003FFFL
#define HUBPREQ0_DCSURF_SURFACE_PITCH_C__META_PITCH_C_MASK                                                    0x3FFF0000L
//HUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS
#define HUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS__PRIMARY_SURFACE_ADDRESS__SHIFT                               0x0
#define HUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS__PRIMARY_SURFACE_ADDRESS_MASK                                 0xFFFFFFFFL
//HUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH
#define HUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH__PRIMARY_SURFACE_ADDRESS_HIGH__SHIFT                     0x0
#define HUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH__PRIMARY_SURFACE_ADDRESS_HIGH_MASK                       0x0000FFFFL
//HUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS_C
#define HUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS_C__PRIMARY_SURFACE_ADDRESS_C__SHIFT                           0x0
#define HUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS_C__PRIMARY_SURFACE_ADDRESS_C_MASK                             0xFFFFFFFFL
//HUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_C
#define HUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_C__PRIMARY_SURFACE_ADDRESS_HIGH_C__SHIFT                 0x0
#define HUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_C__PRIMARY_SURFACE_ADDRESS_HIGH_C_MASK                   0x0000FFFFL
//HUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS
#define HUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS__SECONDARY_SURFACE_ADDRESS__SHIFT                           0x0
#define HUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS__SECONDARY_SURFACE_ADDRESS_MASK                             0xFFFFFFFFL
//HUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH
#define HUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH__SECONDARY_SURFACE_ADDRESS_HIGH__SHIFT                 0x0
#define HUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH__SECONDARY_SURFACE_ADDRESS_HIGH_MASK                   0x0000FFFFL
//HUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS_C
#define HUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS_C__SECONDARY_SURFACE_ADDRESS_C__SHIFT                       0x0
#define HUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS_C__SECONDARY_SURFACE_ADDRESS_C_MASK                         0xFFFFFFFFL
//HUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_C
#define HUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_C__SECONDARY_SURFACE_ADDRESS_HIGH_C__SHIFT             0x0
#define HUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_C__SECONDARY_SURFACE_ADDRESS_HIGH_C_MASK               0x0000FFFFL
//HUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS
#define HUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS__PRIMARY_META_SURFACE_ADDRESS__SHIFT                     0x0
#define HUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS__PRIMARY_META_SURFACE_ADDRESS_MASK                       0xFFFFFFFFL
//HUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH
#define HUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH__PRIMARY_META_SURFACE_ADDRESS_HIGH__SHIFT           0x0
#define HUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH__PRIMARY_META_SURFACE_ADDRESS_HIGH_MASK             0x0000FFFFL
//HUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS_C
#define HUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS_C__PRIMARY_META_SURFACE_ADDRESS_C__SHIFT                 0x0
#define HUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS_C__PRIMARY_META_SURFACE_ADDRESS_C_MASK                   0xFFFFFFFFL
//HUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_C
#define HUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_C__PRIMARY_META_SURFACE_ADDRESS_HIGH_C__SHIFT       0x0
#define HUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_C__PRIMARY_META_SURFACE_ADDRESS_HIGH_C_MASK         0x0000FFFFL
//HUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS
#define HUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS__SECONDARY_META_SURFACE_ADDRESS__SHIFT                 0x0
#define HUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS__SECONDARY_META_SURFACE_ADDRESS_MASK                   0xFFFFFFFFL
//HUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH
#define HUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH__SECONDARY_META_SURFACE_ADDRESS_HIGH__SHIFT       0x0
#define HUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH__SECONDARY_META_SURFACE_ADDRESS_HIGH_MASK         0x0000FFFFL
//HUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS_C
#define HUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS_C__SECONDARY_META_SURFACE_ADDRESS_C__SHIFT             0x0
#define HUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS_C__SECONDARY_META_SURFACE_ADDRESS_C_MASK               0xFFFFFFFFL
//HUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_C
#define HUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_C__SECONDARY_META_SURFACE_ADDRESS_HIGH_C__SHIFT   0x0
#define HUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_C__SECONDARY_META_SURFACE_ADDRESS_HIGH_C_MASK     0x0000FFFFL
//HUBPREQ0_DCSURF_SURFACE_CONTROL
#define HUBPREQ0_DCSURF_SURFACE_CONTROL__PRIMARY_SURFACE_TMZ__SHIFT                                           0x0
#define HUBPREQ0_DCSURF_SURFACE_CONTROL__PRIMARY_SURFACE_DCC_EN__SHIFT                                        0x1
#define HUBPREQ0_DCSURF_SURFACE_CONTROL__PRIMARY_SURFACE_DCC_IND_64B_BLK__SHIFT                               0x2
#define HUBPREQ0_DCSURF_SURFACE_CONTROL__PRIMARY_SURFACE_TMZ_C__SHIFT                                         0x4
#define HUBPREQ0_DCSURF_SURFACE_CONTROL__PRIMARY_SURFACE_DCC_IND_64B_BLK_C__SHIFT                             0x5
#define HUBPREQ0_DCSURF_SURFACE_CONTROL__SECONDARY_SURFACE_TMZ__SHIFT                                         0x8
#define HUBPREQ0_DCSURF_SURFACE_CONTROL__SECONDARY_SURFACE_DCC_EN__SHIFT                                      0x9
#define HUBPREQ0_DCSURF_SURFACE_CONTROL__SECONDARY_SURFACE_DCC_IND_64B_BLK__SHIFT                             0xa
#define HUBPREQ0_DCSURF_SURFACE_CONTROL__SECONDARY_SURFACE_TMZ_C__SHIFT                                       0xc
#define HUBPREQ0_DCSURF_SURFACE_CONTROL__SECONDARY_SURFACE_DCC_IND_64B_BLK_C__SHIFT                           0xd
#define HUBPREQ0_DCSURF_SURFACE_CONTROL__PRIMARY_META_SURFACE_TMZ__SHIFT                                      0x10
#define HUBPREQ0_DCSURF_SURFACE_CONTROL__PRIMARY_META_SURFACE_TMZ_C__SHIFT                                    0x14
#define HUBPREQ0_DCSURF_SURFACE_CONTROL__SECONDARY_META_SURFACE_TMZ__SHIFT                                    0x18
#define HUBPREQ0_DCSURF_SURFACE_CONTROL__SECONDARY_META_SURFACE_TMZ_C__SHIFT                                  0x1c
#define HUBPREQ0_DCSURF_SURFACE_CONTROL__PRIMARY_SURFACE_TMZ_MASK                                             0x00000001L
#define HUBPREQ0_DCSURF_SURFACE_CONTROL__PRIMARY_SURFACE_DCC_EN_MASK                                          0x00000002L
#define HUBPREQ0_DCSURF_SURFACE_CONTROL__PRIMARY_SURFACE_DCC_IND_64B_BLK_MASK                                 0x00000004L
#define HUBPREQ0_DCSURF_SURFACE_CONTROL__PRIMARY_SURFACE_TMZ_C_MASK                                           0x00000010L
#define HUBPREQ0_DCSURF_SURFACE_CONTROL__PRIMARY_SURFACE_DCC_IND_64B_BLK_C_MASK                               0x00000020L
#define HUBPREQ0_DCSURF_SURFACE_CONTROL__SECONDARY_SURFACE_TMZ_MASK                                           0x00000100L
#define HUBPREQ0_DCSURF_SURFACE_CONTROL__SECONDARY_SURFACE_DCC_EN_MASK                                        0x00000200L
#define HUBPREQ0_DCSURF_SURFACE_CONTROL__SECONDARY_SURFACE_DCC_IND_64B_BLK_MASK                               0x00000400L
#define HUBPREQ0_DCSURF_SURFACE_CONTROL__SECONDARY_SURFACE_TMZ_C_MASK                                         0x00001000L
#define HUBPREQ0_DCSURF_SURFACE_CONTROL__SECONDARY_SURFACE_DCC_IND_64B_BLK_C_MASK                             0x00002000L
#define HUBPREQ0_DCSURF_SURFACE_CONTROL__PRIMARY_META_SURFACE_TMZ_MASK                                        0x00010000L
#define HUBPREQ0_DCSURF_SURFACE_CONTROL__PRIMARY_META_SURFACE_TMZ_C_MASK                                      0x00100000L
#define HUBPREQ0_DCSURF_SURFACE_CONTROL__SECONDARY_META_SURFACE_TMZ_MASK                                      0x01000000L
#define HUBPREQ0_DCSURF_SURFACE_CONTROL__SECONDARY_META_SURFACE_TMZ_C_MASK                                    0x10000000L
//HUBPREQ0_DCSURF_FLIP_CONTROL
#define HUBPREQ0_DCSURF_FLIP_CONTROL__SURFACE_UPDATE_LOCK__SHIFT                                              0x0
#define HUBPREQ0_DCSURF_FLIP_CONTROL__SURFACE_FLIP_TYPE__SHIFT                                                0x1
#define HUBPREQ0_DCSURF_FLIP_CONTROL__SURFACE_FLIP_VUPDATE_SKIP_NUM__SHIFT                                    0x4
#define HUBPREQ0_DCSURF_FLIP_CONTROL__SURFACE_FLIP_MODE_FOR_STEREOSYNC__SHIFT                                 0xc
#define HUBPREQ0_DCSURF_FLIP_CONTROL__SURFACE_FLIP_IN_STEREOSYNC__SHIFT                                       0x10
#define HUBPREQ0_DCSURF_FLIP_CONTROL__SURFACE_FLIP_STEREO_SELECT_DISABLE__SHIFT                               0x11
#define HUBPREQ0_DCSURF_FLIP_CONTROL__SURFACE_FLIP_STEREO_SELECT_POLARITY__SHIFT                              0x12
#define HUBPREQ0_DCSURF_FLIP_CONTROL__SURFACE_FLIP_PENDING_DELAY__SHIFT                                       0x14
#define HUBPREQ0_DCSURF_FLIP_CONTROL__SURFACE_UPDATE_PENDING__SHIFT                                           0x1e
#define HUBPREQ0_DCSURF_FLIP_CONTROL__SURFACE_FLIP_PENDING__SHIFT                                             0x1f
#define HUBPREQ0_DCSURF_FLIP_CONTROL__SURFACE_UPDATE_LOCK_MASK                                                0x00000001L
#define HUBPREQ0_DCSURF_FLIP_CONTROL__SURFACE_FLIP_TYPE_MASK                                                  0x00000002L
#define HUBPREQ0_DCSURF_FLIP_CONTROL__SURFACE_FLIP_VUPDATE_SKIP_NUM_MASK                                      0x000000F0L
#define HUBPREQ0_DCSURF_FLIP_CONTROL__SURFACE_FLIP_MODE_FOR_STEREOSYNC_MASK                                   0x00003000L
#define HUBPREQ0_DCSURF_FLIP_CONTROL__SURFACE_FLIP_IN_STEREOSYNC_MASK                                         0x00010000L
#define HUBPREQ0_DCSURF_FLIP_CONTROL__SURFACE_FLIP_STEREO_SELECT_DISABLE_MASK                                 0x00020000L
#define HUBPREQ0_DCSURF_FLIP_CONTROL__SURFACE_FLIP_STEREO_SELECT_POLARITY_MASK                                0x00040000L
#define HUBPREQ0_DCSURF_FLIP_CONTROL__SURFACE_FLIP_PENDING_DELAY_MASK                                         0x3FF00000L
#define HUBPREQ0_DCSURF_FLIP_CONTROL__SURFACE_UPDATE_PENDING_MASK                                             0x40000000L
#define HUBPREQ0_DCSURF_FLIP_CONTROL__SURFACE_FLIP_PENDING_MASK                                               0x80000000L
//HUBPREQ0_DCSURF_FLIP_CONTROL2
#define HUBPREQ0_DCSURF_FLIP_CONTROL2__SURFACE_UPDATE_FLIP_PENDING_MIN_TIME__SHIFT                            0x0
#define HUBPREQ0_DCSURF_FLIP_CONTROL2__SURFACE_UPDATE_PENDING_HIGH_EXTEND_ENABLE__SHIFT                       0xc
#define HUBPREQ0_DCSURF_FLIP_CONTROL2__SURFACE_FLIP_PENDING_HIGH_EXTEND_ENABLE__SHIFT                         0xd
#define HUBPREQ0_DCSURF_FLIP_CONTROL2__SURFACE_UPDATE_FLIP_PENDING_MIN_TIME_MASK                              0x000000FFL
#define HUBPREQ0_DCSURF_FLIP_CONTROL2__SURFACE_UPDATE_PENDING_HIGH_EXTEND_ENABLE_MASK                         0x00001000L
#define HUBPREQ0_DCSURF_FLIP_CONTROL2__SURFACE_FLIP_PENDING_HIGH_EXTEND_ENABLE_MASK                           0x00002000L
//HUBPREQ0_DCSURF_FRAME_PACING_CONTROL
#define HUBPREQ0_DCSURF_FRAME_PACING_CONTROL__SURFACE_FRAME_PACING_ENABLE__SHIFT                              0x0
#define HUBPREQ0_DCSURF_FRAME_PACING_CONTROL__SURFACE_FRAME_PACING_MODE__SHIFT                                0x1
#define HUBPREQ0_DCSURF_FRAME_PACING_CONTROL__SURFACE_FRAME_PACING_QUEUE_RESET__SHIFT                         0x8
#define HUBPREQ0_DCSURF_FRAME_PACING_CONTROL__SURFACE_FRAME_PACING_QUEUE_FREE_ENTRY__SHIFT                    0x18
#define HUBPREQ0_DCSURF_FRAME_PACING_CONTROL__SURFACE_FRAME_PACING_ENABLE_MASK                                0x00000001L
#define HUBPREQ0_DCSURF_FRAME_PACING_CONTROL__SURFACE_FRAME_PACING_MODE_MASK                                  0x00000002L
#define HUBPREQ0_DCSURF_FRAME_PACING_CONTROL__SURFACE_FRAME_PACING_QUEUE_RESET_MASK                           0x00000100L
#define HUBPREQ0_DCSURF_FRAME_PACING_CONTROL__SURFACE_FRAME_PACING_QUEUE_FREE_ENTRY_MASK                      0x07000000L
//HUBPREQ0_DCSURF_FRAME_PACING_TIME
#define HUBPREQ0_DCSURF_FRAME_PACING_TIME__SURFACE_FRAME_PACING_TIME__SHIFT                                   0x0
#define HUBPREQ0_DCSURF_FRAME_PACING_TIME__SURFACE_FRAME_PACING_TIME_MASK                                     0xFFFFFFFFL
//HUBPREQ0_DCSURF_SURFACE_FLIP_INTERRUPT
#define HUBPREQ0_DCSURF_SURFACE_FLIP_INTERRUPT__SURFACE_FLIP_INT_MASK__SHIFT                                  0x0
#define HUBPREQ0_DCSURF_SURFACE_FLIP_INTERRUPT__SURFACE_FLIP_INT_TYPE__SHIFT                                  0x1
#define HUBPREQ0_DCSURF_SURFACE_FLIP_INTERRUPT__SURFACE_FLIP_AWAY_INT_MASK__SHIFT                             0x2
#define HUBPREQ0_DCSURF_SURFACE_FLIP_INTERRUPT__SURFACE_FLIP_AWAY_INT_TYPE__SHIFT                             0x3
#define HUBPREQ0_DCSURF_SURFACE_FLIP_INTERRUPT__SURFACE_FLIP_CLEAR__SHIFT                                     0x8
#define HUBPREQ0_DCSURF_SURFACE_FLIP_INTERRUPT__SURFACE_FLIP_AWAY_CLEAR__SHIFT                                0x9
#define HUBPREQ0_DCSURF_SURFACE_FLIP_INTERRUPT__SURFACE_FLIP_OCCURRED__SHIFT                                  0x10
#define HUBPREQ0_DCSURF_SURFACE_FLIP_INTERRUPT__SURFACE_FLIP_INT_STATUS__SHIFT                                0x11
#define HUBPREQ0_DCSURF_SURFACE_FLIP_INTERRUPT__SURFACE_FLIP_AWAY_OCCURRED__SHIFT                             0x12
#define HUBPREQ0_DCSURF_SURFACE_FLIP_INTERRUPT__SURFACE_FLIP_AWAY_INT_STATUS__SHIFT                           0x13
#define HUBPREQ0_DCSURF_SURFACE_FLIP_INTERRUPT__SURFACE_FLIP_INT_MASK_MASK                                    0x00000001L
#define HUBPREQ0_DCSURF_SURFACE_FLIP_INTERRUPT__SURFACE_FLIP_INT_TYPE_MASK                                    0x00000002L
#define HUBPREQ0_DCSURF_SURFACE_FLIP_INTERRUPT__SURFACE_FLIP_AWAY_INT_MASK_MASK                               0x00000004L
#define HUBPREQ0_DCSURF_SURFACE_FLIP_INTERRUPT__SURFACE_FLIP_AWAY_INT_TYPE_MASK                               0x00000008L
#define HUBPREQ0_DCSURF_SURFACE_FLIP_INTERRUPT__SURFACE_FLIP_CLEAR_MASK                                       0x00000100L
#define HUBPREQ0_DCSURF_SURFACE_FLIP_INTERRUPT__SURFACE_FLIP_AWAY_CLEAR_MASK                                  0x00000200L
#define HUBPREQ0_DCSURF_SURFACE_FLIP_INTERRUPT__SURFACE_FLIP_OCCURRED_MASK                                    0x00010000L
#define HUBPREQ0_DCSURF_SURFACE_FLIP_INTERRUPT__SURFACE_FLIP_INT_STATUS_MASK                                  0x00020000L
#define HUBPREQ0_DCSURF_SURFACE_FLIP_INTERRUPT__SURFACE_FLIP_AWAY_OCCURRED_MASK                               0x00040000L
#define HUBPREQ0_DCSURF_SURFACE_FLIP_INTERRUPT__SURFACE_FLIP_AWAY_INT_STATUS_MASK                             0x00080000L
//HUBPREQ0_DCSURF_SURFACE_INUSE
#define HUBPREQ0_DCSURF_SURFACE_INUSE__SURFACE_INUSE_ADDRESS__SHIFT                                           0x0
#define HUBPREQ0_DCSURF_SURFACE_INUSE__SURFACE_INUSE_ADDRESS_MASK                                             0xFFFFFFFFL
//HUBPREQ0_DCSURF_SURFACE_INUSE_HIGH
#define HUBPREQ0_DCSURF_SURFACE_INUSE_HIGH__SURFACE_INUSE_ADDRESS_HIGH__SHIFT                                 0x0
#define HUBPREQ0_DCSURF_SURFACE_INUSE_HIGH__SURFACE_INUSE_ADDRESS_HIGH_MASK                                   0x0000FFFFL
//HUBPREQ0_DCSURF_SURFACE_INUSE_C
#define HUBPREQ0_DCSURF_SURFACE_INUSE_C__SURFACE_INUSE_ADDRESS_C__SHIFT                                       0x0
#define HUBPREQ0_DCSURF_SURFACE_INUSE_C__SURFACE_INUSE_ADDRESS_C_MASK                                         0xFFFFFFFFL
//HUBPREQ0_DCSURF_SURFACE_INUSE_HIGH_C
#define HUBPREQ0_DCSURF_SURFACE_INUSE_HIGH_C__SURFACE_INUSE_ADDRESS_HIGH_C__SHIFT                             0x0
#define HUBPREQ0_DCSURF_SURFACE_INUSE_HIGH_C__SURFACE_INUSE_ADDRESS_HIGH_C_MASK                               0x0000FFFFL
//HUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE
#define HUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE__SURFACE_EARLIEST_INUSE_ADDRESS__SHIFT                         0x0
#define HUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE__SURFACE_EARLIEST_INUSE_ADDRESS_MASK                           0xFFFFFFFFL
//HUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE_HIGH
#define HUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE_HIGH__SURFACE_EARLIEST_INUSE_ADDRESS_HIGH__SHIFT               0x0
#define HUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE_HIGH__SURFACE_EARLIEST_INUSE_ADDRESS_HIGH_MASK                 0x0000FFFFL
//HUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE_C
#define HUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE_C__SURFACE_EARLIEST_INUSE_ADDRESS_C__SHIFT                     0x0
#define HUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE_C__SURFACE_EARLIEST_INUSE_ADDRESS_C_MASK                       0xFFFFFFFFL
//HUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_C
#define HUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_C__SURFACE_EARLIEST_INUSE_ADDRESS_HIGH_C__SHIFT           0x0
#define HUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_C__SURFACE_EARLIEST_INUSE_ADDRESS_HIGH_C_MASK             0x0000FFFFL
//HUBPREQ0_DCN_EXPANSION_MODE
#define HUBPREQ0_DCN_EXPANSION_MODE__DRQ_EXPANSION_MODE__SHIFT                                                0x0
#define HUBPREQ0_DCN_EXPANSION_MODE__CRQ_EXPANSION_MODE__SHIFT                                                0x2
#define HUBPREQ0_DCN_EXPANSION_MODE__MRQ_EXPANSION_MODE__SHIFT                                                0x4
#define HUBPREQ0_DCN_EXPANSION_MODE__PRQ_EXPANSION_MODE__SHIFT                                                0x6
#define HUBPREQ0_DCN_EXPANSION_MODE__DRQ_EXPANSION_MODE_MASK                                                  0x00000003L
#define HUBPREQ0_DCN_EXPANSION_MODE__CRQ_EXPANSION_MODE_MASK                                                  0x0000000CL
#define HUBPREQ0_DCN_EXPANSION_MODE__MRQ_EXPANSION_MODE_MASK                                                  0x00000030L
#define HUBPREQ0_DCN_EXPANSION_MODE__PRQ_EXPANSION_MODE_MASK                                                  0x000000C0L
//HUBPREQ0_DCN_TTU_QOS_WM
#define HUBPREQ0_DCN_TTU_QOS_WM__QoS_LEVEL_LOW_WM__SHIFT                                                      0x0
#define HUBPREQ0_DCN_TTU_QOS_WM__QoS_LEVEL_HIGH_WM__