/*	$NetBSD: octeon_gpioreg.h,v 1.2 2020/06/22 03:05:07 simonb Exp $	*/

/*
 * Copyright (c) 2007 Internet Initiative Japan, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * GPIO Registers
 */

#ifndef _OCTEON_GPIOREG_H_
#define _OCTEON_GPIOREG_H_

#define	GPIO_BIT_CFG0				0x0001070000000800ULL
#define	GPIO_BIT_CFG1				0x0001070000000808ULL
#define	GPIO_BIT_CFG2				0x0001070000000810ULL
#define	GPIO_BIT_CFG3				0x0001070000000818ULL
#define	GPIO_BIT_CFG4				0x0001070000000820ULL
#define	GPIO_BIT_CFG5				0x0001070000000828ULL
#define	GPIO_BIT_CFG6				0x0001070000000830ULL
#define	GPIO_BIT_CFG7				0x0001070000000838ULL
#define	GPIO_BIT_CFG8				0x0001070000000840ULL
#define	GPIO_BIT_CFG9				0x0001070000000848ULL
#define	GPIO_BIT_CFG10				0x0001070000000850ULL
#define	GPIO_BIT_CFG11				0x0001070000000858ULL
#define	GPIO_BIT_CFG12				0x0001070000000860ULL
#define	GPIO_BIT_CFG13				0x0001070000000868ULL
#define	GPIO_BIT_CFG14				0x0001070000000870ULL
#define	GPIO_BIT_CFG15				0x0001070000000878ULL
#define	GPIO_RX_DAT				0x0001070000000880ULL
#define	GPIO_TX_SET				0x0001070000000888ULL
#define	GPIO_TX_CLR				0x0001070000000890ULL
#define	GPIO_INT_CLR				0x0001070000000898ULL
#define	GPIO_DBG_ENA				0x00010700000008a0ULL
#define	GPIO_BOOT_ENA				0x00010700000008a8ULL
#define	GPIO_XBIT_CFG16				0x0001070000000900ULL
#define	GPIO_XBIT_CFG17				0x0001070000000908ULL
#define	GPIO_XBIT_CFG18				0x0001070000000910ULL
#define	GPIO_XBIT_CFG19				0x0001070000000918ULL
#define	GPIO_XBIT_CFG20				0x0001070000000920ULL
#define	GPIO_XBIT_CFG21				0x0001070000000928ULL
#define	GPIO_XBIT_CFG22				0x0001070000000930ULL
#define	GPIO_XBIT_CFG23				0x0001070000000938ULL

#define	GPIO_BIT_CFG_XXX_63_12			UINT64_C(0xfffffffffffff000)
#define	GPIO_BIT_CFG_FIL_SEL			UINT64_C(0x0000000000000f00)
#define	GPIO_BIT_CFG_FIL_CNT			UINT64_C(0x00000000000000f0)
#define	GPIO_BIT_CFG_INT_TYPE			UINT64_C(0x0000000000000008)
#define	GPIO_BIT_CFG_INT_EN			UINT64_C(0x0000000000000004)
#define	GPIO_BIT_CFG_RX_XOR			UINT64_C(0x0000000000000002)
#define	GPIO_BIT_CFG_TX_OE			UINT64_C(0x0000000000000001)

/* XXX */

/* ---- bus_space */

#define	GPIO_BASE				0x0001070000000800ULL
#define	GPIO_SIZE				0x0200

#define	GPIO_BIT_CFG0_OFFSET			0x0000
#define	GPIO_BIT_CFG1_OFFSET			0x0008
#define	GPIO_BIT_CFG2_OFFSET			0x0010
#define	GPIO_BIT_CFG3_OFFSET			0x0018
#define	GPIO_BIT_CFG4_OFFSET			0x0020
#define	GPIO_BIT_CFG5_OFFSET			0x0028
#define	GPIO_BIT_CFG6_OFFSET			0x0030
#define	GPIO_BIT_CFG7_OFFSET			0x0038
#define	GPIO_BIT_CFG8_OFFSET			0x0040
#define	GPIO_BIT_CFG9_OFFSET			0x0048
#define	GPIO_BIT_CFG10_OFFSET			0x0050
#define	GPIO_BIT_CFG11_OFFSET			0x0058
#define	GPIO_BIT_CFG12_OFFSET			0x0060
#define	GPIO_BIT_CFG13_OFFSET			0x0068
#define	GPIO_BIT_CFG14_OFFSET			0x0070
#define	GPIO_BIT_CFG15_OFFSET			0x0078
#define	GPIO_RX_DAT_OFFSET			0x0080
#define	GPIO_TX_SET_OFFSET			0x0088
#define	GPIO_TX_CLR_OFFSET			0x0090
#define	GPIO_INT_CLR_OFFSET			0x0098
#define	GPIO_DBG_ENA_OFFSET			0x00a0
#define	GPIO_BOOT_ENA_OFFSET			0x00a8
#define	GPIO_XBIT_CFG16_OFFSET			0x0100
#define	GPIO_XBIT_CFG17_OFFSET			0x0108
#define	GPIO_XBIT_CFG18_OFFSET			0x0110
#define	GPIO_XBIT_CFG19_OFFSET			0x0118
#define	GPIO_XBIT_CFG20_OFFSET			0x0120
#define	GPIO_XBIT_CFG21_OFFSET			0x0128
#define	GPIO_XBIT_CFG22_OFFSET			0x0130
#define	GPIO_XBIT_CFG23_OFFSET			0x0138

#endif /* _OCTEON_GPIOREG_H_ */
