/*	$NetBSD: bugstart.S,v 1.1 2014/11/21 20:10:28 christos Exp $	*/

#define _LOCORE
#include <machine/prom.h>
#undef _LOCORE
#include <machine/asm.h>

	.data
	.even

GLOBAL(bugargs)
	.space	MVMEPROM_ARGS_MAX*4

	.text
	.even

	.long	_C_LABEL(start) - 0x10
	.long	_C_LABEL(start)

#define	BUG_ARG(which)	_C_LABEL(bugargs) + (which)

ENTRY_NOPROFILE(_start)
ENTRY_NOPROFILE(start)
	moveml	%d0/%a0,%sp@-
	lea	_C_LABEL(edata),%a0
	movl	#_C_LABEL(end) - 4,%d0
	subl	%a0,%d0
	lsrl	#2,%d0
1:	clrl	%a0@+
	dbra	%d0,1b
	moveml	%sp@+,%d0/%a0
	movl	MVMEPROM_REG_DEVLUN, BUG_ARG(MVMEPROM_ARGS_DEVLUN)
	movl	MVMEPROM_REG_CTRLLUN, BUG_ARG(MVMEPROM_ARGS_CTRLLUN)
	movl	MVMEPROM_REG_FLAGS, BUG_ARG(MVMEPROM_ARGS_FLAGS)
	movl	MVMEPROM_REG_CTRLADDR, BUG_ARG(MVMEPROM_ARGS_CTRLADDR)
	movl	MVMEPROM_REG_ENTRY, BUG_ARG(MVMEPROM_ARGS_ENTRY)
	movl	MVMEPROM_REG_CONFBLK, BUG_ARG(MVMEPROM_ARGS_CONFBLK)
	movl	MVMEPROM_REG_NBARGSTART, BUG_ARG(MVMEPROM_ARGS_NBARGSTART)
	movl	MVMEPROM_REG_NBARGEND, BUG_ARG(MVMEPROM_ARGS_NBARGEND)
	movl	MVMEPROM_REG_ARGSTART, BUG_ARG(MVMEPROM_ARGS_ARGSTART)
	movl	MVMEPROM_REG_ARGEND, BUG_ARG(MVMEPROM_ARGS_ARGEND)
	jmp	_C_LABEL(_bugstart)

ENTRY_NOPROFILE(bugexec)
	addql	#4,%sp
	movl	BUG_ARG(MVMEPROM_ARGS_DEVLUN), MVMEPROM_REG_DEVLUN
	movl	BUG_ARG(MVMEPROM_ARGS_CTRLLUN), MVMEPROM_REG_CTRLLUN
	movl	BUG_ARG(MVMEPROM_ARGS_FLAGS), MVMEPROM_REG_FLAGS
	movl	BUG_ARG(MVMEPROM_ARGS_CTRLADDR), MVMEPROM_REG_CTRLADDR
	movl	BUG_ARG(MVMEPROM_ARGS_ENTRY), MVMEPROM_REG_ENTRY
	movl	BUG_ARG(MVMEPROM_ARGS_CONFBLK), MVMEPROM_REG_CONFBLK
	movl	BUG_ARG(MVMEPROM_ARGS_NBARGSTART), MVMEPROM_REG_NBARGSTART
	movl	BUG_ARG(MVMEPROM_ARGS_NBARGEND), MVMEPROM_REG_NBARGEND
	movl	BUG_ARG(MVMEPROM_ARGS_ARGSTART), MVMEPROM_REG_ARGSTART
	movl	BUG_ARG(MVMEPROM_ARGS_ARGEND), MVMEPROM_REG_ARGEND
ENTRY_NOPROFILE(__main)
	rts
