.\" WARNING: this man page is autogenerated. Do not edit or you will lose all your changes.
.TH XKEYBOARD-CONFIG 7 "xkeyboard-config 2.37" "X Version 11"
.SH NAME
xkeyboard-config \- XKB data description files
.SH DESCRIPTION
xkeyboard-config provides the description files for the X Keyboard
Extension (XKB) and for libxkbcommon. Typically it is
the task of the desktop environment to apply the
requested configuration. Users running an X server can also use the
setxkbmap(1) tool to apply keyboard configuration at runtime or configure XKB
settings in the xorg.conf(5).

.SH XKB DATA FILES LOAD PATHS

xkeyboard-config provides the XKB data files installed in
@xkb_base@. User-specific data files may be elsewhere but it depends on
the tool whether those files are loaded. For example, the libxkbcommon
library will by default load XKB data files from the user's home directory.
See the libxkbcommon documentation for details.

.SH THE "CUSTOM" LAYOUT

The "custom" layout is a layout that is listed as available to tools
reading the data files but is not actually provided by xkeyboard-config.
A user may save a layout specification in the @xkb_base@/symbols/custom file
and that layout will be available to most tools interacting with the
xkeyboard-config data files. This is primarily aimed at systems running X
where additional lookup paths cannot easily be added.
.PP
Because the "custom" layout is merely listed as available but not
provided by xkeyboard-config, the layout will not be overwritten on updates.

.SH MODELS
.TS
left,box;
lB lB
___
lB l.
Model	Description
pc86	Generic 86-key PC
pc101	Generic 101-key PC
pc102	Generic 102-key PC
pc104	Generic 104-key PC
pc104alt	Generic 104-key PC with L-shaped Enter key
pc105	Generic 105-key PC
dell101	Dell 101-key PC
latitude	Dell Latitude laptop
dellm65	Dell Precision M65 laptop
everex	Everex STEPnote
flexpro	Keytronic FlexPro
microsoft	Microsoft Natural
omnikey101	Northgate OmniKey 101
winbook	Winbook Model XP5
pc98	PC-98
a4techKB21	A4Tech KB-21
a4techKBS8	A4Tech KBS-8
a4_rfkb23	A4Tech Wireless Desktop RFKB-23
airkey	Acer AirKey V
azonaRF2300	Azona RF2300 Wireless Internet
scorpius	Advance Scorpius KI
brother	Brother Internet
btc5113rf	BTC 5113RF Multimedia
btc5126t	BTC 5126T
btc6301urf	BTC 6301URF
btc9000	BTC 9000
btc9000a	BTC 9000A
btc9001ah	BTC 9001AH
btc5090	BTC 5090
btc9019u	BTC 9019U
btc9116u	BTC 9116U Mini Wireless Internet and Gaming
cherryblue	Cherry Blue Line CyBo@rd
cherryblueb	Cherry CyMotion Master XPress
cherrybluea	Cherry Blue Line CyBo@rd (alt.)
cherrycyboard	Cherry CyBo@rd USB-Hub
cherrycmexpert	Cherry CyMotion Expert
cherrybunlim	Cherry B.UNLIMITED
chicony	Chicony Internet
chicony0108	Chicony KU-0108
chicony0420	Chicony KU-0420
chicony9885	Chicony KB-9885
compaqeak8	Compaq Easy Access
compaqik7	Compaq Internet (7 keys)
compaqik13	Compaq Internet (13 keys)
compaqik18	Compaq Internet (18 keys)
cymotionlinux	Cherry CyMotion Master Linux
armada	Compaq Armada laptop
presario	Compaq Presario laptop
ipaq	Compaq iPaq
dell	Dell
dellsk8125	Dell SK-8125
dellsk8135	Dell SK-8135
dellusbmm	Dell USB Multimedia
inspiron	Dell Inspiron 6000/8000 laptop
precision_m	Dell Precision M laptop
dexxa	Dexxa Wireless Desktop
diamond	Diamond 9801/9802
dtk2000	DTK2000
ennyah_dkb1008	Ennyah DKB-1008
fscaa1667g	Fujitsu-Siemens Amilo laptop
genius	Genius Comfy KB-16M/Multimedia KWD-910
geniuscomfy	Genius Comfy KB-12e
geniuscomfy2	Genius Comfy KB-21e-Scroll
geniuskb19e	Genius KB-19e NB
geniuskkb2050hs	Genius KKB-2050HS
gyration	Gyration
kinesis	Kinesis
logitech_base	Logitech
logitech_g15	Logitech G15 extra keys via G15daemon
hpi6	Hewlett-Packard Internet
hp250x	Hewlett-Packard NEC SK-2500 Multimedia
hpxe3gc	Hewlett-Packard Omnibook XE3 GC
hpxe3gf	Hewlett-Packard Omnibook XE3 GF
hpxt1000	Hewlett-Packard Omnibook XT1000
hpdv5	Hewlett-Packard Pavilion dv5
hpzt11xx	Hewlett-Packard Pavilion ZT1100
hp500fa	Hewlett-Packard Omnibook 500 FA
hp5xx	Hewlett-Packard Omnibook 500
hpnx9020	Hewlett-Packard nx9020
hp6000	Hewlett-Packard Omnibook 6000/6100
honeywell_euroboard	Honeywell Euroboard
hpmini110	Hewlett-Packard Mini 110 laptop
rapidaccess	IBM Rapid Access
rapidaccess2	IBM Rapid Access II
thinkpad	IBM ThinkPad 560Z/600/600E/A22E
thinkpad60	IBM ThinkPad R60/T60/R61/T61
thinkpadz60	IBM ThinkPad Z60m/Z60t/Z61m/Z61t
ibm_spacesaver	IBM Space Saver
logiaccess	Logitech Access
logiclx300	Logitech Cordless Desktop LX-300
logii350	Logitech Internet 350
logimel	Logitech Internet 350
logicd	Logitech Cordless Desktop
logicd_it	Logitech Cordless Desktop iTouch
logicd_nav	Logitech Cordless Desktop Navigator
logicd_opt	Logitech Cordless Desktop Optical
logicda	Logitech Cordless Desktop (alt.)
logicdpa2	Logitech Cordless Desktop Pro (2nd alt.)
logicfn	Logitech Cordless Freedom/Desktop Navigator
logicdn	Logitech Cordless Desktop Navigator
logiitc	Logitech iTouch Cordless Y-RB6
logiik	Logitech Internet
itouch	Logitech iTouch
logicink	Logitech Internet Navigator
logiex110	Logitech Cordless Desktop EX110
logiinkse	Logitech iTouch Internet Navigator SE
logiinkseusb	Logitech iTouch Internet Navigator SE USB
logiultrax	Logitech Ultra-X
logiultraxc	Logitech Ultra-X Cordless Media Desktop
logidinovo	Logitech diNovo
logidinovoedge	Logitech diNovo Edge
mx1998	Memorex MX1998
mx2500	Memorex MX2500 EZ-Access
mx2750	Memorex MX2750
microsoft4000	Microsoft Natural Ergonomic 4000
microsoft7000	Microsoft Natural Wireless Ergonomic 7000
microsoftinet	Microsoft Internet
microsoftpro	Microsoft Natural Pro/Internet Pro
microsoftprousb	Microsoft Natural Pro USB/Internet Pro
microsoftprooem	Microsoft Natural Pro OEM
vsonku306	ViewSonic KU-306 Internet
microsoftprose	Microsoft Internet Pro (Swedish)
microsoftoffice	Microsoft Office Keyboard
microsoftmult	Microsoft Wireless Multimedia 1.0A
microsoftsurface	Microsoft Surface
microsoftelite	Microsoft Natural Elite
microsoftccurve2k	Microsoft Comfort Curve 2000
oretec	Ortek Multimedia/Internet MCK-800
propeller	Propeller Voyager KTEZ-1000
qtronix	QTronix Scorpius 98N+
samsung4500	Samsung SDM 4500P
samsung4510	Samsung SDM 4510P
sanwaskbkg3	Sanwa Supply SKB-KG3
sk1300	NEC SK-1300
sk2500	NEC SK-2500
sk6200	NEC SK-6200
sk7100	NEC SK-7100
sp_inet	Super Power Multimedia
sven	SVEN Ergonomic 2500
sven303	SVEN Slim 303
symplon	Symplon PaceBook tablet
toshiba_s3000	Toshiba Satellite S3000
trust	Trust Wireless Classic
trustda	Trust Direct Access
trust_slimline	Trust Slimline
tm2020	TypeMatrix EZ-Reach 2020
tm2030PS2	TypeMatrix EZ-Reach 2030 PS2
tm2030USB	TypeMatrix EZ-Reach 2030 USB
tm2030USB-102	TypeMatrix EZ-Reach 2030 USB (102/105:EU mode)
tm2030USB-106	TypeMatrix EZ-Reach 2030 USB (106:JP mode)
yahoo	Yahoo! Internet
macbook78	MacBook/MacBook Pro
macbook79	MacBook/MacBook Pro (intl.)
macintosh	Macintosh
macintosh_old	Macintosh Old
macintosh_hhk	Happy Hacking for Mac
acer_c300	Acer C300
acer_ferrari4k	Acer Ferrari 4000
acer_laptop	Acer laptop
asus_laptop	Asus laptop
apple	Apple
apple_laptop	Apple laptop
applealu_ansi	Apple Aluminium (ANSI)
applealu_iso	Apple Aluminium (ISO)
applealu_jis	Apple Aluminium (JIS)
silvercrest	Silvercrest Multimedia Wireless
emachines	eMachines m6800 laptop
benqx	BenQ X-Touch
benqx730	BenQ X-Touch 730
benqx800	BenQ X-Touch 800
hhk	Happy Hacking
classmate	Classmate PC
olpc	OLPC
sun_type7_usb	Sun Type 7 USB
sun_type7_euro_usb	Sun Type 7 USB (European)
sun_type7_unix_usb	Sun Type 7 USB (Unix)
sun_type7_jp_usb	Sun Type 7 USB (Japanese)/Japanese 106-key
sun_type6_usb	Sun Type 6/7 USB
sun_type6_euro_usb	Sun Type 6/7 USB (European)
sun_type6_unix_usb	Sun Type 6 USB (Unix)
sun_type6_jp_usb	Sun Type 6 USB (Japanese)
sun_type6_jp	Sun Type 6 (Japanese)
targa_v811	Targa Visionary 811
unitekkb1925	Unitek KB-1925
compalfl90	FL90
creativedw7000	Creative Desktop Wireless 7000
teck227	Truly Ergonomic 227
teck229	Truly Ergonomic 229
apex300	SteelSeries Apex 300 (Apex RAW)
chromebook	Chromebook
ppkb	PinePhone Keyboard

.TE
.SH LAYOUTS
.TS
left,box;
lB lB
____
lB l.
Layout(Variant)	Description
us	English (US)
us(chr)	Cherokee
us(haw)	Hawaiian
us(euro)	English (US, euro on 5)
us(intl)	English (US, intl., with dead keys)
us(alt-intl)	English (US, alt. intl.)
us(colemak)	English (Colemak)
us(colemak_dh)	English (Colemak-DH)
us(colemak_dh_iso)	English (Colemak-DH ISO)
us(dvorak)	English (Dvorak)
us(dvorak-intl)	English (Dvorak, intl., with dead keys)
us(dvorak-alt-intl)	English (Dvorak, alt. intl.)
us(dvorak-l)	English (Dvorak, left-handed)
us(dvorak-r)	English (Dvorak, right-handed)
us(dvorak-classic)	English (classic Dvorak)
us(dvp)	English (programmer Dvorak)
us(dvorak-mac)	English (Dvorak, Macintosh)
us(symbolic)	English (US, Symbolic)
us(rus)	Russian (US, phonetic)
us(mac)	English (Macintosh)
us(altgr-intl)	English (intl., with AltGr dead keys)
us(olpc2)	English (the divide/multiply toggle the layout)
us(hbs)	Serbo-Croatian (US)
us(norman)	English (Norman)
us(workman)	English (Workman)
us(workman-intl)	English (Workman, intl., with dead keys)

_
af	Dari
af(ps)	Pashto
af(uz)	Uzbek (Afghanistan)
af(ps-olpc)	Pashto (Afghanistan, OLPC)
af(fa-olpc)	Dari (Afghanistan, OLPC)
af(uz-olpc)	Uzbek (Afghanistan, OLPC)

_
ara	Arabic
ara(azerty)	Arabic (AZERTY)
ara(azerty_digits)	Arabic (AZERTY, Eastern Arabic numerals)
ara(digits)	Arabic (Eastern Arabic numerals)
ara(qwerty)	Arabic (QWERTY)
ara(qwerty_digits)	Arabic (QWERTY, Eastern Arabic numerals)
ara(buckwalter)	Arabic (Buckwalter)
ara(olpc)	Arabic (OLPC)
ara(mac)	Arabic (Macintosh)

_
al	Albanian
al(plisi)	Albanian (Plisi)
al(veqilharxhi)	Albanian (Veqilharxhi)

_
am	Armenian
am(phonetic)	Armenian (phonetic)
am(phonetic-alt)	Armenian (alt. phonetic)
am(eastern)	Armenian (eastern)
am(western)	Armenian (western)
am(eastern-alt)	Armenian (alt. eastern)

_
at	German (Austria)
at(nodeadkeys)	German (Austria, no dead keys)
at(mac)	German (Austria, Macintosh)

_
au	English (Australian)

_
az	Azerbaijani
az(cyrillic)	Azerbaijani (Cyrillic)

_
by	Belarusian
by(legacy)	Belarusian (legacy)
by(latin)	Belarusian (Latin)
by(ru)	Russian (Belarus)
by(intl)	Belarusian (intl.)
by(phonetic)	Belarusian (phonetic)

_
be	Belgian
be(oss)	Belgian (alt.)
be(oss_latin9)	Belgian (Latin-9 only, alt.)
be(iso-alternate)	Belgian (ISO, alt.)
be(nodeadkeys)	Belgian (no dead keys)
be(wang)	Belgian (Wang 724 AZERTY)

_
bd	Bangla
bd(probhat)	Bangla (Probhat)

_
in	Indian
in(ben)	Bangla (India)
in(ben_probhat)	Bangla (India, Probhat)
in(ben_baishakhi)	Bangla (India, Baishakhi)
in(ben_bornona)	Bangla (India, Bornona)
in(ben_gitanjali)	Bangla (India, Gitanjali)
in(ben_inscript)	Bangla (India, Baishakhi InScript)
in(eeyek)	Manipuri (Eeyek)
in(guj)	Gujarati
in(guru)	Punjabi (Gurmukhi)
in(jhelum)	Punjabi (Gurmukhi Jhelum)
in(kan)	Kannada
in(kan-kagapa)	Kannada (KaGaPa, phonetic)
in(mal)	Malayalam
in(mal_lalitha)	Malayalam (Lalitha)
in(mal_enhanced)	Malayalam (enhanced InScript, with rupee)
in(ori)	Oriya
in(ori-bolnagri)	Oriya (Bolnagri)
in(ori-wx)	Oriya (Wx)
in(olck)	Ol Chiki
in(tamilnet)	Tamil (TamilNet '99)
in(tamilnet_tamilnumbers)	Tamil (TamilNet '99 with Tamil numerals)
in(tamilnet_TAB)	Tamil (TamilNet '99, TAB encoding)
in(tamilnet_TSCII)	Tamil (TamilNet '99, TSCII encoding)
in(tam)	Tamil (InScript, with Arabic numerals)
in(tam_tamilnumbers)	Tamil (InScript, with Tamil numerals)
in(tel)	Telugu
in(tel-kagapa)	Telugu (KaGaPa, phonetic)
in(tel-sarala)	Telugu (Sarala)
in(urd-phonetic)	Urdu (phonetic)
in(urd-phonetic3)	Urdu (alt. phonetic)
in(urd-winkeys)	Urdu (Windows)
in(bolnagri)	Hindi (Bolnagri)
in(hin-wx)	Hindi (Wx)
in(hin-kagapa)	Hindi (KaGaPa, phonetic)
in(san-kagapa)	Sanskrit (KaGaPa, phonetic)
in(mar-kagapa)	Marathi (KaGaPa, phonetic)
in(eng)	English (India, with rupee)
in(iipa)	Indic IPA
in(marathi)	Marathi (enhanced InScript)

_
ba	Bosnian
ba(alternatequotes)	Bosnian (with guillemets)
ba(unicode)	Bosnian (with Bosnian digraphs)
ba(unicodeus)	Bosnian (US, with Bosnian digraphs)
ba(us)	Bosnian (US)

_
br	Portuguese (Brazil)
br(nodeadkeys)	Portuguese (Brazil, no dead keys)
br(dvorak)	Portuguese (Brazil, Dvorak)
br(nativo)	Portuguese (Brazil, Nativo)
br(nativo-us)	Portuguese (Brazil, Nativo for US keyboards)
br(nativo-epo)	Esperanto (Brazil, Nativo)
br(thinkpad)	Portuguese (Brazil, IBM/Lenovo ThinkPad)

_
bg	Bulgarian
bg(phonetic)	Bulgarian (traditional phonetic)
bg(bas_phonetic)	Bulgarian (new phonetic)
bg(bekl)	Bulgarian (enhanced)

_
dz	Berber (Algeria, Latin)
dz(azerty-deadkeys)	Kabyle (AZERTY, with dead keys)
dz(qwerty-gb-deadkeys)	Kabyle (QWERTY, UK, with dead keys)
dz(qwerty-us-deadkeys)	Kabyle (QWERTY, US, with dead keys)
dz(ber)	Berber (Algeria, Tifinagh)
dz(ar)	Arabic (Algeria)

_
ma	Arabic (Morocco)
ma(french)	French (Morocco)
ma(tifinagh)	Berber (Morocco, Tifinagh)
ma(tifinagh-alt)	Berber (Morocco, Tifinagh alt.)
ma(tifinagh-alt-phonetic)	Berber (Morocco, Tifinagh phonetic, alt.)
ma(tifinagh-extended)	Berber (Morocco, Tifinagh extended)
ma(tifinagh-phonetic)	Berber (Morocco, Tifinagh phonetic)
ma(tifinagh-extended-phonetic)	Berber (Morocco, Tifinagh extended phonetic)
ma(rif)	Tarifit

_
cm	English (Cameroon)
cm(french)	French (Cameroon)
cm(qwerty)	Cameroon Multilingual (QWERTY, intl.)
cm(azerty)	Cameroon (AZERTY, intl.)
cm(dvorak)	Cameroon (Dvorak, intl.)
cm(mmuock)	Mmuock

_
mm	Burmese
mm(zawgyi)	Burmese Zawgyi
mm(shn)	Shan
mm(zgt)	Shan (Zawgyi Tai)
mm(mnw)	Mon
mm(mnw-a1)	Mon (A1)

_
ca	French (Canada)
ca(fr-dvorak)	French (Canada, Dvorak)
ca(fr-legacy)	French (Canada, legacy)
ca(multix)	Canadian (CSA)
ca(ike)	Inuktitut
ca(eng)	English (Canada)

_
cd	French (Democratic Republic of the Congo)

_
cn	Chinese
cn(mon_trad)	Mongolian (Bichig)
cn(mon_trad_todo)	Mongolian (Todo)
cn(mon_trad_xibe)	Mongolian (Xibe)
cn(mon_trad_manchu)	Mongolian (Manchu)
cn(mon_trad_galik)	Mongolian (Galik)
cn(mon_todo_galik)	Mongolian (Todo Galik)
cn(mon_manchu_galik)	Mongolian (Manchu Galik)
cn(tib)	Tibetan
cn(tib_asciinum)	Tibetan (with ASCII numerals)
cn(ug)	Uyghur
cn(altgr-pinyin)	Hanyu Pinyin Letters (with AltGr dead keys)

_
hr	Croatian
hr(alternatequotes)	Croatian (with guillemets)
hr(unicode)	Croatian (with Croatian digraphs)
hr(unicodeus)	Croatian (US, with Croatian digraphs)
hr(us)	Croatian (US)

_
cz	Czech
cz(bksl)	Czech (with <\|> key)
cz(qwerty)	Czech (QWERTY)
cz(qwerty_bksl)	Czech (QWERTY, extended backslash)
cz(qwerty-mac)	Czech (QWERTY, Macintosh)
cz(ucw)	Czech (UCW, only accented letters)
cz(dvorak-ucw)	Czech (US, Dvorak, UCW support)
cz(rus)	Russian (Czech, phonetic)

_
dk	Danish
dk(nodeadkeys)	Danish (no dead keys)
dk(winkeys)	Danish (Windows)
dk(mac)	Danish (Macintosh)
dk(mac_nodeadkeys)	Danish (Macintosh, no dead keys)
dk(dvorak)	Danish (Dvorak)

_
nl	Dutch
nl(us)	Dutch (US)
nl(mac)	Dutch (Macintosh)
nl(std)	Dutch (standard)

_
bt	Dzongkha

_
ee	Estonian
ee(nodeadkeys)	Estonian (no dead keys)
ee(dvorak)	Estonian (Dvorak)
ee(us)	Estonian (US)

_
ir	Persian
ir(pes_keypad)	Persian (with Persian keypad)
ir(azb)	Azerbaijani (Iran)
ir(ku)	Kurdish (Iran, Latin Q)
ir(ku_f)	Kurdish (Iran, F)
ir(ku_alt)	Kurdish (Iran, Latin Alt-Q)
ir(ku_ara)	Kurdish (Iran, Arabic-Latin)

_
iq	Iraqi
iq(ku)	Kurdish (Iraq, Latin Q)
iq(ku_f)	Kurdish (Iraq, F)
iq(ku_alt)	Kurdish (Iraq, Latin Alt-Q)
iq(ku_ara)	Kurdish (Iraq, Arabic-Latin)

_
fo	Faroese
fo(nodeadkeys)	Faroese (no dead keys)

_
fi	Finnish
fi(winkeys)	Finnish (Windows)
fi(classic)	Finnish (classic)
fi(nodeadkeys)	Finnish (classic, no dead keys)
fi(smi)	Northern Saami (Finland)
fi(mac)	Finnish (Macintosh)

_
fr	French
fr(nodeadkeys)	French (no dead keys)
fr(oss)	French (alt.)
fr(oss_latin9)	French (alt., Latin-9 only)
fr(oss_nodeadkeys)	French (alt., no dead keys)
fr(latin9)	French (legacy, alt.)
fr(latin9_nodeadkeys)	French (legacy, alt., no dead keys)
fr(bepo)	French (BEPO)
fr(bepo_latin9)	French (BEPO, Latin-9 only)
fr(bepo_afnor)	French (BEPO, AFNOR)
fr(dvorak)	French (Dvorak)
fr(mac)	French (Macintosh)
fr(azerty)	French (AZERTY)
fr(afnor)	French (AZERTY, AFNOR)
fr(bre)	Breton (France)
fr(oci)	Occitan
fr(geo)	Georgian (France, AZERTY Tskapo)
fr(us)	French (US)

_
gh	English (Ghana)
gh(generic)	English (Ghana, multilingual)
gh(akan)	Akan
gh(ewe)	Ewe
gh(fula)	Fula
gh(ga)	Ga
gh(hausa)	Hausa (Ghana)
gh(avn)	Avatime
gh(gillbt)	English (Ghana, GILLBT)

_
gn	N'Ko (AZERTY)

_
ge	Georgian
ge(ergonomic)	Georgian (ergonomic)
ge(mess)	Georgian (MESS)
ge(ru)	Russian (Georgia)
ge(os)	Ossetian (Georgia)

_
de	German
de(deadacute)	German (dead acute)
de(deadgraveacute)	German (dead grave acute)
de(nodeadkeys)	German (no dead keys)
de(e1)	German (E1)
de(e2)	German (E2)
de(T3)	German (T3)
de(us)	German (US)
de(ro)	Romanian (Germany)
de(ro_nodeadkeys)	Romanian (Germany, no dead keys)
de(dvorak)	German (Dvorak)
de(neo)	German (Neo 2)
de(mac)	German (Macintosh)
de(mac_nodeadkeys)	German (Macintosh, no dead keys)
de(dsb)	Lower Sorbian
de(dsb_qwertz)	Lower Sorbian (QWERTZ)
de(qwerty)	German (QWERTY)
de(tr)	Turkish (Germany)
de(ru)	Russian (Germany, phonetic)
de(deadtilde)	German (dead tilde)

_
gr	Greek
gr(simple)	Greek (simple)
gr(extended)	Greek (extended)
gr(nodeadkeys)	Greek (no dead keys)
gr(polytonic)	Greek (polytonic)

_
hu	Hungarian
hu(standard)	Hungarian (standard)
hu(nodeadkeys)	Hungarian (no dead keys)
hu(qwerty)	Hungarian (QWERTY)
hu(101_qwertz_comma_dead)	Hungarian (QWERTZ, 101-key, comma, dead keys)
hu(101_qwertz_comma_nodead)	Hungarian (QWERTZ, 101-key, comma, no dead keys)
hu(101_qwertz_dot_dead)	Hungarian (QWERTZ, 101-key, dot, dead keys)
hu(101_qwertz_dot_nodead)	Hungarian (QWERTZ, 101-key, dot, no dead keys)
hu(101_qwerty_comma_dead)	Hungarian (QWERTY, 101-key, comma, dead keys)
hu(101_qwerty_comma_nodead)	Hungarian (QWERTY, 101-key, comma, no dead keys)
hu(101_qwerty_dot_dead)	Hungarian (QWERTY, 101-key, dot, dead keys)
hu(101_qwerty_dot_nodead)	Hungarian (QWERTY, 101-key, dot, no dead keys)
hu(102_qwertz_comma_dead)	Hungarian (QWERTZ, 102-key, comma, dead keys)
hu(102_qwertz_comma_nodead)	Hungarian (QWERTZ, 102-key, comma, no dead keys)
hu(102_qwertz_dot_dead)	Hungarian (QWERTZ, 102-key, dot, dead keys)
hu(102_qwertz_dot_nodead)	Hungarian (QWERTZ, 102-key, dot, no dead keys)
hu(102_qwerty_comma_dead)	Hungarian (QWERTY, 102-key, comma, dead keys)
hu(102_qwerty_comma_nodead)	Hungarian (QWERTY, 102-key, comma, no dead keys)
hu(102_qwerty_dot_dead)	Hungarian (QWERTY, 102-key, dot, dead keys)
hu(102_qwerty_dot_nodead)	Hungarian (QWERTY, 102-key, dot, no dead keys)

_
is	Icelandic
is(mac_legacy)	Icelandic (Macintosh, legacy)
is(mac)	Icelandic (Macintosh)
is(dvorak)	Icelandic (Dvorak)

_
il	Hebrew
il(lyx)	Hebrew (lyx)
il(phonetic)	Hebrew (phonetic)
il(biblical)	Hebrew (Biblical, Tiro)

_
it	Italian
it(nodeadkeys)	Italian (no dead keys)
it(winkeys)	Italian (Windows)
it(mac)	Italian (Macintosh)
it(us)	Italian (US)
it(geo)	Georgian (Italy)
it(ibm)	Italian (IBM 142)
it(intl)	Italian (intl., with dead keys)
it(scn)	Sicilian
it(fur)	Friulian (Italy)

_
jp	Japanese
jp(kana)	Japanese (Kana)
jp(kana86)	Japanese (Kana 86)
jp(OADG109A)	Japanese (OADG 109A)
jp(mac)	Japanese (Macintosh)
jp(dvorak)	Japanese (Dvorak)

_
kg	Kyrgyz
kg(phonetic)	Kyrgyz (phonetic)

_
kh	Khmer (Cambodia)

_
kz	Kazakh
kz(ruskaz)	Russian (Kazakhstan, with Kazakh)
kz(kazrus)	Kazakh (with Russian)
kz(ext)	Kazakh (extended)
kz(latin)	Kazakh (Latin)

_
la	Lao
la(stea)	Lao (STEA)

_
latam	Spanish (Latin American)
latam(nodeadkeys)	Spanish (Latin American, no dead keys)
latam(deadtilde)	Spanish (Latin American, dead tilde)
latam(dvorak)	Spanish (Latin American, Dvorak)
latam(colemak)	Spanish (Latin American, Colemak)

_
lt	Lithuanian
lt(std)	Lithuanian (standard)
lt(us)	Lithuanian (US)
lt(ibm)	Lithuanian (IBM LST 1205-92)
lt(lekp)	Lithuanian (LEKP)
lt(lekpa)	Lithuanian (LEKPa)
lt(sgs)	Samogitian
lt(ratise)	Lithuanian (Ratise)

_
lv	Latvian
lv(apostrophe)	Latvian (apostrophe)
lv(tilde)	Latvian (tilde)
lv(fkey)	Latvian (F)
lv(modern)	Latvian (modern)
lv(ergonomic)	Latvian (ergonomic, ŪGJRMV)
lv(adapted)	Latvian (adapted)

_
mao	Maori

_
me	Montenegrin
me(cyrillic)	Montenegrin (Cyrillic)
me(cyrillicyz)	Montenegrin (Cyrillic, ZE and ZHE swapped)
me(latinunicode)	Montenegrin (Latin, Unicode)
me(latinyz)	Montenegrin (Latin, QWERTY)
me(latinunicodeyz)	Montenegrin (Latin, Unicode, QWERTY)
me(cyrillicalternatequotes)	Montenegrin (Cyrillic, with guillemets)
me(latinalternatequotes)	Montenegrin (Latin, with guillemets)

_
mk	Macedonian
mk(nodeadkeys)	Macedonian (no dead keys)

_
mt	Maltese
mt(us)	Maltese (US)
mt(alt-us)	Maltese (US, with AltGr overrides)
mt(alt-gb)	Maltese (UK, with AltGr overrides)

_
mn	Mongolian

_
no	Norwegian
no(nodeadkeys)	Norwegian (no dead keys)
no(winkeys)	Norwegian (Windows)
no(dvorak)	Norwegian (Dvorak)
no(smi)	Northern Saami (Norway)
no(smi_nodeadkeys)	Northern Saami (Norway, no dead keys)
no(mac)	Norwegian (Macintosh)
no(mac_nodeadkeys)	Norwegian (Macintosh, no dead keys)
no(colemak)	Norwegian (Colemak)

_
pl	Polish
pl(legacy)	Polish (legacy)
pl(qwertz)	Polish (QWERTZ)
pl(dvorak)	Polish (Dvorak)
pl(dvorak_quotes)	Polish (Dvorak, with Polish quotes on quotemark key)
pl(dvorak_altquotes)	Polish (Dvorak, with Polish quotes on key 1)
pl(csb)	Kashubian
pl(szl)	Silesian
pl(ru_phonetic_dvorak)	Russian (Poland, phonetic Dvorak)
pl(dvp)	Polish (programmer Dvorak)

_
pt	Portuguese
pt(nodeadkeys)	Portuguese (no dead keys)
pt(mac)	Portuguese (Macintosh)
pt(mac_nodeadkeys)	Portuguese (Macintosh, no dead keys)
pt(nativo)	Portuguese (Nativo)
pt(nativo-us)	Portuguese (Nativo for US keyboards)
pt(nativo-epo)	Esperanto (Portugal, Nativo)

_
ro	Romanian
ro(std)	Romanian (standard)
ro(winkeys)	Romanian (Windows)

_
ru	Russian
ru(phonetic)	Russian (phonetic)
ru(phonetic_winkeys)	Russian (phonetic, Windows)
ru(phonetic_YAZHERTY)	Russian (phonetic, YAZHERTY)
ru(typewriter)	Russian (typewriter)
ru(ruchey_ru)	Russian (engineering, RU)
ru(ruchey_en)	Russian (engineering, EN)
ru(legacy)	Russian (legacy)
ru(typewriter-legacy)	Russian (typewriter, legacy)
ru(tt)	Tatar
ru(os_legacy)	Ossetian (legacy)
ru(os_winkeys)	Ossetian (Windows)
ru(cv)	Chuvash
ru(cv_latin)	Chuvash (Latin)
ru(udm)	Udmurt
ru(kom)	Komi
ru(sah)	Yakut
ru(xal)	Kalmyk
ru(dos)	Russian (DOS)
ru(mac)	Russian (Macintosh)
ru(srp)	Serbian (Russia)
ru(bak)	Bashkirian
ru(chm)	Mari
ru(phonetic_azerty)	Russian (phonetic, AZERTY)
ru(phonetic_dvorak)	Russian (phonetic, Dvorak)
ru(phonetic_fr)	Russian (phonetic, French)
ru(ab)	Abkhazian (Russia)

_
rs	Serbian
rs(yz)	Serbian (Cyrillic, ZE and ZHE swapped)
rs(latin)	Serbian (Latin)
rs(latinunicode)	Serbian (Latin, Unicode)
rs(latinyz)	Serbian (Latin, QWERTY)
rs(latinunicodeyz)	Serbian (Latin, Unicode, QWERTY)
rs(alternatequotes)	Serbian (Cyrillic, with guillemets)
rs(latinalternatequotes)	Serbian (Latin, with guillemets)
rs(rue)	Pannonian Rusyn

_
si	Slovenian
si(alternatequotes)	Slovenian (with guillemets)
si(us)	Slovenian (US)

_
sk	Slovak
sk(bksl)	Slovak (extended backslash)
sk(qwerty)	Slovak (QWERTY)
sk(qwerty_bksl)	Slovak (QWERTY, extended backslash)

_
es	Spanish
es(nodeadkeys)	Spanish (no dead keys)
es(winkeys)	Spanish (Windows)
es(deadtilde)	Spanish (dead tilde)
es(dvorak)	Spanish (Dvorak)
es(ast)	Asturian (Spain, with bottom-dot H and L)
es(cat)	Catalan (Spain, with middle-dot L)
es(mac)	Spanish (Macintosh)

_
se	Swedish
se(nodeadkeys)	Swedish (no dead keys)
se(dvorak)	Swedish (Dvorak)
se(rus)	Russian (Sweden, phonetic)
se(rus_nodeadkeys)	Russian (Sweden, phonetic, no dead keys)
se(smi)	Northern Saami (Sweden)
se(mac)	Swedish (Macintosh)
se(svdvorak)	Swedish (Svdvorak)
se(us_dvorak)	Swedish (Dvorak, intl.)
se(us)	Swedish (US)
se(swl)	Swedish Sign Language

_
ch	German (Switzerland)
ch(legacy)	German (Switzerland, legacy)
ch(de_nodeadkeys)	German (Switzerland, no dead keys)
ch(fr)	French (Switzerland)
ch(fr_nodeadkeys)	French (Switzerland, no dead keys)
ch(fr_mac)	French (Switzerland, Macintosh)
ch(de_mac)	German (Switzerland, Macintosh)

_
sy	Arabic (Syria)
sy(syc)	Syriac
sy(syc_phonetic)	Syriac (phonetic)
sy(ku)	Kurdish (Syria, Latin Q)
sy(ku_f)	Kurdish (Syria, F)
sy(ku_alt)	Kurdish (Syria, Latin Alt-Q)

_
tj	Tajik
tj(legacy)	Tajik (legacy)

_
lk	Sinhala (phonetic)
lk(tam_unicode)	Tamil (Sri Lanka, TamilNet '99)
lk(tam_TAB)	Tamil (Sri Lanka, TamilNet '99, TAB encoding)
lk(us)	Sinhala (US)

_
th	Thai
th(tis)	Thai (TIS-820.2538)
th(pat)	Thai (Pattachote)

_
tr	Turkish
tr(f)	Turkish (F)
tr(e)	Turkish (E)
tr(alt)	Turkish (Alt-Q)
tr(ku)	Kurdish (Turkey, Latin Q)
tr(ku_f)	Kurdish (Turkey, F)
tr(ku_alt)	Kurdish (Turkey, Latin Alt-Q)
tr(intl)	Turkish (intl., with dead keys)
tr(ot)	Ottoman (Q)
tr(otf)	Ottoman (F)
tr(otk)	Old Turkic
tr(otkf)	Old Turkic (F)

_
tw	Taiwanese
tw(indigenous)	Taiwanese (indigenous)
tw(saisiyat)	Saisiyat (Taiwan)

_
ua	Ukrainian
ua(phonetic)	Ukrainian (phonetic)
ua(typewriter)	Ukrainian (typewriter)
ua(winkeys)	Ukrainian (Windows)
ua(macOS)	Ukrainian (macOS)
ua(legacy)	Ukrainian (legacy)
ua(rstu)	Ukrainian (standard RSTU)
ua(rstu_ru)	Russian (Ukraine, standard RSTU)
ua(homophonic)	Ukrainian (homophonic)
ua(crh)	Crimean Tatar (Turkish Q)
ua(crh_f)	Crimean Tatar (Turkish F)
ua(crh_alt)	Crimean Tatar (Turkish Alt-Q)

_
gb	English (UK)
gb(extd)	English (UK, extended, Windows)
gb(intl)	English (UK, intl., with dead keys)
gb(dvorak)	English (UK, Dvorak)
gb(dvorakukp)	English (UK, Dvorak, with UK punctuation)
gb(mac)	English (UK, Macintosh)
gb(mac_intl)	English (UK, Macintosh, intl.)
gb(colemak)	English (UK, Colemak)
gb(colemak_dh)	English (UK, Colemak-DH)
gb(pl)	Polish (British keyboard)
gb(gla)	Scottish Gaelic

_
uz	Uzbek
uz(latin)	Uzbek (Latin)

_
vn	Vietnamese
vn(us)	Vietnamese (US)
vn(fr)	Vietnamese (France)

_
kr	Korean
kr(kr104)	Korean (101/104-key compatible)

_
ie	Irish
ie(CloGaelach)	CloGaelach
ie(UnicodeExpert)	Irish (UnicodeExpert)
ie(ogam)	Ogham
ie(ogam_is434)	Ogham (IS434)

_
pk	Urdu (Pakistan)
pk(urd-crulp)	Urdu (Pakistan, CRULP)
pk(urd-nla)	Urdu (Pakistan, NLA)
pk(ara)	Arabic (Pakistan)
pk(snd)	Sindhi

_
mv	Dhivehi

_
za	English (South Africa)

_
epo	Esperanto
epo(legacy)	Esperanto (legacy)

_
np	Nepali

_
ng	English (Nigeria)
ng(igbo)	Igbo
ng(yoruba)	Yoruba
ng(hausa)	Hausa (Nigeria)

_
et	Amharic

_
sn	Wolof

_
brai	Braille
brai(left_hand)	Braille (left-handed)
brai(left_hand_invert)	Braille (left-handed inverted thumb)
brai(right_hand)	Braille (right-handed)
brai(right_hand_invert)	Braille (right-handed inverted thumb)

_
tm	Turkmen
tm(alt)	Turkmen (Alt-Q)

_
ml	Bambara
ml(fr-oss)	French (Mali, alt.)
ml(us-mac)	English (Mali, US, Macintosh)
ml(us-intl)	English (Mali, US, intl.)

_
tz	Swahili (Tanzania)

_
tg	French (Togo)

_
ke	Swahili (Kenya)
ke(kik)	Kikuyu

_
bw	Tswana

_
ph	Filipino
ph(qwerty-bay)	Filipino (QWERTY, Baybayin)
ph(capewell-dvorak)	Filipino (Capewell-Dvorak, Latin)
ph(capewell-dvorak-bay)	Filipino (Capewell-Dvorak, Baybayin)
ph(capewell-qwerf2k6)	Filipino (Capewell-QWERF 2006, Latin)
ph(capewell-qwerf2k6-bay)	Filipino (Capewell-QWERF 2006, Baybayin)
ph(colemak)	Filipino (Colemak, Latin)
ph(colemak-bay)	Filipino (Colemak, Baybayin)
ph(dvorak)	Filipino (Dvorak, Latin)
ph(dvorak-bay)	Filipino (Dvorak, Baybayin)

_
md	Moldavian
md(gag)	Moldavian (Gagauz)

_
id	Indonesian (Latin)
id(javanese)	Javanese
id(melayu-phonetic)	Indonesian (Arab Melayu, phonetic)
id(melayu-phoneticx)	Indonesian (Arab Melayu, extended phonetic)
id(pegon-phonetic)	Indonesian (Arab Pegon, phonetic)

_
my	Malay (Jawi, Arabic Keyboard)
my(phonetic)	Malay (Jawi, phonetic)

_
custom	A user-defined custom Layout

_

.TE
.SH OPTIONS

.SS
Switching to another layout
.BR
.TS
left,box;
lB lB
___
lB l.
Option	Description
grp:switch	Right Alt (while pressed)
grp:lswitch	Left Alt (while pressed)
grp:lwin_switch	Left Win (while pressed)
grp:rwin_switch	Right Win (while pressed)
grp:win_switch	Any Win (while pressed)
grp:menu_switch	Menu (while pressed), Shift+Menu for Menu
grp:caps_switch	Caps Lock (while pressed), Alt+Caps Lock for the original Caps Lock action
grp:rctrl_switch	Right Ctrl (while pressed)
grp:toggle	Right Alt
grp:lalt_toggle	Left Alt
grp:caps_toggle	Caps Lock
grp:shift_caps_toggle	Shift+Caps Lock
grp:caps_select	Caps Lock to first layout; Shift+Caps Lock to second layout
grp:win_menu_select	Left Win to first layout; Right Win/Menu to second layout
grp:ctrl_select	Left Ctrl to first layout; Right Ctrl to second layout
grp:alt_caps_toggle	Alt+Caps Lock
grp:shifts_toggle	Both Shifts together
grp:alts_toggle	Both Alts together
grp:alt_altgr_toggle	Both Alts together; AltGr alone chooses third level
grp:ctrls_toggle	Both Ctrls together
grp:ctrl_shift_toggle	Ctrl+Shift
grp:lctrl_lshift_toggle	Left Ctrl+Left Shift
grp:rctrl_rshift_toggle	Right Ctrl+Right Shift
grp:ctrl_alt_toggle	Alt+Ctrl
grp:alt_shift_toggle	Alt+Shift
grp:lalt_lshift_toggle	Left Alt+Left Shift
grp:ralt_rshift_toggle	Right Alt+Right Shift
grp:menu_toggle	Menu
grp:lwin_toggle	Left Win
grp:alt_space_toggle	Alt+Space
grp:win_space_toggle	Win+Space
grp:ctrl_space_toggle	Ctrl+Space
grp:rwin_toggle	Right Win
grp:lshift_toggle	Left Shift
grp:rshift_toggle	Right Shift
grp:lctrl_toggle	Left Ctrl
grp:rctrl_toggle	Right Ctrl
grp:sclk_toggle	Scroll Lock
grp:lctrl_lwin_rctrl_menu	Ctrl+Left Win to first layout; Ctrl+Menu to second layout
grp:lctrl_lwin_toggle	Left Ctrl+Left Win

.TE


.SS
Key to choose the 2nd level
.BR
.TS
left,box;
lB lB
___
lB l.
Option	Description
lv2:lsgt_switch	The "< >" key

.TE


.SS
Key to choose the 3rd level
.BR
.TS
left,box;
lB lB
___
lB l.
Option	Description
lv3:switch	Right Ctrl
lv3:menu_switch	Menu
lv3:win_switch	Any Win
lv3:lwin_switch	Left Win
lv3:rwin_switch	Right Win
lv3:alt_switch	Any Alt
lv3:lalt_switch	Left Alt
lv3:ralt_switch	Right Alt
lv3:ralt_switch_multikey	Right Alt; Shift+Right Alt as Compose
lv3:ralt_alt	Right Alt never chooses 3rd level
lv3:enter_switch	Enter on keypad
lv3:caps_switch	Caps Lock
lv3:bksl_switch	Backslash
lv3:lsgt_switch	The "< >" key
lv3:caps_switch_latch	Caps Lock; acts as onetime lock when pressed together with another 3rd-level chooser
lv3:bksl_switch_latch	Backslash; acts as onetime lock when pressed together with another 3rd level chooser
lv3:lsgt_switch_latch	The "< >" key; acts as onetime lock when pressed together with another 3rd level chooser

.TE


.SS
Ctrl position
.BR
.TS
left,box;
lB lB
___
lB l.
Option	Description
ctrl:nocaps	Caps Lock as Ctrl
ctrl:lctrl_meta	Left Ctrl as Meta
ctrl:swapcaps	Swap Ctrl and Caps Lock
ctrl:hyper_capscontrol	Caps Lock as Ctrl, Ctrl as Hyper
ctrl:ac_ctrl	To the left of "A"
ctrl:aa_ctrl	At the bottom left
ctrl:rctrl_ralt	Right Ctrl as Right Alt
ctrl:menu_rctrl	Menu as Right Ctrl
ctrl:swap_lalt_lctl	Swap Left Alt with Left Ctrl
ctrl:swap_lwin_lctl	Swap Left Win with Left Ctrl
ctrl:swap_rwin_rctl	Swap Right Win with Right Ctrl
ctrl:swap_lalt_lctl_lwin	Left Alt as Ctrl, Left Ctrl as Win, Left Win as Left Alt

.TE


.SS
Use keyboard LED to show alternative layout
.BR
.TS
left,box;
lB lB
___
lB l.
Option	Description
grp_led:num	Num Lock
grp_led:caps	Caps Lock
grp_led:scroll	Scroll Lock

.TE


.SS
Use keyboard LED to indicate modifiers
.BR
.TS
left,box;
lB lB
___
lB l.
Option	Description
mod_led:compose	Compose

.TE


.SS
Layout of numeric keypad
.BR
.TS
left,box;
lB lB
___
lB l.
Option	Description
keypad:legacy	Legacy
keypad:oss	Unicode arrows and math operators
keypad:future	Unicode arrows and math operators on default level
keypad:legacy_wang	Legacy Wang 724
keypad:oss_wang	Wang 724 keypad with Unicode arrows and math operators
keypad:future_wang	Wang 724 keypad with Unicode arrows and math operators on default level
keypad:hex	Hexadecimal
keypad:atm	Phone and ATM style

.TE


.SS
Numeric keypad Delete behavior
.BR
.TS
left,box;
lB lB
___
lB l.
Option	Description
kpdl:dot	Legacy key with dot
kpdl:comma	Legacy key with comma
kpdl:dotoss	Four-level key with dot
kpdl:dotoss_latin9	Four-level key with dot, Latin-9 only
kpdl:commaoss	Four-level key with comma
kpdl:momayyezoss	Four-level key with momayyez
kpdl:kposs	Four-level key with abstract separators
kpdl:semi	Semicolon on third level

.TE


.SS
Caps Lock behavior
.BR
.TS
left,box;
lB lB
___
lB l.
Option	Description
caps:internal	Caps Lock uses internal capitalization; Shift "pauses" Caps Lock
caps:internal_nocancel	Caps Lock uses internal capitalization; Shift does not affect Caps Lock
caps:shift	Caps Lock acts as Shift with locking; Shift "pauses" Caps Lock
caps:shift_nocancel	Caps Lock acts as Shift with locking; Shift does not affect Caps Lock
caps:capslock	Caps Lock toggles normal capitalization of alphabetic characters
caps:shiftlock	Caps Lock toggles Shift Lock (affects all keys)
caps:swapescape	Swap Esc and Caps Lock
caps:escape	Make Caps Lock an additional Esc
caps:escape_shifted_capslock	Make Caps Lock an additional Esc, but Shift + Caps Lock is the regular Caps Lock
caps:backspace	Make Caps Lock an additional Backspace
caps:super	Make Caps Lock an additional Super
caps:hyper	Make Caps Lock an additional Hyper
caps:menu	Make Caps Lock an additional Menu key
caps:numlock	Make Caps Lock an additional Num Lock
caps:ctrl_modifier	Make Caps Lock an additional Ctrl
caps:none	Caps Lock is disabled

.TE


.SS
Alt and Win behavior
.BR
.TS
left,box;
lB lB
___
lB l.
Option	Description
altwin:menu	Add the standard behavior to Menu key
altwin:menu_win	Menu is mapped to Win
altwin:meta_alt	Alt and Meta are on Alt
altwin:alt_win	Alt is mapped to Win and the usual Alt
altwin:ctrl_win	Ctrl is mapped to Win and the usual Ctrl
altwin:ctrl_rwin	Ctrl is mapped to Right Win and the usual Ctrl
altwin:ctrl_alt_win	Ctrl is mapped to Alt, Alt to Win
altwin:meta_win	Meta is mapped to Win
altwin:left_meta_win	Meta is mapped to Left Win
altwin:hyper_win	Hyper is mapped to Win
altwin:alt_super_win	Alt is mapped to Right Win, Super to Menu
altwin:swap_lalt_lwin	Left Alt is swapped with Left Win
altwin:swap_alt_win	Alt is swapped with Win
altwin:prtsc_rwin	Win is mapped to PrtSc and the usual Win

.TE


.SS
Position of Compose key
.BR
.TS
left,box;
lB lB
___
lB l.
Option	Description
compose:ralt	Right Alt
compose:lwin	Left Win
compose:lwin-altgr	3rd level of Left Win
compose:rwin	Right Win
compose:rwin-altgr	3rd level of Right Win
compose:menu	Menu
compose:menu-altgr	3rd level of Menu
compose:lctrl	Left Ctrl
compose:lctrl-altgr	3rd level of Left Ctrl
compose:rctrl	Right Ctrl
compose:rctrl-altgr	3rd level of Right Ctrl
compose:caps	Caps Lock
compose:caps-altgr	3rd level of Caps Lock
compose:102	The "< >" key
compose:102-altgr	3rd level of the "< >" key
compose:paus	Pause
compose:ins	Insert
compose:prsc	PrtSc
compose:sclk	Scroll Lock

.TE


.SS
Compatibility options
.BR
.TS
left,box;
lB lB
___
lB l.
Option	Description
numpad:pc	Default numeric keypad keys
numpad:mac	Numeric keypad always enters digits (as in macOS)
numpad:microsoft	Num Lock on: digits; Shift for arrows. Num Lock off: arrows (as in Windows)
numpad:shift3	Shift does not cancel Num Lock, chooses 3rd level instead
srvrkeys:none	Special keys (Ctrl+Alt+<key>) handled in a server
apple:alupckeys	Apple Aluminium emulates Pause, PrtSc, Scroll Lock
shift:breaks_caps	Shift cancels Caps Lock
misc:typo	Enable extra typographic characters
misc:apl	Enable APL overlay characters
shift:both_capslock	Both Shifts together enable Caps Lock
shift:both_capslock_cancel	Both Shifts together enable Caps Lock; one Shift key disables it
shift:both_shiftlock	Both Shifts together enable Shift Lock
keypad:pointerkeys	Shift + Num Lock enables PointerKeys
grab:break_actions	Allow breaking grabs with keyboard actions (warning: security risk)
grab:debug	Allow grab and window tree logging

.TE


.SS
Currency signs
.BR
.TS
left,box;
lB lB
___
lB l.
Option	Description
eurosign:e	Euro on E
eurosign:2	Euro on 2
eurosign:4	Euro on 4
eurosign:5	Euro on 5
rupeesign:4	Rupee on 4

.TE


.SS
Key to choose 5th level
.BR
.TS
left,box;
lB lB
___
lB l.
Option	Description
lv5:caps_switch	Caps Lock chooses 5th level
lv5:lsgt_switch	The "< >" key chooses 5th level
lv5:ralt_switch	Right Alt chooses 5th level
lv5:menu_switch	Menu chooses 5th level
lv5:rctrl_switch	Right Ctrl chooses 5th level
lv5:lsgt_switch_lock	The "< >" key chooses 5th level and acts as a one-time lock if pressed with another 5th level chooser
lv5:ralt_switch_lock	Right Alt chooses 5th level and acts as a one-time lock if pressed with another 5th level chooser
lv5:lwin_switch_lock	Left Win chooses 5th level and acts as a one-time lock if pressed with another 5th level chooser
lv5:rwin_switch_lock	Right Win chooses 5th level and acts as a one-time lock if pressed with another 5th level chooser

.TE


.SS
Non-breaking space input
.BR
.TS
left,box;
lB lB
___
lB l.
Option	Description
nbsp:none	Usual space at any level
nbsp:level2	Non-breaking space at the 2nd level
nbsp:level3	Non-breaking space at the 3rd level
nbsp:level3n	Non-breaking space at the 3rd level, thin non-breaking space at the 4th level
nbsp:level4	Non-breaking space at the 4th level
nbsp:level4n	Non-breaking space at the 4th level, thin non-breaking space at the 6th level
nbsp:level4nl	Non-breaking space at the 4th level, thin non-breaking space at the 6th level (via Ctrl+Shift)
nbsp:zwnj2	Zero-width non-joiner at the 2nd level
nbsp:zwnj2zwj3	Zero-width non-joiner at the 2nd level, zero-width joiner at the 3rd level
nbsp:zwnj2zwj3nb4	Zero-width non-joiner at the 2nd level, zero-width joiner at the 3rd level, non-breaking space at the 4th level
nbsp:zwnj2nb3	Zero-width non-joiner at the 2nd level, non-breaking space at the 3rd level
nbsp:zwnj2nb3zwj4	Zero-width non-joiner at the 2nd level, non-breaking space at the 3rd level, zero-width joiner at the 4th level
nbsp:zwnj2nb3nnb4	Zero-width non-joiner at the 2nd level, non-breaking space at the 3rd level, thin non-breaking space at the 4th level
nbsp:zwnj3zwj4	Zero-width non-joiner at the 3rd level, zero-width joiner at the 4th level

.TE


.SS
Japanese keyboard options
.BR
.TS
left,box;
lB lB
___
lB l.
Option	Description
japan:kana_lock	Kana Lock key is locking
japan:nicola_f_bs	NICOLA-F style Backspace
japan:hztg_escape	Make Zenkaku Hankaku an additional Esc

.TE


.SS
Korean Hangul/Hanja keys
.BR
.TS
left,box;
lB lB
___
lB l.
Option	Description
korean:ralt_hangul	Make right Alt a Hangul key
korean:rctrl_hangul	Make right Ctrl a Hangul key
korean:ralt_hanja	Make right Alt a Hanja key
korean:rctrl_hanja	Make right Ctrl a Hanja key

.TE


.SS
Esperanto letters with superscripts
.BR
.TS
left,box;
lB lB
___
lB l.
Option	Description
esperanto:qwerty	At the corresponding key in a QWERTY layout
esperanto:dvorak	At the corresponding key in a Dvorak layout
esperanto:colemak	At the corresponding key in a Colemak layout

.TE


.SS
Old Solaris keycodes compatibility
.BR
.TS
left,box;
lB lB
___
lB l.
Option	Description
solaris:sun_compat	Sun key compatibility

.TE


.SS
Key sequence to kill the X server
.BR
.TS
left,box;
lB lB
___
lB l.
Option	Description
terminate:ctrl_alt_bksp	Ctrl+Alt+Backspace

.TE


.SH FILES
@xkb_base@/compat

@xkb_base@/compiled

@xkb_base@/geometry

@xkb_base@/keycodes

@xkb_base@/keymap

@xkb_base@/rules

@xkb_base@/semantics

@xkb_base@/symbols

@xkb_base@/types

.SH SEE ALSO
setxkbmap(1)
