# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=fontconfig
VER=2.7.1
REV=2
ARCH=win64

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${MOD}_${VER}-${REV}_${ARCH}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

# We use a string of hex digits to make it more evident that it is
# just a hash value and not supposed to be relevant at end-user
# machines.
HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usestable
usemingw64
usemsvs9x64

(

set -x

EXPAT=`latest --arch=${ARCH} expat`
FREETYPE=`latest --arch=${ARCH} freetype`

# Don't let libtool do its relinking dance. Don't know how relevant
# this is, but it doesn't hurt anyway.

sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

patch -p1 <<\EOF &&
commit ba36869b14a289da5d1ce191bdab3f246e543bcc
Author: Tor Lillqvist <tml@iki.fi>
Date:   Fri Aug 14 00:02:59 2009 +0300

    Fix MinGW compilation
    
    Need to define _WIN32_WINNT as 0x0500 to get declaration for
    GetSystemWindowsDirectory().

diff --git a/src/fcxml.c b/src/fcxml.c
index 9dc64e2..7b7bbfd 100644
--- a/src/fcxml.c
+++ b/src/fcxml.c
@@ -53,6 +53,7 @@
 #endif /* ENABLE_LIBXML2 */
 
 #ifdef _WIN32
+#define _WIN32_WINNT 0x0500
 #define STRICT
 #include <windows.h>
 #undef STRICT

commit 5252959955249f0331fb9583c69d359c4563f1c1
Author: Tor Lillqvist <tml@iki.fi>
Date:   Fri Aug 14 00:08:17 2009 +0300

    Fix heap corruption on Windows in FcEndElement()
    
    Must not call FcStrFree() on a value returned by
    FcStrBufDoneStatic(). In the Windows code don't bother with dynamic
    allocation, just use a local buffer.

diff --git a/src/fcxml.c b/src/fcxml.c
index 7b7bbfd..e829422 100644
--- a/src/fcxml.c
+++ b/src/fcxml.c
@@ -2031,7 +2031,10 @@ FcEndElement(void *userData, const XML_Char *name)
 {
     FcConfigParse   *parse = userData;
     FcChar8	    *data;
-    
+#ifdef _WIN32
+    FcChar8         buffer[1000];
+#endif
+
     if (!parse->pstack)
 	return;
     switch (parse->pstack->element) {
@@ -2050,18 +2053,10 @@ FcEndElement(void *userData, const XML_Char *name)
 	if (strcmp (data, "CUSTOMFONTDIR") == 0)
 	{
 		char *p;
-		FcStrFree (data);
-		data = malloc (1000);
-		if (!data)
-		{
-			FcConfigMessage (parse, FcSevereError, "out of memory");
-			break;
-		}
-		FcMemAlloc (FC_MEM_STRING, 1000);
-		if(!GetModuleFileName(NULL, data, 1000))
+		data = buffer;
+		if (!GetModuleFileName (NULL, buffer, sizeof (buffer) - 20))
 		{
 			FcConfigMessage (parse, FcSevereError, "GetModuleFileName failed");
-			FcStrFree (data);
 			break;
 		}
 		p = strrchr (data, '\\');
@@ -2071,18 +2066,10 @@ FcEndElement(void *userData, const XML_Char *name)
 	else if (strcmp (data, "APPSHAREFONTDIR") == 0)
 	{
 		char *p;
-		FcStrFree (data);
-		data = malloc (1000);
-		if (!data)
-		{
-			FcConfigMessage (parse, FcSevereError, "out of memory");
-			break;
-		}
-		FcMemAlloc (FC_MEM_STRING, 1000);
-		if(!GetModuleFileName(NULL, data, 1000))
+		data = buffer;
+		if (!GetModuleFileName (NULL, buffer, sizeof (buffer) - 20))
 		{
 			FcConfigMessage (parse, FcSevereError, "GetModuleFileName failed");
-			FcStrFree (data);
 			break;
 		}
 		p = strrchr (data, '\\');
@@ -2092,19 +2079,11 @@ FcEndElement(void *userData, const XML_Char *name)
 	else if (strcmp (data, "WINDOWSFONTDIR") == 0)
 	{
 	    int rc;
-	    FcStrFree (data);
-	    data = malloc (1000);
-	    if (!data)
-	    {
-		FcConfigMessage (parse, FcSevereError, "out of memory");
-		break;
-	    }
-	    FcMemAlloc (FC_MEM_STRING, 1000);
-	    rc = GetSystemWindowsDirectory (data, 800);
-	    if (rc == 0 || rc > 800)
+	    data = buffer;
+	    rc = GetSystemWindowsDirectory (buffer, sizeof (buffer) - 20);
+	    if (rc == 0 || rc > sizeof (buffer) - 20)
 	    {
 		FcConfigMessage (parse, FcSevereError, "GetSystemWindowsDirectory failed");
-		FcStrFree (data);
 		break;
 	    }
 	    if (data [strlen (data) - 1] != '\\')

commit 9abb5bda12c87f19f7924345467a3fe99ed756d5
Author: Tor Lillqvist <tml@iki.fi>
Date:   Fri Aug 14 00:16:18 2009 +0300

    Use multi-byte codepage aware string function on Windows
    
    The East Asian double-byte codepages have characters with backslash as
    the second byte, so we must use _mbsrchr() instead of strrchr() when
    looking at pathnames in the system codepage.

diff --git a/src/fcxml.c b/src/fcxml.c
index e829422..ef85a4f 100644
--- a/src/fcxml.c
+++ b/src/fcxml.c
@@ -57,6 +57,7 @@
 #define STRICT
 #include <windows.h>
 #undef STRICT
+#include <mbstring.h>
 #endif
 
 static void
@@ -2059,7 +2060,13 @@ FcEndElement(void *userData, const XML_Char *name)
 			FcConfigMessage (parse, FcSevereError, "GetModuleFileName failed");
 			break;
 		}
-		p = strrchr (data, '\\');
+		/*
+		 * Must use the multi-byte aware function to search
+		 * for backslash because East Asian double-byte code
+		 * pages have characters with backslash as the second
+		 * byte.
+		 */
+		p = _mbsrchr (data, '\\');
 		if (p) *p = '\0';
 		strcat (data, "\\fonts");
 	}
@@ -2072,7 +2079,7 @@ FcEndElement(void *userData, const XML_Char *name)
 			FcConfigMessage (parse, FcSevereError, "GetModuleFileName failed");
 			break;
 		}
-		p = strrchr (data, '\\');
+		p = _mbsrchr (data, '\\');
 		if (p) *p = '\0';
 		strcat (data, "\\..\\share\\fonts");
 	}
EOF

patch -p0 <<\EOF &&
--- src/Makefile.in
+++ src/Makefile.in
@@ -620,6 +620,7 @@
 # gcc import library install/uninstall
 
 @OS_WIN32_TRUE@install-libtool-import-lib: 
+@OS_WIN32_TRUE@	$(mkdir_p) $(DESTDIR)$(libdir)
 @OS_WIN32_TRUE@	$(INSTALL) .libs/libfontconfig.dll.a $(DESTDIR)$(libdir)
 @OS_WIN32_TRUE@	$(INSTALL) fontconfig.def $(DESTDIR)$(libdir)/fontconfig.def
 
@@ -630,9 +630,10 @@
 @OS_WIN32_FALSE@uninstall-libtool-import-lib:
 
 @MS_LIB_AVAILABLE_TRUE@fontconfig.lib : libfontconfig.la
-@MS_LIB_AVAILABLE_TRUE@	lib -name:libfontconfig-$(lt_current_minus_age).dll -def:fontconfig.def -out:$@
+@MS_LIB_AVAILABLE_TRUE@	lib -machine:X64 -name:libfontconfig-$(LIBT_CURRENT_MINUS_AGE).dll -def:fontconfig.def -out:$@
 
 @MS_LIB_AVAILABLE_TRUE@install-ms-import-lib:
+@MS_LIB_AVAILABLE_TRUE@	$(mkdir_p) $(DESTDIR)$(libdir)
 @MS_LIB_AVAILABLE_TRUE@	$(INSTALL) fontconfig.lib $(DESTDIR)$(libdir)
 
 @MS_LIB_AVAILABLE_TRUE@uninstall-ms-import-lib:
--- fontconfig-zip.in
+++ fontconfig-zip.in
@@ -15,7 +15,7 @@
 EOF
 
 rm -f $DEVZIP
-zip -r $DEVZIP -@ <<EOF
+zip -r -D $DEVZIP -@ <<EOF
 etc/fonts/fonts.dtd
 include/fontconfig
 lib/libfontconfig.dll.a
@@ -24,10 +24,6 @@
 lib/pkgconfig/fontconfig.pc
 bin/fc-list.exe
 bin/fc-cache.exe
-man/man1/fc-cache.1
-man/man1/fc-list.1
-man/man5/fonts-conf.5
+share/man
 share/doc/fontconfig
 EOF
-
-zip $DEVZIP man/man3/Fc*.3
EOF

# Brute force solution for problems with libtool: use
# lt_cv_deplibs_check_method= pass_all

lt_cv_deplibs_check_method='pass_all' \
CC='x86_64-w64-mingw32-gcc' \
LDFLAGS='-Wl,--enable-auto-image-base' \
CFLAGS=-O2 \
./configure --host=x86_64-w64-mingw32 --with-arch=win64 --with-expat="/devel/dist/win64/$EXPAT" --with-freetype-config="/devel/dist/${ARCH}/$FREETYPE/bin/freetype-config" --prefix=c:/devel/target/$HEX  --with-confdir=c:/devel/target/$HEX/etc/fonts --disable-static &&

libtoolcacheize &&

make -j3 install &&

(cd /devel/target/$HEX/lib && lib.exe -machine:X64 -def:fontconfig.def -out:fontconfig.lib) &&

sed -e "s/@VERSION@/$VER/" <fontconfig-zip.in >fontconfig-zip.in.tem && mv fontconfig-zip.in.tem fontconfig-zip.in &&

./config.status --file=fontconfig-zip &&
./fontconfig-zip &&

mv /tmp/$MOD-$VER.zip /tmp/$RUNZIP &&
mv /tmp/$MOD-dev-$VER.zip /tmp/$DEVZIP

) 2>&1 | tee /devel/src/tml/packaging/$THIS.log

(cd /devel && zip /tmp/$DEVZIP src/tml/packaging/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
