# Copyright 2020-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

DISTUTILS_EXT=1
DISTUTILS_USE_PEP517=setuptools
PYTHON_COMPAT=( pypy3_11 python3_{11..14} )

inherit distutils-r1 pypi

DESCRIPTION="Time-handling functionality from netcdf4-python"
HOMEPAGE="
	https://github.com/Unidata/cftime/
	https://pypi.org/project/cftime/
"

LICENSE="GPL-3"
SLOT="0"
KEYWORDS="amd64 arm64 ~loong ~riscv ~s390 ~x86"

DEPEND="
	>=dev-python/numpy-1.26.0[${PYTHON_USEDEP}]
"
RDEPEND="
	${DEPEND}
"
BDEPEND="
	>=dev-python/cython-0.29.20[${PYTHON_USEDEP}]
"

EPYTEST_PLUGINS=()
distutils_enable_tests pytest
