# frozen_string_literal: true

=begin
This file is generated by the templates/template.rb script and should not be
modified manually. See templates/lib/prism/visitor.rb.erb
if you are looking to modify the template
=end

module Prism
  # A class that knows how to walk down the tree. None of the individual visit
  # methods are implemented on this visitor, so it forces the consumer to
  # implement each one that they need. For a default implementation that
  # continues walking the tree, see the Visitor class.
  class BasicVisitor
    # Calls `accept` on the given node if it is not `nil`, which in turn should
    # call back into this visitor by calling the appropriate `visit_*` method.
    def visit(node)
      # @type self: _Visitor
      node&.accept(self)
    end

    # Visits each node in `nodes` by calling `accept` on each one.
    def visit_all(nodes)
      # @type self: _Visitor
      nodes.each { |node| node&.accept(self) }
    end

    # Visits the child nodes of `node` by calling `accept` on each one.
    def visit_child_nodes(node)
      # @type self: _Visitor
      node.compact_child_nodes.each { |node| node.accept(self) }
    end
  end

  # A visitor is a class that provides a default implementation for every accept
  # method defined on the nodes. This means it can walk a tree without the
  # caller needing to define any special handling. This allows you to handle a
  # subset of the tree, while still walking the whole tree.
  #
  # For example, to find all of the method calls that call the `foo` method, you
  # could write:
  #
  #     class FooCalls < Prism::Visitor
  #       def visit_call_node(node)
  #         if node.name == "foo"
  #           # Do something with the node
  #         end
  #
  #         # Call super so that the visitor continues walking the tree
  #         super
  #       end
  #     end
  #
  class Visitor < BasicVisitor
    # Visit a AliasGlobalVariableNode node
    alias visit_alias_global_variable_node visit_child_nodes

    # Visit a AliasMethodNode node
    alias visit_alias_method_node visit_child_nodes

    # Visit a AlternationPatternNode node
    alias visit_alternation_pattern_node visit_child_nodes

    # Visit a AndNode node
    alias visit_and_node visit_child_nodes

    # Visit a ArgumentsNode node
    alias visit_arguments_node visit_child_nodes

    # Visit a ArrayNode node
    alias visit_array_node visit_child_nodes

    # Visit a ArrayPatternNode node
    alias visit_array_pattern_node visit_child_nodes

    # Visit a AssocNode node
    alias visit_assoc_node visit_child_nodes

    # Visit a AssocSplatNode node
    alias visit_assoc_splat_node visit_child_nodes

    # Visit a BackReferenceReadNode node
    alias visit_back_reference_read_node visit_child_nodes

    # Visit a BeginNode node
    alias visit_begin_node visit_child_nodes

    # Visit a BlockArgumentNode node
    alias visit_block_argument_node visit_child_nodes

    # Visit a BlockLocalVariableNode node
    alias visit_block_local_variable_node visit_child_nodes

    # Visit a BlockNode node
    alias visit_block_node visit_child_nodes

    # Visit a BlockParameterNode node
    alias visit_block_parameter_node visit_child_nodes

    # Visit a BlockParametersNode node
    alias visit_block_parameters_node visit_child_nodes

    # Visit a BreakNode node
    alias visit_break_node visit_child_nodes

    # Visit a CallAndWriteNode node
    alias visit_call_and_write_node visit_child_nodes

    # Visit a CallNode node
    alias visit_call_node visit_child_nodes

    # Visit a CallOperatorWriteNode node
    alias visit_call_operator_write_node visit_child_nodes

    # Visit a CallOrWriteNode node
    alias visit_call_or_write_node visit_child_nodes

    # Visit a CallTargetNode node
    alias visit_call_target_node visit_child_nodes

    # Visit a CapturePatternNode node
    alias visit_capture_pattern_node visit_child_nodes

    # Visit a CaseMatchNode node
    alias visit_case_match_node visit_child_nodes

    # Visit a CaseNode node
    alias visit_case_node visit_child_nodes

    # Visit a ClassNode node
    alias visit_class_node visit_child_nodes

    # Visit a ClassVariableAndWriteNode node
    alias visit_class_variable_and_write_node visit_child_nodes

    # Visit a ClassVariableOperatorWriteNode node
    alias visit_class_variable_operator_write_node visit_child_nodes

    # Visit a ClassVariableOrWriteNode node
    alias visit_class_variable_or_write_node visit_child_nodes

    # Visit a ClassVariableReadNode node
    alias visit_class_variable_read_node visit_child_nodes

    # Visit a ClassVariableTargetNode node
    alias visit_class_variable_target_node visit_child_nodes

    # Visit a ClassVariableWriteNode node
    alias visit_class_variable_write_node visit_child_nodes

    # Visit a ConstantAndWriteNode node
    alias visit_constant_and_write_node visit_child_nodes

    # Visit a ConstantOperatorWriteNode node
    alias visit_constant_operator_write_node visit_child_nodes

    # Visit a ConstantOrWriteNode node
    alias visit_constant_or_write_node visit_child_nodes

    # Visit a ConstantPathAndWriteNode node
    alias visit_constant_path_and_write_node visit_child_nodes

    # Visit a ConstantPathNode node
    alias visit_constant_path_node visit_child_nodes

    # Visit a ConstantPathOperatorWriteNode node
    alias visit_constant_path_operator_write_node visit_child_nodes

    # Visit a ConstantPathOrWriteNode node
    alias visit_constant_path_or_write_node visit_child_nodes

    # Visit a ConstantPathTargetNode node
    alias visit_constant_path_target_node visit_child_nodes

    # Visit a ConstantPathWriteNode node
    alias visit_constant_path_write_node visit_child_nodes

    # Visit a ConstantReadNode node
    alias visit_constant_read_node visit_child_nodes

    # Visit a ConstantTargetNode node
    alias visit_constant_target_node visit_child_nodes

    # Visit a ConstantWriteNode node
    alias visit_constant_write_node visit_child_nodes

    # Visit a DefNode node
    alias visit_def_node visit_child_nodes

    # Visit a DefinedNode node
    alias visit_defined_node visit_child_nodes

    # Visit a ElseNode node
    alias visit_else_node visit_child_nodes

    # Visit a EmbeddedStatementsNode node
    alias visit_embedded_statements_node visit_child_nodes

    # Visit a EmbeddedVariableNode node
    alias visit_embedded_variable_node visit_child_nodes

    # Visit a EnsureNode node
    alias visit_ensure_node visit_child_nodes

    # Visit a FalseNode node
    alias visit_false_node visit_child_nodes

    # Visit a FindPatternNode node
    alias visit_find_pattern_node visit_child_nodes

    # Visit a FlipFlopNode node
    alias visit_flip_flop_node visit_child_nodes

    # Visit a FloatNode node
    alias visit_float_node visit_child_nodes

    # Visit a ForNode node
    alias visit_for_node visit_child_nodes

    # Visit a ForwardingArgumentsNode node
    alias visit_forwarding_arguments_node visit_child_nodes

    # Visit a ForwardingParameterNode node
    alias visit_forwarding_parameter_node visit_child_nodes

    # Visit a ForwardingSuperNode node
    alias visit_forwarding_super_node visit_child_nodes

    # Visit a GlobalVariableAndWriteNode node
    alias visit_global_variable_and_write_node visit_child_nodes

    # Visit a GlobalVariableOperatorWriteNode node
    alias visit_global_variable_operator_write_node visit_child_nodes

    # Visit a GlobalVariableOrWriteNode node
    alias visit_global_variable_or_write_node visit_child_nodes

    # Visit a GlobalVariableReadNode node
    alias visit_global_variable_read_node visit_child_nodes

    # Visit a GlobalVariableTargetNode node
    alias visit_global_variable_target_node visit_child_nodes

    # Visit a GlobalVariableWriteNode node
    alias visit_global_variable_write_node visit_child_nodes

    # Visit a HashNode node
    alias visit_hash_node visit_child_nodes

    # Visit a HashPatternNode node
    alias visit_hash_pattern_node visit_child_nodes

    # Visit a IfNode node
    alias visit_if_node visit_child_nodes

    # Visit a ImaginaryNode node
    alias visit_imaginary_node visit_child_nodes

    # Visit a ImplicitNode node
    alias visit_implicit_node visit_child_nodes

    # Visit a ImplicitRestNode node
    alias visit_implicit_rest_node visit_child_nodes

    # Visit a InNode node
    alias visit_in_node visit_child_nodes

    # Visit a IndexAndWriteNode node
    alias visit_index_and_write_node visit_child_nodes

    # Visit a IndexOperatorWriteNode node
    alias visit_index_operator_write_node visit_child_nodes

    # Visit a IndexOrWriteNode node
    alias visit_index_or_write_node visit_child_nodes

    # Visit a IndexTargetNode node
    alias visit_index_target_node visit_child_nodes

    # Visit a InstanceVariableAndWriteNode node
    alias visit_instance_variable_and_write_node visit_child_nodes

    # Visit a InstanceVariableOperatorWriteNode node
    alias visit_instance_variable_operator_write_node visit_child_nodes

    # Visit a InstanceVariableOrWriteNode node
    alias visit_instance_variable_or_write_node visit_child_nodes

    # Visit a InstanceVariableReadNode node
    alias visit_instance_variable_read_node visit_child_nodes

    # Visit a InstanceVariableTargetNode node
    alias visit_instance_variable_target_node visit_child_nodes

    # Visit a InstanceVariableWriteNode node
    alias visit_instance_variable_write_node visit_child_nodes

    # Visit a IntegerNode node
    alias visit_integer_node visit_child_nodes

    # Visit a InterpolatedMatchLastLineNode node
    alias visit_interpolated_match_last_line_node visit_child_nodes

    # Visit a InterpolatedRegularExpressionNode node
    alias visit_interpolated_regular_expression_node visit_child_nodes

    # Visit a InterpolatedStringNode node
    alias visit_interpolated_string_node visit_child_nodes

    # Visit a InterpolatedSymbolNode node
    alias visit_interpolated_symbol_node visit_child_nodes

    # Visit a InterpolatedXStringNode node
    alias visit_interpolated_x_string_node visit_child_nodes

    # Visit a ItLocalVariableReadNode node
    alias visit_it_local_variable_read_node visit_child_nodes

    # Visit a ItParametersNode node
    alias visit_it_parameters_node visit_child_nodes

    # Visit a KeywordHashNode node
    alias visit_keyword_hash_node visit_child_nodes

    # Visit a KeywordRestParameterNode node
    alias visit_keyword_rest_parameter_node visit_child_nodes

    # Visit a LambdaNode node
    alias visit_lambda_node visit_child_nodes

    # Visit a LocalVariableAndWriteNode node
    alias visit_local_variable_and_write_node visit_child_nodes

    # Visit a LocalVariableOperatorWriteNode node
    alias visit_local_variable_operator_write_node visit_child_nodes

    # Visit a LocalVariableOrWriteNode node
    alias visit_local_variable_or_write_node visit_child_nodes

    # Visit a LocalVariableReadNode node
    alias visit_local_variable_read_node visit_child_nodes

    # Visit a LocalVariableTargetNode node
    alias visit_local_variable_target_node visit_child_nodes

    # Visit a LocalVariableWriteNode node
    alias visit_local_variable_write_node visit_child_nodes

    # Visit a MatchLastLineNode node
    alias visit_match_last_line_node visit_child_nodes

    # Visit a MatchPredicateNode node
    alias visit_match_predicate_node visit_child_nodes

    # Visit a MatchRequiredNode node
    alias visit_match_required_node visit_child_nodes

    # Visit a MatchWriteNode node
    alias visit_match_write_node visit_child_nodes

    # Visit a MissingNode node
    alias visit_missing_node visit_child_nodes

    # Visit a ModuleNode node
    alias visit_module_node visit_child_nodes

    # Visit a MultiTargetNode node
    alias visit_multi_target_node visit_child_nodes

    # Visit a MultiWriteNode node
    alias visit_multi_write_node visit_child_nodes

    # Visit a NextNode node
    alias visit_next_node visit_child_nodes

    # Visit a NilNode node
    alias visit_nil_node visit_child_nodes

    # Visit a NoKeywordsParameterNode node
    alias visit_no_keywords_parameter_node visit_child_nodes

    # Visit a NumberedParametersNode node
    alias visit_numbered_parameters_node visit_child_nodes

    # Visit a NumberedReferenceReadNode node
    alias visit_numbered_reference_read_node visit_child_nodes

    # Visit a OptionalKeywordParameterNode node
    alias visit_optional_keyword_parameter_node visit_child_nodes

    # Visit a OptionalParameterNode node
    alias visit_optional_parameter_node visit_child_nodes

    # Visit a OrNode node
    alias visit_or_node visit_child_nodes

    # Visit a ParametersNode node
    alias visit_parameters_node visit_child_nodes

    # Visit a ParenthesesNode node
    alias visit_parentheses_node visit_child_nodes

    # Visit a PinnedExpressionNode node
    alias visit_pinned_expression_node visit_child_nodes

    # Visit a PinnedVariableNode node
    alias visit_pinned_variable_node visit_child_nodes

    # Visit a PostExecutionNode node
    alias visit_post_execution_node visit_child_nodes

    # Visit a PreExecutionNode node
    alias visit_pre_execution_node visit_child_nodes

    # Visit a ProgramNode node
    alias visit_program_node visit_child_nodes

    # Visit a RangeNode node
    alias visit_range_node visit_child_nodes

    # Visit a RationalNode node
    alias visit_rational_node visit_child_nodes

    # Visit a RedoNode node
    alias visit_redo_node visit_child_nodes

    # Visit a RegularExpressionNode node
    alias visit_regular_expression_node visit_child_nodes

    # Visit a RequiredKeywordParameterNode node
    alias visit_required_keyword_parameter_node visit_child_nodes

    # Visit a RequiredParameterNode node
    alias visit_required_parameter_node visit_child_nodes

    # Visit a RescueModifierNode node
    alias visit_rescue_modifier_node visit_child_nodes

    # Visit a RescueNode node
    alias visit_rescue_node visit_child_nodes

    # Visit a RestParameterNode node
    alias visit_rest_parameter_node visit_child_nodes

    # Visit a RetryNode node
    alias visit_retry_node visit_child_nodes

    # Visit a ReturnNode node
    alias visit_return_node visit_child_nodes

    # Visit a SelfNode node
    alias visit_self_node visit_child_nodes

    # Visit a ShareableConstantNode node
    alias visit_shareable_constant_node visit_child_nodes

    # Visit a SingletonClassNode node
    alias visit_singleton_class_node visit_child_nodes

    # Visit a SourceEncodingNode node
    alias visit_source_encoding_node visit_child_nodes

    # Visit a SourceFileNode node
    alias visit_source_file_node visit_child_nodes

    # Visit a SourceLineNode node
    alias visit_source_line_node visit_child_nodes

    # Visit a SplatNode node
    alias visit_splat_node visit_child_nodes

    # Visit a StatementsNode node
    alias visit_statements_node visit_child_nodes

    # Visit a StringNode node
    alias visit_string_node visit_child_nodes

    # Visit a SuperNode node
    alias visit_super_node visit_child_nodes

    # Visit a SymbolNode node
    alias visit_symbol_node visit_child_nodes

    # Visit a TrueNode node
    alias visit_true_node visit_child_nodes

    # Visit a UndefNode node
    alias visit_undef_node visit_child_nodes

    # Visit a UnlessNode node
    alias visit_unless_node visit_child_nodes

    # Visit a UntilNode node
    alias visit_until_node visit_child_nodes

    # Visit a WhenNode node
    alias visit_when_node visit_child_nodes

    # Visit a WhileNode node
    alias visit_while_node visit_child_nodes

    # Visit a XStringNode node
    alias visit_x_string_node visit_child_nodes

    # Visit a YieldNode node
    alias visit_yield_node visit_child_nodes
  end
end
