# This file has been autogenerated by the pywayland scanner

# Copyright © 2021 Emmanuel Gil Peyrot
# Copyright © 2022 Xaver Hugl
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)


class WpContentTypeV1(Interface):
    """Content type object for a surface

    The content type object allows the compositor to optimize for the kind of
    content shown on the surface. A compositor may for example use it to set
    relevant drm properties like "content type".

    The client may request to switch to another content type at any time. When
    the associated surface gets destroyed, this object becomes inert and the
    client should destroy it.
    """

    name = "wp_content_type_v1"
    version = 1

    class type(enum.IntEnum):
        none = 0
        photo = 1
        video = 2
        game = 3


class WpContentTypeV1Proxy(Proxy[WpContentTypeV1]):
    interface = WpContentTypeV1

    @WpContentTypeV1.request()
    def destroy(self) -> None:
        """Destroy the content type object

        Switch back to not specifying the content type of this surface. This is
        equivalent to setting the content type to none, including double
        buffering semantics. See set_content_type for details.
        """
        self._marshal(0)
        self._destroy()

    @WpContentTypeV1.request(
        Argument(ArgumentType.Uint),
    )
    def set_content_type(self, content_type: int) -> None:
        """Specify the content type

        Set the surface content type. This informs the compositor that the
        client believes it is displaying buffers matching this content type.

        This is purely a hint for the compositor, which can be used to adjust
        its behavior or hardware settings to fit the presented content best.

        The content type is double-buffered state, see
        :func:`WlSurface.commit()
        <pywayland.protocol.wayland.WlSurface.commit>` for details.

        :param content_type:
            the content type
        :type content_type:
            `ArgumentType.Uint`
        """
        self._marshal(1, content_type)


class WpContentTypeV1Resource(Resource):
    interface = WpContentTypeV1


class WpContentTypeV1Global(Global):
    interface = WpContentTypeV1


WpContentTypeV1._gen_c()
WpContentTypeV1.proxy_class = WpContentTypeV1Proxy
WpContentTypeV1.resource_class = WpContentTypeV1Resource
WpContentTypeV1.global_class = WpContentTypeV1Global
