/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_bal_Latn extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Grinwech Min Wahd",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Apiáay anjári wahd",
               "",
               "Apiáay róchi wahd",
               "",
               "Apiáay wahd",
               "",
            };
        final String[] Cook = new String[] {
               "Kuk Islánday anjári wahd",
               "",
               "Kuk Islánday ném-garmági wahd",
               "",
               "Kuk Islánday wahd",
               "",
            };
        final String[] Cuba = new String[] {
               "Kyubáay anjári wahd",
               "CST",
               "Kyubáay róchay wahd",
               "CDT",
               "Kyubáay wahd",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Fijiay anjári wahd",
               "",
               "Fijiay garmági wahd",
               "",
               "Fijiay wahd",
               "",
            };
        final String[] Gulf = new String[] {
               "Khalijay anjári wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hówday anjári wahd",
               "",
               "Hówday garmági wahd",
               "",
               "Hówday wahd",
               "",
            };
        final String[] Iran = new String[] {
               "Éránay anjári wahd",
               "",
               "Éránay róchi wahd",
               "",
               "Éránay wahd",
               "",
            };
        final String[] Niue = new String[] {
               "Niuay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Ómskay anjári wahd",
               "",
               "Ómskay garmági wahd",
               "",
               "Ómskay wahd",
               "",
            };
        final String[] Peru = new String[] {
               "Péróay anjári wahd",
               "",
               "Péróay garmági wahd",
               "",
               "Péróay wahd",
               "",
            };
        final String[] Truk = new String[] {
               "Chukay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Wayk Islánday wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Chilayay anjári wahd",
               "",
               "Chilayay garmági wahd",
               "",
               "Chilayay wahd",
               "",
            };
        final String[] China = new String[] {
               "Chinay anjári wahd",
               "CST",
               "Chinay róchi wahd",
               "CDT",
               "Chinay wahd",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Kukus Islánday wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Dawisay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Henday anjári wahd",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Jápánay anjári wahd",
               "JST",
               "Jápánay róchi wahd",
               "JDT",
               "Jápánay wahd",
               "JT",
            };
        final String[] Korea = new String[] {
               "Kóriáay anjári wahd",
               "KST",
               "Kóriáay róchi wahd",
               "KST",
               "Kóriáay wahd",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Nauruay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Népálay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Paláuay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samóáway anjári wahd",
               "SST",
               "Samóáway róchi wahd",
               "SST",
               "Samóáway wahd",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Syówáay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tongáay anjári wahd",
               "",
               "Tongáay garmági wahd",
               "",
               "Tongáay wahd",
               "",
            };
        final String[] Yukon = new String[] {
               "Yukón wahd",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Aláskáay anjári wahd",
               "AKST",
               "Aláskáay garmági wahd",
               "AKDT",
               "Aláskáay wahd",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Amázónay anjári wahd",
               "",
               "Amázónay garmági wahd",
               "",
               "Amázónay wahd",
               "",
            };
        final String[] Azores = new String[] {
               "Azóresay anjári wahd",
               "",
               "Azóresay garmági wahd",
               "",
               "Azóresay wahd",
               "",
            };
        final String[] Bhutan = new String[] {
               "Buthánay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunáiay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Isthar Islánday anjári wahd",
               "",
               "Isthar Islánday garmági wahd",
               "",
               "Isthar Islánday wahd",
               "",
            };
        final String[] Guyana = new String[] {
               "Guyánáay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Esráilay anjári wahd",
               "IST",
               "Esráilay róchi wahd",
               "IDT",
               "Esráilay wahd",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Kósraiay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Mawsonay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Máskóay anjári wahd",
               "MSK",
               "Máskóay garmági wahd",
               "MSK",
               "Máskóay wahd",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Pónpiay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahitiay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Táipiay anjári wahd",
               "CST",
               "Táipiay róchi wahd",
               "CDT",
               "Táipiay wahd",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Tuwáluay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Wostokay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wallis o Futunáay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arabi anjári wahd",
               "",
               "Arabi róchi wahd",
               "",
               "Arabi wahd",
               "",
            };
        final String[] Armenia = new String[] {
               "Árminiáay anjári wahd",
               "",
               "Árminiáay garmági wahd",
               "",
               "Árminiáay wahd",
               "",
            };
        final String[] Bolivia = new String[] {
               "Boliwiáay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Chatam anjári wahd",
               "",
               "Chatam róchi wahd",
               "",
               "Chatam wahd",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Hamdárén Jaháni wahd",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ekwádóray wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambiray wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Járjiáay anjári wahd",
               "",
               "Járjiáay garmági wahd",
               "",
               "Járjiáay wahd",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Erkuskay anjári wahd",
               "",
               "Erkuskay garmági wahd",
               "",
               "Erkuskay wahd",
               "",
            };
        final String[] Magadan = new String[] {
               "Mágadánay anjári wahd",
               "",
               "Mágadánay garmági wahd",
               "",
               "Mágadánay wahd",
               "",
            };
        final String[] Myanmar = new String[] {
               "Myanmáray wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Nurpolk Islánday anjári wahd",
               "",
               "Nurpolk Islánday róchi wahd",
               "",
               "Nurpolk Islánday wahd",
               "",
            };
        final String[] Noronha = new String[] {
               "Noronáay anjári wahd",
               "",
               "Noronáay garmági wahd",
               "",
               "Noronáay wahd",
               "",
            };
        final String[] Reunion = new String[] {
               "Réyunianay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rothéráay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Solomán Islánday wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokeláuay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Yurógóayay anjári wahd",
               "",
               "Yurógóayay garmági wahd",
               "",
               "Yurógóayay wahd",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Wánuátuay anjári wahd",
               "",
               "Wánuátuay garmági wahd",
               "",
               "Wánuátuay wahd",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Yákuskay anjári wahd",
               "",
               "Yákuskay garmági wahd",
               "",
               "Yákuskay wahd",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlantáay anjári wahd",
               "AST",
               "Atlantáay róchi wahd",
               "AST",
               "Atlantáay wahd",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Brázilay anjári wahd",
               "",
               "Brázilay garmági wahd",
               "",
               "Brázilay wahd",
               "",
            };
        final String[] Chamorro = new String[] {
               "Chamorróay wahd",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Kolambiáay anjári wahd",
               "",
               "Kolambiáay garmági wahd",
               "",
               "Kolambiáay wahd",
               "",
            };
        final String[] Falkland = new String[] {
               "Palklánd Islánday anjári wahd",
               "",
               "Palklánd Islánday garmági wahd",
               "",
               "Palklánd Islánday wahd",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malishiáay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Máldipay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulánbátaray anjári wahd",
               "",
               "Ulánbátaray garmági wahd",
               "",
               "Ulánbátaray wahd",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pákestánay anjári wahd",
               "PKT",
               "Pákestánay garmági wahd",
               "PKST",
               "Pákestánay wahd",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Paragóayay anjári wahd",
               "",
               "Paragóayay garmági wahd",
               "",
               "Paragóayay wahd",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitkarénay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sakhálinay anjári wahd",
               "",
               "Sakhálinay garmági wahd",
               "",
               "Sakhálinay wahd",
               "",
            };
        final String[] Suriname = new String[] {
               "Surinaymay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Arjentináay anjári wahd",
               "",
               "Arjentináay garmági wahd",
               "",
               "Arjentináay wahd",
               "",
            };
        final String[] Christmas = new String[] {
               "Kresmes Islánday wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagosay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Háng Kángay anjári wahd",
               "HKT",
               "Háng Kángay garmági wahd",
               "HKST",
               "Háng Kángay wahd",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Hendóchinay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kargezestánay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Ástréliáay, Ládhaway anjári wahd",
               "",
               "Ástréliáay, Ládhaway garmági wahd",
               "",
               "Ástréliáay, Ládhaway wahd",
               "",
            };
        final String[] Marquesas = new String[] {
               "Markésásay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Muritániáay anjári wahd",
               "",
               "Muritániáay garmági wahd",
               "",
               "Muritániáay wahd",
               "",
            };
        final String[] Singapore = new String[] {
               "Sengápuray anjári wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Wenezwéláay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Wolgograday anjári wahd",
               "MSK",
               "Wolgograday garmági wahd",
               "MSK",
               "Wolgograday wahd",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Ázerbáijánay anjári wahd",
               "",
               "Ázerbáijánay garmági wahd",
               "",
               "Ázerbáijánay wahd",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bangaladéshay anjári wahd",
               "",
               "Bangaladéshay garmági wahd",
               "",
               "Bangaladéshay wahd",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Kap Wardéay anjári wahd",
               "",
               "Kap Wardéay garmági wahd",
               "",
               "Kap Wardéay wahd",
               "",
            };
        final String[] East_Timor = new String[] {
               "Ródarátki Timuray wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Kázakestánay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Séchelesay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tájekestánay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Ozbekestánay anjári wahd",
               "",
               "Ozbekestánay garmági wahd",
               "",
               "Ozbekestánay wahd",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Awgánestánay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnóyáskay anjári wahd",
               "",
               "Krasnóyáskay garmági wahd",
               "",
               "Krasnóyáskay wahd",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Niu Zilánday anjári wahd",
               "NZST",
               "Niu Zilánday róchi wahd",
               "NZDT",
               "Niu Zilánday wahd",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Nawásibiskay anjári wahd",
               "",
               "Nawásibiskay garmági wahd",
               "",
               "Nawásibiskay wahd",
               "",
            };
        final String[] Philippines = new String[] {
               "Pelpinay anjári wahd",
               "PST",
               "Pelpinay garmági wahd",
               "PDT",
               "Pelpinay wahd",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Waládiwástókay anjári wahd",
               "",
               "Waládiwástókay garmági wahd",
               "",
               "Waládiwástókay wahd",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Hendi zeray wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Liné Islánday wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Nipándlaynday anjári wahd",
               "NST",
               "Nipándlaynday garmági wahd",
               "NDT",
               "Nipándlaynday wahd",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Torkmenestánay anjári wahd",
               "",
               "Torkmenestánay garmági wahd",
               "",
               "Torkmenestánay wahd",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Paránsi Gwináay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Nyu Kaledóniáay anjári wahd",
               "",
               "Nyu Kaledóniáay garmági wahd",
               "",
               "Nyu Kaledóniáay wahd",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Zerbári Járjiáay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Yakátrinborgay anjári wahd",
               "",
               "Yakátrinborgay garmági wahd",
               "",
               "Yakátrinborgay wahd",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Delgáhi Aprikáay wahd",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Ródarátki Aprikáay wahd",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Rónendi Aprikáay anjári wahd",
               "WAT",
               "Rónendi Aprikáay garmági wahd",
               "WAT",
               "Rónendi Aprikáay wahd",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont Urwilay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Delgáhi Yuropay anjári wahd",
               "CET",
               "Delgáhi Yuropay garmági wahd",
               "CEST",
               "Delgáhi Yuropay wahd",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Ródarátki Yuropay anjári wahd",
               "EET",
               "Ródarátki Yuropay garmági wahd",
               "EEST",
               "Ródarátki Yuropay wahd",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Rónendi Yuropay anjári wahd",
               "WET",
               "Rónendi Yuropay garmági wahd",
               "WEST",
               "Rónendi Yuropay wahd",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Árámzeri Meksikóay anjári wahd",
               "MST",
               "Árámzeri Meksikóay garmági wahd",
               "MDT",
               "Árámzeri Meksikóay wahd",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Ródarátki Aprikáay anjári wahd",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Delgáhi Amrikáay anjári wahd",
               "CST",
               "Delgáhi Amrikáay garmági wahd",
               "CDT",
               "Delgáhi Amrikáay wahd",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Ródarátki Amrikáay anjári wahd",
               "EST",
               "Ródarátki Amrikáay garmági wahd",
               "EST",
               "Ródarátki Amrikáay wahd",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Árámzeri Amrikáay anjári wahd",
               "PST",
               "Árámzeri Amrikáay garmági wahd",
               "PDT",
               "Árámzeri Amrikáay wahd",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Zerbári Paransi o Antárktikáay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gelbart Islánday wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawái/Alushiay anjári wahd",
               "HST",
               "Hawái/Alushiay garmági wahd",
               "HST",
               "Hawái/Alushiay wahd",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoeneks Islánday wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "St. Péri o Mikwélin ajári wahd",
               "",
               "St. Péri o Mikwélin róchi wahd",
               "",
               "St. Péri o Mikwélin wahd",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Kóhestagi Amrikáay anjári wahd",
               "MST",
               "Kóhestagi Amrikáay garmági wahd",
               "MST",
               "Kóhestagi Amrikáay wahd",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Márshal Islánday wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Pápuá Niu Giniáay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Delgáhi Ástréliáay anjári wahd",
               "ACST",
               "Delgáhi Ástréliáay garmági wahd",
               "ACDT",
               "Delgáhi Ástréliáay wahd",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Ródarátki Ástréliáay anjári wahd",
               "AEST",
               "Ródarátki Ástréliáay garmági wahd",
               "AEDT",
               "Ródarátki Ástréliáay wahd",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Rónendi Ástréliáay anjári wahd",
               "AWST",
               "Rónendi Ástréliáay garmági wahd",
               "AWDT",
               "Rónendi Ástréliáay wahd",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Delgáhi Endhonishiáay anjári wahd",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Ródarátki Endhonishiáay anjári wahd",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Rónendi Endhonishiáay anjári wahd",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Delgáhirónendi Ástréliáay anjári wahd",
               "",
               "Delgáhirónendi Ástréliáay garmági wahd",
               "",
               "Delgáhirónendi Ástréliáay wahd",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Grinwech Min Wahd",
                    "GMT",
                    "Bartániái garmági wahd",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Hamdárén Jaháni wahd",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Grinwech Min Wahd",
                    "GMT",
                    "Áeri anjári wahd",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Hamdárén Jaháni wahd",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Hamdárén Jaháni wahd",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Grinwech Min Wahd",
                    "GMT",
                    "Bartániái garmági wahd",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Hamdárén Jaháni wahd",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Hamdárén Jaháni wahd",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Hamdárén Jaháni wahd",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Grinwech Min Wahd",
                    "GMT",
                    "Áeri anjári wahd",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Grinwech Min Wahd",
                    "GMT",
                    "Bartániái garmági wahd",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Grinwech Min Wahd",
                    "GMT",
                    "Bartániái garmági wahd",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Grinwech Min Wahd",
                    "GMT",
                    "Bartániái garmági wahd",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Grinwech Min Wahd",
                    "GMT",
                    "Bartániái garmági wahd",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Grinwech Min Wahd",
                    "GMT",
                    "Bartániái garmági wahd",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Adan" },
            { "timezone.excity.Asia/Baku", "Báku" },
            { "timezone.excity.Asia/Dili", "Dehli" },
            { "timezone.excity.Asia/Hovd", "Hówd" },
            { "timezone.excity.Asia/Oral", "Orál" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Ammán" },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Dhaka", "Dháka" },
            { "timezone.excity.Asia/Dubai", "Dabai" },
            { "timezone.excity.Asia/Kabul", "Kábol" },
            { "timezone.excity.Asia/Macau", "Makáó" },
            { "timezone.excity.Asia/Qatar", "Gatar" },
            { "timezone.excity.Asia/Seoul", "Seól" },
            { "timezone.excity.Asia/Tokyo", "Tókyó" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Jubá" },
            { "timezone.excity.Africa/Lome", "Lómé" },
            { "timezone.excity.Asia/Almaty", "Almati" },
            { "timezone.excity.Asia/Anadyr", "Anadir" },
            { "timezone.excity.Asia/Aqtobe", "Aktubé" },
            { "timezone.excity.Asia/Atyrau", "Atirau" },
            { "timezone.excity.Asia/Beirut", "Bérut" },
            { "timezone.excity.Asia/Brunei", "Brunái" },
            { "timezone.excity.Asia/Hebron", "Hebrón" },
            { "timezone.excity.Asia/Kuwait", "Kwayt" },
            { "timezone.excity.Asia/Muscat", "Maskat" },
            { "timezone.excity.Asia/Riyadh", "Ryáz" },
            { "timezone.excity.Asia/Saigon", "Hó Chi Menn" },
            { "timezone.excity.Asia/Taipei", "Táipi" },
            { "timezone.excity.Asia/Tehran", "Tehrán" },
            { "timezone.excity.Asia/Urumqi", "Urumki" },
            { "timezone.excity.Etc/Unknown", "Námálumén shahr" },
            { "timezone.excity.Europe/Oslo", "Ósló" },
            { "timezone.excity.Europe/Rome", "Rum" },
            { "timezone.excity.Indian/Mahe", "Mahé" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Akkrá" },
            { "timezone.excity.Africa/Cairo", "Káeró" },
            { "timezone.excity.Africa/Ceuta", "Kyutá" },
            { "timezone.excity.Africa/Lagos", "Lagós" },
            { "timezone.excity.Africa/Tunis", "Tunes" },
            { "timezone.excity.America/Lima", "Limá" },
            { "timezone.excity.Asia/Baghdad", "Bagdád" },
            { "timezone.excity.Asia/Bahrain", "Bahren" },
            { "timezone.excity.Asia/Bangkok", "Bengkák" },
            { "timezone.excity.Asia/Colombo", "Kólambó" },
            { "timezone.excity.Asia/Jakarta", "Jakártá" },
            { "timezone.excity.Asia/Karachi", "Karáchi" },
            { "timezone.excity.Asia/Nicosia", "Nikóshiá" },
            { "timezone.excity.Asia/Tbilisi", "Tebilisi" },
            { "timezone.excity.Asia/Thimphu", "Thimpu" },
            { "timezone.excity.Asia/Yerevan", "Yerewán" },
            { "timezone.excity.Europe/Kirov", "Kirów" },
            { "timezone.excity.Europe/Paris", "Payres" },
            { "timezone.excity.Europe/Sofia", "Sofiá" },
            { "timezone.excity.Europe/Vaduz", "Waduz" },
            { "timezone.excity.Indian/Cocos", "Kukus" },
            { "timezone.excity.Pacific/Apia", "Apiá" },
            { "timezone.excity.Africa/Asmera", "Asmará" },
            { "timezone.excity.Africa/Bamako", "Bamakó" },
            { "timezone.excity.Africa/Douala", "Douálá" },
            { "timezone.excity.Africa/Harare", "Haráré" },
            { "timezone.excity.Africa/Luanda", "Luandá" },
            { "timezone.excity.Africa/Lusaka", "Lusáká" },
            { "timezone.excity.Africa/Malabo", "Malábó" },
            { "timezone.excity.Africa/Maputo", "Maputó" },
            { "timezone.excity.Africa/Maseru", "Maséró" },
            { "timezone.excity.Africa/Niamey", "Niaméy" },
            { "timezone.excity.America/Aruba", "Arubá" },
            { "timezone.excity.America/Jujuy", "Jojui" },
            { "timezone.excity.America/Thule", "Tulé" },
            { "timezone.excity.Asia/Calcutta", "Kalkata" },
            { "timezone.excity.Asia/Damascus", "Damáskas" },
            { "timezone.excity.Asia/Dushanbe", "Doshambeh" },
            { "timezone.excity.Asia/Jayapura", "Jaypur" },
            { "timezone.excity.Asia/Khandyga", "Khandiga" },
            { "timezone.excity.Asia/Qostanay", "Kastanay" },
            { "timezone.excity.Asia/Shanghai", "Shangái" },
            { "timezone.excity.Asia/Tashkent", "Táshkand" },
            { "timezone.excity.Europe/Athens", "Áten" },
            { "timezone.excity.Europe/Jersey", "Jerséy" },
            { "timezone.excity.Europe/London", "Landan" },
            { "timezone.excity.Europe/Monaco", "Monákó" },
            { "timezone.excity.Europe/Moscow", "Máskó" },
            { "timezone.excity.Europe/Prague", "Prág" },
            { "timezone.excity.Europe/Skopje", "Kopjé" },
            { "timezone.excity.Europe/Tirane", "Tiráne" },
            { "timezone.excity.Europe/Vienna", "Wienná" },
            { "timezone.excity.Europe/Warsaw", "Wársá" },
            { "timezone.excity.Europe/Zurich", "Zyurekh" },
            { "timezone.excity.Indian/Chagos", "Chagós" },
            { "timezone.excity.Indian/Comoro", "Komóró" },
            { "timezone.excity.Pacific/Efate", "Efáti" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Ábedján" },
            { "timezone.excity.Africa/Conakry", "Konakri" },
            { "timezone.excity.Africa/Kampala", "Kampála" },
            { "timezone.excity.Africa/Mbabane", "Mbabané" },
            { "timezone.excity.Africa/Nairobi", "Nérubi" },
            { "timezone.excity.Africa/Tripoli", "Tripóli" },
            { "timezone.excity.America/Cancun", "Chanchun" },
            { "timezone.excity.America/Cayman", "Kayman" },
            { "timezone.excity.America/Cuiaba", "Kwaibá" },
            { "timezone.excity.America/Denver", "Denwér" },
            { "timezone.excity.America/Guyana", "Guyána" },
            { "timezone.excity.America/Havana", "Hawáná" },
            { "timezone.excity.America/Inuvik", "Inuwik" },
            { "timezone.excity.America/Juneau", "Juniu" },
            { "timezone.excity.America/La_Paz", "Lá Paz" },
            { "timezone.excity.America/Maceio", "Machió" },
            { "timezone.excity.America/Panama", "Panámá" },
            { "timezone.excity.America/Recife", "Rechipé" },
            { "timezone.excity.Asia/Famagusta", "Pamagustá" },
            { "timezone.excity.Asia/Hong_Kong", "Háng Káng" },
            { "timezone.excity.Asia/Jerusalem", "Urshalim" },
            { "timezone.excity.Asia/Pyongyang", "Pyongyáng" },
            { "timezone.excity.Asia/Qyzylorda", "Kizilordá" },
            { "timezone.excity.Asia/Singapore", "Sengápur" },
            { "timezone.excity.Asia/Vientiane", "Wientiáné" },
            { "timezone.excity.Europe/Saratov", "Saratów" },
            { "timezone.excity.Europe/Vatican", "Watikan" },
            { "timezone.excity.Europe/Vilnius", "Wilnius" },
            { "timezone.excity.Indian/Mayotte", "Mayótay" },
            { "timezone.excity.Indian/Reunion", "Réyunian" },
            { "timezone.excity.Pacific/Easter", "Isthar" },
            { "timezone.excity.Pacific/Kosrae", "Kósrai" },
            { "timezone.excity.Africa/Blantyre", "Blantiray" },
            { "timezone.excity.Africa/Djibouti", "Djebóti" },
            { "timezone.excity.Africa/El_Aaiun", "El Áiun" },
            { "timezone.excity.Africa/Freetown", "Peritháón" },
            { "timezone.excity.Africa/Gaborone", "Gaboroné" },
            { "timezone.excity.Africa/Khartoum", "Khartum" },
            { "timezone.excity.Africa/Kinshasa", "Kenshása" },
            { "timezone.excity.Africa/Monrovia", "Monrówiá" },
            { "timezone.excity.Africa/Ndjamena", "Ndjamená" },
            { "timezone.excity.Africa/Sao_Tome", "Sáó Tomé" },
            { "timezone.excity.Africa/Windhoek", "Windoek" },
            { "timezone.excity.America/Antigua", "Antiguá" },
            { "timezone.excity.America/Caracas", "Charakás" },
            { "timezone.excity.America/Cayenne", "Chayenn" },
            { "timezone.excity.America/Chicago", "Shekágó" },
            { "timezone.excity.America/Cordoba", "Kortoba" },
            { "timezone.excity.America/Creston", "Krestón" },
            { "timezone.excity.America/Curacao", "Chorácháó" },
            { "timezone.excity.America/Grenada", "Grenadá" },
            { "timezone.excity.America/Halifax", "Halifaks" },
            { "timezone.excity.America/Iqaluit", "Ikálwit" },
            { "timezone.excity.America/Jamaica", "Jamáeká" },
            { "timezone.excity.America/Mendoza", "Mendozá" },
            { "timezone.excity.America/Moncton", "Monkton" },
            { "timezone.excity.America/Noronha", "Noronhá" },
            { "timezone.excity.America/Phoenix", "Póeniks" },
            { "timezone.excity.America/Tijuana", "Tijuána" },
            { "timezone.excity.America/Toronto", "Torontó" },
            { "timezone.excity.America/Tortola", "Tortolá" },
            { "timezone.excity.Atlantic/Azores", "Azóres" },
            { "timezone.excity.Atlantic/Canary", "Kanaray" },
            { "timezone.excity.Australia/Eucla", "Yuklá" },
            { "timezone.excity.Australia/Perth", "Pert" },
            { "timezone.excity.Europe/Belgrade", "Belgrád" },
            { "timezone.excity.Europe/Budapest", "Budápest" },
            { "timezone.excity.Europe/Guernsey", "Guernséy" },
            { "timezone.excity.Europe/Istanbul", "Estamból" },
            { "timezone.excity.Europe/Sarajevo", "Sarajéwó" },
            { "timezone.excity.Indian/Maldives", "Máldip" },
            { "timezone.excity.Pacific/Fakaofo", "Fakaófó" },
            { "timezone.excity.Pacific/Norfolk", "Nurpolk" },
            { "timezone.excity.Africa/Bujumbura", "Bujombura" },
            { "timezone.excity.Africa/Mogadishu", "Mógádéshó" },
            { "timezone.excity.America/Anguilla", "Anguillá" },
            { "timezone.excity.America/Asuncion", "Asunchión" },
            { "timezone.excity.America/Dominica", "Dominiká" },
            { "timezone.excity.America/Eirunepe", "Irunépé" },
            { "timezone.excity.America/Miquelon", "Mekwelon" },
            { "timezone.excity.America/New_York", "Nyu Yárk" },
            { "timezone.excity.America/Resolute", "Resólut" },
            { "timezone.excity.America/Santiago", "Santiagó" },
            { "timezone.excity.America/St_Lucia", "St. Lusiá" },
            { "timezone.excity.Antarctica/Casey", "Kásé" },
            { "timezone.excity.Antarctica/Davis", "Dawis" },
            { "timezone.excity.Antarctica/Syowa", "Syówá" },
            { "timezone.excity.Asia/Novosibirsk", "Nowosibirsk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulánbátar" },
            { "timezone.excity.Asia/Vladivostok", "Wladiwóstok" },
            { "timezone.excity.Atlantic/Stanley", "Stánlé" },
            { "timezone.excity.Australia/Sydney", "Sedhni" },
            { "timezone.excity.Europe/Bucharest", "Bukhárest" },
            { "timezone.excity.Europe/Ljubljana", "Ljubljaná" },
            { "timezone.excity.Europe/Podgorica", "Podgoriká" },
            { "timezone.excity.Europe/Stockholm", "Esthákholm" },
            { "timezone.excity.Europe/Ulyanovsk", "Ulyanówsk" },
            { "timezone.excity.Europe/Volgograd", "Wolgograd" },
            { "timezone.excity.Indian/Christmas", "Kresmes" },
            { "timezone.excity.Indian/Kerguelen", "Kargwelen" },
            { "timezone.excity.Indian/Mauritius", "Murishas" },
            { "timezone.excity.Pacific/Auckland", "Awklánd" },
            { "timezone.excity.Pacific/Pitcairn", "Pitkarin" },
            { "timezone.excity.Africa/Casablanca", "Kasablanká" },
            { "timezone.excity.Africa/Libreville", "Librewilay" },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbáshi" },
            { "timezone.excity.Africa/Nouakchott", "Nouakshott" },
            { "timezone.excity.Africa/Porto-Novo", "Portó-Nówó" },
            { "timezone.excity.America/Anchorage", "Anchoragé" },
            { "timezone.excity.America/Boa_Vista", "Bóá Wistá" },
            { "timezone.excity.America/Catamarca", "Chatamarká" },
            { "timezone.excity.America/Chihuahua", "Chihuahuá" },
            { "timezone.excity.America/Fortaleza", "Portalezá" },
            { "timezone.excity.America/Glace_Bay", "Glays Bay" },
            { "timezone.excity.America/Guatemala", "Gwátémálá" },
            { "timezone.excity.America/Guayaquil", "Gwáyakil" },
            { "timezone.excity.America/Menominee", "Menomini" },
            { "timezone.excity.America/Monterrey", "Monterray" },
            { "timezone.excity.America/Sao_Paulo", "Sáó Pauló" },
            { "timezone.excity.America/St_Thomas", "St. Tómas" },
            { "timezone.excity.America/Vancouver", "Wankuwar" },
            { "timezone.excity.Antarctica/Vostok", "Wostok" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kwálá Lampur" },
            { "timezone.excity.Asia/Novokuznetsk", "Nowokuznetsk" },
            { "timezone.excity.Europe/Bratislava", "Bratislawá" },
            { "timezone.excity.Europe/Copenhagen", "Kopenhágen" },
            { "timezone.excity.Europe/Luxembourg", "Logzemborg" },
            { "timezone.excity.Europe/San_Marino", "San Marinó" },
            { "timezone.excity.Europe/Simferopol", "Simperópól" },
            { "timezone.excity.Pacific/Marquesas", "Markesás" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Ababá" },
            { "timezone.excity.Africa/Brazzaville", "Brazzawilay" },
            { "timezone.excity.America/Costa_Rica", "Kóstá Riká" },
            { "timezone.excity.America/Guadeloupe", "Gwádelóp" },
            { "timezone.excity.America/Louisville", "Luiswillay" },
            { "timezone.excity.America/Martinique", "Matinik" },
            { "timezone.excity.America/Montevideo", "Montewidió" },
            { "timezone.excity.America/Paramaribo", "Paramaribó" },
            { "timezone.excity.America/Rio_Branco", "Rió Brankó" },
            { "timezone.excity.America/St_Vincent", "St. Winsent" },
            { "timezone.excity.Asia/Srednekolymsk", "Srednekólimsk" },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjawik" },
            { "timezone.excity.Atlantic/St_Helena", "St. Helená" },
            { "timezone.excity.Australia/Adelaide", "Adiléd" },
            { "timezone.excity.Africa/Johannesburg", "Johannesbarg" },
            { "timezone.excity.America/El_Salvador", "El Salwadór" },
            { "timezone.excity.America/Los_Angeles", "Lás Enjeles" },
            { "timezone.excity.America/Mexico_City", "Meksikó Shahr" },
            { "timezone.excity.America/Porto_Velho", "Portó welhó" },
            { "timezone.excity.America/Puerto_Rico", "Puertó Rikó" },
            { "timezone.excity.America/Tegucigalpa", "Teguchigalpá" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kap Wardé" },
            { "timezone.excity.Australia/Melbourne", "Melborn" },
            { "timezone.excity.Indian/Antananarivo", "Antananariwó" },
            { "timezone.excity.Pacific/Guadalcanal", "Guadalkanal" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dár es salám" },
            { "timezone.excity.America/Blanc-Sablon", "Blanch-Sablón" },
            { "timezone.excity.America/Campo_Grande", "Champo Grande" },
            { "timezone.excity.America/Danmarkshavn", "Danmarkshawn" },
            { "timezone.excity.America/Dawson_Creek", "Dawson Krék" },
            { "timezone.excity.America/Indiana/Knox", "Knoks, Indiáná" },
            { "timezone.excity.America/Indianapolis", "Indiánápolis" },
            { "timezone.excity.America/Scoresbysund", "Ittokkorturmit" },
            { "timezone.excity.Antarctica/Macquarie", "Makwáer" },
            { "timezone.excity.Pacific/Bougainville", "Bógáinwilay" },
            { "timezone.excity.America/Cambridge_Bay", "Kambrej Bay" },
            { "timezone.excity.America/Ciudad_Juarez", "Chiudad Juárez" },
            { "timezone.excity.America/Coral_Harbour", "Atikókan" },
            { "timezone.excity.America/Indiana/Vevay", "Weway, Indiáná" },
            { "timezone.excity.America/Port_of_Spain", "Pórt Espin" },
            { "timezone.excity.America/Santo_Domingo", "Santó Domingó" },
            { "timezone.excity.America/Swift_Current", "Swift Karrant" },
            { "timezone.excity.America/Bahia_Banderas", "Bahía de Banderás" },
            { "timezone.excity.America/Port-au-Prince", "Pórt-au-Prens" },
            { "timezone.excity.Atlantic/South_Georgia", "Shemáli Járjiá" },
            { "timezone.excity.America/Indiana/Marengo", "Marengó Indiáná" },
            { "timezone.excity.America/Indiana/Winamac", "Winamak, Indiáná" },
            { "timezone.excity.America/Argentina/Tucuman", "Tukuman" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ushwáiá" },
            { "timezone.excity.America/Indiana/Tell_City", "Tell Sithi, Indiáná" },
            { "timezone.excity.America/Indiana/Vincennes", "Winsennes, Indiáná" },
            { "timezone.excity.Antarctica/DumontDUrville", "Dumont Urwila" },
            { "timezone.excity.America/Indiana/Petersburg", "Petersburg, Indiáná" },
            { "timezone.excity.America/Kentucky/Monticello", "Montichelló, Kentuki" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Nárt Dakótá" },
            { "timezone.excity.America/North_Dakota/Center", "Santhar, Nárt Dakótá" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Nyu Salem, Nárt Dakótá" },
        };
        return data;
    }
}
