/*
 * Copyright (C) 2024, STMicroelectronics - All Rights Reserved
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef STM32MP_RISAB_REGS_H
#define STM32MP_RISAB_REGS_H

#define RISAB_CR				U(0x00)
#define RISAB_IASR				U(0x08)
#define RISAB_IACR				U(0x0C)
#define RISAB_RIFLOCKR				U(0x10)
#define RISAB_IAESR				U(0x20)
#define RISAB_IADDR				U(0x24)
#define RISAB_PG0_SECCFGR			U(0x100)
#define RISAB_PG1_SECCFGR			U(0x104)
#define RISAB_PG2_SECCFGR			U(0x108)
#define RISAB_PG3_SECCFGR			U(0x10C)
#define RISAB_PG4_SECCFGR			U(0x110)
#define RISAB_PG5_SECCFGR			U(0x114)
#define RISAB_PG6_SECCFGR			U(0x118)
#define RISAB_PG7_SECCFGR			U(0x11C)
#define RISAB_PG8_SECCFGR			U(0x120)
#define RISAB_PG9_SECCFGR			U(0x124)
#define RISAB_PG10_SECCFGR			U(0x128)
#define RISAB_PG11_SECCFGR			U(0x12C)
#define RISAB_PG12_SECCFGR			U(0x130)
#define RISAB_PG13_SECCFGR			U(0x134)
#define RISAB_PG14_SECCFGR			U(0x138)
#define RISAB_PG15_SECCFGR			U(0x13C)
#define RISAB_PG16_SECCFGR			U(0x140)
#define RISAB_PG17_SECCFGR			U(0x144)
#define RISAB_PG18_SECCFGR			U(0x148)
#define RISAB_PG19_SECCFGR			U(0x14C)
#define RISAB_PG20_SECCFGR			U(0x150)
#define RISAB_PG21_SECCFGR			U(0x154)
#define RISAB_PG22_SECCFGR			U(0x158)
#define RISAB_PG23_SECCFGR			U(0x15C)
#define RISAB_PG24_SECCFGR			U(0x160)
#define RISAB_PG25_SECCFGR			U(0x164)
#define RISAB_PG26_SECCFGR			U(0x168)
#define RISAB_PG27_SECCFGR			U(0x16C)
#define RISAB_PG28_SECCFGR			U(0x170)
#define RISAB_PG29_SECCFGR			U(0x174)
#define RISAB_PG30_SECCFGR			U(0x178)
#define RISAB_PG31_SECCFGR			U(0x17C)
#define RISAB_PG0_PRIVCFGR			U(0x200)
#define RISAB_PG1_PRIVCFGR			U(0x204)
#define RISAB_PG2_PRIVCFGR			U(0x208)
#define RISAB_PG3_PRIVCFGR			U(0x20C)
#define RISAB_PG4_PRIVCFGR			U(0x210)
#define RISAB_PG5_PRIVCFGR			U(0x214)
#define RISAB_PG6_PRIVCFGR			U(0x218)
#define RISAB_PG7_PRIVCFGR			U(0x21C)
#define RISAB_PG8_PRIVCFGR			U(0x220)
#define RISAB_PG9_PRIVCFGR			U(0x224)
#define RISAB_PG10_PRIVCFGR			U(0x228)
#define RISAB_PG11_PRIVCFGR			U(0x22C)
#define RISAB_PG12_PRIVCFGR			U(0x230)
#define RISAB_PG13_PRIVCFGR			U(0x234)
#define RISAB_PG14_PRIVCFGR			U(0x238)
#define RISAB_PG15_PRIVCFGR			U(0x23C)
#define RISAB_PG16_PRIVCFGR			U(0x240)
#define RISAB_PG17_PRIVCFGR			U(0x244)
#define RISAB_PG18_PRIVCFGR			U(0x248)
#define RISAB_PG19_PRIVCFGR			U(0x24C)
#define RISAB_PG20_PRIVCFGR			U(0x250)
#define RISAB_PG21_PRIVCFGR			U(0x254)
#define RISAB_PG22_PRIVCFGR			U(0x258)
#define RISAB_PG23_PRIVCFGR			U(0x25C)
#define RISAB_PG24_PRIVCFGR			U(0x260)
#define RISAB_PG25_PRIVCFGR			U(0x264)
#define RISAB_PG26_PRIVCFGR			U(0x268)
#define RISAB_PG27_PRIVCFGR			U(0x26C)
#define RISAB_PG28_PRIVCFGR			U(0x270)
#define RISAB_PG29_PRIVCFGR			U(0x274)
#define RISAB_PG30_PRIVCFGR			U(0x278)
#define RISAB_PG31_PRIVCFGR			U(0x27C)
#define RISAB_PG0_C2PRIVCFGR			U(0x600)
#define RISAB_PG1_C2PRIVCFGR			U(0x604)
#define RISAB_PG2_C2PRIVCFGR			U(0x608)
#define RISAB_PG3_C2PRIVCFGR			U(0x60C)
#define RISAB_PG4_C2PRIVCFGR			U(0x610)
#define RISAB_PG5_C2PRIVCFGR			U(0x614)
#define RISAB_PG6_C2PRIVCFGR			U(0x618)
#define RISAB_PG7_C2PRIVCFGR			U(0x61C)
#define RISAB_PG8_C2PRIVCFGR			U(0x620)
#define RISAB_PG9_C2PRIVCFGR			U(0x624)
#define RISAB_PG10_C2PRIVCFGR			U(0x628)
#define RISAB_PG11_C2PRIVCFGR			U(0x62C)
#define RISAB_PG12_C2PRIVCFGR			U(0x630)
#define RISAB_PG13_C2PRIVCFGR			U(0x634)
#define RISAB_PG14_C2PRIVCFGR			U(0x638)
#define RISAB_PG15_C2PRIVCFGR			U(0x63C)
#define RISAB_PG16_C2PRIVCFGR			U(0x640)
#define RISAB_PG17_C2PRIVCFGR			U(0x644)
#define RISAB_PG18_C2PRIVCFGR			U(0x648)
#define RISAB_PG19_C2PRIVCFGR			U(0x64C)
#define RISAB_PG20_C2PRIVCFGR			U(0x650)
#define RISAB_PG21_C2PRIVCFGR			U(0x654)
#define RISAB_PG22_C2PRIVCFGR			U(0x658)
#define RISAB_PG23_C2PRIVCFGR			U(0x65C)
#define RISAB_PG24_C2PRIVCFGR			U(0x660)
#define RISAB_PG25_C2PRIVCFGR			U(0x664)
#define RISAB_PG26_C2PRIVCFGR			U(0x668)
#define RISAB_PG27_C2PRIVCFGR			U(0x66C)
#define RISAB_PG28_C2PRIVCFGR			U(0x670)
#define RISAB_PG29_C2PRIVCFGR			U(0x674)
#define RISAB_PG30_C2PRIVCFGR			U(0x678)
#define RISAB_PG31_C2PRIVCFGR			U(0x67C)
#define RISAB_CID0PRIVCFGR			U(0x800)
#define RISAB_CID0RDCFGR			U(0x808)
#define RISAB_CID0WRCFGR			U(0x810)
#define RISAB_CID1PRIVCFGR			U(0x820)
#define RISAB_CID1RDCFGR			U(0x828)
#define RISAB_CID1WRCFGR			U(0x830)
#define RISAB_CID2PRIVCFGR			U(0x840)
#define RISAB_CID2RDCFGR			U(0x848)
#define RISAB_CID2WRCFGR			U(0x850)
#define RISAB_CID3PRIVCFGR			U(0x860)
#define RISAB_CID3RDCFGR			U(0x868)
#define RISAB_CID3WRCFGR			U(0x870)
#define RISAB_CID4PRIVCFGR			U(0x880)
#define RISAB_CID4RDCFGR			U(0x888)
#define RISAB_CID4WRCFGR			U(0x890)
#define RISAB_CID5PRIVCFGR			U(0x8A0)
#define RISAB_CID5RDCFGR			U(0x8A8)
#define RISAB_CID5WRCFGR			U(0x8B0)
#define RISAB_CID6PRIVCFGR			U(0x8C0)
#define RISAB_CID6RDCFGR			U(0x8C8)
#define RISAB_CID6WRCFGR			U(0x8D0)
#define RISAB_PG0_CIDCFGR			U(0xA00)
#define RISAB_PG1_CIDCFGR			U(0xA04)
#define RISAB_PG2_CIDCFGR			U(0xA08)
#define RISAB_PG3_CIDCFGR			U(0xA0C)
#define RISAB_PG4_CIDCFGR			U(0xA10)
#define RISAB_PG5_CIDCFGR			U(0xA14)
#define RISAB_PG6_CIDCFGR			U(0xA18)
#define RISAB_PG7_CIDCFGR			U(0xA1C)
#define RISAB_PG8_CIDCFGR			U(0xA20)
#define RISAB_PG9_CIDCFGR			U(0xA24)
#define RISAB_PG10_CIDCFGR			U(0xA28)
#define RISAB_PG11_CIDCFGR			U(0xA2C)
#define RISAB_PG12_CIDCFGR			U(0xA30)
#define RISAB_PG13_CIDCFGR			U(0xA34)
#define RISAB_PG14_CIDCFGR			U(0xA38)
#define RISAB_PG15_CIDCFGR			U(0xA3C)
#define RISAB_PG16_CIDCFGR			U(0xA40)
#define RISAB_PG17_CIDCFGR			U(0xA44)
#define RISAB_PG18_CIDCFGR			U(0xA48)
#define RISAB_PG19_CIDCFGR			U(0xA4C)
#define RISAB_PG20_CIDCFGR			U(0xA50)
#define RISAB_PG21_CIDCFGR			U(0xA54)
#define RISAB_PG22_CIDCFGR			U(0xA58)
#define RISAB_PG23_CIDCFGR			U(0xA5C)
#define RISAB_PG24_CIDCFGR			U(0xA60)
#define RISAB_PG25_CIDCFGR			U(0xA64)
#define RISAB_PG26_CIDCFGR			U(0xA68)
#define RISAB_PG27_CIDCFGR			U(0xA6C)
#define RISAB_PG28_CIDCFGR			U(0xA70)
#define RISAB_PG29_CIDCFGR			U(0xA74)
#define RISAB_PG30_CIDCFGR			U(0xA78)
#define RISAB_PG31_CIDCFGR			U(0xA7C)
#define RISAB_HWCFGR3				U(0xFE8)
#define RISAB_HWCFGR2				U(0xFEC)
#define RISAB_HWCFGR1				U(0xFF0)
#define RISAB_VERR				U(0xFF4)
#define RISAB_IPIDR				U(0xFF8)
#define RISAB_SIDR				U(0xFFC)

/* RISAB_CR register fields */
#define RISAB_CR_GLOCK				BIT(0)
#define RISAB_CR_SRWIAD				BIT(31)

/* RISAB_IASR register fields */
#define RISAB_IASR_CAEF				BIT(0)
#define RISAB_IASR_IAEF				BIT(1)

/* RISAB_IACR register fields */
#define RISAB_IACR_CAEF				BIT(0)
#define RISAB_IACR_IAEF				BIT(1)

/* RISAB_RIFLOCKR register fields */
#define RISAB_RIFLOCKR_RLOCK0			BIT(0)
#define RISAB_RIFLOCKR_RLOCK1			BIT(1)
#define RISAB_RIFLOCKR_RLOCK2			BIT(2)
#define RISAB_RIFLOCKR_RLOCK3			BIT(3)
#define RISAB_RIFLOCKR_RLOCK4			BIT(4)
#define RISAB_RIFLOCKR_RLOCK5			BIT(5)
#define RISAB_RIFLOCKR_RLOCK6			BIT(6)
#define RISAB_RIFLOCKR_RLOCK7			BIT(7)
#define RISAB_RIFLOCKR_RLOCK8			BIT(8)
#define RISAB_RIFLOCKR_RLOCK9			BIT(9)
#define RISAB_RIFLOCKR_RLOCK10			BIT(10)
#define RISAB_RIFLOCKR_RLOCK11			BIT(11)
#define RISAB_RIFLOCKR_RLOCK12			BIT(12)
#define RISAB_RIFLOCKR_RLOCK13			BIT(13)
#define RISAB_RIFLOCKR_RLOCK14			BIT(14)
#define RISAB_RIFLOCKR_RLOCK15			BIT(15)
#define RISAB_RIFLOCKR_RLOCK16			BIT(16)
#define RISAB_RIFLOCKR_RLOCK17			BIT(17)
#define RISAB_RIFLOCKR_RLOCK18			BIT(18)
#define RISAB_RIFLOCKR_RLOCK19			BIT(19)
#define RISAB_RIFLOCKR_RLOCK20			BIT(20)
#define RISAB_RIFLOCKR_RLOCK21			BIT(21)
#define RISAB_RIFLOCKR_RLOCK22			BIT(22)
#define RISAB_RIFLOCKR_RLOCK23			BIT(23)
#define RISAB_RIFLOCKR_RLOCK24			BIT(24)
#define RISAB_RIFLOCKR_RLOCK25			BIT(25)
#define RISAB_RIFLOCKR_RLOCK26			BIT(26)
#define RISAB_RIFLOCKR_RLOCK27			BIT(27)
#define RISAB_RIFLOCKR_RLOCK28			BIT(28)
#define RISAB_RIFLOCKR_RLOCK29			BIT(29)
#define RISAB_RIFLOCKR_RLOCK30			BIT(30)
#define RISAB_RIFLOCKR_RLOCK31			BIT(31)

/* RISAB_IAESR register fields */
#define RISAB_IAESR_IACID_MASK			GENMASK(2, 0)
#define RISAB_IAESR_IACID_SHIFT			0
#define RISAB_IAESR_IAPRIV			BIT(4)
#define RISAB_IAESR_IASEC			BIT(5)
#define RISAB_IAESR_IANRW			BIT(7)

/* RISAB_PGx_SECCFGR register fields */
#define RISAB_PGx_SECCFGR_SEC(_y)		BIT(_y)

/* RISAB_PGx_PRIVCFGR register fields */
#define RISAB_PGx_PRIVCFGR_PRIV(_y)		BIT(_y)

/* RISAB_PGx_CmPRIVCFGR register fields */
#define RISAB_PGx_CmPRIVCFGR_PRIV(_y)		BIT(_y)

/* RISAB_CIDxPRIVCFGR register fields */
#define RISAB_CIDxPRIVCFGR_PPRIV(_y)		BIT(_y)

/* RISAB_CIDxRDCFGR register fields */
#define RISAB_CIDxRDCFGR_PRDEN(_y)		BIT(_y)

/* RISAB_CIDxWRCFGR register fields */
#define RISAB_CIDxWRCFGR_PWREN(_y)		BIT(_y)

/* RISAB_PGx_CIDCFGR register fields */
#define RISAB_PGx_CIDCFGR_CFEN			BIT(0)
#define RISAB_PGx_CIDCFGR_DCEN			BIT(2)
#define RISAB_PGx_CIDCFGR_DCCID_MASK		GENMASK(6, 4)
#define RISAB_PGx_CIDCFGR_DCCID_SHIFT		4

/* RISAB_HWCFGR1 register fields */
#define RISAB_HWCFGR1_CFG1_MASK			GENMASK(3, 0)
#define RISAB_HWCFGR1_CFG1_SHIFT		0
#define RISAB_HWCFGR1_CFG2_MASK			GENMASK(7, 4)
#define RISAB_HWCFGR1_CFG2_SHIFT		4
#define RISAB_HWCFGR1_CFG3_MASK			GENMASK(11, 8)
#define RISAB_HWCFGR1_CFG3_SHIFT		8
#define RISAB_HWCFGR1_CFG4_MASK			GENMASK(15, 12)
#define RISAB_HWCFGR1_CFG4_SHIFT		12
#define RISAB_HWCFGR1_CFG5_MASK			GENMASK(19, 16)
#define RISAB_HWCFGR1_CFG5_SHIFT		16
#define RISAB_HWCFGR1_CFG6_MASK			GENMASK(23, 20)
#define RISAB_HWCFGR1_CFG6_SHIFT		20
#define RISAB_HWCFGR1_CFG7_MASK			GENMASK(27, 24)
#define RISAB_HWCFGR1_CFG7_SHIFT		24

/* RISAB_VERR register fields */
#define RISAB_VERR_MINREV_MASK			GENMASK(3, 0)
#define RISAB_VERR_MINREV_SHIFT			0
#define RISAB_VERR_MAJREV_MASK			GENMASK(7, 4)
#define RISAB_VERR_MAJREV_SHIFT			4

#endif /* STM32MP_RISAB_REGS_H */
