/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.notes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.hyperlink.DefaultHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.viewers.IInputSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.xmind.ui.internal.notes.INotesContentViewer;
import org.xmind.ui.internal.notes.NotesHyperlinkDetector;
import org.xmind.ui.richtext.Hyperlink;
import org.xmind.ui.richtext.IRichDocument;
import org.xmind.ui.richtext.IRichDocumentListener;
import org.xmind.ui.richtext.IRichTextActionBarContributor;
import org.xmind.ui.richtext.IRichTextEditViewer;
import org.xmind.ui.richtext.ImagePlaceHolder;
import org.xmind.ui.richtext.LineStyle;
import org.xmind.ui.richtext.RichTextEditViewer;

public class TopicNotesViewer
implements INotesContentViewer,
IInputSelectionProvider {
    private IRichTextEditViewer implementation;
    private Object input;
    private SelectionSynchronizer selectionProvider;
    private IRichTextActionBarContributor contributor;
    private ModificationListener modificationListener;
    private Composite composite;

    public TopicNotesViewer() {
    }

    public TopicNotesViewer(IRichTextActionBarContributor contributor) {
        this.contributor = contributor;
    }

    public void setContributor(IRichTextActionBarContributor contributor) {
        this.contributor = contributor;
    }

    @Override
    public Control createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setBackground(parent.getDisplay().getSystemColor(1));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.composite.setLayout((Layout)layout);
        this.composite.setLayoutData((Object)new GridData(1808));
        this.createControl(this.composite, 834);
        return this.composite;
    }

    public void createControl(Composite parent, int textControlStyle) {
        this.implementation = new RichTextEditViewer(parent, textControlStyle, this.contributor);
        TextViewer viewer = this.implementation.getTextViewer();
        RGB red = new RGB(183, 0, 91);
        viewer.setHyperlinkPresenter((IHyperlinkPresenter)new DefaultHyperlinkPresenter(red));
        viewer.setHyperlinkDetectors(new IHyperlinkDetector[]{new NotesHyperlinkDetector()}, SWT.MOD1);
        this.modificationListener = new ModificationListener();
        viewer.addTextInputListener((ITextInputListener)this.modificationListener);
        IRichDocument document = this.getDocument();
        this.implementation.setInput((Object)document);
        Control control = this.implementation.getControl();
        control.setLayoutData((Object)new GridData(1808));
    }

    private IRichDocument getDocument() {
        if (this.input instanceof IRichDocument) {
            return (IRichDocument)this.input;
        }
        if (this.input instanceof IAdaptable) {
            return (IRichDocument)((IAdaptable)this.input).getAdapter(IRichDocument.class);
        }
        return null;
    }

    @Override
    public Control getControl() {
        return this.implementation == null ? null : this.implementation.getControl();
    }

    public IRichTextEditViewer getImplementation() {
        return this.implementation;
    }

    @Override
    public void setInput(Object input) {
        this.input = input;
        if (this.implementation != null) {
            this.implementation.setInput((Object)this.getDocument());
        }
    }

    public Object getInput() {
        return this.input;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.getSelectionProvider().addSelectionChangedListener(listener);
    }

    private SelectionSynchronizer getSelectionProvider() {
        if (this.selectionProvider == null) {
            this.selectionProvider = new SelectionSynchronizer();
        }
        return this.selectionProvider;
    }

    public ISelection getSelection() {
        return this.getSelectionProvider().getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener(listener);
        }
    }

    public void setSelection(ISelection selection) {
        this.getSelectionProvider().setSelection(selection);
    }

    public boolean hasModified() {
        return this.modificationListener == null || this.modificationListener.isModified();
    }

    public void resetModified() {
        if (this.modificationListener != null) {
            this.modificationListener.reset();
        }
    }

    @Override
    public void dispose() {
        this.composite.dispose();
    }

    private class ModificationListener
    implements IDocumentListener,
    IRichDocumentListener,
    ITextInputListener {
        private boolean modified = false;

        private ModificationListener() {
        }

        public void textStyleChanged(IRichDocument document, StyleRange[] oldTextStyles, StyleRange[] newTextStyles) {
            this.modified = true;
        }

        public void lineStyleChanged(IRichDocument document, LineStyle[] oldLineStyles, LineStyle[] newLineStyles) {
            this.modified = true;
        }

        public void imageChanged(IRichDocument document, ImagePlaceHolder[] oldImages, ImagePlaceHolder[] newImages) {
            this.modified = true;
        }

        public void hyperlinkChanged(IRichDocument document, Hyperlink[] oldHyperlinks, Hyperlink[] newHyperlinks) {
            this.modified = true;
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            this.modified = true;
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput != null) {
                oldInput.removeDocumentListener((IDocumentListener)this);
                if (oldInput instanceof IRichDocument) {
                    ((IRichDocument)oldInput).removeRichDocumentListener((IRichDocumentListener)this);
                }
            }
            if (newInput != null) {
                newInput.addDocumentListener((IDocumentListener)this);
                if (newInput instanceof IRichDocument) {
                    ((IRichDocument)newInput).addRichDocumentListener((IRichDocumentListener)this);
                }
            }
        }

        public boolean isModified() {
            return this.modified;
        }

        public void reset() {
            this.modified = false;
        }
    }

    private class SelectionSynchronizer
    implements ISelectionProvider,
    ISelectionChangedListener {
        private List<ISelectionChangedListener> selectionChangedListeners = null;
        private ISelection selection;
        private boolean synchronizingSelection = false;

        private SelectionSynchronizer() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            if (this.selectionChangedListeners == null) {
                this.selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
            }
            this.selectionChangedListeners.add(listener);
        }

        public ISelection getSelection() {
            return this.selection == null ? StructuredSelection.EMPTY : this.selection;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            if (this.selectionChangedListeners == null) {
                return;
            }
            this.selectionChangedListeners.remove(listener);
        }

        public void setSelection(ISelection selection) {
            this.selection = selection;
            if (TopicNotesViewer.this.implementation != null) {
                this.synchronizingSelection = true;
                TopicNotesViewer.this.implementation.setSelection(selection);
                this.synchronizingSelection = false;
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (this.synchronizingSelection) {
                return;
            }
            this.fireSelectionChanged(event);
        }

        private void fireSelectionChanged(SelectionChangedEvent event) {
            if (this.selectionChangedListeners == null) {
                return;
            }
            Object[] objectArray = this.selectionChangedListeners.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                ((ISelectionChangedListener)o).selectionChanged(event);
                ++n2;
            }
        }
    }
}

