/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorSupportProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.xmind.core.CoreException;
import org.xmind.core.IFileEntry;
import org.xmind.core.IManifest;
import org.xmind.core.IRelationship;
import org.xmind.core.IRelationshipEnd;
import org.xmind.core.ISheet;
import org.xmind.core.ISheetComponent;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicComponent;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSource2;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.util.FileUtils;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IEditDomainListener;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CommandStackEvent;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.ui.actions.IActionRegistry;
import org.xmind.gef.ui.actions.ICommandStackAction;
import org.xmind.gef.ui.actions.RedoAction;
import org.xmind.gef.ui.actions.UndoAction;
import org.xmind.gef.ui.editor.GraphicalEditor;
import org.xmind.gef.ui.editor.IEditingContext;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.gef.ui.editor.IInteractiveMessage;
import org.xmind.gef.ui.editor.IMiniBarContributor;
import org.xmind.ui.IWordContextProvider;
import org.xmind.ui.actions.MindMapActionFactory;
import org.xmind.ui.blackbox.BlackBox;
import org.xmind.ui.commands.ModifyFoldedCommand;
import org.xmind.ui.commands.MoveSheetCommand;
import org.xmind.ui.editor.EditorHistoryItem;
import org.xmind.ui.editor.IEditorHistory;
import org.xmind.ui.editor.PageTitleTabFolderRenderer;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.MindMapWordContextProvider;
import org.xmind.ui.internal.actions.CopySheetAction;
import org.xmind.ui.internal.actions.CreateSheetAction;
import org.xmind.ui.internal.actions.DeleteOtherSheetsAction;
import org.xmind.ui.internal.actions.DeleteSheetAction;
import org.xmind.ui.internal.actions.DuplicateSheetAction;
import org.xmind.ui.internal.actions.PasteSheetAction;
import org.xmind.ui.internal.actions.ShowPropertiesAction;
import org.xmind.ui.internal.e4handlers.SaveWorkbookAsHandler;
import org.xmind.ui.internal.editor.DecryptionDialog;
import org.xmind.ui.internal.editor.DefaultEditorLayout;
import org.xmind.ui.internal.editor.EditorLayoutManager;
import org.xmind.ui.internal.editor.EncryptionDialog;
import org.xmind.ui.internal.editor.ErrorDialog;
import org.xmind.ui.internal.editor.IEditorLayoutManager;
import org.xmind.ui.internal.editor.IEncryptable;
import org.xmind.ui.internal.editor.IMindMapPreviewGenerator;
import org.xmind.ui.internal.editor.MindMapEditorConfigurerManager;
import org.xmind.ui.internal.editor.MindMapEditorInput;
import org.xmind.ui.internal.editor.MindMapEditorPage;
import org.xmind.ui.internal.editor.MindMapEditorPagePopupPreviewHelper;
import org.xmind.ui.internal.editor.MindMapFindReplaceOperationProvider;
import org.xmind.ui.internal.editor.MindMapMiniBarContributor;
import org.xmind.ui.internal.editor.MindMapPageTitleEditor;
import org.xmind.ui.internal.editor.MindMapPreviewOptions;
import org.xmind.ui.internal.findreplace.IFindReplaceOperationProvider;
import org.xmind.ui.internal.mindmap.MindMapEditDomain;
import org.xmind.ui.internal.mindmap.MindMapState;
import org.xmind.ui.internal.mindmap.Overview;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.IWorkbookRef;
import org.xmind.ui.mindmap.IWorkbookRefListener;
import org.xmind.ui.mindmap.MindMapImageExporter;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.mindmap.MindMapViewerExportSourceProvider;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.tabfolder.IPageMoveListener;
import org.xmind.ui.tabfolder.PageMoveHelper;
import org.xmind.ui.util.Logger;
import org.xmind.ui.wizards.ISaveContext;

public class MindMapEditor
extends GraphicalEditor
implements ISaveablePart2,
ICoreEventListener,
IPageMoveListener,
IPropertyChangeListener,
IMindMapPreviewGenerator,
ISaveContext,
IWorkbookRefListener {
    public static final int OVERVIEW_WIDTH = 300;
    public static final int OVERVIEW_HEIGHT = 180;
    private static final int DEFAULT_EXPORT_MARGIN = 5;
    private static final int MINIMUM_PREVIEW_WIDTH = 420;
    private static final int MAXIMUM_PREVIEW_WIDTH = 1680;
    private IWorkbookRef workbookRef = null;
    private ICoreEventRegister workbookEventRegister = null;
    private ICoreEventRegister globalEventRegister = null;
    private MindMapPageTitleEditor pageTitleEditor = null;
    private PageMoveHelper pageMoveHelper = null;
    private MindMapFindReplaceOperationProvider findReplaceOperationProvider = null;
    private Composite messageContainer = null;
    private PageBook pageBook = null;
    private Composite pageContainer = null;
    private IEditingContext editingContext = new IEditingContext(){

        public <T> T getAdapter(Class<T> adapter) {
            MindMapEditor editor = MindMapEditor.this;
            Object result = editor.getSite().getService(adapter);
            if (result != null) {
                return (T)result;
            }
            result = editor.getAdapter(adapter);
            if (result != null) {
                return (T)result;
            }
            result = Platform.getAdapterManager().getAdapter((Object)editor, adapter);
            if (result != null) {
                return (T)result;
            }
            return null;
        }
    };
    private IWordContextProvider wordContextProvider = null;
    private boolean skipNextPreviewImage = false;
    private IContextActivation contextActivation = null;
    private IEditorHistory editorHistory = null;
    private boolean passwordTried = false;
    private IWindowListener windowListener;
    private ISelectionListener selectionListener;
    private boolean ignoreFileChanged = false;
    private IEditorLayoutManager layoutManager = null;
    private IContextActivation toolContextActivation = null;
    private IContextService contextService = null;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.editorHistory = (IEditorHistory)site.getService(IEditorHistory.class);
        this.workbookRef = this.createWorkbookRefFromInput(input);
        if (this.workbookRef == null) {
            throw new PartInitException("Failed to obtain workbook reference from editor input '" + input.toString() + "'");
        }
        super.init(site, input);
        this.setMiniBarContributor((IMiniBarContributor)new MindMapMiniBarContributor());
    }

    private IWorkbookRef createWorkbookRefFromInput(IEditorInput input) {
        IWorkbookRef workbookRef = (IWorkbookRef)input.getAdapter(IWorkbookRef.class);
        if (workbookRef != null) {
            return workbookRef;
        }
        URI uri = (URI)input.getAdapter(URI.class);
        if (uri != null) {
            return MindMapUIPlugin.getDefault().getWorkbookRefFactory().createWorkbookRef(uri, null);
        }
        return null;
    }

    protected ISelectionProvider createSelectionProvider() {
        MindMapEditorSelectionProvider selectionProvider = new MindMapEditorSelectionProvider();
        selectionProvider.setDisplay(Display.getCurrent());
        return selectionProvider;
    }

    protected ICommandStack createCommandStack() {
        if (this.workbookRef != null) {
            return this.workbookRef.getCommandStack();
        }
        return super.createCommandStack();
    }

    protected void disposeCommandStack(ICommandStack commandStack) {
    }

    private void disposeData() {
        IWorkbookRef theWorkbookRef;
        URI uri;
        if (this.workbookRef != null && this.workbookRef.getURI() != null && URIUtil.isFileURI((URI)(uri = this.workbookRef.getURI()))) {
            BlackBox.removeSavedMap(URIUtil.toFile((URI)uri).getAbsolutePath());
        }
        if ((theWorkbookRef = this.workbookRef) != null) {
            theWorkbookRef.removePropertyChangeListener(this);
            theWorkbookRef.removeWorkbookRefListener(this);
            MindMapState.getInstance().saveState(theWorkbookRef, this.getPages());
            if (theWorkbookRef.isDirty()) {
                theWorkbookRef.discardChanges();
            }
            this.safeRun(null, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    theWorkbookRef.close(monitor);
                }
            });
            IEditingContext activeContext = theWorkbookRef.getActiveContext();
            if (activeContext == this.editingContext) {
                theWorkbookRef.setActiveContext(null);
            }
        }
        this.deactivateToolContext();
        this.uninstallModelListener();
    }

    public void dispose() {
        if (this.contextActivation != null) {
            IContextService cs = (IContextService)this.getSite().getService(IContextService.class);
            cs.deactivateContext(this.contextActivation);
        }
        this.disposeData();
        super.dispose();
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof MindMapEditorInput) {
            ((MindMapEditorInput)editorInput).dispose();
        }
        this.deactivateFileNotifier();
        this.workbookEventRegister = null;
        this.globalEventRegister = null;
        this.pageTitleEditor = null;
        this.pageMoveHelper = null;
        this.findReplaceOperationProvider = null;
        this.workbookRef = null;
        this.pageBook = null;
        this.pageContainer = null;
        this.workbookRef = null;
        this.layoutManager = null;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        Composite container = this.getContainer();
        if (container instanceof CTabFolder) {
            ((CTabFolder)container).setRenderer((CTabFolderRenderer)new PageTitleTabFolderRenderer((CTabFolder)container, this));
        }
        this.activateFileNotifier();
    }

    protected Composite createContainerParent(Composite parent) {
        FormLayout formLayout = new FormLayout();
        parent.setLayout((Layout)formLayout);
        this.messageContainer = new Composite(parent, 2048);
        FormData messageFormData = new FormData();
        this.messageContainer.setLayoutData((Object)messageFormData);
        this.messageContainer.setVisible(false);
        GridLayout messageLayout = new GridLayout(1, false);
        messageLayout.marginWidth = 0;
        messageLayout.marginHeight = 0;
        messageLayout.horizontalSpacing = 0;
        messageLayout.verticalSpacing = 0;
        this.messageContainer.setLayout((Layout)messageLayout);
        this.updateMessages(false);
        this.pageBook = new PageBook(parent, 0);
        FormData pageBookData = new FormData();
        pageBookData.left = new FormAttachment(0, 0);
        pageBookData.top = new FormAttachment(0, 0);
        pageBookData.bottom = new FormAttachment(100, 0);
        pageBookData.right = new FormAttachment(100, 0);
        this.pageBook.setLayoutData((Object)pageBookData);
        this.pageContainer = new Composite((Composite)this.pageBook, 0);
        this.layoutManager = new EditorLayoutManager(this.pageContainer);
        this.layoutManager.setActiveLayout(new DefaultEditorLayout());
        IContextService cs = (IContextService)this.getSite().getService(IContextService.class);
        this.contextActivation = cs.activateContext("org.xmind.ui.context.mindmap");
        return this.pageContainer;
    }

    protected void createEditorContents() {
        super.createEditorContents();
        if (this.workbookRef != null) {
            this.workbookRef.setActiveContext(this.editingContext);
            this.workbookRef.addPropertyChangeListener(this);
            this.workbookRef.addWorkbookRefListener(this);
        }
        this.createActions(this.getActionRegistry());
        this.updateNames();
        if (this.getContainer() instanceof CTabFolder) {
            CTabFolder tabFolder = (CTabFolder)this.getContainer();
            this.pageMoveHelper = new PageMoveHelper(tabFolder);
            this.pageMoveHelper.addListener((IPageMoveListener)this);
            this.pageTitleEditor = new MindMapPageTitleEditor(tabFolder, this);
            new MindMapEditorPagePopupPreviewHelper((IGraphicalEditor)this, tabFolder);
        }
        MindMapEditorConfigurerManager.getInstance().configureEditor(this);
        if (this.getWorkbook() != null) {
            this.workbookLoaded();
        } else if (this.workbookRef != null) {
            final IWorkbookRef theWorkbookRef = this.workbookRef;
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MindMapEditor.this.loadWorkbook(theWorkbookRef, 0);
                    MindMapEditor.collectUserData(theWorkbookRef.getURI());
                }
            });
        }
    }

    private static void collectUserData(URI uri) {
        if (uri == null || "".equals(uri)) {
            return;
        }
        String scheme = uri.getScheme();
        if (scheme == null || "".equalsIgnoreCase(scheme)) {
            return;
        }
        if ("file".equalsIgnoreCase(scheme)) {
            MindMapUIPlugin.getDefault().getUsageDataCollector().increase("OpenLocalWorkbookCount");
        }
    }

    private void loadWorkbook(final IWorkbookRef workbookRef, int times) {
        IWorkbenchSiteProgressService context;
        IEncryptable encryptable = (IEncryptable)workbookRef.getAdapter(IEncryptable.class);
        if (encryptable != null && !encryptable.hasPassword()) {
            encryptable.setPassword(null);
        }
        Assert.isTrue(((context = (IWorkbenchSiteProgressService)this.getSite().getService(IWorkbenchSiteProgressService.class)) != null ? 1 : 0) != 0);
        try {
            context.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    workbookRef.open(monitor);
                }
            });
        }
        catch (InvocationTargetException e) {
            int errType;
            CoreException coreEx = this.getCoreException(e);
            if (coreEx != null && (errType = coreEx.getType()) == 17) {
                String message = this.passwordTried ? MindMapMessages.MindMapEditor_passwordPrompt_message1 : MindMapMessages.MindMapEditor_passwordPrompt_message2;
                this.openDecryptionDialog(workbookRef, message, times);
                this.passwordTried = true;
                return;
            }
            Throwable cause = e.getTargetException();
            if (cause == null) {
                cause = e;
            }
            if (cause instanceof FileNotFoundException) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning(null, (String)MindMapMessages.OpenLocalFileHandler_MessageDialog_title, (String)MindMapMessages.WorkbookHistoryItem_FileMissingMessage);
                    }
                });
                this.asyncClose();
            } else {
                this.showError(cause, (ErrorSupportProvider)workbookRef.getAdapter(ErrorSupportProvider.class));
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            this.asyncClose();
            return;
        }
        this.workbookLoaded();
    }

    private void openDecryptionDialog(final IWorkbookRef workbookRef, String message, int times) {
        final int nextTime = times + 1;
        final IEncryptable encryptable = (IEncryptable)workbookRef.getAdapter(IEncryptable.class);
        new DecryptionDialog(Display.getCurrent().getActiveShell(), workbookRef.getName(), encryptable.getPasswordHint(), times){

            @Override
            protected void okPressed() {
                super.okPressed();
                encryptable.setPassword(this.getPassword());
                MindMapEditor.this.loadWorkbook(workbookRef, nextTime);
            }

            protected void handleShellCloseEvent() {
                super.handleShellCloseEvent();
                MindMapEditor.this.asyncClose();
            }

            protected void cancelPressed() {
                super.cancelPressed();
                MindMapEditor.this.asyncClose();
            }
        }.open();
    }

    private CoreException getCoreException(Throwable e) {
        if (e == null) {
            return null;
        }
        if (e instanceof CoreException) {
            return (CoreException)e;
        }
        return this.getCoreException(e.getCause());
    }

    private void asyncClose() {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                MindMapEditor.this.closeEditor();
            }
        });
    }

    private void closeEditor() {
        this.getSite().getPage().closeEditor((IEditorPart)this, false);
    }

    private void showError(Throwable exception, ErrorSupportProvider supportProvider) {
        StatusAdapter statusAdapter = new StatusAdapter((IStatus)new Status(4, "org.xmind.ui.mindmap", MindMapMessages.LoadWorkbookJob_errorDialog_title, exception));
        statusAdapter.setProperty(IStatusAdapterConstants.TIMESTAMP_PROPERTY, (Object)System.currentTimeMillis());
        ErrorDialog errorDialog = new ErrorDialog(Display.getCurrent().getActiveShell(), statusAdapter, supportProvider);
        errorDialog.setCloseCallback(new Runnable(){

            @Override
            public void run() {
                MindMapEditor.this.asyncClose();
            }
        });
        errorDialog.open();
    }

    protected void createActions(IActionRegistry actionRegistry) {
        UndoAction undoAction = new UndoAction((IGraphicalEditor)this);
        actionRegistry.addAction((IAction)undoAction);
        this.addCommandStackAction((ICommandStackAction)undoAction);
        RedoAction redoAction = new RedoAction((IGraphicalEditor)this);
        actionRegistry.addAction((IAction)redoAction);
        this.addCommandStackAction((ICommandStackAction)redoAction);
        CreateSheetAction createSheetAction = new CreateSheetAction((IGraphicalEditor)this);
        actionRegistry.addAction((IAction)createSheetAction);
        DeleteSheetAction deleteSheetAction = new DeleteSheetAction((IGraphicalEditor)this);
        actionRegistry.addAction((IAction)deleteSheetAction);
        DeleteOtherSheetsAction deleteOtherSheetAction = new DeleteOtherSheetsAction((IGraphicalEditor)this);
        actionRegistry.addAction((IAction)deleteOtherSheetAction);
        DuplicateSheetAction duplicateSheetAction = new DuplicateSheetAction((IGraphicalEditor)this);
        actionRegistry.addAction((IAction)duplicateSheetAction);
        CopySheetAction copySheetAction = new CopySheetAction((IGraphicalEditor)this);
        actionRegistry.addAction((IAction)copySheetAction);
        PasteSheetAction pasteSheetAction = new PasteSheetAction((IGraphicalEditor)this);
        actionRegistry.addAction((IAction)pasteSheetAction);
        ShowPropertiesAction showPropertiesAction = new ShowPropertiesAction(this.getSite().getWorkbenchWindow());
        actionRegistry.addAction((IAction)showPropertiesAction);
    }

    private void configurePage(IGraphicalEditorPage page) {
        MindMapEditorConfigurerManager.getInstance().configurePage(page);
    }

    protected void createPages() {
        if (this.getWorkbook() == null) {
            return;
        }
        for (ISheet sheet : this.getWorkbook().getSheets()) {
            IGraphicalEditorPage page = this.createSheetPage(sheet, -1);
            this.configurePage(page);
        }
        if (this.getPageCount() > 0) {
            this.setActivePage(0);
        }
    }

    private void addOverview() {
        final Composite container = this.getContainer();
        final Composite overviewControl = this.createOverview(container);
        overviewControl.moveAbove(null);
        overviewControl.setLayoutData((Object)new GridData(4, 4, true, true));
        new Overview(overviewControl, (IGraphicalEditor)this);
        org.eclipse.swt.graphics.Rectangle containerClientArea = container.getClientArea();
        overviewControl.setBounds(containerClientArea.width - 300, containerClientArea.height - 180, 300, 180);
        container.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                org.eclipse.swt.graphics.Rectangle containerClientArea = container.getClientArea();
                overviewControl.setBounds(containerClientArea.width - 300, containerClientArea.height - 180, 300, 180);
            }

            public void controlMoved(ControlEvent e) {
                org.eclipse.swt.graphics.Rectangle containerClientArea = container.getClientArea();
                overviewControl.setBounds(containerClientArea.width - 300, containerClientArea.height - 180, 300, 180);
            }
        });
    }

    private Composite createOverview(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        return composite;
    }

    protected IGraphicalEditorPage createSheetPage(ISheet sheet, int index) {
        MindMapEditorPage page = new MindMapEditorPage();
        page.init((IGraphicalEditor)this, sheet);
        this.addPage((IGraphicalEditorPage)page);
        if (index >= 0 && index < this.getPageCount()) {
            this.movePageTo(this.findPage((IGraphicalEditorPage)page), index);
        }
        index = this.findPage((IGraphicalEditorPage)page);
        if (this.getActivePage() != index) {
            this.setActivePage(index);
        }
        page.updatePageTitle();
        MindMapState.getInstance().loadState(this.getWorkbookRef(), (IGraphicalEditorPage)page);
        return page;
    }

    protected EditDomain createEditDomain(IGraphicalEditorPage page) {
        MindMapEditDomain domain = new MindMapEditDomain();
        domain.addEditDomainListener(new IEditDomainListener(){

            public void activeToolChanged(ITool oldTool, ITool newTool) {
                MindMapEditor.this.changeContext(newTool);
            }
        });
        domain.setCommandStack(this.getCommandStack());
        return domain;
    }

    protected void changeContext(ITool newTool) {
        this.deactivateToolContext();
        this.activateContext(newTool == null ? null : newTool.getContextId());
    }

    protected void changeContext(String contextId) {
        this.deactivateToolContext();
        this.activateContext(contextId);
    }

    private void activateContext(String contextId) {
        if (contextId == null) {
            return;
        }
        this.contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (this.contextService != null) {
            this.toolContextActivation = this.contextService.activateContext(contextId);
        }
    }

    private void deactivateToolContext() {
        if (this.contextService != null && this.toolContextActivation != null) {
            this.contextService.deactivateContext(this.toolContextActivation);
        }
        this.contextService = null;
        this.toolContextActivation = null;
    }

    private void updateMessages(boolean layout) {
        Control[] controlArray = this.messageContainer.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control messageItem = controlArray[n2];
            messageItem.dispose();
            ++n2;
        }
        List messages = this.workbookRef.getMessages();
        if (messages != null && !messages.isEmpty()) {
            for (IInteractiveMessage message : new ArrayList(messages)) {
                Color textColor;
                Color lineColor;
                Image icon;
                int type = message.getMessageType();
                if (type == 2) {
                    icon = null;
                    lineColor = (Color)JFaceResources.getResources().get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#fff6ae"));
                    textColor = (Color)JFaceResources.getResources().get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#1e1e1e"));
                } else if (type == 3) {
                    icon = null;
                    lineColor = (Color)JFaceResources.getResources().get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#fff6ae"));
                    textColor = (Color)JFaceResources.getResources().get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#1e1e1e"));
                } else {
                    icon = Display.getCurrent().getSystemImage(2);
                    lineColor = (Color)JFaceResources.getResources().get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#fff6ae"));
                    textColor = (Color)JFaceResources.getResources().get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#1e1e1e"));
                }
                String text = message.getMessage();
                if (text == null) {
                    text = "";
                }
                List actions = message.getActions();
                final Composite line = new Composite(this.messageContainer, 0);
                line.setBackground(lineColor);
                GridData lineData = new GridData(0x1000000, 4, true, false);
                lineData.widthHint = 500;
                line.setLayoutData((Object)lineData);
                line.setLayout((Layout)new GridLayout(2, false));
                Composite leftComposite = new Composite(line, 0);
                leftComposite.setBackground(line.getBackground());
                GridData lineBodyData = new GridData(0x1000000, 4, true, false);
                leftComposite.setLayoutData((Object)lineBodyData);
                int numColumns = 0;
                GridLayout leftCompositeLayout = new GridLayout(numColumns, false);
                leftCompositeLayout.marginLeft = 16;
                leftCompositeLayout.marginHeight = 5;
                leftCompositeLayout.horizontalSpacing = 3;
                leftCompositeLayout.verticalSpacing = 0;
                leftComposite.setLayout((Layout)leftCompositeLayout);
                if (icon != null) {
                    ++numColumns;
                    Label iconLabel = new Label(leftComposite, 0);
                    iconLabel.setBackground(line.getBackground());
                    iconLabel.setImage(icon);
                    iconLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, true));
                }
                ++numColumns;
                Label textLabel = new Label(leftComposite, 0x1000040);
                textLabel.setText(text);
                textLabel.setBackground(line.getBackground());
                textLabel.setForeground(textColor);
                textLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
                Font textFont = textLabel.getFont();
                if (textFont != null) {
                    FontData[] fontData = textFont.getFontData();
                    FontData[] newFontData = FontUtils.newHeight((FontData[])fontData, (int)(Util.isMac() ? 12 : 10));
                    textLabel.setFont((Font)JFaceResources.getResources().get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])newFontData)));
                }
                if (!actions.isEmpty()) {
                    ++numColumns;
                    Composite actionBar = new Composite(leftComposite, 0);
                    actionBar.setBackground(line.getBackground());
                    actionBar.setLayoutData((Object)new GridData(4, 4, false, true));
                    GridLayout actionLayout = new GridLayout(actions.size(), false);
                    actionLayout.marginWidth = 0;
                    actionLayout.marginHeight = 0;
                    actionLayout.horizontalSpacing = 3;
                    actionLayout.verticalSpacing = 0;
                    actionBar.setLayout((Layout)actionLayout);
                    for (final IAction action : actions) {
                        Button actionButton = new Button(actionBar, 8);
                        actionButton.setBackground(actionBar.getBackground());
                        actionButton.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
                        String actionText = action.getText();
                        if (actionText == null) {
                            actionButton.setText(actionText);
                        } else {
                            ImageDescriptor actionImageDescriptor = action.getImageDescriptor();
                            if (actionImageDescriptor != null) {
                                final Image actionImage = actionImageDescriptor.createImage((Device)Display.getCurrent());
                                actionButton.addDisposeListener(new DisposeListener(){

                                    public void widgetDisposed(DisposeEvent e) {
                                        actionImage.dispose();
                                    }
                                });
                                actionButton.setImage(actionImage);
                            }
                        }
                        actionButton.setToolTipText(action.getToolTipText());
                        actionButton.addListener(13, new Listener(){

                            public void handleEvent(Event event) {
                                action.runWithEvent(event);
                            }
                        });
                    }
                }
                leftCompositeLayout.numColumns = numColumns;
                final Label closeImageLabel = new Label(line, 0);
                closeImageLabel.setBackground(line.getBackground());
                closeImageLabel.setImage((Image)JFaceResources.getResources().get((DeviceResourceDescriptor)MindMapUI.getImages().get("close.png", true)));
                closeImageLabel.setLayoutData((Object)new GridData(0x1000008, 1, false, false));
                closeImageLabel.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseDown(MouseEvent e) {
                        if (MindMapEditor.this.messageContainer != null && !MindMapEditor.this.messageContainer.isDisposed()) {
                            Control[] children;
                            if (line != null && !line.isDisposed()) {
                                line.dispose();
                            }
                            if ((children = MindMapEditor.this.messageContainer.getChildren()) == null || children.length == 0) {
                                MindMapEditor.this.messageContainer.setVisible(false);
                            }
                            MindMapEditor.this.messageContainer.getParent().layout(true);
                        }
                    }
                });
                closeImageLabel.addMouseTrackListener(new MouseTrackListener(){

                    public void mouseHover(MouseEvent e) {
                        closeImageLabel.setCursor(Display.getDefault().getSystemCursor(21));
                    }

                    public void mouseExit(MouseEvent e) {
                        closeImageLabel.setCursor(null);
                    }

                    public void mouseEnter(MouseEvent e) {
                        closeImageLabel.setCursor(Display.getDefault().getSystemCursor(21));
                    }
                });
            }
            Point size = this.messageContainer.computeSize(-1, -1);
            FormData messageFormData = new FormData();
            messageFormData.left = new FormAttachment(50, -size.x / 2);
            messageFormData.right = new FormAttachment(50, size.x / 2);
            messageFormData.top = new FormAttachment(0, 0);
            this.messageContainer.setLayoutData((Object)messageFormData);
            this.messageContainer.setVisible(true);
        }
        if (layout) {
            this.messageContainer.getParent().layout(true, true);
        }
    }

    protected void updateNames() {
        this.setPartName(this.getEditorInput().getName());
        this.setTitleToolTip(this.getEditorInput().getToolTipText());
    }

    public IWorkbookRef getWorkbookRef() {
        return this.workbookRef;
    }

    public IWorkbook getWorkbook() {
        if (this.workbookRef == null) {
            return null;
        }
        return this.workbookRef.getWorkbook();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IEditorLayoutManager.class) {
            return (T)this.layoutManager;
        }
        return (T)super.getAdapter(adapter);
    }

    protected <T> T getEditorAdapter(Class<T> adapter) {
        Object result;
        if (this.workbookRef != null && (result = this.workbookRef.getAdapter(adapter)) != null) {
            return (T)result;
        }
        if (adapter == IWorkbookRef.class) {
            return adapter.cast(this.getWorkbookRef());
        }
        if (adapter == IWorkbook.class) {
            return adapter.cast(this.getWorkbook());
        }
        if (adapter == MindMapPageTitleEditor.class) {
            return adapter.cast(this.pageTitleEditor);
        }
        if (adapter == PageMoveHelper.class) {
            return adapter.cast(this.pageMoveHelper);
        }
        if (adapter == IFindReplaceOperationProvider.class) {
            if (this.findReplaceOperationProvider == null) {
                this.findReplaceOperationProvider = new MindMapFindReplaceOperationProvider((IGraphicalEditor)this);
            }
            return adapter.cast(this.findReplaceOperationProvider);
        }
        if (adapter == IWordContextProvider.class) {
            if (this.wordContextProvider == null) {
                this.wordContextProvider = new MindMapWordContextProvider((IGraphicalEditor)this);
            }
            return adapter.cast(this.wordContextProvider);
        }
        return (T)super.getEditorAdapter(adapter);
    }

    protected void installModelListener() {
        IWorkbook workbook = this.getWorkbook();
        this.workbookEventRegister = new CoreEventRegister((Object)workbook, (ICoreEventListener)this);
        this.workbookEventRegister.register("sheetAdd");
        this.workbookEventRegister.register("sheetRemove");
        this.workbookEventRegister.register("sheetMove");
        this.workbookEventRegister.register("passwordChange");
        this.workbookEventRegister.register("workbookPreSaveOnce");
        this.globalEventRegister = new CoreEventRegister((ICoreEventSupport)workbook.getAdapter(ICoreEventSupport.class), (ICoreEventListener)this);
        this.globalEventRegister.register("sheetSettings");
    }

    protected void uninstallModelListener() {
        if (this.workbookEventRegister != null) {
            this.workbookEventRegister.unregisterAll();
            this.workbookEventRegister = null;
        }
        if (this.globalEventRegister != null) {
            this.globalEventRegister.unregisterAll();
            this.globalEventRegister = null;
        }
    }

    public void handleCoreEvent(final CoreEvent event) {
        if (this.pageBook == null || this.pageBook.isDisposed() || this.workbookRef == null) {
            return;
        }
        this.pageBook.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbook workbook;
                String type = event.getType();
                if ("workbookPreSaveOnce".equals(type)) {
                    MindMapEditor.this.firePropertyChange(257);
                    MindMapEditor.this.firePropertyChange(258);
                } else if ("sheetAdd".equals(type)) {
                    ISheet sheet = (ISheet)event.getTarget();
                    int index = event.getIndex();
                    IGraphicalEditorPage page = MindMapEditor.this.createSheetPage(sheet, index);
                    MindMapEditor.this.configurePage(page);
                } else if ("sheetRemove".equals(type)) {
                    ISheet sheet = (ISheet)event.getTarget();
                    IGraphicalEditorPage page = MindMapEditor.this.findPage(sheet);
                    if (page != null) {
                        MindMapEditor.this.removePage(page);
                    }
                } else if ("sheetMove".equals(type)) {
                    int oldIndex = event.getIndex();
                    int newIndex = ((ISheet)event.getTarget()).getIndex();
                    MindMapEditor.this.movePageTo(oldIndex, newIndex);
                } else if ("passwordChange".equals(type) && (workbook = MindMapEditor.this.getWorkbook()) instanceof ICoreEventSource2) {
                    ((ICoreEventSource2)workbook).registerOnceCoreEventListener("workbookPreSaveOnce", ICoreEventListener.NULL);
                }
                if ("sheetSettings".equals(type) && "rgb".equals(event.getTarget())) {
                    MindMapEditor.this.updateSheetTabColors();
                }
            }
        });
    }

    private void updateSheetTabColors() {
        this.getContainer().redraw();
    }

    protected void saveAndRun(Command command) {
        ICommandStack cs = this.getCommandStack();
        if (cs != null) {
            cs.execute(command);
        }
    }

    public void pageMoved(int fromIndex, int toIndex) {
        IWorkbook workbook = this.getWorkbook();
        MoveSheetCommand command = new MoveSheetCommand(workbook, fromIndex, toIndex);
        command.setLabel("");
        this.saveAndRun((Command)command);
    }

    protected void createSheet() {
        IAction action = this.getActionRegistry().getAction(MindMapActionFactory.NEW_SHEET.getId());
        if (action != null && action.isEnabled()) {
            action.run();
        }
    }

    public void setFocus() {
        if (this.workbookRef != null) {
            this.workbookRef.setActiveContext(this.editingContext);
        }
        super.setFocus();
    }

    public void openEncryptionDialog() {
        if (this.pageBook == null || this.pageBook.isDisposed()) {
            return;
        }
        final IWorkbookRef theWorkbookRef = this.workbookRef;
        new EncryptionDialog(Display.getCurrent().getActiveShell()){

            @Override
            protected boolean hasPassword() {
                IEncryptable encryptable = (IEncryptable)theWorkbookRef.getAdapter(IEncryptable.class);
                return encryptable != null && encryptable.hasPassword();
            }

            @Override
            protected boolean testsPassword(String password) {
                IEncryptable encryptable = (IEncryptable)theWorkbookRef.getAdapter(IEncryptable.class);
                return encryptable != null && encryptable.testsPassword(password);
            }

            @Override
            protected void okPressed() {
                IEncryptable encryptable;
                boolean verified = this.verify();
                super.okPressed();
                if (verified && (encryptable = (IEncryptable)theWorkbookRef.getAdapter(IEncryptable.class)) != null) {
                    encryptable.setPassword(this.getPassword());
                    encryptable.setPasswordHint(this.getHintMessage());
                }
            }
        }.open();
    }

    public ISelectionProvider getSelectionProvider() {
        return this.getSite().getSelectionProvider();
    }

    public void reveal() {
        this.getSite().getPage().activate((IWorkbenchPart)this);
        this.setFocus();
    }

    @Deprecated
    public void postSave(IProgressMonitor monitor) {
        this.getSite().getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MindMapEditor.this.postSave();
            }
        });
    }

    public void setSelection(ISelection selection, boolean reveal, boolean forceFocus) {
        ISelectionProvider selectionProvider = this.getSite().getSelectionProvider();
        if (selectionProvider != null) {
            selectionProvider.setSelection(selection);
        }
        if (forceFocus) {
            this.getSite().getPage().activate((IWorkbenchPart)this);
            Shell shell = this.getSite().getShell();
            if (shell != null && !shell.isDisposed()) {
                shell.setActive();
            }
        } else if (reveal) {
            this.getSite().getPage().bringToTop((IWorkbenchPart)this);
        }
    }

    public IGraphicalEditorPage findPage(Object input) {
        if (input instanceof IMindMap) {
            input = ((IMindMap)input).getSheet();
        }
        return super.findPage(input);
    }

    private void workbookLoaded() {
        this.passwordTried = false;
        if (this.pageBook == null || this.pageBook.isDisposed()) {
            return;
        }
        this.pageBook.showPage((Control)this.pageContainer);
        if (this.isEditorActive()) {
            this.setFocus();
        }
        Assert.isTrue((this.getWorkbook() != null ? 1 : 0) != 0);
        this.createPages();
        this.addOverview();
        if (this.isEditorActive()) {
            this.setFocus();
        }
        this.installModelListener();
        this.firePropertyChange(258);
        this.firePropertyChange(257);
        this.recordEditorHistory();
    }

    private boolean isEditorActive() {
        return this.getSite().getPage().getActiveEditor() == this;
    }

    protected Object findOwnedInput(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object[] elements;
            Object[] objectArray = elements = ((IStructuredSelection)selection).toArray();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof ISheetComponent) {
                    return ((ISheetComponent)element).getOwnedSheet();
                }
                if (element instanceof ISheet) {
                    return (ISheet)element;
                }
                ++n2;
            }
        }
        return super.findOwnedInput(selection);
    }

    public void skipNextPreviewImage() {
        this.skipNextPreviewImage = true;
    }

    private void setSelectionAndUnfold(Object element) {
        ArrayList<ModifyFoldedCommand> showElementsCommands = new ArrayList<ModifyFoldedCommand>(1);
        ITopic parent = ((ITopicComponent)element).getParent();
        while (parent != null) {
            if (parent.isFolded()) {
                showElementsCommands.add(new ModifyFoldedCommand(parent, false));
            }
            parent = parent.getParent();
        }
        if (!showElementsCommands.isEmpty()) {
            CompoundCommand command = new CompoundCommand(((Command)showElementsCommands.get(0)).getLabel(), showElementsCommands);
            this.saveAndRun((Command)command);
        }
    }

    public boolean isDirty() {
        return this.workbookRef != null && this.workbookRef.isDirty();
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.workbookRef == null) {
            return;
        }
        if (!this.workbookRef.canSave()) {
            this.doSaveAs();
            return;
        }
        this.safeRun(monitor, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                URI uri;
                MindMapEditor.this.workbookRef.save(monitor);
                if (MindMapUIPlugin.getDefault().getPreferenceStore().getBoolean("autoBackupEnable") && URIUtil.isFileURI((URI)(uri = MindMapEditor.this.workbookRef.getURI()))) {
                    BlackBox.doBackup(URIUtil.toFile((URI)uri).getAbsolutePath());
                }
                MindMapEditor.this.postSave();
                MindMapEditor.this.recordEditorHistory();
            }
        });
    }

    private void recordEditorHistory() {
        if (this.workbookRef.getURI() == null || this.workbookRef.getName() == null) {
            return;
        }
        URI uri = this.workbookRef.getURI();
        if (!uri.getScheme().equalsIgnoreCase("file")) {
            return;
        }
        InputStream input = null;
        try {
            try {
                input = uri.getScheme().equalsIgnoreCase("file") ? this.getThumbnailStreamForLocal() : this.getThumbnailStreamFor(this.workbookRef);
                if (input == null) {
                    return;
                }
                this.editorHistory.add(this.workbookRef.getURI(), new EditorHistoryItem(this.workbookRef.getName(), System.currentTimeMillis()));
                this.editorHistory.saveThumbnailData(this.workbookRef.getURI(), input);
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (IOException e) {
            MindMapUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.xmind.ui.mindmap", "Failed to record preview image for editor history", (Throwable)e));
        }
    }

    private InputStream getThumbnailStreamForLocal() throws IOException {
        IFileEntry thumbnailEntry;
        IManifest manifest = this.getWorkbook().getManifest();
        if (manifest != null && (thumbnailEntry = manifest.getFileEntry("Thumbnails/thumbnail.png")) != null) {
            return thumbnailEntry.openInputStream();
        }
        return null;
    }

    private InputStream getThumbnailStreamFor(IWorkbookRef workbookRef) {
        if (workbookRef == null) {
            return null;
        }
        List sheets = workbookRef.getWorkbook().getSheets();
        if (sheets.isEmpty()) {
            return null;
        }
        ISheet sheet = (ISheet)sheets.get(0);
        try {
            return workbookRef.getPreviewImageData(sheet.getId(), null);
        }
        catch (IOException e) {
            MindMapUIPlugin.log(e, String.format("Failed to load preview image for sheet 'workbooks/%s/sheets/%s'", sheet.getParent().toString(), sheet.getId()));
        }
        catch (SWTException e) {
            MindMapUIPlugin.log(e, String.format("Failed to load preview image for sheet 'workbooks/%s/sheets/%s'", sheet.getParent().toString(), sheet.getId()));
        }
        return null;
    }

    public void doSaveAs() {
        this.doSaveAs(false);
    }

    public void doSaveAs(boolean onlyToLocal) {
        IWorkbookRef newWorkbookRef;
        IWorkbookRef oldWorkbookRef = this.workbookRef;
        if (oldWorkbookRef == null || oldWorkbookRef.isInState(33)) {
            throw new IllegalStateException("This mind map editor is already closed.");
        }
        IProgressService runner = (IProgressService)this.getSite().getService(IProgressService.class);
        try {
            newWorkbookRef = SaveWorkbookAsHandler.saveWorkbookAs(this, oldWorkbookRef, (IRunnableContext)runner, null, onlyToLocal);
            if (newWorkbookRef == null) {
                return;
            }
            if (newWorkbookRef.equals(oldWorkbookRef)) {
                this.postSave();
                this.recordEditorHistory();
                return;
            }
            try {
                runner.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        newWorkbookRef.open(monitor);
                        newWorkbookRef.save(monitor);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        catch (Exception e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.xmind.ui.mindmap", e.getMessage(), (Throwable)e), 1);
            return;
        }
        EditorStatus editorStatus = EditorStatus.getInstance();
        editorStatus.saveStatus(oldWorkbookRef, this.getActivePage(), this.getPages());
        this.disposeData();
        while (this.getPageCount() > 0) {
            this.removePage(0);
        }
        this.workbookRef = newWorkbookRef;
        if (newWorkbookRef != null) {
            newWorkbookRef.addPropertyChangeListener(this);
            newWorkbookRef.addWorkbookRefListener(this);
        }
        this.setInput(MindMapUI.getEditorInputFactory().createEditorInput(newWorkbookRef));
        this.setCommandStack(newWorkbookRef.getCommandStack());
        this.updateNames();
        this.createPages();
        this.installModelListener();
        this.firePropertyChange(258);
        this.postSave();
        this.setActivePage(editorStatus.getActiveIndex());
        IGraphicalEditorPage[] pages = this.getPages();
        int index = 0;
        while (index < pages.length) {
            org.eclipse.draw2d.geometry.Point scrollPosition;
            List topicTypeChain;
            IGraphicalViewer viewer = pages[index].getViewer();
            viewer.getProperties().set("selectCentralTopic", (Object)Boolean.FALSE);
            Double scale = editorStatus.getZooms().get(index);
            if (scale != null) {
                viewer.getZoomManager().setScale(scale.doubleValue());
            }
            String indexPath = index < editorStatus.getIndexPaths().size() ? editorStatus.getIndexPaths().get(index) : "";
            List<Object> list = topicTypeChain = index < editorStatus.getTopicTypeChains().size() ? editorStatus.getTopicTypeChains().get(index) : Collections.emptyList();
            if (indexPath != null) {
                if ("".equals(indexPath)) {
                    viewer.setSelection((ISelection)StructuredSelection.EMPTY, true);
                } else {
                    Object input = viewer.getInput();
                    if (input instanceof IMindMap) {
                        ITopic topic = ((IMindMap)input).getCentralTopic();
                        String[] indexes = indexPath.split("/");
                        int i = 1;
                        while (i < indexes.length) {
                            String type;
                            String string = type = i < topicTypeChain.size() ? (String)topicTypeChain.get(i) : "attached";
                            if (topic.getChildren(type).size() > Integer.parseInt(indexes[i])) {
                                topic = (ITopic)topic.getChildren(type).get(Integer.parseInt(indexes[i]));
                            }
                            ++i;
                        }
                        viewer.setSelection((ISelection)new StructuredSelection((Object)topic), true);
                    }
                }
            }
            if ((scrollPosition = editorStatus.getScrollPositions().get(index)) != null) {
                viewer.scrollTo(scrollPosition);
            }
            ++index;
        }
        this.recordEditorHistory();
        IEclipseContext partContext = (IEclipseContext)this.getSite().getService(IEclipseContext.class);
        partContext.deactivate();
        partContext.activateBranch();
    }

    private void reload() {
        IWorkbookRef oldWorkbookRef = this.workbookRef;
        if (oldWorkbookRef == null || oldWorkbookRef.isInState(33)) {
            throw new IllegalStateException("This mind map editor is already closed.");
        }
        EditorStatus editorStatus = EditorStatus.getInstance();
        editorStatus.saveStatus(oldWorkbookRef, this.getActivePage(), this.getPages());
        IEditingContext context = oldWorkbookRef.getActiveContext();
        this.disposeData();
        while (this.getPageCount() > 0) {
            this.removePage(0);
        }
        final IWorkbookRef newWorkbookRef = MindMapUIPlugin.getDefault().getWorkbookRefFactory().createWorkbookRef(oldWorkbookRef.getURI(), null);
        if (newWorkbookRef == null) {
            return;
        }
        try {
            IProgressService runner = (IProgressService)this.getSite().getService(IProgressService.class);
            runner.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    newWorkbookRef.open(monitor);
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
        this.workbookRef = newWorkbookRef;
        if (newWorkbookRef != null) {
            newWorkbookRef.setActiveContext(context);
            newWorkbookRef.addPropertyChangeListener(this);
            newWorkbookRef.addWorkbookRefListener(this);
        }
        this.setInput(MindMapUI.getEditorInputFactory().createEditorInput(newWorkbookRef));
        this.setCommandStack(newWorkbookRef.getCommandStack());
        this.updateNames();
        this.createPages();
        this.installModelListener();
        this.firePropertyChange(258);
        this.firePropertyChange(257);
        this.setActivePage(editorStatus.getActiveIndex());
        IGraphicalEditorPage[] pages = this.getPages();
        int index = 0;
        while (index < pages.length) {
            org.eclipse.draw2d.geometry.Point scrollPosition;
            List topicTypeChain;
            Double scale;
            IGraphicalViewer viewer = pages[index].getViewer();
            viewer.getProperties().set("selectCentralTopic", (Object)Boolean.FALSE);
            Double d = scale = editorStatus.getZooms().size() > index ? editorStatus.getZooms().get(index) : null;
            if (scale != null) {
                viewer.getZoomManager().setScale(scale.doubleValue());
            }
            String indexPath = editorStatus.getIndexPaths().size() > index ? editorStatus.getIndexPaths().get(index) : "";
            List<Object> list = topicTypeChain = editorStatus.getTopicTypeChains().size() > index ? editorStatus.getTopicTypeChains().get(index) : Collections.emptyList();
            if (indexPath != null) {
                if ("".equals(indexPath)) {
                    viewer.setSelection((ISelection)StructuredSelection.EMPTY, true);
                } else {
                    Object input = viewer.getInput();
                    if (input instanceof IMindMap) {
                        ITopic topic = ((IMindMap)input).getCentralTopic();
                        String[] indexes = indexPath.split("/");
                        int i = 1;
                        while (i < indexes.length) {
                            String type;
                            String string = type = i < topicTypeChain.size() ? (String)topicTypeChain.get(i) : "attached";
                            if (topic.getChildren(type).size() > Integer.parseInt(indexes[i])) {
                                topic = (ITopic)topic.getChildren(type).get(Integer.parseInt(indexes[i]));
                            }
                            ++i;
                        }
                        viewer.setSelection((ISelection)new StructuredSelection((Object)topic), true);
                    }
                }
            }
            org.eclipse.draw2d.geometry.Point point = scrollPosition = editorStatus.getScrollPositions().size() > index ? editorStatus.getScrollPositions().get(index) : null;
            if (scrollPosition != null) {
                viewer.scrollTo(scrollPosition);
            }
            ++index;
        }
    }

    private boolean safeRun(final IProgressMonitor monitor, final boolean promptError, final IRunnableWithProgress runnable) {
        final boolean[] successful = new boolean[]{false};
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                if (monitor != null) {
                    runnable.run(monitor);
                } else {
                    IWorkbenchSiteProgressService context = (IWorkbenchSiteProgressService)MindMapEditor.this.getSite().getService(IWorkbenchSiteProgressService.class);
                    Assert.isTrue((context != null ? 1 : 0) != 0);
                    context.run(true, true, runnable);
                }
                successful[0] = true;
            }

            public void handleException(Throwable e) {
                Throwable cause;
                if (e instanceof InterruptedException) {
                    return;
                }
                if (e instanceof InvocationTargetException && (cause = ((InvocationTargetException)e).getTargetException()) != null) {
                    e = cause;
                }
                if (!promptError) {
                    Logger.log(e);
                    return;
                }
                super.handleException(e);
            }
        });
        return successful[0];
    }

    public boolean isSaveAsAllowed() {
        return this.getWorkbook() != null;
    }

    public int promptToSaveOnClose() {
        return 3;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.workbookRef) {
            this.workbookRefPropertyChange(event);
        }
    }

    protected void workbookRefPropertyChange(PropertyChangeEvent event) {
        if ("name".equals(event.getProperty()) || "description".equals(event.getProperty())) {
            this.runInUI(new Runnable(){

                @Override
                public void run() {
                    MindMapEditor.this.updateNames();
                }
            });
        } else if ("dirty".equals(event.getProperty())) {
            this.runInUI(new Runnable(){

                @Override
                public void run() {
                    MindMapEditor.this.firePropertyChange(257);
                }
            });
        } else if ("messages".equals(event.getProperty())) {
            this.runInUI(new Runnable(){

                @Override
                public void run() {
                    MindMapEditor.this.updateMessages(true);
                }
            });
        }
    }

    private void runInUI(Runnable runnable) {
        Composite control = this.pageContainer;
        if (control == null || control.isDisposed()) {
            return;
        }
        Display display = control.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(runnable);
    }

    public void handleCommandStackEvent(CommandStackEvent event) {
    }

    @Override
    public Properties generateMindMapPreview(IWorkbookRef workbookRef, final ISheet sheet, final OutputStream output, MindMapPreviewOptions options) throws IOException {
        Assert.isLegal((output != null ? 1 : 0) != 0);
        final Properties properties = new Properties();
        if (sheet == null || MindMapUIPlugin.getDefault().getPreferenceStore().getBoolean("previewSkipped") || this.skipNextPreviewImage) {
            URL url = BundleUtility.find((String)"org.xmind.ui", (String)"icons/misc/default_thumbnail.jpg");
            if (url != null) {
                InputStream input = url.openStream();
                try {
                    FileUtils.transfer((InputStream)input, (OutputStream)output, (boolean)false);
                }
                finally {
                    input.close();
                }
            }
            this.skipNextPreviewImage = false;
            return properties;
        }
        IEncryptable encryptable = (IEncryptable)workbookRef.getAdapter(IEncryptable.class);
        if (encryptable != null && encryptable.hasPassword()) {
            URL url = BundleUtility.find((String)"org.xmind.ui", (String)"icons/misc/encrypted_thumbnail.png");
            if (url != null) {
                InputStream input = url.openStream();
                try {
                    FileUtils.transfer((InputStream)input, (OutputStream)output, (boolean)false);
                }
                finally {
                    input.close();
                }
            }
            return properties;
        }
        Shell parentShell = this.getSite().getShell();
        Display display = parentShell.getDisplay();
        final MindMapImageExporter exporter = new MindMapImageExporter(display);
        final Exception[] error = new Exception[1];
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                IGraphicalEditorPage page = MindMapEditor.this.findPage(sheet);
                if (page == null && (page = MindMapEditor.this.getActivePageInstance()) == null) {
                    throw new IllegalArgumentException();
                }
                IGraphicalViewer sourceViewer = page.getViewer();
                MindMapViewerExportSourceProvider sourceProvider = new MindMapViewerExportSourceProvider(sourceViewer, 5);
                Rectangle sourceArea = sourceProvider.getSourceArea();
                int resizeWidth = Math.max(sourceArea.width % 21 == 0 ? sourceArea.width : sourceArea.width + 21 - sourceArea.width % 21, sourceArea.height % 13 == 0 ? sourceArea.height * 21 / 13 : (sourceArea.height + 13 - sourceArea.height % 13) * 21 / 13);
                if (resizeWidth < 420) {
                    resizeWidth = 420;
                } else if (resizeWidth > 1680) {
                    resizeWidth = 1680;
                }
                int resizeHeight = resizeWidth * 13 / 21;
                exporter.setSourceProvider(sourceProvider);
                exporter.setResize(1, resizeWidth, resizeHeight);
                exporter.setTargetStream(output);
                try {
                    exporter.export();
                }
                catch (SWTException e) {
                    error[0] = e;
                    return;
                }
                org.eclipse.draw2d.geometry.Point origin = exporter.calcRelativeOrigin();
                properties.put("Thumbnail/Origin/X", String.valueOf(origin.x));
                properties.put("Thumbnail/Origin/Y", String.valueOf(origin.y));
                properties.put("Thumbnail/BackgroundColor", exporter.getBackgroundColor());
            }
        });
        if (error[0] != null) {
            throw new IOException(error[0]);
        }
        return properties;
    }

    @Override
    public <T> T getContextVariable(Class<T> key) {
        return (T)this.getSite().getService(key);
    }

    @Override
    public Object getContextVariable(String key) {
        IEvaluationService service = (IEvaluationService)this.getSite().getService(IEvaluationService.class);
        Assert.isNotNull((Object)service);
        Object variable = service.getCurrentState().getVariable(key);
        return variable == IEvaluationContext.UNDEFINED_VARIABLE ? null : variable;
    }

    private void activateFileNotifier() {
        this.getEditorSite().getWorkbenchWindow().getWorkbench().addWindowListener(this.getWindowListener());
        this.getEditorSite().getPage().addSelectionListener(this.getEditorSite().getId(), this.getSelectionListener());
    }

    private void deactivateFileNotifier() {
        this.getEditorSite().getWorkbenchWindow().getWorkbench().removeWindowListener(this.getWindowListener());
        this.getEditorSite().getPage().removeSelectionListener(this.getEditorSite().getId(), this.getSelectionListener());
    }

    private IWindowListener getWindowListener() {
        if (this.windowListener == null) {
            this.windowListener = new IWindowListener(){

                public void windowOpened(IWorkbenchWindow window) {
                }

                public void windowDeactivated(IWorkbenchWindow window) {
                }

                public void windowClosed(IWorkbenchWindow window) {
                }

                public void windowActivated(IWorkbenchWindow window) {
                    IEditorPart activeEditor = MindMapEditor.this.getEditorSite().getPage().getActiveEditor();
                    if (activeEditor == MindMapEditor.this && MindMapEditor.this.workbookRef != null) {
                        MindMapEditor.this.workbookRef.activateNotifier();
                    }
                }
            };
        }
        return this.windowListener;
    }

    private ISelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.selectionListener = new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    if (MindMapEditor.this.workbookRef != null) {
                        MindMapEditor.this.workbookRef.activateNotifier();
                    }
                }
            };
        }
        return this.selectionListener;
    }

    @Override
    public void fileChanged(final String title, final String message, final String[] buttons) {
        if (this.workbookRef.getState() != 0) {
            return;
        }
        if (this.ignoreFileChanged) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MindMapEditor.this.deactivateFileNotifier();
                MindMapEditor.this.getEditorSite().getPage().activate((IWorkbenchPart)MindMapEditor.this);
                if (!MindMapEditor.this.isDirty()) {
                    MindMapEditor.this.reload();
                } else {
                    MessageDialog dialog = new MessageDialog(null, title, null, NLS.bind((String)(String.valueOf(MindMapMessages.MindMapEditor_fileChangedDialog_message_prefix) + message), (Object)MindMapEditor.this.workbookRef.getName()), 5, buttons, 0);
                    int code = dialog.open();
                    if (code == 0) {
                        MindMapEditor.this.reload();
                    } else if (code == 1 || code == -1) {
                        MindMapEditor.this.ignoreFileChanged = true;
                    }
                }
                MindMapEditor.this.activateFileNotifier();
            }
        });
    }

    @Override
    public void fileRemoved(final String title, final String message, final String[] buttons, boolean forceQuit) {
        if (this.workbookRef.getState() != 0) {
            return;
        }
        if (forceQuit) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MindMapEditor.this.closeEditor();
                }
            });
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MindMapEditor.this.deactivateFileNotifier();
                MindMapEditor.this.getEditorSite().getPage().activate((IWorkbenchPart)MindMapEditor.this);
                if (!MindMapEditor.this.isDirty()) {
                    MindMapEditor.this.closeEditor();
                } else {
                    MessageDialog dialog = new MessageDialog(null, title, null, NLS.bind((String)(String.valueOf(MindMapMessages.MindMapEditor_fileRemovedDialog_message_prefix) + message), (Object)MindMapEditor.this.workbookRef.getName()), 5, buttons, 0);
                    int code = dialog.open();
                    if (code == 0) {
                        MindMapEditor.this.doSaveAs();
                    } else if (code == 1 || code == -1) {
                        MindMapEditor.this.closeEditor();
                    }
                    MindMapEditor.this.activateFileNotifier();
                }
            }
        });
    }

    private static class EditorStatus {
        private static EditorStatus instance = null;
        private int activeIndex;
        private List<Double> zooms;
        private List<org.eclipse.draw2d.geometry.Point> scrollPositions;
        private List<String> indexPaths;
        private List<List<String>> topicTypeChains;

        private EditorStatus() {
        }

        public void saveStatus(IWorkbookRef workbookRef, int activeIndex, IGraphicalEditorPage[] pages) {
            IWorkbook workbook;
            this.init();
            if (workbookRef != null && (workbook = workbookRef.getWorkbook()) != null && pages != null && pages.length != 0) {
                this.activeIndex = activeIndex;
                IGraphicalEditorPage[] iGraphicalEditorPageArray = pages;
                int n = pages.length;
                int n2 = 0;
                while (n2 < n) {
                    Object focused;
                    IGraphicalEditorPage page = iGraphicalEditorPageArray[n2];
                    IGraphicalViewer viewer = page.getViewer();
                    if (this.zooms == null) {
                        this.zooms = new ArrayList<Double>();
                    }
                    double zoom = viewer.getZoomManager().getScale();
                    this.zooms.add(zoom);
                    if (this.scrollPositions == null) {
                        this.scrollPositions = new ArrayList<org.eclipse.draw2d.geometry.Point>();
                    }
                    org.eclipse.draw2d.geometry.Point scrollPosition = viewer.getScrollPosition();
                    this.scrollPositions.add(scrollPosition);
                    if (this.indexPaths == null) {
                        this.indexPaths = new ArrayList<String>();
                    }
                    if (this.topicTypeChains == null) {
                        this.topicTypeChains = new ArrayList<List<String>>();
                    }
                    if ((focused = viewer.getFocused()) == null || !(focused instanceof ITopic)) {
                        this.indexPaths.add("");
                        this.topicTypeChains.add(Collections.emptyList());
                    } else {
                        ArrayList<String> typeChain = new ArrayList<String>();
                        String indexPath = this.getTopicIndexPath((ITopic)focused, "", typeChain);
                        this.indexPaths.add(indexPath);
                        Collections.reverse(typeChain);
                        this.topicTypeChains.add(typeChain);
                    }
                    ++n2;
                }
            }
        }

        private void init() {
            this.activeIndex = 0;
            if (this.zooms != null) {
                this.zooms.clear();
            }
            if (this.scrollPositions != null) {
                this.scrollPositions.clear();
            }
            if (this.indexPaths != null) {
                this.indexPaths.clear();
            }
            if (this.topicTypeChains != null) {
                this.topicTypeChains.clear();
            }
        }

        private String getTopicIndexPath(ITopic topic, String path, List<String> typeChain) {
            path = String.valueOf(topic.getIndex()) + "/" + path;
            typeChain.add(topic.getType());
            if (topic.getParent() != null && topic.getParent() instanceof ITopic) {
                return this.getTopicIndexPath(topic.getParent(), path, typeChain);
            }
            return path;
        }

        public int getActiveIndex() {
            return this.activeIndex;
        }

        public List<Double> getZooms() {
            return this.zooms;
        }

        public List<org.eclipse.draw2d.geometry.Point> getScrollPositions() {
            return this.scrollPositions;
        }

        public List<String> getIndexPaths() {
            return this.indexPaths;
        }

        public List<List<String>> getTopicTypeChains() {
            return this.topicTypeChains;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static EditorStatus getInstance() {
            if (instance != null) return instance;
            Class<EditorStatus> clazz = EditorStatus.class;
            synchronized (EditorStatus.class) {
                if (instance != null) return instance;
                instance = new EditorStatus();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }
    }

    private class MindMapEditorSelectionProvider
    extends GraphicalEditor.MultiPageSelectionProvider {
        private MindMapEditorSelectionProvider() {
            super((GraphicalEditor)MindMapEditor.this);
        }

        public void setSelection(ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                for (Object element : ((IStructuredSelection)selection).toList()) {
                    if (element instanceof ITopicComponent) {
                        MindMapEditor.this.setSelectionAndUnfold(element);
                        continue;
                    }
                    if (!(element instanceof IRelationship)) continue;
                    IRelationship r = (IRelationship)element;
                    IRelationshipEnd e1 = r.getEnd1();
                    IRelationshipEnd e2 = r.getEnd2();
                    if (e1 instanceof ITopicComponent) {
                        MindMapEditor.this.setSelectionAndUnfold(e1);
                    }
                    if (!(e2 instanceof ITopicComponent)) continue;
                    MindMapEditor.this.setSelectionAndUnfold(e2);
                }
            }
            super.setSelection(selection);
        }
    }
}

