/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.commands;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.gef.ArraySourceProvider;
import org.xmind.gef.ISourceProvider;
import org.xmind.gef.command.SourceCommand;

public class AddSummaryCommand
extends SourceCommand {
    private ISourceProvider parentProvider;

    public AddSummaryCommand(ISummary summary, ITopic parent) {
        super((Object)summary);
        Assert.isNotNull((Object)parent);
        this.parentProvider = new ArraySourceProvider((Object)parent);
    }

    public AddSummaryCommand(ISourceProvider summaryProvider, ITopic parent) {
        super(summaryProvider);
        Assert.isNotNull((Object)parent);
        this.parentProvider = new ArraySourceProvider((Object)parent);
    }

    public AddSummaryCommand(ISourceProvider summaryProvider, ISourceProvider parentProvider) {
        super(summaryProvider);
        Assert.isNotNull((Object)parentProvider);
        this.parentProvider = parentProvider;
    }

    public void redo() {
        Object p = this.parentProvider.getSource();
        if (p instanceof ITopic) {
            ITopic parent = (ITopic)p;
            for (Object source : this.getSources()) {
                if (!(source instanceof ISummary)) continue;
                parent.addSummary((ISummary)source);
            }
        }
        super.redo();
    }

    public void undo() {
        Object p = this.parentProvider.getSource();
        if (p instanceof ITopic) {
            ITopic parent = (ITopic)p;
            List sources = this.getSources();
            int i = sources.size() - 1;
            while (i >= 0) {
                Object source = sources.get(i);
                if (source instanceof ISummary) {
                    parent.removeSummary((ISummary)source);
                }
                --i;
            }
        }
        super.undo();
    }
}

