/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.taskinfo;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.xmind.verify.ui.VerifyUI20141031;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.IWorkbook;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.command.ModifyCommand;
import org.xmind.ui.commands.AddMarkerCommand;
import org.xmind.ui.commands.DeleteMarkerCommand;
import org.xmind.ui.internal.taskinfo.DateInfo;
import org.xmind.ui.internal.taskinfo.Dependency;
import org.xmind.ui.internal.taskinfo.DurationInfo;
import org.xmind.ui.internal.taskinfo.TaskMessages;
import org.xmind.ui.internal.taskinfo.commands.AddDependencyCommand;
import org.xmind.ui.internal.taskinfo.commands.ModifyAssignCommand;
import org.xmind.ui.internal.taskinfo.commands.ModifyCheckPointCommand;
import org.xmind.ui.internal.taskinfo.commands.ModifyDependencyPredecessorCommand;
import org.xmind.ui.internal.taskinfo.commands.ModifyDependencyTypeCommand;
import org.xmind.ui.internal.taskinfo.commands.ModifyDurationCommand;
import org.xmind.ui.internal.taskinfo.commands.ModifyEndDateCommand;
import org.xmind.ui.internal.taskinfo.commands.ModifyProgressCommand;
import org.xmind.ui.internal.taskinfo.commands.ModifyStartDateCommand;
import org.xmind.ui.internal.taskinfo.commands.RemoveDependencyCommand;
import org.xmind.ui.mindmap.MindMapUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskInfoUtils {
    private static DateFormat dateFormat = null;

    public static String format(Calendar date) {
        return TaskInfoUtils.format(date, true);
    }

    public static String format(DateInfo date) {
        return date == null ? null : TaskInfoUtils.format(date.date, date.allDay);
    }

    public static String format(Calendar date, boolean allDay) {
        return allDay ? String.format("%1$tY-%1$tm-%1$td", date) : String.format("%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS", date);
    }

    public static String formatDate(Calendar date) {
        return String.format("%1$ta, %1$tb %1$te, %1$tY", date);
    }

    public static String formatDateAndTime(Calendar date) {
        return String.format("%1$ta, %1$tb %1$te, %1$tY  %1$tI:%1$tM %1$Tp", date);
    }

    public static String formatTime(Calendar date) {
        return String.format("%1$tH:%1$tM:%1$tS", date);
    }

    public static String formatAll(Calendar date, boolean allDay) {
        if (!allDay) {
            return TaskInfoUtils.formatDate(date);
        }
        return String.format("%1$ta %1$tb %1$te, %1$tY %1$tH:%1$tM:%1$tS", date);
    }

    public static Calendar toDate(String formatted) {
        DateInfo dateInfo = TaskInfoUtils.toDateInfo(formatted);
        return dateInfo == null ? null : dateInfo.date;
    }

    public static DateInfo toDateInfo(String formatted) {
        if (formatted == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("(\\d+)-(\\d{1,2})-(\\d{1,2})( (\\d{1,2}):(\\d{1,2}):(\\d{1,2}))?");
        Matcher m = pattern.matcher(formatted);
        if (m.find()) {
            DateInfo info = new DateInfo();
            info.date.set(1, Integer.parseInt(m.group(1)));
            info.date.set(2, Integer.parseInt(m.group(2)) - 1);
            info.date.set(5, Integer.parseInt(m.group(3)));
            boolean bl = info.allDay = m.group(4) == null;
            if (!info.allDay) {
                info.date.set(11, Integer.parseInt(m.group(5)));
                info.date.set(12, Integer.parseInt(m.group(6)));
                info.date.set(13, Integer.parseInt(m.group(7)));
            } else {
                info.date.set(11, 0);
                info.date.set(12, 0);
                info.date.set(13, 0);
            }
            return info;
        }
        try {
            Date date = TaskInfoUtils.getDateFormat().parse(formatted);
            DateInfo info = new DateInfo();
            info.date.setTime(date);
            info.allDay = false;
            return info;
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static DateFormat getDateFormat() {
        if (dateFormat == null) {
            dateFormat = DateFormat.getDateTimeInstance(2, 3);
        }
        return dateFormat;
    }

    public static ITopicExtension getExtension(ITopic topic) {
        if (topic == null) {
            return null;
        }
        return topic.getExtension("org.xmind.ui.taskInfo");
    }

    public static ITopicExtensionElement getContent(ITopic topic) {
        ITopicExtension ext = TaskInfoUtils.getExtension(topic);
        if (ext == null) {
            return null;
        }
        return ext.getContent();
    }

    private static ITopicExtensionElement getElement(ITopic topic, String tag) {
        ITopicExtensionElement content = TaskInfoUtils.getContent(topic);
        if (content == null) {
            return null;
        }
        List children = content.getChildren(tag);
        if (children.isEmpty()) {
            return null;
        }
        return (ITopicExtensionElement)children.get(0);
    }

    public static String getContent(ITopic topic, String tag) {
        ITopicExtensionElement element = TaskInfoUtils.getElement(topic, tag);
        if (element == null) {
            return null;
        }
        return element.getTextContent();
    }

    public static DateInfo getStartDateInfo(ITopic topic) {
        String content = TaskInfoUtils.getContent(topic, "start-date");
        return content == null ? null : TaskInfoUtils.toDateInfo(content);
    }

    public static DateInfo getEndDateInfo(ITopic topic) {
        String content = TaskInfoUtils.getContent(topic, "end-date");
        return content == null ? null : TaskInfoUtils.toDateInfo(content);
    }

    public static DurationInfo getDurationInfo(ITopic topic) {
        String content = TaskInfoUtils.getContent(topic, "duration");
        return content == null ? null : DurationInfo.parseDuration(content);
    }

    public static List<Dependency> getDependencies(ITopic topic) {
        ArrayList<Dependency> predecessors = new ArrayList<Dependency>();
        ITopicExtensionElement element = TaskInfoUtils.getElement(topic, "predecessors");
        if (element != null) {
            List children = element.getChildren("predecessor");
            for (ITopicExtensionElement child : children) {
                predecessors.add(Dependency.getInstance(child));
            }
        }
        return predecessors;
    }

    public static DateInfo calculateStartDateInfo(ITopic topic) {
        return TaskInfoUtils.calculateStartDateInfo(topic, new HashSet<ITopic>());
    }

    public static DateInfo calculateEndDateInfo(ITopic topic) {
        return TaskInfoUtils.calculateEndDateInfo(topic, new HashSet<ITopic>());
    }

    private static DateInfo calculateStartDateInfo(ITopic topic, Set<ITopic> checkedTopics) {
        DateInfo date = TaskInfoUtils.getStartDateInfo(topic);
        if ((date = TaskInfoUtils.calcDependentStartDateInfo(topic, checkedTopics, date)) != null && topic != null) {
            return date;
        }
        DateInfo endDate = TaskInfoUtils.getEndDateInfo(topic);
        if ((endDate = TaskInfoUtils.calcDependentEndDateInfo(topic, checkedTopics, endDate)) != null) {
            if (TaskInfoUtils.getCheckPoint(topic)) {
                return endDate;
            }
            DurationInfo duration = TaskInfoUtils.getDurationInfo(topic);
            if (duration == null) {
                duration = DurationInfo.DEFAULT;
            }
            return new DateInfo(endDate.date, endDate.allDay).remove(duration);
        }
        return null;
    }

    private static DateInfo calculateEndDateInfo(ITopic topic, Set<ITopic> checkedTopics) {
        DateInfo startDate = TaskInfoUtils.calculateStartDateInfo(topic, checkedTopics);
        if (TaskInfoUtils.getCheckPoint(topic) && startDate != null) {
            return startDate;
        }
        DurationInfo duration = TaskInfoUtils.getDurationInfo(topic);
        if (duration != null && startDate != null) {
            DateInfo date = new DateInfo(startDate.date, startDate.allDay).add(duration);
            return TaskInfoUtils.calcDependentEndDateInfo(topic, checkedTopics, date);
        }
        DateInfo date = TaskInfoUtils.getEndDateInfo(topic);
        date = TaskInfoUtils.calcDependentEndDateInfo(topic, checkedTopics, date);
        if (startDate != null && (date == null || startDate.date.after(date.date))) {
            if (duration == null) {
                duration = DurationInfo.DEFAULT;
            }
            date = startDate.add(duration);
        }
        return date;
    }

    private static DateInfo calcDependentStartDateInfo(ITopic topic, Set<ITopic> checkedTopics, DateInfo userDate) {
        checkedTopics.add(topic);
        for (Dependency dependency : TaskInfoUtils.getDependencies(topic)) {
            String type = dependency.getType();
            ITopic predecessor = dependency.getPredecessor();
            if (predecessor == null || checkedTopics.contains(predecessor)) continue;
            DateInfo date2 = null;
            if ("FS".equals(type)) {
                date2 = TaskInfoUtils.calculateEndDateInfo(predecessor, checkedTopics);
            } else if ("SS".equals(type)) {
                date2 = TaskInfoUtils.calculateStartDateInfo(predecessor, checkedTopics);
            }
            userDate = TaskInfoUtils.latter(userDate, date2);
        }
        checkedTopics.remove(topic);
        return userDate;
    }

    private static DateInfo calcDependentEndDateInfo(ITopic topic, Set<ITopic> checkedTopics, DateInfo userDate) {
        checkedTopics.add(topic);
        for (Dependency dependency : TaskInfoUtils.getDependencies(topic)) {
            String type = dependency.getType();
            ITopic predecessor = dependency.getPredecessor();
            if (predecessor == null || checkedTopics.contains(predecessor)) continue;
            DateInfo date2 = null;
            if ("SF".equals(type)) {
                date2 = TaskInfoUtils.calculateStartDateInfo(predecessor, checkedTopics);
            } else if ("FF".equals(type)) {
                date2 = TaskInfoUtils.calculateEndDateInfo(predecessor, checkedTopics);
            }
            userDate = TaskInfoUtils.latter(userDate, date2);
        }
        checkedTopics.remove(topic);
        return userDate;
    }

    private static DateInfo latter(DateInfo d1, DateInfo d2) {
        if (d1 == null) {
            return d2;
        }
        if (d2 == null) {
            return d1;
        }
        if (d2.date.after(d1.date)) {
            return d2;
        }
        return d1;
    }

    public static DurationInfo calculateDuration(ITopic topic) {
        DurationInfo duration = TaskInfoUtils.getDurationInfo(topic);
        DateInfo startDate = TaskInfoUtils.calculateStartDateInfo(topic);
        DateInfo endDate = TaskInfoUtils.calculateEndDateInfo(topic);
        if (startDate != null && endDate != null) {
            DurationInfo duration2 = DurationInfo.calcDuration(startDate, endDate);
            if (duration == null || duration2.compareTo(duration) != 0) {
                duration = duration2;
            }
        } else if (duration == null) {
            duration = DurationInfo.DEFAULT;
        }
        return duration;
    }

    public static DurationInfo calculateDurationExcludeWeekends(ITopic topic) {
        DurationInfo duration = TaskInfoUtils.getDurationInfo(topic);
        DateInfo startDate = TaskInfoUtils.calculateStartDateInfo(topic);
        DateInfo endDate = TaskInfoUtils.calculateEndDateInfo(topic);
        if (topic != null && endDate != null) {
            VerifyUI20141031.getUsageDataCollector().put(String.format("Task/startTime/%s", topic.getId()), endDate.date != null ? endDate.date.getTimeInMillis() : -1L);
        }
        if (topic != null && startDate != null) {
            VerifyUI20141031.getUsageDataCollector().put(String.format("Task/endTime/%s", topic.getId()), startDate.date != null ? startDate.date.getTimeInMillis() : -1L);
        }
        if (startDate != null && endDate != null) {
            DurationInfo duration2 = DurationInfo.calcDurationExcludeWeekends(startDate, endDate);
            if (duration == null || duration2.compareTo(duration) != 0) {
                duration = duration2;
            }
        } else if (duration == null) {
            duration = DurationInfo.DEFAULT;
        }
        return duration;
    }

    public static boolean getCheckPoint(ITopic topic) {
        ITopicExtensionElement content = TaskInfoUtils.getContent(topic);
        if (content != null) {
            return Boolean.parseBoolean(content.getAttribute("check-point"));
        }
        return false;
    }

    public static int getProgress(ITopic topic) {
        String content = TaskInfoUtils.getContent(topic, "progress");
        if (content != null) {
            try {
                return Integer.parseInt(content);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0;
    }

    public static int calculateProgress(ITopic topic) {
        IMarker marker = TaskInfoUtils.findMarker(topic, "taskMakers");
        if (marker == null) {
            return -1;
        }
        int percentage = TaskInfoUtils.getProgress(topic);
        IMarker percentageMarker = TaskInfoUtils.findPercentageMarker(percentage, true);
        if (!marker.getId().equals(percentageMarker.getId())) {
            return TaskInfoUtils.getPercentage(marker.getId());
        }
        return Math.min(Math.max(percentage, 0), 100);
    }

    public static void changeAssigned(ITopic topic, ICommandStack commandStack, String value) {
        if (commandStack == null || topic == null) {
            return;
        }
        Command command = TaskInfoUtils.createChangeAssignCommand(topic, value);
        commandStack.execute(command);
    }

    public static Command createChangeAssignCommand(ITopic topic, String value) {
        return new ModifyAssignCommand(topic, value);
    }

    public static void changeProgress(ITopic topic, ICommandStack commandStack, int value, IMarker marker) {
        if (commandStack == null || topic == null) {
            return;
        }
        CompoundCommand command = TaskInfoUtils.createChangeProgressCommand(topic, value, marker);
        commandStack.execute((Command)command);
    }

    public static CompoundCommand createChangeProgressCommand(ITopic topic, int value, IMarker marker) {
        ModifyProgressCommand modifyProgress = new ModifyProgressCommand(topic, value);
        Command replaceProgressMarker = TaskInfoUtils.createReplaceMarkerCommand(topic, marker);
        CompoundCommand command = new CompoundCommand(new Command[]{modifyProgress, replaceProgressMarker});
        command.setLabel(modifyProgress.getLabel());
        return command;
    }

    public static void deleteProgress(ITopic topic, ICommandStack commandStack) {
        if (commandStack == null || topic == null) {
            return;
        }
        Command command = TaskInfoUtils.createDeleteProgressCommand(topic);
        commandStack.execute(command);
    }

    public static Command createDeleteProgressCommand(ITopic topic) {
        ModifyProgressCommand command;
        ModifyProgressCommand modifyProgress = new ModifyProgressCommand(topic, -1);
        Command deleteProgressMarkers = TaskInfoUtils.createDeleteMarkersCommand(topic, "taskMakers");
        if (deleteProgressMarkers != null) {
            command = new CompoundCommand(new Command[]{modifyProgress, deleteProgressMarkers});
            command.setLabel(modifyProgress.getLabel());
        } else {
            command = modifyProgress;
        }
        return command;
    }

    public static Command createReplaceMarkerCommand(ITopic topic, IMarker marker) {
        AddMarkerCommand command = new AddMarkerCommand(topic, marker.getId());
        ArrayList<Object> list = new ArrayList<Object>();
        for (IMarker m : marker.getParent().getMarkers()) {
            String markerId = m.getId();
            if (!topic.hasMarker(markerId)) continue;
            list.add(new DeleteMarkerCommand(topic, markerId));
        }
        if (list.isEmpty()) {
            return command;
        }
        list.add(command);
        return new CompoundCommand(list);
    }

    public static Command createDeleteMarkersCommand(ITopic topic, String groupId) {
        ArrayList<DeleteMarkerCommand> list = new ArrayList<DeleteMarkerCommand>();
        for (IMarkerRef mr : topic.getMarkerRefs()) {
            IMarkerGroup group;
            IMarker marker = mr.getMarker();
            if (marker == null || (group = marker.getParent()) == null || !groupId.equals(group.getId())) continue;
            list.add(new DeleteMarkerCommand(topic, mr.getMarkerId()));
        }
        return list.isEmpty() ? null : new CompoundCommand(list);
    }

    public static void changeCheckPoint(ITopic topic, ICommandStack commandStack, boolean value) {
        if (commandStack == null || topic == null) {
            return;
        }
        commandStack.execute(TaskInfoUtils.createChangeCheckPointCommand(topic, value));
    }

    public static Command createChangeCheckPointCommand(ITopic topic, boolean value) {
        return new ModifyCheckPointCommand(topic, value);
    }

    public static void changeStartDate(ITopic topic, ICommandStack commandStack, DateInfo date) {
        CompoundCommand cc = new CompoundCommand(new ArrayList());
        int deltaNotFullWeekendsHours = 0;
        DateInfo startDate = TaskInfoUtils.calculateStartDateInfo(topic);
        if (startDate == null && date != null) {
            Calendar start = Calendar.getInstance();
            start.setTimeInMillis(date.date.getTimeInMillis());
            int startDayOfWeek = start.get(7);
            if (startDayOfWeek == 7 || startDayOfWeek == 1) {
                Calendar start2 = Calendar.getInstance();
                start2.set(start.get(1), start.get(2), start.get(5), 0, 0, 0);
                start2.getTime();
                start2.set(7, 2);
                if (start2.before(start)) {
                    start2.add(3, 1);
                }
                deltaNotFullWeekendsHours = (int)((start2.getTimeInMillis() - start.getTimeInMillis()) / 1000L / 3600L);
                start.setTimeInMillis(start2.getTimeInMillis());
            }
            Calendar saturday = Calendar.getInstance();
            saturday.set(start.get(1), start.get(2), start.get(5), 0, 0, 0);
            saturday.getTime();
            saturday.set(7, 7);
            if (saturday.before(start)) {
                saturday.add(3, 1);
            }
            int deltaHours = (int)((saturday.getTimeInMillis() - start.getTimeInMillis()) / 1000L / 3600L);
            int n = (int)((saturday.getTimeInMillis() - start.getTimeInMillis()) / 1000L % 3600L) == 0 ? 0 : 1;
            DurationInfo durationInfo = TaskInfoUtils.calculateDuration(topic);
            int totalHours = durationInfo.getTotalHours();
            int weeks = 0;
            totalHours -= (deltaHours += n);
            while (totalHours > 0) {
                ++weeks;
                totalHours -= 120;
            }
            int days = durationInfo.getDays() + weeks * 2;
            int hours = durationInfo.getHours() + deltaNotFullWeekendsHours;
            while (hours > 23) {
                hours -= 24;
                ++days;
            }
            while (hours < 0) {
                hours += 24;
                --days;
            }
            DurationInfo newDurationInfo = new DurationInfo(days, hours);
            Command changeDurationCommand = TaskInfoUtils.createChangeDurationCommand(topic, newDurationInfo);
            cc.append(changeDurationCommand);
        }
        if (TaskInfoUtils.getStartDate(topic) != null && date == null) {
            for (Dependency dependency : TaskInfoUtils.getDependencies(topic)) {
                cc.append(TaskInfoUtils.createRemoveDependencyCommand(dependency));
            }
        }
        TaskInfoUtils.checkDuration(topic, false);
        Command command = TaskInfoUtils.createChangeStartDateCommand(topic, date);
        cc.append(command);
        commandStack.execute((Command)cc);
    }

    public static Command createChangeStartDateCommand(ITopic topic, DateInfo date) {
        String string = date == null ? null : TaskInfoUtils.format(date);
        return new ModifyStartDateCommand(topic, string);
    }

    public static void changeEndDate(ITopic topic, ICommandStack commandStack, DateInfo date) {
        CompoundCommand cc = new CompoundCommand(new Command[0]);
        if (TaskInfoUtils.getEndDate(topic) != null && date == null) {
            for (Dependency dependency : TaskInfoUtils.getDependencies(topic)) {
                cc.append(TaskInfoUtils.createRemoveDependencyCommand(dependency));
            }
        }
        TaskInfoUtils.checkDuration(topic, false);
        cc.append(TaskInfoUtils.createChangeEndDateCommand(topic, date));
        commandStack.execute((Command)cc);
    }

    public static Command createChangeEndDateCommand(ITopic topic, DateInfo date) {
        String string = date == null ? null : TaskInfoUtils.format(date);
        return new ModifyEndDateCommand(topic, string);
    }

    public static void changePriorityMarker(ITopic topic, ICommandStack commandStack, IMarker marker) {
        if (commandStack == null || topic == null) {
            return;
        }
        Command command = TaskInfoUtils.createChangePriorityCommand(topic, marker);
        if (command != null) {
            commandStack.execute(command);
        }
    }

    public static Command createChangePriorityCommand(ITopic topic, IMarker marker) {
        Command command;
        if (marker == null) {
            command = TaskInfoUtils.createDeleteMarkersCommand(topic, "priorityMarkers");
            if (command != null) {
                command.setLabel(TaskMessages.Command_ModifyPriority);
            }
        } else {
            command = TaskInfoUtils.createReplaceMarkerCommand(topic, marker);
            if (command != null) {
                command.setLabel(TaskMessages.Command_ModifyPriority);
            }
        }
        return command;
    }

    public static Command createClearTaskInfoCommand(ITopic topic) {
        Command deleteCheckPoint;
        Command deleteProgress;
        Command deleteEndDate;
        Command deleteDuringDate;
        Command deleteStartDate;
        Command deletePriority;
        if (topic == null) {
            return null;
        }
        if (TaskInfoUtils.isAllTaskInfosClean(topic)) {
            return null;
        }
        ArrayList<Command> commands = new ArrayList<Command>();
        Command deleteAssign = TaskInfoUtils.createChangeAssignCommand(topic, null);
        if (deleteAssign != null) {
            commands.add(deleteAssign);
        }
        if ((deletePriority = TaskInfoUtils.createChangePriorityCommand(topic, null)) != null) {
            commands.add(deletePriority);
        }
        if ((deleteStartDate = TaskInfoUtils.createChangeStartDateCommand(topic, null)) != null) {
            commands.add(deleteStartDate);
        }
        if ((deleteDuringDate = TaskInfoUtils.createChangeDurationCommand(topic, null)) != null) {
            commands.add(deleteDuringDate);
        }
        if ((deleteEndDate = TaskInfoUtils.createChangeEndDateCommand(topic, null)) != null) {
            commands.add(deleteEndDate);
        }
        if ((deleteProgress = TaskInfoUtils.createDeleteProgressCommand(topic)) != null) {
            commands.add(deleteProgress);
        }
        if ((deleteCheckPoint = TaskInfoUtils.createChangeCheckPointCommand(topic, false)) != null) {
            commands.add(deleteCheckPoint);
        }
        for (Dependency dependency : TaskInfoUtils.getDependencies(topic)) {
            commands.add(TaskInfoUtils.createRemoveDependencyCommand(dependency));
        }
        if (commands.isEmpty()) {
            return null;
        }
        CompoundCommand command = new CompoundCommand(commands);
        command.setLabel(TaskMessages.Command_ClearTaskInfo);
        return command;
    }

    public static boolean isAllTaskInfosClean(ITopic topic) {
        if (topic == null) {
            return false;
        }
        if (TaskInfoUtils.getAssignee(topic) != null) {
            return false;
        }
        if (TaskInfoUtils.getPriority(topic) != null) {
            return false;
        }
        if (TaskInfoUtils.getStartDateInfo(topic) != null) {
            return false;
        }
        if (TaskInfoUtils.getDurationInfo(topic) != null) {
            return false;
        }
        if (TaskInfoUtils.getEndDateInfo(topic) != null) {
            return false;
        }
        if (TaskInfoUtils.hasProgress(topic)) {
            return false;
        }
        if (TaskInfoUtils.getCheckPoint(topic)) {
            return false;
        }
        return TaskInfoUtils.getDependencies(topic).size() == 0;
    }

    private static String getAssignee(ITopic topic) {
        return TaskInfoUtils.getContent(topic, "assigned-to");
    }

    private static String getPriority(ITopic topic) {
        IMarker marker = TaskInfoUtils.findMarker(topic, "priorityMarkers");
        return marker == null ? null : marker.getName();
    }

    private static boolean hasProgress(ITopic topic) {
        if (topic == null) {
            return false;
        }
        if (TaskInfoUtils.getProgress(topic) != 0) {
            return true;
        }
        IMarker marker = TaskInfoUtils.findMarker(topic, "taskMakers");
        return marker != null;
    }

    public static void clearTaskInfo(ITopic topic, ICommandStack commandStack) {
        if (commandStack == null || topic == null) {
            return;
        }
        Command command = TaskInfoUtils.createClearTaskInfoCommand(topic);
        if (command != null) {
            commandStack.execute(command);
        }
    }

    public static void clearTaskInfos(List<ITopic> topics, ICommandStack commandStack) {
        if (commandStack == null || topics == null || topics.size() == 0) {
            return;
        }
        ArrayList<Command> commands = new ArrayList<Command>();
        for (ITopic topic : topics) {
            Command command;
            if (topic == null || (command = TaskInfoUtils.createClearTaskInfoCommand(topic)) == null) continue;
            commands.add(command);
        }
        if (commands.size() != 0) {
            CompoundCommand cc = new CompoundCommand(TaskMessages.Command_ClearTaskInfo, commands);
            commandStack.execute((Command)cc);
        }
    }

    public static Command createAddDependencyCommand(ITopic topic, ITopic predecessor, String type) {
        return new AddDependencyCommand(topic, predecessor, type);
    }

    public static Command createRemoveDependencyCommand(Dependency dependency) {
        return new RemoveDependencyCommand(dependency);
    }

    public static Command createChangeDependencyCommand(Dependency dependency, ITopic predecessor, String type) {
        ArrayList<ModifyCommand> commands = new ArrayList<ModifyCommand>(2);
        if (predecessor != null) {
            commands.add(new ModifyDependencyPredecessorCommand(dependency, predecessor.getId()));
        }
        if (type != null) {
            commands.add(new ModifyDependencyTypeCommand(dependency, type));
        }
        if (commands.isEmpty()) {
            return new Command(TaskMessages.Command_ChangeDependency);
        }
        CompoundCommand command = commands.size() == 1 ? (Command)commands.get(0) : new CompoundCommand(TaskMessages.Command_ChangeDependency, commands);
        return command;
    }

    public static void addDependency(ITopic topic, ITopic predecessor, String type, ICommandStack commandStack) {
        if (commandStack == null || topic == null || predecessor == null) {
            return;
        }
        if (type == null) {
            type = "FS";
        }
        commandStack.execute((Command)new AddDependencyCommand(topic, predecessor, type));
        VerifyUI20141031.getUsageDataCollector().increase("AddPredecessorCount");
    }

    public static void removeDependency(Dependency dependency, ICommandStack commandStack) {
        if (commandStack == null || dependency == null) {
            return;
        }
        commandStack.execute((Command)new RemoveDependencyCommand(dependency));
        VerifyUI20141031.getUsageDataCollector().increase("RemovePredecessorCount");
    }

    public static void changeDependency(Dependency dependency, ITopic predecessor, String type, ICommandStack commandStack) {
        if (commandStack == null || dependency == null) {
            return;
        }
        commandStack.execute(TaskInfoUtils.createChangeDependencyCommand(dependency, predecessor, type));
        VerifyUI20141031.getUsageDataCollector().increase("ChangePredecessorCount");
    }

    public static IMarker findMarker(ITopic topic, String targetGroupId) {
        if (topic != null) {
            for (IMarkerRef mr : topic.getMarkerRefs()) {
                String groupId;
                IMarkerGroup group;
                IMarker marker;
                if ("task-pause".equals(mr.getMarkerId()) || (marker = mr.getMarker()) == null || (group = marker.getParent()) == null || !targetGroupId.equals(groupId = group.getId())) continue;
                return marker;
            }
        }
        return null;
    }

    public static Set<String> loadAllAssignees(IWorkbook workbook) {
        TreeSet<String> assignees = new TreeSet<String>();
        List sheets = workbook.getSheets();
        for (ISheet sheet : sheets) {
            ITopic rootTopic = sheet.getRootTopic();
            TaskInfoUtils.loadAssigneesInTopic(assignees, rootTopic);
        }
        return assignees;
    }

    private static void loadAssigneesInTopic(Set<String> assignees, ITopic topic) {
        List children;
        String content = TaskInfoUtils.getContent(topic, "assigned-to");
        if (content != null) {
            assignees.add(content);
        }
        if (!(children = topic.getAllChildren()).isEmpty()) {
            for (ITopic child : children) {
                TaskInfoUtils.loadAssigneesInTopic(assignees, child);
            }
        }
    }

    public static String formatDate(Date date) {
        if (date == null) {
            return null;
        }
        return TaskInfoUtils.getDateFormat().format(date);
    }

    public static Date parseDate(String string) {
        if (string == null) {
            return null;
        }
        try {
            return TaskInfoUtils.getDateFormat().parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static Date getStartDate(ITopic topic) {
        return TaskInfoUtils.toDateObj(TaskInfoUtils.getStartDateInfo(topic));
    }

    public static Date getEndDate(ITopic topic) {
        return TaskInfoUtils.toDateObj(TaskInfoUtils.getEndDateInfo(topic));
    }

    private static Date toDateObj(DateInfo dateInfo) {
        if (dateInfo == null) {
            return null;
        }
        if (dateInfo.allDay) {
            dateInfo.setTime(0, 0, 0);
        }
        return dateInfo.date.getTime();
    }

    public static void changeStartDate(ITopic topic, ICommandStack commandStack, Date date) {
        if (commandStack == null || topic == null) {
            return;
        }
        Command command = TaskInfoUtils.createChangeStartDateCommand(topic, date);
        commandStack.execute(command);
    }

    public static Command createChangeStartDateCommand(ITopic topic, Date date) {
        String string = date == null ? null : TaskInfoUtils.formatDate(date);
        ModifyStartDateCommand command = new ModifyStartDateCommand(topic, string);
        return command;
    }

    public static void changeEndDate(ITopic topic, ICommandStack commandStack, Date date) {
        if (commandStack == null || topic == null) {
            return;
        }
        Command command = TaskInfoUtils.createChangeEndDateCommand(topic, date);
        commandStack.execute(command);
    }

    public static Command createChangeEndDateCommand(ITopic topic, Date date) {
        String string = date == null ? null : TaskInfoUtils.formatDate(date);
        ModifyEndDateCommand command = new ModifyEndDateCommand(topic, string);
        return command;
    }

    public static boolean isCircularDependencies(ITopic successor, ITopic predecessor) {
        return TaskInfoUtils.checkCircularDependencies(successor, predecessor, new HashSet<ITopic>());
    }

    private static boolean checkCircularDependencies(ITopic successor, ITopic predecessor, Set<ITopic> testedPredecessors) {
        for (Dependency dependency : TaskInfoUtils.getDependencies(predecessor)) {
            ITopic nextPredecessor = dependency.getPredecessor();
            if (nextPredecessor == null) continue;
            if (nextPredecessor == successor) {
                return true;
            }
            if (testedPredecessors.contains(nextPredecessor)) continue;
            testedPredecessors.add(nextPredecessor);
            if (TaskInfoUtils.checkCircularDependencies(successor, nextPredecessor, testedPredecessors)) {
                return true;
            }
            testedPredecessors.remove(nextPredecessor);
        }
        return false;
    }

    public static IMarker findPercentageMarker(int percentage, boolean ranged) {
        String markerId = TaskInfoUtils.getPercentageMarkerId(percentage, ranged);
        if (markerId != null) {
            return MindMapUI.getResourceManager().getSystemMarkerSheet().findMarker(markerId);
        }
        return null;
    }

    public static String getPercentageMarkerId(int percentage, boolean ranged) {
        if (percentage < 0) {
            return null;
        }
        if (ranged ? percentage < 13 : percentage == 0) {
            return "task-start";
        }
        if (ranged ? percentage < 25 : percentage == 13) {
            return "task-oct";
        }
        if (ranged ? percentage < 38 : percentage == 25) {
            return "task-quarter";
        }
        if (ranged ? percentage < 50 : percentage == 38) {
            return "task-3oct";
        }
        if (ranged ? percentage < 63 : percentage == 50) {
            return "task-half";
        }
        if (ranged ? percentage < 75 : percentage == 63) {
            return "task-5oct";
        }
        if (ranged ? percentage < 88 : percentage == 75) {
            return "task-3quar";
        }
        if (ranged ? percentage < 100 : percentage == 88) {
            return "task-7oct";
        }
        if (ranged ? percentage >= 100 : percentage == 100) {
            return "task-done";
        }
        return null;
    }

    public static int getPercentage(String markerId) {
        if ("task-start".equals(markerId)) {
            return 0;
        }
        if ("task-oct".equals(markerId)) {
            return 13;
        }
        if ("task-quarter".equals(markerId)) {
            return 25;
        }
        if ("task-3oct".equals(markerId)) {
            return 38;
        }
        if ("task-half".equals(markerId)) {
            return 50;
        }
        if ("task-5oct".equals(markerId)) {
            return 63;
        }
        if ("task-3quar".equals(markerId)) {
            return 75;
        }
        if ("task-7oct".equals(markerId)) {
            return 88;
        }
        if ("task-done".equals(markerId)) {
            return 100;
        }
        return -1;
    }

    public static void changeDuration(ITopic task, ICommandStack commandStack, DurationInfo duration) {
        TaskInfoUtils.checkDuration(task, true);
        if (commandStack == null || task == null) {
            return;
        }
        Command command = TaskInfoUtils.createChangeDurationCommand(task, duration);
        if (command != null) {
            commandStack.execute(command);
        }
    }

    public static Command createChangeDurationCommand(ITopic task, DurationInfo duration) {
        if (duration == null) {
            return ModifyDurationCommand.createRemoveDurationCommand(task);
        }
        return new ModifyDurationCommand(task, duration);
    }

    public static void checkDuration(ITopic topic, boolean active) {
        if (TaskInfoUtils.getStartDateInfo(topic) != null && TaskInfoUtils.getEndDateInfo(topic) != null && TaskInfoUtils.getDurationInfo(topic) != null) {
            TaskInfoUtils.changeDurationActive(topic, ICommandStack.NULL, active);
        }
    }

    public static void changeDurationActive(ITopic task, ICommandStack commandStack, boolean active) {
        CompoundCommand command;
        if (task == null || commandStack == null) {
            return;
        }
        if (active) {
            DurationInfo duration = TaskInfoUtils.calculateDuration(task);
            ArrayList<Command> commands = new ArrayList<Command>(2);
            commands.add(TaskInfoUtils.createChangeDurationCommand(task, duration));
            commands.add(TaskInfoUtils.createChangeEndDateCommand(task, null));
            command = new CompoundCommand(TaskMessages.ActivateDurationCommand_label, commands);
        } else {
            DateInfo endDate = TaskInfoUtils.calculateEndDateInfo(task);
            ArrayList<Command> commands = new ArrayList<Command>(2);
            commands.add(TaskInfoUtils.createChangeEndDateCommand(task, endDate));
            commands.add(TaskInfoUtils.createChangeDurationCommand(task, null));
            command = new CompoundCommand(TaskMessages.DeactivateDurationCommand_label, commands);
        }
        commandStack.execute((Command)command);
    }

    public static boolean hasTaskInfo(ITopic task) {
        if (task == null) {
            return false;
        }
        return TaskInfoUtils.getStartDateInfo(task) != null || TaskInfoUtils.getEndDateInfo(task) != null;
    }

    public static boolean hasCascadeTaskInfo(ITopic task) {
        if (task == null) {
            return false;
        }
        if (TaskInfoUtils.hasTaskInfo(task)) {
            return true;
        }
        List topics = task.getAllChildren();
        if (topics == null || topics.size() == 0) {
            return false;
        }
        for (ITopic topic : topics) {
            if (!TaskInfoUtils.hasCascadeTaskInfo(topic)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasCascadeTaskInfo2(ITopic task) {
        if (task == null) {
            return false;
        }
        List topics = task.getAllChildren();
        if (topics == null || topics.size() == 0) {
            return false;
        }
        for (ITopic topic : topics) {
            if (!TaskInfoUtils.hasCascadeTaskInfo(topic)) continue;
            return true;
        }
        return false;
    }

    public static Date getEarliestStartDate(ITopic topic) {
        if (topic == null) {
            return null;
        }
        Date earliestDate = TaskInfoUtils.toDateObj(TaskInfoUtils.calculateStartDateInfo(topic));
        List topics = topic.getAllChildren();
        if (topics != null && topics.size() != 0) {
            for (ITopic t : topics) {
                Date date = TaskInfoUtils.getEarliestStartDate(t);
                if (date == null || earliestDate != null && !date.before(earliestDate)) continue;
                earliestDate = date;
            }
        }
        return earliestDate;
    }

    public static Date getLatestEndDate(ITopic topic) {
        if (topic == null) {
            return null;
        }
        Date latestDate = TaskInfoUtils.toDateObj(TaskInfoUtils.calculateEndDateInfo(topic));
        List topics = topic.getAllChildren();
        if (topics != null && topics.size() != 0) {
            for (ITopic t : topics) {
                Date date = TaskInfoUtils.getLatestEndDate(t);
                if (date == null || latestDate != null && !date.after(latestDate)) continue;
                latestDate = date;
            }
        }
        return latestDate;
    }
}

