/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.exports.vector.svg;

import java.io.File;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.util.UUID;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.xmind.core.Core;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.util.Properties;
import org.xmind.ui.internal.exports.vector.svg.SVGExporter;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.IMindMapViewer;
import org.xmind.ui.util.Logger;
import org.xmind.ui.wizards.IExporter;

public class SVGGenerator {
    private IMindMap mindmap;
    private IMindMapViewer sourceViewer;
    private Display display;
    private Shell parentShell;
    private boolean renderAsPath;
    private boolean plusVisible;
    private boolean minusVisible;

    public SVGGenerator(IMindMap mindmap, IMindMapViewer sourceViewer, Display display, Shell parentShell, boolean renderAsPath, boolean plusVisible, boolean minusVisible) {
        this.mindmap = mindmap;
        this.sourceViewer = sourceViewer;
        this.display = display;
        this.parentShell = parentShell;
        this.renderAsPath = renderAsPath;
        this.plusVisible = plusVisible;
        this.minusVisible = minusVisible;
    }

    public File generate() {
        if (this.doGenerate()) {
            return new File(this.getTargetPath());
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private boolean doGenerate() {
        try {
            try {
                this.doGenerate(this.display, this.parentShell);
            }
            catch (OutOfMemoryError e) {
                try {
                    throw new Exception("Image is too large.", e);
                }
                catch (Exception e2) {
                    throw new InvocationTargetException(e2);
                }
            }
            return true;
        }
        catch (Throwable e) {
            if (!(e instanceof InterruptedException) && !(e instanceof InterruptedIOException)) ** GOTO lbl16
            return false;
        }
        while ((t = ((InvocationTargetException)e).getCause()) != null) {
            e = t;
lbl16:
            // 2 sources

            if (e instanceof InvocationTargetException) continue;
        }
        ex = e;
        this.display.asyncExec(new Runnable((Throwable)ex){
            private final /* synthetic */ Throwable val$ex;
            {
                this.val$ex = throwable;
            }

            public void run() {
                SVGGenerator.this.handleExportException(this.val$ex);
            }
        });
        return false;
    }

    private void doGenerate(Display display, Shell parentShell) throws InvocationTargetException, InterruptedException {
        IExporter exporter = this.createExporter();
        if (!exporter.canStart()) {
            throw new InterruptedException();
        }
        exporter.start(display, parentShell);
        exporter.end();
    }

    private IExporter createExporter() {
        SVGExporter exporter = new SVGExporter(this.mindmap.getSheet(), this.mindmap.getCentralTopic(), this.getTargetPath(), (IGraphicalViewer)this.sourceViewer, null){

            protected void initProperties(Properties properties) {
                properties.set("plusVisible", SVGGenerator.this.plusVisible);
                properties.set("minusVisible", SVGGenerator.this.minusVisible);
                properties.set("renderTextAsPath", SVGGenerator.this.renderAsPath);
            }
        };
        exporter.init();
        return exporter;
    }

    private String getTargetPath() {
        return Core.getWorkspace().getTempFile("svg/" + UUID.randomUUID().toString() + ".svg");
    }

    private void handleExportException(Throwable e) {
        Logger.log((Throwable)e, (String)NLS.bind((String)"Error occurred when generating {0} file.", (Object)"SVG"));
    }
}

