/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;
import org.xmind.gef.draw2d.IHasImage;
import org.xmind.gef.draw2d.ReferencedFigure;

public class SizeableImageFigure
extends ReferencedFigure
implements IHasImage {
    private static final Rectangle IMAGE_CLIENT_AREA = new Rectangle();
    private static final int FLAG_STRETCHED = MAX_FLAG << 1;
    private static final int FLAG_CONSTRAINED;
    private Image img = null;
    private Dimension imgSize = null;
    private int alpha = -1;
    private Insets margins;

    static {
        MAX_FLAG = FLAG_CONSTRAINED = MAX_FLAG << 2;
    }

    public SizeableImageFigure() {
        this(null);
    }

    public SizeableImageFigure(Image image) {
        this.setImage(image);
    }

    public void setImage(Image image) {
        if (this.img == image) {
            return;
        }
        this.img = image;
        this.imgSize = null;
        this.setMinimumSize(new Dimension(1, 1));
        this.revalidate();
        this.repaint();
    }

    public Dimension getImageSize() {
        if (this.imgSize == null) {
            this.imgSize = this.img != null ? new Dimension(this.img) : new Dimension();
        }
        return this.imgSize;
    }

    public boolean isConstrained() {
        return this.getFlag(FLAG_CONSTRAINED);
    }

    public void setConstrained(boolean constrained) {
        if (constrained == this.isConstrained()) {
            return;
        }
        this.setFlag(FLAG_CONSTRAINED, constrained);
        this.repaint();
    }

    public boolean isStretched() {
        return this.getFlag(FLAG_STRETCHED);
    }

    public void setStretched(boolean stretched) {
        if (stretched == this.isStretched()) {
            return;
        }
        this.setFlag(FLAG_STRETCHED, stretched);
        this.repaint();
    }

    public void setMargins(Insets margins) {
        this.margins = margins;
    }

    public Image getImage() {
        return this.img;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        if (this.alpha == alpha) {
            return;
        }
        this.alpha = alpha;
        this.repaint();
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension d;
        if (this.prefSize != null) {
            return this.prefSize;
        }
        if (this.getLayoutManager() != null && (d = this.getLayoutManager().getPreferredSize((IFigure)this, wHint, hHint)) != null) {
            return d;
        }
        return this.calculatePreferredImageSize(wHint, hHint);
    }

    protected Dimension calculatePreferredImageSize(int wHint, int hHint) {
        Dimension size = this.getImageSize();
        if (wHint < 0 && hHint < 0) {
            return size;
        }
        boolean constrained = this.isConstrained();
        boolean stretched = this.isStretched();
        if (constrained || stretched) {
            if (size.width == 0 || size.height == 0) {
                return new Dimension(Math.max(wHint, 0), Math.max(hHint, 0));
            }
            if (wHint == 0 || hHint == 0) {
                return new Dimension(0, 0);
            }
            if (wHint > 0 && hHint > 0) {
                if (constrained && (stretched || size.width > wHint || size.height > hHint)) {
                    int a = size.width * hHint;
                    int b = size.height * wHint;
                    if (stretched ? a < b : a > b) {
                        int h = wHint == 0 ? 0 : b / size.width;
                        return new Dimension(wHint, h);
                    }
                    if (stretched ? a > b : a < b) {
                        int w = hHint == 0 ? 0 : a / size.height;
                        return new Dimension(w, hHint);
                    }
                    return new Dimension(wHint, hHint);
                }
                return new Dimension(size.width, size.height);
            }
            if (wHint > 0) {
                return new Dimension(wHint, wHint * size.height / size.width);
            }
            return new Dimension(hHint * size.width / size.height, hHint);
        }
        return size;
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        Image image = this.getImage();
        if (image != null) {
            graphics.setAntialias(1);
            if (this.getAlpha() != -1) {
                graphics.setAlpha(this.getAlpha());
            }
            this.paintImage(graphics, image);
        }
    }

    protected void paintImage(Graphics graphics, Image image) {
        if (image != null) {
            Dimension imageSize = image == this.img ? this.getImageSize() : new Dimension(image);
            this.paintImage(graphics, image, imageSize, this.getImageClientArea(imageSize));
        }
    }

    protected Rectangle getImageClientArea(Dimension imageSize) {
        Rectangle area = this.getClientArea(IMAGE_CLIENT_AREA);
        boolean constrained = this.isConstrained();
        boolean stretched = this.isStretched();
        if (constrained && (stretched || imageSize.width > area.width || imageSize.height > area.height)) {
            this.adaptAreaToRatio(area, imageSize, stretched);
        } else if (!stretched) {
            this.adaptAreaToSize(area, imageSize);
        }
        if (this.margins != null) {
            return new Rectangle(area.x + this.margins.left, area.y + this.margins.top, Math.max(0, area.width - this.margins.getWidth()), Math.max(0, area.height - this.margins.getHeight()));
        }
        return area;
    }

    protected void adaptAreaToSize(Rectangle area, Dimension size) {
        area.x += (area.width - size.width) / 2;
        area.width = size.width;
        area.y += (area.height - size.height) / 2;
        area.height = size.height;
    }

    protected void adaptAreaToRatio(Rectangle area, Dimension ratio, boolean bigger) {
        int a = ratio.width * area.height;
        int b = ratio.height * area.width;
        if (bigger ? a < b : a > b) {
            int h = area.width == 0 ? 0 : b / ratio.width;
            area.y += (area.height - h) / 2;
            area.height = h;
        } else if (bigger ? a > b : a < b) {
            int w = area.height == 0 ? 0 : a / ratio.height;
            area.x += (area.width - w) / 2;
            area.width = w;
        }
    }

    protected void paintImage(Graphics graphics, Image image, Dimension imageSize, Rectangle clientArea) {
        try {
            if (clientArea.width == imageSize.width && clientArea.height == imageSize.height) {
                graphics.drawImage(image, clientArea.x, clientArea.y);
            } else {
                graphics.drawImage(image, 0, 0, imageSize.width, imageSize.height, clientArea.x, clientArea.y, clientArea.width, clientArea.height);
            }
        }
        catch (Exception exception) {}
    }
}

