/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.internal.SettingEntry;
import org.xmind.core.internal.dom.SheetImpl;
import org.xmind.core.util.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingEntryImpl
extends SettingEntry {
    private Element implementation;
    private SheetImpl ownedSheet;
    private String path;

    public SettingEntryImpl(Element implementation, String path, SheetImpl ownedSheet) {
        this.implementation = implementation;
        this.path = path;
        this.ownedSheet = ownedSheet;
    }

    protected Element getImplementation() {
        return this.implementation;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getAttribute(String key) {
        return DOMUtils.getAttribute(this.implementation, key);
    }

    @Override
    public void setAttribute(String key, String value) {
        ISheet sheet;
        String oldValue = DOMUtils.getAttribute(this.implementation, key);
        DOMUtils.setAttribute(this.implementation, key, value);
        String newValue = DOMUtils.getAttribute(this.implementation, key);
        if (!(oldValue == newValue || oldValue != null && oldValue.equals(newValue) || (sheet = this.getOwnedSheet()) == null)) {
            CoreEvent event = new CoreEvent((ICoreEventSource)this.ownedSheet, "sheetSettings", (Object)key, (Object)oldValue, newValue);
            event.setData(this.getPath());
            this.ownedSheet.getCoreEventSupport().dispatch(this.ownedSheet, event);
        }
    }

    @Override
    public Set<String> getAttributeKeys() {
        HashSet<String> keys = new HashSet<String>();
        NamedNodeMap atts = this.implementation.getAttributes();
        int i = 0;
        while (i < atts.getLength()) {
            keys.add(atts.item(i).getNodeName());
            ++i;
        }
        return keys;
    }

    @Override
    public ISheet getOwnedSheet() {
        return this.ownedSheet;
    }

    @Override
    public IWorkbook getOwnedWorkbook() {
        return this.getOwnedSheet().getOwnedWorkbook();
    }

    @Override
    public boolean isOrphan() {
        return DOMUtils.isOrphanNode(this.implementation);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(Element.class)) {
            return adapter.cast(this.getImplementation());
        }
        return super.getAdapter(adapter);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof SettingEntryImpl)) {
            return false;
        }
        SettingEntryImpl that = (SettingEntryImpl)obj;
        return that.implementation == this.implementation;
    }

    public int hashCode() {
        return this.implementation.hashCode();
    }

    public String toString() {
        return DOMUtils.toString(this.implementation);
    }
}

