/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.type;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakePsiSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtRealPsiSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.config.FirContextParametersLanguageVersionSettingsChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirContextParametersDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.type.FirTypeChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.utils.exceptions.FirExceptionUtilsKt;
import org.jetbrains.kotlin.psi.KtContextReceiverList;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi.stubs.elements.KtParameterElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.stubs.elements.KtTokenSets;
import org.jetbrains.kotlin.util.LightTreeUtilsKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u0013H\u0002R\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirContextualFunctionTypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeChecker;", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirResolvedTypeRefChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "typeRef", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;)V", "valueParameterElementSet", "", "Lorg/jetbrains/kotlin/psi/stubs/elements/KtParameterElementType;", "kotlin.jvm.PlatformType", "findContextReceiverListSource", "Lorg/jetbrains/kotlin/KtSourceElement;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirContextualFunctionTypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirContextualFunctionTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/type/FirContextualFunctionTypeChecker\n+ 2 ExceptionAttachmentBuilder.kt\norg/jetbrains/kotlin/utils/exceptions/ExceptionAttachmentBuilderKt\n+ 3 FirSourceUtils.kt\norg/jetbrains/kotlin/fir/analysis/FirSourceUtilsKt\n+ 4 KtSourceElement.kt\norg/jetbrains/kotlin/KtSourceElementKt\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n81#2,7:96\n76#2,2:103\n57#2:105\n78#2:106\n42#3,8:107\n67#3:115\n102#3,6:116\n69#3:122\n108#3:123\n50#3:124\n51#3:130\n111#3,5:131\n70#3:136\n116#3,2:139\n119#3:142\n73#3:143\n52#3,2:144\n85#3:146\n102#3,6:147\n87#3:153\n108#3:154\n54#3:162\n111#3,5:163\n88#3:168\n116#3,4:169\n91#3:173\n56#3:174\n884#4,5:125\n890#4,7:155\n884#4,5:175\n890#4,7:180\n234#5:137\n1869#6:138\n1870#6:141\n*S KotlinDebug\n*F\n+ 1 FirContextualFunctionTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/type/FirContextualFunctionTypeChecker\n*L\n42#1:96,7\n42#1:103,2\n42#1:105\n42#1:106\n46#1:107,8\n46#1:115\n46#1:116,6\n46#1:122\n46#1:123\n46#1:124\n46#1:130\n46#1:131,5\n46#1:136\n46#1:139,2\n46#1:142\n46#1:143\n46#1:144,2\n46#1:146\n46#1:147,6\n46#1:153\n46#1:154\n46#1:162\n46#1:163,5\n46#1:168\n46#1:169,4\n46#1:173\n46#1:174\n46#1:125,5\n46#1:155,7\n71#1:175,5\n83#1:180,7\n46#1:137\n46#1:138\n46#1:141\n*E\n"})
public final class FirContextualFunctionTypeChecker
extends FirTypeChecker<FirResolvedTypeRef> {
    @NotNull
    public static final FirContextualFunctionTypeChecker INSTANCE = new FirContextualFunctionTypeChecker();
    @NotNull
    private static final Set<KtParameterElementType> valueParameterElementSet = SetsKt.setOf((Object)KtStubElementTypes.VALUE_PARAMETER);

    private FirContextualFunctionTypeChecker() {
        super(MppCheckerKind.Platform);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirResolvedTypeRef typeRef) {
        void types$iv;
        void $this$forEachChildOfType_u24default$iv;
        KtSourceElement source;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        KtSourceElement ktSourceElement = typeRef.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        if (!CompilerConeAttributesKt.getHasContextParameters(AbbreviatedTypeAttributeKt.getAbbreviatedTypeOrSelf(typeRef.getConeType()))) {
            return;
        }
        KtSourceElement ktSourceElement2 = typeRef.getSource();
        if (ktSourceElement2 == null || (ktSourceElement2 = this.findContextReceiverListSource(ktSourceElement2)) == null) {
            void $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder;
            String message$iv = "Source for type ref of contextual function type doesn't contain context list.";
            Throwable cause$iv = null;
            String attachmentName$iv = "info.txt";
            boolean $i$f$errorWithAttachment = false;
            boolean $i$f$buildErrorWithAttachment = false;
            KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments(message$iv, cause$iv);
            KotlinExceptionWithAttachments $this$buildAttachment$iv$iv$iv = exception$iv$iv;
            boolean $i$f$buildAttachment = false;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
            String string = attachmentName$iv;
            KotlinExceptionWithAttachments kotlinExceptionWithAttachments = $this$buildAttachment$iv$iv$iv;
            boolean bl = false;
            void $this$check_u24lambda_u240 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
            boolean bl2 = false;
            FirExceptionUtilsKt.withFirEntry((ExceptionAttachmentBuilder)$this$check_u24lambda_u240, "fir", typeRef);
            kotlinExceptionWithAttachments.withAttachment(string, exceptionAttachmentBuilder.buildString());
            throw (Throwable)exception$iv$iv;
        }
        KtSourceElement ktSourceElement3 = source = ktSourceElement2;
        Set<KtParameterElementType> set = valueParameterElementSet;
        int depth$iv = 1;
        boolean reverse$iv = false;
        boolean $i$f$forEachChildOfType = false;
        void var10_11 = $this$forEachChildOfType_u24default$iv;
        if (var10_11 instanceof KtPsiSourceElement) {
            PsiElement $this$forEachChildOfType$iv$iv = ((KtPsiSourceElement)$this$forEachChildOfType_u24default$iv).getPsi();
            boolean $i$f$forEachChildOfType2 = false;
            boolean $i$f$forEachChildOfType3 = false;
            Pair[] $i$f$buildAttachment = new Pair[]{TuplesKt.to((Object)$this$forEachChildOfType$iv$iv, (Object)0)};
            List stack$iv$iv$iv = CollectionsKt.mutableListOf((Object[])$i$f$buildAttachment);
            while (!((Collection)stack$iv$iv$iv).isEmpty()) {
                void $this$forEach$iv$iv$iv$iv;
                Iterable $this$butIf$iv$iv$iv$iv;
                PsiElement it$iv$iv;
                $i$f$buildAttachment = (Pair[])AddToStdlibKt.popLast(stack$iv$iv$iv);
                Object element$iv$iv$iv = $i$f$buildAttachment.component1();
                int currentDepth$iv$iv$iv = ((Number)$i$f$buildAttachment.component2()).intValue();
                if (currentDepth$iv$iv$iv != 0) {
                    PsiElement psiElement = (PsiElement)element$iv$iv$iv;
                    void bl = types$iv;
                    boolean bl3 = false;
                    IElementType iElementType = it$iv$iv.getNode().getElementType();
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
                    if (bl.contains(iElementType)) {
                        KtPsiSourceElement ktPsiSourceElement;
                        PsiElement it$iv = (PsiElement)element$iv$iv$iv;
                        boolean bl4 = false;
                        PsiElement $this$toKtPsiSourceElement_u24default$iv$iv = it$iv;
                        KtSourceElementKind kind$iv$iv = KtRealSourceElementKind.INSTANCE;
                        boolean $i$f$toKtPsiSourceElement = false;
                        KtSourceElementKind ktSourceElementKind = kind$iv$iv;
                        if (ktSourceElementKind instanceof KtRealSourceElementKind) {
                            ktPsiSourceElement = new KtRealPsiSourceElement($this$toKtPsiSourceElement_u24default$iv$iv);
                        } else if (ktSourceElementKind instanceof KtFakeSourceElementKind) {
                            ktPsiSourceElement = new KtFakePsiSourceElement($this$toKtPsiSourceElement_u24default$iv$iv, (KtFakeSourceElementKind)kind$iv$iv);
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        KtSourceElement it = ktPsiSourceElement;
                        boolean bl5 = false;
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getNAMED_CONTEXT_PARAMETER_IN_FUNCTION_TYPE(), null, 8, null);
                    }
                }
                if (currentDepth$iv$iv$iv == depth$iv) continue;
                it$iv$iv = (PsiElement)element$iv$iv$iv;
                boolean bl = false;
                List list = SequencesKt.toList((Sequence)PsiUtilsKt.getAllChildren(it$iv$iv));
                boolean condition$iv$iv$iv$iv = true;
                boolean $i$f$butIf22 = false;
                void it$iv$iv$iv = $this$butIf$iv$iv$iv$iv;
                boolean bl6 = false;
                $this$butIf$iv$iv$iv$iv = CollectionsKt.asReversed((List)it$iv$iv$iv);
                boolean $i$f$forEach = false;
                Iterator $i$f$butIf22 = $this$forEach$iv$iv$iv$iv.iterator();
                while ($i$f$butIf22.hasNext()) {
                    Object element$iv$iv$iv$iv;
                    Object child$iv$iv$iv = element$iv$iv$iv$iv = $i$f$butIf22.next();
                    boolean bl7 = false;
                    ((Collection)stack$iv$iv$iv).add(TuplesKt.to(child$iv$iv$iv, (Object)(currentDepth$iv$iv$iv + 1)));
                }
            }
        } else if (var10_11 instanceof KtLightSourceElement) {
            LighterASTNode $this$forEachChildOfType$iv$iv = ((KtLightSourceElement)$this$forEachChildOfType_u24default$iv).getLighterASTNode();
            FlyweightCapableTreeStructure<LighterASTNode> treeStructure$iv$iv = ((KtLightSourceElement)$this$forEachChildOfType_u24default$iv).getTreeStructure();
            boolean $i$f$forEachChildOfType4 = false;
            boolean $i$f$forEachChildOfType5 = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)$this$forEachChildOfType$iv$iv, (Object)0)};
            List stack$iv$iv$iv = CollectionsKt.mutableListOf((Object[])pairArray);
            while (!((Collection)stack$iv$iv$iv).isEmpty()) {
                void $this$forEach$iv$iv$iv$iv;
                Iterable $this$butIf$iv$iv$iv$iv;
                LighterASTNode it$iv$iv;
                pairArray = (Pair[])AddToStdlibKt.popLast(stack$iv$iv$iv);
                Object element$iv$iv$iv = pairArray.component1();
                int currentDepth$iv$iv$iv = ((Number)pairArray.component2()).intValue();
                if (currentDepth$iv$iv$iv != 0) {
                    LighterASTNode bl = (LighterASTNode)element$iv$iv$iv;
                    void var20_41 = types$iv;
                    boolean bl8 = false;
                    IElementType iElementType = it$iv$iv.getTokenType();
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getTokenType(...)");
                    if (var20_41.contains(iElementType)) {
                        void $this$toKtLightSourceElement_u24default$iv$iv;
                        LighterASTNode it$iv = (LighterASTNode)element$iv$iv$iv;
                        boolean bl9 = false;
                        LighterASTNode kind$iv$iv = it$iv;
                        FlyweightCapableTreeStructure<LighterASTNode> tree$iv$iv = ((KtLightSourceElement)$this$forEachChildOfType_u24default$iv).getTreeStructure();
                        KtSourceElementKind kind$iv$iv2 = KtRealSourceElementKind.INSTANCE;
                        int startOffset$iv$iv = $this$toKtLightSourceElement_u24default$iv$iv.getStartOffset();
                        int endOffset$iv$iv = $this$toKtLightSourceElement_u24default$iv$iv.getEndOffset();
                        boolean $i$f$toKtLightSourceElement = false;
                        KtSourceElement it = new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv$iv, startOffset$iv$iv, endOffset$iv$iv, tree$iv$iv, kind$iv$iv2);
                        boolean bl10 = false;
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getNAMED_CONTEXT_PARAMETER_IN_FUNCTION_TYPE(), null, 8, null);
                    }
                }
                if (currentDepth$iv$iv$iv == depth$iv) continue;
                it$iv$iv = (LighterASTNode)element$iv$iv$iv;
                boolean bl = false;
                List<LighterASTNode> element$iv$iv$iv$iv = LightTreeUtilsKt.getChildren(it$iv$iv, treeStructure$iv$iv);
                boolean condition$iv$iv$iv$iv = true;
                boolean $i$f$butIf = false;
                void it$iv$iv$iv = $this$butIf$iv$iv$iv$iv;
                boolean bl11 = false;
                $this$butIf$iv$iv$iv$iv = CollectionsKt.asReversed((List)it$iv$iv$iv);
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv$iv$iv$iv2;
                    Object child$iv$iv$iv = element$iv$iv$iv$iv2 = iterator2.next();
                    boolean bl12 = false;
                    ((Collection)stack$iv$iv$iv).add(TuplesKt.to(child$iv$iv$iv, (Object)(currentDepth$iv$iv$iv + 1)));
                }
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ContextReceivers)) {
            if (FirContextParametersDeclarationChecker.INSTANCE.checkSubTypes(FunctionalTypeUtilsKt.contextParameterTypes(typeRef.getConeType(), context2.getSession()), context2)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getSUBTYPING_BETWEEN_CONTEXT_RECEIVERS(), null, 8, null);
            }
            String message2 = FirContextParametersLanguageVersionSettingsChecker.INSTANCE.getMessage(context2.getLanguageVersionSettings());
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)typeRef.getSource(), FirErrors.INSTANCE.getCONTEXT_RECEIVERS_DEPRECATED(), (Object)message2, null, 16, null);
        } else {
            FirHelpersKt.requireFeatureSupport$default(source, LanguageFeature.ContextParameters, context2, reporter, null, 8, null);
        }
    }

    private final KtSourceElement findContextReceiverListSource(KtSourceElement $this$findContextReceiverListSource) {
        KtSourceElement ktSourceElement;
        KtSourceElement ktSourceElement2 = $this$findContextReceiverListSource;
        if (ktSourceElement2 instanceof KtPsiSourceElement) {
            ktSourceElement = FirContextualFunctionTypeChecker.findContextReceiverListSource$findContextReceiverListSource(((KtPsiSourceElement)$this$findContextReceiverListSource).getPsi());
        } else if (ktSourceElement2 instanceof KtLightSourceElement) {
            ktSourceElement = FirContextualFunctionTypeChecker.findContextReceiverListSource$findContextReceiverListSource$2(((KtLightSourceElement)$this$findContextReceiverListSource).getLighterASTNode(), ((KtLightSourceElement)$this$findContextReceiverListSource).getTreeStructure());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return ktSourceElement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final KtPsiSourceElement findContextReceiverListSource$findContextReceiverListSource(PsiElement $this$findContextReceiverListSource_u24findContextReceiverListSource) {
        KtPsiSourceElement ktPsiSourceElement;
        PsiElement psiElement = $this$findContextReceiverListSource_u24findContextReceiverListSource;
        if (psiElement instanceof KtTypeReference) {
            KtTypeElement ktTypeElement = ((KtTypeReference)$this$findContextReceiverListSource_u24findContextReceiverListSource).getTypeElement();
            if (ktTypeElement == null) return null;
            ktPsiSourceElement = FirContextualFunctionTypeChecker.findContextReceiverListSource$findContextReceiverListSource(ktTypeElement);
            return ktPsiSourceElement;
        } else if (psiElement instanceof KtNullableType) {
            KtTypeElement ktTypeElement = ((KtNullableType)$this$findContextReceiverListSource_u24findContextReceiverListSource).getInnerType();
            if (ktTypeElement == null) return null;
            ktPsiSourceElement = FirContextualFunctionTypeChecker.findContextReceiverListSource$findContextReceiverListSource(ktTypeElement);
            return ktPsiSourceElement;
        } else {
            if (!(psiElement instanceof KtFunctionType)) return null;
            KtContextReceiverList ktContextReceiverList = ((KtFunctionType)$this$findContextReceiverListSource_u24findContextReceiverListSource).getContextReceiverList();
            if (ktContextReceiverList == null) return null;
            PsiElement $this$toKtPsiSourceElement_u24default$iv = ktContextReceiverList;
            KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
            boolean $i$f$toKtPsiSourceElement = false;
            KtSourceElementKind ktSourceElementKind = kind$iv;
            if (ktSourceElementKind instanceof KtRealSourceElementKind) {
                ktPsiSourceElement = new KtRealPsiSourceElement($this$toKtPsiSourceElement_u24default$iv);
                return ktPsiSourceElement;
            } else {
                if (!(ktSourceElementKind instanceof KtFakeSourceElementKind)) throw new NoWhenBranchMatchedException();
                ktPsiSourceElement = new KtFakePsiSourceElement($this$toKtPsiSourceElement_u24default$iv, (KtFakeSourceElementKind)kind$iv);
            }
        }
        return ktPsiSourceElement;
    }

    /*
     * WARNING - void declaration
     */
    private static final KtLightSourceElement findContextReceiverListSource$findContextReceiverListSource$2(LighterASTNode $this$findContextReceiverListSource_u24findContextReceiverListSource_u242, FlyweightCapableTreeStructure<LighterASTNode> tree) {
        KtLightSourceElement ktLightSourceElement;
        IElementType iElementType = $this$findContextReceiverListSource_u24findContextReceiverListSource_u242.getTokenType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.TYPE_REFERENCE) || Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.NULLABLE_TYPE)) {
            TokenSet tokenSet = KtTokenSets.TYPE_ELEMENT_TYPES;
            Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"TYPE_ELEMENT_TYPES");
            LighterASTNode lighterASTNode = LightTreePositioningStrategiesKt.findChildByType(tree, $this$findContextReceiverListSource_u24findContextReceiverListSource_u242, tokenSet);
            ktLightSourceElement = lighterASTNode != null ? FirContextualFunctionTypeChecker.findContextReceiverListSource$findContextReceiverListSource$2(lighterASTNode, tree) : null;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.FUNCTION_TYPE)) {
            IElementType iElementType2 = KtNodeTypes.CONTEXT_RECEIVER_LIST;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"CONTEXT_RECEIVER_LIST");
            LighterASTNode lighterASTNode = LightTreePositioningStrategiesKt.findChildByType(tree, $this$findContextReceiverListSource_u24findContextReceiverListSource_u242, iElementType2);
            if (lighterASTNode != null) {
                void $this$toKtLightSourceElement_u24default$iv;
                LighterASTNode lighterASTNode2 = lighterASTNode;
                KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
                int startOffset$iv = $this$toKtLightSourceElement_u24default$iv.getStartOffset();
                int endOffset$iv = $this$toKtLightSourceElement_u24default$iv.getEndOffset();
                boolean $i$f$toKtLightSourceElement = false;
                ktLightSourceElement = new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv, startOffset$iv, endOffset$iv, tree, kind$iv);
            } else {
                ktLightSourceElement = null;
            }
        } else {
            ktLightSourceElement = null;
        }
        return ktLightSourceElement;
    }
}

